/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.VdcBase;
import com.cisco.dcbu.sm.common.type.IpKey;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthNodeIf;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.ServiceUtil;
import com.cisco.dcbu.sm.server.model.VdcImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.log4j.Level;

public class CdpNode
implements EthNodeIf,
Serializable,
Comparable<EthNodeIf>,
Comparator<EthNodeIf> {
    TraceLogger _Tracer = DCManager._Tracer;
    private final IpKey _nodePK;
    private CdpSeedImpl _seed = null;
    private SerialNumKey _chassisKey = null;
    private int[] _sysObjectID;
    private String _sysDescr;
    private long _sysUpTime;
    private String _sysContact;
    private String _sysName;
    private String _sysLocation;
    private boolean _cdpEnabled;
    private String _globalDeviceId;
    private long _lastCdpChangeTime;
    private String _phyModelName;
    private String _vendorId;
    private int _type;
    private String _version;
    private String _deviceId;
    private String _platform;
    private PlatformType _platformType;
    private byte[] _vtpMgmtDomain;
    private int _currHop = 0;
    private boolean _isVdc;
    private VdcPK _vdcKey;
    private MacAddress _parentVdcMac;
    private short _fcoeVdcCapable;
    private boolean[] _featureFlags = new boolean[AbstractSwitchBase.NUM_FEATURES];
    private int _fcoeFeatureSetStatus;
    private int _fexFeatureSetStatus;
    private long _lastScanTime = 0L;
    private HashSet<Integer> _linkPorts = new HashSet(5);
    private transient SnmpPeer _peer = null;
    private transient int _discFlags = 0;
    private transient boolean _reachable = true;
    private transient String _unReachableCause = null;
    private transient boolean _continueProbe = false;

    public CdpNode(SnmpPeer peer) {
        this._peer = peer;
        this._nodePK = new IpKey(peer.getAddress());
    }

    public CdpNode(CdpSeedImpl seed, InetAddress addr, int currHop) {
        this._nodePK = new IpKey(addr);
        this._seed = seed;
        this._currHop = currHop;
    }

    public CdpNode(InetAddress addr, int currHop, String deviceId, String platform, String version, Bits capability, byte[] vtpMgmtDomain) {
        this._nodePK = new IpKey(addr);
        this._currHop = currHop;
        this._platform = platform;
        if (platform != null) {
            this._phyModelName = GenUtil.trimCisco(platform);
        }
        this._platformType = PlatformType.getTypeByDeviceKey(this._platform);
        this._version = version;
        this._vtpMgmtDomain = vtpMgmtDomain;
        if (deviceId != null) {
            this.setDeviceId(deviceId);
        }
    }

    public CdpNode(EthSwitchImpl sw) {
        this.setVdc(sw.isVdc());
        if (sw.isVdc()) {
            VdcImpl vdc = (VdcImpl)sw;
            VdcBase base = vdc.getBase();
            this._nodePK = new IpKey(base.getInetAddress());
            this._chassisKey = base.getChassisKey();
            this._vdcKey = base.getVdcPK();
            this._currHop = -1;
            this._platform = base.getPlatformName();
            this._platformType = base.getPlatformType();
            this._version = base.getVersion();
            this._vtpMgmtDomain = base.getVtpMgmtDomain();
            this.setDeviceId(base.getDeviceId());
        } else {
            EthSwitchBase base = sw.getBase();
            this._nodePK = new IpKey(base.getInetAddress());
            this._chassisKey = base.getChassisKey();
            this._vdcKey = null;
            this._currHop = -1;
            this._platform = base.getPlatformName();
            this._platformType = base.getPlatformType();
            this._version = base.getVersion();
            this._vtpMgmtDomain = base.getVtpMgmtDomain();
            this.setDeviceId(base.getDeviceId());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CdpNode)) {
            return false;
        }
        CdpNode that = (CdpNode)obj;
        if (this == that) {
            return true;
        }
        int ret = this._nodePK.compare(this._nodePK, that._nodePK);
        if (ret != 0) {
            return false;
        }
        if (this._deviceId == null) {
            return that._deviceId == null;
        }
        return this._deviceId.equals(that._deviceId);
    }

    public int hashCode() {
        if (this._nodePK != null && this._deviceId != null) {
            return this._nodePK.hashCode() ^ this._deviceId.hashCode();
        }
        if (this._nodePK != null) {
            return this._nodePK.hashCode();
        }
        if (this._deviceId != null) {
            return this._deviceId.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compare(EthNodeIf o1, EthNodeIf o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int ret = IpUtil.compare(o1.getInetAddress(), o2.getInetAddress());
        if (ret != 0) {
            return ret;
        }
        if (o1.getDeviceId() != null) {
            return o1.getDeviceId().compareTo(o2.getDeviceId());
        }
        if (o2.getDeviceId() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(EthNodeIf o) {
        return this.compare(this, o);
    }

    @Override
    public IpKey getPK() {
        return this._nodePK;
    }

    @Override
    public IpKey getNodeKey() {
        return this._nodePK;
    }

    @Override
    public PKIf getSwitchPK() {
        if (this._platformType != null && this._platformType == PlatformType.N7K && this.isVdc()) {
            return this._vdcKey;
        }
        if (this._platformType != null && this._platformType == PlatformType.N7K && this.isVersionLessThan("5.2(0)")) {
            if (IpUtil.isValidMgmtAddress(this._nodePK._addr)) {
                return new SerialNumKey(this._nodePK._addr.getHostName());
            }
            return new SerialNumKey(this._nodePK._addr.getHostAddress());
        }
        if (this._chassisKey != null) {
            return this._chassisKey;
        }
        if (this._deviceId != null && !this._deviceId.equalsIgnoreCase("switch")) {
            String snStr = GenUtil.getCiscoSerialNumber(this._deviceId);
            if (snStr != null) {
                this.setChassisKey(new SerialNumKey(snStr));
                return this._chassisKey;
            }
            return new SerialNumKey(this._deviceId);
        }
        if (IpUtil.isValidMgmtAddress(this._nodePK._addr)) {
            return new SerialNumKey(this._nodePK._addr.getHostName());
        }
        return new SerialNumKey(this._nodePK._addr.getHostAddress());
    }

    public CdpSeedImpl getSeed() {
        return this._seed;
    }

    public void setSeed(CdpSeedImpl seed) {
        this._seed = seed;
    }

    public int getCurrentHop() {
        return this._currHop;
    }

    public void addLinkPort(int ifindex) {
        this._linkPorts.add(ifindex);
    }

    public HashSet<Integer> getLinkPorts() {
        return this._linkPorts;
    }

    public void setSerialNum(String serialNum) {
        if (serialNum == null) {
            return;
        }
        if (this._chassisKey == null || this._chassisKey._serialNum.indexOf(".") >= 0) {
            this.setChassisKey(new SerialNumKey(serialNum));
        }
    }

    public String getSysContact() {
        return this._sysContact;
    }

    @Override
    public void setSysContact(String contact) {
        this._sysContact = contact;
    }

    public String getSysLocation() {
        return this._sysLocation;
    }

    @Override
    public void setSysLocation(String location) {
        this._sysLocation = location;
    }

    public String getSysName() {
        return this._sysName;
    }

    @Override
    public void setSysName(String name) {
        this._sysName = name;
    }

    public String getSysDescr() {
        return this._sysDescr;
    }

    @Override
    public void setSysDescr(String descr) {
        this._sysDescr = descr;
    }

    public int[] getSysObjectID() {
        return this._sysObjectID;
    }

    @Override
    public void setSysObjectID(int[] objectID) {
        this._sysObjectID = objectID;
        if (objectID != null && objectID.length > 0) {
            this.setModelType(objectID[objectID.length - 1]);
        }
    }

    public long getSysUpTime() {
        return this._sysUpTime;
    }

    @Override
    public void setSysUpTime(long upTime) {
        this._sysUpTime = upTime;
    }

    @Override
    public String getIpAddress() {
        if (this._nodePK != null) {
            return this._nodePK._addr.getHostAddress();
        }
        return "null";
    }

    @Override
    public InetAddress getInetAddress() {
        return this._nodePK._addr;
    }

    @Override
    public boolean isCdpEnabled() {
        return this._cdpEnabled;
    }

    @Override
    public void setCdpEnabled(boolean enabled) {
        this._cdpEnabled = enabled;
    }

    @Override
    public String getDeviceId() {
        return this._deviceId;
    }

    @Override
    public void setDeviceId(String id) {
        if (id == null) {
            return;
        }
        if (this._deviceId == null || !this._deviceId.equals(id)) {
            String sysName;
            this._deviceId = id;
            String snStr = GenUtil.getCiscoSerialNumber(this._deviceId);
            if (!(snStr == null || snStr.equalsIgnoreCase("switch") || this._chassisKey != null && this._chassisKey.isRealSN())) {
                this.setChassisKey(new SerialNumKey(snStr));
            }
            if (this._sysName == null && (sysName = GenUtil.getSysName(this._deviceId)) != null) {
                this.setSysName(sysName);
            }
        }
    }

    public String getGlobalDeviceId() {
        return this._globalDeviceId;
    }

    @Override
    public void setGlobalDeviceId(String deviceId) {
        this._globalDeviceId = deviceId;
    }

    @Override
    public long getLastScanTime() {
        return this._lastScanTime;
    }

    public void setLastScanTime(long scanTime) {
        this._lastScanTime = scanTime;
    }

    @Override
    public String getModelName() {
        return this._phyModelName;
    }

    @Override
    public void setModelName(String modelName) {
        this._phyModelName = modelName;
    }

    public int getModelType() {
        return this._type;
    }

    @Override
    public void setModelType(int type) {
        this._type = type;
    }

    public void setChassisKey(SerialNumKey snKey) {
        if (snKey == null) {
            return;
        }
        this._chassisKey = snKey;
    }

    @Override
    public SerialNumKey getChassisKey() {
        return this._chassisKey;
    }

    @Override
    public SerialNumKey setSerialNumber(String serialNum) {
        if (serialNum == null) {
            return null;
        }
        if (this._chassisKey == null) {
            this.setChassisKey(new SerialNumKey(serialNum));
            return null;
        }
        if (serialNum.indexOf(".") < 0 && !this._chassisKey._serialNum.equals(serialNum)) {
            SerialNumKey oldChassisKey = this._chassisKey;
            this.setChassisKey(new SerialNumKey(serialNum));
            return oldChassisKey;
        }
        return null;
    }

    @Override
    public PlatformType getPlatformType() {
        return this._platformType;
    }

    public String getPlatform() {
        return this._platform;
    }

    @Override
    public void setPlatform(String platform) {
        this._platform = platform;
        this._platformType = PlatformType.getTypeByDeviceKey(this._platform);
    }

    public void setPlatform(PlatformType type) {
        this._platform = type.getDeviceKey();
        this._platformType = type;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(String _version) {
        this._version = _version;
    }

    public byte[] getVtpMgmtDomain() {
        return this._vtpMgmtDomain;
    }

    @Override
    public void setVtpMgmtDomain(byte[] mgmtDomain) {
        this._vtpMgmtDomain = mgmtDomain;
    }

    public String getVendor() {
        return this._vendorId;
    }

    @Override
    public void setVendor(String id) {
        this._vendorId = id;
    }

    @Override
    public boolean isReachable() {
        return this._reachable;
    }

    @Override
    public void setReachable(boolean reachable) {
        this._reachable = reachable;
    }

    public String getUnReachableCause() {
        return this._unReachableCause;
    }

    public void setUnReachableCause(String cause) {
        this._unReachableCause = cause;
    }

    public boolean continueProbe() {
        return this._continueProbe;
    }

    public void setContinueProble(boolean continueProbe) {
        this._continueProbe = continueProbe;
    }

    @Override
    public void setVdc(boolean isVdc) {
        this._isVdc = isVdc;
    }

    @Override
    public boolean isVdc() {
        return this._isVdc;
    }

    public void setVdcKey(VdcPK vdcKey) {
        this._vdcKey = vdcKey;
    }

    public VdcPK getVdcKey() {
        return this._vdcKey;
    }

    public void setParentVdcMac(MacAddress macAddr) {
        this._parentVdcMac = macAddr;
    }

    public MacAddress getParentMac() {
        return this._parentVdcMac;
    }

    @Override
    public void setVdcFCoECapability(short capable) {
        this._fcoeVdcCapable = capable;
    }

    public short getFcoeCapability() {
        return this._fcoeVdcCapable;
    }

    @Override
    public boolean isFCoEEnabled() {
        if (this._featureFlags != null && this._featureFlags.length == AbstractSwitchBase.NUM_FEATURES) {
            return this._featureFlags[AbstractSwitchBase.Feature.FCOE.flag()];
        }
        return false;
    }

    @Override
    public void setFCoEEnabled(boolean enabled) {
        this.setFeatureFlag(AbstractSwitchBase.Feature.FCOE.flag(), enabled);
    }

    public boolean[] getFeatureFlags() {
        return this._featureFlags;
    }

    @Override
    public void setFeatureFlags(boolean[] flags) {
        if (flags != null && flags.length == AbstractSwitchBase.NUM_FEATURES) {
            System.arraycopy(flags, 0, this._featureFlags, 0, AbstractSwitchBase.NUM_FEATURES);
        }
    }

    public void setFeatureFlag(int flag, boolean enabled) {
        if (flag >= 0 && flag < AbstractSwitchBase.NUM_FEATURES) {
            this._featureFlags[flag] = enabled;
        }
    }

    @Override
    public boolean isFCoECapableVersion() {
        if (this._platformType != PlatformType.UNKNOWN) {
            return FRUConstants.isFCoECapableVersion(this._platformType, this._version);
        }
        if (this._type != -1) {
            return FRUConstants.isFCoECapableVersion(this._type, this._version);
        }
        return false;
    }

    @Override
    public void setFCoEFeatureSetStatus(int status) {
        this._fcoeFeatureSetStatus = status;
    }

    public int getFCoEFeatureSetStatus() {
        return this._fcoeFeatureSetStatus;
    }

    @Override
    public boolean isFexEnabled() {
        if (this._featureFlags != null && this._featureFlags.length == AbstractSwitchBase.NUM_FEATURES) {
            return this._featureFlags[AbstractSwitchBase.Feature.FEX.flag()];
        }
        return false;
    }

    @Override
    public void setFexEnabled(boolean enabled) {
        this.setFeatureFlag(AbstractSwitchBase.Feature.FEX.flag(), enabled);
    }

    @Override
    public boolean isFexCapableVersion() {
        if (this._platformType != PlatformType.UNKNOWN) {
            return FRUConstants.isFexCapableVersion(this._platformType, this._version);
        }
        if (this._type != -1) {
            return FRUConstants.isFexCapableVersion(this._type, this._version);
        }
        return false;
    }

    @Override
    public void setFexFeatureSetStatus(int status) {
        this._fexFeatureSetStatus = status;
    }

    public int getFexFeatureSetStatus() {
        return this._fexFeatureSetStatus;
    }

    @Override
    public void setDiscFlag(int type) {
        this._discFlags |= type;
    }

    @Override
    public void resetDiscFlag(int type) {
        this._discFlags &= ~type;
    }

    @Override
    public boolean isDiscFlagSet(int type) {
        return (this._discFlags & type) != 0;
    }

    @Override
    public void setDiscFlags(int types) {
        this._discFlags = types;
    }

    public boolean hasDiscFlags() {
        return this._discFlags > 0;
    }

    @Override
    public String getDiscFlagsInString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DISC_FLAGS.length; ++i) {
            if (!this.isDiscFlagSet(1 << i)) continue;
            sb.append(DISC_FLAGS[i]).append("|");
        }
        return sb.toString();
    }

    public void handlePeerOutage(String outageMsg) {
        this.resetPeer();
    }

    @Override
    public SnmpPeer getPeer() {
        if (this._peer == null) {
            try {
                this.createAndSetPeer();
            }
            catch (Exception ex) {
                if (this._peer == null && ex instanceof SnmpException) {
                    this.setReachable(false);
                    this.setUnReachableCause(ex.getMessage());
                }
                this._Tracer.log(Level.WARN, this + " getPeer() failed", ex);
            }
        }
        return this._peer;
    }

    @Override
    public boolean hasPeer() {
        return this._peer != null;
    }

    private synchronized void createAndSetPeer() throws SnmpException {
        SnmpPeer oldPeer = this._peer;
        SnmpPeer peer = this.createPeer();
        if (peer != null) {
            this._peer = peer;
            if (oldPeer != null) {
                SnmpPeer.removeServerPeer(oldPeer, true);
            }
            SnmpPeer.addServerPeer(this._peer);
        }
    }

    public void resetPeer() {
        if (this._peer != null) {
            SnmpPeer.removePeer(this._peer);
            SnmpPeer.removeServerPeer(this._peer, true);
            this._peer = null;
        }
    }

    private SnmpPeer createPeer() throws SnmpException {
        SnmpPeer peer = null;
        try {
            peer = ServiceUtil.createSnmpPeer(this._nodePK._addr, this._seed.getBase().getCredential(), DCManager.getInstance().getSnmpSession(), SnmpSession._PreferTcp);
            peer.setTimeout(this._seed.getBase().getPeerTimeout());
            peer.setRetries(this._seed.getBase().getPeerRetries());
        }
        catch (SnmpException se) {
            peer = null;
            this._Tracer.log(Level.DEBUG, this + " cannot creat peer from " + this._nodePK._addr + " cred=" + this._seed.getBase().getCredential(), se);
            throw se;
        }
        return peer;
    }

    public String toString() {
        return this.getPrintString(false, true);
    }

    @Override
    public String getPrintString(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        if (withDecor) {
            sb.append("CdpNode").append("@").append(this._nodePK);
        } else {
            sb.append(this._nodePK);
        }
        if (inDetail) {
            sb.append("[").append(", deviceId=").append(this._deviceId).append(", currHop=").append(this._currHop).append(", platformType=").append((Object)this._platformType).append(", globalDeviceId=").append(this._globalDeviceId).append(", currHop=").append(this._currHop).append(", cdpEnabled=").append(this._cdpEnabled).append(", phyModelName=").append(this._phyModelName).append(", platforme=").append(this._platform).append(", chassisKey=").append(this._chassisKey).append(", isVdc=").append(this._isVdc).append(", vdcKey=").append(this._vdcKey).append(", swKey=").append(this.getSwitchPK()).append(", fcoeEnabled=").append(this._fcoeVdcCapable).append(", discFlag=").append(this._discFlags).append("]");
        }
        return sb.toString();
    }

    public String getSeedPrintString(boolean inDetail) {
        return this._seed.getBase().print(inDetail, true);
    }

    public boolean isVersionLessThan(String version) {
        SwitchVersion devVersion = new SwitchVersion(this._version);
        SwitchVersion targetVersion = new SwitchVersion(version);
        return this._version != null && devVersion.lessThan(targetVersion);
    }
}

