/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.IntPair;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.CfsRegion;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchLicenseDetails;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.rif.SanException;
import com.cisco.dcbu.sm.common.type.CfsRegionPK;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIfWwnKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanFportKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DBObjectIf;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.BrcdFabricWorker;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.discovery.FabricWorker;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CfsRegionImpl;
import com.cisco.dcbu.sm.server.model.ChannelMemberNpvl;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.DataStoreImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FcLinkIf;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.HostClusterImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.model.ZoneImpl;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.vi.facade.api.ViFacade;
import com.cisco.dcbu.vi.model.DataStore;
import com.cisco.dcbu.vi.model.ViManager;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class FabricImpl
implements DBObjectIf,
Comparator,
Comparable {
    public static final String FABRIC_IS_BUSY = "DCNM is busy polling/discovering this fabric";
    public static int _DefRediscInterval;
    public static int _DefPollInterval;
    static final String QuerySeedIdSQLByPk = "select f.seed_switch_id from fabric f where f.fid=? ";
    static final String QueryVsanScopeSQLByPk = "select f.vsans_included, f.vsans_excluded from fabric f where f.fid=? ";
    static final String QueryFpkQLByDbId = "select f.fid from fabric f where  f.id=?";
    static final String QueryDbIdByFpk = "select f.id from fabric f where f.fid=?";
    static final String QueryFpkQLByIp = "select f.fid from fabric f, switch s where s.ip_address=? and f.id=s.fabric_id";
    static final String QueryFpkQLByIpVsans = "select f.fid from fabric f, switch s where s.ip_address=? and f.vsans_included=? and f.vsans_excluded=? and f.id=s.fabric_id";
    static final String QuerySQLByIp = "select f.id, f.seed_switch_id, f.ivr_seed_switch_id, f.ivr_enf_zoneset_name, f.ivr_enf_zoneset_activate_time, f.polling_enabled, f.polling_interval, f.last_scan_time, f.snmp_retries, f.snmp_timeout, f.name, f.fid, f.alias_seed_switch_id, f.is_persistent, f.on_demand_poll_freq, f.fmuser_id,f.use_global_alias, f.license_id from fabric f, switch s where s.ip_address=? and f.id=s.fabric_id";
    static final String QuerySQLByIpVsans = "select f.id, f.seed_switch_id, f.ivr_seed_switch_id, f.ivr_enf_zoneset_name, f.ivr_enf_zoneset_activate_time, f.polling_enabled, f.polling_interval, f.last_scan_time, f.snmp_retries, f.snmp_timeout, f.name, f.fid, f.alias_seed_switch_id, f.is_persistent, f.on_demand_poll_freq, f.fmuser_id,f.use_global_alias, f.license_id from fabric f, switch s where s.ip_address=? and f.vsans_included=? and f.vsans_excluded=? and f.id=s.fabric_id";
    static final String QuerySQLByIpFilteredByServerId = "select f.id, f.seed_switch_id, f.ivr_seed_switch_id, f.ivr_enf_zoneset_name, f.ivr_enf_zoneset_activate_time, f.polling_enabled, f.polling_interval, f.last_scan_time, f.snmp_retries, f.snmp_timeout, f.name, f.fid, f.alias_seed_switch_id, f.is_persistent, f.on_demand_poll_freq, f.fmuser_id,f.use_global_alias, f.license_id from fabric f, switch s, logicsvr_fabric lf where f.id=s.fabric_id and f.fid = lf.f_id and lf.lsvr_id = ? and s.ip_address=?";
    static final String QuerySQLByIpVsansFilteredByServerId = "select f.id, f.seed_switch_id, f.ivr_seed_switch_id, f.ivr_enf_zoneset_name, f.ivr_enf_zoneset_activate_time, f.polling_enabled, f.polling_interval, f.last_scan_time, f.snmp_retries, f.snmp_timeout, f.name, f.fid, f.alias_seed_switch_id, f.is_persistent, f.on_demand_poll_freq, f.fmuser_id,f.use_global_alias, f.license_id, f.vsans_included, f.vsans_excluded from fabric f, switch s, logicsvr_fabric lf where f.id=s.fabric_id and f.fid = lf.f_id and lf.lsvr_id = ? and s.ip_address=? and f.vsans_included=? and f.vsans_excluded=?";
    static final String QuerySQLByPersistent = "select f.id, f.seed_switch_id, f.ivr_seed_switch_id, f.ivr_enf_zoneset_name, f.ivr_enf_zoneset_activate_time, f.polling_enabled, f.polling_interval, f.last_scan_time, f.snmp_retries, f.snmp_timeout, f.name, f.fid, f.alias_seed_switch_id, f.is_persistent, f.on_demand_poll_freq, f.fmuser_id,f.use_global_alias, f.license_id from fabric f";
    static final String QuerySQLByPersistentFilteredByServerId = "select f.id, f.seed_switch_id, f.ivr_seed_switch_id, f.ivr_enf_zoneset_name, f.ivr_enf_zoneset_activate_time, f.polling_enabled, f.polling_interval, f.last_scan_time, f.snmp_retries, f.snmp_timeout, f.name, f.fid, f.alias_seed_switch_id, f.is_persistent, f.on_demand_poll_freq, f.fmuser_id,f.use_global_alias, f.license_id, f.vsans_included, f.vsans_excluded from fabric f, logicsvr_fabric lf where f.fid = lf.f_id and lf.lsvr_id = ?";
    static final String QuerySnmpByFID = "select distinct snmpuser.version, snmpuser.user_name, snmpuser.auth_password, snmpuser.priv_password, snmpuser.auth_protocol, snmpuser.priv_protocol, snmpuser.security_name, snmpuser.role_name from fabric, snmpuser where snmpuser.id = fabric.fmuser_id and fabric.fid=?";
    static final String InsertSQL = "insert into fabric(id, seed_switch_id, ivr_seed_switch_id, ivr_enf_zoneset_name, ivr_enf_zoneset_activate_time, polling_enabled, polling_interval, last_scan_time, snmp_retries, snmp_timeout, name, fid, alias_seed_switch_id, is_persistent, on_demand_poll_freq, fmuser_id, last_update_time, use_global_alias, license_id, vsans_included, vsans_Excluded) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?)";
    static final String UpdateSQL = "update fabric set seed_switch_id=?, ivr_seed_switch_id=?, ivr_enf_zoneset_name=?, ivr_enf_zoneset_activate_time=?, polling_enabled=?, polling_interval=?, last_scan_time=?, snmp_retries=?, snmp_timeout=?, name=?, fid=?, alias_seed_switch_id=?, is_persistent=?, on_demand_poll_freq=?, fmuser_id=?, last_update_time=?,use_global_alias=?, license_id=?, vsans_included=?, vsans_excluded=? where id=?";
    static final String UpdateUserSQL = "update fabric set fmuser_id=? where id=?";
    static final String TableName = "fabric";
    long _lastUpdateTime = 0L;
    long _userDBID = 0L;
    public static final int DISC_IVRZONES = 1;
    public static final int DISC_CLUSTER = 2;
    public static final int STATUS_OPENING = 1;
    public static final int STATUS_OPENED = 2;
    public static final int STATUS_LOADING = 3;
    public static final int STATUS_STORING = 4;
    public static final int STATUS_CLOSING = 5;
    public static final int STATUS_CLOSED = 6;
    public static final String[] STATUS_NAMES;
    static Logger _Logger;
    private final FabricPK _pkey;
    private SwitchImpl _seed;
    private SwitchImpl _ivrSeed;
    private SwitchImpl _aliasSeed;
    private SwitchImpl _licSeed;
    private boolean _useFcAlias = Boolean.getBoolean("fabric.fcalias");
    private boolean _isPersistent;
    private long _lastScanTime;
    private ViFacade smeBean;
    private ConcurrentHashMap<Integer, String> _ivrEnfZoneSetName;
    private ConcurrentHashMap<Integer, Long> _ivrEnfZoneSetActivateTime;
    private ConcurrentHashMap<Integer, ZoneBase[]> _ivrEnfZones;
    private transient ConcurrentHashMap<Integer, Integer> _ivrEnfZoneNum;
    private transient ConcurrentHashMap<Integer, byte[]> _ivrActiveZoneSetChecksum;
    private transient ConcurrentHashMap<Integer, byte[]> _deviceAliasChecksum;
    private int _licenseId = 0;
    private ConcurrentHashMap<VsanPK, VsanImpl> _vsanByPK;
    private ConcurrentHashMap<CfsRegionPK, CfsRegionImpl> _cfsRegionByPK;
    private ConcurrentHashMap<SwitchIntKey, IslImpl> _islBySwitchIntKey;
    private ConcurrentHashMap<SwitchIntKey, NpvLinkImpl> _npvLinkByFPortPK;
    private ConcurrentHashMap<NameKey, DataStoreImpl> _dataStoreByPK;
    private List<SwitchImpl> _switches;
    private ConcurrentHashMap<ClusterPK, ClusterImpl> _clusterByPK;
    private ConcurrentHashMap<String, String> _clusterNameById;
    private ArrayList<ClusterImpl> _preClusters;
    private HashMap<PKIf, PKIf> _coexistSwPKs;
    private ArrayList<Integer> cfsRegions;
    private ConcurrentHashMap<Integer, SwitchImpl> _ivrSeedByCfsRegion;
    private ConcurrentHashMap<Integer, SwitchImpl> _aliasSeedByCfsRegion;
    private final transient AtomicInteger _status;
    private SnmpUser _user;
    private int _retries = SnmpPeer._Retries;
    private int _timeout = SnmpPeer._Timeout;
    private boolean _enablePolling = true;
    private int _pollInterval = _DefPollInterval;
    private int _rediscInterval = _DefRediscInterval;
    private FabricWorker _worker;
    private int _discFlags = 1;
    private final transient HashSet<SwitchImpl> _dupSwitches = new HashSet();
    private final transient Map<SwitchIfWwnKey, FcLinkIf> _pendingLinks = new ConcurrentHashMap<SwitchIfWwnKey, FcLinkIf>();
    private transient String clientIp = null;
    private transient String fmUser = null;
    private transient SyncedInt _delayedChanges = new SyncedInt(0);
    private transient SyncedInt _nondelayedChanges = new SyncedInt(0);
    private transient AtomicBoolean _bufInUse = new AtomicBoolean(false);
    private transient List<AbstractModelObjectImpl> _added;
    private transient Set<AbstractModelObjectImpl> _addedNoLog;
    private transient List<PKIf> _removed;
    private transient Set<PKIf> _removedNoLog;
    private transient List<MovedModelObject> _moved;
    private transient List<ChangedModelObject> _changed;
    private transient FabricBase _cachedFabric;
    protected FabricBase _allVsanScopefabricBase;
    private transient long _dbID;
    private transient long _seedDBID;
    private transient long _ivrSeedDBID;
    private transient long _aliasSeedDBID;
    private transient Map<Long, VsanImpl> _vsanByDbId;
    private transient Map<Long, SwitchImpl> _swByDbId;
    private transient Map<Long, FcPortImpl> _swPortByDbId;
    private transient Map<Long, EnclosureImpl> _encByDbId;
    private transient Map<Long, HostClusterImpl> _hostClusterByDbId;
    private transient Map<Long, EndPortImpl> _endPortByDbId;
    private transient Map<Long, IslImpl> _islByDbId;
    private transient Map<Long, NpvLinkImpl> _npvlByDbId;
    private transient Map<Long, List<int[]>> _chanMbrByChanDbId;
    private transient Map<Long, ClusterImpl> _clusterByDbId;
    private transient Map<Long, FcPortAlias> _deviceAliasByDbId;
    private transient Map<SwitchIntKey, FcPortImpl> _swPortByKey;
    private transient Map<Long, DataStoreImpl> _dataStoreByDbId;
    private transient Map<Long, CfsRegionImpl> _cfsRegionByDbId;
    private transient List<FcPortAlias> _deviceAliasRemoveList;
    private transient List<EndPortImpl> _endPortRemoveList;
    private transient boolean _persisted = false;
    private transient int _maxWait = 75;
    private transient boolean _peerReset = false;
    private transient LicenseInfo _licInfo = null;
    public static final String STATUS_UP = "up";
    public static final String STATUS_DOWN = "down";
    public static final String STATE_ENABLED = "enabled";
    public static final String STATE_DISABLED = "disabled";
    public static final String VALUE_NONE = "none";
    public static final String VALUE_NA = "n/a";
    static final String[] LIL;

    FabricImpl(FabricPK fabricKey) {
        this._pkey = fabricKey;
        this._vsanByPK = new ConcurrentHashMap();
        this._cfsRegionByPK = new ConcurrentHashMap();
        this._islBySwitchIntKey = new ConcurrentHashMap();
        this._npvLinkByFPortPK = new ConcurrentHashMap();
        this._switches = Collections.synchronizedList(new ArrayList());
        this._dataStoreByPK = new ConcurrentHashMap();
        this._coexistSwPKs = new HashMap();
        this._clusterByPK = new ConcurrentHashMap();
        this._clusterNameById = new ConcurrentHashMap();
        this._ivrEnfZoneSetName = new ConcurrentHashMap();
        this._ivrEnfZoneSetActivateTime = new ConcurrentHashMap();
        this._ivrEnfZones = new ConcurrentHashMap();
        this._ivrEnfZoneNum = new ConcurrentHashMap();
        this._ivrActiveZoneSetChecksum = new ConcurrentHashMap();
        this._ivrSeedByCfsRegion = new ConcurrentHashMap();
        this._deviceAliasChecksum = new ConcurrentHashMap();
        this._aliasSeedByCfsRegion = new ConcurrentHashMap();
        this._ivrSeedByCfsRegion = new ConcurrentHashMap();
        this._added = Collections.synchronizedList(new ArrayList(5));
        this._removed = Collections.synchronizedList(new ArrayList(5));
        this._moved = Collections.synchronizedList(new ArrayList(5));
        this._changed = Collections.synchronizedList(new ArrayList(5));
        this._addedNoLog = Collections.synchronizedSet(new HashSet());
        this._removedNoLog = Collections.synchronizedSet(new HashSet());
        this._vsanByDbId = Collections.synchronizedMap(new HashMap());
        this._swByDbId = Collections.synchronizedMap(new HashMap());
        this._swPortByDbId = Collections.synchronizedMap(new HashMap());
        this._encByDbId = Collections.synchronizedMap(new HashMap());
        this._hostClusterByDbId = Collections.synchronizedMap(new HashMap());
        this._endPortByDbId = Collections.synchronizedMap(new HashMap());
        this._islByDbId = Collections.synchronizedMap(new HashMap());
        this._npvlByDbId = Collections.synchronizedMap(new HashMap());
        this._chanMbrByChanDbId = Collections.synchronizedMap(new HashMap());
        this._clusterByDbId = Collections.synchronizedMap(new HashMap());
        this._deviceAliasByDbId = Collections.synchronizedMap(new HashMap());
        this._dataStoreByDbId = Collections.synchronizedMap(new HashMap());
        this._swPortByKey = Collections.synchronizedMap(new HashMap());
        this._cfsRegionByDbId = Collections.synchronizedMap(new HashMap());
        this._deviceAliasRemoveList = Collections.synchronizedList(new ArrayList());
        this._endPortRemoveList = Collections.synchronizedList(new ArrayList());
        this._status = new AtomicInteger(1);
        this._allVsanScopefabricBase = new FabricBase(new FabricConverter(null));
        this._maxWait = Integer.getInteger("fabric.discovery.worker.timeout", 75);
    }

    public FabricPK getPK() {
        return this._pkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            return this._status.get();
        }
    }

    public String toString() {
        return this._pkey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricBase getFabricBase(short[] vsanScope) {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._cachedFabric != null) {
                return this._cachedFabric.getScopedFabric(vsanScope);
            }
            if (this._status.get() == 1) {
                return null;
            }
            FabricBase fBase = new FabricBase(new FabricConverter(vsanScope));
            if (this._allVsanScopefabricBase != null) {
                fBase.setDeviceAliasMap(this._allVsanScopefabricBase);
                fBase.setIncludedVsanList(this._allVsanScopefabricBase.getIncludedVsanList());
                fBase.setExcludedVsanList(this._allVsanScopefabricBase.getExcludedVsanList());
            }
            fBase.setCoexistSwitchPKs(this._coexistSwPKs);
            return fBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FabricBase getFabricBaseByGroup(GroupBase group) {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._cachedFabric != null) {
                return this._cachedFabric.getScopedFabric(group);
            }
            if (this._status.get() == 1) {
                return null;
            }
            short type = group.getType();
            if (type != 1) {
                return null;
            }
            ArrayList<SwitchImpl> switches = new ArrayList<SwitchImpl>();
            ArrayList<PKIf> members = group.getMembers();
            if (members != null && members.size() > 0) {
                for (int j = 0; j < members.size(); ++j) {
                    PKIf memberPK = members.get(j);
                    if (!(memberPK instanceof WwnKey)) continue;
                    WwnKey swPK = (WwnKey)memberPK;
                    SwitchImpl sw = SanManager.getInstance().findSwitch(swPK, this.getPK());
                    if (sw == null) continue;
                    switches.add(sw);
                }
            }
            FabricBase fBase = new FabricBase(new FabricConverter(true, switches));
            if (this._allVsanScopefabricBase != null) {
                fBase.setDeviceAliasMap(this._allVsanScopefabricBase);
            }
            fBase.setCoexistSwitchPKs(this._coexistSwPKs);
            return fBase;
        }
    }

    public static boolean inScope(short[] vsanScope, VsanImpl v) {
        return FabricImpl.inScope(vsanScope, v.getVsanPK());
    }

    public static boolean inScope(short[] vsanScope, VsanPK vkey) {
        return vsanScope == null ? true : Arrays.binarySearch(vsanScope, vkey._id) >= 0;
    }

    public static boolean inScope(short[] vsanScope, SwitchImpl sw) {
        return vsanScope == null ? true : FabricImpl.inScope(vsanScope, sw.getVsanIds());
    }

    public static boolean inScope(short[] vsanScope, IslImpl isl) {
        return vsanScope == null ? true : FabricImpl.inScope(vsanScope, isl.getVsanIds());
    }

    public static boolean inScope(short[] vsanScope, short[] vids) {
        if (vids == null) {
            return false;
        }
        for (int i = 0; i < vids.length; ++i) {
            if (Arrays.binarySearch(vsanScope, vids[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean inScope(short[] vsanScope, EndPortImpl ep) {
        return vsanScope == null ? true : FabricImpl.inScope(vsanScope, ep.getVsanMembership());
    }

    public static boolean inScope(short[] vsanScope, FcPortBase fcp) {
        return vsanScope == null ? true : FabricImpl.inScope(vsanScope, fcp.getVsanMembership());
    }

    public static boolean inScope(short[] vsanScope, NpvLinkImpl npvl) {
        return vsanScope == null ? true : FabricImpl.inScope(vsanScope, npvl.getVsanIds());
    }

    public static boolean inScope(ArrayList<SwitchImpl> switchScope, VsanImpl v) {
        for (SwitchImpl sw : switchScope) {
            short[] vsanScope;
            if (sw == null || !FabricImpl.inScope(vsanScope = sw.getVsanIds(), v.getVsanPK())) continue;
            return true;
        }
        return false;
    }

    public static boolean inScope(ArrayList<SwitchImpl> switchScope, SwitchImpl sw) {
        return switchScope.contains(sw);
    }

    public static boolean inScope(ArrayList<SwitchImpl> switchScope, IslImpl isl) {
        for (SwitchImpl sw : switchScope) {
            if (!sw.equals(isl.getSwitch1()) && !sw.equals(isl.getSwitch2())) continue;
            return true;
        }
        return false;
    }

    public static boolean inScope(ArrayList<SwitchImpl> switchScope, EndPortImpl ep) {
        for (SwitchImpl sw : switchScope) {
            if (!sw.equals(ep.getSwitch())) continue;
            return true;
        }
        return false;
    }

    public static boolean inScope(ArrayList<SwitchImpl> switchScope, FcPortBase fcp) {
        for (SwitchImpl sw : switchScope) {
            if (sw.getPK() == null || !sw.getPK().equals(fcp.getSwitchPK())) continue;
            return true;
        }
        return false;
    }

    public static boolean inScope(ArrayList<SwitchImpl> switchScope, NpvLinkImpl npvl) {
        for (SwitchImpl sw : switchScope) {
            if (!sw.equals(npvl.getCoreSwitch())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockFabricQuery() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() != 1) {
                this._cachedFabric = new FabricBase(new FabricConverter(null));
                if (this._allVsanScopefabricBase != null) {
                    this._cachedFabric.setDeviceAliasMap(this._allVsanScopefabricBase);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockFabricQuery() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            this._cachedFabric = null;
        }
    }

    public boolean attemptFabric(int condStatus, int status, long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() == condStatus) {
                this._status.set(status);
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this._status.wait(waitTime);
                    if (this._status.get() != condStatus) continue;
                    this._status.set(status);
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                if (_Logger.isTraceEnabled()) {
                    _Logger.trace((Object)(this + " attempt fabric interrupted"), (Throwable)new Exception(this + " attempt fabric--" + FabricImpl.getStatusDesc(condStatus) + "--" + FabricImpl.getStatusDesc(status)));
                }
                this._status.notifyAll();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFabric(int status) {
        if (status != this._status.get()) {
            int preStatus = this._status.get();
            this._status.set(status);
            AtomicInteger atomicInteger = this._status;
            synchronized (atomicInteger) {
                this._status.notifyAll();
            }
            if ((preStatus == 1 || preStatus == 3) && status == 2) {
                SanManager.notifyFabricOpened(this);
            } else if (status == 5 || status == 6) {
                SanManager.notifyFabricClosed(this);
            }
        }
    }

    public int getFarbicStatus() {
        return this._status.get();
    }

    public String getFabricName() {
        return this._pkey.getName();
    }

    public void setFabricName(String name) {
        if (!GenUtil.equals(name, this._pkey.getName())) {
            String oldName = this._pkey.getName();
            this._pkey.setName(name);
            this.modelObjectChanged(this._pkey, (short)513, (Serializable)((Object)oldName), (Serializable)((Object)name));
            NavigationUtil.getInstance().modifyFabricName(this._dbID, name);
            this.persistAttributes();
        }
    }

    public long getLastScanTime() {
        return this._lastScanTime;
    }

    public boolean isLicensed() {
        int state = LicenseManager.getInstance().getFmLicensedState(this);
        this.setLicenseId(state);
        return SwitchLicenseDetails.isValidLicenseState(state);
    }

    public int getLicensedState() {
        int state = LicenseManager.getInstance().getFmLicensedState(this);
        this.setLicenseId(state);
        return state;
    }

    public SwitchImpl getLicenseServer() {
        return this._licSeed;
    }

    public void setLicenseServer(SwitchImpl sw) {
        this._licSeed = sw;
    }

    public boolean isManaged() {
        return this._status.get() == 2 || this._status.get() == 4;
    }

    public boolean isPersistent() {
        return this._isPersistent;
    }

    void setPersistent(boolean isPersistent) {
        if (this._isPersistent ^ isPersistent) {
            this._isPersistent = isPersistent;
            this.modelObjectChanged(this._pkey, (short)519, Boolean.valueOf(!isPersistent), Boolean.valueOf(isPersistent));
            this.persistAttributes();
        }
    }

    public boolean isVsanScoped() {
        return this._allVsanScopefabricBase != null ? this._allVsanScopefabricBase.isVsanScoped() : false;
    }

    public boolean setPollInterval(int interval) {
        if (interval != this._pollInterval && interval > this._maxWait) {
            this._pollInterval = interval;
            this.persistAttributes();
            return true;
        }
        return false;
    }

    public int getPollInterval() {
        return this._pollInterval;
    }

    public void enablePolling(boolean enable) {
        this._enablePolling = enable;
    }

    public boolean isPollingEnabled() {
        return this._enablePolling;
    }

    public int getRediscoverInterval() {
        return this._rediscInterval;
    }

    public void setRediscoverInterval(int interval) {
        this._rediscInterval = interval > 0 ? interval : 5;
        this.persistAttributes();
    }

    public long getDiscoveryTimeout() {
        return Math.max(this._timeout * (this._retries + 1) * 6 + 1000, this._maxWait * 4000);
    }

    public void setDiscFlag(int type) {
        this._discFlags |= type;
    }

    public void resetDiscFlag(int type) {
        this._discFlags &= ~type;
    }

    public boolean isDiscFlagSet(int type) {
        return (this._discFlags & type) != 0;
    }

    public void incrementChange(boolean delayed) {
        if (delayed) {
            this.scheduleRefresh(12000);
            this._delayedChanges.set(0);
        } else if (this.isDiscovering()) {
            this._nondelayedChanges.increment();
        } else if (!this.isRefreshScheduled()) {
            this.scheduleRefresh(5000);
        } else if (this.isRefreshScheduled()) {
            int delay = 5000;
            if (this._worker != null && this._worker.getNextExecutionTime() > System.currentTimeMillis() + (long)delay) {
                this.scheduleRefresh(delay);
            }
        }
    }

    public SnmpUser getCredentials() {
        return this._user;
    }

    public void setCredentials(SnmpUser user, boolean tryAll) throws SnmpException {
        if (this._user != null && (!this._user.equals(user) || this._peerReset)) {
            StringBuffer sb = null;
            boolean success = false;
            if (tryAll || this._peerReset) {
                sb = new StringBuffer();
            }
            for (SwitchImpl sw : this._switches) {
                if (!sw.isMDS()) continue;
                try {
                    sw.setCredentials(user);
                    success = true;
                }
                catch (SnmpException ex) {
                    if (tryAll || this._peerReset) {
                        sb.append(sw.getIpAddress() + "\n");
                        continue;
                    }
                    throw ex;
                }
            }
            this._peerReset = false;
            if (success || this._switches.size() == 0) {
                try {
                    if (!this._user.equals(user)) {
                        this._user = user;
                        this.setDBCredentials(this._user);
                        if (this._switches.size() == 0) {
                            this._peerReset = true;
                        }
                    }
                }
                catch (SQLException e) {
                    _Logger.info((Object)"Setting crenential isn't persisted into the DB");
                }
            }
            if (sb != null && sb.length() > 0) {
                throw new SnmpException("Set Fabric SNMP credentail failed on:\n" + sb.toString());
            }
        } else {
            this._user = user;
        }
    }

    public void setDBCredentials(SnmpUser snmpUser) throws SQLException {
        Connection con = null;
        PreparedStatement snmpUpdate = null;
        PreparedStatement userUpdate = null;
        try {
            con = ConnectionManager.getConnection();
            SnmpUserImpl snmpUserImpl = new SnmpUserImpl(snmpUser);
            snmpUpdate = snmpUserImpl.getPersistentSql(con);
            if (snmpUpdate != null) {
                snmpUpdate.execute();
            }
            long userId = snmpUserImpl.getDBID();
            userUpdate = con.prepareStatement(UpdateUserSQL);
            userUpdate.setLong(1, userId);
            userUpdate.setLong(2, this.getDBID());
            userUpdate.execute();
        }
        catch (Exception ex) {
            try {
                throw new SQLException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(snmpUpdate);
                DbUtil.close(userUpdate);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(snmpUpdate);
        DbUtil.close(userUpdate);
        DbUtil.close(con);
    }

    public int getRetries() {
        return this._retries;
    }

    public void setRetries(int retries) {
        if (this._retries != retries) {
            this._retries = retries;
            for (SwitchImpl sw : this._switches) {
                if (!sw.isPeerCreated()) continue;
                try {
                    sw.createPeer().setRetries(retries);
                }
                catch (SnmpException se) {}
            }
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        if (this._timeout != timeout) {
            this._timeout = timeout;
            for (SwitchImpl sw : this._switches) {
                if (!sw.isPeerCreated()) continue;
                try {
                    sw.createPeer().setTimeout(timeout);
                }
                catch (SnmpException se) {}
            }
        }
    }

    public SwitchImpl getIvrSeed() {
        return this._ivrSeed;
    }

    public void setIvrSeed(SwitchImpl swImpl) {
        WwnKey newKey;
        WwnKey oldKey = this._ivrSeed == null ? null : this._ivrSeed.getSwitchPK();
        WwnKey wwnKey = newKey = swImpl == null ? null : swImpl.getSwitchPK();
        if (!GenUtil.equals(newKey, oldKey)) {
            _Logger.info((Object)("fabric " + this.getFabricName() + " IVR seed change: " + this._ivrSeed + "-->" + swImpl));
            this._ivrSeed = swImpl;
            if (swImpl == null) {
                this._ivrSeedByCfsRegion.remove(new Integer(-1));
            } else {
                this._ivrSeedByCfsRegion.put(new Integer(-1), swImpl);
            }
            this._allVsanScopefabricBase.setRegionIvrSeed(-1, swImpl == null ? null : swImpl.getSwitchPK());
            CfsRegion oKey = new CfsRegion(this._pkey, -1, oldKey, null);
            CfsRegion nKey = new CfsRegion(this._pkey, -1, newKey, null);
            this.modelObjectChanged(this._pkey, (short)515, oKey, nKey);
        }
        if (swImpl == null) {
            this.removeIvrEnforcedZoneSetActivateTime(-1);
            this.removeIvrEnforcedZoneSetName(-1);
            this.removeIvrActiveZonesetChecksum(-1);
            this.removeIvrEnforcedZoneNum(-1);
            this.removeIvrEnforcedZones(-1);
        }
    }

    public SwitchImpl getRegionIvrSeed(int cfsRegionId) {
        return this._ivrSeedByCfsRegion.get(new Integer(cfsRegionId));
    }

    public void setRegionIvrSeed(int cfsRegionId, SwitchImpl swImpl) {
        WwnKey newKey;
        SwitchImpl oldSw = this._ivrSeedByCfsRegion.get(new Integer(cfsRegionId));
        WwnKey oldKey = oldSw == null ? null : oldSw.getSwitchPK();
        WwnKey wwnKey = newKey = swImpl == null ? null : swImpl.getSwitchPK();
        if (!GenUtil.equals(newKey, oldKey)) {
            _Logger.info((Object)("fabric " + this.getFabricName() + ", CFS Region " + cfsRegionId + " IVR seed change: " + oldSw + "-->" + swImpl));
            if (swImpl == null) {
                this._ivrSeedByCfsRegion.remove(new Integer(cfsRegionId));
            } else {
                this._ivrSeedByCfsRegion.put(new Integer(cfsRegionId), swImpl);
            }
            this._allVsanScopefabricBase.setRegionIvrSeed(cfsRegionId, swImpl == null ? null : swImpl.getSwitchPK());
            CfsRegion oKey = new CfsRegion(this._pkey, cfsRegionId, oldKey, null);
            CfsRegion nKey = new CfsRegion(this._pkey, cfsRegionId, newKey, null);
            this.modelObjectChanged(this._pkey, (short)515, oKey, nKey);
        }
        if (swImpl == null) {
            this.removeIvrEnforcedZoneSetActivateTime(cfsRegionId);
            this.removeIvrEnforcedZoneSetName(cfsRegionId);
            this.removeIvrActiveZonesetChecksum(cfsRegionId);
            this.removeIvrEnforcedZoneNum(cfsRegionId);
            this.removeIvrEnforcedZones(cfsRegionId);
        }
    }

    public void removeRegionIvrSeed(int cfsRegionId) {
        this.setRegionIvrSeed(cfsRegionId, null);
    }

    public void setIvrEnforcedZoneSetName(String newName) {
        this.setIvrEnforcedZoneSetName(new Integer(-1), newName);
    }

    public void setIvrEnforcedZoneSetName(int regionId, String newName) {
        String oldName;
        if (newName == null) {
            newName = "";
        }
        if (!GenUtil.equals(oldName = this._ivrEnfZoneSetName.get(new Integer(regionId)), newName)) {
            if (newName == null) {
                this._ivrEnfZoneSetName.remove(new Integer(regionId));
            } else {
                this._ivrEnfZoneSetName.put(new Integer(regionId), newName);
            }
            CfsRegion oKey = new CfsRegion(this._pkey, regionId, "IVR", oldName);
            CfsRegion nKey = new CfsRegion(this._pkey, regionId, "IVR", newName);
            this.modelObjectChanged(this._pkey, (short)516, oKey, nKey);
            if (newName != null && newName.length() != 0) {
                this.setDiscFlag(1);
            } else {
                this.setIvrEnforcedZones(regionId, null);
                this.resetDiscFlag(1);
            }
        }
    }

    public String getIvrEnforcedZoneSetName() {
        return this.getIvrEnforcedZoneSetName(-1);
    }

    public void removeIvrEnforcedZones(int regionId) {
        ZoneBase[] oldZones = this._ivrEnfZones.get(new Integer(regionId));
        this._ivrEnfZones.remove(new Integer(regionId));
        if (oldZones != null && oldZones.length != 0) {
            CfsRegion oKey = new CfsRegion(this._pkey, regionId, oldZones, "IVR");
            CfsRegion nKey = new CfsRegion(this._pkey, regionId, new ZoneBase[0], "IVR");
            this.modelObjectChanged(this._pkey, (short)518, oKey, nKey);
        }
    }

    public void removeIvrEnforcedZoneNum(int regionId) {
        this._ivrEnfZoneNum.remove(new Integer(regionId));
    }

    public void removeIvrActiveZonesetChecksum(int regionId) {
        this._ivrActiveZoneSetChecksum.remove(new Integer(regionId));
    }

    public void removeIvrEnforcedZoneSetName(int regionId) {
        String oldName = this._ivrEnfZoneSetName.get(new Integer(regionId));
        this._ivrEnfZoneSetName.remove(new Integer(regionId));
        if (!GenUtil.equals(oldName, null)) {
            CfsRegion oKey = new CfsRegion(this._pkey, regionId, "IVR", oldName);
            CfsRegion nKey = new CfsRegion(this._pkey, regionId, "IVR", null);
            this.modelObjectChanged(this._pkey, (short)516, oKey, nKey);
        }
    }

    public void removeIvrEnforcedZoneSetActivateTime(int regionId) {
        Long oldTime = this._ivrEnfZoneSetActivateTime.get(new Integer(regionId));
        this._ivrEnfZoneSetActivateTime.remove(new Integer(regionId));
        if (oldTime != null) {
            CfsRegion oKey = new CfsRegion(this._pkey, regionId, oldTime, "IVR");
            CfsRegion nKey = new CfsRegion(this._pkey, regionId, 0L, "IVR");
            this.modelObjectChanged(this._pkey, (short)517, oKey, nKey);
        }
    }

    public Integer getFirstIvrEnforcedZoneSetRegionId() {
        if (this._ivrEnfZoneSetName != null) {
            Iterator<Map.Entry<Integer, String>> itr = this._ivrEnfZoneSetName.entrySet().iterator();
            Map.Entry<Integer, String> obEntry = itr.next();
            return obEntry.getKey();
        }
        return null;
    }

    public ArrayList getAllIvrEnforcedZoneSetRegionIds() {
        if (this._ivrEnfZoneSetName != null) {
            ArrayList<Integer> regions = new ArrayList<Integer>();
            for (Map.Entry<Integer, String> obEntry : this._ivrEnfZoneSetName.entrySet()) {
                regions.add(obEntry.getKey());
            }
            return regions;
        }
        return null;
    }

    public String getIvrEnforcedZoneSetName(int regionId) {
        return this._ivrEnfZoneSetName.get(new Integer(regionId));
    }

    public void setIvrEnforcedZoneSetActivateTime(int regionId, long nTime) {
        Long oldTime = this._ivrEnfZoneSetActivateTime.get(new Integer(regionId));
        Long newTime = new Long(nTime);
        if (oldTime == null || !oldTime.equals(newTime)) {
            this._ivrEnfZoneSetActivateTime.put(new Integer(regionId), newTime);
            CfsRegion oKey = new CfsRegion(this._pkey, regionId, oldTime == null ? 0L : oldTime, "IVR");
            CfsRegion nKey = new CfsRegion(this._pkey, regionId, newTime, "IVR");
            this.modelObjectChanged(this._pkey, (short)517, oKey, nKey);
            if (newTime != 0L) {
                this.setDiscFlag(1);
            } else {
                this.setIvrEnforcedZones(regionId, null);
            }
        }
    }

    public Long getIvrEnforcedZoneSetActivateTime() {
        return this.getIvrEnforcedZoneSetActivateTime(-1);
    }

    public Long getIvrEnforcedZoneSetActivateTime(int regionId) {
        return this._ivrEnfZoneSetActivateTime.get(new Integer(regionId));
    }

    public byte[] getIvrActiveZonesetChecksum() {
        return this._ivrActiveZoneSetChecksum.get(new Integer(-1));
    }

    public byte[] getIvzActiveZonesetChecksum(int regionId) {
        return this._ivrActiveZoneSetChecksum.get(new Integer(regionId));
    }

    public void setIvrActiveZonesetChecksum(int regionId, byte[] checksum) {
        byte[] oldChecksum;
        if (checksum == null) {
            checksum = new byte[]{0, 0};
        }
        if (!Arrays.equals(oldChecksum = this._ivrActiveZoneSetChecksum.get(new Integer(regionId)), checksum)) {
            this._ivrActiveZoneSetChecksum.put(new Integer(regionId), checksum);
            if (checksum != null && !Arrays.equals(checksum, new byte[]{0, 0})) {
                this.setDiscFlag(1);
            } else {
                this.setIvrEnforcedZones(regionId, null);
                this.resetDiscFlag(1);
            }
        }
    }

    public int getIvrEnforcedZoneNum() {
        ArrayList regionIds = this.getAllIvrEnforcedZoneSetRegionIds();
        if (regionIds == null || regionIds.size() == 0) {
            return 0;
        }
        List<ZoneBase> zoneList = this.getAllIvrEnforcedZones();
        return zoneList != null ? zoneList.size() : 0;
    }

    public int getAllIvrEnforcedZoneSetNum() {
        if (this._ivrEnfZoneSetName != null) {
            return this._ivrEnfZoneSetName.size();
        }
        return 0;
    }

    public ArrayList getAllIvrEnforcedZoneSets() {
        ArrayList regionIds = this.getAllIvrEnforcedZoneSetRegionIds();
        ArrayList<String> ivrEnfZnstList = new ArrayList<String>();
        if (regionIds == null || regionIds.size() == 0) {
            return ivrEnfZnstList;
        }
        for (int i = 0; i < regionIds.size(); ++i) {
            int regionId = (Integer)regionIds.get(i);
            String ivrZnstName = this.getIvrEnforcedZoneSetName(regionId);
            if (ivrZnstName == null || ivrZnstName.length() <= 0) continue;
            ivrEnfZnstList.add(ivrZnstName);
        }
        return ivrEnfZnstList;
    }

    public int getIvrEnforcedZoneNum(int regionId) {
        Integer ob = this._ivrEnfZoneNum.get(new Integer(regionId));
        return ob == null ? 0 : ob;
    }

    public void setIvrEnforcedZoneNum(int regionId, int num) {
        Integer oldNum = this._ivrEnfZoneNum.get(new Integer(regionId));
        Integer newNum = new Integer(num);
        if (oldNum == null || oldNum != null && !oldNum.equals(newNum)) {
            this._ivrEnfZoneNum.put(new Integer(regionId), newNum);
            if (num != 0) {
                this.setDiscFlag(1);
            } else {
                this.setIvrEnforcedZones(regionId, null);
                this.resetDiscFlag(1);
            }
        }
    }

    public ZoneBase[] getIvrEnforcedZones() {
        List<ZoneBase> list = this.getAllIvrEnforcedZones();
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.toArray(new ZoneBase[list.size()]);
    }

    public List<ZoneBase> getAllIvrEnforcedZones() {
        ArrayList regionIds = this.getAllIvrEnforcedZoneSetRegionIds();
        if (regionIds == null || regionIds.size() == 0) {
            return null;
        }
        ArrayList<ZoneBase> zoneList = new ArrayList<ZoneBase>();
        for (int i = 0; i < regionIds.size(); ++i) {
            ZoneBase[] zones = this.getIvrEnforcedZones((Integer)regionIds.get(i));
            if (zones == null) continue;
            for (int j = 0; j < zones.length; ++j) {
                zoneList.add(zones[j]);
            }
        }
        return zoneList;
    }

    public ZoneBase[] getIvrEnforcedZones(int cfsRegionId) {
        return this._ivrEnfZones.get(new Integer(cfsRegionId));
    }

    public void setIvrEnforcedZones(int cfsRegionId, ZoneBase[] zones) {
        Object[] oldZones;
        if (zones != null) {
            Arrays.sort(zones);
        }
        if (zones == null) {
            zones = new ZoneBase[]{};
        }
        if (!Arrays.equals(oldZones = this._ivrEnfZones.get(new Integer(cfsRegionId)), zones)) {
            if (zones == null) {
                this._ivrEnfZones.remove(new Integer(cfsRegionId));
            } else {
                this._ivrEnfZones.put(new Integer(cfsRegionId), zones);
            }
            CfsRegion oKey = new CfsRegion(this._pkey, cfsRegionId, (ZoneBase[])oldZones, "IVR");
            CfsRegion nKey = new CfsRegion(this._pkey, cfsRegionId, zones, "IVR");
            this.modelObjectChanged(this._pkey, (short)518, oKey, nKey);
        }
    }

    public boolean useFcAlias() {
        return this._useFcAlias;
    }

    public void useFcAlias(boolean b) {
        if (this._useFcAlias ^ b) {
            this._useFcAlias = b;
            this.modelObjectChanged(this._pkey, (short)522, Boolean.valueOf(!b), Boolean.valueOf(b));
            this.persistAttributes();
            if (!this._useFcAlias && this._aliasSeed == null) {
                this.selectAliasSeed();
            }
        }
    }

    public SwitchImpl getAliasSeed() {
        return this._aliasSeed;
    }

    public void setAliasSeed(SwitchImpl sw) {
        WwnKey newKey;
        WwnKey oldKey = this._aliasSeed == null ? null : this._aliasSeed.getSwitchPK();
        WwnKey wwnKey = newKey = sw == null ? null : sw.getSwitchPK();
        if (!GenUtil.equals(newKey, oldKey)) {
            this._aliasSeed = sw;
            if (sw == null) {
                this._aliasSeedByCfsRegion.remove(new Integer(-1));
            } else {
                this._aliasSeedByCfsRegion.put(new Integer(-1), sw);
            }
            this._allVsanScopefabricBase.setRegionAliasSeed(-1, sw == null ? null : sw.getSwitchPK());
            CfsRegion oKey = new CfsRegion(this._pkey, -1, null, oldKey);
            CfsRegion nKey = new CfsRegion(this._pkey, -1, null, newKey);
            this.modelObjectChanged(this._pkey, (short)520, oKey, nKey);
        }
    }

    public void setRegionAliasSeed(int cfsRegionId, SwitchImpl sw) {
        WwnKey newKey;
        SwitchImpl oldSw = this._aliasSeedByCfsRegion.get(new Integer(cfsRegionId));
        WwnKey oldKey = oldSw == null ? null : oldSw.getSwitchPK();
        WwnKey wwnKey = newKey = sw == null ? null : sw.getSwitchPK();
        if (!GenUtil.equals(newKey, oldKey)) {
            if (sw == null) {
                this._aliasSeedByCfsRegion.remove(new Integer(cfsRegionId));
            } else {
                this._aliasSeedByCfsRegion.put(new Integer(cfsRegionId), sw);
            }
            this._allVsanScopefabricBase.setRegionAliasSeed(cfsRegionId, sw == null ? null : sw.getSwitchPK());
            CfsRegion oKey = new CfsRegion(this._pkey, cfsRegionId, null, oldKey);
            CfsRegion nKey = new CfsRegion(this._pkey, cfsRegionId, null, newKey);
            this.modelObjectChanged(this._pkey, (short)520, oKey, nKey);
        }
    }

    public SwitchImpl getRegionAliasSeed(int cfsRegionId) {
        return this._aliasSeedByCfsRegion.get(new Integer(cfsRegionId));
    }

    public void removeRegionAliasSeed(int cfsRegionId) {
        this.setRegionAliasSeed(cfsRegionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VsanImpl createVsan(int vid, Wwn prinSwwn) {
        boolean notPreexist;
        VsanImpl vsan;
        VsanPK vkey = new VsanPK(vid, prinSwwn);
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            vsan = this._vsanByPK.get(vkey);
            notPreexist = vsan == null;
            if (notPreexist) {
                vsan = new VsanImpl(this._pkey, vkey);
                this._vsanByPK.put(vkey, vsan);
            }
        }
        if (notPreexist) {
            this.modelObjectAdded(vsan);
        }
        return vsan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VsanImpl createVsan(VsanPK vkey, String name, byte adminState, byte operState, byte interOper, int mtu, byte lbType, boolean ioDelivery, int latency) {
        boolean notPreexist;
        VsanImpl vsan;
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            vsan = this._vsanByPK.get(vkey);
            notPreexist = vsan == null;
            if (notPreexist) {
                vsan = new VsanImpl(this._pkey, vkey, name, adminState, operState, interOper, mtu, lbType, ioDelivery, latency);
                this._vsanByPK.put(vkey, vsan);
            }
        }
        if (notPreexist) {
            this.modelObjectAdded(vsan);
        } else {
            vsan.setName(name);
            vsan.setAdminState(adminState);
            vsan.setOperState(operState);
            vsan.setInterOperMode(interOper);
            vsan.setMtu(mtu);
            vsan.setLoadBalancingType(lbType);
            vsan.setInorderDelievery(ioDelivery);
            vsan.setNetworkDropLatency(latency);
        }
        return vsan;
    }

    public int getNumVsans() {
        return this._vsanByPK.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VsanImpl[] getVsans() {
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            return this._vsanByPK.values().toArray(new VsanImpl[this._vsanByPK.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VsanPK getVsanByPrinwwn(Wwn prinwwn) {
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            Set vsankeys = this._vsanByPK.keySet();
            if (vsankeys != null) {
                VsanPK pk2 = null;
                for (VsanPK pk2 : vsankeys) {
                    if (!pk2._prinSwwn.equals(prinwwn)) continue;
                    return pk2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getVsanIds() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            for (VsanImpl vsan : this._vsanByPK.values()) {
                if (list.contains(new Integer(vsan.getId()))) continue;
                list.add(Integer.valueOf(vsan.getId()));
            }
        }
        return list;
    }

    void removeVsan(VsanImpl vsan) {
        if (this._vsanByPK.remove(vsan.getVsanPK()) != null) {
            if (vsan.getDBID() != 0L) {
                this._vsanByDbId.remove(vsan.getDBID());
            }
            this.modelObjectRemoved(vsan.getVsanPK());
            vsan.destroy();
        }
    }

    public VsanImpl findVsan(VsanPK vsanPK) {
        return this._vsanByPK.get(vsanPK);
    }

    public VsanImpl[] findVsan(int vsanId) {
        ArrayList<VsanImpl> vsans = new ArrayList<VsanImpl>(3);
        for (VsanImpl vsan : this._vsanByPK.values()) {
            if (vsan.getId() != vsanId) continue;
            vsans.add(vsan);
        }
        return vsans.isEmpty() ? null : vsans.toArray(new VsanImpl[vsans.size()]);
    }

    public boolean isVsanSegmented(int vid) {
        int i = 0;
        ArrayList<VsanImpl> vsans = new ArrayList<VsanImpl>();
        for (VsanPK key : this._vsanByPK.keySet()) {
            if (key._id != vid) continue;
            vsans.add(this._vsanByPK.get(key));
            ++i;
        }
        return i > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getCfsRegions(String feature) {
        IntArray regionIds = new IntArray(3);
        List<SwitchImpl> list = this._switches;
        synchronized (list) {
            for (SwitchImpl sw : this._switches) {
                int rId = sw.getCfsRegionId(feature);
                if (regionIds.contains(rId)) continue;
                regionIds.add(new Integer(rId));
            }
        }
        return regionIds.size() == 0 ? new int[]{} : regionIds.toArray();
    }

    public int getNumCfsRegions(String feature) {
        int[] cfsRegions = this.getCfsRegions(feature);
        if (cfsRegions == null || cfsRegions.length == 1 && cfsRegions[0] == -1) {
            return 0;
        }
        return cfsRegions.length;
    }

    public CfsRegionImpl[] getAllCfsRegions() {
        ArrayList regionIds = this.getAllIvrEnforcedZoneSetRegionIds();
        if (regionIds == null || regionIds.size() == 0) {
            return null;
        }
        ArrayList<CfsRegionImpl> cfsRegionList = new ArrayList<CfsRegionImpl>();
        for (int i = 0; i < regionIds.size(); ++i) {
            WwnKey aliasSeedPK;
            int regionId = (Integer)regionIds.get(i);
            String zonesetName = this.getIvrEnforcedZoneSetName(regionId);
            SwitchImpl ivrSeed = this.getRegionIvrSeed(regionId);
            SwitchImpl aliasSeed = this.getRegionAliasSeed(regionId);
            WwnKey ivrSeedPK = ivrSeed == null ? null : ivrSeed.getSwitchPK();
            WwnKey wwnKey = aliasSeedPK = aliasSeed == null ? null : aliasSeed.getSwitchPK();
            if (zonesetName == null) {
                zonesetName = "";
            }
            cfsRegionList.add(new CfsRegionImpl(this._pkey, regionId, ivrSeedPK, aliasSeedPK, zonesetName));
        }
        return cfsRegionList.toArray(new CfsRegionImpl[cfsRegionList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CfsRegionImpl createCfsRegion(int regionId, WwnKey ivrSeed, WwnKey aliasSeed, String ivrEnfZoneSetName) {
        boolean notPreexist;
        CfsRegionImpl cfsRegion;
        CfsRegionPK vkey = new CfsRegionPK(this._pkey, regionId);
        ConcurrentHashMap<CfsRegionPK, CfsRegionImpl> concurrentHashMap = this._cfsRegionByPK;
        synchronized (concurrentHashMap) {
            cfsRegion = this._cfsRegionByPK.get(vkey);
            notPreexist = cfsRegion == null;
            if (notPreexist) {
                cfsRegion = new CfsRegionImpl(this._pkey, regionId, ivrSeed, aliasSeed, ivrEnfZoneSetName);
                this._cfsRegionByPK.put(vkey, cfsRegion);
            }
        }
        if (notPreexist) {
            this.modelObjectAdded(cfsRegion);
        } else {
            SwitchImpl iSeed = SanManager.getInstance().findSwitch(ivrSeed, this.getPK());
            cfsRegion.setIvrSeed(iSeed);
            SwitchImpl aSeed = SanManager.getInstance().findSwitch(aliasSeed, this.getPK());
            cfsRegion.setAliasSeed(aSeed);
            cfsRegion.setIvrEnfZoneSetName(ivrEnfZoneSetName);
        }
        return cfsRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CfsRegionImpl[] getCfsRegions() {
        ConcurrentHashMap<CfsRegionPK, CfsRegionImpl> concurrentHashMap = this._cfsRegionByPK;
        synchronized (concurrentHashMap) {
            return this._cfsRegionByPK.values().toArray(new CfsRegionImpl[this._cfsRegionByPK.size()]);
        }
    }

    void removeCfsRegion(CfsRegionImpl cfsRegion) {
        if (this._cfsRegionByPK.remove(cfsRegion.getPK()) != null) {
            if (cfsRegion.getDBID() != 0L) {
                this._cfsRegionByDbId.remove(cfsRegion.getDBID());
            }
            this.modelObjectRemoved(cfsRegion.getCfsRegionPK());
            cfsRegion.destroy();
        }
    }

    public CfsRegionImpl findCfsRegion(CfsRegionPK cfsRegionPK) {
        return this._cfsRegionByPK.get(cfsRegionPK);
    }

    public int getNumSwitches() {
        return this._switches.size();
    }

    public SwitchImpl[] getSwitches() {
        return this._switches.toArray(new SwitchImpl[this._switches.size()]);
    }

    public SwitchImpl[] getNewSwitches() {
        ArrayList<SwitchImpl> swList = new ArrayList<SwitchImpl>();
        for (SwitchImpl sw : this._switches) {
            if (sw.getDBID() != 0L) continue;
            swList.add(sw);
        }
        return swList.toArray(new SwitchImpl[swList.size()]);
    }

    public SwitchImpl[] getSwitches(CfsRegionPK regPK) {
        ArrayList<SwitchImpl> swList = new ArrayList<SwitchImpl>();
        block0: for (SwitchImpl sw : this._switches) {
            ArrayList<Integer> rIds = sw.getCfsRegionIds();
            for (Integer rId : rIds) {
                if (rId != regPK._id) continue;
                swList.add(sw);
                continue block0;
            }
        }
        return swList.toArray(new SwitchImpl[swList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addSwitch(SwitchImpl sw) {
        boolean notPreexist;
        List<SwitchImpl> list = this._switches;
        synchronized (list) {
            notPreexist = !this._switches.contains(sw);
            if (notPreexist) {
                this._switches.add(sw);
            }
        }
        if (sw.getDBID() != 0L) {
            this._swByDbId.put(sw.getDBID(), sw);
        }
        if (notPreexist) {
            this.modelObjectAdded(sw);
        }
        return notPreexist;
    }

    public boolean removeSwitch(SwitchImpl sw) {
        boolean preexist = this._switches.remove(sw);
        if (preexist) {
            this._swByDbId.remove(sw.getDBID());
            this.modelObjectRemoved(sw.getPK());
        }
        return preexist;
    }

    void removeSwitchAndLinks(SwitchImpl sw) {
        this.removeSwitchAndLinks(sw, true);
    }

    void removeSwitchAndLinks(SwitchImpl sw, boolean purgeEnclosure) {
        if (sw == null) {
            return;
        }
        IslImpl[] isls = this.findIsls(sw);
        if (isls != null && isls.length > 0) {
            for (int i = 0; i < isls.length; ++i) {
                this.removeIsl(isls[i]);
            }
        }
        ArrayList<NpvLinkImpl> npvLinks = new ArrayList<NpvLinkImpl>();
        if (sw.isNpvEnabled()) {
            npvLinks.addAll(this.findNpvLinksByEdgeSwitch(sw));
        }
        if (sw.isFeatureEnabled(AbstractSwitchBase.Feature.NPIV.flag())) {
            npvLinks.addAll(this.findNpvLinksByCoreSwitch(sw));
        }
        for (NpvLinkImpl nl : npvLinks) {
            this.removeNpvLink(nl);
        }
        EndPortImpl[] endports = this.findEndPortsBySwitch(sw);
        if (endports != null && endports.length > 0) {
            for (int i = 0; i < endports.length; ++i) {
                this.removeEndPort(endports[i], false, purgeEnclosure);
            }
        }
        SanManager.getInstance().removeEndPorts(Arrays.asList(endports));
        VsanImpl[] vsans = this.getVsans();
        for (int i = 0; i < vsans.length; ++i) {
            vsans[i].removeSwitch(sw);
        }
        List<FcPortBase> ports = sw.getAllPorts();
        for (FcPortBase port : ports) {
            this.removeSwitchPort((SwitchIntKey)port.getSwitchPortPK(), false);
        }
        this.removeSwitch(sw);
    }

    public SwitchImpl findSwitch(InetAddress inetAddr) {
        SwitchImpl sw = SanManager.getInstance().findSwitch(inetAddr, this.getPK());
        return sw == null ? null : (sw.getFabric() == this ? sw : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDupSwitches(SwitchImpl sw) {
        HashSet<SwitchImpl> hashSet = this._dupSwitches;
        synchronized (hashSet) {
            this._dupSwitches.add(sw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDupSwitches(SwitchImpl sw) {
        HashSet<SwitchImpl> hashSet = this._dupSwitches;
        synchronized (hashSet) {
            this._dupSwitches.remove(sw);
        }
    }

    public int getNumOfDupSwitches() {
        return this._dupSwitches.size();
    }

    public HashSet<SwitchImpl> getDupSwitches() {
        return new HashSet<SwitchImpl>(this._dupSwitches);
    }

    public void clearDupSwitches() {
        this._dupSwitches.clear();
    }

    public int getNumIsls() {
        return this._islBySwitchIntKey.size() / 2;
    }

    public IslImpl[] getIsls() {
        ArrayList<IslImpl> isls = new ArrayList<IslImpl>(this._islBySwitchIntKey.size() / 2);
        for (Map.Entry<SwitchIntKey, IslImpl> entry : this._islBySwitchIntKey.entrySet()) {
            IslImpl isl = entry.getValue();
            if (!entry.getKey().equals(isl.getSwitch1IntKey())) continue;
            isls.add(isl);
        }
        return isls.toArray(new IslImpl[isls.size()]);
    }

    public List<IslImpl> findIslsBySwitches(SwitchImpl sw1, SwitchImpl sw2) {
        return this.getIsls(sw1, sw2, false);
    }

    public List<IslImpl> getPcIsls(SwitchImpl sw1, SwitchImpl sw2) {
        return this.getIsls(sw1, sw2, true);
    }

    List<IslImpl> getIsls(SwitchImpl sw1, SwitchImpl sw2, boolean needPCs) {
        if (sw1.hashCode() > sw2.hashCode()) {
            SwitchImpl tmp = sw1;
            sw1 = sw2;
            sw2 = tmp;
        }
        ArrayList<IslImpl> arIsl = new ArrayList<IslImpl>();
        for (Map.Entry<SwitchIntKey, IslImpl> entry : this._islBySwitchIntKey.entrySet()) {
            IslImpl isl = entry.getValue();
            if (!isl.getSwitch1().equals(sw1) || !isl.getSwitch2().equals(sw2) || needPCs && !isl.isPortChannel() || !entry.getKey().equals(isl.getSwitch1IntKey())) continue;
            arIsl.add(isl);
        }
        return arIsl;
    }

    public IslImpl findIsl(SwitchImpl sw, int ifIndex) {
        SwitchIntKey swIntKey = new SwitchIntKey(sw.getSwitchPK(), ifIndex);
        return this.findIsl(swIntKey);
    }

    public IslImpl findIslByFspfIfIndex(SwitchImpl sw, int fspfIfIndex) {
        SwitchIntKey swIntKey = new SwitchIntKey(sw.getSwitchPK(), IfIndexUtil.fspfPortIndexToIfIndex(fspfIfIndex));
        return this.findIsl(swIntKey);
    }

    public IslImpl findIsl(PKIf swIntKey) {
        if (swIntKey == null) {
            return null;
        }
        return this._islBySwitchIntKey.get(swIntKey);
    }

    public IslImpl[] findIsls(SwitchImpl sw) {
        if (sw == null) {
            return null;
        }
        ArrayList<IslImpl> isls = new ArrayList<IslImpl>();
        for (IslImpl isl : this._islBySwitchIntKey.values()) {
            if (!isl.getSwitch1().equals(sw) && !isl.getSwitch2().equals(sw)) continue;
            isls.add(isl);
        }
        return isls.toArray(new IslImpl[isls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIsl(IslImpl isl) {
        boolean added = false;
        ConcurrentHashMap<SwitchIntKey, IslImpl> concurrentHashMap = this._islBySwitchIntKey;
        synchronized (concurrentHashMap) {
            added = this._islBySwitchIntKey.put(isl.getSwitch1IntKey(), isl) == null;
            added |= this._islBySwitchIntKey.put(isl.getSwitch2IntKey(), isl) == null;
        }
        NpvLinkImpl npvLink = this.findNpvLink(isl.getSwitch1IntKey());
        if (npvLink == null) {
            npvLink = this.findNpvLink(isl.getSwitch2IntKey());
        }
        if (npvLink != null) {
            this.removeNpvLink(npvLink);
            try {
                InventoryPersistentManager.getInstance().purgeNpvLink(npvLink);
            }
            catch (Exception e) {
                _Logger.warn((Object)("[FabricImpl]Fabric cannot remove the NPV link from database:" + npvLink));
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("[FabricImpl]check ISL:" + isl));
            _Logger.trace((Object)("[FabricImpl]find NPVLink:" + npvLink));
        }
        if (isl.getDBID() != 0L) {
            added = true;
            this._islByDbId.put(isl.getDBID(), isl);
        }
        if (added) {
            this.modelObjectAdded(isl);
        }
    }

    public void removeIsl(IslImpl isl) {
        this.removeIsl(isl, false);
    }

    public void removeIsl(IslImpl isl, boolean purge) {
        this.removeIsl(isl, purge, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIsl(IslImpl isl, boolean purge, boolean needlog) {
        SwitchImpl sw;
        boolean removed = false;
        ConcurrentHashMap<SwitchIntKey, IslImpl> concurrentHashMap = this._islBySwitchIntKey;
        synchronized (concurrentHashMap) {
            removed = this._islBySwitchIntKey.remove(isl.getSwitch1IntKey()) != null;
            removed |= this._islBySwitchIntKey.remove(isl.getSwitch2IntKey()) != null;
        }
        if (isl.getDBID() != 0L) {
            this._islByDbId.remove(isl.getDBID());
        }
        if ((sw = isl.getSwitch1()) == null) {
            sw = isl.getSwitch2();
        }
        if (sw == null) {
            return;
        }
        short[] vids = sw.getVsanIds();
        if (vids != null && vids.length > 0) {
            for (int i = 0; i < vids.length; ++i) {
                VsanImpl[] vsans = this.findVsan(vids[i]);
                if (vsans == null || vsans.length <= 0) continue;
                for (int j = 0; j < vsans.length; ++j) {
                    vsans[j].removeIsl(isl);
                }
            }
        }
        if (removed) {
            if (purge) {
                this.modelObjectRemoved(isl.getPK(), true, needlog);
            } else {
                this.modelObjectRemoved(isl.getPK(), false, needlog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingLink(SwitchIfWwnKey swFwwn, FcLinkIf link) {
        if (swFwwn != null && link != null) {
            Map<SwitchIfWwnKey, FcLinkIf> map = this._pendingLinks;
            synchronized (map) {
                this._pendingLinks.put(swFwwn, link);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcLinkIf removePendingLink(SwitchIfWwnKey swFwwn) {
        if (swFwwn != null) {
            Map<SwitchIfWwnKey, FcLinkIf> map = this._pendingLinks;
            synchronized (map) {
                return this._pendingLinks.remove(swFwwn);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingLinks() {
        Map<SwitchIfWwnKey, FcLinkIf> map = this._pendingLinks;
        synchronized (map) {
            this._pendingLinks.clear();
        }
    }

    public FcLinkIf findPendingLink(SwitchIfWwnKey swFwwn) {
        if (swFwwn != null) {
            return this._pendingLinks.get(swFwwn);
        }
        return null;
    }

    public void resolvePendingInfo() {
        HashSet<SwitchIfWwnKey> swIfWwnKeys = new HashSet<SwitchIfWwnKey>(this._pendingLinks.keySet());
        for (SwitchIfWwnKey key : swIfWwnKeys) {
            try {
                byte[] fwwn;
                FcLinkIf link = this._pendingLinks.get(key);
                if (link == null) continue;
                if (link instanceof IslImpl) {
                    IslImpl isl = (IslImpl)link;
                    if (!isl.isPortChannel()) continue;
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)(key + " old PC==>" + isl));
                    }
                    SwitchImpl sw1 = isl.getSwitch1();
                    SwitchImpl sw2 = isl.getSwitch2();
                    List<IntPair> children = isl.getBase().getPcMembers();
                    if (sw1 == null || sw2 == null || children == null) continue;
                    HashSet<IntPair> newChildren = new HashSet<IntPair>(children.size());
                    for (IntPair c : children) {
                        int newIfindex;
                        byte[] fwwn2;
                        int[] newPair = new int[]{c._pair[0], c._pair[1]};
                        if (IfIndexUtil.isFmWwnPidIdx(c._pair[0])) {
                            fwwn2 = IfIndexUtil.fmIfIndex2Fwwm(c._pair[0], sw1.getSwitchPK()._wwn.getValue());
                            newPair[0] = newIfindex = sw1.getBase().ifWwn2IfIndex(fwwn2, IfIndexIf.FwwnInfo.PcMember);
                            this._pendingLinks.remove(new SwitchIfWwnKey(sw1.getSwitchPK(), new Wwn(fwwn2)));
                        }
                        if (IfIndexUtil.isFmWwnPidIdx(c._pair[1])) {
                            fwwn2 = IfIndexUtil.fmIfIndex2Fwwm(c._pair[1], sw2.getSwitchPK()._wwn.getValue());
                            newPair[1] = newIfindex = sw2.getBase().ifWwn2IfIndex(fwwn2, IfIndexIf.FwwnInfo.PcMember);
                            this._pendingLinks.remove(new SwitchIfWwnKey(sw2.getSwitchPK(), new Wwn(fwwn2)));
                        }
                        newChildren.add(new IntPair(newPair));
                    }
                    isl.setPcMember(newChildren);
                    if (!_Logger.isDebugEnabled()) continue;
                    _Logger.debug((Object)(key + " new PC==>" + isl));
                    continue;
                }
                if (!(link instanceof NpvLinkImpl)) continue;
                NpvLinkImpl npvl = (NpvLinkImpl)link;
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(key + " old NPV==>" + npvl));
                }
                int fpIndex = npvl.getFPortIfIndex();
                int npIndex = npvl.getNpPortIfIndex();
                SwitchImpl coreSw = npvl.getCoreSwitch();
                SwitchImpl npvSw = npvl.getEdgeSwitch();
                int fIfindex = coreSw.getBase().getIfIndexByFwwnInMap(npvl.getFPortWwn());
                int npIfindex = npvSw.getBase().getIfIndexByFwwnInMap(npvl.getNpPortWwn());
                if (IfIndexUtil.isFmIfIndex(npvl.getFPortIfIndex())) {
                    fwwn = IfIndexUtil.fmIfIndex2Fwwm(npvl.getFPortIfIndex(), coreSw.getSwitchPK()._wwn.getValue());
                    fpIndex = coreSw.getBase().ifWwn2IfIndex(fwwn, IfIndexIf.FwwnInfo.NPV);
                    this._pendingLinks.remove(new SwitchIfWwnKey(coreSw.getSwitchPK(), new Wwn(fwwn)));
                } else if (coreSw.findPort(fpIndex) == null) {
                    fpIndex = coreSw.getBase().ifWwn2IfIndex(npvl.getFPortWwn().getValue(), IfIndexIf.FwwnInfo.NPV);
                    this._pendingLinks.remove(new SwitchIfWwnKey(coreSw.getSwitchPK(), npvl.getFPortWwn()));
                } else if (fIfindex != -1 && fIfindex != fpIndex) {
                    fpIndex = fIfindex;
                    this._pendingLinks.remove(new SwitchIfWwnKey(coreSw.getSwitchPK(), npvl.getFPortWwn()));
                }
                if (IfIndexUtil.isFmIfIndex(npvl.getNpPortIfIndex())) {
                    fwwn = IfIndexUtil.fmIfIndex2Fwwm(npvl.getNpPortIfIndex(), npvSw.getSwitchPK()._wwn.getValue());
                    npIndex = npvSw.getBase().ifWwn2IfIndex(fwwn, IfIndexIf.FwwnInfo.NPV);
                    this._pendingLinks.remove(new SwitchIfWwnKey(npvSw.getSwitchPK(), new Wwn(fwwn)));
                } else if (npvSw.findPort(npIndex) == null) {
                    npIndex = npvSw.getBase().ifWwn2IfIndex(npvl.getNpPortWwn().getValue(), IfIndexIf.FwwnInfo.NPV);
                    this._pendingLinks.remove(new SwitchIfWwnKey(npvSw.getSwitchPK(), npvl.getNpPortWwn()));
                } else if (npIfindex != -1 && npIfindex != npIndex) {
                    npIndex = npIfindex;
                    this._pendingLinks.remove(new SwitchIfWwnKey(npvSw.getSwitchPK(), npvl.getNpPortWwn()));
                }
                if (fpIndex != npvl.getFPortIfIndex()) {
                    NpvLinkImpl oldNpvl = npvl;
                    npvl = this.createNpvLink(coreSw, npvSw, fpIndex, npIndex, oldNpvl.getFPortWwn().getValue(), oldNpvl.getNpPortWwn().getValue());
                    if (oldNpvl.isPortChannel()) {
                        npvl.setChildren(oldNpvl.getChildren());
                        npvl.setPortChannelAutoCreated(oldNpvl.getBase().isAutoCreated());
                    }
                    for (short vsanId : oldNpvl.getVsanIds()) {
                        VsanImpl vsan = oldNpvl.getCoreSwitch().getVsan(vsanId);
                        if (vsan == null) continue;
                        vsan.addNpvLink(npvl);
                    }
                    this.removeNpvLink(oldNpvl, true);
                    this.addNpvl(npvl);
                    FcPortImpl fp = this.findSwitchPortByKey(npvl.getFPortPK());
                    if (fp != null) {
                        npvl.setOperMode((short)fp.getIfOperMode());
                        npvl.setOperStatusCause(fp.getOperStatusCause());
                        npvl.setSpeed(fp.getIfSpeed());
                        npvl.setFcConnectorType(fp.getFcConnectorType());
                    }
                } else if (npIndex != npvl.getNpPortIfIndex()) {
                    npvl.setNpPort(npvSw, npIndex, npvl.getNpPortWwn());
                }
                if (npvl.isPortChannel()) {
                    List<int[]> children = npvl.getChildren();
                    if (coreSw == null || npvSw == null || children == null) continue;
                    ArrayList<int[]> newChildren = new ArrayList<int[]>(children.size());
                    for (int[] pair : children) {
                        int newIfindex;
                        byte[] fwwn3;
                        int[] newPair = new int[]{pair[0], pair[1]};
                        if (IfIndexUtil.isFmIfIndex(pair[0])) {
                            fwwn3 = IfIndexUtil.fmIfIndex2Fwwm(pair[0], coreSw.getSwitchPK()._wwn.getValue());
                            newPair[0] = newIfindex = coreSw.getBase().ifWwn2IfIndex(fwwn3, IfIndexIf.FwwnInfo.PcMember);
                            this._pendingLinks.remove(new SwitchIfWwnKey(coreSw.getSwitchPK(), new Wwn(fwwn3)));
                        }
                        if (IfIndexUtil.isFmIfIndex(pair[1])) {
                            fwwn3 = IfIndexUtil.fmIfIndex2Fwwm(pair[1], npvSw.getSwitchPK()._wwn.getValue());
                            newPair[1] = newIfindex = npvSw.getBase().ifWwn2IfIndex(fwwn3, IfIndexIf.FwwnInfo.PcMember);
                            this._pendingLinks.remove(new SwitchIfWwnKey(npvSw.getSwitchPK(), new Wwn(fwwn3)));
                        }
                        newChildren.add(newPair);
                    }
                    npvl.setChildren(newChildren);
                }
                if (!_Logger.isDebugEnabled()) continue;
                _Logger.debug((Object)(key + " new NPV==>" + npvl));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int[] findEPortIfIndexesBySwitchPK(WwnKey swPK) {
        IntArray ifIndexes = new IntArray(this._islBySwitchIntKey.size() / 2);
        for (SwitchIntKey sikey : this._islBySwitchIntKey.keySet()) {
            if (!sikey._swPK.equals(swPK)) continue;
            ifIndexes.add(sikey._index);
        }
        return ifIndexes.size() == 0 ? null : ifIndexes.toArray();
    }

    public List<SwitchImpl> findAdjacentSwitches(SwitchImpl sw) {
        ArrayList<SwitchImpl> sws = new ArrayList<SwitchImpl>();
        for (IslImpl isl : this._islBySwitchIntKey.values()) {
            SwitchImpl sw1 = isl.getSwitch1();
            SwitchImpl sw2 = isl.getSwitch2();
            if (sw1.equals(sw) && !sws.contains(sw2)) {
                sws.add(sw2);
                continue;
            }
            if (!sw2.equals(sw) || sws.contains(sw1)) continue;
            sws.add(sw1);
        }
        return sws;
    }

    public int getNumNpvLinks() {
        return this._npvLinkByFPortPK.size();
    }

    public NpvLinkImpl[] getNpvLinks() {
        return this._npvLinkByFPortPK.values().toArray(new NpvLinkImpl[this._npvLinkByFPortPK.size()]);
    }

    public List<NpvLinkImpl> findNpvLinksByCoreSwitch(SwitchImpl coresw) {
        List<NpvLinkImpl> npvls;
        if (this._npvLinkByFPortPK.size() == 0) {
            npvls = Collections.emptyList();
        } else {
            npvls = new ArrayList();
            for (NpvLinkImpl npvl : this._npvLinkByFPortPK.values()) {
                if (npvl.getCoreSwitch() != coresw) continue;
                npvls.add(npvl);
            }
        }
        return npvls;
    }

    public List<NpvLinkImpl> findNpvLinksByEdgeSwitch(SwitchImpl edgesw) {
        List<NpvLinkImpl> npvls;
        if (this._npvLinkByFPortPK.size() == 0) {
            npvls = Collections.emptyList();
        } else {
            npvls = new ArrayList();
            for (NpvLinkImpl npvl : this._npvLinkByFPortPK.values()) {
                if (npvl.getEdgeSwitch() != edgesw) continue;
                npvls.add(npvl);
            }
        }
        return npvls;
    }

    public NpvLinkImpl findNpvLink(SwitchImpl sw, int ifIndex) {
        SwitchIntKey swIntKey = new SwitchIntKey(sw.getSwitchPK(), ifIndex);
        return this.findNpvLink(swIntKey);
    }

    public NpvLinkImpl findNpvLink(SwitchIntKey swIntKey) {
        return swIntKey == null ? null : this._npvLinkByFPortPK.get(swIntKey);
    }

    public NpvLinkImpl createNpvLink(SwitchImpl coresw, SwitchImpl edgesw, int fpIfIndex, int npIfIndex, byte[] fwwn, byte[] npwwn) {
        NpvLinkImpl npvl = this.findNpvLink(coresw, fpIfIndex);
        IslImpl isl = null;
        if (npvl == null) {
            isl = this.findIsl(coresw, fpIfIndex);
            if (isl != null && isl == this.findIsl(edgesw, npIfIndex)) {
                this.removeIsl(isl);
                try {
                    InventoryPersistentManager.getInstance().purgeIsl(isl);
                }
                catch (Exception e) {
                    _Logger.warn((Object)("[FabricImpl]Cannot remove the ISL from database:" + isl));
                }
            }
            npvl = new NpvLinkImpl(coresw, fpIfIndex, new Wwn(fwwn));
            this._npvLinkByFPortPK.put(npvl.getFPortPK(), npvl);
        }
        if (npwwn != null) {
            npvl.setNpPort(edgesw, npIfIndex, new Wwn(npwwn));
        }
        npvl.syncLastScanTime();
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("[FabricImpl]check NPVlink:" + npvl));
            _Logger.trace((Object)("[FabricImpl]find ISL:" + isl));
        }
        boolean added = false;
        if (npvl.getDBID() != 0L) {
            added = true;
            this._npvlByDbId.put(npvl.getDBID(), npvl);
        }
        if (added) {
            this.modelObjectAdded(npvl);
        }
        return npvl;
    }

    public void removeNpvLink(NpvLinkImpl npvl) {
        this.removeNpvLink(npvl, true);
    }

    public void removeNpvLink(NpvLinkImpl npvl, boolean removeFromDB) {
        this.removeNpvLink(npvl, removeFromDB, true);
    }

    public void removeNpvLink(NpvLinkImpl npvl, boolean removeFromDB, boolean needlog) {
        SwitchImpl sw;
        boolean removed;
        boolean bl = removed = this._npvLinkByFPortPK.remove(npvl.getFPortPK()) != null;
        if (removeFromDB && npvl.getDBID() != 0L) {
            this._npvlByDbId.remove(npvl.getDBID());
        }
        if ((sw = npvl.getCoreSwitch()) != null) {
            short[] vids;
            for (short vid : vids = sw.getVsanIds()) {
                VsanImpl vsan = sw.getVsan(vid);
                if (vsan == null) continue;
                vsan.removeNpvLink(npvl);
            }
        }
        if (removed) {
            this.modelObjectRemoved(npvl.getPK(), removeFromDB, needlog);
        }
    }

    public void addNpvl(NpvLinkImpl npvl) {
        boolean added = false;
        if (npvl.getDBID() != 0L) {
            added = true;
            this._npvlByDbId.put(npvl.getDBID(), npvl);
        }
        if (added) {
            this.modelObjectAdded(npvl);
        }
    }

    public List<SwitchImpl> getNpvDevices() {
        List<SwitchImpl> npvs;
        if (this._npvLinkByFPortPK.size() == 0) {
            npvs = Collections.emptyList();
        } else {
            npvs = new ArrayList();
            for (NpvLinkImpl npvl : this._npvLinkByFPortPK.values()) {
                SwitchImpl npv = npvl.getEdgeSwitch();
                if (npvs.contains(npv)) continue;
                npvs.add(npv);
            }
        }
        return npvs;
    }

    public List<SwitchImpl> getFCoESwitches() {
        ArrayList<SwitchImpl> fcoeSws = new ArrayList<SwitchImpl>();
        for (SwitchImpl sw : this.getSwitches()) {
            if (!sw.getBase().isFCoEEnabled()) continue;
            fcoeSws.add(sw);
        }
        return fcoeSws;
    }

    public List<IslImpl> getFCoEIsls() {
        ArrayList<IslImpl> fcoeIsls = new ArrayList<IslImpl>();
        for (IslImpl isl : this.getIsls()) {
            if (isl.getSwitch1() != null && isl.getSwitch1().getBase().getType(isl.getIfIndex1()) == 30) {
                fcoeIsls.add(isl);
                continue;
            }
            if (isl.getSwitch2() != null && isl.getSwitch2().getBase().getType(isl.getIfIndex2()) == 30) {
                fcoeIsls.add(isl);
                continue;
            }
            if (IfIndexUtil.getType(isl.getIfIndex1()) != 30) continue;
            fcoeIsls.add(isl);
        }
        return fcoeIsls;
    }

    public EndPortImpl[] getFCoEEndPorts() {
        HashMap<WwnKey, EndPortImpl> map = new HashMap<WwnKey, EndPortImpl>();
        for (VsanImpl v : this._vsanByPK.values()) {
            for (EndPortImpl ep : v.getEndPorts()) {
                if (!ep.isFCoE()) continue;
                map.put(ep.getEndPortPK(), ep);
            }
        }
        Collection list = map.values();
        return list.toArray(new EndPortImpl[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumEndPorts() {
        int num = 0;
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            for (VsanImpl v : this._vsanByPK.values()) {
                num += v.getNumEndPorts();
            }
        }
        return num;
    }

    public EndPortImpl[] getEndPorts() {
        HashMap<WwnKey, EndPortImpl> map = new HashMap<WwnKey, EndPortImpl>();
        for (VsanImpl v : this._vsanByPK.values()) {
            for (EndPortImpl ep : v.getEndPorts()) {
                map.put(ep.getEndPortPK(), ep);
            }
        }
        Collection list = map.values();
        return list.toArray(new EndPortImpl[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EndPortImpl> findEndPortsBySwitchIfIndex(SwitchImpl sw, int ifIndex) {
        WwnKey swPK = sw.getSwitchPK();
        ArrayList<EndPortImpl> epList = new ArrayList<EndPortImpl>();
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            for (VsanImpl vsan : this._vsanByPK.values()) {
                for (EndPortImpl ep : vsan.getEndPorts()) {
                    if (!swPK.equals(ep.getSwitchPK()) || ep.getIfIndex() != ifIndex) continue;
                    epList.add(ep);
                }
            }
        }
        return epList;
    }

    public ArrayList<EndPortImpl> findEndPortsBySwitchIfIndex(FabricPK fpk, WwnKey swPK, int ifIndex) {
        return SanManager.getInstance().findEndportsBySwitchIfIndex(fpk, swPK, ifIndex);
    }

    public EndPortImpl[] findEndPortsBySwitch(SwitchImpl sw) {
        if (sw == null) {
            return null;
        }
        WwnKey swPK = sw.getSwitchPK();
        ArrayList<EndPortImpl> epList = new ArrayList<EndPortImpl>();
        for (VsanImpl vsan : this._vsanByPK.values()) {
            for (EndPortImpl ep : vsan.getEndPorts()) {
                if (!swPK.equals(ep.getSwitchPK())) continue;
                epList.add(ep);
            }
        }
        return epList.toArray(new EndPortImpl[epList.size()]);
    }

    public ArrayList getTargets() {
        return this.getEndPorts(true);
    }

    public ArrayList getInitiators() {
        return this.getEndPorts(false);
    }

    ArrayList<EndPortImpl> getEndPorts(boolean needTarget) {
        ArrayList<EndPortImpl> list = new ArrayList<EndPortImpl>();
        for (VsanImpl vsan : this._vsanByPK.values()) {
            for (EndPortImpl ep : vsan.getEndPorts()) {
                if (ep.getEnclosure() != null) {
                    List<EndPortImpl> l = ep.getEnclosure().getEndPorts();
                    if (l == null || l.size() == 0 || ep.getEnclosure().isStorage() != needTarget) continue;
                    list.add(ep);
                    continue;
                }
                if (ep.isTarget() != needTarget) continue;
                list.add(ep);
            }
        }
        return list;
    }

    public int[] findFxPortIfIndexesBySwitchPK(WwnKey swPK) {
        IntArray ifIndexes = new IntArray();
        for (VsanImpl vsan : this._vsanByPK.values()) {
            List<EndPortImpl> eps = vsan.getEndPorts();
            for (EndPortImpl ep : eps) {
                if (!swPK.equals(ep.getSwitchPK()) || ifIndexes.contains(ep.getIfIndex())) continue;
                ifIndexes.add(ep.getIfIndex());
            }
        }
        return ifIndexes.toArray();
    }

    public FcPortAlias createDeviceAlias(Wwn pwwn, String alias, long dbid, int cfsRegionId) {
        FcPortAlias ret = this.createDeviceAlias(pwwn, alias, cfsRegionId);
        if (ret != null) {
            ret.setDBID(dbid);
            this._deviceAliasByDbId.put(dbid, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortAlias createDeviceAlias(Wwn pwwn, String alias, int cfsRegionId) {
        FcPortAlias oldDa = null;
        FcPortAlias da = null;
        if (this._allVsanScopefabricBase != null) {
            oldDa = this._allVsanScopefabricBase.getDeviceAlias(alias, cfsRegionId);
            if (oldDa != null) {
                oldDa = new FcPortAlias(alias, oldDa.getWwn(), cfsRegionId);
            }
            da = this._allVsanScopefabricBase.createDeviceAlias(pwwn, alias, cfsRegionId);
            FabricPK fabricPK = this._pkey;
            synchronized (fabricPK) {
                if (oldDa == null) {
                    this.modelObjectChanged(this._pkey, (short)521, null, da);
                } else if (oldDa.getWwn() != null && !oldDa.getWwn().equals(pwwn)) {
                    this.modelObjectChanged(this._pkey, (short)521, oldDa, da);
                }
            }
        }
        return da;
    }

    public int getNumDeviceAliases() {
        return this._cachedFabric != null ? this._cachedFabric.getDeviceAlliasCount() : 0;
    }

    public FcPortAlias[] getDeviceAliases() {
        if (this._allVsanScopefabricBase != null) {
            return this._allVsanScopefabricBase.getDeviceAliasesByWwn();
        }
        return new FcPortAlias[0];
    }

    public ArrayList<String> getDeviceAliasNames() {
        return this._allVsanScopefabricBase != null ? this._allVsanScopefabricBase.getDeviceAliasNames() : new ArrayList<String>();
    }

    public ArrayList<String> getDeviceAliasNames(int regionId) {
        return this._allVsanScopefabricBase != null ? this._allVsanScopefabricBase.getDeviceAliasNames(regionId) : new ArrayList();
    }

    public FcPortAlias getDeviceAlias(String alias) {
        return this.getDeviceAlias(alias, -1);
    }

    public FcPortAlias getDeviceAlias(String alias, int cfsRegionId) {
        FcPortAlias da = null;
        if (this._allVsanScopefabricBase != null) {
            da = this._allVsanScopefabricBase.getDeviceAlias(alias, cfsRegionId);
        }
        return da;
    }

    public void removeDeviceAlias(String alias) {
        this.removeDeviceAlias(alias, -1);
    }

    public void removeDeviceAlias(String alias, int regionId) {
        FcPortAlias da;
        if (this._allVsanScopefabricBase != null && (da = this._allVsanScopefabricBase.getDeviceAlias(alias, regionId)) != null) {
            EndPortImpl ep;
            this._allVsanScopefabricBase.removeDeviceAlias(alias, regionId);
            if (da.getDBID() != 0L) {
                FcPortAlias removedObj = this._deviceAliasByDbId.remove(da.getDBID());
                this._deviceAliasRemoveList.add(removedObj);
            }
            this.modelObjectChanged(this._pkey, (short)521, da, null);
            FcPortAlias daFromWwn = this._allVsanScopefabricBase.getDeviceAliasWwn(da.getWwn());
            if (daFromWwn != null && daFromWwn.getAlias() != null && daFromWwn.getAlias().equals(alias) && daFromWwn.getCfsRegionId() == regionId) {
                this._allVsanScopefabricBase.removeDeviceAliasWwn(da.getWwn());
            }
            if ((ep = SanManager.getInstance().findEndPort(da.getWwn(), this.getPK())) != null) {
                ep.setAutoAlias(ep.createAutoAlias());
            }
        }
    }

    public void addAlias(FcPortAlias alias) {
        if (alias.getDBID() != 0L) {
            this._deviceAliasByDbId.put(alias.getDBID(), alias);
        }
    }

    public FcPortAlias findDeviceAliasByName(String name) {
        return this._allVsanScopefabricBase != null ? this._allVsanScopefabricBase.getDeviceAlias(name) : null;
    }

    public FcPortAlias findDeviceAliasByWwn(Wwn wwn) {
        return this._allVsanScopefabricBase != null ? this._allVsanScopefabricBase.getDeviceAliasWwn(wwn) : null;
    }

    public void setDeviceAliasChecksum(int regionId, byte[] checksum) {
        if (checksum == null) {
            checksum = new byte[]{0, 0};
        }
        this._deviceAliasChecksum.put(new Integer(regionId), checksum);
    }

    public byte[] getDeviceAliasChecksum(int regionId) {
        return this._deviceAliasChecksum == null ? null : this._deviceAliasChecksum.get(new Integer(regionId));
    }

    public void setLicenseId(int id) {
        this._licenseId = id;
    }

    public int getLicenseId() {
        return this._licenseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterImpl createCluster(ClusterPK ckey, short type, short state, short masterInetAddrType, String masterInetAddr, SwitchImpl sw) {
        boolean notPreexist;
        ClusterImpl cl;
        ConcurrentHashMap<ClusterPK, ClusterImpl> concurrentHashMap = this._clusterByPK;
        synchronized (concurrentHashMap) {
            cl = this._clusterByPK.get(ckey);
            notPreexist = cl == null;
            if (notPreexist) {
                cl = new ClusterImpl(ckey, type, state, masterInetAddrType, masterInetAddr, sw);
                cl.setFabric(this);
                this._clusterByPK.put(ckey, cl);
                this._clusterNameById.put(ckey.getCid(), ckey.getName());
            }
        }
        if (notPreexist) {
            this.modelObjectAdded(cl);
        } else {
            cl.setState(state);
            cl.setMasterInetAddrType(masterInetAddrType);
            cl.setMasterInetAddr(masterInetAddr);
        }
        return cl;
    }

    public ClusterImpl findCluster(ClusterPK cPK) {
        if (cPK == null) {
            return null;
        }
        return this._clusterByPK.get(cPK);
    }

    public ClusterImpl[] getClusters() {
        return this._clusterByPK.values().toArray(new ClusterImpl[this._clusterByPK.size()]);
    }

    public ArrayList<ClusterImpl> getClusterList() {
        ArrayList<ClusterImpl> list = new ArrayList<ClusterImpl>(this._clusterByPK.values());
        return list;
    }

    public void removeCluster(ClusterImpl da) {
        if (this._clusterByPK.remove(da.getClusterPK()) != null) {
            this._clusterNameById.remove(((ClusterPK)da.getClusterPK()).getCid());
            if (da.getDBID() != 0L) {
                this._clusterByDbId.remove(da.getDBID());
            }
            this.modelObjectRemoved(da.getClusterPK());
        }
    }

    public String findClusterName(String cId) {
        if (cId == null) {
            return null;
        }
        return this._clusterNameById.get(cId);
    }

    public ArrayList<ClusterImpl> getPreClusters() {
        return this._preClusters;
    }

    public ArrayList<ClusterImpl> setPreClusters(ArrayList<ClusterImpl> preClusters) {
        this._preClusters = preClusters;
        return this._preClusters;
    }

    public String getIncludedVsanList() {
        return this._allVsanScopefabricBase == null ? null : this._allVsanScopefabricBase.getIncludedVsanList();
    }

    public void setIncludedVsanList(String includedVsanList) {
        if (this._allVsanScopefabricBase != null) {
            this._allVsanScopefabricBase.setIncludedVsanList(includedVsanList);
        }
    }

    public String getExcludedVsanList() {
        return this._allVsanScopefabricBase == null ? null : this._allVsanScopefabricBase.getExcludedVsanList();
    }

    public void setExcludedVsanList(String excludedVsanList) {
        if (this._allVsanScopefabricBase != null) {
            this._allVsanScopefabricBase.setExcludedVsanList(excludedVsanList);
        }
    }

    public void setFcAlias(boolean b) {
        this._useFcAlias = b;
        if (this._allVsanScopefabricBase != null) {
            this._allVsanScopefabricBase.useFcAlias(b);
        }
    }

    public EnclosureImpl[] getEnclosures(int type) {
        ArrayList<EnclosureImpl> encls = new ArrayList<EnclosureImpl>();
        for (VsanImpl vsan : this._vsanByPK.values()) {
            Iterator<EndPortImpl> en = vsan.getEndPorts().iterator();
            while (en.hasNext()) {
                EnclosureImpl enc = en.next().getEnclosure();
                if (enc == null || type != 3 && (!enc.isStorage() || (type & 2) != 2) && (enc.isStorage() || (type & 1) != 1) || encls.contains(enc)) continue;
                encls.add(enc);
            }
        }
        Collections.sort(encls);
        return encls.toArray(new EnclosureImpl[encls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int findInAddedList(PKIf pkey) {
        List<AbstractModelObjectImpl> list = this._added;
        synchronized (list) {
            for (int i = 0; i < this._added.size(); ++i) {
                AbstractModelObjectImpl o = this._added.get(i);
                if (o == null) {
                    _Logger.error((Object)("model object #" + i + " in added list(" + this._added.size() + ") is null"));
                    continue;
                }
                PKIf pk = o.getPK();
                if (pk == null) {
                    _Logger.error((Object)("model object " + o.toString() + " key is null"));
                    continue;
                }
                if (!pk.equals(pkey)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modelObjectChanged(PKIf objKey, short propId, Serializable oldValue, Serializable newValue) {
        if (propId != 1038 && (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3 || this._status.get() == 6)) {
            return;
        }
        if (objKey == null) {
            _Logger.warn((Object)("FabricImpl::modelObjectChanged has null PK: " + objKey));
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                if (propId != 521 && propId != 786 && propId != 1047 && propId != 1802) {
                    for (int i = 0; i < this._changed.size(); ++i) {
                        ChangedModelObject chgObj = this._changed.get(i);
                        if (chgObj._propId != propId || !chgObj.getPK().equals(objKey)) continue;
                        if (FabricImpl.equals(propId, chgObj.getOldValue(), newValue)) {
                            this._changed.remove(i);
                        } else {
                            chgObj.setNewValue(newValue);
                        }
                        return;
                    }
                }
                this._changed.add(new ChangedModelObject(objKey, propId, oldValue, newValue));
            }
        } else {
            SanManager.notifyMembersChanged(this, new ChangedModelObject[]{new ChangedModelObject(objKey, propId, oldValue, newValue)});
        }
    }

    void modelObjectAdded(AbstractModelObjectImpl modelObj) {
        this.modelObjectAdded(modelObj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modelObjectAdded(AbstractModelObjectImpl modelObj, boolean needlog) {
        if (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3) {
            return;
        }
        if (modelObj.getPK() == null) {
            _Logger.warn((Object)("FabricImpl::modelObjectAdded has null PK: " + modelObj));
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                if (!needlog) {
                    this._addedNoLog.add(modelObj);
                } else if (this.findInAddedList(modelObj.getPK()) == -1) {
                    this._added.add(modelObj);
                }
                Iterator<ChangedModelObject> it = this._changed.iterator();
                while (it.hasNext()) {
                    ChangedModelObject chgObj = it.next();
                    if (!chgObj.getPK().equals(modelObj.getPK())) continue;
                    it.remove();
                }
            }
        } else {
            SanManager.notifyMembersAdded(this, new AbstractModelObjectImpl[]{modelObj}, needlog);
        }
    }

    void modelObjectRemoved(PKIf moKey, boolean purge) {
        this.modelObjectRemoved(moKey, purge, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modelObjectRemoved(PKIf moKey, boolean purge, boolean needlog) {
        if (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3 || this._status.get() == 6) {
            return;
        }
        if (moKey == null) {
            _Logger.warn((Object)("FabricImpl::modelObjectRemoved has null PK: " + moKey));
            return;
        }
        if (this._bufInUse.get() && !purge) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                int index = this.findInAddedList(moKey);
                if (index != -1) {
                    this._added.remove(index);
                } else if (!this._addedNoLog.remove(moKey)) {
                    if (needlog && !this._removed.contains(moKey)) {
                        this._removed.add(moKey);
                    } else if (!needlog) {
                        this._removedNoLog.add(moKey);
                    }
                }
            }
        } else {
            SanManager.notifyMembersRemoved(this, new PKIf[]{moKey}, needlog);
        }
    }

    void modelObjectRemoved(PKIf moKey) {
        this.modelObjectRemoved(moKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelObjectMoved(PKIf objKey, PKIf oldAssocKey, PKIf newAssocKey) {
        if (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3 || this._status.get() == 6) {
            return;
        }
        if (objKey == null) {
            _Logger.warn((Object)("FabricImpl::modelObjectMoved has null PK: " + objKey));
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                if (this.findInAddedList(objKey) == -1 && !this._addedNoLog.contains(objKey)) {
                    for (int i = 0; i < this._moved.size(); ++i) {
                        MovedModelObject movObj = this._moved.get(i);
                        if (!movObj.getObjectPK().equals(objKey)) continue;
                        if (GenUtil.equals(movObj.getOldAssocPK(), newAssocKey)) {
                            this._moved.remove(i);
                        } else {
                            movObj.setNewParent(newAssocKey);
                        }
                        return;
                    }
                    this._moved.add(new MovedModelObject(objKey, oldAssocKey, newAssocKey));
                }
            }
        } else {
            SanManager.notifyMembersMoved(this, new MovedModelObject[]{new MovedModelObject(objKey, oldAssocKey, newAssocKey)});
        }
    }

    public void checkDelta() {
    }

    boolean isFabricEmpty() {
        return this.getNumSwitches() == 0 && this.getFarbicStatus() != 5 && this.getFarbicStatus() != 6;
    }

    void checkVsanPresence() {
        int i;
        VsanImpl[] vsans = this.getVsans();
        for (i = 0; i < vsans.length; ++i) {
            block5: {
                VsanImpl v = vsans[i];
                v.createEnclosure();
                if (v.getLastScanTime() < this._lastScanTime && (v.getId() != 1 || this.isVsanSegmented(1))) {
                    List<SwitchImpl> sws = v.getSwitches();
                    for (SwitchImpl sw : sws) {
                        if (sw.getVsan(v.getId()) == v) continue;
                        v.removeSwitch(sw);
                    }
                    sws = v.getSwitches();
                    for (SwitchImpl sw : sws) {
                        if (!sw.isMDS() || sw.isManageable() && (!sw.isManageable() || !sw.isManageTimeOut())) continue;
                        break block5;
                    }
                    this.removeVsan(v);
                    _Logger.info((Object)("VSAN " + v.getName() + " purged"));
                    continue;
                }
            }
            vsans[i].setSegmented(this.isVsanSegmented(vsans[i].getId()));
        }
        vsans = this.getVsans();
        for (i = 0; i < vsans.length; ++i) {
            if (!vsans[i].isSegmented()) continue;
            vsans[i].setSegmented(this.isVsanSegmented(vsans[i].getId()));
        }
    }

    void checkCfsRegionPresence() {
        CfsRegionImpl[] regions = this.getCfsRegions();
        for (int i = 0; i < regions.length; ++i) {
            CfsRegionImpl r = regions[i];
            if (r == null) continue;
            if (this.getSwitches(r.getCfsRegionPK()).length == 0) {
                this.removeCfsRegion(r);
            }
            _Logger.info((Object)("Cfs Region " + r.getId() + " purged"));
        }
    }

    void updateIslFcsp() {
        IslImpl[] isls = this.getIsls();
        for (int i = 0; i < isls.length; ++i) {
            IslImpl isl = isls[i];
            SwitchImpl sw1 = isl.getSwitch1();
            SwitchImpl sw2 = isl.getSwitch2();
            SwitchIntKey key1 = isl.getSwitch1IntKey();
            SwitchIntKey key2 = isl.getSwitch2IntKey();
            FcPortBase port1 = sw1.findPort(key1._index);
            FcPortBase port2 = sw2.findPort(key2._index);
            if (!(!isl.isPortChannel() || sw1.isVersionGreaterThanEqual("5.0(0)") && sw2.isVersionGreaterThanEqual("5.0(0)"))) {
                FcPortBase port1s = null;
                FcPortBase port2s = null;
                boolean fcspAuthens = true;
                boolean espReadys = true;
                boolean espSecures = true;
                List<int[]> children = isl.getChildren();
                if (children != null) {
                    for (int[] pair : children) {
                        port1s = sw1.findPort(pair[0]);
                        boolean[] trustSecs = this.getIslTrustSecs(sw1, sw2, port1s, port2s = sw2.findPort(pair[1]), null);
                        if (trustSecs == null) {
                            fcspAuthens = false;
                            espReadys = false;
                            espSecures = false;
                            continue;
                        }
                        isl.createTrustSecs(pair, trustSecs);
                        if (!trustSecs[0]) {
                            fcspAuthens = false;
                        }
                        if (!trustSecs[1]) {
                            espReadys = false;
                        }
                        if (trustSecs[2]) continue;
                        espSecures = false;
                    }
                    isl.setFcspAuthenticated(fcspAuthens);
                    isl.setEspReady(espReadys);
                    isl.setEspSecure(espSecures);
                    continue;
                }
                _Logger.warn((Object)("Cannot get children from the port channel:" + isl));
                continue;
            }
            boolean[] trustSecs = this.getIslTrustSecs(sw1, sw2, port1, port2, isl);
            if (trustSecs == null) {
                isl.setFcspAuthenticated(false);
                isl.setEspReady(false);
                isl.setEspSecure(false);
                continue;
            }
            isl.setFcspAuthenticated(trustSecs[0]);
            isl.setEspReady(trustSecs[1]);
            isl.setEspSecure(trustSecs[2]);
        }
    }

    private boolean[] getIslTrustSecs(SwitchImpl sw1, SwitchImpl sw2, FcPortBase port1, FcPortBase port2, IslImpl isl) {
        if (sw1 == null || sw2 == null || port1 == null || port2 == null) {
            return null;
        }
        boolean[] trustSecs = new boolean[3];
        boolean fcspAuthenticated = false;
        boolean espReady = false;
        boolean espSecure = false;
        if (sw1.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag()) && sw2.isFeatureEnabled(AbstractSwitchBase.Feature.FCSP.flag())) {
            if (!(port1.getFcspMode() != 2 && port1.getFcspMode() != 3 && port1.getFcspMode() != 4 || port2.getFcspMode() != 2 && port2.getFcspMode() != 3 && port2.getFcspMode() != 4 || port1.getFcspMode() == 2 && port2.getFcspMode() == 2)) {
                fcspAuthenticated = true;
            }
            if (port1.getFcspMode() == 4 && port2.getFcspMode() == 4) {
                espReady = true;
                if (port1.getFcspEspMode() == 2 || port1.getFcspEspMode() == 3 || port2.getFcspEspMode() == 2 || port2.getFcspEspMode() == 3) {
                    espSecure = true;
                }
            }
        }
        trustSecs[0] = fcspAuthenticated;
        trustSecs[1] = espReady;
        trustSecs[2] = espSecure;
        return trustSecs;
    }

    public PKIf[] purgeAll() throws Exception {
        if (this.isDiscovering()) {
            throw new SanException(FABRIC_IS_BUSY);
        }
        ArrayList<PKIf> purgedKeys = new ArrayList<PKIf>(5);
        purgedKeys.addAll(this.purgeSwitches());
        purgedKeys.addAll(this.purgeIsls());
        purgedKeys.addAll(this.purgeNpvLinks());
        purgedKeys.addAll(this.purgeEndPorts());
        PKIf[] pkeys = null;
        if (purgedKeys.size() != 0) {
            pkeys = purgedKeys.toArray(new PKIf[purgedKeys.size()]);
        }
        SanManager.notifyMembersPurged(this, pkeys);
        return pkeys;
    }

    Collection<IslPK> purgeIsls() {
        Hashtable<PKIf, IslImpl> purgedIsls = new Hashtable<PKIf, IslImpl>();
        Object[] vobjs = this._vsanByPK.values().toArray();
        for (int i = 0; i < vobjs.length; ++i) {
            VsanImpl v = (VsanImpl)vobjs[i];
            List<IslImpl> list = v.purgeIsls();
            if (list == null) continue;
            for (IslImpl isl : list) {
                this._islBySwitchIntKey.remove(isl.getSwitch1IntKey());
                this._islBySwitchIntKey.remove(isl.getSwitch2IntKey());
                if (purgedIsls.containsKey(isl.getIslPK())) continue;
                this._islByDbId.remove(isl.getDBID());
                purgedIsls.put(isl.getIslPK(), isl);
            }
        }
        SanManager sm = SanManager.getInstance();
        IslImpl[] isls = this._islBySwitchIntKey.values().toArray(new IslImpl[this._islBySwitchIntKey.size()]);
        for (int i = 0; i < isls.length; ++i) {
            if (isls[i].isPresent() && sm.findSwitch(isls[i].getSwitch1IntKey()._swPK, this.getPK()) != null && sm.findSwitch(isls[i].getSwitch2IntKey()._swPK, this.getPK()) != null) continue;
            this._islBySwitchIntKey.remove(isls[i].getSwitch1IntKey());
            this._islBySwitchIntKey.remove(isls[i].getSwitch2IntKey());
            this._islByDbId.remove(isls[i].getDBID());
            if (purgedIsls.containsKey(isls[i].getPK())) continue;
            purgedIsls.put(isls[i].getPK(), isls[i]);
        }
        try {
            IslImpl[] tobePurged = purgedIsls.values().toArray(new IslImpl[purgedIsls.size()]);
            InventoryPersistentManager.getInstance().purgeIsls(tobePurged);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Purge ISL from db: " + ex.getMessage()));
        }
        return purgedIsls.keySet();
    }

    public Collection<SwitchIntKey> purgeNpvLinks() {
        NpvLinkImpl[] npvLinks;
        VsanImpl[] vsans;
        HashMap<SwitchIntKey, NpvLinkImpl> purgedFabricNpvLinks = new HashMap<SwitchIntKey, NpvLinkImpl>();
        for (VsanImpl vsan : vsans = this._vsanByPK.values().toArray(new VsanImpl[this._vsanByPK.values().size()])) {
            List<NpvLinkImpl> purgedVsanNpvLinks = vsan.purgeNpvLinks();
            for (NpvLinkImpl npvLink : purgedVsanNpvLinks) {
                this._npvLinkByFPortPK.remove(npvLink.getFPortPK());
                this._npvlByDbId.remove(npvLink.getDBID());
                if (purgedFabricNpvLinks.containsKey(npvLink.getFPortPK())) continue;
                purgedFabricNpvLinks.put(npvLink.getFPortPK(), npvLink);
            }
        }
        for (NpvLinkImpl npvLink : npvLinks = this._npvLinkByFPortPK.values().toArray(new NpvLinkImpl[this._npvLinkByFPortPK.size()])) {
            List<ChannelMemberNpvl> pcm;
            if (!SanManager.getInstance().shouldPurgeNpvLink(npvLink)) continue;
            this._npvLinkByFPortPK.remove(npvLink.getFPortPK());
            this._npvlByDbId.remove(npvLink.getDBID());
            if (npvLink.isPortChannel() && (pcm = npvLink.getPCMemberLinks()) != null) {
                for (ChannelMemberNpvl mem : pcm) {
                    if (mem.isPresent()) continue;
                    this._npvlByDbId.remove(mem.getDBID());
                }
            }
            if (purgedFabricNpvLinks.containsKey(npvLink.getFPortPK())) continue;
            purgedFabricNpvLinks.put(npvLink.getFPortPK(), npvLink);
        }
        if (purgedFabricNpvLinks.size() > 0) {
            try {
                NpvLinkImpl[] purgedDBNpvLinks = purgedFabricNpvLinks.values().toArray(new NpvLinkImpl[purgedFabricNpvLinks.size()]);
                InventoryPersistentManager.getInstance().purgeNpvLinks(purgedDBNpvLinks);
            }
            catch (Exception e) {
                _Logger.warn((Object)("Fabric (" + this.getFabricName() + ") purged NPV links from DB:"), (Throwable)e);
            }
        }
        _Logger.info((Object)("Fabric (" + this.getFabricName() + ") purged number of NPV links: " + purgedFabricNpvLinks.size()));
        Set entries = purgedFabricNpvLinks.entrySet();
        for (Map.Entry entry : entries) {
            _Logger.info((Object)("NPV(portKey, link):" + entry.getKey() + ", " + entry.getValue()));
        }
        return purgedFabricNpvLinks.keySet();
    }

    Collection<WwnKey> purgeEndPorts() {
        Hashtable<WwnKey, EndPortImpl> purgedEndPorts = new Hashtable<WwnKey, EndPortImpl>();
        Object[] vobjs = this._vsanByPK.values().toArray();
        for (int i = 0; i < vobjs.length; ++i) {
            VsanImpl v = (VsanImpl)vobjs[i];
            List<EndPortImpl> list = v.purgeEndPorts();
            if (list == null) continue;
            for (EndPortImpl ep : list) {
                if (purgedEndPorts.containsKey(ep.getEndPortPK())) continue;
                this._endPortByDbId.remove(ep.getDBID());
                this._endPortRemoveList.add(ep);
                purgedEndPorts.put(ep.getEndPortPK(), ep);
            }
        }
        if (this._endPortByDbId != null) {
            Iterator<EndPortImpl> it = this._endPortByDbId.values().iterator();
            while (it.hasNext()) {
                EndPortImpl ep = it.next();
                VsanFcIdKey[] vsans = ep.getVsanFcIds();
                if (ep.isPresent() && vsans != null && vsans.length != 0) continue;
                it.remove();
                SanManager.getInstance().removeEndPort(ep);
                if (purgedEndPorts.containsKey(ep.getEndPortPK())) continue;
                purgedEndPorts.put(ep.getEndPortPK(), ep);
            }
        }
        try {
            EndPortImpl[] tobePurged = purgedEndPorts.values().toArray(new EndPortImpl[purgedEndPorts.size()]);
            if (_Logger.isDebugEnabled()) {
                for (int i = 0; i < tobePurged.length; ++i) {
                    _Logger.debug((Object)(" >>>>> tobePurged " + tobePurged[i]));
                }
            }
            InventoryPersistentManager.getInstance().purgeEndPorts(tobePurged);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Purge EndPort from db: " + ex.getMessage()));
        }
        return purgedEndPorts.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<PKIf> purgeSwitches() {
        Hashtable<PKIf, SwitchImpl> purgedSwitches = new Hashtable<PKIf, SwitchImpl>(5);
        List<SwitchImpl> list = this._switches;
        synchronized (list) {
            Iterator<SwitchImpl> it = this._switches.iterator();
            while (it.hasNext()) {
                SwitchImpl sw = it.next();
                if (sw.isPresent()) continue;
                it.remove();
                this._swByDbId.remove(sw.getDBID());
                this.modelObjectRemoved(sw.getPK());
                sw.setManageable(false, "not exist in the fabric");
                sw.setFabric(null);
                SanManager.getInstance().removeSwitch(sw);
                if (purgedSwitches.containsKey(sw.getSwitchPK())) continue;
                purgedSwitches.put(sw.getPK(), sw);
            }
        }
        try {
            SwitchImpl[] purgedSws = purgedSwitches.values().toArray(new SwitchImpl[purgedSwitches.size()]);
            InventoryPersistentManager.getInstance();
            InventoryPersistentManager.purgeSwitchAndComponents(purgedSws);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Purge switch from db: " + ex.getMessage()));
        }
        return purgedSwitches.keySet();
    }

    public void purgeIslsInChannels() {
        ArrayList<IslImpl> pcs = new ArrayList<IslImpl>();
        IslImpl[] isls = this.getIsls();
        for (int i = 0; i < isls.length; ++i) {
            if (isls[i].getChildren() == null || !isls[i].isPresent()) continue;
            pcs.add(isls[i]);
        }
        if (pcs.size() == 0) {
            return;
        }
        for (int i = 0; i < isls.length; ++i) {
            IslImpl pc;
            if (isls[i].getChildren() != null || (pc = FabricImpl.islInChannel(pcs, isls[i])) == null) continue;
            if (!isls[i].isPresent()) {
                this.removeIsl(isls[i]);
            }
            if (pc.isPresent() || !isls[i].isPresent()) continue;
            this.removeIsl(pc);
        }
    }

    void scheduleRefresh(int delay) {
        if (this._worker == null) {
            return;
        }
        SchedulerSingleton schdl = SchedulerSingleton.getInstance();
        Schedule sch = new Schedule(delay, (long)this._pollInterval * 1000L, false);
        if (this._worker.getState() == 1 || this._worker.getState() == 2) {
            schdl.setTaskSchedule(this._worker, sch);
        } else {
            schdl.addTask(this._worker, sch);
        }
    }

    boolean isRefreshScheduled() {
        return this._worker != null && (this._worker.getState() == 1 || this._worker.getState() == 2);
    }

    public synchronized FabricWorker getWorker() {
        if (this._worker == null) {
            this._worker = this.isBrcdNpvFabric() ? new BrcdFabricWorker(this, this._pollInterval) : new FabricWorker(this, this._pollInterval);
        }
        return this._worker;
    }

    public boolean isDiscovering() {
        return this._worker == null ? false : this._worker.isDiscovering();
    }

    public boolean isInitialDiscovery() {
        return this._worker == null || this._worker.getDiscoveryType() == DiscoveryType.FABRIC_INITIAL;
    }

    public boolean isInInitialDiscovery() {
        if (this._worker == null) {
            return false;
        }
        return this._worker.getDiscoveryType() == DiscoveryType.FABRIC_INITIAL && this._worker.isDiscovering();
    }

    public boolean isOnDemandDiscovery() {
        return this._worker != null && this._worker.getDiscoveryType() == DiscoveryType.FABRIC_ONDEMAND;
    }

    public void setDiscoveryType(DiscoveryType discType) {
        if (this._worker != null) {
            this._worker.setDiscoveryType(discType);
        }
    }

    public boolean isQuailOnly() {
        SwitchImpl[] sws = this.getSwitches();
        if (sws != null) {
            for (int i = 0; i < sws.length; ++i) {
                if (!sws[i].isMDS()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBrcdNpvFabric() {
        SwitchImpl sw = this.getSeed();
        if (sw == null) {
            return false;
        }
        return sw.isBrocade();
    }

    public SwitchImpl getSeed() {
        return this._seed;
    }

    public void selectSeedSwitch() {
        if (this._seed != null) {
            return;
        }
        SwitchImpl[] sws = this.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            if (!sws[i].isMDS() || sws[i].isNpvEnabled()) continue;
            this._seed = sws[i];
            return;
        }
    }

    public void setSeed(SwitchImpl seed) {
        PKIf oldKey = this._seed == null ? null : this._seed.getPK();
        this._seed = seed;
        if (!GenUtil.equals(seed.getPK(), oldKey)) {
            this.modelObjectChanged(this._pkey, (short)514, oldKey, this._seed.getPK());
        }
    }

    public SwitchImpl selectIvrSeed() {
        SwitchImpl seed = null;
        for (SwitchImpl sw : this._switches) {
            if (!sw.isManageableMDS() || !sw.isIvrEnabled() || sw.isNpvEnabled() || seed != null && !sw.isVersionGreaterThan(seed.getVersion()) && (sw.getIvrShowCfg() != 1 || seed.getIvrShowCfg() == 1)) continue;
            seed = sw;
        }
        return seed;
    }

    public SwitchImpl selectRegionIvrSeed(int regionId) {
        SwitchImpl seed = null;
        for (SwitchImpl sw : this._switches) {
            if (sw.getCfsRegionId("ivr") != regionId || !sw.isManageableMDS() || !sw.isIvrEnabled() || sw.isNpvEnabled() || seed != null && !sw.isVersionGreaterThan(seed.getVersion()) && (sw.getIvrShowCfg() != 1 || seed.getIvrShowCfg() == 1)) continue;
            seed = sw;
        }
        return seed;
    }

    public SwitchImpl selectAliasSeed() {
        SwitchImpl seed = null;
        SwitchImpl lastSw = null;
        Iterator<SwitchImpl> i$ = this._switches.iterator();
        while (i$.hasNext()) {
            SwitchImpl sw;
            lastSw = sw = i$.next();
            if (!sw.isManageableMDS() || sw.isNpvEnabled()) continue;
            if (seed == null || sw.getDeviceAliasShowCfg() == 1 && seed.getDeviceAliasShowCfg() != 1) {
                seed = sw;
                continue;
            }
            if (sw.getDeviceAliasShowCfg() == seed.getDeviceAliasShowCfg() && sw.isCfsFeatureEnabled() && !seed.isCfsFeatureEnabled()) {
                seed = sw;
                continue;
            }
            if (sw.getDeviceAliasShowCfg() == seed.getDeviceAliasShowCfg() && sw.isCfsFeatureEnabled() == seed.isCfsFeatureEnabled() && sw.getDeviceAliasMode() > seed.getDeviceAliasMode()) {
                seed = sw;
                continue;
            }
            if (sw.getDeviceAliasShowCfg() != seed.getDeviceAliasShowCfg() || sw.isCfsFeatureEnabled() != seed.isCfsFeatureEnabled() || sw.getDeviceAliasMode() != seed.getDeviceAliasMode() || !sw.isVersionGreaterThan(seed.getVersion())) continue;
            seed = sw;
        }
        if (seed != null) {
            this.setAliasSeed(seed);
            return seed;
        }
        Object[] vsans = this._vsanByPK.values().toArray(new VsanImpl[this._vsanByPK.size()]);
        Arrays.sort(vsans);
        for (int i = 0; i < vsans.length; ++i) {
            SwitchImpl prinsw = ((VsanImpl)vsans[i]).getPrincipalSwitch();
            if (prinsw != null && prinsw.isPresent() && prinsw.isManageableMDS() && !prinsw.isNpvEnabled() && prinsw.isCfsFeatureEnabled() && prinsw.isVersionGreaterThanEqual("2.0(0.149)")) {
                seed = prinsw;
                break;
            }
            if (seed != null) continue;
            for (SwitchImpl sw : ((VsanImpl)vsans[i]).getSwitches()) {
                if (!sw.isPresent() || !sw.isManageableMDS() || sw.isNpvEnabled() || prinsw == null || !prinsw.isCfsFeatureEnabled() || !sw.isVersionGreaterThanEqual("2.0(0.149)")) continue;
                seed = sw;
            }
        }
        if (seed == null) {
            if (lastSw != null && lastSw.isMDS() && !lastSw.isNpvEnabled() && lastSw.isCfsFeatureEnabled()) {
                seed = lastSw;
            } else {
                for (SwitchImpl sw : this._switches) {
                    if (!sw.isMDS() || sw.isNpvEnabled() || !sw.isCfsFeatureEnabled()) continue;
                    seed = sw;
                    break;
                }
            }
        }
        this.setAliasSeed(seed);
        return seed;
    }

    public SwitchImpl selectRegionAliasSeed(int regionId) {
        SwitchImpl seed = null;
        SwitchImpl lastSw = null;
        for (SwitchImpl sw : this._switches) {
            if (sw.getCfsRegionId("device-alias") != regionId) continue;
            lastSw = sw;
            if (!sw.isManageableMDS() || sw.isNpvEnabled()) continue;
            if (seed == null || sw.getDeviceAliasShowCfg() == 1 && seed.getDeviceAliasShowCfg() != 1) {
                seed = sw;
                continue;
            }
            if (sw.getDeviceAliasShowCfg() == seed.getDeviceAliasShowCfg() && sw.isCfsFeatureEnabled() && !seed.isCfsFeatureEnabled()) {
                seed = sw;
                continue;
            }
            if (sw.getDeviceAliasShowCfg() == seed.getDeviceAliasShowCfg() && sw.isCfsFeatureEnabled() == seed.isCfsFeatureEnabled() && sw.getDeviceAliasMode() > seed.getDeviceAliasMode()) {
                seed = sw;
                continue;
            }
            if (sw.getDeviceAliasShowCfg() != seed.getDeviceAliasShowCfg() || sw.isCfsFeatureEnabled() != seed.isCfsFeatureEnabled() || sw.getDeviceAliasMode() != seed.getDeviceAliasMode() || !sw.isVersionGreaterThan(seed.getVersion())) continue;
            seed = sw;
        }
        if (seed != null) {
            this.setRegionAliasSeed(regionId, seed);
            return seed;
        }
        Object[] vsans = this._vsanByPK.values().toArray(new VsanImpl[this._vsanByPK.size()]);
        Arrays.sort(vsans);
        for (int i = 0; i < vsans.length; ++i) {
            SwitchImpl prinsw = ((VsanImpl)vsans[i]).getPrincipalSwitch();
            if (prinsw != null && prinsw.isPresent() && prinsw.isManageableMDS() && !prinsw.isNpvEnabled() && prinsw.isCfsFeatureEnabled() && prinsw.isVersionGreaterThanEqual("2.0(0.149)") && prinsw.getCfsRegionId("device-alias") == regionId) {
                seed = prinsw;
                break;
            }
            if (seed != null) continue;
            for (SwitchImpl sw : ((VsanImpl)vsans[i]).getSwitches()) {
                if (!sw.isPresent() || !sw.isManageableMDS() || sw.isNpvEnabled() || prinsw == null || !prinsw.isCfsFeatureEnabled() || !sw.isVersionGreaterThanEqual("2.0(0.149)") || sw.getCfsRegionId("device-alias") != regionId) continue;
                seed = sw;
            }
        }
        if (seed == null) {
            if (lastSw != null && lastSw.isMDS() && !lastSw.isNpvEnabled() && lastSw.isCfsFeatureEnabled()) {
                seed = lastSw;
            } else {
                for (SwitchImpl sw : this._switches) {
                    if (!sw.isMDS() || sw.isNpvEnabled() || !sw.isCfsFeatureEnabled() || sw.getCfsRegionId("device-alias") != regionId) continue;
                    seed = sw;
                    break;
                }
            }
        }
        this.setRegionAliasSeed(regionId, seed);
        return seed;
    }

    private void selectFabricName() {
        if (this.isBrcdNpvFabric()) {
            if (this._seed != null) {
                boolean alreadyExists;
                Wwn seedWwn;
                String name = this._seed.getSysName();
                if (name == null || name.length() == 0) {
                    name = this._seed.getIpAddress();
                }
                if ((name == null || name.length() == 0) && (seedWwn = this._seed.getWwn()) != null) {
                    name = WwnDictionary.get(seedWwn.getValue(), true, false);
                }
                if (alreadyExists = SanManager.getInstance().checkIfFabricNameExists(name)) {
                    String tempName = name;
                    int i = 0;
                    while (alreadyExists) {
                        tempName = name + "." + ++i;
                        alreadyExists = SanManager.getInstance().checkIfFabricNameExists(tempName);
                    }
                    name = tempName;
                }
                this.setFabricName("BrcdNpvFabric_" + name);
            }
        } else {
            String inVsans = this.getIncludedVsanList();
            String exVsans = this.getExcludedVsanList();
            if (inVsans != null && !inVsans.equals("") || exVsans != null && !exVsans.equals("")) {
                try {
                    this.setFabricName("Fabric_" + this._seed.getSysName() + "_" + Sequence.getSequence().getPK());
                }
                catch (SQLException ex) {
                    _Logger.log((Priority)Level.WARN, (Object)"setFabricName", (Throwable)ex);
                }
                return;
            }
            VsanImpl[] vs = this.findVsan(1);
            if (vs != null && vs.length != 0) {
                boolean alreadyExists;
                String name;
                if (vs.length > 1) {
                    Arrays.sort(vs, new Comparator<VsanImpl>(){

                        @Override
                        public int compare(VsanImpl v1, VsanImpl v2) {
                            byte[] b1 = v1.getVsanPK()._prinSwwn.getValue();
                            byte[] b2 = v2.getVsanPK()._prinSwwn.getValue();
                            return ((b1[5] & 0xFF) << 16 + (b1[6] & 0xFF) << 8 + b1[7]) - ((b2[5] & 0xFF) << 16 + (b2[6] & 0xFF) << 8 + b2[7]);
                        }
                    });
                }
                SwitchImpl sw = null;
                for (int i = 0; i < vs.length && (sw = vs[i].getPrincipalSwitch()) == null; ++i) {
                }
                if (sw == null) {
                    sw = this._seed;
                }
                if ((name = sw.getSysName()) == null || name.length() == 0) {
                    name = sw.getIpAddress();
                }
                if (name == null || name.length() == 0) {
                    name = WwnDictionary.get(sw.getWwn().getValue(), true, false);
                }
                if (alreadyExists = SanManager.getInstance().checkIfFabricNameExists(name)) {
                    String tempName = name;
                    int i = 0;
                    while (alreadyExists) {
                        tempName = name + "." + ++i;
                        alreadyExists = SanManager.getInstance().checkIfFabricNameExists(tempName);
                    }
                    name = tempName;
                }
                this.setFabricName("Fabric_" + name);
            } else {
                this.setFabricName("Fabric_" + this._seed.getSysName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePendingBuffer() {
        AtomicBoolean atomicBoolean = this._bufInUse;
        synchronized (atomicBoolean) {
            Serializable[] a;
            if (!this._bufInUse.get()) {
                return;
            }
            if (!this._added.isEmpty() || !this._addedNoLog.isEmpty()) {
                Comparator endPortCmp = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        boolean is2;
                        boolean is1 = o1 instanceof EndPortImpl || o1 instanceof IslImpl;
                        boolean bl = is2 = o2 instanceof EndPortImpl || o2 instanceof IslImpl;
                        if (is1 && is2) {
                            return 0;
                        }
                        if (is1 && !is2) {
                            return 1;
                        }
                        return -1;
                    }
                };
                if (!this._addedNoLog.isEmpty()) {
                    AbstractModelObjectImpl[] an = this._addedNoLog.toArray(new AbstractModelObjectImpl[this._addedNoLog.size()]);
                    Arrays.sort(an, endPortCmp);
                    SanManager.notifyMembersAdded(this, an, false);
                    this._addedNoLog.clear();
                }
                if (!this._added.isEmpty()) {
                    AbstractModelObjectImpl[] a2 = new AbstractModelObjectImpl[this._added.size()];
                    this._added.toArray(a2);
                    Arrays.sort(a2, endPortCmp);
                    SanManager.notifyMembersAdded(this, a2);
                    this._added.clear();
                }
            }
            if (!this._changed.isEmpty()) {
                a = new ChangedModelObject[this._changed.size()];
                this._changed.toArray(a);
                SanManager.notifyMembersChanged(this, (ChangedModelObject[])a);
                this._changed.clear();
            }
            if (!this._moved.isEmpty()) {
                a = new MovedModelObject[this._moved.size()];
                this._moved.toArray(a);
                SanManager.notifyMembersMoved(this, (MovedModelObject[])a);
                this._moved.clear();
            }
            if (!this._removedNoLog.isEmpty()) {
                a = new PKIf[this._removedNoLog.size()];
                this._removedNoLog.toArray(a);
                SanManager.notifyMembersRemoved(this, (PKIf[])a, false);
                this._removedNoLog.clear();
            }
            if (!this._removed.isEmpty()) {
                a = new PKIf[this._removed.size()];
                this._removed.toArray(a);
                SanManager.notifyMembersRemoved(this, (PKIf[])a);
                this._removed.clear();
            }
            this._bufInUse.set(false);
        }
    }

    public void preDiscovery(DiscoveryType discType) {
        this._lastScanTime = System.currentTimeMillis();
        this._bufInUse.set(true);
        if (discType != DiscoveryType.FABRIC_INITIAL) {
            this.lockFabricQuery();
            if (this._nondelayedChanges.get() != 0) {
                this._nondelayedChanges.set(0);
            }
        }
    }

    public boolean postCoreDiscovery(DiscoveryType discType) {
        if (discType == DiscoveryType.FABRIC_INITIAL && this._pkey.getName() == null) {
            if (this._switches.size() == 1) {
                SwitchImpl sw;
                SwitchImpl switchImpl = sw = this._switches.get(0) == null ? null : this._switches.get(0);
                if (sw != null && sw.getNumVsans() == 0) {
                    SanManager.notifyFabricEmptied(this);
                    return false;
                }
                this.selectFabricName();
            } else {
                this.selectFabricName();
            }
        } else {
            this.unlockFabricQuery();
        }
        return true;
    }

    public void purgeEmptyFabric() {
        try {
            _Logger.info((Object)("Purge empty fabric --" + this.getFabricName()));
            SanManager.getInstance().purgeFabric(this);
            if (this._status.get() == 1) {
                this.releaseFabric(2);
            } else if (this._status.get() == 2) {
                SanManager.notifyFabricRediscovered(this);
            }
        }
        catch (Exception e) {
            _Logger.info((Object)"Catch Excetpion for purging empty fabric", (Throwable)e);
        }
    }

    public void postDiscovery(DiscoveryType discType, boolean succeeded) {
        boolean autoReg;
        HashSet<FabricImpl> checkFabrics = new HashSet<FabricImpl>();
        checkFabrics.add(this);
        SanManager sm = SanManager.getInstance();
        if (this._dupSwitches.size() > 0) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)(this + " handle fabric merge mergedSwitches=" + this._dupSwitches));
            }
            for (SwitchImpl sw : this._dupSwitches) {
                if (sw.getFabric() != null) {
                    checkFabrics.add(sw.getFabric());
                }
                if (sw.isNpvEnabled()) continue;
                sm.purgeSwitch(sw);
            }
            this._dupSwitches.clear();
        }
        for (FabricImpl fab : checkFabrics) {
            SwitchImpl[] sws = fab.getSwitches();
            boolean purgeOrphan = true;
            for (SwitchImpl sw : sws) {
                if (sw.isNpvEnabled()) continue;
                purgeOrphan = false;
                break;
            }
            if (purgeOrphan) {
                for (SwitchImpl sw : sws) {
                    sm.purgeSwitch(sw);
                }
            }
            if (fab == this) continue;
            boolean allfound = true;
            for (SwitchImpl sw : sws) {
                SwitchImpl ie = sm.findSwitchByPK(sw.getSwitchPK(), this);
                if (ie != null && ie.getFabric() == this) continue;
                allfound = false;
                break;
            }
            if (!allfound) continue;
            try {
                _Logger.info((Object)("Purge empty fabric --" + fab.getFabricName()));
                SanManager.getInstance().purgeFabric(fab);
            }
            catch (Exception e) {
                _Logger.info((Object)("Catch Excetpion for purging empty fabric " + fab), (Throwable)e);
            }
        }
        if (this.isFabricEmpty()) {
            try {
                _Logger.info((Object)("Purge empty fabric --" + this.getFabricName()));
                SanManager.getInstance().purgeFabric(this);
                if (this._status.get() == 1) {
                    this.releaseFabric(2);
                } else if (this._status.get() == 2) {
                    SanManager.notifyFabricRediscovered(this);
                }
            }
            catch (Exception e) {
                _Logger.info((Object)"Catch Excetpion for purging empty fabric", (Throwable)e);
            }
            return;
        }
        this.checkNpvLinks();
        this.checkCoexistSwitches();
        this.createSwitchPorts();
        this.setCapacity();
        if (!this.isBrcdNpvFabric() && discType != DiscoveryType.FABRIC_ON_DEMAND_ZONE_ONLY) {
            this.checkVsanPresence();
            this.checkCfsRegionPresence();
            this.updateIslFcsp();
        }
        FileLicensingHelper fileLicHelper = FileLicensingHelper.getInstance();
        for (SwitchImpl nextSwitch : this._switches) {
            fileLicHelper.postDiscoveryLicenseProcessing(nextSwitch);
        }
        try {
            this.processVmWare();
        }
        catch (Exception e) {
            _Logger.warn((Object)("processVmWare: " + e.toString()));
        }
        if (SnmpAdapter.AutoCdpDiscv && discType == DiscoveryType.FABRIC_INITIAL) {
            this.exportFcSwitchesToLAN();
        }
        if (this._status.get() == 1) {
            this.releaseFabric(2);
        } else if (this._status.get() == 2) {
            SanManager.notifyFabricRediscovered(this);
        }
        if (discType == DiscoveryType.FABRIC_INITIAL && this._status.get() != 6) {
            try {
                DiscoveryManager.getInstance().enablePoll(this._pkey, this._enablePolling);
            }
            catch (Exception ex) {}
        } else {
            this.releasePendingBuffer();
        }
        try {
            int lic = LicenseManager.getInstance().getFmLicensedState(this._pkey);
            this.setPersistent(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        boolean bl = autoReg = Boolean.valueOf(System.getProperty("trap.listen", "true")) != false && Boolean.valueOf(System.getProperty("trap.autoregistration", "true")) != false;
        if (autoReg) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EventControllerService ec = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
                    ArrayList switchsCopy = null;
                    List list = FabricImpl.this._switches;
                    synchronized (list) {
                        switchsCopy = new ArrayList(FabricImpl.this._switches);
                    }
                    for (SwitchImpl sw : switchsCopy) {
                        ec.addSource(sw);
                        if (sw.isTrapRegistered() || !sw.isManageableMDS()) continue;
                        try {
                            if (!Boolean.parseBoolean(System.getProperty("fabric.enableNpvDiscovery", "true")) && sw.isNpvEnabled()) {
                                sw.setManageable(false, "unmanaged no NPV discovery");
                                continue;
                            }
                            SnmpPeer peer = sw.createPeer();
                            ec.registerTrap(peer);
                        }
                        catch (SnmpException se) {}
                    }
                }
            }.start();
        }
        if (this._delayedChanges.get() != 0) {
            this.scheduleRefresh(12000);
            this._delayedChanges.set(0);
        } else if (this._nondelayedChanges.get() != 0 && !this.isRefreshScheduled()) {
            this.scheduleRefresh(2000);
        }
    }

    private void processVmWare() {
        try {
            if (!this.isLicensed()) {
                _Logger.info((Object)("Skip Enclosure - Vhost association due to no license of fabric " + this));
                return;
            }
            EnclosureImpl[] ens = this.getEnclosures(1);
            _Logger.info((Object)(this + " Num of Host Enclosure is " + ens.length));
            VHostImpl[] hosts = ViManager.getInstance().getHosts();
            HashMap<String, EndPortImpl> endPortsByWwnHexStr = new HashMap<String, EndPortImpl>();
            EndPortImpl[] endPorts = this.getEndPorts();
            if (endPorts != null) {
                for (EndPortImpl ep : endPorts) {
                    endPortsByWwnHexStr.put(ep.getPortWwn().toHexString(true), ep);
                }
            }
            for (int i = 0; hosts != null && i < hosts.length; ++i) {
                EnclosureImpl enc;
                int connState = hosts[i].getConnState();
                if (connState != 0) continue;
                ArrayList<Wwn> pwwns = hosts[i].getHbas();
                ArrayList<String> aliases = hosts[i].getAliases();
                for (int k = 0; pwwns != null && k < pwwns.size(); ++k) {
                    String alias;
                    String pwwn = pwwns.get(k).toHexString(true);
                    EndPortImpl ep = (EndPortImpl)endPortsByWwnHexStr.get(pwwn);
                    if (ep == null) continue;
                    enc = ep.getEnclosure();
                    if (enc != null) {
                        this.setVmHost(enc, hosts[i], ep);
                    }
                    aliases.set(k, (alias = ep.getDeviceAlias()) == null ? "NA" : alias);
                }
                List<String> iscsiNames = hosts[i].getIscsiNames();
                if (iscsiNames == null) continue;
                for (String name : iscsiNames) {
                    enc = SanManager.getInstance().findEnclosureByName(name);
                    if (enc == null) continue;
                    this.setVmHost(enc, hosts[i], null);
                }
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("Fabric " + this + " process VmWare error"), (Throwable)e);
        }
    }

    void setVmHost(EnclosureImpl enc, VHostImpl vhost, EndPortImpl ep) {
        EnclosureImpl ens1 = SanManager.getInstance().findEnclosureByName(enc.getName());
        if (ens1 != enc) {
            _Logger.warn((Object)(this + " enclosure: " + enc + ", SanManager has enclosure as " + ens1));
        }
        if (enc != null) {
            if (vhost == null) {
                enc.setVmHost(false);
                enc.setVhost(null);
                enc.setIpAddress(null);
            } else {
                EnclosureImpl encTarget = SanManager.getInstance().findEnclosureByPK(new NameKey(vhost.getHostName()));
                if (encTarget != null) {
                    ArrayList<EndPortImpl> eps = null;
                    if (enc.getEndPorts() != null && !enc.getEndPorts().isEmpty()) {
                        eps = new ArrayList<EndPortImpl>(enc.getEndPorts().size());
                        eps.addAll(enc.getEndPorts());
                        for (EndPortImpl e : eps) {
                            e.setEnclosure(encTarget);
                        }
                    }
                    enc = encTarget;
                } else {
                    EnclosureImpl newEnc = SanManager.getInstance().createEnclosure(vhost.getHostName(), null, true);
                    newEnc.setType(47);
                    if (ep != null) {
                        newEnc.addEndPort(ep);
                        ep.setEnclosure(newEnc);
                    }
                    enc = newEnc;
                    _Logger.info((Object)("setVmHost: create new enclosure: '" + newEnc + "' for endport: " + ep.getPortWwn().toHexString(true)));
                }
                enc.setIpAddress(vhost.getIpAddressesAsString());
                enc.setVmHost(true);
                enc.setOSInfo(vhost.getOsType());
                enc.setVendor(vhost.getVendor());
                enc.setVersion(vhost.getVersion());
                enc.setModel(vhost.getModel());
                enc.setVhost(vhost);
            }
        }
        if (vhost == null) {
            return;
        }
        List<EndPortImpl> edPorts = enc.getEndPorts();
        for (EndPortImpl edPort : edPorts) {
            edPort.createAutoAlias();
        }
        VirtualCenterImpl vc = vhost.getVirtualCenter();
        ArrayList<DataStoreImpl> dStores = vc.findDataStoresByHost(vhost.getHostName());
        for (DataStoreImpl dStore : dStores) {
            dStore.setFabric(this);
            dStore.addEnclosure(enc);
            this.addDataStore(dStore);
        }
    }

    void checkNpvLinks() {
        NpvLinkImpl[] npvls = this.getNpvLinks();
        VsanImpl[] vsans = this.getVsans();
        for (int i = 0; i < npvls.length; ++i) {
            boolean found = false;
            for (int j = 0; j < vsans.length; ++j) {
                List<NpvLinkImpl> npvlsOnVsan = vsans[j].getNpvLinks();
                if (!npvlsOnVsan.contains(npvls[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            npvls[i].setPresent(false, 11);
        }
    }

    void checkCoexistSwitches() {
        try {
            boolean changed;
            Map<PKIf, PKIf> newCoexistSwPKMap = GlobalDCManager.getInstance().getAllCoexistSwPKs();
            boolean bl = changed = !this._coexistSwPKs.entrySet().containsAll(newCoexistSwPKMap.entrySet()) || !newCoexistSwPKMap.entrySet().containsAll(this._coexistSwPKs.entrySet());
            if (changed) {
                HashMap<PKIf, PKIf> oldCoexistSwPKs = this._coexistSwPKs;
                this._coexistSwPKs = new HashMap<PKIf, PKIf>(newCoexistSwPKMap);
                ChangedModelObject[] mos = new ChangedModelObject[]{new ChangedModelObject(this.getPK(), 525, oldCoexistSwPKs, this._coexistSwPKs)};
                SanManager.notifyMembersChanged(this, mos);
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)(this + " check coexistSwitches failed "), (Throwable)ex);
        }
    }

    private void exportFcSwitchesToLAN() {
        DCManager dcm = DCManager.getInstance();
        ArrayList<SwitchImpl> exportSws = new ArrayList<SwitchImpl>();
        for (SwitchImpl sw : this._switches) {
            if (!sw.isManageableMDS() || this._coexistSwPKs.get(sw.getPK()) != null) continue;
            exportSws.add(sw);
        }
        if (exportSws.size() == 0) {
            return;
        }
        try {
            dcm.importFcSwitches(this._seed, exportSws, this.getCredentials());
        }
        catch (Exception ex) {
            _Logger.warn((Object)(this + " cannot export fc switches to LAN:" + this._seed + "," + exportSws), (Throwable)ex);
        }
    }

    void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean cleanSwitchCache) {
        EndPortImpl[] endPortImplArray;
        Object swList;
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("Fabric--" + this.getPK() + " is closing"), (Throwable)new Exception("TraceLogger"));
        }
        if (this._worker != null) {
            try {
                SchedulerSingleton.getInstance().removeTask(this._worker);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this._worker.stop();
            this._worker = null;
            if (this.getFarbicStatus() == 5) {
                this.releaseFabric(6);
            }
        }
        SanManager sm = SanManager.getInstance();
        HashSet<SwitchImpl> rmSwList = new HashSet<SwitchImpl>();
        ArrayList<SwitchImpl> rmSwList1 = new ArrayList<SwitchImpl>();
        if (this._switches == null || this._switches.size() == 0) {
            for (SwitchImpl sw2 : swList = sm.getSwitchesForFabric(this.getPK())) {
                if (sw2.getSwitchPK() == null) {
                    rmSwList1.add(sw2);
                    continue;
                }
                rmSwList.add(sw2);
            }
            for (SwitchImpl sw : swList = sm.getSwitchesByIpForFabric(this.getPK())) {
                if (sw.getSwitchPK() == null) {
                    rmSwList1.add(sw);
                    continue;
                }
                rmSwList.add(sw);
            }
        } else {
            swList = this._switches;
            synchronized (swList) {
                for (SwitchImpl sw3 : this._switches) {
                    if (sw3.getSwitchPK() == null) {
                        rmSwList1.add(sw3);
                        continue;
                    }
                    rmSwList.add(sw3);
                }
            }
        }
        for (SwitchImpl switchImpl : rmSwList) {
            this.removeSwitchAndLinks(switchImpl, false);
            sm.removeSwitch(switchImpl, cleanSwitchCache);
        }
        for (SwitchImpl switchImpl : rmSwList1) {
            this.removeSwitchAndLinks(switchImpl, false);
            sm.removeSwitch(switchImpl, cleanSwitchCache);
        }
        HashSet<SwitchImpl> rmDupSwList = new HashSet<SwitchImpl>();
        HashSet<SwitchImpl> hashSet = this._dupSwitches;
        synchronized (hashSet) {
            for (SwitchImpl sw5 : this._dupSwitches) {
                rmDupSwList.add(sw5);
            }
        }
        for (SwitchImpl sw6 : rmDupSwList) {
            this.removeDupSwitches(sw6);
        }
        ConcurrentHashMap<VsanPK, VsanImpl> concurrentHashMap = this._vsanByPK;
        synchronized (concurrentHashMap) {
            for (VsanImpl vsan : this._vsanByPK.values()) {
                try {
                    sm.removeEndPorts(vsan.getEndPorts());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.removeVsan(vsan);
            }
        }
        for (EndPortImpl ep : endPortImplArray = sm.findEndPorts(this.getPK())) {
            try {
                sm.removeEndPort(ep);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.clearDbHashMap();
    }

    private static IslImpl islInChannel(List<IslImpl> pcs, IslImpl isl) {
        for (IslImpl pc : pcs) {
            for (int[] ifIndeces : pc.getChildren()) {
                if (isl.getIfIndex1() != ifIndeces[0] || isl.getIfIndex2() != ifIndeces[1]) continue;
                return pc;
            }
        }
        return null;
    }

    @Override
    public long getDBID() {
        return this._dbID;
    }

    @Override
    public void setDBID(long id) {
        this._dbID = id;
    }

    public long getSeedDBID() {
        return this._seedDBID;
    }

    public long getIvrSeedDBID() {
        return this._ivrSeedDBID;
    }

    public long getAliasSeedDBID() {
        return this._aliasSeedDBID;
    }

    public VsanImpl findVsanByDbId(long dbid) {
        return this._vsanByDbId.get(dbid);
    }

    public void addVsanByDbId(VsanImpl vsan) {
        if (vsan.getDBID() != 0L) {
            this._vsanByDbId.put(vsan.getDBID(), vsan);
        }
    }

    public CfsRegionImpl findCfsRegionByDbId(long dbid) {
        return this._cfsRegionByDbId.get(dbid);
    }

    public void addCfsRegionByDbId(CfsRegionImpl cfsRegion) {
        if (cfsRegion.getDBID() != 0L) {
            this._cfsRegionByDbId.put(cfsRegion.getDBID(), cfsRegion);
        }
    }

    public void addClusterByDbId(ClusterImpl da) {
        if (da.getDBID() != 0L) {
            this._clusterByDbId.put(da.getDBID(), da);
        }
    }

    public SwitchImpl findSwitchByDbId(long dbid) {
        return this._swByDbId.get(dbid);
    }

    public ClusterImpl findClusterByDbId(long dbid) {
        return this._clusterByDbId.get(dbid);
    }

    public IslImpl findIsl(long dbid) {
        return this._islByDbId.get(dbid);
    }

    public NpvLinkImpl findNpvLink(long dbid) {
        return this._npvlByDbId.get(dbid);
    }

    public void addChannelMember(long cid, int[] mids) {
        List<int[]> al = this._chanMbrByChanDbId.get(cid);
        if (al == null) {
            al = new ArrayList<int[]>();
            this._chanMbrByChanDbId.put(cid, al);
        }
        if (!al.contains(mids)) {
            al.add(mids);
        }
    }

    public List<int[]> getIslChannelMemberByDbId(long cid) {
        return this._chanMbrByChanDbId.get(cid);
    }

    public void associateChannelMembers() {
        for (Map.Entry<Long, List<int[]>> entry : this._chanMbrByChanDbId.entrySet()) {
            FcLinkIf fcLink = this._islByDbId.get(entry.getKey());
            if (fcLink == null) {
                fcLink = this._npvlByDbId.get(entry.getKey());
            }
            if (fcLink == null) continue;
            fcLink.setChildren(entry.getValue());
        }
    }

    public EndPortImpl findEndPortByDbId(long dbid) {
        return this._endPortByDbId.get(dbid);
    }

    public void addEndPortById(EndPortImpl epImpl) {
        boolean added = false;
        if (epImpl != null && epImpl.getDBID() != 0L) {
            boolean bl = added = this._endPortByDbId.put(epImpl.getDBID(), epImpl) == null;
        }
        if (added) {
            this.modelObjectAdded(epImpl);
        }
    }

    public void removeEndPort(EndPortImpl epImpl) {
        this.removeEndPort(epImpl, false);
    }

    public void removeEndPort(EndPortImpl epImpl, boolean needPurge) {
        this.removeEndPort(epImpl, needPurge, true);
    }

    public void removeEndPort(EndPortImpl epImpl, boolean needPurge, boolean purgeEnclosure) {
        if (epImpl == null) {
            return;
        }
        this._endPortByDbId.remove(epImpl.getDBID());
        this._endPortRemoveList.add(epImpl);
        SwitchImpl sw = epImpl.getSwitch();
        if (sw == null) {
            return;
        }
        short[] vids = sw.getVsanIds();
        if (vids != null && vids.length > 0) {
            for (int i = 0; i < vids.length; ++i) {
                VsanImpl[] vsans = this.findVsan(vids[i]);
                if (vsans == null || vsans.length <= 0) continue;
                for (int j = 0; j < vsans.length; ++j) {
                    vsans[j].removeEndPort(epImpl, needPurge);
                }
            }
        }
        this.modelObjectRemoved(epImpl.getPK());
        EnclosureImpl ec = epImpl.getEnclosure();
        if (ec != null) {
            ec.removeEndPort(epImpl.getEndPortPK());
            List list = ec.getEndPortPKs();
            if (list == null || list.isEmpty()) {
                try {
                    if (purgeEnclosure) {
                        SanManager.getInstance().purgeEnclosure(ec.getEnclosurePK());
                    } else {
                        SanManager.getInstance().removeEnclosure(ec.getEnclosurePK());
                    }
                }
                catch (Exception ex) {
                    _Logger.warn((Object)("purege enclosure " + ec.getEnclosurePK() + " failed"));
                }
            }
        }
    }

    public void deleteEndPort(EndPortImpl ep) {
        EnclosureImpl encl;
        short[] vids;
        if (ep == null) {
            return;
        }
        SwitchImpl sw = ep.getSwitch();
        if (sw != null && (vids = sw.getVsanIds()) != null && vids.length > 0) {
            for (int i = 0; i < vids.length; ++i) {
                VsanImpl[] vsans = this.findVsan(vids[i]);
                if (vsans == null || vsans.length <= 0) continue;
                for (int j = 0; j < vsans.length; ++j) {
                    vsans[j].removeEndPort(ep, true);
                }
            }
        }
        if ((encl = ep.getEnclosure()) != null) {
            encl.removeEndPort(ep.getEndPortPK());
            if (encl.getNumOfEndPorts() < 1) {
                try {
                    SanManager.getInstance().removeEnclosure(encl.getEnclosurePK());
                }
                catch (Exception ex) {
                    _Logger.warn((Object)("purege enclosure " + encl.getEnclosurePK() + " failed"));
                }
            }
        }
        this._endPortByDbId.remove(ep.getDBID());
        try {
            InventoryPersistentManager.getInstance().purgeEndPort(ep);
        }
        catch (Exception ex) {
            _Logger.warn((Object)(this + " cannot purge end port from db:" + ep), (Throwable)ex);
        }
        this.modelObjectRemoved(ep.getEndPortPK(), true);
    }

    public void setCapacity() {
        SwitchImpl[] sws = this.getSwitches();
        InventoryManager im = InventoryManager.getInstance();
        for (SwitchImpl sw : sws) {
            int port1g = 0;
            int port2g = 0;
            int port4g = 0;
            int port8g = 0;
            int port10g = 0;
            int port16g = 0;
            int port40g = 0;
            int port100g = 0;
            List<FcPortBase> swPorts = sw.getPorts();
            for (FcPortBase swPort : swPorts) {
                if (!swPort.isPhysical() || swPort.isMgmtPort()) continue;
                if (swPort.getIfSpeed() > 0L && swPort.getIfSpeed() <= 1000000000L) {
                    ++port1g;
                    continue;
                }
                if (swPort.getIfSpeed() > 1000000000L && swPort.getIfSpeed() <= 2000000000L) {
                    ++port2g;
                    continue;
                }
                if (swPort.getIfSpeed() > 2000000000L && swPort.getIfSpeed() <= 4000000000L) {
                    ++port4g;
                    continue;
                }
                if (swPort.getIfSpeed() > 4000000000L && swPort.getIfSpeed() <= 8000000000L) {
                    ++port8g;
                    continue;
                }
                if (swPort.getIfSpeed() > 8000000000L && swPort.getIfSpeed() <= 10000000000L) {
                    ++port10g;
                    continue;
                }
                if (swPort.getIfSpeed() > 10000000000L && swPort.getIfSpeed() <= 16000000000L) {
                    ++port16g;
                    continue;
                }
                if (swPort.getIfSpeed() > 16000000000L && swPort.getIfSpeed() <= 40000000000L) {
                    ++port40g;
                    continue;
                }
                if (swPort.getIfSpeed() <= 40000000000L || swPort.getIfSpeed() > 100000000000L) continue;
                ++port100g;
            }
            sw.setNum1gPorts(port1g);
            sw.setNum2gPorts(port2g);
            sw.setNum4gPorts(port4g);
            sw.setNum8gPorts(port8g);
            sw.setNum10gPorts(port10g);
            sw.setNum16gPorts(port16g);
            sw.setNum40gPorts(port40g);
            sw.setNum100gPorts(port100g);
        }
    }

    public void createSwitchPorts() {
        try {
            SwitchImpl[] sws = this.getSwitches();
            InventoryManager im = InventoryManager.getInstance();
            for (SwitchImpl sw : sws) {
                if (sw.getBase().isVdc()) continue;
                Set<Integer> preCardSlots = im.findCardSlotIds(sw.getSwitchPK());
                List<FcPortBase> ports = sw.getPorts();
                for (FcPortBase port : ports) {
                    int relPos = IfIndexUtil.ifIndex2Card(port.getIfIndex());
                    if (port.getIfSpeed() == 0L) {
                        int slotId = relPos + 1;
                        Card card = im.findCard(sw.getSwitchPK(), slotId);
                        if (card != null) {
                            if (port.isPhyEthPort()) {
                                port.setIfSpeed(FRUConstants.getMaxCapacity(card.getType(), 3));
                            } else {
                                port.setIfSpeed(FRUConstants.getMaxCapacity(card.getType(), 1));
                            }
                        }
                    }
                    preCardSlots.remove(relPos + 1);
                }
                Iterator<Comparable> i$ = preCardSlots.iterator();
                while (i$.hasNext()) {
                    Card card;
                    int slotId = (Integer)i$.next();
                    if (slotId == 0 || (card = im.findCard(sw.getSwitchPK(), slotId)) == null || NexusEntityMibHelper.isFexPhyIndex(card.getPhysicalIndex())) continue;
                    this.createSwitchPorts(sw, slotId, card.getType());
                }
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)(this + " createSwitchPorts failed "), (Throwable)ex);
        }
    }

    public void createSwitchPorts(SwitchImpl sw, int slot, int moduleType) {
        FcPortBase port;
        String ifName;
        int i;
        int totalPorts = FRUConstants.getNumPorts(moduleType);
        int gigEPorts = FRUConstants.getNumGigEPorts(moduleType);
        int ethPorts = FRUConstants.getNumEthPorts(moduleType);
        int fcPorts = totalPorts - gigEPorts - ethPorts;
        long capacityEth = FRUConstants.getMaxCapacity(moduleType, 2);
        long capacityGigE = FRUConstants.getMaxCapacity(moduleType, 3);
        long capacityFc = FRUConstants.getMaxCapacity(moduleType, 1);
        for (i = 0; i < fcPorts; ++i) {
            ifName = "fc" + slot + '/' + (i + 1);
            port = sw.createPort(sw.getBase().nameToIfIndex(ifName));
            port.setIfname(ifName);
            if (moduleType == 40) {
                capacityFc = FRUConstants.getMaxCapacity(moduleType, 1, i + 1);
            }
            port.setIfSpeed(capacityFc);
            port.setIfOperStatus((short)109);
        }
        for (i = 0; i < gigEPorts; ++i) {
            ifName = "gigE" + slot + '/' + (i + 1);
            port = sw.createPort(sw.getBase().nameToIfIndex(ifName));
            port.setIfname(ifName);
            port.setIfSpeed(capacityGigE);
            port.setIfOperStatus((short)109);
        }
        for (i = 0; i < ethPorts; ++i) {
            ifName = "Ethernet" + slot + '/' + (i + 1);
            port = sw.createPort(sw.getBase().nameToIfIndex(ifName));
            port.setIfname(ifName);
            port.setIfSpeed(capacityEth);
            port.setIfOperStatus((short)109);
        }
    }

    public Collection<WwnKey> purgeDupEndPorts() {
        Hashtable<WwnKey, EndPortImpl> purgedEndPorts = new Hashtable<WwnKey, EndPortImpl>();
        Object[] vobjs = this._vsanByPK.values().toArray();
        for (int i = 0; i < vobjs.length; ++i) {
            VsanImpl v = (VsanImpl)vobjs[i];
            List<EndPortImpl> list = v.purgeDupEndPorts();
            if (list == null) continue;
            for (EndPortImpl ep : list) {
                if (purgedEndPorts.containsKey(ep.getEndPortPK())) continue;
                this._endPortByDbId.remove(ep.getDBID());
                this._endPortRemoveList.add(ep);
                purgedEndPorts.put(ep.getEndPortPK(), ep);
            }
        }
        try {
            EndPortImpl[] tobePurged = purgedEndPorts.values().toArray(new EndPortImpl[purgedEndPorts.size()]);
            if (_Logger.isDebugEnabled()) {
                for (int i = 0; i < tobePurged.length; ++i) {
                    _Logger.debug((Object)(" >>>>> tobePurged " + tobePurged[i]));
                }
            }
            InventoryPersistentManager.getInstance().purgeDupEndPorts(tobePurged);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("Purge EndPort from db: " + ex.getMessage()));
        }
        return purgedEndPorts.keySet();
    }

    public EnclosureImpl findEnclosureByDbId(long dbid) {
        return this._encByDbId.get(dbid);
    }

    public void addEnclosure(EnclosureImpl encImpl) {
        this._encByDbId.put(new Long(encImpl.getDBID()), encImpl);
    }

    public HostClusterImpl findHostClusterByDbId(long dbid) {
        return this._hostClusterByDbId.get(dbid);
    }

    public void addHostCluster(HostClusterImpl hostCluster) {
        this._hostClusterByDbId.put(new Long(hostCluster.getDBID()), hostCluster);
    }

    public FcPortImpl findSwitchPortByDbId(long id) {
        return this._swPortByDbId.get(id);
    }

    public FcPortImpl findSwitchPortByKey(SwitchIntKey id) {
        return this._swPortByKey.get(id);
    }

    public Iterator<FcPortImpl> getDbFcPortIterator() {
        return this._swPortByDbId.values().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSwitchPort(FcPortImpl spImpl) {
        boolean notPreexist;
        Map<SwitchIntKey, FcPortImpl> map = this._swPortByKey;
        synchronized (map) {
            notPreexist = this._swPortByKey.get(spImpl.getBase().getSwitchPortPK()) == null;
            if (notPreexist) {
                this._swPortByKey.put((SwitchIntKey)spImpl.getBase().getSwitchPortPK(), spImpl);
            }
        }
        if (spImpl.getDBID() != 0L) {
            this._swPortByDbId.put(spImpl.getDBID(), spImpl);
        }
        if (notPreexist) {
            this.modelObjectAdded(spImpl);
        }
        return notPreexist;
    }

    public void removeSwitchPort(SwitchIntKey portPK, boolean purge) {
        if (portPK == null) {
            return;
        }
        FcPortImpl portImpl = this._swPortByKey.remove(portPK);
        if (portImpl == null) {
            return;
        }
        if (portImpl.getSwitch() != null) {
            portImpl.getSwitch().removePort(portImpl.getIfIndex());
        }
        if (portImpl.getDBID() > 0L) {
            this._swPortByDbId.remove(portImpl.getDBID());
        }
        this.modelObjectRemoved(portImpl.getPK());
        if (purge) {
            try {
                InventoryPersistentManager.getInstance().purgeSwitchPort(portImpl);
            }
            catch (Exception ex) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.warn((Object)(this + " failed to purge switch port:" + portImpl.getIfname()), (Throwable)ex);
                }
                _Logger.warn((Object)(this + " failed to purge switch port:" + portImpl.getIfname()));
            }
        }
    }

    public void setLastUpdateTime(long time) {
        this._lastUpdateTime = time;
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public static byte[] valueOf(long[] ids) {
        byte[] b = new byte[ids.length * 4];
        int bCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            long id = ids[i];
            b[bCount++] = (byte)(id >> 24);
            b[bCount++] = (byte)(id >> 16);
            b[bCount++] = (byte)(id >> 8);
            b[bCount++] = (byte)id;
        }
        return b;
    }

    public static byte[] valueOf(long inm) {
        byte[] b = new byte[]{(byte)(inm >> 56 & 0xFFL), (byte)(inm >> 48 & 0xFFL), (byte)(inm >> 40 & 0xFFL), (byte)(inm >> 32 & 0xFFL), (byte)(inm >> 24 & 0xFFL), (byte)(inm >> 16 & 0xFFL), (byte)(inm >> 8 & 0xFFL), (byte)(inm & 0xFFL)};
        return b;
    }

    public static String getStatusDesc(int status) {
        if (status > 0 && status <= STATUS_NAMES.length) {
            return STATUS_NAMES[status - 1];
        }
        return "Unknown Status";
    }

    public void setUserDBID(long id) {
        this._userDBID = id;
    }

    void persistAttributes() {
        try {
            InventoryPersistentManager.getInstance().persistDBObject(this);
        }
        catch (Exception ex) {
            _Logger.warn((Object)("persist " + this._pkey + " attributes failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block5: {
            if (this.getSeed() == null || this.getSeed().getInetAddress() == null) {
                return;
            }
            stat = con.prepareStatement(QuerySQLByIpVsans);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block5;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getFmUser() {
        return this.fmUser;
    }

    public void setFmUser(String fmUser) {
        this.fmUser = fmUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadPersistentFabricsFromDB() throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        String queryStr = QuerySQLByPersistentFilteredByServerId;
        try {
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(queryStr));
            stat.setInt(1, Sequence.getSequence().getServerId());
            rs = stat.executeQuery();
            arrayList = FabricImpl.loadDBRecord(rs, null, null, null);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.error((Object)"loadPersistentFabricsFromDB failed", (Throwable)ex);
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadPersistentFabricsFromDB(int serverId) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(QuerySQLByPersistentFilteredByServerId));
            stat.setInt(1, serverId);
            rs = stat.executeQuery();
            arrayList = FabricImpl.loadDBRecord(rs, null, null, null);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.error((Object)"loadPersistentFabricsFromDB failed", (Throwable)ex);
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findSeedSwitchIdByPk(FabricPK pk) throws SQLException {
        long ret;
        block6: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = 0L;
            try {
                stat = con.prepareStatement(QuerySeedIdSQLByPk);
                stat.setInt(1, pk.get_fid());
                rs = stat.executeQuery();
                while (rs.next()) {
                    ret = rs.getLong(1);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] findVsanScopeByPk(FabricPK pk) throws SQLException {
        String[] ret;
        block6: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = new String[2];
            try {
                stat = con.prepareStatement(QueryVsanScopeSQLByPk);
                stat.setInt(1, pk.get_fid());
                rs = stat.executeQuery();
                while (rs.next()) {
                    ret[0] = rs.getString(1);
                    ret[1] = rs.getString(2);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)"FabricImpl caught exception from findVsanScopeByPk", (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    public static SnmpUser getSnmpUser(FabricPK fabricPK) throws SQLException {
        CommunityUser communityUser;
        Connection con = null;
        PreparedStatement userFabricQuery = null;
        ResultSet rs = null;
        SnmpUser snmpUser = null;
        try {
            con = ConnectionManager.getConnection();
            userFabricQuery = con.prepareStatement(QuerySnmpByFID);
            userFabricQuery.setInt(1, fabricPK.get_fid());
            rs = userFabricQuery.executeQuery();
            int version = 3;
            String userName = null;
            String authPassword = null;
            String privPassword = null;
            int authProtocol = -1;
            int privProtocol = -1;
            String securityName = null;
            String roleName = null;
            if (rs.next()) {
                version = rs.getInt(1);
                userName = rs.getString(2);
                authPassword = rs.getString(3);
                privPassword = rs.getString(4);
                authProtocol = rs.getInt(5);
                privProtocol = rs.getInt(6);
                securityName = rs.getString(7);
                roleName = rs.getString(8);
            }
            snmpUser = version == 3 ? new UsmUser(StringEncrypter.decryptString("DES", userName), authProtocol, StringEncrypter.decryptString("DES", authPassword), privProtocol, privPassword == null ? null : StringEncrypter.decryptString("DES", privPassword)) : new CommunityUser(StringEncrypter.decryptString("DES", userName), version);
            snmpUser.setSecurityName(securityName);
            snmpUser.setRoleName(roleName);
            communityUser = snmpUser;
        }
        catch (Exception ex) {
            try {
                throw new SQLException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(userFabricQuery);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(userFabricQuery);
        DbUtil.close(con);
        return communityUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FabricPK findFPKByDbId(long id) throws SQLException {
        FabricPK ret;
        block6: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = null;
            try {
                stat = con.prepareStatement(QueryFpkQLByDbId);
                stat.setLong(1, id);
                rs = stat.executeQuery();
                while (rs.next()) {
                    ret = new FabricPK((int)rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findDbIdByFPK(long fpk) throws SQLException {
        long ret;
        block6: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = 0L;
            try {
                stat = con.prepareStatement(QueryDbIdByFpk);
                stat.setLong(1, fpk);
                rs = stat.executeQuery();
                while (rs.next()) {
                    ret = rs.getLong(1);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FabricPK findFPKBySeedIP(InetAddress addr) throws SQLException {
        FabricPK ret;
        block6: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = null;
            try {
                stat = con.prepareStatement(QueryFpkQLByIp);
                stat.setBytes(1, addr.getAddress());
                rs = stat.executeQuery();
                while (rs.next()) {
                    ret = new FabricPK((int)rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FabricPK findFPKBySeedIPVsans(InetAddress addr, String inVsans, String exVsans) throws SQLException {
        FabricPK ret;
        block6: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = null;
            try {
                stat = con.prepareStatement(QueryFpkQLByIpVsans);
                stat.setBytes(1, addr.getAddress());
                stat.setString(2, inVsans == null ? "-1" : inVsans);
                stat.setString(3, exVsans == null ? "-1" : exVsans);
                rs = stat.executeQuery();
                while (rs.next()) {
                    ret = new FabricPK((int)rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FabricImpl loadFromDB(InetAddress ip) throws SQLException {
        FabricImpl fabricImpl;
        if (ip == null) {
            return null;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByIpFilteredByServerId);
            stat.setInt(1, Sequence.getSequence().getServerId());
            stat.setBytes(2, ip.getAddress());
            rs = stat.executeQuery();
            ArrayList al = FabricImpl.loadDBRecord(rs, ip, null, null);
            fabricImpl = al.size() == 0 ? null : (FabricImpl)al.get(0);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            FabricImpl fabricImpl2 = null;
            return fabricImpl2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FabricImpl loadFromDB(InetAddress ip, String inVsans, String exVsans) throws SQLException {
        FabricImpl fabricImpl;
        if (ip == null) {
            return null;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByIpVsansFilteredByServerId);
            stat.setInt(1, Sequence.getSequence().getServerId());
            stat.setBytes(2, ip.getAddress());
            if (inVsans != null) {
                stat.setString(3, inVsans);
            } else {
                stat.setString(3, "-1");
            }
            if (exVsans != null) {
                stat.setString(4, exVsans);
            } else {
                stat.setString(4, "-1");
            }
            rs = stat.executeQuery();
            ArrayList al = FabricImpl.loadDBRecord(rs, ip, inVsans, exVsans);
            fabricImpl = al.size() == 0 ? null : (FabricImpl)al.get(0);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            FabricImpl fabricImpl2 = null;
            return fabricImpl2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return fabricImpl;
    }

    public static ArrayList loadDBRecord(ResultSet rs, InetAddress ip, String inVsans, String exVsans) throws SQLException {
        ArrayList<FabricImpl> al = new ArrayList<FabricImpl>();
        while (rs.next()) {
            SnmpUser user;
            FabricPK fabricKey;
            FabricPK fabricPK = fabricKey = ip == null ? null : SanManager.getInstance().findFabricPK(ip, inVsans, exVsans);
            if (fabricKey == null) {
                fabricKey = new FabricPK((int)rs.getLong(12));
                fabricKey.setName(rs.getString(11));
            }
            FabricImpl fImpl = SanManager.getInstance().createFabric(fabricKey);
            fImpl.setDBID(rs.getLong(1));
            fImpl._seedDBID = rs.getLong(2);
            fImpl._ivrSeedDBID = rs.getLong(3);
            fImpl.setIvrEnforcedZoneSetName(-1, rs.getString(4));
            fImpl.setIvrEnforcedZoneSetActivateTime(-1, rs.getLong(5));
            fImpl.enablePolling(rs.getBoolean(6));
            fImpl._pollInterval = rs.getInt(7);
            fImpl._lastScanTime = rs.getLong(8);
            fImpl._retries = rs.getInt(9);
            fImpl._timeout = rs.getInt(10);
            fImpl._aliasSeedDBID = rs.getLong(13);
            fImpl._isPersistent = rs.getBoolean(14);
            fImpl._rediscInterval = rs.getInt(15);
            fImpl._user = user = SnmpUserImpl.loadFromDB(rs.getLong(16));
            fImpl.setFcAlias(!rs.getBoolean(17));
            fImpl.setLicenseId(rs.getInt(18));
            if (rs.getString(19) != null && rs.getString(19).equals("-1")) {
                fImpl.setIncludedVsanList(null);
            } else {
                fImpl.setIncludedVsanList(rs.getString(19));
            }
            if (rs.getString(20) != null && rs.getString(20).equals("-1")) {
                fImpl.setExcludedVsanList(null);
            } else {
                fImpl.setExcludedVsanList(rs.getString(20));
            }
            al.add(fImpl);
        }
        return al;
    }

    @Override
    public String getDeleteSql() throws DBException {
        return "delete from fabric where id=" + this.getDBID();
    }

    public void clearDbHashMap() {
        for (SwitchImpl sw : this._swByDbId.values()) {
            sw.clearIslHash();
        }
        this._vsanByDbId.clear();
        this._swByDbId.clear();
        this._swPortByDbId.clear();
        this._swPortByKey.clear();
        this._encByDbId.clear();
        this._endPortByDbId.clear();
        this._islByDbId.clear();
        this._npvlByDbId.clear();
        this._chanMbrByChanDbId.clear();
        this._clusterByDbId.clear();
        this._cfsRegionByDbId.clear();
        this._deviceAliasRemoveList.clear();
        this._endPortRemoveList.clear();
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByIpVsans;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        if (this._seed != null) {
            stat.setLong(2, this._seed.getDBID());
        } else {
            stat.setLong(2, this._seedDBID);
        }
        if (this.getIvrSeed() != null) {
            stat.setLong(3, this.getIvrSeed().getDBID());
        } else {
            stat.setLong(3, this._ivrSeedDBID);
        }
        stat.setString(4, this._ivrEnfZoneSetName.get(new Integer(-1)));
        if (this._ivrEnfZoneSetActivateTime.get(new Integer(-1)) != null) {
            stat.setLong(5, this._ivrEnfZoneSetActivateTime.get(new Integer(-1)));
        } else {
            stat.setLong(5, 0L);
        }
        stat.setBoolean(6, this._enablePolling);
        stat.setInt(7, this.getPollInterval());
        stat.setLong(8, this._lastScanTime);
        stat.setInt(9, this._retries);
        stat.setInt(10, this._timeout);
        stat.setString(11, this.getPK().getName());
        stat.setInt(12, this.getPK()._fid);
        if (this.getAliasSeed() != null) {
            stat.setLong(13, this.getAliasSeed().getDBID());
        } else {
            stat.setNull(13, 4);
        }
        stat.setBoolean(14, this._isPersistent);
        stat.setInt(15, this._rediscInterval);
        stat.setLong(16, this._userDBID);
        stat.setTimestamp(17, new Timestamp(this._lastUpdateTime));
        stat.setBoolean(18, !this._useFcAlias);
        stat.setInt(19, this.getLicensedState());
        if (this.getIncludedVsanList() != null) {
            stat.setString(20, this.getIncludedVsanList());
        } else {
            stat.setString(20, "-1");
        }
        if (this.getExcludedVsanList() != null) {
            stat.setString(21, this.getExcludedVsanList());
        } else {
            stat.setString(21, "-1");
        }
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._seed != null) {
            stat.setLong(1, this._seed.getDBID());
        } else {
            stat.setLong(1, this._seedDBID);
        }
        if (this.getIvrSeed() != null) {
            stat.setLong(2, this.getIvrSeed().getDBID());
        } else {
            stat.setLong(2, this._ivrSeedDBID);
        }
        stat.setString(3, this._ivrEnfZoneSetName.get(new Integer(-1)));
        if (this._ivrEnfZoneSetActivateTime.get(new Integer(-1)) != null) {
            stat.setLong(4, this._ivrEnfZoneSetActivateTime.get(new Integer(-1)));
        } else {
            stat.setLong(4, 0L);
        }
        stat.setBoolean(5, this._enablePolling);
        stat.setInt(6, this.getPollInterval());
        stat.setLong(7, this._lastScanTime);
        stat.setInt(8, this._retries);
        stat.setInt(9, this._timeout);
        stat.setString(10, this.getPK().getName());
        stat.setInt(11, this.getPK()._fid);
        if (this.getAliasSeed() != null) {
            stat.setLong(12, this.getAliasSeed().getDBID());
        } else {
            stat.setNull(12, 4);
        }
        stat.setBoolean(13, this._isPersistent);
        stat.setInt(14, this._rediscInterval);
        stat.setLong(15, this._userDBID);
        stat.setTimestamp(16, new Timestamp(this._lastUpdateTime));
        stat.setBoolean(17, !this._useFcAlias);
        stat.setInt(18, this.getLicensedState());
        if (this.getIncludedVsanList() != null) {
            stat.setString(19, this.getIncludedVsanList());
        } else {
            stat.setString(19, "-1");
        }
        if (this.getExcludedVsanList() != null) {
            stat.setString(20, this.getExcludedVsanList());
        } else {
            stat.setString(20, "-1");
        }
        stat.setLong(21, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        if (this._seed != null) {
            stat.setBytes(1, this._seed.getInetAddress().getAddress());
        } else {
            stat.setNull(1, -2);
        }
        if (this.getIncludedVsanList() != null) {
            stat.setString(2, this.getIncludedVsanList());
        } else {
            stat.setString(2, "-1");
        }
        if (this.getExcludedVsanList() != null) {
            stat.setString(3, this.getExcludedVsanList());
        } else {
            stat.setString(3, "-1");
        }
    }

    public static boolean equals(short propId, Serializable value1, Serializable value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        switch (propId) {
            case 1544: {
                return VsanFcIdKey.equals((VsanFcIdKey[])value1, (VsanFcIdKey[])value2);
            }
            case 1555: {
                return VsanFportKey.equals((VsanFportKey[])value1, (VsanFportKey[])value2);
            }
            case 1284: 
            case 1287: 
            case 3076: {
                List l1 = (List)((Object)value1);
                List l2 = (List)((Object)value2);
                return l1.size() != l2.size() ? false : l1.containsAll(l2) && l2.containsAll(l1);
            }
        }
        return value1.equals(value2);
    }

    public String dumpHashes() {
        Field[] flds;
        StringBuilder sb = new StringBuilder();
        for (Field field : flds = this.getClass().getDeclaredFields()) {
            try {
                Object o = field.get(this);
                if (!(o instanceof Map)) continue;
                String name = field.getName();
                Map map = (Map)o;
                sb.append('\n');
                if (name.charAt(0) == '_') {
                    sb.append(name.substring(1));
                } else {
                    sb.append(name);
                }
                sb.append(": ");
                if (map == null) {
                    sb.append(VALUE_NONE);
                } else {
                    sb.append(map.size());
                    Set s = map.entrySet();
                    for (Map.Entry ent : s) {
                        sb.append("\n\tkey=").append(ent.getKey()).append(" \tvalue=").append(ent.getValue());
                    }
                }
                sb.append('\n');
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String dumpIvr(int level) {
        StringBuffer sb;
        block24: {
            block22: {
                block23: {
                    sb = new StringBuffer();
                    sb.append(LIL[level]).append("IVR Info");
                    if (this.getNumCfsRegions("ivr") != 0) break block22;
                    sb.append(LIL[level + 1]).append("Seed Switch: ");
                    if (this.getIvrSeed() == null) {
                        sb.append(VALUE_NONE);
                    } else {
                        sb.append(this.getIvrSeed().getIpAddress());
                    }
                    sb.append(LIL[level + 1]).append("Active Zoneset: ");
                    String ivrEnfZoneSet = this._ivrEnfZoneSetName.get(new Integer(-1));
                    if (ivrEnfZoneSet == null || ivrEnfZoneSet.length() == 0) {
                        sb.append(VALUE_NONE);
                    } else {
                        sb.append(ivrEnfZoneSet);
                    }
                    sb.append(LIL[level + 1]).append("Activate Time: ");
                    Long ivrEnfZoneSetActivateT = this._ivrEnfZoneSetActivateTime.get(new Integer(-1));
                    if (ivrEnfZoneSetActivateT != null) {
                        if (ivrEnfZoneSetActivateT == 0L) {
                            sb.append(VALUE_NONE);
                        } else {
                            sb.append(new Date(ivrEnfZoneSetActivateT));
                        }
                    }
                    sb.append(LIL[level + 1]).append("Active Zoneset Checksum: ");
                    if (this.getIvrActiveZonesetChecksum() == null || this.getIvrActiveZonesetChecksum().length == 0) {
                        sb.append(VALUE_NONE);
                    } else {
                        sb.append(SnmpString.toHexString(this.getIvrActiveZonesetChecksum()));
                    }
                    sb.append(LIL[level + 1]).append("Active Zones: ");
                    if (ivrEnfZoneSet != null && ivrEnfZoneSet.length() != 0) break block23;
                    sb.append(VALUE_NA);
                    break block24;
                }
                ZoneBase[] ivrEnfZones = this._ivrEnfZones.get(new Integer(-1));
                if (ivrEnfZones == null) break block24;
                for (int i = 0; i < ivrEnfZones.length; ++i) {
                    sb.append(ZoneImpl.dump(ivrEnfZones[i], level + 2));
                }
                break block24;
            }
            int[] cfsRegions = this.getCfsRegions("ivr");
            for (int i = 0; cfsRegions != null && i < cfsRegions.length; ++i) {
                sb.append(LIL[level + 1]).append("CFS Region Id: " + cfsRegions[i]);
                sb.append(LIL[level + 1]).append("Seed Switch: ");
                SwitchImpl ivrSeed = this.getRegionIvrSeed(cfsRegions[i]);
                if (ivrSeed == null) {
                    sb.append(VALUE_NONE);
                } else {
                    sb.append(ivrSeed.getIpAddress());
                }
                sb.append(LIL[level + 1]).append("Active Zoneset: ");
                String ivrEnfZoneSet = this._ivrEnfZoneSetName.get(new Integer(cfsRegions[i]));
                if (ivrEnfZoneSet == null || ivrEnfZoneSet.length() == 0) {
                    sb.append(VALUE_NONE);
                } else {
                    sb.append(ivrEnfZoneSet);
                }
                sb.append(LIL[level + 1]).append("Activate Time: ");
                Long ivrEnfZoneSetActivateT = this._ivrEnfZoneSetActivateTime.get(new Integer(cfsRegions[i]));
                if (ivrEnfZoneSetActivateT != null) {
                    if (ivrEnfZoneSetActivateT == 0L) {
                        sb.append(VALUE_NONE);
                    } else {
                        sb.append(new Date(ivrEnfZoneSetActivateT));
                    }
                }
                sb.append(LIL[level + 1]).append("Active Zoneset Checksum: ");
                byte[] ivrActiveZonesetChecksum = this._ivrActiveZoneSetChecksum.get(new Integer(cfsRegions[i]));
                if (ivrActiveZonesetChecksum == null || ivrActiveZonesetChecksum.length == 0) {
                    sb.append(VALUE_NONE);
                } else {
                    sb.append(SnmpString.toHexString(ivrActiveZonesetChecksum));
                }
                sb.append(LIL[level + 1]).append("Active Zones: ");
                if (ivrEnfZoneSet == null || ivrEnfZoneSet.length() == 0) {
                    sb.append(VALUE_NA);
                    continue;
                }
                ZoneBase[] ivrEnfZones = this._ivrEnfZones.get(new Integer(cfsRegions[i]));
                if (ivrEnfZones == null) continue;
                for (int j = 0; j < ivrEnfZones.length; ++j) {
                    sb.append(ZoneImpl.dump(ivrEnfZones[j], level + 2));
                }
            }
        }
        return sb.toString();
    }

    public String dumpVsans(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of Vsans: ").append(this._vsanByPK.size());
        Object[] v = this.getVsans();
        Arrays.sort(v);
        for (int i = 0; i < v.length; ++i) {
            if (inDetail) {
                sb.append(((VsanImpl)v[i]).dump(level));
                continue;
            }
            sb.append(LIL[level]).append(((VsanImpl)v[i]).getId()).append(": ").append(((VsanImpl)v[i]).getName());
            if (((VsanImpl)v[i]).isSegmented()) {
                sb.append(" (segmented), ");
            } else {
                sb.append(", ");
            }
            sb.append(((VsanImpl)v[i]).isUp() ? STATUS_UP : STATUS_DOWN);
            sb.append(", seed: ").append(((VsanImpl)v[i]).getSeed()).append(", enforced zoneset: ");
            if (((VsanImpl)v[i]).getEnforcedZoneSetName() == null || ((VsanImpl)v[i]).getEnforcedZoneSetName().length() == 0) {
                sb.append(VALUE_NONE);
                continue;
            }
            sb.append(((VsanImpl)v[i]).getEnforcedZoneSetName());
        }
        return sb.toString();
    }

    public String dumpSwitches(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of Switches: ").append(this.getNumSwitches());
        SwitchImpl[] sws = this.getSwitches();
        for (int i = 0; i < sws.length; ++i) {
            if (inDetail) {
                sb.append(sws[i].dump(level));
                continue;
            }
            sb.append(LIL[level]).append(sws[i].getIpAddress()).append(", ").append(sws[i].getWwn()).append(", IVR ").append(sws[i].isIvrEnabled() ? STATE_ENABLED : STATE_DISABLED);
            if (sws[i] == this._seed) {
                sb.append(" (seed)");
            }
            if (sws[i] == this._ivrSeed) {
                sb.append(" (IVR seed)");
            }
            if (sws[i] != this._aliasSeed) continue;
            sb.append(" (alias server)");
        }
        return sb.toString();
    }

    public String dumpIsls(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of ISLs: ").append(this.getNumIsls());
        IslImpl[] isls = this.getIsls();
        for (int i = 0; i < isls.length; ++i) {
            if (inDetail) {
                sb.append(isls[i].dump(level));
                continue;
            }
            sb.append(LIL[level]).append(isls[i].toString());
        }
        return sb.toString();
    }

    public String dumpNpvLinks(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(LIL[level]).append("Num of NP Links: ").append(this.getNumNpvLinks());
        NpvLinkImpl[] npvls = this.getNpvLinks();
        for (int i = 0; i < npvls.length; ++i) {
            if (inDetail) {
                sb.append(npvls[i].dump(level));
                continue;
            }
            sb.append(LIL[level]).append(npvls[i].toString());
        }
        return sb.toString();
    }

    public String dumpEndPorts(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (VsanImpl v : this._vsanByPK.values()) {
            for (EndPortImpl ep : v.getEndPorts()) {
                if (inDetail) {
                    sb.append(ep.dump(level));
                } else {
                    sb.append(LIL[level]).append(ep.getDetails());
                    if (ep.isVirtualized()) {
                        sb.append(", isVirtualized");
                    }
                    if (ep.getSymNodeName() != null) {
                        sb.append("; ").append(ep.getSymNodeName());
                    }
                }
                ++count;
            }
        }
        sb.insert(0, count).insert(0, "Num of NxPorts: ").insert(0, LIL[level]);
        return sb.toString();
    }

    public String dumpDeviceAliases(boolean inDetail, int level) {
        Object[] das = this.getDeviceAliases();
        Arrays.sort(das);
        StringBuilder sb = new StringBuilder(LIL[level]).append(LIL[level]).append("Use fc-alias: ").append(this._useFcAlias);
        if (this.getNumCfsRegions("device-alias") == 0) {
            sb.append(LIL[level]).append("Device-alias seed:\t").append(this._aliasSeed);
            sb.append(LIL[level]).append("Device-alias checksum:\t");
            sb.append(SnmpString.toHexString(this._deviceAliasChecksum.get(new Integer(-1))));
        } else {
            int[] cfsRegions = this.getCfsRegions("device-alias");
            for (int i = 0; i < cfsRegions.length; ++i) {
                sb.append(LIL[level]).append("CFS Region:\t");
                sb.append(cfsRegions[i]);
                sb.append(LIL[level]).append("Device-alias seed:\t").append(this._aliasSeedByCfsRegion.get(new Integer(cfsRegions[i])));
                sb.append(LIL[level]).append("Device-alias checksum:\t");
                sb.append(SnmpString.toHexString(this._deviceAliasChecksum.get(new Integer(cfsRegions[i]))));
            }
        }
        sb.append(LIL[level]).append("Num of Device-aliases:\t");
        sb.append(das.length);
        for (int i = 0; i < das.length; ++i) {
            Wwn pwwn = ((FcPortAlias)das[i]).getWwn();
            sb.append(LIL[level + 1]).append(pwwn).append("\t: ").append(((FcPortAlias)das[i]).getAlias());
            if (!inDetail) continue;
            EndPortImpl ep = SanManager.getInstance().findEndPort(pwwn, this.getPK());
            if (ep != null) {
                sb.append(" (VSAN ").append(ep.getVsan()).append(")");
                continue;
            }
            sb.append(" (offline)");
        }
        return sb.toString();
    }

    public String dumpEnclosures(boolean inDetail, int level, int type) {
        StringBuffer sb = new StringBuffer();
        EnclosureImpl[] encls = this.getEnclosures(type);
        sb.append(LIL[level]).append("Num of Enclosures: ").append(encls.length);
        for (int i = 0; i < encls.length; ++i) {
            if (inDetail) {
                sb.append(encls[i].dump(level)).append('\n');
                continue;
            }
            sb.append(LIL[level]).append(encls[i]);
            if (encls[i].getIpAddress() == null) continue;
            sb.append(" :: ").append(encls[i].getIpAddress());
        }
        return sb.toString();
    }

    public String dumpZones(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Active Zones:");
        Object[] vs = this.getVsans();
        Arrays.sort(vs);
        for (int i = 0; i < vs.length; ++i) {
            if (((VsanImpl)vs[i]).getEnforcedZoneSetName() == null || ((VsanImpl)vs[i]).getEnforcedZoneSetName().length() == 0) continue;
            sb.append(LIL[level]).append("VSAN: ").append(((VsanImpl)vs[i]).getId()).append(", ").append(((VsanImpl)vs[i]).getEnforcedZoneSetName()).append(", ").append(new Date(((VsanImpl)vs[i]).getEnforcedZoneSetActivateTime()));
            ZoneBase[] zones = ((VsanImpl)vs[i]).getEnforcedZones();
            if (zones == null || zones.length <= 0) continue;
            for (int j = 0; j < zones.length; ++j) {
                if (inDetail) {
                    sb.append(ZoneImpl.dump(zones[j], level + 1));
                    continue;
                }
                sb.append(LIL[level + 1]).append(zones[j]);
            }
        }
        return sb.toString();
    }

    public String dumpFabric(boolean inDetail) {
        StringBuilder sb = new StringBuilder(this._pkey.toString());
        sb.append(LIL[1]).append("Status: ").append(this._status.get());
        if (this._status.get() == 2 || this._status.get() == 4) {
            sb.append(LIL[1]).append("User role: ").append(this._user == null ? VALUE_NA : this._user.getRoleName()).append(LIL[1]).append("Seed switch: ").append(this._seed == null ? VALUE_NA : this._seed.getIpAddress()).append(LIL[1]).append(this.isBrcdNpvFabric() ? "\nBrocade NPV fabric: true" : "").append("\n").append(this.dumpIvr(1)).append(LIL[1]).append("FM license server: ");
            if (this._licSeed == null) {
                sb.append(VALUE_NONE);
            } else {
                sb.append(this._licSeed.getIpAddress());
            }
            sb.append(LIL[1]).append("Manage continously: ").append(this.isPersistent()).append("\n").append(this.dumpVsans(inDetail, 1)).append('\n').append(this.dumpSwitches(inDetail, 1)).append('\n').append(this.dumpIsls(inDetail, 1)).append('\n').append(this.dumpNpvLinks(inDetail, 1)).append("\n").append(this.dumpEndPorts(inDetail, 1)).append("\n").append(this.dumpDeviceAliases(inDetail, 1)).append("\n").append(this.dumpEnclosures(inDetail, 1, 3)).append("\n").append(this.dumpZones(inDetail, 1));
        }
        return sb.toString();
    }

    public List<FcPortAlias> getDeviceAliasRemoveList() {
        return this._deviceAliasRemoveList;
    }

    public List<EndPortImpl> getEndPortRemoveList() {
        return this._endPortRemoveList;
    }

    public void postCommit() {
        this._deviceAliasRemoveList.clear();
        for (FcPortAlias alias : this._deviceAliasByDbId.values()) {
            alias.setModified(false);
        }
        this._endPortRemoveList.clear();
        for (EndPortImpl ep : this._endPortByDbId.values()) {
            ep.getBaseObject().clear();
        }
        Iterator<Map.Entry<Long, FcPortImpl>> iter = this._swPortByDbId.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, FcPortImpl> entry = iter.next();
            if (!entry.getValue().getBaseObject().isFlushed()) {
                iter.remove();
                this._swPortByKey.remove((SwitchIntKey)entry.getValue().getPK());
                continue;
            }
            entry.getValue().getBaseObject().clear();
        }
        EnclosureImpl[] encls = this.getEnclosures(3);
        for (int i = 0; i < encls.length; ++i) {
            encls[i].getBaseObject().clear();
        }
        ClusterImpl[] clusters = this.getClusters();
        for (int i = 0; i < clusters.length; ++i) {
            clusters[i].getBaseObject().clear();
        }
        if (!this._persisted) {
            SanManager.getInstance().notifyFabricDiscovered(this);
        }
        this._persisted = true;
    }

    public boolean isPersisted() {
        return this._persisted;
    }

    public Map<Long, Long> getEndPortDbIds() {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (long id : this._endPortByDbId.keySet()) {
            map.put(id, id);
        }
        return map;
    }

    public void setLicenseInfo(LicenseInfo licInfo) {
        if (licInfo.isPermanent()) {
            this._licInfo = licInfo;
        }
    }

    public LicenseInfo getLicenseInfo() {
        return this._licInfo;
    }

    public void updateSwByDBId() {
        for (SwitchImpl sw : this._switches) {
            if (sw.getDBID() == 0L || this.findSwitchByDbId(sw.getDBID()) != null) continue;
            this._swByDbId.put(sw.getDBID(), sw);
        }
    }

    public void addDataStore(DataStoreImpl dStore) {
        this._dataStoreByPK.put(new NameKey(dStore.getCanonicalName()), dStore);
    }

    public int getNumDataStores() {
        return this._dataStoreByPK.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreImpl[] getDataStores() {
        ConcurrentHashMap<NameKey, DataStoreImpl> concurrentHashMap = this._dataStoreByPK;
        synchronized (concurrentHashMap) {
            return this._dataStoreByPK.values().toArray(new DataStoreImpl[this._dataStoreByPK.size()]);
        }
    }

    void removeDataStore(DataStoreImpl dataStore) {
        if (this._dataStoreByPK.remove(dataStore.getDataStorePK()) != null) {
            if (dataStore.getDBID() != 0L) {
                this._dataStoreByDbId.remove(dataStore.getDBID());
            }
            this.modelObjectRemoved(dataStore.getPK());
        }
    }

    public DataStoreImpl findDataStore(NameKey dataStorePK) {
        return this._dataStoreByPK.get(dataStorePK);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        String key1 = ((FabricImpl)o1).toString();
        String key2 = ((FabricImpl)o2).toString();
        return key1.compareTo(key2);
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    static {
        STATUS_NAMES = new String[]{"OPENING", "OPENED", "LOADING", "STORING", "CLOSING", "CLOSED"};
        _Logger = LogManager.getLogger((String)"fms.model");
        Integer n = Integer.getInteger("fabric.rediscoverinterval");
        _DefRediscInterval = n == null || n <= 0 ? 5 : n;
        n = Integer.getInteger("fabric.pollinterval");
        _DefPollInterval = n == null || n < 75 ? 300 : n;
        LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};
    }

    class FabricConverter
    extends FabricBase {
        private FabricConverter(short[] vsanScope) {
            super(FabricImpl.this._pkey);
            this._seedSwPK = FabricImpl.this._seed != null ? FabricImpl.this._seed.getSwitchPK() : null;
            this._seedSwName = FabricImpl.this._seed != null ? FabricImpl.this._seed.getName() : null;
            this._seedIP = FabricImpl.this._seed != null ? FabricImpl.this._seed.getInetAddress() : null;
            this._licensed = LicenseManager.getInstance().isFmLicensed(FabricImpl.this.getPK());
            this._lastUpdateTime = FabricImpl.this._lastUpdateTime;
            this._ivrSeedSwPK = FabricImpl.this._ivrSeed == null ? null : FabricImpl.this._ivrSeed.getSwitchPK();
            this._ivrEnfZoneSetName = FabricImpl.this._ivrEnfZoneSetName;
            this._ivrEnfZoneSetActivateTime = FabricImpl.this._ivrEnfZoneSetActivateTime;
            this._ivrEnfZones = FabricImpl.this._ivrEnfZones;
            this._ivrSeedByCfsRegion = new ConcurrentHashMap();
            for (Integer n : FabricImpl.this._ivrSeedByCfsRegion.keySet()) {
                SwitchImpl switchImpl = (SwitchImpl)FabricImpl.this._ivrSeedByCfsRegion.get(n);
                if (switchImpl == null || switchImpl.getSwitchPK() == null) continue;
                this._ivrSeedByCfsRegion.put(n, switchImpl.getSwitchPK());
            }
            this._aliasSeedByCfsRegion = new ConcurrentHashMap();
            for (Integer n : FabricImpl.this._aliasSeedByCfsRegion.keySet()) {
                SwitchImpl switchImpl = (SwitchImpl)FabricImpl.this._aliasSeedByCfsRegion.get(n);
                if (switchImpl == null || switchImpl.getSwitchPK() == null) continue;
                this._aliasSeedByCfsRegion.put(n, switchImpl.getSwitchPK());
            }
            this._aliasSeedSwPK = FabricImpl.this._aliasSeed == null ? null : FabricImpl.this._aliasSeed.getSwitchPK();
            this._useFcAlias = FabricImpl.this._useFcAlias;
            this._isPersistent = FabricImpl.this._isPersistent;
            this._vsans = new ArrayList(FabricImpl.this._vsanByPK.size());
            for (VsanImpl vsanImpl : FabricImpl.this._vsanByPK.values()) {
                if (!FabricImpl.inScope(vsanScope, vsanImpl)) continue;
                this._vsans.add((VsanBase)vsanImpl.getBaseObject());
            }
            this._switches = new ArrayList(FabricImpl.this._switches.size());
            for (SwitchImpl switchImpl : FabricImpl.this._switches) {
                if (!FabricImpl.inScope(vsanScope, switchImpl)) continue;
                this._switches.add((SwitchBase)switchImpl.getBaseObject());
            }
            this._cfsRegions = new ArrayList(FabricImpl.this._cfsRegionByPK.size());
            for (SwitchBase switchBase : this._switches) {
                ArrayList<Integer> arrayList = switchBase.getCfsRegionIds();
                for (Integer reg : arrayList) {
                    CfsRegionImpl cRegion = FabricImpl.this.findCfsRegion(new CfsRegionPK(this.getPK(), reg));
                    this._cfsRegions.add((CfsRegion)cRegion.getBaseObject());
                }
            }
            this._dataStores = new ArrayList(FabricImpl.this._dataStoreByPK.size());
            for (DataStoreImpl dataStoreImpl : FabricImpl.this._dataStoreByPK.values()) {
                this._dataStores.add((DataStore)dataStoreImpl.getBaseObject());
            }
            this._isls = new ArrayList(FabricImpl.this._islBySwitchIntKey.size() / 2);
            for (Map.Entry entry : FabricImpl.this._islBySwitchIntKey.entrySet()) {
                IslImpl islImpl = (IslImpl)entry.getValue();
                if (!((SwitchIntKey)entry.getKey()).equals(islImpl.getSwitch1IntKey()) || !FabricImpl.inScope(vsanScope, islImpl)) continue;
                this._isls.add((IslBase)islImpl.getBaseObject());
            }
            this._endports = new ArrayList(20);
            HashMap<PKIf, PKIf> epMap = new HashMap<PKIf, PKIf>();
            for (VsanImpl vsanImpl : FabricImpl.this._vsanByPK.values()) {
                for (EndPortImpl ep : vsanImpl.getEndPorts()) {
                    if (FabricImpl.inScope(vsanScope, ep) && epMap.get(ep.getPK()) == null) {
                        EndPortBase epBase;
                        if (((EndPortBase)ep.getBaseObject()).getFabricPK() == null) {
                            ((EndPortBase)ep.getBaseObject()).setFabricPK(FabricImpl.this.getPK());
                        }
                        if ((epBase = (EndPortBase)ep.getBaseObject()).getEnclosurePK() != null && SanManager.getInstance().findEnclosureByPK(epBase.getEnclosurePK()) == null) {
                            epBase.setEnclosurePK(null);
                        }
                        this._endports.add((EndPortBase)ep.getBaseObject());
                    }
                    epMap.put(ep.getPK(), ep.getPK());
                }
            }
            epMap.clear();
            this._fcports = new ArrayList(20);
            for (SwitchImpl switchImpl : FabricImpl.this._switches) {
                List<FcPortBase> swFcPorts = switchImpl.getPorts();
                for (FcPortBase fcPort : switchImpl.getPorts()) {
                    if (!FabricImpl.inScope(vsanScope, fcPort)) continue;
                    this._fcports.add(fcPort);
                }
            }
            this._npvLinks = new ArrayList(FabricImpl.this._npvLinkByFPortPK.size());
            for (Map.Entry entry : FabricImpl.this._npvLinkByFPortPK.entrySet()) {
                NpvLinkImpl npvl = (NpvLinkImpl)entry.getValue();
                if (!FabricImpl.inScope(vsanScope, npvl)) continue;
                this._npvLinks.add((NpvLinkBase)npvl.getBaseObject());
            }
            this._deviceAliases = new ArrayList(this._deviceAliasByWwn.size());
            for (FcPortAlias fcPortAlias : this._deviceAliasByWwn.values()) {
                this._deviceAliases.add(fcPortAlias);
            }
            this._clusters = new ArrayList(FabricImpl.this._clusterByPK.size());
            for (ClusterImpl clusterImpl : FabricImpl.this._clusterByPK.values()) {
                this._clusters.add((ClusterBase)clusterImpl.getBaseObject());
            }
        }

        private FabricConverter(boolean scope, ArrayList<SwitchImpl> switchScope) {
            super(FabricImpl.this._pkey);
            this._seedSwPK = FabricImpl.this._seed != null ? FabricImpl.this._seed.getSwitchPK() : null;
            this._ivrSeedSwPK = FabricImpl.this._ivrSeed == null ? null : FabricImpl.this._ivrSeed.getSwitchPK();
            this._ivrEnfZoneSetName = FabricImpl.this._ivrEnfZoneSetName;
            this._ivrEnfZoneSetActivateTime = FabricImpl.this._ivrEnfZoneSetActivateTime;
            this._ivrEnfZones = FabricImpl.this._ivrEnfZones;
            this._ivrSeedByCfsRegion = new ConcurrentHashMap();
            for (Integer n : FabricImpl.this._ivrSeedByCfsRegion.keySet()) {
                SwitchImpl switchImpl = (SwitchImpl)FabricImpl.this._ivrSeedByCfsRegion.get(n);
                if (switchImpl == null || switchImpl.getSwitchPK() == null) continue;
                this._ivrSeedByCfsRegion.put(n, switchImpl.getSwitchPK());
            }
            this._aliasSeedByCfsRegion = new ConcurrentHashMap();
            for (Integer n : FabricImpl.this._aliasSeedByCfsRegion.keySet()) {
                SwitchImpl switchImpl = (SwitchImpl)FabricImpl.this._aliasSeedByCfsRegion.get(n);
                if (switchImpl == null || switchImpl.getSwitchPK() == null) continue;
                this._aliasSeedByCfsRegion.put(n, switchImpl.getSwitchPK());
            }
            this._aliasSeedSwPK = FabricImpl.this._aliasSeed == null ? null : FabricImpl.this._aliasSeed.getSwitchPK();
            this._useFcAlias = FabricImpl.this._useFcAlias;
            this._isPersistent = FabricImpl.this._isPersistent;
            this._vsans = new ArrayList(FabricImpl.this._vsanByPK.size());
            for (VsanImpl vsanImpl : FabricImpl.this._vsanByPK.values()) {
                if (!FabricImpl.inScope(switchScope, vsanImpl)) continue;
                this._vsans.add((VsanBase)vsanImpl.getBaseObject());
            }
            this._switches = new ArrayList(FabricImpl.this._switches.size());
            for (SwitchImpl switchImpl : FabricImpl.this._switches) {
                if (!FabricImpl.inScope(switchScope, switchImpl)) continue;
                this._switches.add((SwitchBase)switchImpl.getBaseObject());
            }
            this._cfsRegions = new ArrayList(FabricImpl.this._cfsRegionByPK.size());
            for (SwitchBase switchBase : this._switches) {
                ArrayList<Integer> arrayList = switchBase.getCfsRegionIds();
                for (Integer reg : arrayList) {
                    CfsRegionImpl cRegion = FabricImpl.this.findCfsRegion(new CfsRegionPK(this.getPK(), reg));
                    this._cfsRegions.add((CfsRegion)cRegion.getBaseObject());
                }
            }
            this._dataStores = new ArrayList(FabricImpl.this._dataStoreByPK.size());
            for (DataStoreImpl dataStoreImpl : FabricImpl.this._dataStoreByPK.values()) {
                this._dataStores.add((DataStore)dataStoreImpl.getBaseObject());
            }
            this._isls = new ArrayList(FabricImpl.this._islBySwitchIntKey.size() / 2);
            for (Map.Entry entry : FabricImpl.this._islBySwitchIntKey.entrySet()) {
                IslImpl islImpl = (IslImpl)entry.getValue();
                if (!((SwitchIntKey)entry.getKey()).equals(islImpl.getSwitch1IntKey()) || !FabricImpl.inScope(switchScope, islImpl)) continue;
                this._isls.add((IslBase)islImpl.getBaseObject());
            }
            this._endports = new ArrayList(20);
            HashMap<PKIf, PKIf> epMap = new HashMap<PKIf, PKIf>();
            for (VsanImpl vsanImpl : FabricImpl.this._vsanByPK.values()) {
                for (EndPortImpl ep : vsanImpl.getEndPorts()) {
                    if (FabricImpl.inScope(switchScope, ep) && epMap.get(ep.getPK()) == null) {
                        if (((EndPortBase)ep.getBaseObject()).getFabricPK() == null) {
                            ((EndPortBase)ep.getBaseObject()).setFabricPK(FabricImpl.this.getPK());
                        }
                        this._endports.add((EndPortBase)ep.getBaseObject());
                    }
                    epMap.put(ep.getPK(), ep.getPK());
                }
            }
            epMap.clear();
            this._fcports = new ArrayList(20);
            for (SwitchImpl switchImpl : FabricImpl.this._switches) {
                for (FcPortBase fcPort : switchImpl.getPorts()) {
                    if (!FabricImpl.inScope(switchScope, fcPort)) continue;
                    this._fcports.add(fcPort);
                }
            }
            this._npvLinks = new ArrayList(FabricImpl.this._npvLinkByFPortPK.size());
            for (Map.Entry entry : FabricImpl.this._npvLinkByFPortPK.entrySet()) {
                NpvLinkImpl npvl = (NpvLinkImpl)entry.getValue();
                if (!FabricImpl.inScope(switchScope, npvl)) continue;
                this._npvLinks.add((NpvLinkBase)npvl.getBaseObject());
            }
            this._deviceAliases = new ArrayList(this._deviceAliasByWwn.size());
            for (FcPortAlias fcPortAlias : this._deviceAliasByWwn.values()) {
                this._deviceAliases.add(fcPortAlias);
            }
            this._clusters = new ArrayList(FabricImpl.this._clusterByPK.size());
            for (ClusterImpl clusterImpl : FabricImpl.this._clusterByPK.values()) {
                this._clusters.add((ClusterBase)clusterImpl.getBaseObject());
            }
        }
    }
}

