/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.FexBase;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class FexImpl
extends EthSwitchImpl {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String QuerySQL_ByDeviceId = "select id from ethswitch where ethswitch.device_id=?";

    public FexImpl(SerialNumKey fexPK, int fexId) {
        this._base = new FexBase(fexPK, fexId);
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    @Override
    public FexBase getBase() {
        return (FexBase)this._base;
    }

    @Override
    public PKIf getSwitchPK() {
        return this.getBase().getSwitchPK();
    }

    public SerialNumKey getFexPK() {
        return this.getBase().getFexPK();
    }

    @Override
    public SerialNumKey getChassisKey() {
        return this.getBase().getChassisKey();
    }

    public int getFexId() {
        return this.getBase().getFexId();
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean oldValue = this._base.isPresent();
        if (oldValue != isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1025, Boolean.valueOf(oldValue), Boolean.valueOf(this._base.isPresent()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, "FexImpl trace setPresent: old=" + oldValue + "-->new=" + isPresent + " for " + this.print(false, true), new Exception("TraceLogger"));
            }
            new Exception("FexImpl trace setPresent: old=" + oldValue + "-->new=" + isPresent + " for " + this.print(false, true), new Exception("TraceLogger")).printStackTrace();
        }
        return oldValue;
    }

    public void setFexId(int fexId) {
        int oldValue = this.getBase().getFexId();
        if (oldValue != fexId) {
            this.getBase().setFexId(fexId);
            this.propertyChanged((short)1075, Integer.valueOf(oldValue), Integer.valueOf(this.getBase().getFexId()));
        }
    }

    @Override
    public void setSwitchLastBootTime(long time) {
        long oldTime = this.getBase().getSwitchLastBootTime();
        if (Math.abs(oldTime - time) > 5000L) {
            this.getBase().setSwitchLastBootTime(time);
            this.propertyChanged((short)1069, new Long(oldTime), new Long(time));
        }
    }

    @Override
    public String getName() {
        return this.getBase().getName();
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        String oldValue = this._base.getName();
        if (!name.equals(oldValue)) {
            this._base.setName(name);
        }
    }

    @Override
    public void setVersion(String version) {
        String oldVersion = this.getBase().getVersion();
        if (!GenUtil.equals(oldVersion, version)) {
            this.getBase().setVersion(version);
            this.propertyChanged((short)1031, (Serializable)((Object)oldVersion), (Serializable)((Object)version));
        }
    }

    @Override
    public String getVersion() {
        return this.getBase().getVersion();
    }

    @Override
    protected boolean hasManageableSeed() {
        List<EthSwitchImpl> sws = this.getLan().getEthSwitches();
        for (EthSwitchImpl sw : sws) {
            CdpSeedImpl seed;
            if (sw instanceof FexImpl || !sw.containsFex(this) || (seed = DCManager.getInstance().findTaskBySwPK(sw.getSwitchPK())) == null || !seed.isManageable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportPortVlans() {
        return false;
    }

    @Override
    public void setNumEthPorts(int ethPorts) {
        int oldValue = this._base.getNumEthPorts();
        if (oldValue != ethPorts) {
            this._base.setNumEthPorts(ethPorts);
            this.propertyChanged((short)1064, Integer.valueOf(oldValue), Integer.valueOf(this._base.getNumEthPorts()));
        }
    }

    public void updateNumPorts(int[] vendorType) {
        ((FexBase)this._base).updateNumPorts(vendorType);
    }

    @Override
    public int[] getIfindexes() {
        ArrayList ifindexList = new ArrayList(this._ethPortsByIfindex.keySet());
        Collections.sort(ifindexList);
        int[] ifindexAry = new int[ifindexList.size()];
        for (int i = 0; i < ifindexAry.length; ++i) {
            ifindexAry[i] = (Integer)ifindexList.get(i);
        }
        return ifindexAry;
    }

    @Override
    public String ifIndexToName(int ifIndex) {
        return this.getBase().ifIndexToName(ifIndex);
    }

    @Override
    public int ifNameToIndex(String ifName) {
        return this.getBase().nameToIfIndex(ifName);
    }

    @Override
    public List<EthPortImpl> getEthPorts() {
        return new ArrayList<EthPortImpl>(this._ethPortsByIfindex.values());
    }

    public boolean isFex() {
        return true;
    }

    @Override
    public void cleanCache() {
        this._ethPortsByIfindex.clear();
    }

    @Override
    public void setCredential(SnmpUser user) throws SnmpException {
        if (user == null) {
            return;
        }
        if (!GenUtil.equals(this._credential, user)) {
            this._credential = user;
        }
    }

    @Override
    public SnmpUser getCredential() {
        return this._credential;
    }

    @Override
    public synchronized SnmpPeer getPeer() {
        return null;
    }

    @Override
    public synchronized void createAndSetPeer() {
    }

    @Override
    protected SnmpPeer asyncCreatePeer() throws SnmpException {
        return null;
    }

    @Override
    protected void asyncCreateAndSetPeer() {
    }

    @Override
    public void resetPeer() {
    }

    @Override
    public boolean hasPeer() {
        return false;
    }

    @Override
    public boolean isReachable() {
        return false;
    }

    @Override
    protected void testVPN() {
    }

    @Override
    public String toString() {
        return this.print(false, true);
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        return this.getBase().print(inDetail, withDecor) + (inDetail ? " DiscFlags:" + SwitchImpl.toDiscFlagString(this._discFlags) : "");
    }

    @Override
    public String getPrintString(boolean inDetail, boolean withDecor) {
        return this.getBase().print(inDetail, withDecor) + (inDetail ? " DiscFlags:" + SwitchImpl.toDiscFlagString(this._discFlags) : "");
    }

    public static String toDiscFlagString(int flags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DISC_FLAGS.length; ++i) {
            if ((flags >> i & 1) == 0) continue;
            sb.append(DISC_FLAGS[i]).append(" ");
        }
        return sb.toString();
    }

    @Override
    public PreparedStatement getCheckExistanceStatement(Connection con) throws SQLException {
        return con.prepareStatement(QuerySQL_ByDeviceId);
    }

    @Override
    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this.getDeviceId());
    }
}

