/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.FexIslBase;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Level;

public class FexIslImpl
extends EthIslImpl {
    public FexIslImpl(EthSwitchImpl sw1, EthSwitchImpl sw2, int ifIndex1, int ifIndex2) {
        EthIslPK pkey = new EthIslPK(sw1.getSwitchPK(), sw2.getSwitchPK(), ifIndex1, ifIndex2);
        this._base = new FexIslBase(pkey);
        if (pkey.getSwitch1Key().equals(sw1.getSwitchPK())) {
            this._sw1 = sw1;
            this._sw2 = sw2;
        } else {
            this._sw1 = sw2;
            this._sw2 = sw1;
        }
    }

    @Override
    public FexIslBase getBase() {
        return (FexIslBase)this._base;
    }

    public EthPortImpl getFabricPort() {
        if (this._port1 != null && this._port1.getPK().equals(this.getBase().getFabricPortPK())) {
            return this._port1;
        }
        if (this._port2 != null && this._port2.getPK().equals(this.getBase().getFabricPortPK())) {
            return this._port2;
        }
        return null;
    }

    public EthPortImpl getUplinkPort() {
        if (this._port1 != null && this._port1.getPK().equals(this.getBase().getUplinkPortPK())) {
            return this._port1;
        }
        if (this._port2 != null && this._port2.getPK().equals(this.getBase().getUplinkPortPK())) {
            return this._port2;
        }
        return null;
    }

    public EthSwitchImpl getSwitch() {
        if (this._sw1 != null && this._sw1.getPK().equals(this.getBase().getSwitchPK())) {
            return this._sw1;
        }
        if (this._sw2 != null && this._sw2.getPK().equals(this.getBase().getSwitchPK())) {
            return this._sw2;
        }
        return null;
    }

    public FexImpl getFex() {
        if (this._sw1 != null && this._sw1.getPK().equals(this.getBase().getFexPK())) {
            return (FexImpl)this._sw1;
        }
        if (this._sw2 != null && this._sw2.getPK().equals(this.getBase().getFexPK())) {
            return (FexImpl)this._sw2;
        }
        return null;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent != isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1281, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, "FexIslImpl trace setPresent:old=" + wasPresent + "-->new=" + isPresent + " for " + this.print(false, true), new Exception("TraceLogger"));
            }
        }
        return wasPresent;
    }

    @Override
    public int getOperMode() {
        return this._base.getOperMode();
    }

    @Override
    public String indent(int level) {
        return this._base.indent(level);
    }

    @Override
    public String dumpIfindexNum(int ifindex, boolean withBrace) {
        if (withBrace) {
            return "(" + ifindex + "-0x" + Integer.toHexString(ifindex) + ")";
        }
        return ifindex + "-0x" + Integer.toHexString(ifindex);
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.indent(level)).append("Fex ISL: ").append(this._sw1.getName()).append(',').append(this._sw1.ifIndexToName(this.getIfIndex1())).append(this.dumpIfindexNum(this.getIfIndex1(), true)).append(" <-> ").append(this._sw2.getName()).append(',').append(this._sw2.ifIndexToName(this.getIfIndex2())).append(this.dumpIfindexNum(this.getIfIndex2(), true));
            sb.append(this.indent(level + 1)).append("Status: ").append(this.isPresent() ? "up" : "down").append(", LastScanTime: " + new Date(this.getLastScanTime())).append(this.indent(level + 1)).append("Active Vlans: ").append(this._base.getVlanIdsAsString());
            if (inDetail) {
                sb.append(this.indent(level + 1)).append("OperMode: ").append(this.getOperMode()).append(this.indent(level + 1)).append("Speed: ").append(this.getSpeed()).append(" bps").append(this.indent(level + 1)).append("IsChannel: ").append(this.isPortChannel());
                if (this.isPortChannel() && this.getChildCount() > 0) {
                    int i;
                    sb.append(this.indent(level + 1)).append("Children: ");
                    List<int[]> chList = this.getChildren();
                    ArrayList<Integer> ch1List = new ArrayList<Integer>(chList.size());
                    ArrayList<Integer> ch2List = new ArrayList<Integer>(chList.size());
                    for (int[] pair : chList) {
                        ch1List.add(pair[0]);
                        ch2List.add(pair[1]);
                    }
                    for (i = 0; i < ch1List.size(); ++i) {
                        sb.append(this._sw1.ifIndexToName((Integer)ch1List.get(i))).append(",");
                    }
                    if (sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append("<->");
                    for (i = 0; i < ch2List.size(); ++i) {
                        sb.append(this._sw2.ifIndexToName((Integer)ch2List.get(i))).append(",");
                    }
                    if (sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
                if (this._base.getMatchStatus() != null && this._base.getMatchStatus().length() > 0) {
                    sb.append(this.indent(level + 1)).append("Warning:").append(this._base.getMatchStatus());
                }
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.DEBUG, "EthIsl cannot get dump string", e);
        }
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        try {
            if (withDecor) {
                sb.append("FexIsl-").append(this._sw1.getName()).append(",").append(this._sw1.ifIndexToName(this.getIfIndex1())).append('(').append(this.getIfIndex1()).append(')').append("<->").append(this._sw2.getName()).append(",").append(this._sw2.ifIndexToName(this.getIfIndex2())).append('(').append(this.getIfIndex2()).append(')').append("[");
            } else {
                sb.append(this._sw1.getName()).append(",").append(this._sw1.ifIndexToName(this.getIfIndex1())).append('(').append(this.getIfIndex1()).append(')').append("<->").append(this._sw2.getName()).append(",").append(this._sw2.ifIndexToName(this.getIfIndex2())).append('(').append(this.getIfIndex2()).append(')').append(':');
            }
            if (this.isPortChannel() && this.getChildCount() > 0) {
                int i;
                List<int[]> chList = this.getChildren();
                ArrayList<Integer> ch1List = new ArrayList<Integer>(chList.size());
                ArrayList<Integer> ch2List = new ArrayList<Integer>(chList.size());
                for (int[] pair : chList) {
                    ch1List.add(pair[0]);
                    ch2List.add(pair[1]);
                }
                sb.append(this.getIfIndex1()).append("Children: ");
                for (i = 0; i < ch1List.size(); ++i) {
                    sb.append(this._sw1.ifIndexToName((Integer)ch1List.get(i))).append(",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("<->");
                for (i = 0; i < ch2List.size(); ++i) {
                    sb.append(this._sw2.ifIndexToName((Integer)ch2List.get(i))).append(",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.deleteCharAt(sb.length() - 1);
                }
            }
            if (inDetail) {
                sb.append(", Status=").append(this.isPresent() ? "up" : "down").append(", LastScanTime=" + new Date(this.getLastScanTime())).append(", OperMode=").append(this.getOperMode()).append(", Speed=").append(this.getSpeed()).append(" bps").append(", IsChannel=").append(this.isPortChannel());
            }
            if (withDecor) {
                sb.append("]");
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.DEBUG, "FexIsl cannot get print string", e);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.print(false, false);
    }
}

