/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.vi.model.ClusterComputeResource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class HostClusterImpl
extends AbstractModelObjectImpl {
    static final String QuerySQL = "select id, name, last_update_time from host_cluster";
    static final String QuerySQLByName = "select id, name, last_update_time from host_cluster where name=?";
    static final String QuerySQLByID = "select id, name, last_update_time from host_cluster where id=?";
    static final String QuerySQLByFabricID = "select distinct host_cluster.id, host_cluster.name from host_cluster, enclosure, end_port where end_port.enclosure_id=enclosure.id and enclosure.cluster_id=host_clueter.id and end_port.fabric_id=?";
    static final String InsertSQL = "insert into host_cluster(id, name, last_update_time ) values(?,?,?)";
    static final String UpdateSQL = "update host_cluster set name=?, last_update_time=? where id=?";
    static final String DeleteSQL = "delete from host_cluster where id=?";
    static final String TableName = "host_cluster";
    private final ClusterComputeResource _base;
    private final Set<VHostImpl> _hosts = Collections.synchronizedSet(new HashSet(10));

    public HostClusterImpl(String name) {
        this._base = new ClusterComputeResource(name);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public NameKey getClusterPK() {
        return (NameKey)this._base.getPK();
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
        }
        return wasPresent;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    public String getClusterName() {
        return this._base.getName();
    }

    void setClusterName(String newName) {
        String oldName = this._base.getName();
        this._base.setName(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QuerySQLByName);
            ResultSet rs = null;
            try {
                stat.setString(1, this.getClusterName());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            stat.setLong(1, this.getDBID());
            stat.setString(2, this.getClusterName());
            stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        stat.setString(1, this.getClusterName());
        stat.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        stat.setLong(3, this.getDBID());
        return stat;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<HostClusterImpl> al = new ArrayList<HostClusterImpl>();
        while (rs.next()) {
            HostClusterImpl hostCluster = SanManager.getInstance().createHostCluster(rs.getString(2));
            hostCluster.setDBID(rs.getLong(1));
            al.add(hostCluster);
        }
        return al;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getDeleteSqlStr() {
        return DeleteSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByName;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setString(2, this.getClusterName());
        stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this.getClusterName());
        stat.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        stat.setLong(3, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this.getClusterName());
    }

    public void addHost(VHostImpl host) {
        if (!this._hosts.contains(host)) {
            this._hosts.add(host);
        } else {
            Iterator<VHostImpl> it = this._hosts.iterator();
            while (it.hasNext()) {
                VHostImpl oldHost = it.next();
                if (!oldHost.getPK().equals(host.getPK()) || oldHost == host) continue;
                it.remove();
                this._hosts.add(host);
                break;
            }
        }
        host.setCluster(this);
    }

    public void removeHost(VHostImpl host) {
        host.setCluster(null);
        this._hosts.remove(host);
    }

    public List<VHostImpl> getHosts() {
        return new ArrayList<VHostImpl>(this._hosts);
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(VirtualCenterImpl.LIL[level]).append("Host Cluster: ").append(this.getClusterName());
        sb.append(VirtualCenterImpl.LIL[level + 1]).append("VHosts: ");
        if (this._hosts.size() == 0) {
            sb.append("n/a");
        } else {
            for (VHostImpl host : this._hosts) {
                if (host == null) continue;
                sb.append(VirtualCenterImpl.LIL[level + 2]).append(host.getHostName());
            }
        }
        return sb.toString();
    }
}

