/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.HostBase;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.HostMapImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HostImpl
extends AbstractModelObjectImpl {
    static final TraceLogger _logger = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String QuerySQL = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host";
    public static final String QuerySQLByName = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host where name=?";
    public static final String QuerySQLByVHostId = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host where vhost_id=?";
    public static final String QuerySQLEsitingRecord = "select id from host where name=?";
    public static final String QuerySQLByFabricId = "select h.id, h.name, h.full_name, h.enclosure_id, h.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h, enclosure e, end_port ep where h.enclosure_id=e.id and e.enc_type=47 and e.id=ep.enclosure_id and ep.fabric_id=?";
    public static final String QuerySQLById = "select id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time from host where id=?";
    static final String QuerySQLInvalidSanHosts = "select h.id, h.name, h.full_name, h.enclosure_id, h.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h where h.enclosure_id > 0 and h.enclosure_id not in (select id from enclosure where enc_type=47)";
    public static final String QuerySanHostSQL = "select h.id, h.name, h.full_name, h.enclosure_id, h.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h where h.enclosure_id>0";
    public static final String QueryVHostHostSQL = "select h.id, h.name, h.full_name, h.enclosure_id, h.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h where h.vhost_id>0";
    public static final String QueryHostByMacSQL = "select h.id, h.name, h.full_name, h.enclosure_id, h.vhost_id, h.user_modified, h.mac, h.ip, h.pwwn, h.multipath, h.os_info, h.hbas, h.vcluster, h.created_time, h.last_updated_time from host h where ((h.vhost_id in (select id from vhost where upper(mac_address) like ?)) or (h.vhost_id in (select vhost_id from phynic where upper(mac) like ?)) or (h.vhost_id in (select vh.id from vhost vh, vm vm left join vnic vn on upper(mac) like ? where vh.id=vm.vhost_id and vm.id=vn.vm_id)))";
    public static final String QueryEnclosureByFabricIdSQL = "select distinct e.id, e.name, e.vhost_id from enclosure e, end_port ep where e.id=ep.enclosure_id and e.enc_type=47 and ep.fabric_id=?";
    public static final String QueryFexNameSQL = "select fs.id, fs.sys_name from ethswitch s, ethswitch fs, ethswitch_fex f where s.id=? and f.switch_id=s.id and fs.id=f.fex_id and fs.fex_id=?";
    public static final String QueryVhostSQL = "select v.id, v.name, v.full_name from vhost v";
    public static final String QueryPhynicSQL = "select count(*) from phynic p where upper(p.mac)=?";
    public static final String QueryVnicSQL = "select count(*) from vnic v where upper(v.mac)=?";
    public static final String QueryVhostMacSQL = "select count(*) from vhost v where upper(v.mac_address) like ?";
    public static final String DeleteSQL = "delete from host where id=?";
    public static final String DeleteAllLanHostSQL = "delete from host where enclosure_id=0 and vhost_id=0";
    public static final String DeleteInvalidLanHostSQL = "delete from host where enclosure_id=0 and vhost_id=0 and (id not in (select host_id from lan_host)  or name not in (select name from lan_host))";
    public static final String DeleteInvalidSANHostsSQL = "delete from host h where h.enclosure_id > 0 and h.enclosure_id not in (select id from enclosure where enc_type=47)";
    public static final String InsertSQL = "insert into host(id, name, full_name, enclosure_id, vhost_id, user_modified, mac, ip, pwwn, multipath, os_info, hbas, vcluster, created_time, last_updated_time) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?)";
    public static final String UpdateSQL = "update host set name=?, full_name=?, enclosure_id=?, vhost_id=?, user_modified=?, mac=?, ip=?, pwwn=?, multipath=?, os_info=?, hbas=?, vcluster=?, last_updated_time=? where id=?";
    static final String TableName = "host";
    private final HostBase _base;

    public HostImpl(String name) {
        this._base = new HostBase(name);
    }

    public HostImpl(long id, String name, String fullName, long enclosureId, long vhostId, boolean userModified, String mac, String ip, String pwwn, String multipath, String osinfo, String hbas, String vcluster) {
        super.setDBID(id);
        this._base = new HostBase(name, fullName);
        this._base.setId(id);
        this._base.setEnclosureId(enclosureId);
        this._base.setVhostId(vhostId);
        this._base.setUserModified(userModified);
        this._base.setMac(mac);
        this._base.setIp(ip);
        this._base.setPwwn(pwwn);
        this._base.setMultipath(multipath);
        this._base.setOsInfo(osinfo);
        this._base.setVcluster(vcluster);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public HostBase getBase() {
        return this._base;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1793, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    @Override
    public void setDBID(long id) {
        super.setDBID(id);
        this._base.setId(id);
    }

    public String getName() {
        return this._base.getName();
    }

    public void setName(String name) {
        this._base.setName(name);
    }

    public String getFullName() {
        return this._base.getFullName();
    }

    public void setFullName(String value) {
        this._base.setFullName(value);
    }

    public String getMac() {
        return this._base.getMac();
    }

    public void setMac(String value) {
        this._base.setMac(value);
    }

    public String getIp() {
        return this._base.getIp();
    }

    public void setIp(String ip) {
        this._base.setIp(ip);
    }

    public String getPwwn() {
        return this._base.getPwwn();
    }

    public void setPwwn(String pwwn) {
        this._base.setPwwn(pwwn);
    }

    public String getMutipath() {
        return this._base.getMultipath();
    }

    public void setMultipath(String multipath) {
        this._base.setMultipath(multipath);
    }

    public String getOsInfo() {
        return this._base.getOsInfo();
    }

    public void setOsInfo(String osinfo) {
        this._base.setOsInfo(osinfo);
    }

    public String getHbas() {
        return this._base.getHbas();
    }

    public void setHbas(String hbas) {
        this._base.setHbas(hbas);
    }

    public String getVcluster() {
        return this._base.getVcluster();
    }

    public void setVcluster(String vcluster) {
        this._base.setVcluster(vcluster);
    }

    public Timestamp getCreatedTime() {
        return this._base.getCreatedTime();
    }

    public void setCreatedTime(Timestamp t) {
        this._base.setCreatedTime(t);
    }

    public Timestamp getLastUpdatedTime() {
        return this._base.getLastUpdatedTime();
    }

    public void setLastUpdatedTime(Timestamp t) {
        this._base.setLastUpdatedTime(t);
    }

    public long getEnclosureId() {
        return this._base.getEnclosureId();
    }

    public void setEnclosureId(long id) {
        this._base.setEnclosureId(id);
    }

    public long getVhostId() {
        return this._base.getVhostId();
    }

    public void setVhostId(long id) {
        this._base.setVhostId(id);
    }

    public boolean isEnclosure() {
        return this._base.getEnclosureId() > 0L;
    }

    public boolean isVhost() {
        return this._base.getVhostId() > 0L;
    }

    public boolean isUserModified() {
        return this._base.isUserModified();
    }

    public void setUserModified(boolean value) {
        this._base.setUserModified(value);
    }

    public void setData(Connection con) {
        VHostImpl vhost;
        EnclosureImpl enc;
        this._base.clear();
        if (this.getEnclosureId() > 0L && (enc = SanManager.getInstance().findEnclosureByName(this.getName())) != null) {
            List<Wwn> pwwns;
            if (enc.getIpAddress() != null && !enc.getIpAddress().equalsIgnoreCase("null")) {
                if (this.getIp() == null || this.getIp().length() == 0) {
                    this.setIp(enc.getIpAddress());
                } else if (enc.getIpAddress() != null && this.getIp().indexOf(enc.getIpAddress()) < 0) {
                    this.setIp(this.getIp() + "," + enc.getIpAddress());
                }
            }
            if ((pwwns = HostManager.getPortWwnByEnclosureId(con, enc.getDBID())) != null && !pwwns.isEmpty()) {
                String wwns = "";
                for (int i = 0; i < pwwns.size() - 1; ++i) {
                    String pwwn;
                    if (pwwns.get(i) == null || wwns.indexOf(pwwn = pwwns.get(i).toHexString(true).toUpperCase()) >= 0 || this.getPwwn() != null && this.getPwwn().indexOf(pwwn) >= 0) continue;
                    wwns = wwns + pwwn + ",";
                }
                String pwwn = pwwns.get(pwwns.size() - 1).toHexString(true).toUpperCase();
                if (wwns.indexOf(pwwn) < 0 && (this.getPwwn() == null || this.getPwwn().indexOf(pwwn) < 0)) {
                    wwns = wwns + pwwn;
                }
                if (this.getPwwn() == null || this.getPwwn().length() == 0) {
                    this.setPwwn(wwns);
                } else {
                    this.setPwwn(this.getPwwn() + "," + wwns);
                }
            }
        }
        if (this.getVhostId() > 0L && (vhost = VHostImpl.getVhostById(this.getVhostId())) != null) {
            PhyNicImpl[] phynics;
            this.setVcluster(vhost.getClusterName());
            if (this.getHbas() == null || this.getHbas().length() == 0) {
                this.setHbas(vhost.getHbasAsString());
            } else if (vhost.getHbasAsString() != null && this.getHbas().indexOf(vhost.getHbasAsString()) < 0) {
                this.setHbas(this.getHbas() + "," + vhost.getHbasAsString());
            }
            this.setFullName(vhost.getHostFullName());
            if (this.getIp() == null || this.getIp().length() == 0) {
                this.setIp(vhost.getIpAddressesAsString());
            } else if (vhost.getIpAddressesAsString() != null && this.getIp().indexOf(vhost.getIpAddressesAsString()) < 0) {
                this.setIp(this.getIp() + "," + vhost.getIpAddressesAsString());
            }
            this.setOsInfo(vhost.getOsType());
            this.setMultipath(vhost.getMultiPath());
            String mac = "";
            if (vhost.getMacAddressesAsString() != null && vhost.getMacAddressesAsString().length() > 0) {
                mac = vhost.getMacAddressesAsString().toUpperCase();
            }
            if ((phynics = vhost.getPhyNics()) != null && phynics.length > 0) {
                if (mac.length() > 0) {
                    mac = mac + ",";
                }
                for (int i = 0; i < phynics.length - 1; ++i) {
                    if (mac.indexOf(phynics[i].getMac().toUpperCase()) >= 0 || this.getMac() != null && this.getMac().indexOf(phynics[i].getMac().toUpperCase()) >= 0) continue;
                    mac = mac + phynics[i].getMac().toUpperCase() + ",";
                }
                String temp = phynics[phynics.length - 1].getMac().toUpperCase();
                if (mac.indexOf(temp) < 0 && (this.getMac() == null || this.getMac().indexOf(temp) < 0)) {
                    mac = mac + temp;
                }
            }
            if (this.getMac() == null || this.getMac().length() == 0) {
                this.setMac(mac);
            } else {
                this.setMac(this.getMac() + "," + mac);
            }
            ArrayList<Wwn> pwwns = vhost.getHbas();
            if (pwwns != null && !pwwns.isEmpty()) {
                String wwns = "";
                for (int i = 0; i < pwwns.size() - 1; ++i) {
                    String pwwn;
                    if (pwwns.get(i) == null || wwns.indexOf(pwwn = ((Wwn)pwwns.get(i)).toHexString(true).toUpperCase()) >= 0 || this.getPwwn() != null && this.getPwwn().indexOf(pwwn) >= 0) continue;
                    wwns = wwns + pwwn + ",";
                }
                String pwwn = ((Wwn)pwwns.get(pwwns.size() - 1)).toHexString(true).toUpperCase();
                if (wwns.indexOf(pwwn) < 0 && (this.getPwwn() == null || this.getPwwn().indexOf(pwwn) < 0)) {
                    wwns = wwns + pwwn;
                }
                if (this.getPwwn() == null || this.getPwwn().length() == 0) {
                    this.setPwwn(wwns);
                } else {
                    this.setPwwn(this.getPwwn() + "," + wwns);
                }
            }
        }
    }

    public void setData(Connection con, LanHostImpl lanHost) {
        if (lanHost != null) {
            if (this.getMac() == null || this.getMac().length() == 0) {
                this.setMac(lanHost.getMac());
            } else if (lanHost.getMac() != null && this.getMac() != null && this.getMac().indexOf(lanHost.getMac()) < 0) {
                this.setMac(this.getMac() + "," + lanHost.getMac());
            }
            if (this.getIp() == null || this.getIp().length() == 0) {
                this.setIp(lanHost.getIpAddress());
            } else if (lanHost.getIpAddress() != null && lanHost.getIpAddress() != null && this.getIp().indexOf(lanHost.getIpAddress()) < 0) {
                this.setIp(this.getIp() + "," + lanHost.getIpAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QuerySQLEsitingRecord);
            ResultSet rs = null;
            try {
                int i = 1;
                stat.setString(i++, this.getName());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "checkPreexistRecord caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setString(i++, this.getName());
        stat.setString(i++, this._base.getFullName());
        stat.setLong(i++, this._base.getEnclosureId());
        stat.setLong(i++, this._base.getVhostId());
        stat.setBoolean(i++, this._base.isUserModified());
        if (this._base.getMac() != null && this._base.getMac().length() > 4000) {
            stat.setString(i++, this._base.getMac().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getMac());
        }
        if (this._base.getIp() != null && this._base.getIp().length() > 4000) {
            stat.setString(i++, this._base.getIp().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getIp());
        }
        if (this._base.getPwwn() != null && this._base.getPwwn().length() > 4000) {
            stat.setString(i++, this._base.getPwwn().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getPwwn());
        }
        if (this._base.getMultipath() != null && this._base.getMultipath().length() > 1024) {
            stat.setString(i++, this._base.getMultipath().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getMultipath());
        }
        if (this._base.getOsInfo() != null && this._base.getOsInfo().length() > 1024) {
            stat.setString(i++, this._base.getOsInfo().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getOsInfo());
        }
        if (this._base.getHbas() != null && this._base.getHbas().length() > 4000) {
            stat.setString(i++, this._base.getHbas().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getHbas());
        }
        stat.setString(i++, this._base.getVcluster());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setString(i++, this.getName());
        stat.setString(i++, this._base.getFullName());
        stat.setLong(i++, this._base.getEnclosureId());
        stat.setLong(i++, this._base.getVhostId());
        stat.setBoolean(i++, this._base.isUserModified());
        if (this._base.getMac() != null && this._base.getMac().length() > 4000) {
            stat.setString(i++, this._base.getMac().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getMac());
        }
        if (this._base.getIp() != null && this._base.getIp().length() > 4000) {
            stat.setString(i++, this._base.getIp().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getIp());
        }
        if (this._base.getPwwn() != null && this._base.getPwwn().length() > 4000) {
            stat.setString(i++, this._base.getPwwn().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getPwwn());
        }
        if (this._base.getMultipath() != null && this._base.getMultipath().length() > 1024) {
            stat.setString(i++, this._base.getMultipath().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getMultipath());
        }
        if (this._base.getOsInfo() != null && this._base.getOsInfo().length() > 1024) {
            stat.setString(i++, this._base.getOsInfo().substring(0, 1023));
        } else {
            stat.setString(i++, this._base.getOsInfo());
        }
        if (this._base.getHbas() != null && this._base.getHbas().length() > 4000) {
            stat.setString(i++, this._base.getHbas().substring(0, 3999));
        } else {
            stat.setString(i++, this._base.getHbas());
        }
        stat.setString(i++, this._base.getVcluster());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getDBID());
    }

    @Override
    public String toString() {
        return "HostImpl [_base=" + this._base + "]";
    }

    public static List<HostImpl> loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        if (rs == null) {
            return list;
        }
        while (rs.next()) {
            int i = 1;
            long id = rs.getLong(i++);
            String name = rs.getString(i++);
            String fullName = rs.getString(i++);
            long enclosure_id = rs.getLong(i++);
            long vhost_id = rs.getLong(i++);
            boolean userModified = rs.getBoolean(i++);
            String mac = rs.getString(i++);
            String ip = rs.getString(i++);
            String pwwn = rs.getString(i++);
            String multipath = rs.getString(i++);
            String osinfo = rs.getString(i++);
            String hbas = rs.getString(i++);
            String vcluster = rs.getString(i++);
            Timestamp createdTime = rs.getTimestamp(i++);
            Timestamp lastUpdatedTime = rs.getTimestamp(i++);
            HostImpl host = new HostImpl(id, name, fullName, enclosure_id, vhost_id, userModified, mac, ip, pwwn, multipath, osinfo, hbas, vcluster);
            host.setCreatedTime(createdTime);
            host.setLastUpdatedTime(lastUpdatedTime);
            list.add(host);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHost(Connection con, HostImpl host) {
        if (host == null) {
            return;
        }
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteSQL);
            deleteStat.setLong(1, host.getDBID());
            deleteStat.execute();
            List<HostMapImpl> hostMaps = HostMapImpl.loadHostMapsByHostId(con, host.getDBID());
            if (hostMaps != null && !hostMaps.isEmpty()) {
                HostMapImpl.deleteHostMaps(con, hostMaps);
            }
        }
        catch (Exception ex) {
            try {
                con.rollback();
            }
            catch (Exception sqlex) {
                // empty catch block
            }
            _logger.log(Level.ERROR, "deleteHost caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHosts(Connection con, List<HostImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        for (HostImpl h : hosts) {
            try {
                deleteStat = con.prepareStatement(DeleteSQL);
                deleteStat.setLong(1, h.getDBID());
                deleteStat.execute();
                List<HostMapImpl> hostMaps = HostMapImpl.loadHostMapsByHostId(con, h.getDBID());
                if (hostMaps != null && !hostMaps.isEmpty()) {
                    HostMapImpl.deleteHostMaps(con, hostMaps);
                }
                _logger.log(Level.DEBUG, "done deleteHost: " + h.getName());
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "deleteHost '" + h.getName() + "' failed", ex);
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ex != null && ex.getNextException() != null) {
                    _logger.log(Level.WARN, "deleteHosts failed and got SQLException", ex.getNextException());
                    continue;
                }
                _logger.log(Level.WARN, "deleteHosts failed and got SQLException", ex);
            }
            finally {
                DbUtil.close(deleteStat);
            }
        }
        _logger.log(Level.INFO, "deleteHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, deleted: " + hosts.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistHost(Connection con, HostImpl host) {
        PreparedStatement updateStat;
        PreparedStatement insertStat;
        block6: {
            if (host == null) {
                return;
            }
            insertStat = null;
            updateStat = null;
            try {
                insertStat = con.prepareStatement(InsertSQL);
                updateStat = con.prepareStatement(UpdateSQL);
                if (host.getDBID() > 0L) {
                    host.setupUpdateStatement(updateStat);
                    updateStat.executeUpdate();
                    break block6;
                }
                host.setDBID(Sequence.getSequence().getPK());
                host.setupInsertStatement(insertStat);
                insertStat.execute();
            }
            catch (Exception ex) {
                try {
                    _logger.log(Level.WARN, "persistsHosts caught exception", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(insertStat);
                    DbUtil.close(updateStat);
                    throw throwable;
                }
                DbUtil.close(insertStat);
                DbUtil.close(updateStat);
            }
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void persistHosts(Connection con, List<HostImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        int MAX_COUNT = 500;
        long startTime = System.currentTimeMillis();
        Statement insertStat = null;
        Statement updateStat = null;
        int insertCount = 0;
        int updateCount = 0;
        int total = 0;
        try {
            for (HostImpl h : hosts) {
                if (insertStat == null) {
                    insertStat = con.prepareStatement(InsertSQL);
                }
                if (updateStat == null) {
                    updateStat = con.prepareStatement(UpdateSQL);
                }
                try {
                    if (h.getDBID() == 0L) {
                        h.setDBID(Sequence.getSequence().getPK());
                        h.setupInsertStatement((PreparedStatement)insertStat);
                        insertStat.addBatch();
                        ++insertCount;
                    } else if (h.getBase().isModified()) {
                        h.setupUpdateStatement((PreparedStatement)updateStat);
                        updateStat.addBatch();
                        ++updateCount;
                    }
                    ++total;
                    if (insertCount == MAX_COUNT) {
                        try {
                            insertStat.executeBatch();
                        }
                        catch (SQLException sqlex) {
                            if (sqlex != null && sqlex.getNextException() != null) {
                                _logger.log(Level.WARN, "insertHosts failed and got SQLException", sqlex.getNextException());
                            } else {
                                _logger.log(Level.WARN, "insertHosts failed and got SQLException", sqlex);
                            }
                        }
                        finally {
                            DbUtil.close(insertStat);
                            insertStat = null;
                            insertCount = 0;
                        }
                    }
                    if (updateCount != MAX_COUNT) continue;
                    try {
                        updateStat.executeBatch();
                    }
                    catch (SQLException sqlex) {
                        if (sqlex != null && sqlex.getNextException() != null) {
                            _logger.log(Level.WARN, "updateHosts failed and got SQLException", sqlex.getNextException());
                            continue;
                        }
                        _logger.log(Level.WARN, "updateHosts failed and got SQLException", sqlex);
                    }
                    finally {
                        DbUtil.close(updateStat);
                        updateStat = null;
                        updateCount = 0;
                    }
                }
                catch (SQLException ex) {
                    _logger.log(Level.ERROR, "persistHost '" + h.getName() + "' failed", ex);
                }
            }
            if (insertStat != null) {
                insertStat.executeBatch();
            }
            if (updateStat != null) {
                updateStat.executeBatch();
            }
            con.commit();
            _logger.log(Level.INFO, "persistHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, persisted: " + total);
        }
        catch (SQLException sqlex) {
            block33: {
                if (sqlex != null && sqlex.getNextException() != null) {
                    _logger.log(Level.WARN, "persistsHosts failed and got SQLException", sqlex.getNextException());
                    break block33;
                }
                _logger.log(Level.WARN, "persistsHosts failed and got SQLException", sqlex);
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "persistsHosts failed and got exception", ex);
            {
                catch (Throwable throwable) {
                    DbUtil.close(insertStat);
                    DbUtil.close(updateStat);
                    throw throwable;
                }
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByName(Connection con, String name) {
        HostImpl host;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            host = null;
            try {
                List<HostImpl> hosts;
                stat = con.prepareStatement(QuerySQLByName);
                stat.setString(1, name);
                rs = stat.executeQuery();
                if (rs != null && (hosts = HostImpl.loadDBRecord(rs)) != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getHostByName caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByVHostId(Connection con, long id) {
        HostImpl host;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            host = null;
            try {
                List<HostImpl> hosts;
                stat = con.prepareStatement(QuerySQLByVHostId);
                stat.setLong(1, id);
                rs = stat.executeQuery();
                if (rs != null && (hosts = HostImpl.loadDBRecord(rs)) != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getHostByName caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<HostImpl> loadHostsFromDB() throws SQLException {
        ArrayList<HostImpl> result = new ArrayList();
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            result = HostImpl.loadHostsFromDB(con);
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "Load hosts from DB failed", ex);
            List<HostImpl> list = null;
            return list;
        }
        finally {
            DbUtil.close(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<HostImpl> loadHostsFromDB(Connection con) throws SQLException {
        ArrayList<HostImpl> result = new ArrayList();
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            queryStat = con.prepareStatement(QuerySQL);
            rs = queryStat.executeQuery();
            result = HostImpl.loadDBRecord(rs);
        }
        catch (Exception ex) {
            List<HostImpl> list;
            try {
                _logger.log(Level.WARN, "Load hosts from DB failed", ex);
                list = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupLanHosts(Connection con) {
        long startTime = System.currentTimeMillis();
        PreparedStatement hostStat = null;
        try {
            hostStat = con.prepareStatement(DeleteInvalidLanHostSQL);
            hostStat.execute();
        }
        catch (SQLException ex) {
            _logger.log(Level.ERROR, "deleteInvalidHosts failed. ", ex);
        }
        finally {
            DbUtil.close(hostStat);
        }
        _logger.info("cleanupHosts: finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HostImpl getHostByMac(Connection con, String mac) {
        HostImpl host;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            host = null;
            try {
                List<HostImpl> hosts;
                String macAddr = "%" + mac + "%";
                stat = con.prepareStatement(QueryHostByMacSQL);
                stat.setString(1, macAddr);
                stat.setString(2, macAddr);
                stat.setString(3, macAddr);
                rs = stat.executeQuery();
                if (rs != null && (hosts = HostImpl.loadDBRecord(rs)) != null && !hosts.isEmpty()) {
                    host = hosts.get(0);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getHostByMac caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadSanHostsFromDB(Connection con) throws SQLException {
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        List<HostImpl> list = null;
        try {
            queryStat = con.prepareStatement(QuerySanHostSQL);
            rs = queryStat.executeQuery();
            list = HostImpl.loadDBRecord(rs);
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.WARN, "loadSanHostsFromDB failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadEnclosuresByFabricIdFromDB(Connection con, long fId) throws SQLException {
        ArrayList<HostImpl> id2;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        try {
            queryStat = con.prepareStatement(QueryEnclosureByFabricIdSQL);
            queryStat.setLong(1, fId);
            rs = queryStat.executeQuery();
            while (rs.next()) {
                long id2 = rs.getLong(1);
                String name = rs.getString(2);
                long vhost_id = rs.getLong(3);
                HostImpl host = new HostImpl(name);
                host.getBase().setEnclosureId(id2);
                if (vhost_id > 0L) {
                    host.getBase().setVhostId(vhost_id);
                }
                list.add(host);
            }
            id2 = list;
        }
        catch (Exception ex) {
            List<HostImpl> list2;
            try {
                _logger.log(Level.WARN, "load enclosures from DB failed", ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadVHostHostsFromDB(Connection con) throws SQLException {
        ArrayList<HostImpl> arrayList;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList();
        try {
            queryStat = con.prepareStatement(QueryVHostHostSQL);
            rs = queryStat.executeQuery();
            arrayList = list = HostImpl.loadDBRecord(rs);
        }
        catch (Exception ex) {
            List<HostImpl> list2;
            try {
                _logger.log(Level.WARN, "loadVHostHostsFromDB failed", ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> loadVHostsFromDB(Connection con) throws SQLException {
        ArrayList<HostImpl> id2;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        ArrayList<HostImpl> list = new ArrayList<HostImpl>();
        try {
            queryStat = con.prepareStatement(QueryVhostSQL);
            rs = queryStat.executeQuery();
            while (rs.next()) {
                long id2 = rs.getLong(1);
                String name = rs.getString(2);
                String fullName = rs.getString(3);
                HostImpl host = new HostImpl(name);
                host.getBase().setVhostId(id2);
                host.setFullName(fullName);
                list.add(host);
            }
            id2 = list;
        }
        catch (Exception ex) {
            List<HostImpl> list2;
            try {
                _logger.log(Level.WARN, "loadVHostsFromDB failed", ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostImpl> getInvalidSanHosts(Connection con) throws SQLException {
        ArrayList<HostImpl> hosts = new ArrayList();
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            queryStat = con.prepareStatement(QuerySQLInvalidSanHosts);
            rs = queryStat.executeQuery();
            hosts = HostImpl.loadDBRecord(rs);
        }
        catch (Exception ex) {
            List<HostImpl> list;
            try {
                _logger.log(Level.WARN, "load SAN host Ids failed", ex);
                list = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            return list;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        return hosts;
    }

    public static void cleanupLanHosts() {
        HostManager.getInstance().stopLanHostWorker();
        Thread cleanup = new Thread((Runnable)new CleanupLanHosts(), "CleanupLanHosts");
        cleanup.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOldSanHosts(Connection con) {
        PreparedStatement stat = null;
        try {
            long startTime = System.currentTimeMillis();
            stat = con.prepareStatement(DeleteInvalidSANHostsSQL);
            stat.execute();
            _logger.info("deleteOldSanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.ERROR, "deleteOldSanHosts caught exception", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                throw throwable;
            }
            DbUtil.close(stat);
        }
        DbUtil.close(stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllLanHosts(Connection con) {
        PreparedStatement stat = null;
        long startTime = System.currentTimeMillis();
        try {
            stat = con.prepareStatement(DeleteAllLanHostSQL);
            stat.execute();
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteAllLanHosts caught exception", ex);
        }
        finally {
            DbUtil.close(stat);
        }
        _logger.info("deleteAllLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public static void deleteOldLanHosts(Connection con) {
        try {
            long startTime = System.currentTimeMillis();
            LanHostImpl.deleteInvalidLanHosts(con);
            HostImpl.cleanupLanHosts(con);
            _logger.info("deleteOldLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteOldLanHosts caught exception", ex);
        }
    }

    public static class CleanupLanHosts
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            Connection con = null;
            try {
                con = ConnectionManager.getConnection();
                LanImpl lan = DCManager.getInstance().getLan();
                List<EthSwitchImpl> swList = null;
                if (lan != null) {
                    swList = lan.getEthSwitches();
                }
                if (swList == null || swList.isEmpty()) {
                    LanHostImpl.deleteAllLanHosts(con);
                    HostImpl.cleanupLanHosts(con);
                } else {
                    HostImpl.deleteOldLanHosts(con);
                }
            }
            catch (Exception e) {
                _logger.log(Level.ERROR, "cleanupLanHosts caught exception", e);
            }
            finally {
                DbUtil.close(con);
            }
            _logger.info("cleanupLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }
}

