/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.LanHostBase;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.LanImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LanHostImpl
extends AbstractModelObjectImpl {
    static final TraceLogger _logger = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String QueryIdByHostIdSQL = "select id from lan_host where host_id=?";
    public static final String QuerySQLByVhostId = "select id, name, description, mac, eth_switch_id, eth_ifname, ipaddress, ethswitch_port_id, vlan, vhost_id, host_id, created_time, last_updated_time from lan_host where vhost_id=?";
    public static final String QueryFexNameSQL = "select fs.id, fs.sys_name from ethswitch s, ethswitch fs, ethswitch_fex f where s.id=? and f.switch_id=s.id and fs.id=f.fex_id and fs.fex_id=?";
    public static final String QuerySQLBySwitchId = "select id, name, description, mac, eth_switch_id, eth_ifname, ipaddress, ethswitch_port_id, vlan, vhost_id, host_id, created_time, last_updated_time from lan_host where eth_switch_id=? or eth_switch_id in (select f.fex_id from ethswitch_fex f where f.switch_id=?)";
    public static final String QueryIdsBySwitchIdSQL = "select id from lan_host where eth_switch_id=?";
    public static final String QuerySwitchIdsSQL = "select distinct eth_switch_id from lan_host";
    public static final String QueryExistingRecordSQL = "select id, name, description, mac, eth_switch_id, eth_ifname, ipaddress, ethswitch_port_id, vlan, vhost_id, host_id, created_time, last_updated_time from lan_host where mac=? and eth_switch_id=? and eth_ifname=? and vlan=?";
    public static final String DeleteAllSQL = "delete from lan_host";
    public static final String DeleteSQLById = "delete from lan_host where id=?";
    public static final String DeleteSQLByHostId = "delete from lan_host where host_id=?";
    public static final String DeleteInvalidLanHostsSQL = "delete from lan_host l where l.eth_switch_id not in (select id from ethswitch) or l.host_id not in (select id from host)";
    public static final String InsertSQL = "insert into lan_host(id, name, description, mac, eth_switch_id, eth_ifname, ipaddress, ethswitch_port_id, vlan, vhost_id, host_id, created_time, last_updated_time) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    public static final String UpdateSQL = "update lan_host set name=?, description=?, mac=?, eth_switch_id=?, eth_ifname=?, ipaddress=?, ethswitch_port_id=?, vlan=?, vhost_id=?, host_id=?, last_updated_time=? where id=?";
    static final String TableName = "LAN_HOST";
    private final LanHostBase base;

    public LanHostImpl(String chassisId) {
        this.base = new LanHostBase(chassisId);
    }

    public LanHostImpl(String name, String desc, String mac, long ethSwId, String ifName, String ip, int vlan) {
        long portId = -1L;
        try {
            portId = EthPortImpl.queryDbIdBySwIdAndIfName(ethSwId, ifName);
        }
        catch (Exception e) {
            _logger.log(Level.WARN, "failed to get ethswitch port id for [ip='" + ip + ", ifName='" + ifName + "']", e);
        }
        this.base = new LanHostBase(name, desc, mac, ethSwId, ifName, ip, portId, vlan);
    }

    public LanHostImpl(String name, String desc, String mac, long ethSwId, String ifName, String ip, int vlan, long vhostId) {
        long portId = -1L;
        try {
            portId = EthPortImpl.queryDbIdBySwIdAndIfName(ethSwId, ifName);
        }
        catch (Exception e) {
            _logger.log(Level.WARN, "failed to get ethswitch port id for [ip='" + ip + ", ifName='" + ifName + "']", e);
        }
        this.base = new LanHostBase(name, desc, mac, ethSwId, ifName, ip, portId, vlan, vhostId);
    }

    public LanHostImpl(String name, String desc, String mac, long ethSwId, String ifName, String ip, long portId, int vlan) {
        this.base = new LanHostBase(name, desc, mac, ethSwId, ifName, ip, portId, vlan);
    }

    public LanHostImpl(String name, String desc, String mac, long ethSwId, String ifName, String ip, long portId, int vlan, long vhostId) {
        this.base = new LanHostBase(name, desc, mac, ethSwId, ifName, ip, portId, vlan, vhostId);
    }

    public LanHostImpl(LanHostBase lanHost) {
        long portId = -1L;
        long swId = lanHost.getEthSwitchId();
        String ifName = lanHost.getEthIfName();
        try {
            portId = EthPortImpl.queryDbIdBySwIdAndIfName(swId, ifName);
            lanHost.setEthSwitchPortId(portId);
        }
        catch (Exception e) {
            _logger.log(Level.WARN, "failed to get ethswitch port id for [id='" + swId + ", ifName='" + ifName + "']", e);
        }
        this.base = lanHost;
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this.base;
    }

    public String getName() {
        return this.base.getName();
    }

    public void setName(String name) {
        this.base.setName(name);
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this.base.isPresent();
        if (wasPresent ^ isPresent) {
            this.base.setPresent(isPresent);
            this.propertyChanged((short)1793, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    public LanHostBase getLanHostBase() {
        return this.base;
    }

    @Override
    public void setDBID(long id) {
        super.setDBID(id);
        this.base.setId(id);
    }

    public Timestamp getCreatedTime() {
        return this.base.getCreatedTime();
    }

    public void setCreatedTime(Timestamp time) {
        this.base.setCreatedTime(time);
    }

    public Timestamp getLastUpdatedTime() {
        return this.base.getLastUpdatedTime();
    }

    public void setLastUpdatedTime(Timestamp time) {
        this.base.setLastUpdatedTime(time);
    }

    public String getMac() {
        return this.base.getMac();
    }

    public void setMac(String mac) {
        if (mac != null) {
            this.base.setMac(mac);
        }
    }

    public String getIpAddress() {
        return this.base.getIpAddress();
    }

    public void setIpAddress(String ip) {
        this.base.setIpAddress(ip);
    }

    public long getEthSwitchId() {
        return this.base.getEthSwitchId();
    }

    public void setEthSwitchId(long id) {
        this.base.setEthSwitchId(id);
    }

    public String getEthIfName() {
        return this.base.getEthIfName();
    }

    public void setEthIfName(String ifName) {
        this.base.setEthIfName(ifName);
    }

    public int getVlan() {
        return this.base.getVlan();
    }

    public void setVlan(int value) {
        this.base.setVlan(value);
    }

    public long getVhostId() {
        return this.base.getVhostId();
    }

    public void setVhostId(long vhostId) {
        this.base.setVhostId(vhostId);
    }

    public long getHostId() {
        return this.base.getHostId();
    }

    public void setHostId(long hostId) {
        this.base.setHostId(hostId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QueryExistingRecordSQL);
            ResultSet rs = null;
            try {
                stat.setString(1, this.base.getMac());
                stat.setLong(2, this.base.getEthSwitchId());
                stat.setString(3, this.base.getEthIfName());
                stat.setInt(4, this.base.getVlan());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "checkPreexistRecord caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setString(i++, this.base.getName());
        stat.setString(i++, this.base.getDescription());
        stat.setString(i++, this.base.getMac());
        stat.setLong(i++, this.base.getEthSwitchId());
        stat.setString(i++, this.base.getEthIfName());
        stat.setString(i++, this.base.getIpAddress());
        stat.setLong(i++, this.base.getEthSwitchPortId());
        stat.setInt(i++, this.base.getVlan());
        stat.setLong(i++, this.base.getVhostId());
        stat.setLong(i++, this.base.getHostId());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        stat.setTimestamp(i++, time);
        stat.setTimestamp(i++, time);
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setString(i++, this.base.getName());
        stat.setString(i++, this.base.getDescription());
        stat.setString(i++, this.base.getMac());
        stat.setLong(i++, this.base.getEthSwitchId());
        stat.setString(i++, this.base.getEthIfName());
        stat.setString(i++, this.base.getIpAddress());
        stat.setLong(i++, this.base.getEthSwitchPortId());
        stat.setInt(i++, this.base.getVlan());
        stat.setLong(i++, this.base.getVhostId());
        stat.setLong(i++, this.base.getHostId());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getDBID());
    }

    public static void createHostsFromLanHosts(Connection con, long swId) {
        List<LanHostImpl> lanHosts = LanHostImpl.loadLanHostsBySwitchIdFromDB(con, swId);
        LanHostImpl.createHosts(con, lanHosts);
    }

    public static void createHosts(Connection con, List<LanHostImpl> lanHosts) {
        if (lanHosts == null || lanHosts.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LanImpl lan = DCManager.getInstance().getLan();
        EthSwitchImpl sw = lan.findEthSwitchByDBID(lanHosts.get(0).getEthSwitchId());
        List<LanHostImpl> lHosts = LanHostImpl.getLanHostsBySwitchId(con, sw._dbID);
        HashMap<String, LanHostImpl> lhostMap = new HashMap<String, LanHostImpl>();
        ArrayList<LanHostImpl> deleteLanHosts = new ArrayList<LanHostImpl>();
        if (lHosts != null) {
            for (LanHostImpl l : lHosts) {
                String name = l.getName() + "-" + l.getEthSwitchId() + "-" + l.getEthIfName() + "-" + l.getVlan();
                if (lhostMap.get(name) == null) {
                    lhostMap.put(name, l);
                    continue;
                }
                deleteLanHosts.add(l);
            }
        }
        ArrayList<HostImpl> updateHosts = new ArrayList<HostImpl>();
        ArrayList<LanHostImpl> updateLanHosts = new ArrayList<LanHostImpl>();
        for (LanHostImpl l : lanHosts) {
            String name;
            LanHostImpl e;
            HostImpl host = null;
            if (HostManager.isMacAddressExist(l)) {
                host = HostImpl.getHostByMac(con, l.getMac());
                if (host == null) continue;
                HostImpl deleteHost = HostImpl.getHostByName(con, l.getName());
                if (deleteHost != null) {
                    HostImpl.deleteHost(con, deleteHost);
                }
                l.setHostId(host.getDBID());
                if (host.getVhostId() <= 0L) continue;
                l.setVhostId(host.getVhostId());
                continue;
            }
            if (host == null) {
                host = HostImpl.getHostByName(con, l.getName());
            }
            if (host == null) {
                host = new HostImpl(l.getName());
                HostImpl.persistHost(con, host);
            }
            if (host != null) {
                host.setData(con, l);
                updateHosts.add(host);
            }
            if ((e = (LanHostImpl)lhostMap.get(name = l.getName() + "-" + l.getEthSwitchId() + "-" + l.getEthIfName() + "-" + l.getVlan())) != null) {
                e.setHostId(host.getDBID());
                updateLanHosts.add(e);
                continue;
            }
            l.setHostId(host.getDBID());
            updateLanHosts.add(l);
            lhostMap.put(name, l);
        }
        LanHostImpl.persistLanHosts(con, updateLanHosts);
        if (updateHosts.size() > 0) {
            HostImpl.persistHosts(con, updateHosts);
        }
        for (LanHostImpl l : updateLanHosts) {
            String key = l.getName() + "-" + l.getEthSwitchId() + "-" + l.getEthIfName() + "-" + l.getVlan();
            if (lhostMap.get(key) == null) continue;
            lhostMap.remove(key);
        }
        if (lhostMap.size() > 0) {
            deleteLanHosts.addAll(lhostMap.values());
        }
        if (deleteLanHosts.size() > 0) {
            LanHostImpl.deleteLanHosts(con, deleteLanHosts);
        }
        _logger.info("createLanHosts for sw='" + sw.getIpAddress() + "' finished in " + (System.currentTimeMillis() - startTime) + "ms, LAN hosts: " + lanHosts.size() + ", updated hosts: " + updateHosts.size() + ", deleted LAN hosts: " + deleteLanHosts.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLanHostByHostId(Connection con, long id) {
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteSQLByHostId);
            deleteStat.setLong(1, id);
            deleteStat.execute();
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.log(Level.WARN, "deleteLanHostByHostId failed and rollback", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "deleteLanHostByHostId failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "deleteLanHostByHostId failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteLanHostByHostId caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllLanHosts(Connection con) {
        PreparedStatement deleteStat = null;
        long startTime = System.currentTimeMillis();
        try {
            deleteStat = con.prepareStatement(DeleteAllSQL);
            deleteStat.execute();
        }
        catch (SQLException sqlex) {
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.ERROR, "deleteAllLanHosts failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.ERROR, "deleteAllLanHosts failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteAllLanHosts caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.info("deleteAllLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLanHosts(Connection con, List<LanHostImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteSQLById);
            for (LanHostImpl h : hosts) {
                deleteStat.setLong(1, h.getDBID());
                deleteStat.addBatch();
            }
            deleteStat.executeBatch();
            con.commit();
            _logger.log(Level.DEBUG, "done deleteLanHosts: " + hosts.size());
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.log(Level.WARN, "deleteLanHosts failed and rollback", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "deleteLanHosts failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "deleteLanHosts failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteLanHosts caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLanHostsByIds(Connection con, List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteSQLById);
            for (Long id : ids) {
                deleteStat.setLong(1, id);
                deleteStat.addBatch();
            }
            deleteStat.executeBatch();
            _logger.log(Level.DEBUG, "deleteLanHostsByIds: " + ids.size());
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteLanHostsByIds caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteInvalidLanHosts() {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            LanHostImpl.deleteInvalidLanHosts(con);
        }
        catch (SQLException ex) {
            _logger.log(Level.ERROR, "deleteInvalidLanHosts failed. ", ex);
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteInvalidLanHosts(Connection con) {
        PreparedStatement lanhostStat = null;
        try {
            lanhostStat = con.prepareStatement(DeleteInvalidLanHostsSQL);
            lanhostStat.execute();
        }
        catch (SQLException ex) {
            _logger.log(Level.ERROR, "deleteInvalidLanHosts failed. ", ex);
        }
        finally {
            DbUtil.close(lanhostStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanHostImpl> loadLanHostsBySwitchIdFromDB(Connection con, long swId) {
        List<LanHostImpl> hosts;
        block5: {
            hosts = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLBySwitchId);
                stat.setLong(1, swId);
                stat.setLong(2, swId);
                rs = stat.executeQuery();
                hosts = LanHostImpl.loadLanHostDBRecord(rs);
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "loadLanHostsFromDB caught exception", ex);
                break block5;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistLanHost(Connection con, LanHostImpl host) {
        if (host == null) {
            return;
        }
        PreparedStatement updateStat = null;
        try {
            updateStat = host.getUpdateSql(con);
            updateStat.execute();
            _logger.log(Level.DEBUG, "done persistLanHost: " + host);
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.log(Level.WARN, "persistLanHost failed and rollback", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "persistLanHost failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "persistLanHost failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "persistLanHosts caught exception", ex);
        }
        finally {
            DbUtil.close(updateStat);
        }
    }

    public static List<LanHostImpl> loadLanHostDBRecord(ResultSet rs) throws SQLException {
        ArrayList<LanHostImpl> list = new ArrayList<LanHostImpl>();
        while (rs.next()) {
            int i = 1;
            long id = rs.getLong(i++);
            String name = rs.getString(i++);
            String desc = rs.getString(i++);
            String mac = rs.getString(i++);
            long swId = rs.getLong(i++);
            String ifName = rs.getString(i++);
            String ipaddress = rs.getString(i++);
            long swPortId = rs.getLong(i++);
            int vlan = rs.getInt(i++);
            long vhostId = rs.getLong(i++);
            long hostId = rs.getLong(i++);
            Timestamp createdTime = rs.getTimestamp(i++);
            Timestamp lastUpdatedTime = rs.getTimestamp(i++);
            LanHostImpl lanhost = new LanHostImpl(name, desc, mac, swId, ifName, ipaddress, swPortId, vlan, vhostId);
            lanhost.setCreatedTime(createdTime);
            lanhost.setLastUpdatedTime(lastUpdatedTime);
            lanhost.setDBID(id);
            lanhost.setHostId(hostId);
            list.add(lanhost);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getLanHostIdsByHostId(Connection con, long id) {
        ArrayList<Long> ids;
        block7: {
            ids = new ArrayList<Long>();
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QueryIdByHostIdSQL);
                stat.setLong(1, id);
                rs = stat.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        ids.add(rs.getLong(1));
                    }
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getLanHostsByVhostId caught exception", ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanHostImpl> getLanHostsByVhostId(Connection con, long id) {
        List<LanHostImpl> lanHosts;
        block5: {
            lanHosts = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByVhostId);
                stat.setLong(1, id);
                rs = stat.executeQuery();
                lanHosts = LanHostImpl.loadLanHostDBRecord(rs);
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getLanHostsByVhostId caught exception", ex);
                break block5;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return lanHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void persistLanHosts(Connection con, List<LanHostImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        int total = 0;
        try {
            long startTime = System.currentTimeMillis();
            insertStat = con.prepareStatement(InsertSQL);
            updateStat = con.prepareStatement(UpdateSQL);
            for (LanHostImpl h : hosts) {
                try {
                    if (h.getDBID() == 0L) {
                        h.setDBID(Sequence.getSequence().getPK());
                        h.setupInsertStatement(insertStat);
                        insertStat.addBatch();
                    } else if (h.getBaseObject().isModified()) {
                        h.setupUpdateStatement(updateStat);
                        updateStat.addBatch();
                    }
                    ++total;
                }
                catch (SQLException ex) {
                    _logger.log(Level.ERROR, "persistLanHost '" + h.getName() + "' failed", ex);
                }
            }
            insertStat.executeBatch();
            updateStat.executeBatch();
            con.commit();
            _logger.log(Level.DEBUG, "persistLanHosts finished in " + (System.currentTimeMillis() - startTime) + "ms, persisted: " + total);
        }
        catch (SQLException sqlex) {
            block14: {
                if (sqlex != null && sqlex.getNextException() != null) {
                    _logger.log(Level.WARN, "persistLanHosts failed and got SQLException", sqlex.getNextException());
                    break block14;
                }
                _logger.log(Level.WARN, "persistLanHosts failed and got SQLException", sqlex);
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
        }
        catch (Exception ex) {
            _logger.log(Level.WARN, "persistLanHosts caught exception", ex);
            {
                catch (Throwable throwable) {
                    DbUtil.close(insertStat);
                    DbUtil.close(updateStat);
                    throw throwable;
                }
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanHostImpl> getLanHostsBySwitchId(Connection con, Long id) {
        List<LanHostImpl> result;
        block6: {
            result = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLBySwitchId);
                stat.setLong(1, id);
                stat.setLong(2, id);
                rs = stat.executeQuery();
                if (rs != null) {
                    result = LanHostImpl.loadLanHostDBRecord(rs);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getLanHostIdsFromSwitchId caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getLanHostIdsBySwitchId(Connection con, Long id) {
        ArrayList<Long> result;
        block7: {
            result = new ArrayList<Long>();
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QueryIdsBySwitchIdSQL);
                stat.setLong(1, id);
                rs = stat.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        result.add(rs.getLong(1));
                    }
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "getLanHostIdsFromSwitchId caught exception", ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getEthSwitchIds(Connection con) {
        ResultSet rs;
        PreparedStatement stat;
        ArrayList<Long> result;
        block5: {
            result = new ArrayList<Long>();
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(QuerySwitchIdsSQL);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    result.add(rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                try {
                    _logger.log(Level.ERROR, "getLanHostsBySwitchId caught exception", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSwitchIdFromIfName(Connection con, EthSwitchImpl sw, String ifName) {
        StringTokenizer tokenizer;
        if (sw == null || ifName == null) {
            return -1L;
        }
        long id = sw.getDBID();
        if (ifName.startsWith("Eth") && (tokenizer = new StringTokenizer(ifName, "/")).hasMoreElements()) {
            String temp = null;
            if (ifName.startsWith("Ethernet")) {
                temp = ((String)tokenizer.nextElement()).substring("Ethernet".length());
            } else if (ifName.startsWith("Eth")) {
                temp = ((String)tokenizer.nextElement()).substring("Eth".length());
            }
            if (temp != null && !temp.equals("")) {
                int fexId = -1;
                try {
                    fexId = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    _logger.log(Level.DEBUG, "ifname='" + ifName + "'. " + e.getMessage());
                }
                _logger.log(Level.DEBUG, "fexID: " + fexId);
                if (fexId >= 100) {
                    ResultSet rs;
                    PreparedStatement queryStat;
                    block15: {
                        queryStat = null;
                        rs = null;
                        try {
                            queryStat = con.prepareStatement(QueryFexNameSQL);
                            queryStat.setLong(1, sw.getDBID());
                            queryStat.setInt(2, fexId);
                            rs = queryStat.executeQuery();
                            if (rs != null) {
                                while (rs.next()) {
                                    id = rs.getLong(1);
                                }
                                break block15;
                            }
                            _logger.debug("Cannot find fex switch with fexID=" + fexId + " for switch '" + sw.getName() + "'");
                        }
                        catch (SQLException e) {
                            try {
                                _logger.info("Query FEX switch ID and name failed." + e.getMessage());
                            }
                            catch (Throwable throwable) {
                                DbUtil.close(rs);
                                DbUtil.close(queryStat);
                                throw throwable;
                            }
                            DbUtil.close(rs);
                            DbUtil.close(queryStat);
                        }
                    }
                    DbUtil.close(rs);
                    DbUtil.close(queryStat);
                }
            }
        }
        return id;
    }
}

