/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.sshexec.impl.CliAdapter;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.lib.util.SyncedInt;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.model.EthPortBase;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.LanBase;
import com.cisco.dcbu.sm.common.model.VlanBase;
import com.cisco.dcbu.sm.common.type.DiscStateType;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.type.SwitchSnIntKey;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.VdcSnIntKey;
import com.cisco.dcbu.sm.common.type.VlanPK;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.LanPersistentManager;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.CdpWorker;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthNodeIf;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import com.cisco.dcbu.sm.server.model.FexIslImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.VlanImpl;
import com.cisco.dcbu.sm.server.model.VpcImpl;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LanImpl
extends AbstractDBObjectImpl
implements DumpIf {
    public static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String LAN_IS_BUSY = "DCNM is busy polling/discovering LAN";
    private static final String Cdp_IncludedDevices_Prop = "cdp.includedDevices";
    private static final String Cdp_PollInterval_Prop = "cdp.pollingInterval";
    private static final String Cdp_RediscvInterval_Prop = "cdp.rediscoveryInternal";
    private static final String Cdp_Timeout_Prop = "cdp.timeout";
    private static final PlatformType[] Cdp_Default_Devices = new PlatformType[]{PlatformType.N9K, PlatformType.N7K, PlatformType.N6K, PlatformType.N5K, PlatformType.N3K, PlatformType.CAT6K, PlatformType.CAT4K, PlatformType.MDS, PlatformType.UCS6K};
    private static final int Cdp_Default_PollIntervalInSecond = 300;
    private static final int Cdp_Default_RediscvInterval = 5;
    private static final int Cdp_Default_TimeoutInSecond = 300;
    public static Set<PlatformType> _IncludedDeviceSet = new HashSet<PlatformType>();
    private static int _CdpPollIntervalInSecond = 300;
    private static int _CdpRediscvInterval = 5;
    private static int _CdpTimeoutInSecond = 300;
    public static final boolean CdpTrimDomain = Boolean.parseBoolean(System.getProperty("trimDomain", "true"));
    public static final int STATUS_OPENING = 1;
    public static final int STATUS_OPENED = 2;
    public static final int STATUS_LOADING = 3;
    public static final int STATUS_STORING = 4;
    public static final int STATUS_CLOSING = 5;
    public static final int STATUS_CLOSED = 6;
    static final String LanDBTableName = "lan";
    static final String QuerySQL = "select id, lan_id, lan_name, last_scan_time, last_update_time, is_persistent, is_manageable from lan";
    static final String InsertSQL = "insert into lan(id, lan_id, lan_name, last_scan_time, last_update_time,  is_persistent, is_manageable ) values(?,?,?,?,?, ?,?)";
    static final String UpdateSQL = "update lan set lan_id=?, lan_name=?, last_scan_time=?, last_update_time=?, is_persistent=?, is_manageable=? where id=?";
    static final String DeleteSQL = "delete from lan where id=?";
    static final String QuerySQL_LanByServerId = "select l.id, l.lan_id, l.lan_name, l.last_scan_time, l.last_update_time, l.is_persistent, l.is_manageable from lan l, logicsvr_fabric lsvrf where l.lan_id=lsvrf.f_id and lsvrf.lsvr_id=?";
    static final String QuerySQL_LanByLanPK = "select id, lan_id, lan_name, last_scan_time, last_update_time, is_persistent, is_manageable from lan where lan_id=?";
    static final String QuerySQL_LanDBIDByLanId = "select id from lan where lan_id=?";
    private LanPK _pkey;
    private boolean _isPersistent = true;
    private long _lastScanTime;
    private long _lastUpdateTime;
    private transient LanBase _cachedLan = null;
    private final Collection<EthSwitchImpl> _ethSwitches = Collections.synchronizedSet(new HashSet());
    private final Collection<EthIslImpl> _ethIsls = Collections.synchronizedSet(new HashSet());
    private final Collection<CdpSeedImpl> _cdpSeeds = Collections.synchronizedSet(new HashSet());
    private final Collection<VlanImpl> _vlans = Collections.synchronizedSet(new HashSet());
    private final Collection<FexImpl> _fexes = Collections.synchronizedSet(new HashSet());
    private final transient ConcurrentHashMap<PKIf, EthSwitchImpl> _ethSwitchesBySwPK = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<String, EthSwitchImpl> _ethSwitchesBySysname = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<InetAddress, EthSwitchImpl> _ethSwitchesBySwIP = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<EthIslPK, EthIslImpl> _ethIslsByPK = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<PKIf, Map<Integer, Set<EthIslImpl>>> _ethIslsBySwIfindex = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<TaskKey, CdpSeedImpl> _discTasksByPK = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<Short, VlanImpl> _vlansById = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<EthIslPK, Map<Integer, VpcImpl>> _vpcByPK = new ConcurrentHashMap();
    private transient CdpWorker _worker = null;
    private final transient AtomicInteger _status = new AtomicInteger(1);
    private transient boolean _enablePolling = true;
    private transient int _pollInterval = _CdpPollIntervalInSecond;
    private transient int _cdpTimeout = _CdpTimeoutInSecond;
    private transient Map<PKIf, EthNodeIf> _unreachNodes = new ConcurrentHashMap<PKIf, EthNodeIf>();
    private transient SyncedInt _delayedChanges = new SyncedInt(0);
    private transient SyncedInt _nondelayedChanges = new SyncedInt(0);
    private transient AtomicBoolean _bufInUse = new AtomicBoolean(false);
    private transient List<AbstractModelObjectImpl> _added = Collections.synchronizedList(new ArrayList(5));
    private transient List<PKIf> _removed = Collections.synchronizedList(new ArrayList(5));
    private transient List<MovedModelObject> _moved = Collections.synchronizedList(new ArrayList(5));
    private transient List<ChangedModelObject> _changed = Collections.synchronizedList(new ArrayList(5));
    private long _userDBID = 0L;
    private final ConcurrentHashMap<Long, EthSwitchImpl> _ethSwitchesByDBID = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, EthIslImpl> _ethIslsByDBID = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, CdpSeedImpl> _cdpSeedsByDBID = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, EthPortImpl> _ethPortsByDBID = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, VlanImpl> _vlansByDBID = new ConcurrentHashMap();
    private transient boolean _persisted = false;

    LanImpl(LanPK pkey) {
        this._pkey = pkey;
    }

    public LanPK getPK() {
        return this._pkey;
    }

    public String getLanName() {
        return this.toString();
    }

    public String toString() {
        return this._pkey.toString();
    }

    public LanBase getLanBase() {
        if (this._cachedLan != null) {
            return this._cachedLan;
        }
        return this.createLanBase();
    }

    private LanBase createLanBase() {
        LanBase base = new LanBase();
        base.setPkey(this._pkey);
        base.setPersistent(this._isPersistent);
        base.setLastScanTime(this._lastScanTime);
        base.setEthSwitches(this.getEthSwitchBases());
        base.setEthIsls(this.getEthIslBases());
        base.setCdpSeeds(this.getCdpSeedBases());
        base.setVlans(this.getVlanBases());
        base.setEthPorts(this.getEthPortBases());
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockLanQuery() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() != 1) {
                this._cachedLan = this.createLanBase();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockLanQuery() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            this._cachedLan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            return this._status.get();
        }
    }

    public boolean attemptLan(int condStatus, int status, long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() == condStatus) {
                this._status.set(status);
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this._status.wait(waitTime);
                    if (this._status.get() != condStatus) continue;
                    this._status.set(status);
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this._status.notifyAll();
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLan(int status) {
        if (status != this._status.get()) {
            int preStatus = this._status.get();
            this._status.set(status);
            AtomicInteger atomicInteger = this._status;
            synchronized (atomicInteger) {
                this._status.notifyAll();
            }
            if ((preStatus == 1 || preStatus == 3) && status == 2) {
                DCManager.getInstance().notifyLanOpened(this);
                _Tracer.log(Level.INFO, this.prefix() + "releaseLan: LAN had been opened " + this);
            } else if (status == 5 || status == 6) {
                DCManager.getInstance().notifyLanClosed(this);
                _Tracer.log(Level.INFO, this.prefix() + "releaseLan: LAN had been closed " + this);
            }
        }
    }

    public int getLanStatus() {
        return this._status.get();
    }

    public boolean isPersistent() {
        return this._isPersistent;
    }

    void setPersistent(boolean isPersistent) {
        if (this._isPersistent ^ isPersistent) {
            this._isPersistent = isPersistent;
            this.modelObjectChanged(this._pkey, (short)519, Boolean.valueOf(!isPersistent), Boolean.valueOf(isPersistent));
        }
    }

    public long getLastScanTime() {
        return this._lastScanTime;
    }

    public void setLastUpdateTime(long time) {
        this._lastUpdateTime = time;
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public boolean isLanEmpty() {
        return this.getNumCdpSeeds() == 0 && this.getNumEthSwitches() == 0 && this.getNumEthIsls() == 0;
    }

    public boolean isLanOpened() {
        int status = this.getLanStatus();
        return status == 2 || status == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean cleanCache) {
        _Tracer.log(Level.DEBUG, this.prefix() + "is closing", new Exception("To track LAN close"));
        try {
            if (this._worker != null) {
                try {
                    SchedulerSingleton.getInstance().removeTask(this._worker);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this._worker.stop();
                this._worker = null;
            }
            if (cleanCache) {
                this.cleanCache();
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.WARN, this.prefix() + "cannot completely close worker", e);
        }
        finally {
            this.releaseLan(6);
        }
    }

    private void cleanCache() {
        this._ethSwitchesBySwPK.clear();
        this._ethSwitchesBySysname.clear();
        this._ethSwitchesBySwIP.clear();
        this._ethIslsByPK.clear();
        this._unreachNodes.clear();
        for (Map<Integer, Set<EthIslImpl>> m : this._ethIslsBySwIfindex.values()) {
            for (Set<EthIslImpl> s : m.values()) {
                s.clear();
            }
            m.clear();
        }
        this._ethIslsBySwIfindex.clear();
        this._discTasksByPK.clear();
        this._ethSwitchesByDBID.clear();
        this._ethIslsByDBID.clear();
        this._cdpSeedsByDBID.clear();
        this._ethPortsByDBID.clear();
        this._vlansByDBID.clear();
        for (CdpSeedImpl seed : this._cdpSeeds) {
            seed.cleanCache();
        }
        this._cdpSeeds.clear();
        for (EthSwitchImpl sw : this._ethSwitches) {
            sw.cleanCache();
        }
        this._ethSwitches.clear();
        this._ethIsls.clear();
        this._vlans.clear();
        this._fexes.clear();
        this._vpcByPK.clear();
        System.gc();
    }

    public void addUnreachNode(EthNodeIf node) {
        if (node == null) {
            return;
        }
        this._unreachNodes.put(node.getPK(), node);
    }

    public void removeUnreachNode(EthNodeIf node) {
        if (node == null) {
            return;
        }
        this._unreachNodes.remove(node.getPK());
    }

    public boolean isUnreachNode(EthNodeIf node) {
        return this._unreachNodes.containsKey(node.getPK());
    }

    public int getNumEthSwitches() {
        return this._ethSwitches.size();
    }

    public List<EthSwitchImpl> getEthSwitches() {
        return new ArrayList<EthSwitchImpl>(this._ethSwitches);
    }

    public List<EthSwitchImpl> getManageableSeedEthSwitches() {
        ArrayList<EthSwitchImpl> sws = new ArrayList<EthSwitchImpl>(this._ethSwitches.size());
        for (EthSwitchImpl sw : this._ethSwitches) {
            if (!sw.hasManageableSeed()) continue;
            sws.add(sw);
        }
        return sws;
    }

    public List<EthSwitchBase> getEthSwitchBases() {
        ArrayList<EthSwitchBase> base = new ArrayList<EthSwitchBase>(this._ethSwitches.size());
        for (EthSwitchImpl sw : this._ethSwitches) {
            base.add(sw.getBase());
        }
        return base;
    }

    public boolean addEthSwitch(EthSwitchImpl sw, boolean checkNew) {
        if (sw == null) {
            return false;
        }
        if (checkNew && !this.checkNewEthSwitch(sw)) {
            return false;
        }
        boolean added = this._ethSwitches.add(sw);
        if (added) {
            this._ethSwitchesBySwPK.put(sw.getSwitchPK(), sw);
            if (!(sw instanceof FexImpl)) {
                this.checkAndUpdateCacheBySysname(sw, null, sw.getBase().getSysName());
                this.checkAndUpdateCacheByMgmtAddrs(sw, null, sw.getBase().getManagementAddresses());
            }
            if (sw.getDBID() != 0L) {
                this._ethSwitchesByDBID.put(sw.getDBID(), sw);
            }
            this.modelObjectAdded(sw);
        }
        return added;
    }

    boolean removeEthSwitchOnly(EthSwitchImpl sw, boolean purgeDB) {
        if (sw == null) {
            return false;
        }
        _Tracer.log(Level.INFO, this + " remove Ethswitch " + sw);
        boolean removed = this._ethSwitches.remove(sw);
        if (removed) {
            CdpSeedImpl seed = this.findCdpSeedFromNodePK(sw.getPK());
            if (seed != null) {
                seed.removeEthSwitch(sw);
                try {
                    LanPersistentManager.getInstance().persistLanCdpSeed(seed);
                }
                catch (Exception e) {
                    _Tracer.log(Level.WARN, this + " CDP purge failed on switch" + sw, e);
                }
            }
            this._ethSwitchesBySwPK.remove(sw.getSwitchPK());
            if (!(sw instanceof FexImpl)) {
                this.checkAndUpdateCacheBySysname(sw, sw.getBase().getSysName(), null);
                this.checkAndUpdateCacheByMgmtAddrs(sw, sw.getManagementAddresses(), null);
            }
            this._ethSwitchesByDBID.remove(sw.getDBID());
            if (purgeDB) {
                try {
                    LanPersistentManager.getInstance().purgeEthSwitchAndComponents(this, sw, LanPersistentManager.Option.ObjectOnly);
                }
                catch (Exception e) {
                    _Tracer.log(Level.WARN, this + " purge failed on switch" + sw, e);
                }
            }
            this.modelObjectRemoved(sw.getPK());
        }
        return removed;
    }

    public boolean removeEthSwitchAndComponents(EthSwitchImpl sw, boolean purgeDB) {
        if (sw == null) {
            return false;
        }
        _Tracer.log(Level.INFO, this + " remove EthSwitch and Components " + sw);
        String ip = sw.getIpAddress();
        InetAddress clientIp = IdentityManager.getInstance().getClientAddress();
        String userName = IdentityManager.getInstance().getCurrentUsername();
        Set<EthIslImpl> islSet = this.findEthIslsBySwPK(sw.getSwitchPK());
        for (EthIslImpl isl : islSet) {
            this.removeEthIsl(isl, false);
        }
        PKIf swKey = sw.getSwitchPK();
        if (swKey != null) {
            InventoryManager.getInstance().removeEthSwInventory(swKey, sw.getDBID(), false);
        }
        ArrayList<EthPortImpl> portSet = sw.getAllPorts();
        for (EthPortImpl port : portSet) {
            sw.removeEthPort(port.getIfIndex(), false);
        }
        if (sw.isFexEnabled() && !sw.getBase().isFex()) {
            List<FexImpl> fexList = sw.getFexes();
            for (FexImpl fex : fexList) {
                this.removeEthSwitchAndComponents(fex, false);
            }
        }
        if (sw.isPeerCreated()) {
            EventControllerService ec = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
            ec.delSource(sw);
            if (sw.isTrapRegistered() && sw.isManageable()) {
                try {
                    sw.getPeer().getSession();
                    if (SnmpSession._PreferTcp) {
                        CountDownLatch doneSignal = new CountDownLatch(1);
                        ec.deregisterTrap(sw.getPeer(), doneSignal);
                        doneSignal.await(5L, TimeUnit.SECONDS);
                    } else {
                        ec.deregisterTrap(sw.getPeer());
                    }
                }
                catch (InterruptedException ie) {
                    _Tracer.debug(ie.getMessage());
                }
            }
        }
        SnmpPeer.removeServerPeer(sw._peer, true);
        if (sw._peer != null) {
            sw._peer.close();
        }
        CliAdapter.close((String)sw.getIpAddress());
        boolean removed = this.removeEthSwitchOnly(sw, false);
        if (removed) {
            _Tracer.info(this + " switch '" + sw + "' was removed");
        }
        if (purgeDB) {
            try {
                LanPersistentManager.getInstance().purgeEthSwitchAndComponents(this, sw, LanPersistentManager.Option.ObjectAndComp);
            }
            catch (Exception e) {
                _Tracer.log(Level.WARN, this + " purge failed on switch" + sw, e);
            }
        }
        return removed;
    }

    public void checkAndUpdateCacheByMgmtAddrs(EthSwitchImpl sw, InetAddress[] oldOne, InetAddress[] newOne) {
        EthSwitchImpl tsw;
        if (sw == null || oldOne == null && newOne == null) {
            return;
        }
        if (oldOne != null) {
            for (InetAddress addr : oldOne) {
                tsw = this._ethSwitchesBySwIP.get(addr);
                if (tsw == null || tsw != sw && !tsw.getSwitchPK().equals(sw.getSwitchPK())) continue;
                this._ethSwitchesBySwIP.remove(addr);
            }
        }
        if (newOne != null) {
            for (InetAddress addr : newOne) {
                if (!IpUtil.isValidMgmtAddress(addr)) continue;
                tsw = this._ethSwitchesBySwIP.get(addr);
                if (tsw != null && tsw != sw) {
                    _Tracer.log(Level.INFO, "Cdp discovery found conflict switches with same swIP:" + addr + " sw1=" + sw + " sw2=" + tsw);
                }
                this._ethSwitchesBySwIP.put(addr, sw);
            }
        }
    }

    public void checkAndUpdateCacheBySysname(EthSwitchImpl sw, String oldOne, String newOne) {
        EthSwitchImpl tsw;
        if (sw == null || oldOne == null && newOne == null) {
            return;
        }
        if (oldOne != null && (tsw = this._ethSwitchesBySysname.get(oldOne)) != null && (tsw == sw || tsw.getSwitchPK().equals(sw.getSwitchPK()))) {
            this._ethSwitchesBySysname.remove(oldOne);
        }
        if (newOne != null && !newOne.equalsIgnoreCase("switch")) {
            tsw = this._ethSwitchesBySysname.get(newOne);
            if (tsw != null && tsw != sw) {
                _Tracer.log(Level.INFO, "Cdp discovery found conflict switches with same sysname:" + newOne + " sw1=" + sw + " sw2=" + tsw);
            }
            this._ethSwitchesBySysname.put(newOne, sw);
        }
    }

    public EthSwitchImpl findEthSwitchBySysName(String sysName) {
        if (sysName == null) {
            return null;
        }
        return this._ethSwitchesBySysname.get(sysName);
    }

    public EthSwitchImpl findEthSwitchByIp(InetAddress swIp) {
        if (swIp == null) {
            return null;
        }
        return this._ethSwitchesBySwIP.get(swIp);
    }

    public EthSwitchImpl findEthSwitchByPK(PKIf swPK) {
        if (swPK == null) {
            return null;
        }
        return this._ethSwitchesBySwPK.get(swPK);
    }

    public boolean checkNewEthSwitch(EthSwitchImpl newSw) {
        SerialNumKey oldSnKey;
        InetAddress swIp;
        if (newSw == null) {
            return false;
        }
        EthSwitchImpl oldSw = this.findEthSwitchByPK(newSw.getSwitchPK());
        if (oldSw != null) {
            return false;
        }
        String newSysName = newSw.getBase().getSysName();
        if (newSysName != null) {
            oldSw = this.findEthSwitchBySysName(newSysName);
        }
        if (oldSw == null && (swIp = newSw.getInetAddress()) != null) {
            oldSw = this.findEthSwitchByIp(swIp);
        }
        if (oldSw == null) {
            return true;
        }
        if (oldSw.getSwitchPK() instanceof SerialNumKey && newSw.getSwitchPK() instanceof SerialNumKey) {
            oldSnKey = (SerialNumKey)oldSw.getSwitchPK();
            SerialNumKey newSnKey = (SerialNumKey)newSw.getSwitchPK();
            if (oldSnKey.isRealSN() && newSnKey.isRealSN()) {
                return true;
            }
            if (newSnKey.isRealSN()) {
                this.removeEthSwitchAndComponents(oldSw, true);
                return true;
            }
            if (oldSnKey.isRealSN()) {
                return false;
            }
        } else {
            if (oldSw.getSwitchPK() instanceof VdcPK && newSw.getSwitchPK() instanceof VdcPK) {
                return true;
            }
            if (newSw.getSwitchPK() instanceof VdcPK) {
                if (!oldSw.getBase().isN7K()) {
                    return true;
                }
                oldSnKey = (SerialNumKey)newSw.getSwitchPK();
                if (oldSnKey.equals(newSw.getChassisKey())) {
                    this.removeEthSwitchAndComponents(oldSw, true);
                }
                return true;
            }
            if (oldSw.getSwitchPK() instanceof VdcPK) {
                if (!newSw.getBase().isN7K()) {
                    return true;
                }
                SerialNumKey newSnKey = (SerialNumKey)newSw.getSwitchPK();
                if (newSnKey != null && newSnKey.equals(oldSw.getChassisKey())) {
                    if (FRUConstants.isVdcCapableVersion(PlatformType.N7K, newSw.getVersion())) {
                        return false;
                    }
                    this.removeEthSwitchAndComponents(oldSw, true);
                    return true;
                }
                return true;
            }
        }
        return true;
    }

    public Set<EthSwitchImpl> findNeighborEthSwitches(PKIf swPK) {
        if (swPK == null) {
            return Collections.EMPTY_SET;
        }
        Set<EthIslImpl> ethIsls = this.findEthIslsBySwPK(swPK);
        if (ethIsls == null || ethIsls.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<EthSwitchImpl> ret = new HashSet<EthSwitchImpl>();
        for (EthIslImpl isl : ethIsls) {
            if (isl.getSwitch1PK().equals(swPK)) {
                ret.add(this.findEthSwitchByPK(isl.getSwitch1PK()));
            }
            if (!isl.getSwitch2PK().equals(swPK)) continue;
            ret.add(this.findEthSwitchByPK(isl.getSwitch2PK()));
        }
        return ret;
    }

    public int getNumEthIsls() {
        return this._ethIsls.size();
    }

    public List<EthIslImpl> getEthIsls() {
        return new ArrayList<EthIslImpl>(this._ethIsls);
    }

    public List<EthIslBase> getEthIslBases() {
        ArrayList<EthIslBase> base = new ArrayList<EthIslBase>(this._ethIsls.size());
        for (EthIslImpl isl : this._ethIsls) {
            base.add(isl.getBase());
        }
        return base;
    }

    public boolean addEthIsl(EthIslImpl isl) {
        if (isl == null) {
            return false;
        }
        boolean added = this._ethIsls.add(isl);
        if (added) {
            this._ethIslsByPK.put(isl.getIslPK(), isl);
            this.updateEthIslsBySwitch(isl, true, true);
            this.updateEthIslsBySwitch(isl, true, false);
            if (isl.getDBID() != 0L) {
                this._ethIslsByDBID.put(isl.getDBID(), isl);
            }
            this.modelObjectAdded(isl);
        }
        return added;
    }

    public boolean removeEthIsl(EthIslImpl isl, boolean purgeDB) {
        boolean removed;
        if (isl == null) {
            return false;
        }
        if (isl.isPortChannel()) {
            isl.clearChildren();
        }
        if (removed = this._ethIsls.remove(isl)) {
            EthSwitchImpl sw;
            if (IfIndexUtil.isFmIfIndex(isl.getIfIndex1()) && (sw = isl.getSwitch1()) != null) {
                sw.removeEthPort(isl.getPort1(), true);
            }
            if (IfIndexUtil.isFmIfIndex(isl.getIfIndex2()) && (sw = isl.getSwitch2()) != null) {
                sw.removeEthPort(isl.getPort2(), true);
            }
            this._ethIslsByPK.remove(isl.getIslPK());
            this.updateEthIslsBySwitch(isl, false, true);
            this.updateEthIslsBySwitch(isl, false, false);
            this._ethIslsByDBID.remove(isl.getDBID());
            this.modelObjectRemoved(isl.getPK());
            if (purgeDB) {
                try {
                    LanPersistentManager.getInstance().purgeEthIsl(this, isl);
                }
                catch (Exception e) {
                    _Tracer.log(Level.WARN, this + " purge failed on eth isl:" + isl, e);
                }
            }
        }
        return removed;
    }

    private void updateEthIslsBySwitch(EthIslImpl isl, boolean isAdd, boolean isSwitch1) {
        if (isl == null) {
            return;
        }
        PKIf swPK = isSwitch1 ? isl.getSwitch1().getSwitchPK() : isl.getSwitch2().getSwitchPK();
        int ifindex = isSwitch1 ? isl.getIfIndex1() : isl.getIfIndex2();
        Map<Integer, Set<EthIslImpl>> islMap = this._ethIslsBySwIfindex.get(swPK);
        if (isAdd) {
            Set<EthIslImpl> islSet;
            if (islMap == null) {
                islMap = new HashMap<Integer, Set<EthIslImpl>>();
                this._ethIslsBySwIfindex.put(swPK, islMap);
            }
            if ((islSet = islMap.get(ifindex)) == null) {
                islSet = new HashSet<EthIslImpl>();
                islMap.put(ifindex, islSet);
            }
            islSet.add(isl);
        } else {
            if (islMap == null) {
                return;
            }
            Set<EthIslImpl> islSet = islMap.get(ifindex);
            if (islSet == null) {
                return;
            }
            islSet.remove(isl);
            if (islSet.size() == 0) {
                islMap.remove(ifindex);
            }
            if (islMap.isEmpty()) {
                this._ethIslsBySwIfindex.remove(swPK);
            }
        }
    }

    public Set<EthIslImpl> findEthIslsBySwPK(PKIf swPK) {
        if (swPK == null) {
            return Collections.EMPTY_SET;
        }
        Map<Integer, Set<EthIslImpl>> islMap = this._ethIslsBySwIfindex.get(swPK);
        if (islMap == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<EthIslImpl> ret = new HashSet<EthIslImpl>();
        for (Set<EthIslImpl> isls : islMap.values()) {
            ret.addAll(isls);
        }
        return ret;
    }

    public Set<EthIslImpl> findEthIslsBySwPort(PKIf swPK, int ifindex) {
        if (swPK == null || ifindex < 0) {
            return Collections.EMPTY_SET;
        }
        Map<Integer, Set<EthIslImpl>> islMap = this._ethIslsBySwIfindex.get(swPK);
        if (islMap == null) {
            return Collections.EMPTY_SET;
        }
        Set<EthIslImpl> islSet = islMap.get(ifindex);
        if (islSet == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<EthIslImpl> ret = new HashSet<EthIslImpl>(islSet);
        return ret;
    }

    public Set<EthIslImpl> findEthIslsBySwIntKey(SwitchIntKeyIf swIntKey) {
        if (swIntKey == null) {
            return Collections.EMPTY_SET;
        }
        return this.findEthIslsBySwPort((PKIf)swIntKey.getSwitchKey(), swIntKey.getIfindex());
    }

    public EthIslImpl findEthIsl(PKIf sw1PK, PKIf sw2PK, int ifindex1, int ifindex2) {
        EthIslPK islPK = new EthIslPK(sw1PK, sw2PK, ifindex1, ifindex2);
        return this.findEthIsl(islPK);
    }

    public EthIslImpl findEthIsl(SwitchIntKeyIf port1PK, SwitchIntKeyIf port2PK) {
        EthIslPK islPK = new EthIslPK(port1PK, port2PK);
        return this.findEthIsl(islPK);
    }

    public EthIslImpl findEthIsl(EthIslPK islPK) {
        if (islPK == null) {
            return null;
        }
        return this._ethIslsByPK.get(islPK);
    }

    public Map<Integer, VpcImpl> findVpcByPeerLinkPK(EthIslPK islPK) {
        if (islPK == null) {
            return null;
        }
        return this._vpcByPK.get(islPK);
    }

    public void addVpc(EthIslPK key, VpcImpl vpc) {
        if (key == null) {
            return;
        }
        if (this._vpcByPK.get(key) == null) {
            HashMap<Integer, VpcImpl> vpcCol = new HashMap<Integer, VpcImpl>();
            vpcCol.put(vpc.getVpcID(), vpc);
            this._vpcByPK.put(key, vpcCol);
        } else {
            this._vpcByPK.get(key).put(vpc.getVpcID(), vpc);
        }
    }

    public void removeVpc(EthIslPK key, VpcImpl vpc) {
        if (key == null) {
            return;
        }
        if (this._vpcByPK.get(key) != null) {
            this._vpcByPK.get(key).remove(vpc);
        }
    }

    public ConcurrentHashMap<EthIslPK, Map<Integer, VpcImpl>> getAllVpcs() {
        return this._vpcByPK;
    }

    public List<VpcImpl> getVpcImps() {
        ArrayList<VpcImpl> vpcImpls = new ArrayList<VpcImpl>();
        ConcurrentHashMap<EthIslPK, Map<Integer, VpcImpl>> vpcPerformanceCol = this.getAllVpcs();
        Iterator it = vpcPerformanceCol.keySet().iterator();
        while (it.hasNext()) {
            Map<Integer, VpcImpl> vpcMap = vpcPerformanceCol.get(it.next());
            Iterator<Integer> it2 = vpcMap.keySet().iterator();
            while (it2.hasNext()) {
                VpcImpl vpcImpl = vpcMap.get(it2.next());
                vpcImpls.add(vpcImpl);
            }
        }
        return vpcImpls;
    }

    public Set<EthIslImpl> findEthIslsBySwitches(EthSwitchImpl sw1, EthSwitchImpl sw2) {
        if (sw1 == null || sw2 == null) {
            return Collections.EMPTY_SET;
        }
        Set<EthIslImpl> islSet = this.findEthIslsBySwPK(sw1.getSwitchPK());
        PKIf sw2PK = sw2.getSwitchPK();
        for (EthIslImpl isl : islSet) {
            if (isl.getSwitch1PK() == sw2PK && isl.getSwitch2PK() == sw2PK) continue;
            islSet.remove(isl);
        }
        return islSet;
    }

    public Set<FexIslImpl> findFexLinksBySwPK(PKIf swPK) {
        if (swPK == null) {
            return Collections.EMPTY_SET;
        }
        Set<EthIslImpl> isls = this.findEthIslsBySwPK(swPK);
        if (isls.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<FexIslImpl> fexIsls = new HashSet<FexIslImpl>();
        for (EthIslImpl isl : isls) {
            if (!(isl instanceof FexIslImpl)) continue;
            fexIsls.add((FexIslImpl)isl);
        }
        isls.clear();
        return fexIsls;
    }

    Map<EthIslPK, EthIslImpl> findEthIslsByEitherPort(EthSwitchImpl sw1, EthSwitchImpl sw2, int ifindex1, int ifindex2) {
        if (sw1 == null || sw2 == null || ifindex1 <= 0 || ifindex2 <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<EthIslPK, EthIslImpl> ret = new HashMap<EthIslPK, EthIslImpl>();
        SwitchIntKeyIf<VdcPK> swIfKey1 = null;
        SwitchIntKeyIf<VdcPK> swIfKey2 = null;
        swIfKey1 = sw1.isVdc() ? new VdcSnIntKey((VdcPK)sw1.getBase().getSwitchPK(), ifindex1) : new SwitchSnIntKey((SerialNumKey)sw1.getBase().getSwitchPK(), ifindex1);
        swIfKey2 = sw2.isVdc() ? new VdcSnIntKey((VdcPK)sw2.getBase().getSwitchPK(), ifindex2) : new SwitchSnIntKey((SerialNumKey)sw2.getBase().getSwitchPK(), ifindex2);
        Set<EthIslImpl> islSet = this.findEthIslsBySwIntKey(swIfKey1);
        islSet.addAll(this.findEthIslsBySwIntKey(swIfKey2));
        for (EthIslImpl isl : islSet) {
            ret.put(isl.getIslPK(), isl);
        }
        return ret;
    }

    public void addChildOfEthChannel(EthIslImpl channelIsl, EthPortImpl childPort1, EthPortImpl childPort2) {
        EthIslPK channelPK;
        if (channelIsl == null || !channelIsl.isPortChannel() || childPort1 == null || childPort2 == null) {
            _Tracer.log(Level.DEBUG, this + " cannot add child isl to channel:" + channelIsl + "," + childPort1 + "," + childPort2);
            return;
        }
        EthIslImpl oldIsl = this.findEthIsl(childPort1.getSwitchPortPK(), childPort2.getSwitchPortPK());
        if (oldIsl != null) {
            this.removeEthIsl(oldIsl, true);
        }
        if (childPort1.getBase().isChild() && childPort2.getBase().isChild()) {
            EthIslImpl oldParent;
            EthPortImpl parentPort1 = childPort1.getSwitch().findChannelPortByChild(childPort1.getBase().getChannelIfindex());
            EthPortImpl parentPort2 = childPort2.getSwitch().findChannelPortByChild(childPort2.getBase().getChannelIfindex());
            if (parentPort1 != null && parentPort2 != null && (oldParent = this.findEthIsl(parentPort1.getSwitchPortPK(), parentPort2.getSwitchPortPK())) != null) {
                this.removeChildOfEthChannel(oldParent, childPort1, childPort2);
            }
        }
        if ((channelPK = channelIsl.getIslPK()).getSwitch1Key().equals(childPort1.getSwitchPK())) {
            channelIsl.getPort1().addChild(childPort1.getIfIndex());
            channelIsl.getPort2().addChild(childPort2.getIfIndex());
            childPort1.setChannelIfindex(channelPK.getIfIndex1());
            childPort2.setChannelIfindex(channelPK.getIfIndex2());
        } else {
            channelIsl.getPort1().addChild(childPort2.getIfIndex());
            channelIsl.getPort2().addChild(childPort1.getIfIndex());
            childPort1.setChannelIfindex(channelPK.getIfIndex2());
            childPort2.setChannelIfindex(channelPK.getIfIndex1());
        }
        channelIsl.addChild(childPort1.getSwitchPK(), childPort2.getSwitchPK(), childPort1.getIfIndex(), childPort2.getIfIndex());
    }

    public void removeChildOfEthChannel(EthIslImpl channelIsl, PKIf sw1PK, PKIf sw2PK, int childIfindex1, int childIfindex2) {
        if (channelIsl == null || !channelIsl.isPortChannel() || sw1PK == null || sw2PK == null) {
            _Tracer.log(Level.DEBUG, this + " cannot remove child isl to channel:" + channelIsl + "," + sw1PK + "," + sw2PK);
            return;
        }
        EthSwitchImpl sw1 = this.findEthSwitchByPK(sw1PK);
        EthSwitchImpl sw2 = this.findEthSwitchByPK(sw2PK);
        if (sw1 == null || sw2 == null) {
            _Tracer.log(Level.DEBUG, this + " cannot find child switches of channel:" + channelIsl + "," + sw1 + "," + sw2);
            return;
        }
        EthPortImpl childPort1 = sw1.findEthPort(childIfindex1);
        EthPortImpl childPort2 = sw2.findEthPort(childIfindex2);
        if (childPort1 == null || childPort2 == null) {
            _Tracer.log(Level.DEBUG, this + " cannot find child ports of channel:" + channelIsl + "," + childPort1 + "," + childPort2);
            return;
        }
        this.removeChildOfEthChannel(channelIsl, childPort1, childPort2);
    }

    public void removeChildOfEthChannel(EthIslImpl channelIsl, EthPortImpl childPort1, EthPortImpl childPort2) {
        if (channelIsl == null || !channelIsl.isPortChannel() || childPort1 == null || childPort2 == null) {
            _Tracer.log(Level.DEBUG, this + " cannot find child ports of channel:" + channelIsl + "," + childPort1 + "," + childPort2);
            return;
        }
        EthIslPK channelPK = channelIsl.getIslPK();
        if (channelPK.getSwitch1Key().equals(childPort1.getSwitchPK())) {
            channelIsl.getPort1().removeChild(childPort1.getIfIndex());
            channelIsl.getPort2().removeChild(childPort2.getIfIndex());
        } else {
            channelIsl.getPort1().removeChild(childPort2.getIfIndex());
            channelIsl.getPort2().removeChild(childPort1.getIfIndex());
        }
        childPort1.resetChannelIfindex();
        childPort2.resetChannelIfindex();
        channelIsl.removeChild(childPort1.getSwitchPK(), childPort2.getSwitchPK(), childPort1.getIfIndex(), childPort2.getIfIndex());
    }

    public void clearChildrenOfEthChannel(EthIslImpl channelIsl) {
        if (channelIsl == null || !channelIsl.isPortChannel()) {
            _Tracer.log(Level.DEBUG, this + " cannot clear  child isl to channel:" + channelIsl);
            return;
        }
        EthSwitchImpl sw1 = channelIsl.getSwitch1();
        EthSwitchImpl sw2 = channelIsl.getSwitch2();
        List<int[]> children = channelIsl.getChildren();
        for (int[] child : children) {
            EthPortImpl p1 = this.findEthPort(sw1.getSwitchPK(), child[0]);
            EthPortImpl p2 = this.findEthPort(sw2.getSwitchPK(), child[1]);
            if (p1 != null && p2 != null) {
                this.removeChildOfEthChannel(channelIsl, p1, p2);
                continue;
            }
            _Tracer.log(Level.DEBUG, "Cannot remove child from channel:" + channelIsl + "," + Arrays.toString(child));
        }
    }

    public EthIslImpl findEthChannelByChildren(PKIf sw1PK, PKIf sw2PK, int childIfindex1, int childIfindex2) {
        EthSwitchImpl sw1 = this.findEthSwitchByPK(sw1PK);
        EthSwitchImpl sw2 = this.findEthSwitchByPK(sw2PK);
        if (sw1 == null || sw2 == null) {
            return null;
        }
        EthPortImpl childPort1 = sw1.findEthPort(childIfindex1);
        EthPortImpl childPort2 = sw2.findEthPort(childIfindex2);
        if (childPort1 == null || !childPort1.getBase().isChild() || childPort2 == null || !childPort2.getBase().isChild()) {
            return null;
        }
        EthIslPK channelPK = new EthIslPK(sw1.getSwitchPK(), sw2.getSwitchPK(), childPort1.getBase().getChannelIfindex(), childPort2.getBase().getChannelIfindex());
        EthIslImpl channelIsl = this.findEthIsl(channelPK);
        return channelIsl;
    }

    public List<EthPortBase> getEthPortBases() {
        ArrayList<EthPortBase> ports = new ArrayList<EthPortBase>();
        List<EthSwitchImpl> sws = this.getEthSwitches();
        for (EthSwitchImpl sw : sws) {
            ArrayList<EthPortImpl> pl = sw.getAllPorts();
            for (EthPortImpl p : pl) {
                ports.add(p.getBase());
            }
        }
        return ports;
    }

    public EthPortImpl findEthPort(SwitchIntKeyIf portPK) {
        if (portPK == null) {
            return null;
        }
        return this.findEthPort((PKIf)portPK.getSwitchKey(), portPK.getIfindex());
    }

    public EthPortImpl findEthPort(PKIf swPK, int ifindex) {
        if (swPK == null) {
            return null;
        }
        EthSwitchImpl sw = this.findEthSwitchByPK(swPK);
        if (sw == null) {
            return null;
        }
        return sw.findEthPort(ifindex);
    }

    public static boolean isAllowedCdpDevice(PlatformType type) {
        for (PlatformType allowed : _IncludedDeviceSet) {
            if (!PlatformType.isTypeOf(type, allowed)) continue;
            return true;
        }
        return false;
    }

    public int getNumCdpSeeds() {
        return this._cdpSeeds.size();
    }

    public List<CdpSeedImpl> getCdpSeeds() {
        if (this._cdpSeeds.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<CdpSeedImpl>(this._cdpSeeds);
    }

    public List<CdpSeedBase> getCdpSeedBases() {
        if (this._cdpSeeds.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CdpSeedBase> base = new ArrayList<CdpSeedBase>(this._cdpSeeds.size());
        for (CdpSeedImpl seed : this._cdpSeeds) {
            base.add(seed.getBase());
        }
        return base;
    }

    public boolean addCdpSeed(CdpSeedImpl seed) {
        if (seed == null) {
            return false;
        }
        boolean added = this._cdpSeeds.add(seed);
        if (added) {
            this._discTasksByPK.put(seed.getBase().getTaskKey(), seed);
            if (seed.getDBID() != 0L) {
                this._cdpSeedsByDBID.put(seed.getDBID(), seed);
            }
            this.modelObjectAdded(seed);
        }
        return added;
    }

    boolean unmanage(CdpSeedImpl seed) {
        if (seed == null) {
            return false;
        }
        _Tracer.log(Level.INFO, this + " is unmanaging cdp seed:" + seed);
        this._worker.stopEthNodeWorkers(seed);
        return true;
    }

    boolean close(CdpSeedImpl seed) {
        if (seed == null) {
            return false;
        }
        _Tracer.log(Level.INFO, this + " is closing cdp seed:" + seed);
        if (this._worker != null) {
            this._worker.stopEthNodeWorkers(seed);
        }
        List<PKIf> ethSwPKs = seed.getBase().getEthSwitches();
        for (PKIf swPK : ethSwPKs) {
            EthSwitchImpl ethSw = this.findEthSwitchByPK(swPK);
            if (ethSw == null) continue;
            ethSw.setBeingRemoved(true);
            this.removeEthSwitchAndComponents(ethSw, false);
        }
        this._discTasksByPK.remove(seed.getBase().getTaskKey());
        this._cdpSeedsByDBID.remove(seed.getDBID());
        this.modelObjectRemoved(seed.getPK());
        return this._cdpSeeds.remove(seed);
    }

    boolean removeCdpSeed(CdpSeedImpl seed, boolean purgeDB) {
        if (seed == null) {
            return false;
        }
        _Tracer.log(Level.INFO, this + " remove Cdp Seed " + seed);
        boolean removed = this.close(seed);
        if (removed && purgeDB) {
            try {
                long seedDBID = seed.getDBID();
                List<Long> swDBIDs = GlobalDCManager.getInstance().querySwDBIDsBySeedDBID(seedDBID);
                LanPersistentManager.getInstance().purgeCdpSeedAndComponents(this, seed, LanPersistentManager.Option.ObjectAndComp);
                for (Long swDBId : swDBIDs) {
                    DCManager.getInstance().notifyDBObjectPurged(swDBId);
                }
                DCManager.getInstance().notifyDBObjectPurged(seedDBID);
            }
            catch (Exception e) {
                _Tracer.log(Level.WARN, this + "purge failed on cdp seed:" + seed, e);
            }
        }
        return removed;
    }

    public CdpSeedImpl findCdpSeedBySeedPK(TaskKey taskPK) {
        if (taskPK == null) {
            return null;
        }
        return this._discTasksByPK.get(taskPK);
    }

    public CdpSeedImpl findCdpSeedBySeedIps(List<InetAddress> seedIps) {
        if (seedIps == null) {
            return null;
        }
        for (CdpSeedImpl task : this._discTasksByPK.values()) {
            List<InetAddress> currSeedIps = task.getSeedIPs();
            int count = 0;
            for (InetAddress seedIp : seedIps) {
                if (!currSeedIps.contains(seedIp)) continue;
                ++count;
            }
            if (count != seedIps.size()) continue;
            return task;
        }
        return null;
    }

    public CdpSeedImpl findCdpSeedFromNodeIp(InetAddress nodeIp) {
        if (nodeIp == null) {
            return null;
        }
        EthSwitchImpl ethsw = this.findEthSwitchByIp(nodeIp);
        if (ethsw == null) {
            return null;
        }
        return this.findCdpSeedFromNodePK(ethsw.getPK());
    }

    public CdpSeedImpl findCdpSeedFromNodePK(PKIf nodePK) {
        if (nodePK == null) {
            return null;
        }
        for (CdpSeedImpl seed : this._cdpSeeds) {
            if (!seed.getPK().equals(nodePK) && seed.findDiscoveredNodeByNodePK(nodePK) == null) continue;
            return seed;
        }
        return null;
    }

    public CdpSeedImpl findTaskByDeepTask(long deepTaskId) {
        for (CdpSeedImpl seed : this._cdpSeeds) {
            if (seed.getDeepTaskId() != deepTaskId) continue;
            return seed;
        }
        return null;
    }

    public int getNumVlans() {
        return this._vlans.size();
    }

    public List<VlanImpl> getVlans() {
        if (this._vlans.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<VlanImpl>(this._vlans);
    }

    public List<VlanBase> getVlanBases() {
        if (this._vlans.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<VlanBase> base = new ArrayList<VlanBase>(this._vlans.size());
        for (VlanImpl vlan : this._vlans) {
            base.add(vlan.getBase());
        }
        return base;
    }

    boolean addVlan(VlanImpl vlan) {
        if (vlan == null) {
            return false;
        }
        boolean added = this._vlans.add(vlan);
        if (added) {
            this._vlansById.put(vlan.getVlanPK()._id, vlan);
            if (vlan.getDBID() != 0L) {
                this._vlansByDBID.put(vlan.getDBID(), vlan);
            }
            this.modelObjectAdded(vlan);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeVlan(VlanImpl vlan, boolean purgeDB) {
        if (vlan == null) {
            return false;
        }
        boolean removed = this._vlans.remove(vlan);
        if (removed) {
            this.modelObjectRemoved(vlan.getPK());
            ConcurrentHashMap<Number, VlanImpl> concurrentHashMap = this._vlansById;
            synchronized (concurrentHashMap) {
                this._vlansById.remove(vlan.getVlanPK()._id);
            }
            concurrentHashMap = this._vlansByDBID;
            synchronized (concurrentHashMap) {
                this._vlansByDBID.remove(vlan.getDBID());
            }
            if (purgeDB) {
                try {
                    LanPersistentManager.getInstance().purgeVlan(this, vlan);
                }
                catch (Exception e) {
                    _Tracer.log(Level.WARN, this + "purge failed on cdp vlan:" + vlan, e);
                }
            }
        }
        return removed;
    }

    public VlanImpl findVlanByPK(VlanPK vlanPK) {
        if (vlanPK == null) {
            return null;
        }
        return this._vlansById.get(vlanPK._id);
    }

    public VlanImpl findVlanById(int vlanId) {
        return this._vlansById.get((short)vlanId);
    }

    public int getNumFexes() {
        return this._fexes.size();
    }

    public List<FexImpl> getFexes() {
        return new ArrayList<FexImpl>(this._fexes);
    }

    public boolean addFex(FexImpl fex) {
        if (fex == null) {
            return false;
        }
        this._fexes.add(fex);
        boolean added = this.addEthSwitch(fex, false);
        return added;
    }

    boolean removeFexOnly(FexImpl fex, boolean purgeDB) {
        if (fex == null) {
            return false;
        }
        boolean removed = this._fexes.remove(fex);
        if (removed) {
            this.removeEthSwitchOnly(fex, purgeDB);
        }
        return removed;
    }

    boolean removeFexAndComponents(FexImpl fex, boolean purgeDB) {
        if (fex == null) {
            return false;
        }
        SerialNumKey fexPK = fex.getFexPK();
        Set<EthIslImpl> islSet = this.findEthIslsBySwPK(fexPK);
        for (EthIslImpl isl : islSet) {
            this.removeEthIsl(isl, false);
        }
        ArrayList<EthPortImpl> portSet = fex.getAllPorts();
        for (EthPortImpl port : portSet) {
            fex.removeEthPort(port.getIfIndex(), false);
        }
        boolean removed = this.removeFexOnly(fex, false);
        return removed;
    }

    public FexImpl findFexByPK(SerialNumKey fexPK) {
        if (fexPK == null) {
            return null;
        }
        EthSwitchImpl sw = this.findEthSwitchByPK(fexPK);
        if (sw instanceof FexImpl) {
            return (FexImpl)sw;
        }
        return null;
    }

    public List<FexImpl> findFexesBySwPK(PKIf swPK) {
        EthSwitchImpl sw = this.findEthSwitchByPK(swPK);
        if (sw == null || !sw.isFexEnabled()) {
            return null;
        }
        return sw.getFexes();
    }

    public List<PKIf> purgeAllDowns() throws Exception {
        if (this.isDiscovering()) {
            throw new DiscoveryException(LAN_IS_BUSY);
        }
        ArrayList<PKIf> purgedKeys = new ArrayList<PKIf>(5);
        purgedKeys.addAll(this.purgeDownEthIsls());
        purgedKeys.addAll(this.purgeDownEthSwitches());
        List<CdpSeedImpl> tasks = this.getCdpSeeds();
        for (CdpSeedImpl task : tasks) {
            if (task.getSeedIPs().size() > 0) continue;
            long taskId = task.getTaskKey().getId();
            try {
                _Tracer.log(Level.INFO, "purgeAllDowns(),  remove empty CdpTask taskId = " + taskId);
                DCManager.getInstance().removeLanTask(IdentityManager.getInstance().getCurrentUsername(), taskId);
                DCManager.getInstance().removeTask(task.getTaskKey(), true);
                HostImpl.cleanupLanHosts();
                _Tracer.log(Level.INFO, "purgeAllDowns(),  DONE remove CdpTask taskId = " + taskId);
            }
            catch (Exception e) {
                _Tracer.log(Level.INFO, "purgeAllDowns() caught exception in removing empty CdpTask taskId = " + taskId, e);
            }
        }
        return purgedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PKIf> purgeDownEthSwitches() throws Exception {
        if (this.isDiscovering()) {
            throw new DiscoveryException(LAN_IS_BUSY);
        }
        HashMap<PKIf, EthSwitchImpl> purgedMap = new HashMap<PKIf, EthSwitchImpl>(5);
        Collection<EthSwitchImpl> collection = this._ethSwitches;
        synchronized (collection) {
            for (EthSwitchImpl sw : this._ethSwitches) {
                if (sw.isPresent()) continue;
                purgedMap.put(sw.getSwitchPK(), sw);
            }
            for (EthSwitchImpl sw : purgedMap.values()) {
                this.removeEthSwitchAndComponents(sw, true);
            }
        }
        ArrayList<PKIf> purgedKeys = new ArrayList<PKIf>(purgedMap.keySet());
        if (purgedKeys.size() != 0) {
            PKIf[] keys = purgedKeys.toArray(new PKIf[purgedKeys.size()]);
            DCManager.getInstance().notifyMembersPurged(this, keys);
        }
        return purgedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EthIslPK> purgeDownEthIsls() throws Exception {
        if (this.isDiscovering()) {
            throw new DiscoveryException(LAN_IS_BUSY);
        }
        HashMap<EthIslPK, EthIslImpl> purgedMap = new HashMap<EthIslPK, EthIslImpl>(5);
        Collection<EthIslImpl> collection = this._ethIsls;
        synchronized (collection) {
            for (EthIslImpl isl : this._ethIsls) {
                if (isl.isPresent() && this.findEthSwitchByPK(isl.getSwitch1PK()) != null && this.findEthSwitchByPK(isl.getSwitch2PK()) != null) continue;
                purgedMap.put(isl.getIslPK(), isl);
            }
            for (EthIslImpl isl : purgedMap.values()) {
                this.removeEthIsl(isl, true);
            }
        }
        ArrayList<EthIslPK> purgedKeys = new ArrayList<EthIslPK>(purgedMap.keySet());
        if (purgedKeys.size() != 0) {
            PKIf[] keys = purgedKeys.toArray(new PKIf[purgedKeys.size()]);
            DCManager.getInstance().notifyMembersPurged(this, keys);
        }
        return purgedKeys;
    }

    public boolean setPollInterval(int interval) {
        if (interval != this._pollInterval && interval > 0) {
            this._pollInterval = interval;
            return true;
        }
        return false;
    }

    public int getPollInterval() {
        return this._pollInterval;
    }

    public void enablePolling(boolean enable) {
        this._enablePolling = enable;
    }

    public boolean isPollingEnabled() {
        return this._enablePolling;
    }

    public int getRediscoverInterval() {
        return _CdpRediscvInterval;
    }

    public long getDiscoveryTimeout() {
        return this._cdpTimeout;
    }

    public synchronized CdpWorker getWorker() {
        if (this._worker == null) {
            this._worker = new CdpWorker(this, this.getPollInterval());
        }
        return this._worker;
    }

    public boolean isDiscovering() {
        return this._worker == null ? false : this._worker.isDiscovering();
    }

    public boolean hasWorker() {
        return this._worker != null;
    }

    public boolean isInitialDiscovery() {
        return this._worker == null || this._worker.getDiscoveryType() == DiscoveryType.LAN_INITIAL;
    }

    public boolean isInInitialDiscovery() {
        if (this._worker == null) {
            return false;
        }
        return this._worker.getDiscoveryType() == DiscoveryType.LAN_INITIAL && this._worker.isDiscovering();
    }

    public boolean isOnDemandDiscovery() {
        return this._worker != null && this._worker.getDiscoveryType() == DiscoveryType.LAN_ONDEMAND;
    }

    public void setDiscoveryType(DiscoveryType discType) {
        if (this._worker != null) {
            this._worker.setDiscoveryType(discType);
        }
    }

    public void incrementChange(boolean delayed) {
        if (delayed) {
            this.scheduleRefresh(12000);
            this._delayedChanges.set(0);
        } else if (this.isDiscovering()) {
            this._nondelayedChanges.increment();
        } else if (!this.isRefreshScheduled()) {
            this.scheduleRefresh(5000);
        }
    }

    void scheduleRefresh(int delay) {
        if (this._worker == null) {
            return;
        }
        SchedulerSingleton schdl = SchedulerSingleton.getInstance();
        Schedule sch = new Schedule(delay, (long)this._pollInterval * 1000L, false);
        if (this._worker.getState() == 1 || this._worker.getState() == 2) {
            schdl.setTaskSchedule(this._worker, sch);
        } else {
            schdl.addTask(this._worker, sch);
        }
    }

    boolean isRefreshScheduled() {
        return this._worker != null && (this._worker.getState() == 1 || this._worker.getState() == 2);
    }

    public void preDiscovery(DiscoveryType discType) {
        this._lastScanTime = System.currentTimeMillis();
        this._bufInUse.set(true);
        if (discType != DiscoveryType.LAN_INITIAL) {
            this.lockLanQuery();
            if (this._nondelayedChanges.get() != 0) {
                this._nondelayedChanges.set(0);
            }
        }
    }

    public void postCoreDiscovery(DiscoveryType discType) {
        if (discType == DiscoveryType.LAN_INITIAL) {
            this.unlockLanQuery();
        }
        if (this._status.get() == 1 || this._status.get() == 6) {
            this.releaseLan(2);
        } else if (this._status.get() == 2) {
            _Tracer.log(Level.INFO, "postCoreDiscovery: LAN " + this + " had been opened");
        }
    }

    public void postDiscovery(DiscoveryType discType, boolean succeeded) {
        boolean autoReg;
        List<EthSwitchImpl> ethSwitches;
        ArrayList<VlanImpl> emptyVlans = new ArrayList<VlanImpl>(5);
        for (VlanImpl vlan : this._vlans) {
            if (!vlan.isEmpty()) continue;
            emptyVlans.add(vlan);
        }
        for (VlanImpl vlan : emptyVlans) {
            this.removeVlan(vlan, true);
        }
        this.createSwitchPorts();
        this.setCapacity();
        List<Integer> sIds = null;
        try {
            if (this.getPK() != null) {
                sIds = ClusterMapping.getInstance().qSIdsFromFId(this.getPK().getId());
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.INFO, "Catch Excetpion for query SIds From FId for LAN:" + this, e);
        }
        if (this.getDBID() != 0L && (sIds == null || sIds.size() == 0) || this.isLanEmpty()) {
            try {
                _Tracer.log(Level.INFO, "Remove and purge empty LAN --" + this.getLanName());
                DCManager.getInstance().removeLan(this.getPK(), true, true);
                if (this._status.get() == 1) {
                    this.releaseLan(2);
                } else if (this._status.get() == 2 && this.getDBID() > 0L) {
                    DCManager.getInstance().notifyLanOpened(this);
                }
            }
            catch (Exception e) {
                _Tracer.log(Level.INFO, "Catch Excetpion for purging empty LAN:" + this, e);
            }
            return;
        }
        List<CdpSeedImpl> cdplist = this.getCdpSeeds();
        for (CdpSeedImpl seed : cdplist) {
            if (!seed.isDeepDisc()) continue;
            List<EthSwitchImpl> switches = seed.getDiscoveredEthSwitches();
            if (switches != null && switches.size() > 0) {
                for (EthSwitchImpl sw : switches) {
                    sw.setDeepDisc(true);
                }
            }
            seed.setDeepDisc(false);
        }
        if (discType == DiscoveryType.LAN_INITIAL && this._status.get() != 6) {
            try {
                DiscoveryManager.getInstance().enablePoll(this._pkey, this._enablePolling);
            }
            catch (Exception ex) {}
        } else {
            this.releasePendingBuffer();
        }
        if ((discType == DiscoveryType.LAN_INITIAL || discType == DiscoveryType.LAN_AUTODEMAND || discType == DiscoveryType.LAN_ONDEMAND) && (ethSwitches = this.getEthSwitches()) != null) {
            ArrayList<EthSwitchImpl> sws = new ArrayList<EthSwitchImpl>();
            for (EthSwitchImpl sw : ethSwitches) {
                CdpSeedImpl seed = DCManager.getInstance().findTaskBySwPK(sw.getSwitchPK());
                if (!sw.isManageable() && (seed == null || !seed.needDisc())) continue;
                sws.add(sw);
            }
            HostManager.getInstance().startLanHostWorker(this, sws);
        }
        boolean bl = autoReg = Boolean.valueOf(System.getProperty("trap.listen", "true")) != false && Boolean.valueOf(System.getProperty("trap.autoregistration", "true")) != false;
        if (autoReg) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EventControllerService ec = (EventControllerService)ServiceConfig.findService((String)"Event Controller Service");
                    ArrayList switchsCopy = null;
                    Collection collection = LanImpl.this._ethSwitches;
                    synchronized (collection) {
                        switchsCopy = new ArrayList(LanImpl.this._ethSwitches);
                    }
                    for (EthSwitchImpl sw : switchsCopy) {
                        ec.addSource(sw);
                        if (sw.isTrapRegistered() || !sw.isManageable() || sw.isFexEnabled()) continue;
                        SnmpPeer peer = sw.getPeer();
                        if (ec == null || peer == null) continue;
                        ec.registerTrap(peer);
                    }
                }
            }.start();
        }
        if (this._delayedChanges.get() != 0) {
            this.scheduleRefresh(12000);
            this._delayedChanges.set(0);
        } else if (this._nondelayedChanges.get() != 0 && !this.isRefreshScheduled()) {
            this.scheduleRefresh(2000);
        }
    }

    public void createSwitchPorts() {
        List<EthSwitchImpl> sws = this.getEthSwitches();
        InventoryManager im = InventoryManager.getInstance();
        for (EthSwitchImpl sw : sws) {
            if (sw.getBase().isVdc() || sw.getBase().isFwsm() || sw.getBase().isFex()) continue;
            Set<Integer> preCardSlots = im.findCardSlotIds(sw.getSwitchPK());
            List<EthPortImpl> ports = sw.getEthPorts();
            for (EthPortImpl port : ports) {
                Card card;
                int slotId = -1;
                if (IfIndexUtil.getType(port.getIfIndex()) == 31) {
                    int fexId = IfIndexUtil.ifIndex2SatSwitchId(port.getIfIndex()) + 1;
                    slotId = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.MODULE.value(), fexId);
                } else {
                    slotId = IfIndexUtil.ifIndex2Card(port.getIfIndex()) + 1;
                }
                if (port.getIfSpeed() == 0L && (card = im.findCard(sw.getSwitchPK(), slotId)) != null) {
                    if (port.isPhysical() && port.isEth()) {
                        port.setIfSpeed(FRUConstants.getMaxCapacity(card.getType(), 3));
                    } else {
                        port.setIfSpeed(FRUConstants.getMaxCapacity(card.getType(), 1));
                    }
                }
                preCardSlots.remove(slotId);
            }
            Iterator<Comparable> i$ = preCardSlots.iterator();
            while (i$.hasNext()) {
                Card card;
                int slotId = (Integer)i$.next();
                if (slotId == 0 || (card = im.findCard(sw.getSwitchPK(), slotId)) == null || NexusEntityMibHelper.isFexPhyIndex(card.getPhysicalIndex())) continue;
                this.createSwitchPorts(sw, slotId, card.getType());
            }
        }
    }

    public void createSwitchPorts(EthSwitchImpl sw, int slot, int moduleType) {
        EthPortImpl port;
        String ifName;
        int i;
        int totalPorts = FRUConstants.getNumPorts(moduleType);
        int gigEPorts = FRUConstants.getNumGigEPorts(moduleType);
        int ethPorts = FRUConstants.getNumEthPorts(moduleType);
        int fcPorts = totalPorts - gigEPorts - ethPorts;
        long capacityEth = FRUConstants.getMaxCapacity(moduleType, 2);
        long capacityGigE = FRUConstants.getMaxCapacity(moduleType, 3);
        long capacityFc = FRUConstants.getMaxCapacity(moduleType, 1);
        for (i = 0; i < fcPorts; ++i) {
            ifName = "fc" + slot + '/' + (i + 1);
            port = sw.createPort(sw.getBase().nameToIfIndex(ifName));
            port.setIfname(ifName);
            if (moduleType == 40) {
                capacityFc = FRUConstants.getMaxCapacity(moduleType, 1, i + 1);
            }
            port.setIfSpeed(capacityFc);
            port.setIfType(56);
        }
        for (i = 0; i < gigEPorts; ++i) {
            ifName = "gigE" + slot + '/' + (i + 1);
            port = sw.createPort(sw.getBase().nameToIfIndex(ifName));
            port.setIfname(ifName);
            if (moduleType == 50000003) {
                capacityFc = FRUConstants.getMaxCapacity(moduleType, 3, i + 1);
            }
            port.setIfSpeed(capacityGigE);
            port.setIfType(117);
        }
        for (i = 0; i < ethPorts; ++i) {
            ifName = "Ethernet" + slot + '/' + (i + 1);
            port = sw.createPort(sw.getBase().nameToIfIndex(ifName));
            port.setIfname(ifName);
            port.setIfSpeed(capacityEth);
            port.setIfType(6);
        }
    }

    public void createNavGroup(EthSwitchImpl sw) {
        try {
            if (sw.isFwsm()) {
                return;
            }
            long grpId = CdpSeedImpl.findNavGroupDBIdFromDB(sw);
            NavigationUtil.getInstance().modifyGroupType(grpId, 1);
            if (grpId < 2L) {
                grpId = 2L;
            }
            NavigationUtil.getInstance().addGroupMember(sw.getDBID(), sw.getName(), 4, grpId);
        }
        catch (SQLException ex) {
            _Tracer.log(Level.WARN, "Failed to find nav group for switch " + sw, ex);
        }
    }

    public void createNavGroup() {
        for (EthSwitchImpl sw : this._ethSwitches) {
            try {
                if (sw.isFwsm()) continue;
                long grpId = CdpSeedImpl.findNavGroupDBIdFromDB(sw);
                NavigationUtil.getInstance().modifyGroupType(grpId, 1);
                if (grpId < 2L) {
                    grpId = 2L;
                }
                NavigationUtil.getInstance().addGroupMember(sw.getDBID(), sw.getName(), 4, grpId);
            }
            catch (SQLException ex) {
                _Tracer.log(Level.WARN, "Failed to find nav group for switch " + sw, ex);
            }
        }
    }

    public void createNavGroupForFex() {
        for (EthSwitchImpl sw : this._ethSwitches) {
            try {
                if (!sw.getBase().isFex() || !sw.hasManageableSeed()) continue;
                long grpId = CdpSeedImpl.findNavGroupDBIdFromDB(sw);
                NavigationUtil.getInstance().modifyGroupType(grpId, 1);
                if (grpId < 2L) {
                    grpId = 2L;
                }
                NavigationUtil.getInstance().addGroupMember(sw.getDBID(), sw.getName(), 4, grpId);
            }
            catch (SQLException ex) {
                _Tracer.log(Level.WARN, "Failed to find nav group for switch " + sw, ex);
            }
        }
    }

    public void finalizeDiscovery() {
        this.unlockLanQuery();
        this.releasePendingBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modelObjectChanged(PKIf objKey, short propId, Serializable oldValue, Serializable newValue) {
        if (propId != 1038 && (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3)) {
            return;
        }
        if (objKey == null) {
            _Tracer.log(Level.WARN, this.prefix() + "modelObjectChanged has null PK: " + objKey);
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                boolean escapeSupress = true;
                if (!escapeSupress) {
                    for (int i = 0; i < this._changed.size(); ++i) {
                        ChangedModelObject chgObj = this._changed.get(i);
                        if (chgObj._propId != propId || !chgObj.getPK().equals(objKey)) continue;
                        if (LanImpl.equals(propId, chgObj.getOldValue(), newValue)) {
                            this._changed.remove(i);
                        } else {
                            chgObj.setNewValue(newValue);
                        }
                        return;
                    }
                }
                this._changed.add(new ChangedModelObject(objKey, propId, oldValue, newValue));
                DCManager.getInstance().notifyMembersChanged(this, new ChangedModelObject[]{new ChangedModelObject(objKey, propId, oldValue, newValue)});
            }
        } else {
            DCManager.getInstance().notifyMembersChanged(this, new ChangedModelObject[]{new ChangedModelObject(objKey, propId, oldValue, newValue)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modelObjectAdded(AbstractModelObjectImpl modelObj) {
        if (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3) {
            return;
        }
        if (modelObj.getPK() == null) {
            _Tracer.log(Level.WARN, "LanImpl::modelObjectAdded has null PK: " + modelObj);
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                if (this.findInAddedList(modelObj.getPK()) == -1) {
                    this._added.add(modelObj);
                }
                Iterator<ChangedModelObject> it = this._changed.iterator();
                while (it.hasNext()) {
                    ChangedModelObject chgObj = it.next();
                    if (!chgObj.getPK().equals(modelObj.getPK())) continue;
                    it.remove();
                }
            }
        } else {
            DCManager.getInstance().notifyMembersAdded(this, new AbstractModelObjectImpl[]{modelObj});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void modelObjectRemoved(PKIf moKey) {
        if (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3) {
            return;
        }
        if (moKey == null) {
            _Tracer.log(Level.WARN, "LanImpl::modelObjectRemoved has null PK: " + moKey);
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                int index = this.findInAddedList(moKey);
                if (index != -1) {
                    this._added.remove(index);
                } else if (!this._removed.contains(moKey)) {
                    this._removed.add(moKey);
                }
            }
        } else {
            DCManager.getInstance().notifyMembersRemoved(this, new PKIf[]{moKey});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelObjectMoved(PKIf objKey, PKIf oldAssocKey, PKIf newAssocKey) {
        if (this.isInitialDiscovery() && this._status.get() == 1 || this._status.get() == 3) {
            return;
        }
        if (objKey == null) {
            _Tracer.log(Level.WARN, "LanImpl::modelObjectMoved has null PK: " + objKey);
            return;
        }
        if (this._bufInUse.get()) {
            AtomicBoolean atomicBoolean = this._bufInUse;
            synchronized (atomicBoolean) {
                if (this.findInAddedList(objKey) == -1) {
                    for (int i = 0; i < this._moved.size(); ++i) {
                        MovedModelObject movObj = this._moved.get(i);
                        if (!movObj.getObjectPK().equals(objKey)) continue;
                        if (GenUtil.equals(movObj.getOldAssocPK(), newAssocKey)) {
                            this._moved.remove(i);
                        } else {
                            movObj.setNewParent(newAssocKey);
                        }
                        return;
                    }
                    this._moved.add(new MovedModelObject(objKey, oldAssocKey, newAssocKey));
                }
            }
        } else {
            DCManager.getInstance().notifyMembersMoved(this, new MovedModelObject[]{new MovedModelObject(objKey, oldAssocKey, newAssocKey)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int findInAddedList(PKIf pkey) {
        List<AbstractModelObjectImpl> list = this._added;
        synchronized (list) {
            for (int i = 0; i < this._added.size(); ++i) {
                AbstractModelObjectImpl o = this._added.get(i);
                if (o == null) {
                    _Tracer.log(Level.ERROR, "model object #" + i + " in added list(" + this._added.size() + ") is null");
                    continue;
                }
                PKIf pk = o.getPK();
                if (pk == null) {
                    _Tracer.log(Level.ERROR, "model object " + o.toString() + " key is null");
                    continue;
                }
                if (!pk.equals(pkey)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePendingBuffer() {
        AtomicBoolean atomicBoolean = this._bufInUse;
        synchronized (atomicBoolean) {
            Serializable[] a;
            if (!this._bufInUse.get()) {
                return;
            }
            if (!this._added.isEmpty()) {
                Comparator endPortCmp = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        boolean is2;
                        boolean is1 = o1 instanceof EndPortImpl || o1 instanceof IslImpl;
                        boolean bl = is2 = o2 instanceof EndPortImpl || o2 instanceof IslImpl;
                        if (is1 && is2) {
                            return 0;
                        }
                        if (is1 && !is2) {
                            return 1;
                        }
                        return -1;
                    }
                };
                AbstractModelObjectImpl[] a2 = new AbstractModelObjectImpl[this._added.size()];
                this._added.toArray(a2);
                Arrays.sort(a2, endPortCmp);
                DCManager.getInstance().notifyMembersAdded(this, a2);
                this._added.clear();
            }
            if (!this._changed.isEmpty()) {
                a = new ChangedModelObject[this._changed.size()];
                this._changed.toArray(a);
                DCManager.getInstance().notifyMembersChanged(this, (ChangedModelObject[])a);
                this._changed.clear();
            }
            if (!this._moved.isEmpty()) {
                a = new MovedModelObject[this._moved.size()];
                this._moved.toArray(a);
                DCManager.getInstance().notifyMembersMoved(this, (MovedModelObject[])a);
                this._moved.clear();
            }
            if (!this._removed.isEmpty()) {
                a = new PKIf[this._removed.size()];
                this._removed.toArray(a);
                DCManager.getInstance().notifyMembersRemoved(this, (PKIf[])a);
                this._removed.clear();
            }
            this._bufInUse.set(false);
        }
    }

    public static boolean equals(short propId, Serializable value1, Serializable value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        switch (propId) {
            case 1544: {
                return VsanFcIdKey.equals((VsanFcIdKey[])value1, (VsanFcIdKey[])value2);
            }
            case 1284: 
            case 1287: 
            case 3076: {
                List l1 = (List)((Object)value1);
                List l2 = (List)((Object)value2);
                return l1.size() != l2.size() ? false : l1.containsAll(l2) && l2.containsAll(l1);
            }
        }
        return value1.equals(value2);
    }

    private String prefix() {
        return "Lan-" + String.valueOf(this._pkey) + " : ";
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    public String dump(boolean inDetail) {
        return this.dump(inDetail, 0);
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indent(level)).append(this.getPK());
        if (inDetail) {
            sb.append(this.indent(level + 1)).append("Status: ").append(this._status).append(this.indent(level + 1)).append("LastScanTime: ").append(new Date(this.getLastScanTime()));
            if (this._isPersistent) {
                sb.append(this.indent(level + 1)).append("Persisted at: ").append(new Date(this.getLastUpdateTime()));
                sb.append(this.indent(level + 1)).append("Database Id: ").append(this.getDBID());
            }
            sb.append(this.indent(level + 1)).append("Cdp Included Devices: ").append(_IncludedDeviceSet);
            if (this.getWorker() != null) {
                sb.append(this.getWorker().dump(true, level + 1));
            }
        }
        sb.append(this.indent(level));
        sb.append(this.dump("Cdp Seeds", this._cdpSeeds, inDetail, level + 1)).append(this.dump("Vlans", this._vlans, inDetail, level + 1)).append(this.dump("Ethernet Switches", this._ethSwitches, inDetail, level + 1)).append(this.dump("Fexes", this._fexes, inDetail, level + 1)).append(this.dump("Ethernet Isls", this._ethIsls, inDetail, level + 1));
        return sb.toString();
    }

    public String dumpCdpSeeds() {
        return this.dump("Cdp Seeds", this._cdpSeeds, true, 0);
    }

    public String dumpVlans() {
        return this.dump("Vlans", this._vlans, true, 0);
    }

    public String dumpEthSwitches() {
        return this.dump("Ethernet Switches", this._ethSwitches, true, 0);
    }

    public String dumpEthIsls() {
        return this.dump("Ethernet Isls", this._ethIsls, true, 0);
    }

    public String dump(String prefix, Collection objs, boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.indent(level)).append("Num of " + prefix + ": ").append(objs == null ? Integer.valueOf(0) : objs);
        if (objs != null) {
            for (Object o : objs) {
                if (o instanceof DumpIf) {
                    DumpIf dobj = (DumpIf)o;
                    sb.append(dobj.dump(inDetail, level));
                    continue;
                }
                sb.append(this.indent(level)).append(String.valueOf(o));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        return this.toString();
    }

    public String dumpHashes() {
        Field[] flds;
        StringBuilder sb = new StringBuilder();
        for (Field field : flds = this.getClass().getDeclaredFields()) {
            try {
                String name;
                Object o = field.get(this);
                if (o instanceof Map) {
                    name = field.getName();
                    Map map = (Map)o;
                    sb.append('\n');
                    if (name.charAt(0) == '_') {
                        sb.append(name.substring(1));
                    } else {
                        sb.append(name);
                    }
                    sb.append(": ");
                    if (map == null) {
                        sb.append("none");
                    } else {
                        sb.append(map.size());
                        Set s = map.entrySet();
                        for (Map.Entry ent : s) {
                            sb.append("\n\tkey=").append(ent.getKey()).append(" \tvalue=").append(ent.getValue());
                        }
                    }
                    sb.append('\n');
                    continue;
                }
                if (!(o instanceof Set)) continue;
                name = field.getName();
                Set set = (Set)o;
                sb.append('\n');
                if (name.charAt(0) == '_') {
                    sb.append(name.substring(1));
                } else {
                    sb.append(name);
                }
                sb.append(": ");
                if (set == null) {
                    sb.append("none");
                } else {
                    sb.append(set.size());
                    for (Object item : set) {
                        if (item instanceof DumpIf) {
                            sb.append("\n\t").append(((DumpIf)item).print(true, true));
                            continue;
                        }
                        sb.append("\n\t").append(item);
                    }
                }
                sb.append('\n');
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public void addEthSwitchDBID(EthSwitchImpl sw) {
        if (sw.getDBID() != 0L) {
            this._ethSwitchesByDBID.put(sw.getDBID(), sw);
        }
    }

    public void removeEthSwitchDBID(EthSwitchImpl sw) {
        if (sw.getDBID() != 0L) {
            this._ethSwitchesByDBID.remove(sw.getDBID(), sw);
        }
    }

    public EthSwitchImpl findEthSwitchByDBID(long dbid) {
        return this._ethSwitchesByDBID.get(dbid);
    }

    public void addEthPortDBID(EthPortImpl ethPort) {
        if (ethPort.getDBID() != 0L) {
            this._ethPortsByDBID.put(ethPort.getDBID(), ethPort);
        }
    }

    public void removeEthPortDBID(EthPortImpl ethPort) {
        if (ethPort.getDBID() != 0L) {
            this._ethPortsByDBID.remove(ethPort.getDBID());
        }
    }

    public EthPortImpl findEthPortByDBID(long dbid) {
        return this._ethPortsByDBID.get(dbid);
    }

    public void addEthIslDBID(EthIslImpl ethIsl) {
        if (ethIsl.getDBID() != 0L) {
            this._ethIslsByDBID.put(ethIsl.getDBID(), ethIsl);
        }
    }

    public void removeEthIslDBID(EthIslImpl ethIsl) {
        if (ethIsl.getDBID() != 0L) {
            this._ethIslsByDBID.remove(ethIsl.getDBID());
        }
    }

    public EthIslImpl findEthIslByDBID(long dbid) {
        return this._ethIslsByDBID.get(dbid);
    }

    public void addVlanDBID(VlanImpl vlan) {
        if (vlan.getDBID() != 0L) {
            this._vlansByDBID.put(vlan.getDBID(), vlan);
        }
    }

    public void removeVlanDBID(VlanImpl vlan) {
        if (vlan.getDBID() != 0L) {
            this._vlansByDBID.remove(vlan.getDBID());
        }
    }

    public VlanImpl findVlanByDBID(long dbid) {
        return this._vlansByDBID.get(dbid);
    }

    public void addCdpSeedDBID(CdpSeedImpl cdpSeed) {
        if (cdpSeed.getDBID() != 0L) {
            this._cdpSeedsByDBID.put(cdpSeed.getDBID(), cdpSeed);
        }
    }

    public void removeCdpSeedDBID(CdpSeedImpl cdpSeed) {
        if (cdpSeed.getDBID() != 0L) {
            this._cdpSeedsByDBID.remove(cdpSeed.getDBID());
        }
    }

    public CdpSeedImpl findCdpSeedByDBID(long dbid) {
        return this._cdpSeedsByDBID.get(dbid);
    }

    public void setUserDBID(long id) {
        this._userDBID = id;
    }

    public long getUserDBID() {
        return this._userDBID;
    }

    public boolean isPersisted() {
        return this._persisted;
    }

    public void postCommit() {
        Iterator<Map.Entry<Long, EthPortImpl>> it = this._ethPortsByDBID.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, EthPortImpl> entry = it.next();
            if (!entry.getValue().getBaseObject().isFlushed()) {
                it.remove();
                continue;
            }
            entry.getValue().getBaseObject().clear();
        }
        DCManager.getInstance().notifyLanDiscovered(this);
        this._persisted = true;
    }

    @Override
    public String getDBTableName() {
        return LanDBTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block5: {
            if (this.getPK() == null) {
                return;
            }
            stat = con.prepareStatement(QuerySQL_LanDBIDByLanId);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block5;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._pkey.getId());
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setLong(i++, this._pkey.getId());
        stat.setString(i++, this._pkey.getName());
        stat.setLong(i++, this.getLastScanTime());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setBoolean(i++, this.isPersistent());
        stat.setBoolean(i++, true);
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this._pkey.getId());
        stat.setString(i++, this._pkey.getName());
        stat.setLong(i++, this.getLastScanTime());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setBoolean(i++, this.isPersistent());
        stat.setBoolean(i++, true);
        stat.setLong(i++, this.getDBID());
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getDeleteSqlStr() {
        return DeleteSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQL_LanDBIDByLanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanImpl> loadLanFromDB() throws SQLException {
        List<LanImpl> list;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        int serverId = -1;
        try {
            String queryStr = QuerySQL_LanByServerId;
            serverId = ClusterSequence.getSequence().getServerId();
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(queryStr));
            stat.setInt(1, serverId);
            rs = stat.executeQuery();
            list = LanImpl.loadDBRecord(rs);
        }
        catch (SQLException ex) {
            List<LanImpl> list2;
            try {
                _Tracer.log(Level.ERROR, "loadLanFromDB failed for server:" + serverId, ex);
                list2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return list2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanImpl loadLanFromDB(LanPK lanPK) throws SQLException {
        LanImpl lanImpl;
        int serverId;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block6: {
            if (lanPK == null) {
                return null;
            }
            con = ConnectionManager.getConnection();
            stat = null;
            rs = null;
            serverId = -1;
            String queryStr = QuerySQL_LanByLanPK;
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(queryStr));
            stat.setInt(1, lanPK.getId());
            rs = stat.executeQuery();
            List<LanImpl> lans = LanImpl.loadDBRecord(rs);
            if (lans == null || lans.size() <= 0) break block6;
            LanImpl lanImpl2 = lans.get(0);
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return lanImpl2;
        }
        try {
            lanImpl = null;
        }
        catch (SQLException ex) {
            LanImpl lanImpl3;
            try {
                _Tracer.log(Level.ERROR, "loadLanFromDB failed for server:" + serverId, ex);
                lanImpl3 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return lanImpl3;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return lanImpl;
    }

    public static List<LanImpl> loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<LanImpl> list = new ArrayList<LanImpl>();
        while (rs.next()) {
            long dbid = rs.getLong(1);
            int lanId = (int)rs.getLong(2);
            String name = rs.getString(3);
            long timestamp = rs.getLong(4);
            boolean isPersist = rs.getBoolean(6);
            LanImpl lan = DCManager.getInstance().createLan(lanId, name);
            if (lan.getPK().getId() != lanId) continue;
            lan.setDBID(dbid);
            lan._lastScanTime = timestamp;
            lan.setPersistent(isPersist);
            list.add(lan);
        }
        return list;
    }

    public void setCapacity() {
        InventoryManager im = InventoryManager.getInstance();
        for (EthSwitchImpl sw : this._ethSwitches) {
            if (sw.getSwitchDiscStatus() == DiscStateType.UNMANAGE.value() || sw.getSwitchDiscStatus() == DiscStateType.FAILED.value()) {
                sw.setSwitchDiscStatus(DiscStateType.CDPMANAGE.value());
            } else if (sw.getSwitchDiscStatus() == DiscStateType.DEEPMANAGE.value()) {
                sw.setSwitchDiscStatus(DiscStateType.FULLMANAGE.value());
            }
            if (sw.getBase().isFwsm()) continue;
            int port1g = 0;
            int port2g = 0;
            int port4g = 0;
            int port8g = 0;
            int port10g = 0;
            int port16g = 0;
            int port40g = 0;
            int port100g = 0;
            List<EthPortImpl> swPorts = sw.getEthPorts();
            for (EthPortImpl swPort : swPorts) {
                if (!swPort.isPhysical() || swPort.getBase().getIfType() == 135 || swPort.isMgmtPort()) continue;
                if (swPort.getIfSpeed() > 0L && swPort.getIfSpeed() <= 1000000000L) {
                    ++port1g;
                    continue;
                }
                if (swPort.getIfSpeed() > 1000000000L && swPort.getIfSpeed() <= 2000000000L) {
                    ++port2g;
                    continue;
                }
                if (swPort.getIfSpeed() > 2000000000L && swPort.getIfSpeed() <= 4000000000L) {
                    ++port4g;
                    continue;
                }
                if (swPort.getIfSpeed() > 4000000000L && swPort.getIfSpeed() <= 8000000000L) {
                    ++port8g;
                    continue;
                }
                if (swPort.getIfSpeed() > 8000000000L && swPort.getIfSpeed() <= 10000000000L) {
                    ++port10g;
                    continue;
                }
                if (swPort.getIfSpeed() > 10000000000L && swPort.getIfSpeed() <= 16000000000L) {
                    ++port16g;
                    continue;
                }
                if (swPort.getIfSpeed() > 16000000000L && swPort.getIfSpeed() <= 40000000000L) {
                    ++port40g;
                    continue;
                }
                if (swPort.getIfSpeed() <= 40000000000L || swPort.getIfSpeed() > 100000000000L) continue;
                ++port100g;
            }
            sw.setNum1gPorts(port1g);
            sw.setNum2gPorts(port2g);
            sw.setNum4gPorts(port4g);
            sw.setNum8gPorts(port8g);
            sw.setNum10gPorts(port10g);
            sw.setNum16gPorts(port16g);
            sw.setNum40gPorts(port40g);
            sw.setNum100gPorts(port100g);
        }
    }

    static {
        String devStr = null;
        try {
            devStr = System.getProperty(Cdp_IncludedDevices_Prop);
        }
        catch (Exception e) {
            _Tracer.log(Level.DEBUG, "CDP get included device properties failed:", e);
        }
        Exception e = PlatformType.parsePlatforms(devStr, _IncludedDeviceSet);
        if (e != null) {
            _Tracer.log(Level.WARN, "Get errors from parsing cdp included devices: " + e.getMessage());
        } else {
            _Tracer.log(Level.INFO, "Cdp includes devices:" + _IncludedDeviceSet);
        }
        if (_IncludedDeviceSet.size() == 0) {
            _IncludedDeviceSet = new HashSet<PlatformType>(Cdp_Default_Devices.length);
            for (PlatformType t : Cdp_Default_Devices) {
                _IncludedDeviceSet.add(t);
            }
            _Tracer.log(Level.WARN, "Cannot get cdp included devices from server properties, use default one: " + _IncludedDeviceSet);
        }
        _CdpPollIntervalInSecond = Integer.getInteger(Cdp_PollInterval_Prop, 300);
        _CdpRediscvInterval = Integer.getInteger(Cdp_RediscvInterval_Prop, 5);
        _CdpTimeoutInSecond = Integer.getInteger(Cdp_Timeout_Prop, 300);
        _Tracer.log(Level.INFO, "Cdp trimDomain:" + CdpTrimDomain);
    }
}

