/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.PmPolicyBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class PmPolicyImpl
extends AbstractDBObjectImpl {
    static final String QuerySQL = "select PM_COLLECTION.ID,FABRIC.NAME, FABRIC_ID ,VSAN_LIST ,MONITOR_ISL,MONITOR_HOST,MONITOR_STORAGE,MONITOR_FLOW, MONITOR_GIGE,MONITOR_OTHER,TRAFFIC_THRESHOLD_ENABLE,EVENT_THRESHOLD,PM_COLLECTION.LAST_UPDATE_TIME  from PM_COLLECTION, fabric where PM_COLLECTION.fabric_id=fabric.id";
    static final String QuerySQLFilteredByServerId = "select PM_COLLECTION.ID,FABRIC.NAME, FABRIC_ID ,VSAN_LIST ,MONITOR_ISL,MONITOR_HOST,MONITOR_STORAGE,MONITOR_FLOW, MONITOR_GIGE,MONITOR_OTHER,TRAFFIC_THRESHOLD_ENABLE,EVENT_THRESHOLD,PM_COLLECTION.LAST_UPDATE_TIME  from PM_COLLECTION, fabric, logicsvr_fabric where PM_COLLECTION.fabric_id=fabric.id and fabric.fid = logicsvr_fabric.f_id and logicsvr_fabric.lsvr_id = ?";
    static final String QuerySQLLanFilteredByServerId = "select PM_COLLECTION.ID,LAN.LAN_NAME, LAN_ID ,VSAN_LIST ,MONITOR_ISL,MONITOR_HOST,MONITOR_STORAGE,MONITOR_FLOW, MONITOR_GIGE,MONITOR_OTHER,TRAFFIC_THRESHOLD_ENABLE,EVENT_THRESHOLD,PM_COLLECTION.LAST_UPDATE_TIME  from PM_COLLECTION, lan where PM_COLLECTION.fabric_id=lan.id ";
    static final String QuerySQLById = "select PM_COLLECTION.ID,FABRIC.NAME,FABRIC_ID ,VSAN_LIST ,MONITOR_ISL,MONITOR_HOST,MONITOR_STORAGE,MONITOR_FLOW, MONITOR_GIGE,MONITOR_OTHER,TRAFFIC_THRESHOLD_ENABLE,EVENT_THRESHOLD,PM_COLLECTION.LAST_UPDATE_TIME  from PM_COLLECTION, fabric where id=? and PM_COLLECTION.fabric_id=fabric.id";
    static final String QuerySQLByFabricId = "select PM_COLLECTION.ID,FABRIC.NAME,FABRIC_ID ,VSAN_LIST ,MONITOR_ISL,MONITOR_HOST,MONITOR_STORAGE,MONITOR_FLOW, MONITOR_GIGE,MONITOR_OTHER,TRAFFIC_THRESHOLD_ENABLE,EVENT_THRESHOLD,PM_COLLECTION.LAST_UPDATE_TIME  from PM_COLLECTION, fabric where fabric_id=? and fabric.id=PM_COLLECTION.fabric_id";
    static final String InsertSQL = "insert into PM_COLLECTION(ID,FABRIC_ID ,VSAN_LIST ,MONITOR_ISL,MONITOR_HOST,MONITOR_STORAGE,MONITOR_FLOW,MONITOR_GIGE,MONITOR_OTHER,TRAFFIC_THRESHOLD_ENABLE,EVENT_THRESHOLD,LAST_UPDATE_TIME) values(?,?,?,?,?,?, ?,?,?,?,?,?)";
    static final String UpdateSQL = "update PM_COLLECTION set FABRIC_ID=?,VSAN_LIST=?,MONITOR_ISL=?,MONITOR_HOST=?,MONITOR_STORAGE=?,MONITOR_FLOW=?,MONITOR_GIGE=?,MONITOR_OTHER=?,TRAFFIC_THRESHOLD_ENABLE=?,EVENT_THRESHOLD=?,LAST_UPDATE_TIME=? where id=?";
    static final String TableName = "PM_COLLECTION";
    private PmPolicyBase _base;

    public PmPolicyImpl(PmPolicyBase base) {
        this._base = base;
        this.setDBID(base.getDBID());
    }

    public PmPolicyBase getBase() {
        return this._base;
    }

    @Override
    public long getDBID() {
        return this._base.getDBID();
    }

    @Override
    public void setDBID(long id) {
        this._base.setDBID(id);
    }

    public static String[] decodeVsanList(String vsanList) {
        return vsanList.split(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QuerySQLByFabricId);
            ResultSet rs = null;
            try {
                stat.setLong(1, this._base.getFabricId());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            stat.setLong(1, this.getDBID());
            stat.setLong(2, this._base.getFabricId());
            stat.setString(3, this._base.getVsans());
            stat.setBoolean(4, this._base.isMonitoringISL());
            stat.setBoolean(5, this._base.isMonitoringHost());
            stat.setBoolean(6, this._base.isMonitoringStorage());
            stat.setBoolean(7, this._base.isMonitoringFlow());
            stat.setBoolean(8, this._base.isMonitoringGige());
            stat.setBoolean(9, this._base.isMonitoringOther());
            stat.setBoolean(10, this._base.hasTrafficThreshold());
            stat.setBoolean(11, this._base.hasEventThreshold());
            stat.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        stat.setLong(1, this._base.getFabricId());
        stat.setString(2, this._base.getVsans());
        stat.setBoolean(3, this._base.isMonitoringISL());
        stat.setBoolean(4, this._base.isMonitoringHost());
        stat.setBoolean(5, this._base.isMonitoringStorage());
        stat.setBoolean(6, this._base.isMonitoringFlow());
        stat.setBoolean(7, this._base.isMonitoringGige());
        stat.setBoolean(8, this._base.isMonitoringOther());
        stat.setBoolean(9, this._base.hasTrafficThreshold());
        stat.setBoolean(10, this._base.hasEventThreshold());
        stat.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
        stat.setLong(12, this.getDBID());
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadAllFromDB() throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        String queryStr = QuerySQLFilteredByServerId;
        ArrayList sanList = null;
        ArrayList lanList = null;
        try {
            stat = con.prepareStatement(queryStr);
            stat.setInt(1, Sequence.getSequence().getServerId());
            rs = stat.executeQuery();
            sanList = PmPolicyImpl.loadDBRecord(rs);
            DbUtil.close(rs);
            DbUtil.close(stat);
            stat = con.prepareStatement(QuerySQLLanFilteredByServerId);
            rs = stat.executeQuery();
            lanList = PmPolicyImpl.loadDBRecord(rs);
            sanList.addAll(lanList);
            arrayList = sanList;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<PmPolicyImpl> al = new ArrayList<PmPolicyImpl>();
        while (rs.next()) {
            PmPolicyBase ppb = new PmPolicyBase(rs.getLong(3), rs.getString(2), rs.getString("vsan_list"), rs.getBoolean("monitor_isl"), rs.getBoolean("monitor_host"), rs.getBoolean("monitor_storage"), rs.getBoolean("monitor_flow"), rs.getBoolean("monitor_gige"), rs.getBoolean("monitor_other"), rs.getBoolean("TRAFFIC_THRESHOLD_ENABLE"), rs.getBoolean("EVENT_THRESHOLD"));
            if (rs.getMetaData().getColumnLabel(3).toLowerCase().equals("fabric_id")) {
                ppb.setLan(false);
            } else {
                ppb.setLan(true);
            }
            PmPolicyImpl ppi = new PmPolicyImpl(ppb);
            al.add(ppi);
        }
        return al;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }
}

