/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.HostClusterImpl;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.vi.model.ComputeResource;
import com.cisco.dcbu.vi.model.HostSystem;
import com.cisco.dcbu.vi.model.PhyNic;
import com.cisco.dcbu.vi.model.ViManager;
import com.vmware.vim25.HostNetworkInfo;
import com.vmware.vim25.PhysicalNic;
import com.vmware.vim25.PhysicalNicHintInfo;
import com.vmware.vim25.PhysicalNicIpHint;
import com.vmware.vim25.mo.HostNetworkSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class VHostImpl
extends AbstractModelObjectImpl {
    static final String QuerySQL = "select id, vcenter_id, name, full_name, mac_address, ip_address, last_scan_time from vhost";
    static final String QuerySQLByMoRef = "select id, vcenter_id, name, full_name, mac_address, ip_address, last_scan_time, moref from vhost where moref=? and vcenter_id=?";
    static final String QuerySQLByFullName = "select id, name, full_name, mac_address, ip_address, last_scan_time, moref from vhost where full_name=? and vcenter_id=?";
    static final String QuerySQLByID = "select id, vcenter_id, name, full_name, mac_address, ip_address, last_update_time, moref from vhost where id=?";
    static final String QuerySQLByIp = "select id from vhost where ip_address=?";
    static final String InsertSQL = "insert into vhost(id,vcenter_id, name,  full_name, mac_address, ip_address, os_info, vendor, model, version,cluster_id, memory_size, cpucount, cpu_speed_avg, hbas, multipath, iscsi_names, aliases, conn_state, power_state, moRef, last_scan_time, last_update_time) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    static final String UpdateSQL = "update vhost set vcenter_id =?, name =?,  full_name=?, mac_address=?, ip_address=?, os_info=?, vendor=?, model=?, version=?, cluster_id=?, memory_size=?, cpucount=?, cpu_speed_avg=?, hbas=?, multipath=?, iscsi_names=?, aliases=?, conn_state=?, power_state=?, moRef=?, last_scan_time=?, last_update_time=? where id=?";
    static final String TableName = "vhost";
    static Logger _Logger = LogManager.getLogger((String)"fms.db");
    private VirtualCenterImpl _vc;
    private HostClusterImpl _cluster;
    private final HostSystem _base;
    private ConcurrentHashMap<NameKey, VmImpl> _vmByNameKey = new ConcurrentHashMap();
    private ConcurrentHashMap<NameKey, PhyNicImpl> _phynicByNameKey = new ConcurrentHashMap();
    private List<LanHostImpl> _lanHosts = null;
    static final String[] LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};

    public VHostImpl(long[] nwwns, long[] pwwns, String ostype, String vendor, String model, String version, long memorySize, short cpuCount, long cpuSpeedAvg, String hostName, String hostFullName, int powerState, int connState, ArrayList<String> macAddresses, ArrayList<String> ipAddresses, String moRef, VirtualCenterImpl vc) {
        this._base = new HostSystem(nwwns, pwwns, ostype, vendor, model, version, memorySize, cpuCount, cpuSpeedAvg, hostName, hostFullName, powerState, connState, macAddresses, ipAddresses, moRef, vc.getIpAddress());
        this._vc = vc;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    public VirtualCenterImpl getVirtualCenter() {
        return this._vc;
    }

    public void setVirtualCenter(VirtualCenterImpl vc) {
        this._base.setVCPK(vc.getIpAddress());
        this._vc = vc;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
        }
        return wasPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = con.prepareStatement(QuerySQLByMoRef);
            ResultSet rs = null;
            try {
                stat.setString(1, this.getMoRef());
                stat.setLong(2, ((VcenterPK)this._vc.getVcPK())._vid);
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByMoRef;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setLong(2, this._vc.getDBID());
        stat.setString(3, this.getHostName());
        stat.setString(4, this.getHostFullName());
        stat.setString(5, this._base.getMacAddressesAsString());
        stat.setString(6, this._base.getIpAddressesAsString());
        stat.setString(7, this._base.getOsType());
        stat.setString(8, this._base.getVendor());
        stat.setString(9, this._base.getModel());
        stat.setString(10, this._base.getVersion());
        stat.setLong(11, this._cluster == null ? -1L : this._cluster.getDBID());
        stat.setLong(12, this._base.getMemorySize());
        stat.setInt(13, this._base.getCpuCount());
        stat.setLong(14, this._base.getCpuSpeedAvg());
        stat.setString(15, this._base.getHbasAsString());
        stat.setString(16, this._base.getMultiPath());
        stat.setString(17, this._base.getIscsiNamesAsString());
        stat.setString(18, this._base.getAliasesAsString());
        stat.setInt(19, this._base.getConnState());
        stat.setInt(20, this._base.getPowerState());
        stat.setString(21, this._base.getMoRef());
        stat.setLong(22, this._base.getLastScanTime());
        stat.setTimestamp(23, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._vc.getDBID());
        stat.setString(2, this.getHostName());
        stat.setString(3, this.getHostFullName());
        stat.setString(4, this._base.getMacAddressesAsString());
        stat.setString(5, this._base.getIpAddressesAsString());
        stat.setString(6, this._base.getOsType());
        stat.setString(7, this._base.getVendor());
        stat.setString(8, this._base.getModel());
        stat.setString(9, this._base.getVersion());
        stat.setLong(10, this._cluster == null ? -1L : this._cluster.getDBID());
        stat.setLong(11, this._base.getMemorySize());
        stat.setInt(12, this._base.getCpuCount());
        stat.setLong(13, this._base.getCpuSpeedAvg());
        stat.setString(14, this._base.getHbasAsString());
        stat.setString(15, this._base.getMultiPath());
        stat.setString(16, this._base.getIscsiNamesAsString());
        stat.setString(17, this._base.getAliasesAsString());
        stat.setInt(18, this._base.getConnState());
        stat.setInt(19, this._base.getPowerState());
        stat.setString(20, this._base.getMoRef());
        stat.setLong(21, this._base.getLastScanTime());
        stat.setTimestamp(22, new Timestamp(System.currentTimeMillis()));
        stat.setLong(23, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this.getMoRef());
        stat.setLong(2, ((VcenterPK)this._vc.getVcPK())._vid);
    }

    public String getVendor() {
        return this._base.getVendor();
    }

    public void setVendor(String vendor) {
        this._base.setVendor(vendor);
    }

    public long getMemorySize() {
        return this._base.getMemorySize();
    }

    public void setMemorySize(long memorySize) {
        this._base.setMemorySize(memorySize);
    }

    public short getCpuCount() {
        return this._base.getCpuCount();
    }

    public void setCpuCount(short cpuCount) {
        this._base.setCpuCount(cpuCount);
    }

    public long getCpuSpeedAvg() {
        return this._base.getCpuSpeedAvg();
    }

    public void setCpuSpeedAvg(long cpuSpeedAvg) {
        this._base.setCpuSpeedAvg(cpuSpeedAvg);
    }

    public String getHostName() {
        return this._base.getHostName();
    }

    public void setHostName(String hostName) {
        this._base.setHostName(hostName);
    }

    public String getHostFullName() {
        return this._base.getHostFullName();
    }

    public void setHostFullName(String hostName) {
        this._base.setHostFullName(hostName);
    }

    public String getMoRef() {
        return this._base.getMoRef();
    }

    public void setMoRef(String moRef) {
        this._base.setMoRef(moRef);
    }

    public int getDcId() {
        return this._base.getDcId();
    }

    public void setDcId(int dcId) {
        this._base.setDcId(dcId);
    }

    public ComputeResource getRes() {
        return this._base.getRes();
    }

    public void setRes(ComputeResource res) {
        this._base.setRes(res);
    }

    public int getResId() {
        return this._base.getResId();
    }

    public void setResId(int resId) {
        this._base.setResId(resId);
    }

    public long[] getNwwns() {
        return this._base.getNwwns();
    }

    public String getNodeWwnsAsString() {
        return this._base.getNodeWwnsAsString();
    }

    public void setNwwns(long[] nwwns) {
        this._base.setNwwns(nwwns);
    }

    public long[] getPwwns() {
        return this._base.getPwwns();
    }

    public void setPwwns(long[] pwwns) {
        this._base.setPwwns(pwwns);
    }

    public String getOsType() {
        return this._base.getOsType();
    }

    public void setOsType(String ostype) {
        this._base.setOsType(ostype);
    }

    public String getClusterName() {
        return this._base.getClusterName();
    }

    public InetAddress getVCPK() {
        return this._base.getVCPK();
    }

    public String getMultiPath() {
        return this._base.getMultiPath();
    }

    public void setMultiPath(String multiPath) {
        this._base.setMultiPath(multiPath);
    }

    public ArrayList<String> getIpAddresses() {
        return this._base.getIpAddresses();
    }

    public void setIpAddresses(ArrayList<String> ipAddresses) {
        this._base.setIpAddresses(ipAddresses);
    }

    public String getIpAddressesAsString() {
        return this._base.getIpAddressesAsString();
    }

    public ArrayList<String> getMacAddresses() {
        return this._base.getMacAddresses();
    }

    public void setMacAddresses(ArrayList<String> macAddresses) {
        this._base.setMacAddresses(macAddresses);
    }

    public String getMacAddressesAsString() {
        return this._base.getMacAddressesAsString();
    }

    public ArrayList<Wwn> getHbas() {
        return this._base.getHbas();
    }

    public String getHbasAsString() {
        return this._base.getHbasAsString();
    }

    public boolean hasVm(NameKey vmPK) {
        return this._base.hasVm(vmPK);
    }

    public String getVersion() {
        return this._base.getVersion();
    }

    public void setVersion(String version) {
        this._base.setVersion(version);
    }

    public int getConnState() {
        return this._base.getConnState();
    }

    public void setConnState(int connState) {
        this._base.setConnState(connState);
    }

    public int getPowerState() {
        return this._base.getPowerState();
    }

    public void setPowerState(int powerState) {
        this._base.setPowerState(powerState);
    }

    public String getModel() {
        return this._base.getModel();
    }

    public void setModel(String model) {
        this._base.setModel(model);
    }

    public void setVmPKs(List<NameKey> vms) {
        this._base.setVms(vms);
    }

    public List<NameKey> getVmPKs() {
        return this._base.getVmPKs();
    }

    public List<String> getIscsiNames() {
        return this._base.getIscsiNames();
    }

    public String getIscsiNamesAsString() {
        return this._base.getIscsiNamesAsString();
    }

    public void setIscsiNames(List<String> names) {
        this._base.setIscsiNames(names);
    }

    public void removeVm(NameKey vmPK) {
        ArrayList<NameKey> oldVmPKs = new ArrayList<NameKey>(this._base.getVmPKs());
        if (this._base.removeVm(vmPK)) {
            this.propertyChanged((short)3850, oldVmPKs, (Serializable)((Object)this._base.getVmPKs()));
        }
        this._vmByNameKey.remove(vmPK);
    }

    public boolean hasVms() {
        return this._vmByNameKey.values() != null && this._vmByNameKey.values().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VHostImpl getVhostByFullName(VirtualCenterImpl vc, String fullName) {
        VHostImpl id2;
        VHostImpl result = null;
        PreparedStatement stat = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByFullName);
            stat.setString(1, fullName);
            stat.setLong(2, vc.getDBID());
            rs = stat.executeQuery();
            if (rs != null && rs.next()) {
                long id2 = rs.getLong(1);
                String name = rs.getString(2);
                String full_name = rs.getString(3);
                String mac_address = rs.getString(4);
                String ip_address = rs.getString(5);
                long last_scan_time = rs.getLong(6);
                String moRef = rs.getString(7);
                ArrayList<String> macAddresses = new ArrayList<String>();
                macAddresses.add(mac_address);
                ArrayList<String> ipAddresses = new ArrayList<String>();
                ipAddresses.add(ip_address);
                result = new VHostImpl(null, null, null, null, null, null, 0L, 0, 0L, name, full_name, 0, 0, macAddresses, ipAddresses, moRef, vc);
                result._base.setLastScanTime(last_scan_time);
                result._base.setId(id2);
            }
            id2 = result;
            DbUtil.close(rs);
        }
        catch (SQLException e) {
            _Logger.error((Object)"getVhostByFullName failed", (Throwable)e);
            VHostImpl vHostImpl = result;
            return vHostImpl;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return id2;
    }

    public static VHostImpl getVhostById(long id) {
        VHostImpl vhost = null;
        VHostImpl[] hosts = ViManager.getInstance().getHosts();
        if (hosts != null) {
            for (VHostImpl v : hosts) {
                if (v.getDBID() != id) continue;
                vhost = v;
                break;
            }
        }
        return vhost;
    }

    public List<LanHostImpl> getLanHosts() {
        return this._lanHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmImpl createVm(String name, String fullName, String moRef, long memorySize, int cpuCount, long hostId, String ostype, String ipaddr, int powerState) {
        ConcurrentHashMap<NameKey, VmImpl> concurrentHashMap = this._vmByNameKey;
        synchronized (concurrentHashMap) {
            VmImpl vm = this.findVmByName(moRef);
            if (vm == null) {
                vm = new VmImpl(name, fullName, moRef, memorySize, cpuCount, hostId, ostype, ipaddr, powerState);
                vm.setVhost(this);
                this._vmByNameKey.put(new NameKey(moRef), vm);
                this._base.addVm(new NameKey(moRef));
            }
            return vm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVm(VmImpl vm) {
        ConcurrentHashMap<NameKey, VmImpl> concurrentHashMap = this._vmByNameKey;
        synchronized (concurrentHashMap) {
            VmImpl oldvm = this.findVmByName(vm.getMoRef());
            if (oldvm == null) {
                this._vmByNameKey.put(new NameKey(vm.getMoRef()), vm);
                this._base.addVm(new NameKey(vm.getMoRef()));
            }
        }
    }

    public List<VmImpl> getVms() {
        VmImpl[] vms = this._vmByNameKey.values().toArray(new VmImpl[this._vmByNameKey.size()]);
        ArrayList<VmImpl> vmList = new ArrayList<VmImpl>();
        for (int i = 0; vms != null && i < vms.length; ++i) {
            vmList.add(vms[i]);
        }
        return vmList;
    }

    public VmImpl findVmByPK(NameKey pkey) {
        return pkey == null ? null : this._vmByNameKey.get(pkey);
    }

    public VmImpl findVmByName(String name) {
        return this.findVmByPK(new NameKey(name));
    }

    public VmImpl findAllVm(NameKey pkey) {
        return pkey == null ? null : this._vmByNameKey.get(pkey);
    }

    public VmImpl updateVm(String vmName, String fullName, String moRef, long memorySize, int cpuCount, long hostId, String ostype, String ipaddr, int powerState) throws Exception {
        VmImpl vm = this.findVmByPK(new NameKey(moRef));
        if (vm == null) {
            throw new Exception("vm " + moRef + " not found");
        }
        vm.setMemorySize(memorySize);
        vm.setCpuCount(cpuCount);
        vm.setHostId(hostId);
        vm.setOstype(ostype);
        vm.setIpAddress(ipaddr);
        vm.setPowerState(powerState);
        vm.setName(vmName);
        vm.setFullName(fullName);
        vm.setVhost(this);
        return vm;
    }

    public void removeEnclosure(NameKey encPK) throws Exception {
        VmImpl enc = this.findVmByPK(encPK);
        if (enc == null) {
            throw new Exception("enclosure " + encPK._name + " not found");
        }
        this._vmByNameKey.remove(encPK);
    }

    public HostClusterImpl getCluster() {
        return this._cluster;
    }

    public void setCluster(HostClusterImpl cluster) {
        this._cluster = cluster;
        this._base.setClusterName(cluster == null ? null : cluster.getClusterName());
    }

    public ArrayList<String> getAliases() {
        return this._base.getAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NameKey> getAllVmPKs() {
        ConcurrentHashMap<NameKey, VmImpl> concurrentHashMap = this._vmByNameKey;
        synchronized (concurrentHashMap) {
            return new HashSet<NameKey>(this._vmByNameKey.keySet());
        }
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(VirtualCenterImpl.LIL[level]).append("vHost: ").append(this.getMoRef()).append(VirtualCenterImpl.LIL[level]).append("Host Name: ").append(this.getHostName()).append(VirtualCenterImpl.LIL[level + 1]).append("IP Addresses: ").append(this.getIpAddressesAsString()).append(VirtualCenterImpl.LIL[level + 1]).append("Mac Addresses: ").append(this.getMacAddressesAsString()).append(VirtualCenterImpl.LIL[level + 1]).append("Node wwns: ").append(this.getNodeWwnsAsString()).append(VirtualCenterImpl.LIL[level + 1]).append("HBAs: ").append(this.getHbasAsString()).append(VirtualCenterImpl.LIL[level + 1]).append("MultiPath: ").append(this.getMultiPath()).append(VirtualCenterImpl.LIL[level + 1]).append("Connection State: ").append(this.getConnState()).append(VirtualCenterImpl.LIL[level + 1]).append("Power State: ").append(this.getPowerState()).append(VirtualCenterImpl.LIL[level + 1]).append("OS Type: ");
        if (this.getOsType() == null) {
            sb.append("n/a");
        } else {
            sb.append(this.getOsType());
        }
        sb.append(VirtualCenterImpl.LIL[level + 1]).append("Vendor: ");
        if (this.getVendor() == null) {
            sb.append("n/a");
        } else {
            sb.append(this.getVendor());
        }
        sb.append(VirtualCenterImpl.LIL[level + 1]).append("Model: ");
        if (this.getModel() == null) {
            sb.append("n/a");
        } else {
            sb.append(this.getModel());
        }
        sb.append(VirtualCenterImpl.LIL[level + 1]).append("Version: ");
        if (this.getVersion() == null) {
            sb.append("n/a");
        } else {
            sb.append(this.getVersion());
        }
        sb.append(VirtualCenterImpl.LIL[level + 1]).append("Aliases: ");
        ArrayList<String> aliases = this.getAliases();
        if (aliases == null || aliases.size() == 0) {
            sb.append("n/a");
        } else {
            for (String alias : aliases) {
                if (alias == null) continue;
                sb.append(alias).append(",");
            }
        }
        sb.append(VirtualCenterImpl.LIL[level + 1]).append("Memory Size: ").append(this.getMemorySize()).append(VirtualCenterImpl.LIL[level + 1]).append("CPU Count: ").append(this.getCpuCount()).append(VirtualCenterImpl.LIL[level + 1]).append("CPU Speed Avg: ").append(this.getCpuSpeedAvg()).append(VirtualCenterImpl.LIL[level + 1]).append("Last Scan Time: ").append(new Date(this.getLastScanTime())).append(this.dumpVms(level + 1));
        return sb.toString();
    }

    public String dumpVms(int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(VirtualCenterImpl.LIL[level]).append("Num of Virtual Machines: ").append(this.getVms().size());
        List<VmImpl> vms = this.getVms();
        if (vms.size() == 0) {
            sb.append("n/a");
        } else {
            for (VmImpl vm : vms) {
                sb.append(vm.dump(level));
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<NameKey> purgeVms() {
        ConcurrentHashMap<NameKey, VmImpl> concurrentHashMap = this._vmByNameKey;
        synchronized (concurrentHashMap) {
            this._vmByNameKey.clear();
        }
        return this._vmByNameKey.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPhyNics(PhyNic[] pnics) {
        ConcurrentHashMap<NameKey, PhyNicImpl> concurrentHashMap = this._phynicByNameKey;
        synchronized (concurrentHashMap) {
            ArrayList prepnics = new ArrayList(this._phynicByNameKey.keySet());
            for (int i = 0; pnics != null && i < pnics.length; ++i) {
                PhyNicImpl pnicImpl = this.findPhynicByName(pnics[i].getKey());
                if (pnicImpl == null) {
                    pnicImpl = new PhyNicImpl(pnics[i]);
                } else {
                    pnicImpl.setDevice(pnics[i].getDevice());
                    pnicImpl.setMac(pnics[i].getMac());
                }
                pnicImpl.setVhost(this);
                this._phynicByNameKey.put(new NameKey(pnics[i].getKey()), pnicImpl);
                prepnics.remove(new NameKey(pnics[i].getKey()));
            }
            for (NameKey prepnic : prepnics) {
                this._phynicByNameKey.remove(prepnic);
            }
            this._base.setPnic(pnics);
        }
    }

    public PhyNicImpl findPhynicByPK(NameKey pkey) {
        return pkey == null ? null : this._phynicByNameKey.get(pkey);
    }

    public PhyNicImpl findPhynicByName(String name) {
        return this.findPhynicByPK(new NameKey(name));
    }

    public PhyNicImpl[] getPhyNics() {
        return this._phynicByNameKey.values().toArray(new PhyNicImpl[this._phynicByNameKey.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean findVHostByIp(String ip) {
        boolean result = false;
        PreparedStatement stat = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByIp);
            stat.setString(1, ip);
            rs = stat.executeQuery();
            if (rs != null && rs.next()) {
                result = true;
            }
            DbUtil.close(rs);
        }
        catch (SQLException e) {
            _Logger.error((Object)"findVHostByIpOrMac failed", (Throwable)e);
            boolean bl = result;
            return bl;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLanHosts(HostNetworkSystem hns) {
        if (hns == null) {
            return;
        }
        HostNetworkInfo hninfo = hns.getNetworkInfo();
        if (hninfo == null) {
            return;
        }
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            PhysicalNic[] pnics = hninfo.getPnic();
            this._lanHosts = new ArrayList<LanHostImpl>();
            HashMap<String, LanHostImpl> macs = new HashMap<String, LanHostImpl>();
            for (int i = 0; i < pnics.length; ++i) {
                try {
                    String[] device = new String[]{pnics[i].device};
                    PhysicalNicHintInfo[] nicHintInfos = hns.queryNetworkHint(device);
                    if (nicHintInfos == null) continue;
                    for (int j = 0; j < nicHintInfos.length; ++j) {
                        StringTokenizer tokenizer;
                        EthSwitchImpl sw;
                        String name;
                        if (nicHintInfos[j].connectedSwitchPort == null || (name = pnics[i].mac) == null) continue;
                        String mac = name.toUpperCase();
                        String ip = nicHintInfos[j].connectedSwitchPort.mgmtAddr;
                        if (ip == null || ip.equals("0.0.0.0")) continue;
                        String portId = nicHintInfos[j].connectedSwitchPort.portId;
                        PhysicalNicIpHint[] ipHints = nicHintInfos[j].subnet;
                        int vlanId = 0;
                        if (ipHints != null && ipHints.length > 0) {
                            vlanId = ipHints[0].vlanId;
                        }
                        if ((sw = DCManager.getInstance().findEthSwitchBySwIp(InetAddress.getByName(ip))) == null) continue;
                        long swId = LanHostImpl.getSwitchIdFromIfName(con, sw, portId);
                        HostImpl host = HostImpl.getHostByVHostId(con, this.getDBID());
                        if (swId <= 0L || host == null) continue;
                        if (portId.startsWith("Eth") && (tokenizer = new StringTokenizer(portId, "/")).hasMoreElements()) {
                            String temp = null;
                            if (portId.startsWith("Ethernet")) {
                                temp = ((String)tokenizer.nextElement()).substring("Ethernet".length());
                            } else if (portId.startsWith("Eth")) {
                                temp = ((String)tokenizer.nextElement()).substring("Eth".length());
                            }
                            if (temp != null && !temp.equals("")) {
                                int fexId = -1;
                                try {
                                    fexId = Integer.parseInt(temp);
                                }
                                catch (Exception e) {
                                    _Logger.debug((Object)("ifname='" + portId + "', switch='" + sw.getIpAddress() + "'." + e.getMessage()));
                                }
                                _Logger.debug((Object)("fexID: " + fexId));
                                if (fexId >= 100) {
                                    ResultSet rs;
                                    PreparedStatement queryStat;
                                    block32: {
                                        queryStat = null;
                                        rs = null;
                                        try {
                                            queryStat = con.prepareStatement("select fs.id, fs.sys_name from ethswitch s, ethswitch fs, ethswitch_fex f where s.id=? and f.switch_id=s.id and fs.id=f.fex_id and fs.fex_id=?");
                                            queryStat.setLong(1, sw.getDBID());
                                            queryStat.setInt(2, fexId);
                                            rs = queryStat.executeQuery();
                                            if (rs != null) {
                                                while (rs.next()) {
                                                    swId = rs.getLong(1);
                                                    String ethSwName = rs.getString(2);
                                                    _Logger.debug((Object)("fex switch name: " + ethSwName));
                                                }
                                                break block32;
                                            }
                                            _Logger.debug((Object)("Cannot find fex switch with fexID=" + fexId + " for switch '" + sw.getName() + "'"));
                                        }
                                        catch (SQLException e) {
                                            try {
                                                _Logger.info((Object)("Query FEX switch ID and name failed." + e.getMessage()));
                                            }
                                            catch (Throwable throwable) {
                                                DbUtil.close(rs);
                                                DbUtil.close(queryStat);
                                                throw throwable;
                                            }
                                            DbUtil.close(rs);
                                            DbUtil.close(queryStat);
                                        }
                                    }
                                    DbUtil.close(rs);
                                    DbUtil.close(queryStat);
                                }
                            }
                        }
                        LanHostImpl e = new LanHostImpl(name, "", mac, swId, portId, ip, vlanId, this.getDBID());
                        e.setHostId(host.getDBID());
                        this._lanHosts.add(e);
                        String key = name + "-" + swId + "-" + portId + "-" + vlanId;
                        macs.put(key, e);
                    }
                    continue;
                }
                catch (Exception e) {
                    _Logger.debug((Object)("get vhost.connectedSwitchPort failed: " + e.getMessage()));
                }
            }
            List<LanHostImpl> existingLanHosts = LanHostImpl.getLanHostsByVhostId(con, this.getDBID());
            if (existingLanHosts != null) {
                for (LanHostImpl l : existingLanHosts) {
                    String key = l.getName() + "-" + l.getEthSwitchId() + "-" + l.getEthIfName() + "-" + l.getVlan();
                    LanHostImpl e = (LanHostImpl)macs.get(key);
                    if (e == null) continue;
                    e.setDBID(l.getDBID());
                }
            }
            if (this._lanHosts != null && !this._lanHosts.isEmpty()) {
                LanHostImpl.persistLanHosts(con, this._lanHosts);
                _Logger.info((Object)("persisted vhost.connectedSwitchPort: " + this._lanHosts.size()));
            }
        }
        catch (Exception e) {
            _Logger.error((Object)("createLanHosts: failed to persist. " + e.getMessage()));
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            DbUtil.close(con);
        }
    }
}

