/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.CfsStaticPeerDto;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.dto.TrafficMapElement;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NPVhelper {
    static Logger _Logger = LogManager.getLogger((String)"fms.npv");
    static final int[] _CnpvTrafficMapToIfIndexListOid = MibNode.get("cnpvTrafficMapToIfIndexList").getOid();
    static final int[] _CnpvTrafficMapLastChangeOid = MibNode.get("cnpvTrafficMapLastChange").getOid();
    static final int[] _CnpvTrafficAutoLoadBalanceOid = MibNode.get("cnpvTrafficAutoLoadbalance").getOid();
    static final int[] _cfsStatPeerAddrType = MibNode.get("cfsStatPeerAddrType").getOid();
    static final int[] _cfsStatPeerAddr = MibNode.get("cfsStatPeerAddr").getOid();
    static final int[] _cfsStatPeerDiscStatus = MibNode.get("cfsStatPeerDiscStatus").getOid();
    static final int[] _cnpvTrafficToIfIndex = MibNode.get("cnpvTrafficToIfIndex").getOid();
    static VarBindList _TrafficMapVbl = new VarBindList(2);
    static VarBindList _ServerToExternalInterfaceMapVbl;
    static VarBindList _CfsStaticPeerVbl;

    public static List<TrafficMap> getTrafficMap(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts) throws SnmpException {
        ArrayList<TrafficMap> trafficEngMap = new ArrayList<TrafficMap>();
        for (int i = 0; i < switches.size(); ++i) {
            SwitchBase sw = switches.get(i);
            SnmpUserOpt nextCred = snmpUserOpts.get(i);
            SnmpPeer peer = NPVhelper.generatePeer(sw, nextCred);
            TrafficMap nextMap = NPVhelper.getTrafficMap(peer, sw);
            trafficEngMap.add(nextMap);
        }
        return trafficEngMap;
    }

    public static TrafficMap getTrafficMap(SnmpPeer peer, SwitchBase sw) throws SnmpException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch((WwnKey)sw.getSwitchPK(), sw.getFabricPK());
        VarBindList resp = SnmpFetch.getBulk(peer, _TrafficMapVbl).getVariables();
        Map<Integer, TrafficMapElement> mapElements = NPVhelper.parseTrafficMapElements(swImpl, resp, _TrafficMapVbl.size());
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addNull(new SnmpOID(_CnpvTrafficAutoLoadBalanceOid, 0));
        VarBindList resp2 = peer.send(pdu).getVariables();
        boolean trafficAutoLoadBalanceEnabled = resp2.intValue(0) == 1;
        return new TrafficMap(sw, mapElements, trafficAutoLoadBalanceEnabled);
    }

    public static Map<Integer, TrafficMapElement> parseTrafficMapElements(SwitchImpl swImpl, VarBindList resp, int elementCount) {
        HashMap<Integer, TrafficMapElement> results = new HashMap<Integer, TrafficMapElement>();
        for (int i = 0; i < resp.size(); i += elementCount) {
            int[] oid = resp.getVb(i).getOid().getValue();
            int srvIfIndex = oid[oid.length - 1];
            byte[] extIfIndexList = resp.byteValue(i);
            long lastChangedTime = resp.longValue(i + 1);
            ArrayList<Integer> extBaseList = new ArrayList<Integer>();
            int size = extIfIndexList.length;
            for (int j = 0; j < size; j += 4) {
                int extIfIndex = ((extIfIndexList[j] & 0xFF) << 24) + ((extIfIndexList[j + 1] & 0xFF) << 16) + ((extIfIndexList[j + 2] & 0xFF) << 8) + (extIfIndexList[j + 3] & 0xFF);
                extBaseList.add(extIfIndex);
            }
            TrafficMapElement nextElem = new TrafficMapElement(srvIfIndex, extBaseList, lastChangedTime);
            results.put(srvIfIndex, nextElem);
        }
        return results;
    }

    public static Map<SwitchBase, Map> getCnpvServerIfTable(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts) throws SnmpException {
        HashMap<SwitchBase, Map> switchCnpvServerIfTableMap = new HashMap<SwitchBase, Map>();
        for (int i = 0; i < switches.size(); ++i) {
            SwitchBase sw = switches.get(i);
            SnmpUserOpt nextCred = snmpUserOpts.get(i);
            SnmpPeer peer = NPVhelper.generatePeer(sw, nextCred);
            try {
                Map<Integer, Integer> nextMap = NPVhelper.getCnpvServerIfTable(peer, sw);
                switchCnpvServerIfTableMap.put(sw, nextMap);
                continue;
            }
            catch (SnmpException se) {
                switchCnpvServerIfTableMap.put(sw, new HashMap());
            }
        }
        return switchCnpvServerIfTableMap;
    }

    public static Map<Integer, Integer> getCnpvServerIfTable(SnmpPeer peer, SwitchBase sw) throws SnmpException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch((WwnKey)sw.getSwitchPK(), sw.getFabricPK());
        VarBindList resp = SnmpFetch.getBulk(peer, _ServerToExternalInterfaceMapVbl).getVariables();
        Map<Integer, Integer> mapElements = NPVhelper.parseCnpvServerIfTable(swImpl, resp);
        return mapElements;
    }

    public static Map<Integer, Integer> parseCnpvServerIfTable(SwitchImpl swImpl, VarBindList resp) {
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        for (int i = 0; i < resp.size(); i += _ServerToExternalInterfaceMapVbl.size()) {
            int[] oid = resp.getVb(i).getOid().getValue();
            int srvIfIndex = oid[oid.length - 1];
            int extIfIndex = resp.intValue(i);
            results.put(srvIfIndex, extIfIndex);
        }
        return results;
    }

    public static List<CfsStaticPeerDto> getCFSStaticPeerList(SwitchBase sw, SnmpUserOpt cred) throws SnmpException {
        SnmpPeer peer = NPVhelper.generatePeer(sw, cred);
        return NPVhelper.getCFSStaticPeerList(peer);
    }

    public static List<CfsStaticPeerDto> getCFSStaticPeerList(SnmpPeer peer) throws SnmpException {
        VarBindList resp = SnmpFetch.getBulk(peer, _CfsStaticPeerVbl).getVariables();
        return NPVhelper.parseCfsStaticPeerElements(resp, _CfsStaticPeerVbl.size());
    }

    public static List<CfsStaticPeerDto> parseCfsStaticPeerElements(VarBindList resp, int elementCount) {
        ArrayList<CfsStaticPeerDto> results = new ArrayList<CfsStaticPeerDto>();
        for (int i = 0; i < resp.size(); i += elementCount) {
            int[] respOID = resp.getVb(i).getOid().getValue();
            int indexOffset = _CfsStaticPeerVbl.get(0).getOid().getValue().length;
            int addrType = respOID[indexOffset++];
            int length = respOID[indexOffset++];
            byte[] addr = new byte[length];
            int addrIndex = 0;
            while (addrIndex < length) {
                addr[addrIndex++] = (byte)respOID[indexOffset++];
            }
            InetAddress inetAddr = null;
            try {
                inetAddr = SnmpInetAddress.getInetAddressFrom(addrType, addr);
            }
            catch (UnknownHostException uhe) {
                _Logger.error((Object)("error constructing the Inet address from addr - " + addr + " and type - " + addrType + " from mib :" + uhe));
            }
            int status = resp.intValue(i);
            CfsStaticPeerDto nextElem = new CfsStaticPeerDto(inetAddr, addrType, addr, status);
            results.add(nextElem);
        }
        return results;
    }

    public static byte[] generateExternalIfIndexList(List<Integer> ifIndexList) {
        int size = ifIndexList.size() * 4;
        byte[] result = new byte[size];
        int indexPointer = 0;
        for (int i = 0; i < ifIndexList.size(); ++i) {
            int nextIfIndex = ifIndexList.get(i);
            result[indexPointer++] = (byte)(nextIfIndex >> 24 & 0xFF);
            result[indexPointer++] = (byte)(nextIfIndex >> 16 & 0xFF);
            result[indexPointer++] = (byte)(nextIfIndex >> 8 & 0xFF);
            result[indexPointer++] = (byte)(nextIfIndex & 0xFF);
        }
        return result;
    }

    public static SnmpPeer generatePeer(SwitchBase sw, SnmpUserOpt snmpUserOpt) throws SnmpException {
        if (sw == null) {
            throw new IllegalArgumentException("Switch can not be null");
        }
        return SnmpPeer.getSnmpPeer(sw.getInetAddress(), SnmpSession.getInstance(), snmpUserOpt);
    }

    static {
        _TrafficMapVbl.add(_CnpvTrafficMapToIfIndexListOid);
        _TrafficMapVbl.add(_CnpvTrafficMapLastChangeOid);
        _ServerToExternalInterfaceMapVbl = new VarBindList(1);
        _ServerToExternalInterfaceMapVbl.add(_cnpvTrafficToIfIndex);
        _CfsStaticPeerVbl = new VarBindList(3);
        _CfsStaticPeerVbl.add(_cfsStatPeerDiscStatus);
    }
}

