/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.sm.common.dto.CfsStaticPeerDto;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.server.npv.CFSStatisPeerListRunnable;
import com.cisco.dcbu.sm.server.npv.CopyRSRunnable;
import com.cisco.dcbu.sm.server.npv.FlexAttachRunnable;
import com.cisco.dcbu.sm.server.npv.Job;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import com.cisco.dcbu.sm.server.npv.NpvSetFeatureRunnable;
import com.cisco.dcbu.sm.server.npv.NpvSetPortModeRunnable;
import com.cisco.dcbu.sm.server.npv.NpvSetVsanRunnable;
import com.cisco.dcbu.sm.server.npv.PortJob;
import com.cisco.dcbu.sm.server.npv.PortVsanJob;
import com.cisco.dcbu.sm.server.npv.SwitchAuthenticate;
import com.cisco.dcbu.sm.server.npv.SwitchJob;
import com.cisco.dcbu.sm.server.npv.SwitchVsanJob;
import com.cisco.dcbu.sm.server.npv.TrafficEngineerRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class NpvManager {
    static Logger _Logger = LogManager.getLogger((String)"fms.npv");
    private static NpvManager _Instance;
    private long _requestId = 1L;
    private PooledThreadExecutor _switchPool;
    private ConcurrentLinkedQueue<Job> _jobQueue;
    private Thread _jobThread;
    private boolean _started = false;
    private HashMap<Object, CommunicationObjectSender> channelOrQueueMap = new HashMap();

    public static NpvManager getInstance() {
        if (_Instance == null) {
            _Instance = new NpvManager();
        }
        return _Instance;
    }

    private NpvManager() {
        this._switchPool = new PooledThreadExecutor("NPVManager", 3, 100, 30000L);
        this._jobQueue = new ConcurrentLinkedQueue();
        this._jobThread = new Thread("Npv Job Thread"){

            @Override
            public void run() {
                block13: while (NpvManager.this._started) {
                    Job nextJob = (Job)NpvManager.this._jobQueue.poll();
                    if (nextJob != null) {
                        if (_Logger.isDebugEnabled()) {
                            _Logger.debug((Object)("pulled new job from queue: job - " + nextJob));
                            _Logger.debug((Object)("Is queue empty now? - " + NpvManager.this._jobQueue.isEmpty()));
                            _Logger.debug((Object)("Threadpool stats: current number active threads - " + NpvManager.this._switchPool.getPoolSize()));
                        }
                        int jobType = nextJob.getJobType();
                        switch (jobType) {
                            case 1: 
                            case 2: {
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    NpvSetFeatureRunnable jobRunnable = new NpvSetFeatureRunnable(jobType, jobRequestId, nextSwitch, snmpCred, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 3: 
                            case 4: 
                            case 5: 
                            case 9: {
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((PortJob)nextJob).getSwitchObjects();
                                List<List<FcPortBase>> ports = ((PortJob)nextJob).getJobPortObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((PortJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    List<FcPortBase> swports = ports.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    NpvSetPortModeRunnable jobRunnable = new NpvSetPortModeRunnable(jobType, jobRequestId, nextSwitch, swports, snmpCred, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 7: {
                                NpvRunnable jobRunnable;
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((PortVsanJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((PortVsanJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((PortVsanJob)nextJob).getSender();
                                Integer vsan = ((PortVsanJob)nextJob).getVsan();
                                List<List<FcPortBase>> ports = ((PortVsanJob)nextJob).getJobPortObjects();
                                VsanBase vsanBase = ((PortVsanJob)nextJob).getVsanBase();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    List<FcPortBase> swports = ports.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    jobRunnable = new NpvSetVsanRunnable(jobType, jobRequestId, nextSwitch, swports, snmpCred, vsan, vsanBase, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 6: {
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchVsanJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchVsanJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchVsanJob)nextJob).getSender();
                                Integer vsan = ((SwitchVsanJob)nextJob).getVsan();
                                VsanBase vsanBase = ((SwitchVsanJob)nextJob).getVsanBase();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    NpvSetVsanRunnable jobRunnable = new NpvSetVsanRunnable(jobType, jobRequestId, nextSwitch, null, snmpCred, vsan, vsanBase, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 8: {
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    SwitchAuthenticate jobRunnable = new SwitchAuthenticate(jobRequestId, nextSwitch, snmpCred, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 10: {
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    CopyRSRunnable jobRunnable = new CopyRSRunnable(jobRequestId, nextSwitch, snmpCred, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 11: {
                                NpvRunnable jobRunnable;
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                Integer mode = (Integer)((SwitchJob)nextJob).getExtraData();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    jobRunnable = new FlexAttachRunnable(jobRequestId, nextSwitch, snmpCred, mode, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 12: {
                                NpvRunnable jobRunnable;
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                List maps = (List)((SwitchJob)nextJob).getExtraData();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    TrafficMap map = (TrafficMap)maps.get(i);
                                    jobRunnable = new TrafficEngineerRunnable(jobRequestId, nextSwitch, snmpCred, map, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                continue block13;
                            }
                            case 13: {
                                NpvRunnable jobRunnable;
                                long jobRequestId = nextJob.getRequestId();
                                List<SwitchBase> switches = ((SwitchJob)nextJob).getSwitchObjects();
                                List<SnmpUserOpt> snmpUserOpts = ((SwitchJob)nextJob).getSnnpCreds();
                                CommunicationObjectSender sender = ((SwitchJob)nextJob).getSender();
                                List cfsPeers = (List)((SwitchJob)nextJob).getExtraData();
                                for (int i = 0; i < switches.size(); ++i) {
                                    SwitchBase nextSwitch = switches.get(i);
                                    SnmpUserOpt snmpCred = snmpUserOpts.get(i);
                                    jobRunnable = new CFSStatisPeerListRunnable(jobRequestId, nextSwitch, snmpCred, cfsPeers, sender);
                                    NpvManager.this._switchPool.execute(jobRunnable);
                                }
                                break;
                            }
                        }
                        continue;
                    }
                    if (_Logger.isTraceEnabled()) {
                        _Logger.trace((Object)"no job on the queue");
                    }
                    try {
                        1.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
    }

    public synchronized void start() {
        this._started = true;
        if (!this._jobThread.isAlive()) {
            this._jobThread.start();
        }
    }

    public synchronized void stop() {
        this._started = false;
        this._jobQueue.clear();
    }

    public synchronized boolean isRunning() {
        return this._jobThread.isAlive();
    }

    private synchronized long getNextRequestId() {
        ++this._requestId;
        return this._requestId;
    }

    public synchronized void destroyPtoPQueue(Object channelOrQueue) {
        CommunicationObjectSender sender = this.channelOrQueueMap.remove(channelOrQueue);
        if (sender != null) {
            sender.stop();
        }
    }

    public synchronized CommunicationObjectSender createCommunicationObject(Object channelOrQueue) throws Exception {
        CommunicationObjectSender sender = this.channelOrQueueMap.get(channelOrQueue);
        if (sender == null) {
            sender = new CommunicationObjectSender(channelOrQueue);
            this.channelOrQueueMap.put(channelOrQueue, sender);
        }
        return sender;
    }

    public long enableNPVFeature(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        SwitchJob job = new SwitchJob(1, requestId, switches, snmpUserOpts);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting enableNPVFeature job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long addSwitchesToVsan(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, int vsan, VsanBase vsanBase, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        SwitchVsanJob job = new SwitchVsanJob(6, requestId, switches, snmpUserOpts, new Integer(vsan), vsanBase);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting addSwitchesToVsan job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long addPortsToVsan(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, int vsan, VsanBase vsanBase, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        PortVsanJob job = new PortVsanJob(7, requestId, switches, snmpUserOpts, ports, new Integer(vsan), vsanBase);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting addPortsToVsan job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long enableNPIVFeature(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("call to enable NPIV Feature on " + switches));
        }
        SwitchJob job = new SwitchJob(2, requestId, switches, snmpUserOpts);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting enable NPIV job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setNPPorts(List<SwitchBase> npvSwitches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        PortJob job = new PortJob(3, requestId, npvSwitches, snmpUserOpts, ports);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setNPPorts job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setFPorts(List<SwitchBase> npvSwitches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        PortJob job = new PortJob(4, requestId, npvSwitches, snmpUserOpts, ports);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setFPorts job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setPortsToAuto(List<SwitchBase> npvSwitches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        PortJob job = new PortJob(5, requestId, npvSwitches, snmpUserOpts, ports);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setPortsToAuto job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setPortsToEnable(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, List<List<FcPortBase>> ports, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        PortJob job = new PortJob(9, requestId, switches, snmpUserOpts, ports);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setPortsEnable job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long authenticateSwitch(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        SwitchJob job = new SwitchJob(8, requestId, switches, snmpUserOpts);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting authenticateSwitch job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long saveRunningConfigOnSwitch(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        SwitchJob job = new SwitchJob(10, requestId, switches, snmpUserOpts);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting save running config job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setFlexAttachWWNMode(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, int mode, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        SwitchJob job = new SwitchJob(11, requestId, switches, snmpUserOpts);
        job.setExtraData(new Integer(mode));
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setFlexAttachWWNMode job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setTrafficMap(List<SwitchBase> switches, List<SnmpUserOpt> snmpUserOpts, List<TrafficMap> maps, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        SwitchJob job = new SwitchJob(12, requestId, switches, snmpUserOpts);
        job.setExtraData(maps);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setTrafficMap job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }

    public long setCFSStaticPeerList(SwitchBase sw, SnmpUserOpt cred, List<CfsStaticPeerDto> peers, Object channelOrQueue) throws Exception {
        long requestId = this.getNextRequestId();
        ArrayList<SwitchBase> sws = new ArrayList<SwitchBase>();
        sws.add(sw);
        ArrayList<SnmpUserOpt> snmpUserOpts = new ArrayList<SnmpUserOpt>();
        snmpUserOpts.add(cred);
        SwitchJob job = new SwitchJob(13, requestId, sws, snmpUserOpts);
        job.setExtraData(peers);
        CommunicationObjectSender sender = this.createCommunicationObject(channelOrQueue);
        job.setSender(sender);
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("putting setCFSStaticPeerList job on queue: job - " + job));
        }
        this._jobQueue.add(job);
        return requestId;
    }
}

