/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NpvSetVsanRunnable
extends NpvRunnable {
    static final int ALREADY_EXISTS = 1;
    static final int NOT_FOUND = 0;
    static final int[] _vsanRowStatusOid = MibNode.get("vsanRowStatus").getOid();
    static final int[] _vsanNameOid = MibNode.get("vsanName").getOid();
    static final int[] _vsanLoadBalancingTypeOid = MibNode.get("vsanLoadBalancingType").getOid();
    static final int[] _vsanInterOperValueOid = MibNode.get("vsanInterOperValue").getOid();
    static final int[] _vsanAdminStateOid = MibNode.get("vsanAdminState").getOid();
    static final int[] _vsanInorderDeliveryOid = MibNode.get("vsanInorderDelivery").getOid();
    static final int[] _vsanIfVsanOid = MibNode.get("vsanIfVsan").getOid();
    static final int[] _fcIfAllowedVsanList2kOid = MibNode.get("fcIfAllowedVsanList2k").getOid();
    static final int[] _fcIfAllowedVsanList4kOid = MibNode.get("fcIfAllowedVsanList4k").getOid();
    private int _jobType;
    private long _requestId;
    private SwitchBase _sw;
    private List<FcPortBase> _ports;
    private SnmpUserOpt _snmpUserOpt;
    private CommunicationObjectSender _sender;
    private int _vsan;
    private VsanBase _vsanBase;
    private SnmpString _vsan2Kmap;
    private SnmpString _vsan4Kmap;
    static Logger _logger = LogManager.getLogger((String)"fms.npv");

    public NpvSetVsanRunnable(int jobType, long requestId, SwitchBase sw, List<FcPortBase> ports, SnmpUserOpt snmpUserOpt, int vsan, VsanBase vbase, CommunicationObjectSender sender) {
        this._jobType = jobType;
        this._requestId = requestId;
        this._sw = sw;
        this._ports = ports;
        this._snmpUserOpt = snmpUserOpt;
        this._vsan = vsan;
        this._vsanBase = vbase;
        this._sender = sender;
    }

    @Override
    public void run() {
        try {
            switch (this._jobType) {
                case 7: {
                    SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
                    QueueResponseObject results = this.addPortsToVsan(peer);
                    this.setVsanAllowList(peer);
                    this.setPortAdminStatus(peer, 2);
                    this.setPortAdminStatus(peer, 1);
                    this._sender.send(results);
                    break;
                }
                case 6: {
                    QueueResponseObject results = this.addSwitchToVsan();
                    this._sender.send(results);
                }
            }
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to Add/Set VSAN for switch:" + this._sw.toString() + " received error: " + se.getMessage()), (Throwable)se);
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    public QueueResponseObject addSwitchToVsan() throws SnmpException {
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        int exists = this.doesVsanExist(peer);
        if (exists == 0) {
            VarBindList varList = new VarBindList();
            varList.add(_vsanRowStatusOid, this._vsan, (SnmpVar)new SnmpInt(4));
            if (this._vsanBase == null) {
                String name = "vsan_" + this._vsan;
                varList.add(_vsanNameOid, this._vsan, (SnmpVar)new SnmpString(name));
                varList.add(_vsanLoadBalancingTypeOid, this._vsan, (SnmpVar)new SnmpInt(2));
                varList.add(_vsanInterOperValueOid, this._vsan, (SnmpVar)new SnmpInt(0));
                varList.add(_vsanAdminStateOid, this._vsan, (SnmpVar)new SnmpInt(1));
                varList.add(_vsanInorderDeliveryOid, this._vsan, (SnmpVar)new SnmpInt(2));
            } else {
                varList.add(_vsanNameOid, this._vsan, (SnmpVar)new SnmpString(this._vsanBase.getName()));
                varList.add(_vsanLoadBalancingTypeOid, this._vsan, (SnmpVar)new SnmpInt(this._vsanBase.getLoadBalancingType()));
                varList.add(_vsanInterOperValueOid, this._vsan, (SnmpVar)new SnmpInt(0));
                varList.add(_vsanAdminStateOid, this._vsan, (SnmpVar)new SnmpInt(this._vsanBase.getAdminState()));
                varList.add(_vsanInorderDeliveryOid, this._vsan, (SnmpVar)new SnmpInt(2));
            }
            SnmpPDU pdu = new SnmpPDU(-93, varList);
            pdu.setIgnoreSetCount(true);
            peer.set(pdu);
            SwitchImpl switchImpl = SanManager.getInstance().findSwitch(this._sw.getWwn(), this._sw.getFabricPK());
            boolean success = SnmpAdapter.discoverVsans(switchImpl);
            if (success) {
                QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
                return result;
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 2, "Unable to rediscover VSANs after successful creation", null);
            return result;
        }
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 6, "Successful", null);
        return result;
    }

    public QueueResponseObject addPortsToVsan(SnmpPeer peer) throws SnmpException {
        VarBindList varList = new VarBindList();
        for (int i = 0; i < this._ports.size(); ++i) {
            FcPortBase nextPort = this._ports.get(i);
            int fcIndex = nextPort.getIfIndex();
            varList.add(_vsanIfVsanOid, fcIndex, (SnmpVar)new SnmpInt(this._vsan));
        }
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
        varList.clear();
        varList = new VarBindList();
        for (int i = 0; i < this._ports.size(); ++i) {
            FcPortBase nextPort = this._ports.get(i);
            int fcIndex = nextPort.getIfIndex();
            varList.add(_vsanIfVsanOid, fcIndex);
        }
        pdu = new SnmpPDU(-96, varList);
        SnmpPDU resp = peer.send(pdu);
        VarBindList respList = resp.getVariables();
        for (int i = 0; i < respList.size(); ++i) {
            SnmpVar next = respList.get(i).getVar();
        }
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }

    protected int doesVsanExist(SnmpPeer peer) throws SnmpException {
        VarBindList varList = new VarBindList();
        varList.add(_vsanNameOid);
        VarBindList resp = SnmpFetch.getBulk(peer, varList).getVariables();
        for (int k = 0; k < resp.size(); k += varList.size()) {
            int[] oid = resp.getVb(k).getOid().getValue();
            int vsanId = oid[oid.length - 1];
            if (vsanId == -1 || vsanId != this._vsan) continue;
            return 1;
        }
        return 0;
    }

    protected QueueResponseObject setPortAdminStatus(SnmpPeer peer, int portStatus) throws SnmpException {
        VarBindList varList = new VarBindList();
        for (int i = 0; i < this._ports.size(); ++i) {
            FcPortBase nextPort = this._ports.get(i);
            int fcIndex = nextPort.getIfIndex();
            varList.add(_ifAdminStatusOid, fcIndex, (SnmpVar)new SnmpInt(portStatus));
        }
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }

    protected QueueResponseObject setVsanAllowList(SnmpPeer peer) throws SnmpException {
        this.buildVsanList(this._vsan);
        VarBindList varList = new VarBindList();
        for (int i = 0; i < this._ports.size(); ++i) {
            FcPortBase nextPort = this._ports.get(i);
            int fcIndex = nextPort.getIfIndex();
            varList.add(_fcIfAllowedVsanList2kOid, fcIndex, (SnmpVar)this._vsan2Kmap);
            varList.add(_fcIfAllowedVsanList4kOid, fcIndex, (SnmpVar)this._vsan4Kmap);
        }
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }

    private void buildVsanList(int vsanId) throws SnmpException {
        String vsanbits = new Integer(vsanId).toString();
        byte[] bitmap = SnmpBitmap.parse(vsanbits, false);
        this._vsan2Kmap = new SnmpString(bitmap);
        PortInterfaceUtil.getInstance(1);
        byte[] vsan4Kmap = PortInterfaceUtil.getVsan4k2(new SnmpOID(_fcIfAllowedVsanList2kOid), this._vsan2Kmap);
        if (vsan4Kmap == null) {
            vsan4Kmap = new byte[]{};
        }
        vsan4Kmap = SnmpBitmap.trimTrailingZero(vsan4Kmap);
        this._vsan2Kmap = new SnmpString(SnmpBitmap.trimTrailingZero(this._vsan2Kmap.getValue()));
        this._vsan4Kmap = new SnmpString(vsan4Kmap);
    }
}

