/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.dto.TrafficMapElement;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.npv.NPVhelper;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TrafficEngineerRunnable
extends NpvRunnable {
    static Logger _logger = LogManager.getLogger((String)"fms.npv");
    static final int[] _CnpvTrafficAutoLoadBalanceOid = MibNode.get("cnpvTrafficAutoLoadbalance").getOid();
    static final int[] _CnpvTrafficMapFromIfIndexOid = MibNode.get("cnpvTrafficMapFromIfIndex").getOid();
    static final int[] _CnpvTrafficMapToIfIndexListOid = MibNode.get("cnpvTrafficMapToIfIndexList").getOid();
    static final int[] _CnpvTrafficMapRowStatusOid = MibNode.get("cnpvTrafficMapRowStatus").getOid();
    static final SnmpInt ACTIVE = new SnmpInt(1);
    static final SnmpInt CREATE_AND_GO = new SnmpInt(4);
    static final SnmpInt DESTROY = new SnmpInt(6);
    protected SwitchBase _sw;
    protected SnmpUserOpt _snmpUserOpt;
    protected CommunicationObjectSender _sender;
    protected long _requestId;
    protected TrafficMap _map;

    public TrafficEngineerRunnable(long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, TrafficMap map, CommunicationObjectSender sender) {
        this._sw = sw;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        this._requestId = requestId;
        this._map = map;
    }

    @Override
    public void run() {
        try {
            QueueResponseObject result = this.setTrafficEngineeringMap();
            this._sender.send(result);
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to set Traffic Engineering for switch:" + this._sw.toString() + " received error: " + se.getMessage()));
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    public QueueResponseObject setTrafficEngineeringMap() throws SnmpException {
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        Map<Integer, Integer> serverIfUsageMap = NPVhelper.getCnpvServerIfTable(peer, this._sw);
        TrafficMap currentMap = NPVhelper.getTrafficMap(peer, this._sw);
        Map<Integer, TrafficMapElement> currentMapElements = currentMap.getMap();
        Map<Integer, TrafficMapElement> mapElements = this._map.getMap();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        Map<Integer, Integer> prePortStatus = this.getPortAdminStatus();
        Set<Integer> portsToDisable = null;
        if (mapElements != null && mapElements.size() > 0) {
            portsToDisable = this.checkForPortsToDisable(serverIfUsageMap, mapElements);
            if (portsToDisable.size() > 0) {
                this.setPortAdminStatus(2, portsToDisable);
            }
            for (Integer key : mapElements.keySet()) {
                TrafficMapElement nextElement = mapElements.get(key);
                TrafficMapElement currentElement = currentMapElements.get(key);
                switch (nextElement.getType()) {
                    case 1: 
                    case 2: {
                        if (currentElement == null) {
                            pdu.addVar(new SnmpOID(_CnpvTrafficMapRowStatusOid, (int)key), CREATE_AND_GO);
                        }
                        byte[] extIndexes = NPVhelper.generateExternalIfIndexList(nextElement.getExternalPorts());
                        pdu.addVar(new SnmpOID(_CnpvTrafficMapToIfIndexListOid, (int)key), new SnmpString(extIndexes));
                        break;
                    }
                    case 3: {
                        if (currentElement == null) break;
                        pdu.addVar(new SnmpOID(_CnpvTrafficMapRowStatusOid, (int)key), DESTROY);
                    }
                }
            }
        }
        int enableLB = 1;
        if (!this._map.isEnableDisruptiveLoadBalance()) {
            enableLB = 2;
        }
        pdu.addVar(new SnmpOID(_CnpvTrafficAutoLoadBalanceOid, 0), new SnmpInt(enableLB));
        peer.set(pdu);
        if (mapElements != null && mapElements.size() > 0) {
            HashSet<Integer> portsToBringUp = new HashSet<Integer>();
            for (Integer portIndex : portsToDisable) {
                Integer portStatus = prePortStatus.get(portIndex);
                if (portStatus != 1) continue;
                portsToBringUp.add(portIndex);
            }
            if (portsToBringUp.size() > 0) {
                this.setPortAdminStatus(1, portsToBringUp);
            }
        }
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }

    protected void setPortAdminStatus(int portStatus, Set ports) throws SnmpException {
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        VarBindList varList = new VarBindList();
        for (Integer fcIndex : ports) {
            varList.add(_ifAdminStatusOid, fcIndex, (SnmpVar)new SnmpInt(portStatus));
        }
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
    }

    protected Map<Integer, Integer> getPortAdminStatus() throws SnmpException {
        HashMap<Integer, Integer> portResults = new HashMap<Integer, Integer>();
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        VarBindList varList = new VarBindList();
        varList.add(_ifAdminStatusOid);
        VarBindList resp = SnmpFetch.getBulk(peer, varList).getVariables();
        for (int i = 0; i < resp.size(); ++i) {
            int[] oid = resp.getVb(i).getOid().getValue();
            int ifIndex = oid[oid.length - 1];
            int adminStatus = resp.intValue(i);
            portResults.put(ifIndex, adminStatus);
        }
        _logger.debug((Object)("port admin status" + portResults));
        return portResults;
    }

    private Set<Integer> checkForPortsToDisable(Map<Integer, Integer> serverIfUsageMap, Map<Integer, TrafficMapElement> mapElements) {
        if (serverIfUsageMap.isEmpty()) {
            return mapElements.keySet();
        }
        HashSet<Integer> portsToDisable = new HashSet<Integer>();
        for (Integer serverIf : mapElements.keySet()) {
            Integer usedExternal = serverIfUsageMap.get(serverIf);
            if (usedExternal == null) {
                portsToDisable.add(serverIf);
                continue;
            }
            TrafficMapElement nextElement = mapElements.get(serverIf);
            if (nextElement.getExternalPorts().contains(usedExternal)) continue;
            portsToDisable.add(serverIf);
        }
        return portsToDisable;
    }
}

