/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.sm.server.pm.FlowPort;

class FlowPairKey {
    int _vsanId;
    FlowPort _src;
    FlowPort _dst;

    FlowPairKey(int vsanId, FlowPort src, FlowPort dst) {
        if (dst.isTarget() && src.isTarget()) {
            if (src._name.compareTo(dst._name) > 0) {
                FlowPort temp = dst;
                dst = src;
                src = temp;
            }
        } else if (!dst.isTarget()) {
            FlowPort temp = dst;
            dst = src;
            src = temp;
        }
        this._vsanId = vsanId;
        this._src = src;
        this._dst = dst;
    }

    public String toString() {
        return "pair:vsan:" + this._vsanId + ":" + this._src.toString() + "---" + this._dst.toString();
    }

    public int hashCode() {
        return this._vsanId ^ this._src.getFcIdNum(this._vsanId) ^ this._dst.getFcIdNum(this._vsanId);
    }

    public boolean equals(Object key) {
        if (key instanceof FlowPairKey) {
            if (key == this) {
                return true;
            }
            FlowPairKey k = (FlowPairKey)key;
            return k._vsanId == this._vsanId && this.same(this._src, k._src) && this.same(this._dst, k._dst);
        }
        return false;
    }

    private boolean same(FlowPort p1, FlowPort p2) {
        return p1.getFcIdNum(this._vsanId) == p2.getFcIdNum(this._vsanId);
    }
}

