/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.pm.N3KBufferIfCountData;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import java.io.File;
import java.io.FileInputStream;
import java.net.Inet4Address;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class N3kCollector {
    protected static N3kCollector _Instance = null;
    protected Logger _Log = LogManager.getLogger((String)"PM.n3k");
    protected Map<String, Integer> _BufMap = null;
    private DateFormat _dateFormat;
    protected long timeStmp = -1L;

    private N3kCollector() {
    }

    public static N3kCollector getInstance() {
        if (_Instance == null) {
            _Instance = new N3kCollector();
        }
        return _Instance;
    }

    private void reset() {
        this._BufMap = new HashMap<String, Integer>();
    }

    public void readStats(String fname) {
        this.reset();
        this.persistStats(fname);
    }

    private void persistStats(String fname) {
        File file = new File(fname);
        if (!file.exists()) {
            this._Log.warn((Object)(fname + " failed to generate properly."));
            return;
        }
        long updateTime = this.collectByFile(file);
        if (updateTime < 0L) {
            file.delete();
            return;
        }
        updateTime = (long)((int)(updateTime / 3600000L) * 3600) * 1000L;
        String curFileName = fname.substring(0, fname.lastIndexOf(45)) + "-" + updateTime;
        File curFile = new File(curFileName);
        if (curFile.exists()) {
            file.delete();
            return;
        }
        try {
            this._Log.info((Object)("Try to move file from:" + file.getName() + " to " + curFile.getName()));
            FileUtils.copyFile((File)file, (File)curFile);
            this.store2DB(updateTime);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFullFileName(long swDbId, long tStamp) {
        String ipStr;
        String prefix;
        String fname;
        block6: {
            fname = swDbId + "-" + tStamp;
            prefix = ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary";
            ipStr = null;
            Connection conn = null;
            ResultSet rs = null;
            PreparedStatement pstmt = null;
            try {
                byte[] ipByteArr;
                conn = ConnectionManager.getConnection();
                pstmt = conn.prepareStatement("select ip_address from ethswitch where id = ?");
                pstmt.setLong(1, swDbId);
                rs = pstmt.executeQuery();
                if (rs.next() && (ipByteArr = rs.getBytes(1)) != null) {
                    ipStr = Inet4Address.getByAddress(ipByteArr).getHostAddress();
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        return ipStr == null ? null : prefix + File.separator + ipStr + File.separator + fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getN3kSwitches() {
        ArrayList<String> rstList = new ArrayList<String>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            conn = ConnectionManager.getConnection();
            String sql = "select id, ip_address from ethswitch where is_pm_collect=true and type in (1238,1107,1106,1105,1163,1239)";
            pstmt = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(sql));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                long switchId = rs.getLong(1);
                byte[] ipByteArr = rs.getBytes(2);
                if (ipByteArr == null) continue;
                rstList.add(switchId + "--" + Inet4Address.getByAddress(ipByteArr).getHostAddress());
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        DbUtil.close(conn);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store2DB(long tStmp) {
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            conn = ConnectionManager.getConnection();
            for (Map.Entry<String, Integer> entry : this._BufMap.entrySet()) {
                String[] strArr = entry.getKey().split("-");
                long switchId = Long.parseLong(strArr[0]);
                int ifIndex = Integer.parseInt(strArr[1]);
                try {
                    pstmt = conn.prepareStatement("insert into pm_buffer_count(UPDATE_TIME, SWITCH_ID, IF_INDEX, COUNT)  values(?,?,?,?)");
                    pstmt.setTimestamp(1, new Timestamp(tStmp));
                    pstmt.setLong(2, switchId);
                    pstmt.setInt(3, ifIndex);
                    pstmt.setInt(4, entry.getValue());
                    pstmt.execute();
                }
                catch (Exception ex) {
                    this._Log.warn((Object)"Exception in persisting buffer count:", (Throwable)ex);
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(pstmt);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex);
        }
        finally {
            DbUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<N3KBufferIfCountData> getCountsBySwIdAndInf(long switchId, long infIndex, long timestamp) {
        ArrayList<N3KBufferIfCountData> ret = new ArrayList<N3KBufferIfCountData>();
        String fileName = this.getFullFileName(switchId, timestamp);
        File file = new File(fileName);
        if (!file.exists()) {
            this._Log.warn((Object)("Error in getCountsBySwIdAndInf: " + fileName + " does not exist."));
            return ret;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String header_str = null;
            byte dataType = 0;
            int records = 0;
            byte[] header = new byte[36];
            int n = fis.read(header, 0, 36);
            if (n != 36) {
                throw new Exception("Error reading header");
            }
            header_str = new String(header);
            System.out.println("Header is:" + header_str);
            byte[] next = new byte[4];
            n = fis.read(next, 0, 4);
            if (n != 4) {
                throw new Exception("Error reading version");
            }
            byte majVersion = next[0];
            byte minVersion = next[1];
            dataType = next[2];
            System.out.println("Version major is: " + majVersion + "; Version minor is: " + minVersion + "; Data Type is: " + dataType);
            n = fis.read(next, 0, 4);
            if (n != 4) {
                throw new Exception("Error reading counts");
            }
            records = N3kCollector.byteArrayToInt(next);
            System.out.println("Total record counts is: " + records);
            if (dataType == 1 && records > 0) {
                byte[] b_timestamp = new byte[8];
                byte[] b_ifIndex = new byte[4];
                byte[] b_next = new byte[2];
                byte[] b_count = new byte[16];
                int index = 1;
                for (int j = 0; j < records; ++j) {
                    n = fis.read(b_timestamp, 0, 4);
                    long timestamp_second = N3kCollector.byteArrayToInt(b_timestamp);
                    n = fis.read(b_timestamp, 0, 4);
                    long timestamp_microSecond = N3kCollector.byteArrayToInt(b_timestamp);
                    n = fis.read(b_ifIndex, 0, 4);
                    int ifIndex = N3kCollector.byteArrayToInt(b_ifIndex);
                    n = fis.read(b_next, 0, 2);
                    byte recordType = b_next[0];
                    byte vol = b_next[1];
                    n = fis.read(b_count, 0, 16);
                    int count1 = N3kCollector.unsignedByteToInt(b_count[0]);
                    int count2 = N3kCollector.unsignedByteToInt(b_count[1]);
                    int count3 = N3kCollector.unsignedByteToInt(b_count[2]);
                    int count4 = N3kCollector.unsignedByteToInt(b_count[3]);
                    int count5 = N3kCollector.unsignedByteToInt(b_count[4]);
                    int count6 = N3kCollector.unsignedByteToInt(b_count[5]);
                    int count7 = N3kCollector.unsignedByteToInt(b_count[6]);
                    int count8 = N3kCollector.unsignedByteToInt(b_count[7]);
                    int count9 = N3kCollector.unsignedByteToInt(b_count[8]);
                    int count10 = N3kCollector.unsignedByteToInt(b_count[9]);
                    int count11 = N3kCollector.unsignedByteToInt(b_count[10]);
                    int count12 = N3kCollector.unsignedByteToInt(b_count[11]);
                    int count13 = N3kCollector.unsignedByteToInt(b_count[12]);
                    int count14 = N3kCollector.unsignedByteToInt(b_count[13]);
                    int count15 = N3kCollector.unsignedByteToInt(b_count[14]);
                    int count16 = N3kCollector.unsignedByteToInt(b_count[15]);
                    if ((long)ifIndex != infIndex) continue;
                    N3KBufferIfCountData ifData = new N3KBufferIfCountData(infIndex);
                    ifData.setTimestamp(timestamp_second * 1000L);
                    Date dd = new Date(timestamp_second * 1000L);
                    ifData.setTimestampStr(this.getDateFormat().format(dd));
                    ifData.setIndex(index++);
                    ifData.setCount1(count1);
                    ifData.setCount2(count2);
                    ifData.setCount3(count3);
                    ifData.setCount4(count4);
                    ifData.setCount5(count5);
                    ifData.setCount6(count6);
                    ifData.setCount7(count7);
                    ifData.setCount8(count8);
                    ifData.setCount9(count9);
                    ifData.setCount10(count10);
                    ifData.setCount11(count11);
                    ifData.setCount12(count12);
                    ifData.setCount13(count13);
                    ifData.setCount14(count14);
                    ifData.setCount15(count15);
                    ifData.setCount16(count16);
                    ret.add(ifData);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collectByFile(File f) {
        String swIdStr = f.getName().split("-")[0];
        long timestamp = -1L;
        long timestamp_second = -1L;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            String header_str = null;
            byte dataType = 0;
            int records = 0;
            byte[] header = new byte[36];
            int n = fis.read(header, 0, 36);
            if (n != 36) {
                throw new Exception("Error reading header");
            }
            header_str = new String(header);
            System.out.println("Header is:" + header_str);
            byte[] next = new byte[4];
            n = fis.read(next, 0, 4);
            if (n != 4) {
                throw new Exception("Error reading version");
            }
            byte majVersion = next[0];
            byte minVersion = next[1];
            dataType = next[2];
            System.out.println("Version major is: " + majVersion + "; Version minor is: " + minVersion + "; Data Type is: " + dataType);
            n = fis.read(next, 0, 4);
            if (n != 4) {
                throw new Exception("Error reading counts");
            }
            records = N3kCollector.byteArrayToInt(next);
            System.out.println("Total record counts is: " + records);
            if (dataType == 1 && records > 0) {
                byte[] b_timestamp = new byte[8];
                byte[] b_ifIndex = new byte[4];
                byte[] b_next = new byte[2];
                byte[] b_count = new byte[16];
                int threshold = Integer.parseInt(System.getProperty("pm.n3k.threshold", "1"));
                for (int j = 0; j < records; ++j) {
                    n = fis.read(b_timestamp, 0, 4);
                    timestamp_second = N3kCollector.byteArrayToInt(b_timestamp);
                    n = fis.read(b_timestamp, 0, 4);
                    long timestamp_microSecond = N3kCollector.byteArrayToInt(b_timestamp);
                    timestamp = timestamp_second * 1000000L + timestamp_microSecond;
                    n = fis.read(b_ifIndex, 0, 4);
                    int ifIndex = N3kCollector.byteArrayToInt(b_ifIndex);
                    n = fis.read(b_next, 0, 2);
                    byte recordType = b_next[0];
                    byte vol = b_next[1];
                    n = fis.read(b_count, 0, 16);
                    int count1 = N3kCollector.unsignedByteToInt(b_count[0]);
                    int count2 = N3kCollector.unsignedByteToInt(b_count[1]);
                    int count3 = N3kCollector.unsignedByteToInt(b_count[2]);
                    int count4 = N3kCollector.unsignedByteToInt(b_count[3]);
                    int count5 = N3kCollector.unsignedByteToInt(b_count[4]);
                    int count6 = N3kCollector.unsignedByteToInt(b_count[5]);
                    int count7 = N3kCollector.unsignedByteToInt(b_count[6]);
                    int count8 = N3kCollector.unsignedByteToInt(b_count[7]);
                    int count9 = N3kCollector.unsignedByteToInt(b_count[8]);
                    int count10 = N3kCollector.unsignedByteToInt(b_count[9]);
                    int count11 = N3kCollector.unsignedByteToInt(b_count[10]);
                    int count12 = N3kCollector.unsignedByteToInt(b_count[11]);
                    int count13 = N3kCollector.unsignedByteToInt(b_count[12]);
                    int count14 = N3kCollector.unsignedByteToInt(b_count[13]);
                    int count15 = N3kCollector.unsignedByteToInt(b_count[14]);
                    int count16 = N3kCollector.unsignedByteToInt(b_count[15]);
                    Integer counter = this._BufMap.get(swIdStr + "-" + ifIndex);
                    if (counter == null) {
                        counter = 0;
                    }
                    for (int i = threshold - 1; i < b_count.length; ++i) {
                        if (N3kCollector.unsignedByteToInt(b_count[i]) <= 0) continue;
                        Integer n2 = counter;
                        Integer n3 = counter = Integer.valueOf(counter + 1);
                        break;
                    }
                    this._BufMap.put(swIdStr + "-" + ifIndex, counter);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return timestamp_second * 1000L;
    }

    private void cleanOldFiles() {
        block8: {
            File path = null;
            File[] fileList = null;
            long curTStamp = System.currentTimeMillis();
            long threshold = Long.parseLong(System.getProperty("pm.n3k.history", "7"));
            try {
                path = new File(ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary" + File.separator);
                fileList = path.listFiles();
                if (fileList == null || fileList.length <= 0) break block8;
                for (File file : fileList) {
                    if (file.isDirectory()) {
                        File[] subList;
                        for (File sub : subList = file.listFiles()) {
                            try {
                                long tStamp;
                                if (!sub.isFile()) continue;
                                String[] strArr = sub.getName().split("-");
                                if (strArr.length < 2) {
                                    sub.delete();
                                }
                                if (curTStamp - (tStamp = Long.parseLong(strArr[1])) <= threshold * 24L * 60L * 60L * 1000L) continue;
                                sub.delete();
                            }
                            catch (Exception ex) {
                                this._Log.warn((Object)("Error in deleting " + sub.getName()));
                            }
                        }
                        continue;
                    }
                    file.delete();
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldDbRecords() {
        block5: {
            Connection conn = null;
            ResultSet rs = null;
            PreparedStatement pstmt = null;
            long curTStamp = System.currentTimeMillis();
            long limit = Long.parseLong(System.getProperty("pm.n3k.history", "7"));
            try {
                long threshold = curTStamp - limit * 24L * 60L * 60L * 1000L;
                conn = ConnectionManager.getConnection();
                pstmt = conn.prepareStatement("delete from pm_buffer_count where update_time < ?");
                pstmt.setTimestamp(1, new Timestamp(threshold));
                pstmt.execute();
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block5;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
            }
            DbUtil.close(pstmt);
            DbUtil.close(conn);
        }
    }

    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static int byteArrayToLong(byte[] b) {
        return b[7] & 0xFF | (b[6] & 0xFF) << 8 | (b[5] & 0xFF) << 16 | (b[4] & 0xFF) << 24 | (b[3] & 0xFF) << 32 | (b[2] & 0xFF) << 40 | (b[1] & 0xFF) << 48 | (b[0] & 0xFF) << 56;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    public static void main(String[] args) {
        N3kCollector.getInstance().getFullFileName(58306000L, 1359669600000L);
    }

    public void cleanOldStats() {
        this.cleanOldFiles();
        this.cleanOldDbRecords();
    }
}

