/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.pm.PmConfig;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.Query;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;

public final class PmConfigUtil {
    static final String GigeQuerySQLByWwn = "select s.sys_name, sp.if_name, s.ip_address from switch_port sp, switch s where  s.wwn =? and sp.if_index=? and s.id=sp.switch_id";
    static final String OtherQuerySQLByWwn = "select o.displayname, o.switchname  from PM_EXTRAOID o where  o.switchip =? and o.name = ?";
    static final String SwitchQuerySQLByWwn = "select o.sys_name, o.ip_address  from SWITCH o where  o.wwn =?";
    static final String QuerySQLBySwitchWwnPortIndex = "select sp.id, sp.if_speed, s.sys_name, s.ip_address, s.is_managable, s.is_mds from switch s, switch_port sp where s.wwn = ? and sp.switch_id = s.id and sp.if_index = ?";
    static final String QuerySQLBySwitchIpPortIndex = "select sp.id, sp.if_speed, s.sys_name, sp.if_name from ethswitch s, ethswitch_port sp where s.ip_address = ? and sp.switch_id = s.id and sp.if_index = ?";
    static final String QuerySQLByCoreSwitchIfIndexFexPortIndex = "select sp1.id, sp1.if_speed, s1.sys_name, sp1.if_name, sp2.id, s2.sys_name, sp2.if_name from ethswitch s1, ethswitch_port sp1, ethswitch_fex ef, ethswitch s2, ethswitch_port sp2 where ef.switch_id=s1.id and ef.fex_id=s2.id and sp1.switch_id=s1.id and sp2.switch_id=s2.id and sp1.if_index=? and sp2.if_index=?";
    static final String QuerySQLByEndPortWwn = "select ep.id, ep.name, s.sys_name, sp.if_index, sp.if_speed, s.ip_address from switch s, switch_port sp, end_port ep where ep.wwn = ? and ep.switch_port_id=sp.id and sp.switch_id = s.id";
    static final String VsanQuerySQLBySWPortId = "select vsan.vsan_id from isl, vsan, vsan_isl_info vii where isl.port1_id=? and vii.isl_id=isl.id and vii.vsan_id=vsan.id order by vsan.vsan_id";
    static final String VsanQuerySQLByEndPortId = "select vsan.vsan_id from vsan, vsan_endport_info vei where vei.endport_id=? and vei.vsan_id=vsan.id order by vsan.vsan_id";
    private String _rrdFile;
    private int _type;

    public PmConfigUtil(String rrdFile, int type) {
        this._rrdFile = rrdFile;
        this._type = type;
    }

    PmConfig findPmConfig(InetAddress ip1, int if1, InetAddress ip2, int if2) throws Exception {
        PmConfig config = null;
        try {
            config = this.findRegularIslPmConfig(ip1, if1, ip2, if2);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (config == null) {
            config = this.findFexIslPmConfig(ip1, if1, ip2, if2);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findRegularIslPmConfig(InetAddress ip1, int if1, InetAddress ip2, int if2) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySQLBySwitchIpPortIndex);
            pstmt_s.setBytes(1, ip1.getAddress());
            pstmt_s.setInt(2, if1);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find etherisl information.");
            }
            long speed = rs.getLong(2) / 10L;
            String sw1Name = rs.getString(3);
            String ifName1 = rs.getString(4);
            rs.close();
            rs = null;
            pstmt_s.setBytes(1, ip2.getAddress());
            pstmt_s.setInt(2, if2);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find etherisl information.");
            }
            String sw2Name = rs.getString(3);
            String ifName2 = rs.getString(4);
            DbUtil.close(pstmt_s);
            DbUtil.close(rs);
            String title = sw1Name + " " + ifName1 + " - " + sw2Name + " " + ifName2;
            rs.close();
            rs = null;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(ip1.getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + if1, "1.3.6.1.2.1.31.1.1.1.10." + if1});
            pmConfig = new PmConfig(this._rrdFile, title, "", 10, map);
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            PmConfig pmConfig2 = null;
            return pmConfig2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findFexIslPmConfig(InetAddress ip1, int if1, InetAddress ip2, int if2) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySQLByCoreSwitchIfIndexFexPortIndex);
            String sw1Name = null;
            String sw2Name = null;
            String ifName1 = null;
            String ifName2 = null;
            boolean tryOtherSide = false;
            pstmt_s.setLong(1, if1);
            pstmt_s.setInt(2, if2);
            rs = pstmt_s.executeQuery();
            if (rs.next()) {
                long speed = rs.getLong(2) / 10L;
                sw1Name = rs.getString(3);
                ifName1 = rs.getString(4);
                sw2Name = rs.getString(6);
                ifName2 = rs.getString(7);
            } else {
                tryOtherSide = true;
            }
            if (tryOtherSide) {
                rs.close();
                rs = null;
                pstmt_s.setLong(1, if2);
                pstmt_s.setInt(2, if1);
                rs = pstmt_s.executeQuery();
                if (rs.next()) {
                    sw2Name = rs.getString(3);
                    ifName2 = rs.getString(4);
                    sw1Name = rs.getString(6);
                    ifName1 = rs.getString(7);
                } else {
                    throw new Exception("Can not find fex etherisl information.");
                }
            }
            String title = sw1Name + " " + ifName1 + " - " + sw2Name + " " + ifName2;
            rs.close();
            rs = null;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(ip1.getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + if1, "1.3.6.1.2.1.31.1.1.1.10." + if1});
            pmConfig = new PmConfig(this._rrdFile, title, "", 10, map);
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            System.out.println("PM findFexIslPmConfig error: " + ex.getMessage());
            PmConfig pmConfig2 = null;
            return pmConfig2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findPmConfig(InetAddress ip1, int if1) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySQLBySwitchIpPortIndex);
            pstmt_s.setBytes(1, ip1.getAddress());
            pstmt_s.setInt(2, if1);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find ether_intf information.");
            }
            long speed = rs.getLong(2) / 10L;
            String sw1Name = rs.getString(3);
            String ifName1 = rs.getString(4);
            rs.close();
            String title = sw1Name + " " + ifName1;
            rs.close();
            rs = null;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(ip1.getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + if1});
            pmConfig = new PmConfig(this._rrdFile, title, "", 11, map);
        }
        catch (Exception ex) {
            PmConfig pmConfig2;
            try {
                System.out.println("PM find PmConfig error: " + ex.getMessage());
                pmConfig2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return pmConfig2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findEthInfPmConfig(InetAddress ip1, int if1) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySQLBySwitchIpPortIndex);
            pstmt_s.setBytes(1, ip1.getAddress());
            pstmt_s.setInt(2, if1);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find ether_intf information.");
            }
            long speed = rs.getLong(2) / 10L;
            String sw1Name = rs.getString(3);
            String ifName1 = rs.getString(4);
            rs.close();
            String title = sw1Name + " " + ifName1;
            rs.close();
            rs = null;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(ip1.getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + if1, "1.3.6.1.2.1.31.1.1.1.10." + if1});
            pmConfig = new PmConfig(this._rrdFile, title, "", 11, map);
        }
        catch (Exception ex) {
            PmConfig pmConfig2;
            try {
                System.out.println("PM find PmConfig error: " + ex.getMessage());
                pmConfig2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return pmConfig2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findPmConfig(String sw1Wwn, int if1, String sw2Wwn, int if2) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        boolean hasColon = sw1Wwn != null && sw1Wwn.indexOf(58) >= 0;
        byte[] sw1 = SnmpString.fromHexString(sw1Wwn, hasColon);
        byte[] sw2 = SnmpString.fromHexString(sw2Wwn, hasColon);
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySQLBySwitchWwnPortIndex);
            StringBuffer vList = new StringBuffer("VSAN: ");
            pstmt_s.setBytes(1, sw1);
            pstmt_s.setInt(2, if1);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find isl information.");
            }
            long spId = rs.getLong(1);
            long speed = rs.getLong(2) / 10L;
            String sw1Name = rs.getString(3);
            byte[] sw1IpAddr = rs.getBytes(4);
            boolean sw1_isMng = rs.getBoolean(5);
            boolean sw1_isMDS = rs.getBoolean(6);
            rs.close();
            rs = null;
            pstmt_s.setBytes(1, sw2);
            pstmt_s.setInt(2, if2);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find isl information.");
            }
            String sw2Name = rs.getString(3);
            byte[] sw2IpAddr = rs.getBytes(4);
            boolean sw2_isMng = rs.getBoolean(5);
            boolean sw2_isMDS = rs.getBoolean(6);
            DbUtil.close(pstmt_s);
            DbUtil.close(rs);
            pstmt_s = conn.prepareStatement(VsanQuerySQLBySWPortId);
            pstmt_s.setLong(1, spId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                vList.append(rs.getInt(1) + ", ");
            }
            vList.append(" Max Speed: " + this.formatSpeed(speed));
            String title = sw1Name + " " + IfIndexUtil.ifIndexToName(if1) + " - " + sw2Name + " " + IfIndexUtil.ifIndexToName(if2);
            rs.close();
            rs = null;
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(InetAddress.getByAddress(sw1IpAddr).getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + if1, "1.3.6.1.2.1.31.1.1.1.10." + if1});
            pmConfig = new PmConfig(this._rrdFile, title, vList.toString(), 1, map);
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            System.out.println("PM find PmConfig error: " + ex.getMessage());
            PmConfig pmConfig2 = null;
            return pmConfig2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    String formatSpeed(long speed) {
        String s;
        if (speed > 1000000000L) {
            double sd = (double)speed / 1.0E9;
            s = sd + "G";
        } else if (speed > 1000000L) {
            double sd = (double)speed / 1000000.0;
            s = sd + "M";
        } else {
            s = String.valueOf(speed);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findPmConfig(String epWwn, int type) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        boolean hasColon = epWwn != null && epWwn.indexOf(58) >= 0;
        byte[] ep = SnmpString.fromHexString(epWwn, hasColon);
        ResultSet rs = null;
        try {
            String epName;
            long epId;
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySQLByEndPortWwn);
            String epAlias = null;
            StringBuffer vList = new StringBuffer("VSAN: ");
            pstmt_s.setBytes(1, ep);
            rs = pstmt_s.executeQuery();
            if (rs.next()) {
                epId = rs.getLong(1);
                epName = rs.getString(2);
                EndPortImpl epImpl = SanManager.getInstance().findEndPortByWwn(new Wwn(ep));
                if (epImpl != null) {
                    epAlias = epImpl.getAlias();
                }
            } else {
                throw new Exception("Can not find end port information.");
            }
            epName = epAlias != null && epAlias.length() > 0 ? epAlias : epName;
            String swName = rs.getString(3);
            int ifIndex = rs.getInt(4);
            long speed = rs.getLong(5) / 10L;
            byte[] ipAddr = rs.getBytes(6);
            pstmt_s.close();
            rs.close();
            pstmt_s = null;
            pstmt_s = conn.prepareStatement(VsanQuerySQLByEndPortId);
            pstmt_s.setLong(1, epId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                vList.append(rs.getInt(1) + ", ");
            }
            vList.append(swName + " " + IfIndexUtil.ifIndexToName(ifIndex) + ", Max Speed: " + this.formatSpeed(speed));
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(InetAddress.getByAddress(ipAddr).getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex});
            pmConfig = new PmConfig(this._rrdFile, epName, vList.toString(), type, map);
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            System.out.println("PM find PmConfig error: " + ex.getMessage());
            PmConfig pmConfig2 = null;
            return pmConfig2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findPmConfig(String ep1Wwn, String ep2Wwn) throws Exception {
        PmConfig pmConfig;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        boolean hasColon = ep1Wwn != null && ep1Wwn.indexOf(58) >= 0;
        byte[] ep1 = SnmpString.fromHexString(ep1Wwn, hasColon);
        byte[] ep2 = SnmpString.fromHexString(ep2Wwn, hasColon);
        ResultSet rs = null;
        try {
            String ep2Name;
            String ep1Name;
            pstmt_s = conn.prepareStatement(QuerySQLByEndPortWwn);
            String ep1Alias = null;
            String ep2Alias = null;
            pstmt_s.setBytes(1, ep1);
            rs = pstmt_s.executeQuery();
            if (rs.next()) {
                ep1Name = rs.getString(2);
                EndPortImpl epImpl = SanManager.getInstance().findEndPortByWwn(new Wwn(ep1));
                if (epImpl != null) {
                    ep1Alias = epImpl.getAlias();
                }
            } else {
                throw new Exception("Can not find end port information.");
            }
            ep1Name = ep1Alias != null ? ep1Alias : ep1Name;
            String if1 = rs.getString(4);
            byte[] sw1IpAddr = rs.getBytes(6);
            rs.close();
            rs = null;
            pstmt_s.setBytes(1, ep2);
            rs = pstmt_s.executeQuery();
            if (rs.next()) {
                ep2Name = rs.getString(2);
                EndPortImpl epImpl2 = SanManager.getInstance().findEndPortByWwn(new Wwn(ep2));
                if (epImpl2 != null) {
                    ep2Alias = epImpl2.getAlias();
                }
            } else {
                throw new Exception("Can not find end port information.");
            }
            ep2Name = ep2Alias != null ? ep2Alias : ep1Name;
            String if2 = rs.getString(4);
            byte[] sw2IpAddr = rs.getBytes(6);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(InetAddress.getByAddress(sw1IpAddr).getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.10." + if1});
            map.put(InetAddress.getByAddress(sw2IpAddr).getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + if2});
            pmConfig = new PmConfig(this._rrdFile, ep1Name + " -- " + ep2Name, null, 2, map);
        }
        catch (Exception ex) {
            PmConfig pmConfig2;
            try {
                System.out.println("PM find PmConfig error: " + ex.getMessage());
                pmConfig2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return pmConfig2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findEthOtherPmConfig(String ip, String oid) throws Exception {
        PmConfig pmConfig;
        oid = oid.replace('-', '.');
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        String ipAddress = ip.replace("-", "/.");
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(OtherQuerySQLByWwn);
            pstmt_s.setString(1, ipAddress);
            String oiddbName = oid.substring(0, oid.indexOf(".rrd"));
            pstmt_s.setString(2, oiddbName);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find end port information.");
            }
            String displayName = rs.getString(1);
            String sysName = rs.getString(2);
            StringBuffer vList = new StringBuffer(ip);
            vList.append(" " + displayName);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(ipAddress, new String[]{oiddbName});
            pmConfig = new PmConfig(this._rrdFile, sysName + " " + displayName, vList.toString(), 5, map);
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            System.out.println("PM find PmConfig error: " + ex.getMessage());
            PmConfig pmConfig2 = null;
            return pmConfig2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findOtherPmConfig(String wwn, String oid) throws Exception {
        PmConfig pmConfig;
        oid = oid.replace('-', '.');
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        byte[] ep = SnmpString.fromHexString(wwn, false);
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(SwitchQuerySQLByWwn);
            pstmt_s.setBytes(1, ep);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find end port information.");
            }
            String sysName = rs.getString(1);
            String ipAddress = InetAddress.getByAddress(rs.getBytes(2)).getHostAddress();
            DbUtil.close(pstmt_s);
            DbUtil.close(rs);
            pstmt_s = conn.prepareStatement(OtherQuerySQLByWwn);
            pstmt_s.setString(1, ipAddress);
            String oiddbName = oid.substring(0, oid.indexOf(".rrd"));
            pstmt_s.setString(2, oiddbName);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find end port information.");
            }
            String displayName = rs.getString(1);
            StringBuffer vList = new StringBuffer(sysName);
            vList.append(" " + displayName);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(ipAddress, new String[]{oiddbName});
            pmConfig = new PmConfig(this._rrdFile, sysName + ":" + displayName, vList.toString(), 5, map);
        }
        catch (Exception ex) {
            PmConfig pmConfig2;
            try {
                System.out.println("PM find PmConfig error: " + ex.getMessage());
                pmConfig2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return pmConfig2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PmConfig findGigePmConfig(String wwn, String ifIndexStr) throws Exception {
        PmConfig pmConfig;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        byte[] ep = SnmpString.fromHexString(wwn, false);
        int ifIndex = Integer.parseInt(ifIndexStr);
        String ifName = "";
        String sysName = "";
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(GigeQuerySQLByWwn);
            pstmt_s.setBytes(1, ep);
            pstmt_s.setInt(2, ifIndex);
            rs = pstmt_s.executeQuery();
            if (!rs.next()) {
                throw new Exception("Can not find gige port information.");
            }
            sysName = rs.getString(1);
            ifName = rs.getString(2);
            byte[] ipAddr = rs.getBytes(3);
            StringBuffer vList = new StringBuffer(sysName);
            vList.append(" " + ifName);
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put(InetAddress.getByAddress(ipAddr).getHostAddress(), new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex});
            pmConfig = new PmConfig(this._rrdFile, sysName + ":" + ifName, vList.toString(), 6, map);
        }
        catch (Exception ex) {
            PmConfig pmConfig2;
            try {
                System.out.println("PM find PmConfig error: " + ex.getMessage());
                pmConfig2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return pmConfig2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return pmConfig;
    }

    public PmConfig findFlowWithDiffIPPmConfig(String rrdFile) throws Exception {
        String[] v = StringUtil.tokenize(rrdFile, "_");
        if (v.length != 3) {
            throw new Exception("pmconfig: wrong flow rrd file name " + this._rrdFile);
        }
        return this.findPmConfig(v[0], v[1]);
    }

    public PmConfig findPmConfig() throws Exception {
        switch (this._type) {
            case 10: {
                String[] v = StringUtil.tokenize(this._rrdFile.substring(0, this._rrdFile.indexOf(46)), "_");
                if (v.length != 4) {
                    throw new Exception("pmConfig: wrong isl rrd file name " + this._rrdFile);
                }
                int if1 = Integer.parseInt(v[1]);
                int if2 = Integer.parseInt(v[3]);
                InetAddress ip1 = InetAddress.getByName(v[0].replace('X', '.'));
                InetAddress ip2 = InetAddress.getByName(v[2].replace('X', '.'));
                return this.findPmConfig(ip1, if1, ip2, if2);
            }
            case 1: 
            case 8: 
            case 9: {
                String[] v = StringUtil.tokenize(this._rrdFile.substring(0, this._rrdFile.indexOf(46)), "_");
                if (v.length != 4) {
                    throw new Exception("pmConfig: wrong isl rrd file name " + this._rrdFile);
                }
                int if1 = Integer.parseInt(v[1]);
                int if2 = Integer.parseInt(v[3]);
                return this.findPmConfig(v[0], if1, v[2], if2);
            }
            case 11: {
                String[] v = StringUtil.tokenize(this._rrdFile.substring(0, this._rrdFile.indexOf(46)), "_");
                if (v.length < 2) {
                    throw new Exception("pmConfig: wrong ether inf rrd file name " + this._rrdFile);
                }
                int if1 = Integer.parseInt(v[1]);
                InetAddress ip1 = InetAddress.getByName(v[0].replace('X', '.'));
                return this.findEthInfPmConfig(ip1, if1);
            }
            case 3: 
            case 4: {
                String[] v = new String[]{this._rrdFile.substring(0, this._rrdFile.indexOf(46))};
                return this.findPmConfig(v[0], this._type);
            }
            case 2: {
                HashMap<String, Query> map = PmCollect._QueryByRrd;
                Query obj = map.get(this._rrdFile);
                if (obj != null) {
                    return obj._def;
                }
                throw new Exception("pmconifg: can not find rrd file :  " + this._rrdFile + " in _QueryByRrd Hash");
            }
            case 15: {
                String[] v = StringUtil.tokenize(this._rrdFile, "_");
                return this.findEthOtherPmConfig(v[0], v[1]);
            }
            case 5: {
                String[] v = StringUtil.tokenize(this._rrdFile, "_");
                return this.findOtherPmConfig(v[0], v[1]);
            }
            case 6: {
                String[] v = StringUtil.tokenize(this._rrdFile, "_");
                return this.findGigePmConfig(v[0], v[1]);
            }
        }
        throw new Exception("pmconfig: invaid type of rrd file " + this._rrdFile);
    }
}

