/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTP;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.cisco.dcbu.sm.common.rif.PmServiceRif;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.pm.N3kCollector;
import com.cisco.dcbu.sm.server.pm.PmSwitchCmdHelper;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class PmServiceMgr
implements PmServiceRif {
    private static PmServiceMgr _Instance = null;
    private static Logger _Log = Logger.getLogger((String)"PM.n3k");
    private String _RemotePath = "bootflash:BufferMonitor-1HourData";

    protected PmServiceMgr() {
    }

    public static PmServiceMgr getInstance() {
        if (_Instance == null) {
            _Instance = new PmServiceMgr();
        }
        return _Instance;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    public static void main(String[] args) {
        try {
            TFTP tftpSrvr = TFTP.getInstance();
            tftpSrvr.addIpAccess("172.28.83.159", "true", "true", "true");
            tftpSrvr.addIpAccess("172.28.83.242", "true", "true", "true");
            tftpSrvr.setRoot(ClientCache.getInstallLocation());
            tftpSrvr.startServer(true);
        }
        catch (Exception ex) {
            System.err.print(ex.getMessage());
        }
    }

    @Override
    public void collect() throws RemoteException {
        this.getRemoteFiles();
        N3kCollector.getInstance().cleanOldStats();
    }

    private void getRemoteFiles() throws RemoteException {
        _Log.info((Object)"------------------------ Pm Service collecting ---------------------------");
        boolean useSFTP = Boolean.valueOf(System.getProperty("server.sftp.enabled", "false"));
        if (useSFTP) {
            this.getSftpFiles();
        } else {
            this.getTftpFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTftpFiles() throws RemoteException {
        List<String> n3kSwitches;
        TFTP tftpSrvr = null;
        String localIp = NetUtil.getLocalServerHostAddress();
        if (localIp == null) {
            _Log.warn((Object)"PM Service cannot get local server ip address.");
            throw new RemoteException("PM Service cannot get local server ip address.");
        }
        LanImpl lanIm = DCManager.getInstance().getLan();
        if (lanIm == null) {
            _Log.warn((Object)"Failed to get the Lan Manager.");
            return;
        }
        File binaryDir = new File(ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary");
        if (!binaryDir.exists()) {
            binaryDir.mkdir();
        }
        if ((n3kSwitches = N3kCollector.getInstance().getN3kSwitches()).size() < 1) {
            return;
        }
        String tftpRoot = ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary" + File.separator;
        File dir = new File(tftpRoot);
        if (!dir.exists()) {
            dir.mkdir();
        }
        try {
            tftpSrvr = TFTP.getInstance();
            tftpSrvr.setRoot(tftpRoot);
            tftpSrvr.startServer(SnmpSession.isTrace());
            for (String itm : n3kSwitches) {
                long swDbId = Long.parseLong(itm.split("--")[0]);
                String ipAddr = itm.split("--")[1];
                try {
                    tftpSrvr.addIpAccess(ipAddr, "true", "true", "true");
                    EthSwitchImpl ethImpl = lanIm.findEthSwitchByDBID(swDbId);
                    if (ethImpl == null) {
                        _Log.warn((Object)("PM N3k tftp file retrieval failed on switchImpl:" + ipAddr));
                        continue;
                    }
                    SnmpPeer ethPeer = ethImpl.getPeer();
                    if (ethPeer == null) {
                        _Log.warn((Object)("PM N3k tftp file retrieval failed on peer:" + ipAddr));
                        continue;
                    }
                    String localDir = ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary" + File.separator + ipAddr + File.separator;
                    File localdirF = new File(localDir);
                    if (!localdirF.exists()) {
                        localdirF.mkdir();
                    }
                    String fileName = swDbId + "-" + System.currentTimeMillis();
                    String localPath = "tftp://" + localIp + "/" + ipAddr + "/" + fileName;
                    Vsh vsh = Vsh.get(null, ethPeer, true);
                    String cmd = "copy " + this._RemotePath + " " + localPath + "\n";
                    PmSwitchCmdHelper helper = new PmSwitchCmdHelper(vsh, cmd, tftpSrvr, localDir + fileName);
                    helper.execute();
                }
                catch (Exception ex) {
                    _Log.warn((Object)ex, (Throwable)ex);
                }
            }
        }
        catch (IOException e) {
            _Log.warn((Object)e, (Throwable)e);
        }
        finally {
            if (tftpSrvr != null) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    _Log.warn((Object)ex, (Throwable)ex);
                }
                tftpSrvr.stopServer();
            }
        }
    }

    private void getSftpFiles() throws RemoteException {
        String localIp;
        String sftpRoot = null;
        String sftpUserName = null;
        String sftpPassword = null;
        sftpRoot = System.getProperty("server.sftp.rootdir", null);
        sftpUserName = System.getProperty("server.sftp.username", null);
        String pass = System.getProperty("server.sftp.password", null);
        if (pass != null) {
            if (pass.startsWith("#")) {
                try {
                    sftpPassword = JBoss_4_2Encrypter.decrypt(pass.substring(1));
                }
                catch (Exception ex) {
                    throw new RemoteException("can not decrypt SFTP password:" + pass.substring(1));
                }
            } else {
                sftpPassword = pass;
            }
        }
        if (sftpRoot == null || sftpUserName == null || sftpPassword == null) {
            this.getTftpFiles();
        }
        if ((localIp = NetUtil.getLocalServerHostAddress()) == null) {
            throw new RemoteException("PM Service cannot get local server ip address");
        }
        LanImpl lanIm = DCManager.getInstance().getLan();
        if (lanIm == null) {
            return;
        }
        File binaryDir = new File(ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary");
        if (!binaryDir.exists()) {
            binaryDir.mkdir();
        }
        List<String> n3kSwithes = N3kCollector.getInstance().getN3kSwitches();
        SnmpPeer ethPeer = null;
        for (String itm : n3kSwithes) {
            File localDirF;
            long swDbId = Long.parseLong(itm.split("--")[0]);
            String ipAddr = itm.split("--")[1];
            EthSwitchImpl ethImpl = lanIm.findEthSwitchByDBID(swDbId);
            if (ethImpl == null) {
                return;
            }
            ethPeer = ethImpl.getPeer();
            String localDir = ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary" + File.separator + ipAddr + File.separator;
            File dir = new File(sftpRoot + "/" + ipAddr);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!(localDirF = new File(localDir)).exists()) {
                localDirF.mkdir();
            }
            String ftpStr = "sftp://" + sftpUserName + "@";
            String fileName = swDbId + "-" + System.currentTimeMillis();
            String localPath = ftpStr + localIp + "/" + fileName;
            localPath = ftpStr + localIp + "/" + ipAddr + "/" + fileName;
            try {
                this.getRemoteFileViaSftp(ethPeer, ipAddr, this._RemotePath, localIp, localPath, sftpPassword);
                String srcFile = sftpRoot + File.separator + ipAddr + File.separator + fileName;
                FileUtils.moveFileToDirectory((File)new File(srcFile), (File)new File(localDir), (boolean)true);
                N3kCollector.getInstance().readStats(localDir + fileName);
            }
            catch (Exception ex) {
                _Log.warn((Object)ex, (Throwable)ex);
            }
        }
    }

    private void getRemoteFiles1() throws RemoteException {
        _Log.warn((Object)"------------------------ Pm Service collecting ---------------------------");
        TFTP tftpSrvr = null;
        try {
            String localIp;
            boolean useSFTP = Boolean.valueOf(System.getProperty("server.sftp.enabled", "false"));
            String sftpRoot = null;
            String sftpUserName = null;
            String sftpPassword = null;
            if (useSFTP) {
                sftpRoot = System.getProperty("server.sftp.rootdir", null);
                sftpUserName = System.getProperty("server.sftp.username", null);
                String pass = System.getProperty("server.sftp.password", null);
                if (pass != null) {
                    if (pass.startsWith("#")) {
                        try {
                            sftpPassword = JBoss_4_2Encrypter.decrypt(pass.substring(1));
                        }
                        catch (Exception ex) {
                            throw new Exception("can not decrypt SFTP password:" + pass.substring(1));
                        }
                    } else {
                        sftpPassword = pass;
                    }
                }
                if (sftpRoot == null || sftpUserName == null || sftpPassword == null) {
                    useSFTP = false;
                }
            }
            if ((localIp = NetUtil.getLocalServerHostAddress()) == null) {
                throw new Exception("PM Service cannot get local server ip address");
            }
            LanImpl lanIm = DCManager.getInstance().getLan();
            if (lanIm == null) {
                return;
            }
            File binaryDir = new File(ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary");
            if (!binaryDir.exists()) {
                binaryDir.mkdir();
            }
            List<String> n3kSwithes = N3kCollector.getInstance().getN3kSwitches();
            SnmpPeer ethPeer = null;
            for (String itm : n3kSwithes) {
                String ftpStr;
                File dir;
                long swDbId = Long.parseLong(itm.split("--")[0]);
                String ipAddr = itm.split("--")[1];
                EthSwitchImpl ethImpl = lanIm.findEthSwitchByDBID(swDbId);
                if (ethImpl == null) {
                    return;
                }
                ethPeer = ethImpl.getPeer();
                String localDir = ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary" + File.separator + ipAddr + File.separator;
                String localRoot = ClientCache.getInstallLocation() + File.separator + "pm" + File.separator + "binary" + File.separator;
                if (!useSFTP) {
                    tftpSrvr = TFTP.getInstance();
                    tftpSrvr.addIpAccess(ipAddr, "true", "true", "true");
                    tftpSrvr.setRoot(localDir);
                    tftpSrvr.startServer(SnmpSession.isTrace());
                    String tftpRoot = tftpSrvr.getRoot();
                    dir = new File(tftpRoot);
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if (!(dir = new File(localDir)).exists()) {
                        dir.mkdir();
                    }
                    ftpStr = "tftp://";
                } else {
                    File dir2 = new File(sftpRoot + "/" + ipAddr);
                    if (!dir2.exists()) {
                        dir2.mkdir();
                    }
                    ftpStr = "sftp://" + sftpUserName + "@";
                }
                String remotePath = "bootflash:BufferMonitor-1HourData";
                dir = new File(localDir);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (_Log.isDebugEnabled()) {
                    _Log.debug((Object)(ftpStr + " " + localDir + "  " + remotePath));
                }
                String fileName = swDbId + "-" + System.currentTimeMillis();
                String localPath = ftpStr + localIp + "/" + fileName;
                if (!useSFTP) {
                    Vsh vsh = Vsh.get(null, ethPeer, true);
                    String cmd = "copy " + remotePath + " " + localPath + "\n";
                    PmSwitchCmdHelper helper = new PmSwitchCmdHelper(vsh, cmd, tftpSrvr, localDir + fileName);
                    helper.execute();
                    continue;
                }
                localPath = ftpStr + localIp + "/" + ipAddr + "/" + fileName;
                this.getRemoteFileViaSftp(ethPeer, ipAddr, remotePath, localIp, localPath, sftpPassword);
                String srcFile = sftpRoot + File.separator + ipAddr + File.separator + fileName;
                FileUtils.moveFileToDirectory((File)new File(srcFile), (File)new File(localDir), (boolean)true);
                N3kCollector.getInstance().readStats(localDir + fileName);
            }
        }
        catch (Exception ex) {
            _Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRemoteFileViaSftp(SnmpPeer peer, String remoteAddr, String remotePath, String localAddr, String localPath, String passwd) throws Exception {
        Vsh vsh = null;
        try {
            String[] vrfArr;
            vsh = Vsh.get(null, peer, true);
            String currentPrompt = vsh.getPrompt();
            for (String vrfStr : vrfArr = new String[]{"management", "default"}) {
                String cmd = "copy " + remotePath + " " + localPath + "\n" + vrfStr + "\n";
                StringBuffer output = new StringBuffer();
                try {
                    if (vsh == null) continue;
                    vsh.send("\n");
                    vsh.readPrompt();
                    vsh.send(cmd);
                    vsh.expect(new String[]{"password:", "Password:", "(yes/no)?", currentPrompt}, output);
                    if (output.indexOf("(yes/no)?") != -1) {
                        output.setLength(0);
                        vsh.send("yes\n");
                        vsh.expect(new String[]{"password:", "Password:", currentPrompt}, output);
                    }
                    if (output.toString().toLowerCase().indexOf("password:") != -1) {
                        output.setLength(0);
                        vsh.send(passwd + "\n");
                        vsh.expect(new String[]{"password:", "Password:", currentPrompt}, output);
                        if (output.toString().toLowerCase().indexOf("password:") != -1) {
                            throw new Exception("Incorrect Password");
                        }
                        if (output.indexOf("100%") != -1) {
                            output.setLength(0);
                            continue;
                        }
                        throw new Exception("Remote copy failed. " + output);
                    }
                    throw new Exception("Remote copy failed. " + output);
                }
                catch (Exception ex) {
                    _Log.warn((Object)ex, (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            _Log.warn((Object)ex, (Throwable)ex);
        }
        finally {
            if (vsh != null) {
                Vsh.put(vsh);
            }
        }
    }
}

