/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm.pmutil;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.sm.common.model.SpanInfo;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.discovery.NtopWorker;
import com.cisco.dcbu.sm.server.discovery.SpanWorker;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.NtopImpl;
import com.cisco.dcbu.sm.server.model.NtopSpanInfoImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SpanPortImpl;
import com.cisco.dcbu.sm.server.model.SpanSessionImpl;
import com.cisco.dcbu.sm.server.model.SpanSourcePortImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.pm.pmutil.NtopSwitchInfo;
import com.cisco.dcbu.sm.server.pm.pmutil.NtopUpdateTask;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NtopIntegrator {
    static final String QuerySwitchIpSQL = "select sw.ip_address, ntop.ip_addr, ntop.port_number from ntop, ntop_span_info nsi, span_port sp, switch sw where nsi.ntop_id=ntop.id and nsi.span_port_id=sp.id and sp.switch_id=sw.id";
    static final String SpanPortCleanSQL = "delete from span_port where id in (select span_port.id from span_port, switch, fabric where span_port.switch_id=switch.id and switch.fabric_id=fabric.id and fabric.fid=? and span_port.last_update_time  < ?)";
    static final String NtopSpanInfoCleanSQL = "delete from ntop_span_info where id in (select ntop_span_info.id from ntop_span_info, span_port, switch, fabric where ntop_span_info.span_port_id=span_port.id and span_port.switch_id=switch.id and switch.fabric_id=fabric.id and fabric.fid=? and ntop_span_info.last_update_time  < ?)";
    static final String SpanSessionCleanSQL = "delete from span_session where id in (select span_session.id from span_session, span_port, switch, fabric where span_session.span_port_id=span_port.id and span_port.switch_id=switch.id and switch.fabric_id=fabric.id and fabric.fid=? and span_session.last_update_time  < ?)";
    static final String SpanSourcePortCleanSQL = "delete from span_source_port where id in (select span_source_port.id from span_source_port, span_session, span_port, switch, fabric where span_source_port.session_id=span_session.id and span_session.span_port_id=span_port.id and span_port.switch_id=switch.id and switch.fabric_id=fabric.id and fabric.fid=? and span_source_port.last_update_time  < ?)";

    public static void startTask() {
        NtopUpdateTask _task = new NtopUpdateTask(new Schedule(30000L));
        SchedulerSingleton.getInstance().addTask(_task);
    }

    public static synchronized void scanNtopSD(String search, int fabricId) throws Exception {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        Map spanBySwitchPort = NtopIntegrator.scanSD(fabricId);
        if (spanBySwitchPort.size() > 0) {
            NtopIntegrator.cleanFabricObject(fabricId, ts);
        }
    }

    public static HashMap scanNtop(String search) throws Exception {
        NtopWorker nsweep = new NtopWorker();
        HashMap ntopBySWwwnSDIndex = nsweep.search(search);
        for (NtopImpl ntop : ntopBySWwwnSDIndex.values()) {
            InventoryPersistentManager.getInstance().persistDBObject(ntop);
            Iterator spit = ntop.getSpanInfos().iterator();
            while (spit.hasNext()) {
                try {
                    SpanInfo si = (SpanInfo)spit.next();
                    byte[] ip = InetAddress.getByName(si._swWwn).getAddress();
                    ArrayList al = SpanPortImpl.searchFromDBBySwitchIpIfIndex(ip, si._spIndex);
                    if (al.size() <= 0) continue;
                    for (int i = 0; i < al.size(); ++i) {
                        SpanPortImpl spImpl = (SpanPortImpl)al.get(i);
                        NtopSpanInfoImpl nsImpl = new NtopSpanInfoImpl(spImpl, ntop, si);
                        InventoryPersistentManager.getInstance().persistDBObject(nsImpl);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return ntopBySWwwnSDIndex;
    }

    public static Map scanSD(int fabricId) throws Exception {
        FabricImpl fImpl = NtopIntegrator.findFabric(fabricId);
        SpanWorker sw = new SpanWorker(fImpl);
        Map spanBySwitchPort = sw.discoverSpan();
        for (Object key : spanBySwitchPort.keySet()) {
            SpanPortImpl spImpl = (SpanPortImpl)spanBySwitchPort.get(key);
            InventoryPersistentManager.getInstance().persistDBObject(spImpl);
            ArrayList spanSessions = spImpl.getSpanSessions();
            for (int i = 0; i < spanSessions.size(); ++i) {
                SpanSessionImpl ssImpl = (SpanSessionImpl)spanSessions.get(i);
                InventoryPersistentManager.getInstance().persistDBObject(ssImpl);
                ArrayList spanSources = ssImpl.getSpanSourcePorts();
                for (int j = 0; j < spanSources.size(); ++j) {
                    SpanSourcePortImpl sspImpl = (SpanSourcePortImpl)spanSources.get(j);
                    InventoryPersistentManager.getInstance().persistDBObject(sspImpl);
                }
            }
        }
        return spanBySwitchPort;
    }

    private static void cleanObject(int fid, Timestamp ts, Connection con, String sql) throws DBException, SQLException {
        PreparedStatement ps = null;
        try {
            con = ConnectionManager.getConnection();
            ps = con.prepareStatement(sql);
            if (ps != null) {
                ps.setInt(1, fid);
                ps.setTimestamp(2, ts);
                ps.execute();
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null) {
                try {
                    ConnectionManager.returnConnection(con);
                }
                catch (Exception ex) {}
            }
        }
    }

    private static void cleanFabricObject(int fid, Timestamp ts) throws DBException, SQLException {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            NtopIntegrator.cleanObject(fid, ts, con, NtopSpanInfoCleanSQL);
            NtopIntegrator.cleanObject(fid, ts, con, SpanSourcePortCleanSQL);
            NtopIntegrator.cleanObject(fid, ts, con, SpanSessionCleanSQL);
            NtopIntegrator.cleanObject(fid, ts, con, SpanPortCleanSQL);
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            if (con != null) {
                try {
                    ConnectionManager.returnConnection(con);
                }
                catch (Exception ex) {}
            }
        }
    }

    public static void updateNtopEndPortInfo() throws SQLException {
        StringBuffer sb = new StringBuffer();
        ArrayList al = NtopIntegrator.searchNtopSwitchInfo();
        boolean hasData = false;
        HashMap<String, String> h = new HashMap<String, String>();
        byte[] fcids = new byte[3];
        for (int i = 0; i < al.size(); ++i) {
            VsanImpl[] vs;
            String key;
            NtopSwitchInfo nsi = (NtopSwitchInfo)al.get(i);
            FabricImpl fi = SanManager.getInstance().findFabric(nsi._swIp);
            if (fi == null || h.get(key = fi.getPK().toString() + nsi._ntopIp.getHostAddress()) != null || (vs = fi.getVsans()) == null) continue;
            for (int j = 0; j < vs.length; ++j) {
                List<EndPortImpl> eps = vs[j].getEndPorts();
                Iterator it = eps.iterator();
                while (it.hasNext()) {
                    hasData = true;
                    EndPortImpl epi = (EndPortImpl)it.next();
                    int fcid = epi.getFcId(vs[j].getId());
                    fcids[2] = (byte)(fcid & 0xFF);
                    fcids[1] = (byte)(fcid >> 8 & 0xFF);
                    fcids[0] = (byte)(fcid >> 16 & 0xFF);
                    String fcidstr = SnmpString.toHexString(fcids, 0, 3, false);
                    String pwwn = SnmpString.toHexString(epi.getPortWwn().getValue(), 0, epi.getPortWwn().getValue().length, false);
                    String nwwn = SnmpString.toHexString(epi.getNodeWwn().getValue(), 0, epi.getNodeWwn().getValue().length, false);
                    String name = epi.getSymNodeName() == null ? "" : epi.getSymNodeName();
                    sb.append("<+>,<VSAN|\"" + vs[j].getId() + "\">,<FC_ID|\"" + fcidstr + "\">,<PWWN|\"" + pwwn + "\">,<NWWN|\"" + nwwn + "\">,<Symbolic Name|\"" + name + "\">\n");
                }
            }
            try {
                if (hasData) {
                    NetUtil.putHtml(nsi._ntopIp.getHostAddress(), nsi._port, "configFcWWNMap.html", sb.toString());
                }
                h.put(key, key);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList searchNtopSwitchInfo() throws SQLException {
        ArrayList<NtopSwitchInfo> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySwitchIpSQL);
            rs = stat.executeQuery();
            ArrayList<NtopSwitchInfo> al = new ArrayList<NtopSwitchInfo>();
            while (rs.next()) {
                try {
                    NtopSwitchInfo nsi = new NtopSwitchInfo();
                    nsi._swIp = InetAddress.getByAddress(rs.getBytes(1));
                    nsi._ntopIp = InetAddress.getByName(rs.getString(2));
                    nsi._port = rs.getInt(3);
                    al.add(nsi);
                }
                catch (UnknownHostException ex) {
                    System.out.println("Unknown ip address error: " + ex.getMessage());
                }
            }
            arrayList = al;
        }
        catch (SQLException ex) {
            ArrayList arrayList2;
            try {
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static void main(String[] args) {
        try {
            NtopIntegrator.scanNtopSD(args[0], 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static FabricImpl findFabric(int id) throws Exception {
        FabricImpl fabric = null;
        try {
            FabricPK pkey = new FabricPK(id);
            fabric = SanManager.getInstance().findFabric(pkey);
        }
        catch (NumberFormatException nfex) {
            System.out.println("NtopIntegrator: find fabric error :" + nfex.getMessage());
        }
        if (fabric == null) {
            throw new Exception("Fabric \"" + id + "\" is an invalid ID or not opened");
        }
        return fabric;
    }
}

