/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ps;

import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.rif.PortSecurityRif;
import com.cisco.dcbu.sm.server.ps.PSBase;

public class PSAutoLearn
extends PSBase
implements StatusIf {
    static final MibEnum[] PSM_ACTIVATE_RESULT_ENUM = MibNode.get("cpsmPortBindResult").getEnums();
    protected static PSAutoLearn repInstance;
    private static final int ACTIVATE = 1;
    private static final int ACTIVATE_COMMIT = 2;
    private static final int AUTOLEARN_COMMIT = 3;
    private static final int AUTOLEARN_OFF_COMMIT = 4;
    private static final int COPY_ACTIVE_COMMIT = 5;
    private String masterSw;
    private int vsanId;
    SnmpUserOpt userOpt;
    boolean autoLearnProcessSuccess;
    private static int state;

    protected PSAutoLearn() {
    }

    public static PSAutoLearn getInstance() {
        if (repInstance == null) {
            repInstance = new PSAutoLearn();
        }
        return repInstance;
    }

    public static PSAutoLearn newInstance() {
        return new PSAutoLearn();
    }

    public void runAutoLearnProcedure(String masterSw, SnmpUserOpt userOpt, int vsanId) throws SnmpException {
        state = 0;
        this.masterSw = masterSw;
        this.vsanId = vsanId;
        this.userOpt = userOpt;
        this.autoLearnProcessSuccess = false;
        this.setStatus(" ");
        _Logger.info((Object)"Port Security Wizard:Start running full Auto Learn operation...");
        this.activate();
    }

    public void autoLearn(String sw, SnmpUserOpt userOpt, boolean enable, int vsan) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cpsmPortBindAutoLearnEnable").getOid(), new int[]{1, vsan}, (SnmpVar)new SnmpInt(enable ? 1 : 2));
        _Logger.info((Object)("Port Security Wizard:Setting Auto Learn on " + sw + " to " + Boolean.toString(enable) + "..."));
        this.setStatus("Setting Auto Learn on " + sw + " to " + Boolean.toString(enable) + "...");
        SnmpFetch.set(PSAutoLearn.generatePeer(sw, userOpt), this.buildPSMPDU((byte)-93, vbl));
    }

    public boolean isAutoLearnEnabled(String sw, SnmpUserOpt userOpt, int vsan) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cpsmPortBindAutoLearnEnable").getOid(), new int[]{1, vsan});
        return PSAutoLearn.generatePeer(sw, userOpt).send(this.buildPSMPDU((byte)-96, vbl)).getVariables().intValue(0) == 1;
    }

    public boolean isPSActive(String sw, SnmpUserOpt userOpt, int vsan) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cpsmPortBindActState").getOid(), new int[]{1, vsan});
        return PSAutoLearn.generatePeer(sw, userOpt).send(this.buildPSMPDU((byte)-96, vbl)).getVariables().intValue(0) == 1;
    }

    public void copyPortSecurityActiveToLocal(String sw, SnmpUserOpt userOpt, int[] cfsIndex, int[] scope) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cpsmPortBindCopyActToConfig").getOid(), scope, (SnmpVar)new SnmpInt(1));
        this.readFromVbl(vbl, false, this.getCfsIndex(sw));
        _Logger.info((Object)("Port Security Wizard:Start copy Active to Local DB on " + sw + " for VSAN " + scope[1] + "..."));
        this.setStatus("Start copy Active to Local DB on " + sw + " for VSAN " + scope[1] + "...");
        SnmpFetch.set(PSAutoLearn.generatePeer(sw, userOpt), this.buildPSMPDU((byte)-93, vbl));
    }

    public void activatePortSecurityDb(String sw, int[] cfsIndex, int[] scope, SnmpUserOpt userOpt, boolean withAutoLearn) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cpsmPortBindActivate").getOid(), scope, (SnmpVar)new SnmpInt(withAutoLearn ? 1 : 4));
        this.readFromVbl(vbl, false, this.getCfsIndex(sw));
        _Logger.info((Object)("Port Security Wizard:Activate Port Security DB on " + sw + " for VSAN " + scope[1] + "..."));
        this.setStatus("Activate Port Security DB on " + sw + " for VSAN " + scope[1] + "...");
        SnmpFetch.set(PSAutoLearn.generatePeer(sw, userOpt), this.buildPSMPDU((byte)-93, vbl));
    }

    public int getPortSecurityActivateResult(String sw, int[] scope, SnmpUserOpt userOpt) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cpsmPortBindResult").getOid(), scope);
        int actRes = PSAutoLearn.generatePeer(sw, userOpt).send(this.buildPSMPDU((byte)-96, vbl)).getVariables().intValue(0);
        _Logger.info((Object)("Port Security Wizard:Port Security Activate state on " + sw + " for VSAN " + scope[1] + " is " + actRes + "..."));
        this.setStatus("Port Security Activate state on " + sw + " for VSAN " + scope[1] + " is " + actRes + "...");
        return actRes;
    }

    private void activate() throws SnmpException {
        boolean activateNeeded;
        this.setReadFrom(this.masterSw, true, (int[])PortSecurityRif.FEATURE_TABLE[0][1], this.userOpt);
        boolean bl = activateNeeded = !this.isPSActive(this.masterSw, this.userOpt, this.vsanId);
        if (activateNeeded) {
            this.setStatus(this.masterSw + ":Activate local database...");
            this.activatePortSecurityDb(this.masterSw, (int[])PortSecurityRif.FEATURE_TABLE[0][1], new int[]{1, this.vsanId}, this.userOpt, true);
            state = 1;
            int resultVal = this.getPortSecurityActivateResult(this.masterSw, new int[]{1, this.vsanId}, this.userOpt);
            if (resultVal > 1) {
                throw new SnmpException("Activation failed on " + this.masterSw + "\n" + MibEnum.getLabel(PSM_ACTIVATE_RESULT_ENUM, resultVal));
            }
            state = 2;
            this.startCommit(this.masterSw, this.userOpt, (int[])PortSecurityRif.FEATURE_TABLE[0][1], new int[]{2, this.vsanId}, "Activate database...", 4);
        } else {
            state = 2;
            this.actionFinished();
        }
    }

    private void autoLearn(boolean enable) throws SnmpException {
        boolean autoLearn = this.isAutoLearnEnabled(this.masterSw, this.userOpt, this.vsanId);
        if (!enable && autoLearn || enable && !autoLearn) {
            this.setStatus(this.masterSw + ":Autolearn already logged in devices...");
            this.setReadFrom(this.masterSw, false, (int[])PortSecurityRif.FEATURE_TABLE[0][1], this.userOpt);
            ++state;
            this.autoLearn(this.masterSw, this.userOpt, enable, this.vsanId);
            this.startCommit(this.masterSw, this.userOpt, (int[])PortSecurityRif.FEATURE_TABLE[0][1], new int[]{2, this.vsanId}, "AutoLearn Port Security Database...", 4);
        } else {
            state = enable ? 3 : 4;
            this.actionFinished();
        }
    }

    private void copyActiveToLocal() throws SnmpException {
        this.setStatus(this.masterSw + ":Copy Active Database to Local...");
        this.copyPortSecurityActiveToLocal(this.masterSw, this.userOpt, (int[])PortSecurityRif.FEATURE_TABLE[0][1], new int[]{1, this.vsanId});
        ++state;
        this.startCommit(this.masterSw, this.userOpt, (int[])PortSecurityRif.FEATURE_TABLE[0][1], new int[]{2, this.vsanId}, "Copy Active Port Security Database to Local...", 4);
    }

    @Override
    public void actionFinished() {
        if (this.stopAction) {
            this.lastActionSuccess = false;
            this.errorException = null;
            return;
        }
        this.lastActionSuccess = true;
        try {
            switch (state) {
                case 2: {
                    this.autoLearn(true);
                    break;
                }
                case 3: {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exx) {
                        // empty catch block
                    }
                    this.autoLearn(false);
                    break;
                }
                case 4: {
                    this.lastActionSuccess = false;
                    this.copyActiveToLocal();
                    break;
                }
                case 5: {
                    this.autoLearnProcessSuccess = true;
                    break;
                }
                default: {
                    return;
                }
            }
            this.setReadFrom(this.masterSw, true, (int[])PortSecurityRif.FEATURE_TABLE[0][1], this.userOpt);
            super.actionFinished();
        }
        catch (Exception ex) {
            _Logger.info((Object)("Port Security Wizard:Error in operation " + ex.getMessage()));
            this.errorException = new Exception[]{ex};
        }
    }

    public boolean isAutoLearnProcessSuccess() {
        return this.autoLearnProcessSuccess;
    }
}

