/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.se.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.se.SESshMediatorPdu;
import com.cisco.dcbu.sm.server.se.pdu.SeLunDiscoveryData;
import com.cisco.dcbu.sm.server.se.pdu.SeTarget;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class SeTargetDiscoveryData
implements SESshMediatorPdu {
    private SeTarget m_target;
    private int m_lun_count;
    private List m_lun_list;

    public void setTarget(SeTarget target) {
        this.m_target = target;
    }

    public SeTarget getTarget() {
        return this.m_target;
    }

    public void setLunCount(int lun_count) {
        this.m_lun_count = lun_count;
    }

    public int getLunCount() {
        return this.m_lun_count;
    }

    public void setLunList(List lun_list) {
        this.m_lun_list = lun_list;
    }

    public List getLunList() {
        return this.m_lun_list;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_target.toByteArray());
        SshMediatorHelper.writeInt(stream, this.m_lun_count, 4);
        for (int i = 0; i < this.m_lun_list.size(); ++i) {
            SeLunDiscoveryData obj = (SeLunDiscoveryData)this.m_lun_list.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_target = new SeTarget();
        this.m_target.fromByteArray(stream);
        this.m_lun_count = SshMediatorHelper.readInt(stream, 4);
        this.m_lun_list = new ArrayList();
        for (int i = 0; i < this.m_lun_count; ++i) {
            SeLunDiscoveryData obj = new SeLunDiscoveryData();
            obj.fromByteArray(stream);
            this.m_lun_list.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(SeTargetDiscoveryData:");
        buf.append("m_lun_count:" + this.m_lun_count + ":");
        buf.append("m_lun_list:");
        for (int i = 0; i < this.m_lun_list.size(); ++i) {
            buf.append(":" + this.m_lun_list.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

