/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.security.CryptoHelper;
import com.cisco.dcbu.sm.common.security.RoleType;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.FMUserFailedAttempts;
import com.cisco.dcbu.sm.server.security.UMUtil;
import com.cisco.dcbu.sm.server.security.UserFabricImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class DCNMUserImpl
extends AbstractDBObjectImpl {
    public static Logger _Logger = LogManager.getLogger((String)"fms.dcnmuser");
    private static Random _RandomGen = new Random();
    final FMUser _user;
    static final String QuerySQLByUser = "select id, userid, password, role, salt from dcnmuser where userid=?";
    static final String QuerySQLById = "select id, userid, password, role, salt from dcnmuser where id=?";
    static final String QuerySQLByRole = "select id, version from dcnmuser where role = ?";
    static final String QueryVersionSQLByUserID = "select version from dcnmuser where userid = ?";
    static final String InsertSQL = "insert into dcnmuser(id, version, userid, password, role, salt) values(?,0,?,?,?,?)";
    static final String UpdateUserSQL = "update dcnmuser set password=? where userid=? and password <> ?";
    static final String UpdateVersionById = "update dcnmuser set version= ? where id = ?";
    static final String UpdateVersionByUserId = "update dcnmuser set version = ? where userid = ?";
    static final String GetAllUsersSQL = "select u.userid, u.password, u.role, u.salt from dcnmuser u";
    static final String GetUsersSQL = "select u.userid, u.password, u.role, u.salt from dcnmuser u where u.userid=?";
    static final String GetSalt = "select salt from dcnmuser where userid = ?";
    static final String DeleteSQL = "delete from dcnmuser where userid=?";
    static final String UpdateRoleToBasic = "update dcnmuser set role='basic' where role = ? and id = ?";
    static final String UpdateRoleforUser = "update dcnmuser set role=? where userid=? and role <> ?";
    static final String TableName = "dcnmuser";

    public DCNMUserImpl(FMUser user) {
        this._user = user;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByUser);
            this.setupCheckExistenceStatement(stat);
            rs = stat.executeQuery();
            if (rs.next()) {
                this.setDBID(rs.getLong(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new SQLException(ex2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalUserExist(String userName) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        boolean result = false;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByUser);
            stat.setString(1, userName);
            rs = stat.executeQuery();
            if (rs.next()) {
                result = true;
            }
            bl = result;
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new SQLException(ex2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteUser(String userName, String userInCharge) {
        Connection con = null;
        PreparedStatement deleteSate = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            deleteSate = con.prepareStatement(DeleteSQL);
            deleteSate.setString(1, userName);
            deleteSate.executeUpdate();
            UserFabricImpl.deleteUserFabricInfo(userName);
            if (userInCharge != null && !userInCharge.isEmpty()) {
                UMUtil.logAuthentication("User: " + userName + " is deleted from DB", userInCharge);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            _Logger.error((Object)e.getMessage());
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(deleteSate);
            DbUtil.close(con);
        }
        return false;
    }

    public static int insertUser(String userName, String authPassword) {
        return DCNMUserImpl.insertUser(userName, authPassword, RoleType.ROLE_ADMIN.value(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int insertUser(String userName, String authPassword, String roleName, String userInCharge) {
        int salt222222;
        Connection con = null;
        PreparedStatement queryStat = null;
        PreparedStatement insertStat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            queryStat = con.prepareStatement(QuerySQLByUser);
            queryStat.setString(1, userName);
            rs = queryStat.executeQuery();
            if (!rs.next()) {
                int salt222222 = _RandomGen.nextInt();
                insertStat = con.prepareStatement(InsertSQL);
                insertStat.setLong(1, Sequence.getSequence().getPK());
                insertStat.setString(2, userName);
                insertStat.setString(3, DCNMUserImpl.convertSPWD(authPassword, salt222222));
                insertStat.setString(4, roleName);
                insertStat.setInt(5, salt222222);
                insertStat.execute();
                if (userInCharge != null && !userInCharge.isEmpty()) {
                    UMUtil.logAuthentication("User: " + userName + " is created with role as: " + roleName, userInCharge);
                }
                int n = 1;
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                DbUtil.close(insertStat);
                DbUtil.close(con);
                return n;
            }
            salt222222 = 0;
            DbUtil.close(rs);
        }
        catch (SQLException e1) {
            _Logger.trace((Object)e1.getMessage());
            int n = -1;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                _Logger.trace((Object)e2.getMessage());
                int n2 = -1;
                return n2;
            }
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            DbUtil.close(insertStat);
            DbUtil.close(con);
        }
        DbUtil.close(queryStat);
        DbUtil.close(insertStat);
        DbUtil.close(con);
        return salt222222;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean updateRoleToBasic(String role) {
        ResultSet rs;
        PreparedStatement stat2;
        PreparedStatement stat1;
        PreparedStatement stat;
        Connection con;
        block25: {
            con = null;
            stat = null;
            stat1 = null;
            stat2 = null;
            rs = null;
            if (role != null && !role.equalsIgnoreCase("basic")) break block25;
            boolean bl = false;
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(stat1);
            DbUtil.close(stat2);
            DbUtil.close(con);
            return bl;
        }
        con = ConnectionManager.getConnection();
        stat = con.prepareStatement(QuerySQLByRole);
        stat.setString(1, role);
        rs = stat.executeQuery();
        while (rs.next()) {
            long id = rs.getLong(1);
            long version = rs.getLong(2);
            try {
                con.setAutoCommit(false);
                stat1 = con.prepareStatement(UpdateRoleToBasic);
                stat1.setString(1, role);
                stat1.setLong(2, id);
                int count = stat1.executeUpdate();
                if (count > 0) {
                    stat2 = con.prepareStatement(UpdateVersionById);
                    stat2.setLong(1, version + 1L);
                    stat2.setLong(2, id);
                    stat2.executeUpdate();
                }
                con.commit();
            }
            catch (SQLException e) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    _Logger.trace((Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    DbUtil.close(stat2);
                    DbUtil.close(stat1);
                    throw throwable;
                }
                DbUtil.close(stat2);
                DbUtil.close(stat1);
                continue;
            }
            DbUtil.close(stat2);
            DbUtil.close(stat1);
        }
        boolean id = true;
        try {
            if (con != null) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(stat1);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return id;
        catch (Exception e) {
            boolean bl;
            try {
                _Logger.trace((Object)e.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        con.setAutoCommit(true);
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(stat1);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e3) {
                // empty catch block
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(stat1);
            DbUtil.close(stat2);
            DbUtil.close(con);
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean updateRoleForUser(String role, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean updateUser(String userName, String authPassword) {
        Connection con = null;
        PreparedStatement stat = null;
        PreparedStatement stat1 = null;
        PreparedStatement stat2 = null;
        ResultSet rs = null;
        int salt = DCNMUserImpl.getSalt(userName);
        String tmppwd = DCNMUserImpl.convertSPWD(authPassword, salt);
        con = ConnectionManager.getConnection();
        con.setAutoCommit(false);
        stat = con.prepareStatement(UpdateUserSQL);
        stat.setString(1, tmppwd);
        stat.setString(2, userName);
        stat.setString(3, tmppwd);
        int count = stat.executeUpdate();
        if (count > 0) {
            stat1 = con.prepareStatement(QueryVersionSQLByUserID);
            stat1.setString(1, userName);
            rs = stat1.executeQuery();
            while (rs.next()) {
                long version = rs.getLong(1) + 1L;
                stat2 = con.prepareStatement(UpdateVersionByUserId);
                stat2.setLong(1, version);
                stat2.setString(2, userName);
                stat2.executeUpdate();
                DbUtil.close(stat2);
            }
        }
        con.commit();
        boolean bl = true;
        try {
            if (con != null) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(stat1);
        DbUtil.close(stat2);
        DbUtil.close(con);
        return bl;
        catch (Exception e) {
            boolean bl2;
            try {
                try {
                    con.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                _Logger.trace((Object)e.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        con.setAutoCommit(true);
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(stat1);
                DbUtil.close(stat2);
                DbUtil.close(con);
                throw throwable;
            }
            try {
                if (con != null) {
                    con.setAutoCommit(true);
                }
            }
            catch (SQLException e3) {
                // empty catch block
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(stat1);
            DbUtil.close(stat2);
            DbUtil.close(con);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMUserBase getFMUserBase(String userName) throws SQLException {
        FMUserBase fMUserBase;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GetUsersSQL);
            stat.setString(1, userName);
            rs = stat.executeQuery();
            ArrayList<FMUserBase> al = DCNMUserImpl.loadFMUserBaseDBRecord(rs);
            fMUserBase = al.size() == 0 ? null : al.get(0);
            DbUtil.close(rs);
        }
        catch (Exception e) {
            _Logger.trace((Object)e.getMessage());
            FMUserBase fMUserBase2 = null;
            return fMUserBase2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return fMUserBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FMUserBase getFMUserBase(String userName, String auth_passWord) {
        FMUserBase fMUserBase;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block8: {
            FMUserBase fMUserBase2;
            block7: {
                con = null;
                stat = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(GetUsersSQL);
                    stat.setString(1, userName);
                    rs = stat.executeQuery();
                    if (!rs.next() || !DCNMUserImpl.sconvertPWD(rs.getString(2), rs.getInt(4)).equals(auth_passWord)) {
                        fMUserBase2 = null;
                        DbUtil.close(rs);
                        break block7;
                    }
                    ArrayList<FMUserBase> al = DCNMUserImpl.loadFMUserBaseDBRecord(rs);
                    fMUserBase = al.size() == 0 ? null : al.get(0);
                    DbUtil.close(rs);
                    break block8;
                }
                catch (Exception e) {
                    _Logger.trace((Object)e.getMessage());
                    FMUserBase fMUserBase3 = null;
                    return fMUserBase3;
                }
            }
            DbUtil.close(stat);
            DbUtil.close(con);
            return fMUserBase2;
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return fMUserBase;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FMUserBase> getAllUsers() {
        ArrayList<FMUserBase> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GetAllUsersSQL);
            rs = stat.executeQuery();
            ArrayList<FMUserBase> al = DCNMUserImpl.filterRemoteUser(DCNMUserImpl.loadFMUserBaseDBRecord(rs));
            arrayList = al.size() == 0 ? null : al;
        }
        catch (SQLException e) {
            ArrayList<FMUserBase> arrayList2;
            try {
                _Logger.warn((Object)e.getMessage(), (Throwable)e);
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMUser loadFromDB(long id) throws SQLException {
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLById);
            stat.setLong(1, id);
            rs = stat.executeQuery();
            ArrayList<FMUser> al = DCNMUserImpl.loadDBRecord(rs);
            FMUser fMUser = al.size() == 0 ? null : al.get(0);
            return fMUser;
        }
        catch (SQLException ex) {
            FMUser fMUser = null;
            return fMUser;
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (rs != null) {
                    rs.close();
                }
                if (stat != null) {
                    stat.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMUser loadFromDB(String userName) throws SQLException {
        Connection con = null;
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            queryStat = con.prepareStatement(QuerySQLByUser);
            queryStat.setString(1, userName);
            rs = queryStat.executeQuery();
            ArrayList<FMUser> al = DCNMUserImpl.loadDBRecord(rs);
            FMUser fMUser = al.size() == 0 ? null : al.get(0);
            return fMUser;
        }
        catch (SQLException ex) {
            FMUser fMUser = null;
            return fMUser;
        }
        catch (Exception e2) {
            _Logger.trace((Object)e2.getMessage());
            FMUser fMUser = null;
            return fMUser;
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (rs != null) {
                    rs.close();
                }
                if (queryStat != null) {
                    queryStat.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static ArrayList<FMUser> loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<FMUser> al = new ArrayList<FMUser>();
        while (rs.next()) {
            FMUser user = null;
            try {
                int salt = rs.getInt(5);
                user = new FMUser(rs.getLong(1), rs.getString(2), DCNMUserImpl.sconvertPWD(rs.getString(3), salt), rs.getString(4));
                user.setSnmpUsers(UserFabricImpl.loadFromDB(user.getUserName()));
            }
            catch (Exception e) {
                _Logger.trace((Object)e.getMessage());
                continue;
            }
            al.add(user);
        }
        return al;
    }

    public static ArrayList<FMUserBase> loadFMUserBaseDBRecord(ResultSet rs) throws SQLException {
        ArrayList<FMUserBase> al = new ArrayList<FMUserBase>();
        String userName = null;
        while (rs.next()) {
            FMUserBase user = null;
            try {
                userName = rs.getString(1);
                user = new FMUserBase(userName, DCNMUserImpl.sconvertPWD(rs.getString(2), rs.getInt(4)), rs.getString(3));
                user.setFailedAttempts(FMUserFailedAttempts.getInstance().getUserFailedAttempts(userName));
            }
            catch (Exception e) {
                _Logger.warn((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            al.add(user);
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMUser verifyUserInfo(String userName, String authPassword) {
        FMUser fMUser;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block10: {
            String pwdInDB;
            block9: {
                block8: {
                    con = null;
                    stat = null;
                    rs = null;
                    con = ConnectionManager.getConnection();
                    stat = con.prepareStatement(QuerySQLByUser, 1004, 1007);
                    stat.setString(1, userName);
                    rs = stat.executeQuery();
                    if (rs.next()) break block8;
                    FMUser fMUser2 = null;
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    return fMUser2;
                }
                pwdInDB = rs.getString(3);
                if (pwdInDB != null) break block9;
                FMUser fMUser3 = null;
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return fMUser3;
            }
            String tmppwd = DCNMUserImpl.convertSPWD(authPassword, rs.getInt(5));
            if (pwdInDB.equals(tmppwd)) break block10;
            if (pwdInDB.equals(CryptoHelper.INSTANCE.encrypt(StringEncrypter.DESedeDecrypt(authPassword)))) {
                DCNMUserImpl.updateUser(userName, authPassword);
                break block10;
            }
            FMUser fMUser4 = null;
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return fMUser4;
        }
        try {
            rs.close();
            stat.setString(1, userName);
            rs = stat.executeQuery();
            ArrayList<FMUser> al = DCNMUserImpl.loadDBRecord(rs);
            fMUser = al.size() == 0 ? null : al.get(0);
        }
        catch (Exception e) {
            FMUser fMUser5;
            try {
                _Logger.trace((Object)e.getMessage());
                fMUser5 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return fMUser5;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return fMUser;
    }

    private static int getSalt(String userName) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        int salt = 0;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(GetSalt);
            stat.setString(1, userName);
            rs = stat.executeQuery();
            while (rs.next()) {
                salt = rs.getInt(1);
            }
            n = salt;
        }
        catch (SQLException ex) {
            try {
                _Logger.warn((Object)ex.getMessage());
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return n;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByUser;
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws Exception {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._user.getUserName());
    }

    private static ArrayList<FMUserBase> filterRemoteUser(ArrayList<FMUserBase> al) {
        ArrayList<FMUserBase> localUsers = new ArrayList<FMUserBase>();
        for (int i = 0; i < al.size(); ++i) {
            FMUserBase user = al.get(i);
            if (user.getUsername().indexOf(64) != -1) continue;
            localUsers.add(user);
        }
        return localUsers;
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    private static String convertSPWD(String authpwd, int salt) throws Exception {
        String tmp = StringEncrypter.DESedeDecrypt(authpwd);
        return StringEncrypter.DESedeEncrypt(tmp, salt);
    }

    private static String sconvertPWD(String spwd, int salt) throws Exception {
        String tmp = StringEncrypter.DESedeDecrypt(spwd, salt);
        return StringEncrypter.DESedeEncrypt(tmp);
    }

    public static void main(String[] strArgs) {
        try {
            DCNMUserImpl.verifyUserInfo("admin10", StringEncrypter.DESedeEncrypt("admin1"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

