/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.security.RoleImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public final class RoleFabricImpl {
    public static Logger _Logger = Logger.getLogger((String)RoleFabricImpl.class.getName());
    static final String QuerySQLByRoleName = "select 1 from role_fabric_info where role_name=?";
    static final String QuerySQL = "select rf.fabric_id, f.name from role_fabric_info rf left join fabric f  on (f.fid = rf.fabric_id) where rf.role_name=?";
    static final String InsertSQL = "insert into role_fabric_info(role_name, fabric_id, last_update_time) values(?,?,?)";
    static final String DeleteSQL = "delete from role_fabric_info where role_name=?";
    static final String TableName = "role_fabric_info";
    final String _role;
    final long _fabricID;

    public RoleFabricImpl(String role, long fabricID) {
        this._role = role;
        this._fabricID = fabricID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPreexistRecord(Connection con) throws SQLException {
        boolean status;
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            status = false;
            try {
                stat = con.prepareStatement(QuerySQLByRoleName);
                stat.setString(1, this._role);
                rs = stat.executeQuery();
                if (rs.next()) {
                    status = true;
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _Logger.info((Object)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteRole(String role) {
        ResultSet rs;
        PreparedStatement deleteStat;
        PreparedStatement queryStat;
        Connection con;
        block7: {
            boolean bl;
            block6: {
                con = null;
                queryStat = null;
                deleteStat = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    queryStat = con.prepareStatement(QuerySQLByRoleName);
                    queryStat.setString(1, role);
                    rs = queryStat.executeQuery();
                    if (rs.next()) {
                        con = ConnectionManager.getConnection();
                        deleteStat = con.prepareStatement(DeleteSQL);
                        deleteStat.setString(1, role);
                        deleteStat.executeUpdate();
                        bl = true;
                        DbUtil.close(rs);
                        break block6;
                    }
                    DbUtil.close(rs);
                    break block7;
                }
                catch (Exception e) {
                    _Logger.info((Object)e);
                    return false;
                }
            }
            DbUtil.close(queryStat);
            DbUtil.close(deleteStat);
            DbUtil.close(con);
            return bl;
        }
        DbUtil.close(queryStat);
        DbUtil.close(deleteStat);
        DbUtil.close(con);
        return false;
        finally {
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            DbUtil.close(deleteStat);
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMultiFabricsToRole(String roleName, ArrayList<Long> fabricIds) {
        boolean bl;
        if (fabricIds == null || fabricIds.isEmpty()) {
            return false;
        }
        Iterator<Long> it = fabricIds.iterator();
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(InsertSQL);
            while (it.hasNext()) {
                stat.setString(1, roleName);
                stat.setLong(2, it.next());
                stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                stat.execute();
            }
            bl = true;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                _Logger.error((Object)"addMultiFabricsToRole", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl2;
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFabricToRole(String roleName, long fabricID) {
        boolean bl;
        PreparedStatement stat;
        Connection con;
        block5: {
            con = null;
            stat = null;
            con = ConnectionManager.getConnection();
            if (RoleImpl.checkPreexistRecord(con, roleName)) break block5;
            boolean bl2 = false;
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl2;
        }
        try {
            stat = con.prepareStatement(InsertSQL);
            stat.setString(1, roleName);
            stat.setLong(2, fabricID);
            stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            stat.execute();
            bl = true;
        }
        catch (SQLException e) {
            boolean bl3;
            try {
                _Logger.trace((Object)e.getMessage());
                bl3 = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl3;
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<FabricPK> getAllFabrics(String role_name) {
        ArrayList<FabricPK> arrayList;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQL);
            stat.setString(1, role_name);
            rs = stat.executeQuery();
            ArrayList<FabricPK> al = new ArrayList<FabricPK>();
            FabricPK fabricPK = null;
            while (rs.next()) {
                fabricPK = new FabricPK(rs.getInt(1));
                fabricPK.setName(rs.getString(2));
                al.add(fabricPK);
            }
            arrayList = al.size() == 0 ? null : al;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            _Logger.trace((Object)ex.getMessage());
            ArrayList<FabricPK> arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public String getDBTableName() {
        return TableName;
    }
}

