/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UserEntry;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.LDAPAuthenticator;
import com.cisco.dcbu.sm.server.security.LocalAuthenticator;
import com.cisco.dcbu.sm.server.security.RadiusAuthenticator;
import com.cisco.dcbu.sm.server.security.ServerAuthenticatorIf;
import com.cisco.dcbu.sm.server.security.SwitchAuthenticator;
import com.cisco.dcbu.sm.server.security.TACACSAuthenticator;
import com.cisco.dcbu.sm.server.security.UMUtil;
import com.cisco.dcbu.sm.server.security.UserManager;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SecurityManager {
    public static Logger _Logger = LogManager.getLogger((String)"fms.security");
    private static final String SECRETKEY = "POsVwv6VBInSOtYQd9r2pFRsSe1cEeVFQuTvDfN7nJ55Qw8fMm5ZGvjmIr87GEF";
    private static final long _Timeout = 600000L;
    private static volatile SecurityManager _Instance;
    private AtomicBoolean _inited = new AtomicBoolean();
    private String _authMode = null;
    public static final String LOCAL_AUTH = "local";
    private volatile List<ServerAuthenticatorIf> _authenticators = new ArrayList<ServerAuthenticatorIf>(4);
    private Semaphore _sema = new Semaphore(1);

    private SecurityManager() {
    }

    private static String getTokenSeparator() {
        return System.getProperty("security.tokenSeparator", ".");
    }

    public static SecurityManager getInstance() {
        if (_Instance == null) {
            _Instance = new SecurityManager();
        }
        _Instance.init();
        return _Instance;
    }

    void init() {
        if (this._inited.get()) {
            return;
        }
        if (this._sema.tryAcquire() && !this._inited.get()) {
            this._authenticators.add(new LocalAuthenticator());
            this._authMode = System.getProperty("authentication.mode");
            if (this._authMode != null) {
                if (this._authMode.trim().equalsIgnoreCase("mds")) {
                    this._authenticators.add(0, new SwitchAuthenticator());
                } else if (this._authMode.trim().equalsIgnoreCase("radius")) {
                    this._authenticators.add(0, new RadiusAuthenticator());
                } else if (this._authMode.trim().equalsIgnoreCase("tacacs")) {
                    this._authenticators.add(0, new TACACSAuthenticator());
                } else if (this._authMode.trim().equalsIgnoreCase("ldap")) {
                    this._authenticators.add(0, new LDAPAuthenticator());
                }
            }
            this._inited.set(true);
            this._sema.release();
        }
        _Logger.info((Object)("UserManager inited, auth mode: " + this._authenticators.get(0).getName()));
    }

    public void reinit() throws Exception {
        if (this._inited.get()) {
            this._authenticators.clear();
            this._inited.set(false);
        }
        this.init();
    }

    public FMUser authenticate(String userName, String authPassword) throws RemoteException {
        FMUser duser = null;
        for (ServerAuthenticatorIf auth : this._authenticators) {
            try {
                duser = auth.authenticate(userName, authPassword);
                break;
            }
            catch (Exception e) {
                if (!this._authMode.trim().equalsIgnoreCase(LOCAL_AUTH)) {
                    _Logger.info((Object)"falling to local DB for authentication");
                    continue;
                }
                UMUtil.logAuthentication("Login failed for the DCNM user: " + userName + ", with exception: " + e.getMessage(), userName);
                throw new RemoteException(e.getMessage());
            }
        }
        if (duser == null) {
            String desc = "Login failed for the DCNM user: " + userName;
            UMUtil.logAuthentication(desc, userName);
        }
        return duser;
    }

    public FMUser authenticateUser(String userName, String authPassword) throws RemoteException {
        FMUser duser = null;
        for (ServerAuthenticatorIf auth : this._authenticators) {
            try {
                duser = auth.authenticate(userName, authPassword);
                break;
            }
            catch (Exception e) {
                if (!this._authMode.trim().equalsIgnoreCase(LOCAL_AUTH)) {
                    _Logger.info((Object)"falling to local DB for authentication");
                    continue;
                }
                throw new RemoteException(e.getMessage());
            }
        }
        return duser;
    }

    public static boolean authenticate(String userName, int authProtocol, String authPassword, int privacyProtocol, String privacyPassword, InetAddress targetAdd) {
        try {
            UsmUser user = new UsmUser(userName, authProtocol, authPassword, privacyProtocol, privacyPassword);
            UserEntry.authenticate(user, targetAdd);
            return true;
        }
        catch (SnmpException e) {
            _Logger.info((Object)e.getMessage());
            return false;
        }
    }

    public static boolean authenticate(String userName, int authProtocol, String authPassword, InetAddress targetAdd) {
        return SecurityManager.authenticate(userName, authProtocol, authPassword, -1, null, targetAdd);
    }

    public static boolean authenticate(String communityUser, InetAddress targetAdd) {
        try {
            CommunityUser user = new CommunityUser(communityUser);
            UserEntry.authenticate(user, targetAdd);
            return true;
        }
        catch (SnmpException e) {
            _Logger.info((Object)e.getMessage());
            return false;
        }
    }

    public static UserEntry authenticate(SnmpUser snmpUser, FabricImpl fabric) throws SnmpException {
        SwitchImpl[] switches = fabric.getSwitches();
        SwitchImpl seedsw = fabric.getSeed();
        ArrayList<SwitchImpl> sws = new ArrayList<SwitchImpl>(switches.length);
        for (int i = 0; i < switches.length; ++i) {
            if (!switches[i].isMDS() || switches[i] == seedsw) continue;
            sws.add(switches[i]);
        }
        sws.add(0, seedsw);
        UserEntry entry = null;
        SnmpException sx = null;
        for (SwitchImpl sw : sws) {
            try {
                InetAddress addr = sw.getInetAddress();
                if (addr == null) continue;
                entry = UserEntry.authenticate(snmpUser, addr);
                break;
            }
            catch (SnmpException ex) {
                if (ex.getMessage().indexOf(SnmpException.toError(26)) != -1 || ex.getMessage().indexOf(SnmpException.toError(28)) != -1) break;
                sx = ex;
            }
        }
        if (entry == null) {
            throw sx != null ? sx : new SnmpException("authentication failed");
        }
        return entry;
    }

    public static String getSSOToken(String userName) throws Exception {
        long curSysTime = System.currentTimeMillis();
        String separator = SecurityManager.getTokenSeparator();
        if (userName == null || userName.length() == 0) {
            throw new Exception("user name is null or empty");
        }
        String ssoToken = "0" + separator + curSysTime + separator + SecurityManager.getMessageDigest("MD5", userName, 0, curSysTime) + separator + userName;
        return ssoToken;
    }

    public static String getSSOToken(String userName, long systime) throws Exception {
        String separator = SecurityManager.getTokenSeparator();
        if (userName == null || userName.length() == 0) {
            throw new Exception("user name is null or empty");
        }
        String ssoToken = "0" + separator + systime + separator + SecurityManager.getMessageDigest("MD5", userName, 0, systime) + separator + userName;
        return ssoToken;
    }

    public static String getSSOToken(String userName, int sessionId) throws Exception {
        long curSysTime = System.currentTimeMillis();
        String separator = SecurityManager.getTokenSeparator();
        if (userName == null || userName.length() == 0) {
            throw new Exception("user name is null or empty");
        }
        String ssoToken = sessionId + separator + curSysTime + separator + SecurityManager.getMessageDigest("MD5", userName, sessionId, curSysTime) + separator + userName;
        return ssoToken;
    }

    private static String getMessageDigest(String algorithm, String userName, int sessionid, long sysTime) throws Exception {
        String input = userName + sessionid + sysTime + SECRETKEY;
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(input.getBytes());
        return new String(Base64.encodeBase64((byte[])md.digest()));
    }

    public static FMUserBase verifySSoToken(String ssoToken) {
        String userName = null;
        FMUserBase fmUserBase = null;
        FMUser fmUser = null;
        try {
            userName = SecurityManager.getSSoTokenUserName(ssoToken);
            if (SecurityManager.confirmSSOToken(ssoToken)) {
                fmUser = UserManager.getInstance().findUser(userName);
                if (fmUser != null) {
                    fmUserBase = new FMUserBase(userName, fmUser.getHashedPwd(), fmUser.getRoles());
                }
                if (fmUserBase == null) {
                    fmUserBase = DCNMUserImpl.getFMUserBase(userName);
                }
                if (fmUserBase == null) {
                    fmUserBase = FMSessionManager.getInstance().getFMUser(SecurityManager.getSessionIdByToken(ssoToken));
                }
            }
        }
        catch (Exception ex) {
            _Logger.info((Object)"verifySSoToken: ", (Throwable)ex);
        }
        return fmUserBase;
    }

    private static String[] getSSoTokenDetails(String ssoToken) {
        String[] ret = new String[4];
        String separator = SecurityManager.getTokenSeparator();
        StringTokenizer st = new StringTokenizer(ssoToken, separator);
        if (st.hasMoreTokens()) {
            ret[0] = st.nextToken();
            ret[1] = st.nextToken();
            ret[2] = st.nextToken();
            ret[3] = st.nextToken();
            while (st.hasMoreTokens()) {
                ret[3] = ret[3] + separator + st.nextToken();
            }
        }
        return ret;
    }

    public static String getSSoTokenUserName(String ssoToken) {
        return SecurityManager.getSSoTokenDetails(ssoToken)[3];
    }

    public static boolean confirmSSOToken(String ssoToken) {
        String userName = null;
        int sessionId = 0;
        long sysTime = 0L;
        String digest = null;
        boolean count = false;
        boolean ret = false;
        try {
            String[] detail = SecurityManager.getSSoTokenDetails(ssoToken);
            userName = detail[3];
            sessionId = Integer.parseInt(detail[0]);
            sysTime = new Long(detail[1]);
            if (System.currentTimeMillis() - sysTime > 600000L) {
                return ret;
            }
            digest = detail[2];
            if (digest != null && digest.equals(SecurityManager.getMessageDigest("MD5", userName, sessionId, sysTime))) {
                ret = true;
            }
        }
        catch (Exception ex) {
            _Logger.info((Object)"confirmSSoToken: ", (Throwable)ex);
        }
        return ret;
    }

    public static int getSessionIdByToken(String ssoToken) {
        Object userName = null;
        int sessionId = 0;
        try {
            String[] detail = SecurityManager.getSSoTokenDetails(ssoToken);
            String separator = SecurityManager.getTokenSeparator();
            sessionId = Integer.parseInt(detail[0]);
        }
        catch (Exception ex) {
            _Logger.info((Object)"getSessionIdByToken: ", (Throwable)ex);
        }
        return sessionId;
    }

    public String getAuthMode() {
        return this._authMode;
    }

    public String formatUser(String uname) {
        String rstName = uname;
        String curAuthMode = this._authMode;
        if (!curAuthMode.equalsIgnoreCase(LOCAL_AUTH) && !uname.contains("@")) {
            rstName = uname + "@" + curAuthMode.toUpperCase();
        }
        return rstName;
    }

    public static void main(String[] strArgs) {
        try {
            String ssoToken = SecurityManager.getSSOToken("admin", 1);
            boolean ret = SecurityManager.confirmSSOToken(ssoToken);
            ssoToken = SecurityManager.getSSOToken("admin.test", 1);
            ret = SecurityManager.confirmSSOToken(ssoToken);
            ssoToken = SecurityManager.getSSOToken("admin");
            SecurityManager.verifySSoToken(ssoToken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

