/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class UserFabricImpl {
    public static Logger _Logger = Logger.getLogger((String)UserFabricImpl.class.getName());
    static final String QuerySQLByFMUserFabricId = "select fmuser_name, fabric_id, snmpuser_id from userfabric where fabric_id = ? and fmuser_name = ?";
    static final String QuerySQLByFMUser = "select userfabric.fabric_id, snmpuser.id, snmpuser.version, snmpuser.user_name, snmpuser.auth_password, snmpuser.priv_password, snmpuser.auth_protocol, snmpuser.priv_protocol, snmpuser.security_name, snmpuser.role_name, snmpuser.is_logging_in, snmpuser.last_update_time from userfabric, snmpuser where snmpuser.id = userfabric.snmpuser_id and userfabric.fmuser_name=? ";
    static final String QuerySnmpByFMUser = "select distinct snmpuser.version, snmpuser.user_name, snmpuser.auth_password, snmpuser.priv_password, snmpuser.auth_protocol, snmpuser.priv_protocol, snmpuser.security_name, snmpuser.role_name from userfabric, snmpuser where snmpuser.id = userfabric.snmpuser_id and userfabric.fmuser_name=? and userfabric.fabric_id=?";
    static final String QueryFMUser = "select fmuser_name from userfabric where fabric_id=?";
    static final String InsertSQL = "insert into userfabric(fmuser_name, fabric_id, snmpuser_id, last_update_time) values(?,?,?,?)";
    static final String UpdateSQL = "update userfabric set snmpuser_id=?, last_update_time=? where fmuser_name=? and fabric_id=?";
    static final String DeleteSQL = "delete from userfabric where fmuser_name=?";
    static final String TableName = "userfabric";
    final String _fmUserName;
    final long _fabricDBID;
    final long _snmpUserDBID;

    public UserFabricImpl(String fmUserName, long fabricDBID, SnmpUserImpl snmpUser) {
        this._fmUserName = SecurityManager.getInstance().formatUser(fmUserName);
        this._fabricDBID = fabricDBID;
        this._snmpUserDBID = snmpUser.getDBID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPreexistRecord(Connection con) throws SQLException {
        boolean status;
        block7: {
            if (this._fmUserName == null || this._fabricDBID == 0L) {
                throw new SQLException("usr name or fabric id is not valid");
            }
            ResultSet rs = null;
            PreparedStatement stat = null;
            status = false;
            try {
                stat = con.prepareStatement(QuerySQLByFMUserFabricId);
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (rs.next()) {
                    status = true;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.info((Object)ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
        return status;
    }

    public static void addSnmpUser(String fmUserName, FabricPK fabricPK, SnmpUser snmpUser) throws SQLException {
        Connection con = null;
        PreparedStatement snmpUpdate = null;
        PreparedStatement userFabricInfoUpdate = null;
        try {
            UserFabricImpl userFabricInfo;
            con = ConnectionManager.getConnection();
            SnmpUserImpl snmpUserImpl = new SnmpUserImpl(snmpUser);
            snmpUpdate = snmpUserImpl.getPersistentSql(con);
            if (snmpUpdate != null) {
                snmpUpdate.execute();
            }
            if (!(userFabricInfo = new UserFabricImpl(fmUserName, fabricPK.get_fid(), snmpUserImpl)).checkPreexistRecord(con)) {
                userFabricInfoUpdate = con.prepareStatement(InsertSQL);
                userFabricInfo.setupInsertStatement(userFabricInfoUpdate);
            } else {
                userFabricInfoUpdate = con.prepareStatement(UpdateSQL);
                userFabricInfo.setupUpdateStatement(userFabricInfoUpdate);
            }
            userFabricInfoUpdate.execute();
        }
        catch (Exception ex) {
            try {
                throw new SQLException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(snmpUpdate);
                DbUtil.close(userFabricInfoUpdate);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(snmpUpdate);
        DbUtil.close(userFabricInfoUpdate);
        DbUtil.close(con);
    }

    public static SnmpUser getSnmpUser(String fmUserName, FabricPK fabricPK) throws SQLException {
        CommunityUser communityUser;
        Connection con = null;
        PreparedStatement userFabricQuery = null;
        ResultSet rs = null;
        SnmpUser snmpUser = null;
        fmUserName = SecurityManager.getInstance().formatUser(fmUserName);
        try {
            con = ConnectionManager.getConnection();
            userFabricQuery = con.prepareStatement(QuerySnmpByFMUser);
            userFabricQuery.setString(1, StringEncrypter.encryptString("DES", fmUserName));
            userFabricQuery.setInt(2, fabricPK.get_fid());
            rs = userFabricQuery.executeQuery();
            int version = 3;
            String userName = null;
            String authPassword = null;
            String privPassword = null;
            int authProtocol = -1;
            int privProtocol = -1;
            String securityName = null;
            String roleName = null;
            if (rs.next()) {
                version = rs.getInt(1);
                userName = rs.getString(2);
                authPassword = rs.getString(3);
                privPassword = rs.getString(4);
                authProtocol = rs.getInt(5);
                privProtocol = rs.getInt(6);
                securityName = rs.getString(7);
                roleName = rs.getString(8);
            }
            snmpUser = version == 3 ? new UsmUser(StringEncrypter.decryptString("DES", userName), authProtocol, StringEncrypter.decryptString("DES", authPassword), privProtocol, privPassword == null ? null : StringEncrypter.decryptString("DES", privPassword)) : new CommunityUser(StringEncrypter.decryptString("DES", userName), version);
            snmpUser.setSecurityName(securityName);
            snmpUser.setRoleName(roleName);
            communityUser = snmpUser;
        }
        catch (Exception ex) {
            try {
                throw new SQLException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(userFabricQuery);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(userFabricQuery);
        DbUtil.close(con);
        return communityUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFmUser(FabricPK fabricPK) {
        ResultSet rs;
        PreparedStatement fmUserQuery;
        String result;
        Connection con;
        block4: {
            con = null;
            result = null;
            fmUserQuery = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                fmUserQuery = con.prepareStatement(QueryFMUser);
                fmUserQuery.setInt(1, fabricPK.get_fid());
                rs = fmUserQuery.executeQuery();
                if (rs == null || !rs.next()) break block4;
                result = StringEncrypter.decryptString("DES", rs.getString(1));
            }
            catch (Exception ex) {
                try {
                    _Logger.warn((Object)("getFmUser failed. " + ex.getMessage()));
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(fmUserQuery);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(fmUserQuery);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(fmUserQuery);
        DbUtil.close(con);
        return result;
    }

    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<FabricPK, SnmpUser> loadFromDB(String userName) throws SQLException {
        HashMap<FabricPK, SnmpUser> hashMap;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        HashMap<FabricPK, SnmpUser> htable = new HashMap<FabricPK, SnmpUser>(5);
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByFMUser);
            stat.setString(1, StringEncrypter.encryptString("DES", userName));
            rs = stat.executeQuery();
            FabricPK fpk = null;
            while (rs.next()) {
                fpk = new FabricPK(rs.getInt(1));
                int version = rs.getInt(3);
                SnmpUser user = null;
                try {
                    if (version == 3) {
                        String privPass = rs.getString(6);
                        user = new UsmUser(StringEncrypter.decryptString("DES", rs.getString(4)), rs.getInt(7), StringEncrypter.decryptString("DES", rs.getString(5)), rs.getInt(8), privPass == null ? privPass : StringEncrypter.decryptString("DES", privPass));
                    } else {
                        user = new CommunityUser(StringEncrypter.decryptString("DES", rs.getString(4)), version);
                    }
                }
                catch (Exception ex) {
                    _Logger.trace((Object)ex.getMessage());
                    continue;
                }
                htable.put(fpk, user);
            }
            hashMap = htable;
            DbUtil.close(rs);
        }
        catch (Exception ex) {
            _Logger.trace((Object)ex.getMessage());
            HashMap<FabricPK, SnmpUser> hashMap2 = null;
            return hashMap2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteUserFabricInfo(String fmUserName) {
        boolean bl;
        Connection con = null;
        PreparedStatement stat = null;
        fmUserName = SecurityManager.getInstance().formatUser(fmUserName);
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(DeleteSQL);
            stat.setString(1, fmUserName);
            stat.executeUpdate();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                _Logger.trace((Object)e.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl2;
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return bl;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        try {
            stat.setString(1, StringEncrypter.encryptString("DES", this._fmUserName));
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        stat.setLong(2, this._fabricDBID);
        stat.setLong(3, this._snmpUserDBID);
        stat.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._snmpUserDBID);
        stat.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        try {
            stat.setString(3, StringEncrypter.encryptString("DES", this._fmUserName));
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        stat.setLong(4, this._fabricDBID);
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws Exception {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._fabricDBID);
        stat.setString(2, StringEncrypter.encryptString("DES", this._fmUserName));
    }
}

