/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.smis;

import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.security.RoleType;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SMISDiscoveryTool {
    private static SMISDiscoveryTool _singlton = null;
    public static Logger _Logger = LogManager.getLogger((String)"fms");

    private SMISDiscoveryTool() {
    }

    public static SMISDiscoveryTool getInstance() {
        if (_singlton == null) {
            _singlton = new SMISDiscoveryTool();
        }
        return _singlton;
    }

    public void perform(InetAddress seedip, InetAddress seedip2, String username, String passwd, String encp) {
        SnmpUserOpt userOpt = new SnmpUserOpt(username, passwd, null, SnmpUserOpt.convertSnmpV3Security(encp), true);
        SnmpUser user = SessionImpl.convertSnmpUser(userOpt);
        user.setRoleName(RoleType.ROLE_ADMIN.value());
        try {
            if (seedip != null) {
                _Logger.info((Object)("Start SMIS discovery tool with:" + seedip + ":" + username));
                FabricPK pk1 = this.doSeed(seedip, user);
                _Logger.info((Object)("Done SMIS discovery tool with:" + seedip + ":" + username));
            }
            if (seedip2 != null) {
                _Logger.info((Object)("Start SMIS discovery tool with:" + seedip2 + ":" + username));
                FabricPK pk2 = this.doSeed(seedip2, user);
                _Logger.info((Object)("Done SMIS discovery tool with:" + seedip + ":" + username));
            }
        }
        catch (Throwable ex) {
            _Logger.error((Object)("SMIS discovery Failed :" + seedip), ex);
        }
    }

    private FabricPK doSeed(InetAddress seedip, SnmpUser user) throws Exception, SQLException, InterruptedException, RemoteException {
        SanManager.getInstance().openFabric(seedip, user, null, null);
        while (GlobalFabricManager.getInstance().findFabricPK(seedip) == null) {
            Thread.currentThread();
            Thread.sleep(60000L);
        }
        FabricPK pk = GlobalFabricManager.getInstance().findFabricPK(seedip);
        return pk;
    }
}

