/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.test.hammer;

import com.cisco.dcbu.sm.server.test.hammer.DynamicInvokeTestProvider;
import com.cisco.dcbu.sm.server.test.hammer.FreeTestProvider;
import com.cisco.dcbu.sm.server.test.hammer.GatetoUnitTestProvider;
import com.cisco.dcbu.sm.server.test.hammer.HammerTest;
import com.cisco.dcbu.sm.server.test.hammer.MetaData;
import com.cisco.dcbu.sm.server.test.hammer.Provider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AllHammerTests {
    private static final int POOL_SIZE = 20;
    private static final long TIME_ALIVE = 50000L;
    Logger _log = LogManager.getLogger((String)"Tests.all");
    private static final Map<String, Provider> providers = new ConcurrentHashMap<String, Provider>();
    public static final String DEFAULT_PROVIDER_NAME = "<def>";

    private AllHammerTests() {
    }

    public static void registerDefaultProvider(Provider p) {
        AllHammerTests.registerProvider(DEFAULT_PROVIDER_NAME, p);
    }

    public static void registerProvider(String name, Provider p) {
        providers.put(name, p);
    }

    public static HammerTest newInstance() {
        return AllHammerTests.newInstance(DEFAULT_PROVIDER_NAME);
    }

    public static HammerTest newInstance(String name) {
        Provider p = providers.get(name);
        if (p == null) {
            throw new IllegalArgumentException("No provider registered with name: " + name);
        }
        return p.newTest();
    }

    public static void main(String[] args) {
        int threadnums;
        String wsdl = null;
        FreeTestProvider fp = new FreeTestProvider();
        DynamicInvokeTestProvider dp = new DynamicInvokeTestProvider();
        GatetoUnitTestProvider gp = new GatetoUnitTestProvider();
        AllHammerTests.registerProvider("FreeTestProvider", fp);
        AllHammerTests.registerProvider("DynamicInvokeTestProvider", dp);
        if (args.length == 1) {
            wsdl = args[0];
            String[] wsdlArray = new String[]{wsdl};
            MetaData.setWsdlImplURIs(wsdlArray);
        }
        threadnums = (threadnums = providers.size()) < 20 ? threadnums : 20;
        System.out.println("All Tests are starting ...  ");
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(threadnums, 20, 50000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        for (Map.Entry<String, Provider> me : providers.entrySet()) {
            tpe.execute(me.getValue().newTest());
        }
        tpe.shutdown();
    }
}

