/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.IndexUtil;
import com.cisco.dcbu.sm.common.model.IndexerBase;
import com.cisco.dcbu.sm.common.rif.IndexerRif;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class Indexer
implements IndexerRif {
    static final String INDEX_DIR = ClientCache.getInstallLocation() + File.separator + "db" + File.separator + "index";
    Logger _Log = Logger.getLogger((String)"fms.indexer");
    static Indexer _Indexer = null;
    static String[][] _queryFields = new String[][]{{"Name", "name"}, {"IP Address", "ipaddr"}, {"WWN", "wwn"}, {"Alias", "alias"}, {"MAC Address", "macAddr"}, {"Serial Number", "serialNumber"}};
    static final int MaxClauseCount = 10000;
    Map<String, String> queryFieldsMap = null;
    static final String FIELD_PREFIX = "-0-";
    static final String FIELD_SUFFIX = "-|-";

    private Indexer() {
        this.initQueryFieldsMap();
    }

    protected Indexer(boolean b) {
    }

    public static Indexer getInstance() {
        if (_Indexer == null) {
            _Indexer = new Indexer();
        }
        return _Indexer;
    }

    @Override
    public Map<Integer, List<IndexerBase>> search(String queryField, String queryValue) throws Exception {
        HashMap<Integer, List<IndexerBase>> idxResultMap = new HashMap<Integer, List<IndexerBase>>();
        List<Object> invResultList = new ArrayList();
        List<Object> pmResultList = new ArrayList();
        try {
            invResultList = this.processResult(queryField, queryValue, 2);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            pmResultList = this.processResult(queryField, queryValue, 1);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        idxResultMap.put(2, invResultList);
        idxResultMap.put(1, pmResultList);
        return idxResultMap;
    }

    public List<IndexerBase> processResult(String queryField, String queryValue, int category) throws Exception {
        ArrayList<IndexerBase> list = new ArrayList<IndexerBase>();
        String queryString = this.applyEscape(queryValue);
        String realField = this.getRealQueryField(queryField);
        QueryParser parser = new QueryParser(realField == null ? queryField : realField, (Analyzer)new StandardAnalyzer());
        parser.setAllowLeadingWildcard(true);
        Query query = parser.parse(queryString);
        String schDir = null;
        String catString = null;
        switch (category) {
            case 1: {
                schDir = "pm";
                catString = "performance";
                break;
            }
            case 2: {
                schDir = "inv";
                catString = "inventory";
                break;
            }
            case 3: {
                schDir = "evt";
                catString = "event";
            }
        }
        IndexSearcher searcher = new IndexSearcher(INDEX_DIR + File.separator + schDir);
        BooleanQuery.setMaxClauseCount((int)10000);
        TopDocs topDocs = searcher.search(query, 100);
        int hitCount = topDocs.scoreDocs.length;
        if (hitCount == 0) {
            this._Log.info((Object)("No matches were found for \"" + queryValue + " in " + catString + "\""));
        } else {
            this._Log.info((Object)("Found \"" + queryValue + "\" in " + catString + "."));
            int resultIdx = 0;
            StringBuffer sb = null;
            IndexerBase iBase = null;
            boolean searchForMac = false;
            if (realField != null && realField.equalsIgnoreCase("macAddr")) {
                searchForMac = true;
            }
            for (int i = 0; i < hitCount; ++i) {
                boolean isVhost = false;
                sb = new StringBuffer();
                ++resultIdx;
                ScoreDoc scoreDoc = topDocs.scoreDocs[i];
                Document doc = searcher.doc(scoreDoc.doc);
                List fList = doc.getFields();
                for (int j = 0; j < fList.size(); ++j) {
                    Field field = (Field)fList.get(j);
                    if (field.name().equalsIgnoreCase("identityId") && field.stringValue().equals("-9")) {
                        isVhost = true;
                    }
                    sb.append(field.name() + FIELD_PREFIX + field.stringValue());
                    sb.append(FIELD_SUFFIX);
                }
                String[] initValues = this.parseField(sb.toString());
                iBase = new IndexerBase(initValues);
                if (!isVhost) {
                    list.add(iBase);
                    continue;
                }
                if (!searchForMac) continue;
                list.add(iBase);
            }
        }
        return list;
    }

    private String applyEscape(String queryValue) {
        while (queryValue.startsWith("*")) {
            queryValue = queryValue.substring(1);
        }
        while (queryValue.endsWith("*")) {
            queryValue = queryValue.substring(0, queryValue.length() - 1);
        }
        queryValue = IndexUtil.getInstance().idxEscape(queryValue);
        queryValue = "*" + queryValue + "*";
        return queryValue;
    }

    private String getRealQueryField(String queryField) {
        if (this.queryFieldsMap.containsKey(queryField)) {
            return this.queryFieldsMap.get(queryField);
        }
        return null;
    }

    private String[] parseField(String str) {
        String filterStr = IndexUtil.getInstance().reverseEscape(str);
        String[] values = new String[13];
        String[] fields = new String[]{"id-0-", "dstId-0-", "name-0-", "category-0-", "type-0-", "wwn-0-", "alias-0-", "ipaddr-0-", "dscr-0-", "identityId-0-", "serialNumber-0-", "scopeType-0-", "macAddr-0-"};
        for (int i = 0; i < fields.length; ++i) {
            if (filterStr.indexOf(fields[i]) < 0) {
                values[i] = "";
                continue;
            }
            int sIdx = filterStr.indexOf(fields[i]) + fields[i].length();
            values[i] = filterStr.substring(sIdx, filterStr.indexOf(FIELD_SUFFIX, sIdx)).trim();
        }
        return values;
    }

    @Override
    public Map<Integer, List<IndexerBase>> search(String queryString) throws Exception {
        return this.search("name", queryString);
    }

    @Override
    public void enableSearch() throws Exception {
        System.setProperty("web.enableSearch", "true");
    }

    @Override
    public void disableSearch() throws Exception {
        System.setProperty("web.enableSearch", "false");
    }

    private void initQueryFieldsMap() {
        this.queryFieldsMap = new HashMap<String, String>();
        for (String[] item : _queryFields) {
            this.queryFieldsMap.put(item[0], item[1]);
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    public static void main(String[] args) {
        try {
            String[] tests;
            for (String test : tests = new String[]{"*172*"}) {
                List<IndexerBase> rstList = Indexer.getInstance().processResult("name", test, 3);
                System.out.println("rst:" + rstList.size());
            }
            boolean bl = false;
        }
        catch (Exception ex) {
            System.err.print(ex.getMessage());
        }
    }
}

