/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web;

import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.ServerReference;
import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.rif.SchedulerRif;
import com.cisco.dcbu.sm.common.rif.TopologyManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WebReferenceManager {
    private static WebReferenceManager _ReferenceManager = null;
    EjbRegistryIf _LocalRif = null;
    List<String> _Servers = null;
    List<ServerReference> _References = null;
    Timer _Timer = null;
    public static final long SYNC_INTERVAL = 120000L;
    static final String LOCAL_HOST = "127.0.0.1";
    Logger _Log = LogManager.getLogger((String)"fms.webRefMgr");

    public static WebReferenceManager getInstance() {
        if (_ReferenceManager == null) {
            _ReferenceManager = new WebReferenceManager();
        }
        return _ReferenceManager;
    }

    private WebReferenceManager() {
        this.loadServerProperties();
        try {
            this._LocalRif = EjbRegistry.getInstance();
            this._References = new ArrayList<ServerReference>();
            this._Timer = new Timer();
            this._Timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        WebReferenceManager.this.updateReferences();
                    }
                    catch (Exception e) {
                        WebReferenceManager.this._Log.warn((Object)("WebReference sync: " + e.getStackTrace()));
                    }
                }
            }, 0L, 120000L);
        }
        catch (Exception e) {
            this._Log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void loadServerProperties() {
        String _ConfigFile = ClientCache.getConfDir() + "server.properties";
        Properties properties = new Properties();
        try {
            GenUtil.loadServerProperties(this._Log);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Server configuration file loaded: " + _ConfigFile);
        System.getProperties().putAll((Map<?, ?>)properties);
    }

    public void updateReferences() throws Exception {
        if (this._LocalRif == null) {
            return;
        }
        FMServerRif serverRif = this._LocalRif.getFMServer();
        this._Servers = serverRif.getServerNodes();
        ServerReference serverRef = null;
        this._References = new ArrayList<ServerReference>();
        for (String serverIp : this._Servers) {
            serverIp = serverIp.contains("0.0.0.0") ? LOCAL_HOST : serverIp;
            serverRef = new ServerReference(serverIp);
            try {
                serverRef.setServerMgr((FMServerRif)this._LocalRif.getRemoteService(serverIp, "FMServerBean"));
            }
            catch (Exception e) {
                this._Log.debug((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            try {
                serverRef.setPmMgr((PMRif)this._LocalRif.getRemoteService(serverIp, "PMBean"));
                serverRef.setSchedulerMgr((SchedulerRif)this._LocalRif.getRemoteService(serverIp, "SchedulerManagerBean"));
                serverRef.setIscRif((IscRif)this._LocalRif.getRemoteService(serverIp, "IscBean"));
                serverRef.setEMRif((EMRif)this._LocalRif.getRemoteService(serverIp, "EMBean"));
                serverRef.setTopologyMgrRif((TopologyManager)this._LocalRif.getRemoteService(serverIp, "TopologyBean"));
            }
            catch (Exception e) {
                this._Log.debug((Object)e.getMessage(), (Throwable)e);
            }
            this._References.add(serverRef);
        }
        this._Log.info((Object)"Web References update done.");
    }

    public void syncReferences() throws Exception {
        ExecutorService pool = Executors.newSingleThreadExecutor();
        SyncRefCallable call = new SyncRefCallable(this._LocalRif);
        pool.submit(call);
        pool.shutdown();
    }

    public EjbRegistryIf getLocalRef() {
        return this._LocalRif;
    }

    public List<ServerReference> getReferences() {
        if (this._References == null || this._References.size() == 0) {
            try {
                this.updateReferences();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<ServerReference> viewList = new ArrayList<ServerReference>();
        viewList.addAll(this._References);
        return viewList;
    }

    public Object reAttach(String serverIP, ServerReference.Beans bean) throws Exception {
        switch (bean) {
            case FMSERVER_BEAN: {
                return this._LocalRif.getRemoteService(serverIP, "FMServerBean");
            }
            case PM_BEAN: {
                return this._LocalRif.getRemoteService(serverIP, "PMBean");
            }
            case SCHEDULER_BEAN: {
                return this._LocalRif.getRemoteService(serverIP, "SchedulerManagerBean");
            }
            case ISC_BEAN: {
                return this._LocalRif.getRemoteService(serverIP, "IscBean");
            }
            case EM_BEAN: {
                return this._LocalRif.getRemoteService(serverIP, "EMBean");
            }
            case TOPOLOGY_BEAN: {
                return this._LocalRif.getRemoteService(serverIP, "TopologyBean");
            }
        }
        throw new Exception("Can not bind to the bean!");
    }

    public void removeReference(ServerReference svrRef) {
        this._Servers.remove(svrRef.getServerIP());
        this._References.remove(svrRef);
    }

    public class SyncRefCallable
    implements Callable<Integer> {
        EjbRegistryIf _LocalRif;

        public SyncRefCallable(EjbRegistryIf _rif) {
            this._LocalRif = _rif;
        }

        @Override
        public Integer call() {
            try {
                FMServerRif serverRif = this._LocalRif.getFMServer();
                WebReferenceManager.this._Servers = serverRif.getServerNodes();
                for (String serverIp : WebReferenceManager.this._Servers) {
                    try {
                        serverIp = serverIp.contains("0.0.0.0") ? WebReferenceManager.LOCAL_HOST : serverIp;
                        serverRif = (FMServerRif)this._LocalRif.getRemoteService(serverIp, "FMServerBean");
                        serverRif.syncWebReferences();
                    }
                    catch (Exception e) {
                        WebReferenceManager.this._Log.info((Object)("syncReferences: " + serverIp + " is not alive"));
                    }
                }
            }
            catch (Throwable t) {
                WebReferenceManager.this._Log.error((Object)"syncReferences: ", t);
            }
            return new Integer(1);
        }
    }
}

