/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.dashboard;

import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.wo.DashboardFabricDO;
import com.cisco.dcbu.jaxws.san.wo.FederationDO;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FederationHandler {
    private static FederationHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private static String fedQuery = "select p.lsvr_id, l.f_id, p.IP_ADDR, p.LOCATION, p.STATUS from PHYSICAL_LOGICSVR p LEFT JOIN LOGICSVR_FABRIC l ON l.LSVR_ID=p.LSVR_ID";

    public static FederationHandler getInstance() {
        if (_Instance == null) {
            _Instance = new FederationHandler();
        }
        return _Instance;
    }

    private FederationHandler() {
    }

    public void updateLocation(int serverId, String location) throws SanServiceException {
        try {
            ClusterMapping.getInstance().updateLocation(serverId, location);
        }
        catch (SQLException e) {
            throw new SanServiceException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ArrayList<FederationDO> getFederationList() {
        block32: {
            fedList = new ArrayList<FederationDO>();
            fedMap = new HashMap<Integer, FederationDO>();
            fabToFedMap = new HashMap<Integer, Integer>();
            fedToFabMap = new HashMap<Integer, ArrayList<E>>();
            if (!SQLLoader.canExecute()) {
                return fedList;
            }
            scanInterval = 180000L;
            stmt = null;
            rs = null;
            con = null;
            try {
                con = ConnectionManager.getConnection();
                sql = FederationHandler.fedQuery;
                stmt = con.prepareStatement(sql);
                rs = SQLLoader.execute(stmt);
                acceptableLastScan = System.currentTimeMillis() - scanInterval;
                while (rs.next()) {
                    sid = rs.getInt(1);
                    fid = rs.getInt(2);
                    addr = rs.getBytes(3);
                    location = rs.getString(4);
                    if (location == null) {
                        location = "";
                    }
                    status = rs.getInt(5);
                    fed = (FederationDO)fedMap.get(sid);
                    if (fed == null) {
                        inetAddr = null;
                        try {
                            inetAddr = InetAddress.getByAddress(addr);
                        }
                        catch (UnknownHostException e) {
                            this._Log.warn((Object)"FederationHandler: Skipped federation view addition due to ", (Throwable)e);
                            continue;
                        }
                        isActive = false;
                        if (status == 0 || status == 3) {
                            isActive = true;
                        }
                        ipaddr = inetAddr.getHostAddress();
                        hostname = inetAddr.getHostName();
                        fed = new FederationDO();
                        fed.setIp(ipaddr);
                        fed.setName(hostname);
                        fed.setServerId(sid);
                        fed.setActive(isActive);
                        fed.setLocation(location);
                        fedMap.put(sid, fed);
                        fedToFabMap.put(sid, new ArrayList<E>());
                    }
                    fabToFedMap.put(fid, sid);
                }
                if (rs == null) break block32;
            }
            catch (SQLException ex) {
                block33: {
                    try {
                        this._Log.error((Object)"SQL Exception in FederationHandler.getDashboard ", (Throwable)ex);
                        if (rs == null) break block33;
                    }
                    catch (Throwable var23_35) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw var23_35;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                } else {
                    ** GOTO lbl79
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        fabricPKs = GlobalFabricManager.getInstance().getAllDisplayFabricPKs();
        for (FabricPK fpk : fabricPKs) {
            df = new DashboardFabricDO();
            df.setDbid(fpk.id);
            df.setFid(fpk.get_fid());
            df.setName(fpk.getName());
            fedId = (Integer)fabToFedMap.get(fpk.get_fid());
            dfList = (ArrayList)fedToFabMap.get(fedId);
            if (dfList == null) continue;
            dfList.add(df);
        }
        try {
            lanList = GlobalDCManager.getInstance().getAllLanPKs();
            for (LanPK lan : lanList) {
                fedId = (Integer)fabToFedMap.get(lan._fid);
                dfList = (ArrayList)fedToFabMap.get(fedId);
                if (dfList == null) continue;
                try {
                    cdpSeeds = GlobalDCManager.getInstance().getCdpSeedsByLanPK(lan);
                    for (CdpSeedBase cdpSeed : cdpSeeds) {
                        df = new DashboardFabricDO();
                        df.setDbid(cdpSeed.getTaskKey().getId());
                        df.setFid(lan._fid);
                        ipList = cdpSeed.getSeedIPs();
                        seedString = new StringBuffer("task_seed_");
                        for (InetAddress ip : ipList) {
                            if (seedString.length() > 10) {
                                seedString.append("_");
                            }
                            seedString.append(ip.getHostAddress());
                        }
                        df.setName(seedString.toString());
                        dfList.add(df);
                    }
                }
                catch (Exception ex1) {
                    this._Log.warn((Object)("FederationHandler: failed to get LAN dataSrouce from GlobalDCManager getCdpSeedsByLanPK() for lan " + lan._fid + ", ex= "), (Throwable)ex1);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)"FederationHandler: failed to get LAN dataSrouce from GlobalDCManager getAllLanPKs(), ex= ", (Throwable)ex);
        }
        for (FederationDO fed : fedMap.values()) {
            dfList = (ArrayList)fedToFabMap.get(fed.getServerId());
            dfArray = new DashboardFabricDO[dfList.size()];
            dfArray = dfList.toArray(dfArray);
            fed.setFabricList(dfArray);
            localTime = "error : cannot contact server";
            fmServer = null;
            try {
                fmServer = ClusterProcessor.getInstance().getFmsByIp(fed.getIp());
                if (fmServer != null) {
                    localTime = SnmpTimeticks.getDateFormat().format(new Date(fmServer.getServerTime()));
                } else {
                    this._Log.warn((Object)"FederationHandler, failed to get fmServer localTime, fmServer null, failed to contact server");
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)("FederationHandler, failed to get fmServer localTime, ex=" + ex));
            }
            fed.setLocalTime(localTime);
            fedList.add(fed);
        }
        return fedList;
    }
}

