/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.health;

import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountingHandler {
    public static final String SYSLOG = "Syslog Message";
    public static final String TRAPS = "All Traps";
    public static final String ALLEVENTS = "All";
    static String REPOSITORY = null;
    public static final String RS = ">:";
    public static final String EVENTS = "Events";
    public static final String ACCOUNTING = "Accounting";
    public static final String HARDWARE = "Hardware";
    public static final String RLIR = "Link Incidents";
    public static final String EVENTS_FILE = "events";
    public static final String ACCOUNTING_FILE = "accounting";
    public static final String HARDWARE_FILE = "hardware";
    public static final String RLIR_FILE = "rli";
    private static AccountingHandler _Instance;
    static Logger _Logger;
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    static final String INSERT_STMT_ACCOUNTING = "INSERT INTO ACCOUNTING(EVENTID, LAST_SEEN, SWITCH_TIME, FACILITY, SEVERITY, SOURCE, DESCR, SYSLOGEVENT, FABRICID, SWITCHID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    static final String DELETE_STMT_ORCL_ACCT = "DELETE FROM ACCOUNTING WHERE EVENTID IN (SELECT EVENTID FROM (SELECT *  FROM ACCOUNTING ORDER BY SWITCH_TIME) WHERE ROWNUM < ?)";
    static final String DELETE_STMT_PSQL_ACCT = "DELETE FROM ACCOUNTING WHERE EVENTID IN (SELECT EVENTID FROM (SELECT *  FROM ACCOUNTING ORDER BY SWITCH_TIME) TEMP LIMIT ?)";
    static final String COUNT_STMT_ACCT = "SELECT COUNT(*) FROM ACCOUNTING";
    static int cnt;
    static final int ACCTEVENTID;
    static final int ACCTHOST_TIME;
    static final int ACCTSWITCH_TIME;
    static final int ACCTFACILITY;
    static final int ACCTSEVERITY;
    static final int ACCTSOURCE;
    static final int ACCTDESCR;
    static final int ACCTSYSLOGEVENT;
    static final int ACCTFABRICID;
    static final int ACCTSWITCHID;

    public static AccountingHandler getInstance() {
        if (_Instance == null) {
            _Instance = new AccountingHandler();
        }
        return _Instance;
    }

    AccountingHandler() {
        this._Name2SqlHash.put("sw", " ORDER BY TIMESTAMP(EVENT.LAST_SEEN) DESC");
        this._Name2SqlHash.put("source", " ORDER BY SWITCH.SYS_NAME ?, FABRIC.NAME ASC, ACCOUNTING.LAST_SEEN DESC");
        this._Name2SqlHash.put("switchTime", " ORDER BY ACCOUNTING.SWITCH_TIME ?, FABRIC.NAME ASC");
        this._Name2SqlHash.put("userName", " ORDER BY ACCOUNTING.USER_NAME ?, FABRIC.NAME ASC");
    }

    public DBEntryDO getList(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getList(records, dbFilter, dbFilter.getDcType(), dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.getGroupId(), startIdx, recordSize, severity, interval, type, sortSqlSuffix, false);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getList(DBEntryDO records, DbFilterDO dbFilter, int dcType, long fDbId, long swDbId, long groupId, int startIdx, int recordSize, String sevFilter, String intervalFilter, String typeFilter, String sortSqlSuffix, boolean lengthOnly) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block24: {
            String[] st;
            if (sortSqlSuffix == null) {
                sortSqlSuffix = "";
            }
            String colFilterStr = "";
            String filterStr = dbFilter.getFilterStr();
            if (filterStr == null || filterStr.length() == 0) {
                filterStr = "";
            }
            for (String elem : st = filterStr.split("/t")) {
                String[] pos = elem.split("=");
                if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("SOURCE")) {
                    String scopeStr = " AND ((UPPER(SYS_NAME) LIKE '%$SCOPE$%') OR (UPPER(SYS_NAME) IS NULL AND UPPER(SOURCE) LIKE '%$SCOPE$%'))";
                    colFilterStr = colFilterStr + scopeStr.replace("$SCOPE$", pos[1].trim().toUpperCase());
                    continue;
                }
                if (pos.length != 2) continue;
                colFilterStr = colFilterStr + " AND (UPPER(" + pos[0] + ") LIKE '%" + pos[1].trim().toUpperCase() + "%')";
            }
            colFilterStr = colFilterStr + " ";
            con = null;
            stmt = null;
            rs = null;
            String sql = null;
            if (sevFilter == null || ALLEVENTS.equals(sevFilter)) {
                sevFilter = "Debug";
            }
            if (intervalFilter == null) {
                intervalFilter = ALLEVENTS;
            }
            con = ConnectionManager.getConnection();
            if (swDbId > 0L) {
                if (dcType == 0) {
                    sql = SQLLoader.getSql("AccountingSummaryAction.ACCOUNTING_SWITCH_STMT") + colFilterStr + AccountingHandler.getIntervalPhrase(intervalFilter);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                    stmt.setLong(1, swDbId);
                    stmt.setInt(2, Severity.stringOf(sevFilter).getValue());
                } else {
                    sql = SQLLoader.getSql("AccountingSummaryAction.ACCOUNTING_ETHSWITCH_STMT") + colFilterStr + AccountingHandler.getIntervalPhrase(intervalFilter);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                    stmt.setLong(1, swDbId);
                    stmt.setInt(2, Severity.stringOf(sevFilter).getValue());
                }
            } else if (fDbId != -1L) {
                if (dcType == 0) {
                    sql = SQLLoader.getSql("AccountingSummaryAction.ACCOUNTING_FABRIC_STMT") + colFilterStr + AccountingHandler.getIntervalPhrase(intervalFilter);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                    stmt.setLong(1, fDbId);
                    stmt.setInt(2, Severity.stringOf(sevFilter).getValue());
                } else {
                    sql = SQLLoader.getSql("AccountingSummaryAction.ACCOUNTING_LAN_STMT") + colFilterStr + AccountingHandler.getIntervalPhrase(intervalFilter);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                    stmt.setLong(1, fDbId);
                    stmt.setInt(2, Severity.stringOf(sevFilter).getValue());
                }
            } else if (groupId != -1L) {
                StringBuilder groupFilter = new StringBuilder();
                ArrayList<Long> gids = NavigationUtil.getInstance().getAllNavGroupIds(groupId);
                groupFilter.append(" AND GROUP_ID in (");
                String tmp = gids.toString();
                groupFilter.append(tmp.substring(1, tmp.length() - 1));
                groupFilter.append(") ");
                sql = SQLLoader.getSql("AccountingSummaryAction.ACCOUNTING_GROUP_STMT") + groupFilter + colFilterStr + AccountingHandler.getIntervalPhrase(intervalFilter);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                stmt.setInt(1, Severity.stringOf(sevFilter).getValue());
            } else {
                sql = SQLLoader.getSql("AccountingSummaryAction.ACCOUNTING_STMT") + colFilterStr + AccountingHandler.getIntervalPhrase(intervalFilter);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                stmt.setInt(1, Severity.stringOf(sevFilter).getValue());
            }
            rs = SQLLoader.execute(stmt);
            if (!lengthOnly) break block24;
            rs.last();
            int groupFilter = rs.getRow();
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
            return groupFilter;
        }
        try {
            records.setColumn(new String[]{"Index", "Group", "Type", "Host Time", "Time", "Source", "Severity", "Facility", "Syslog Event", "Description", "User Name", "Switch Id", "DC Type"});
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                Timestamp lastSeen = rs.getTimestamp(2);
                Timestamp switchtime = rs.getTimestamp(3);
                String source = rs.getString(4);
                int severity = rs.getInt(5);
                String facility = rs.getString(6);
                String syslogEvent = rs.getString(7);
                String description = rs.getString(8);
                String userName = rs.getString(9);
                Timestamp firstSeen = rs.getTimestamp(10);
                long switchId = rs.getLong(12);
                dcType = rs.getInt(13);
                long eventId = rs.getLong(15);
                if (source == null || source.length() == 0) {
                    source = rs.getString(16);
                }
                String currentType = "";
                String firstSeenStr = firstSeen == null ? "" : SnmpTimeticks.getDateFormat().format(firstSeen.getTime());
                String swTime = switchtime == null ? "" : SnmpTimeticks.getDateFormat().format(switchtime.getTime());
                String sevStr = Severity.valueOf(severity).toString();
                String desc = DisplayUtil.formatLongString(description, 60);
                String index = curIdx + startIdx + 1 + "";
                DBRowDO row = new DBRowDO();
                row.setEntry(new String[]{index, fabric, currentType, firstSeenStr, swTime, source, sevStr, facility == null ? "" : facility, syslogEvent == null ? "" : syslogEvent, description, userName, "" + switchId, "" + dcType, "" + eventId});
                rList.add(row);
                if (recordSize <= 0 || ++curIdx <= 0 || curIdx < recordSize) continue;
                break;
            }
            records.setRow(rList.toArray(new DBRowDO[0]));
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)ex);
            }
            catch (Throwable throwable) {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAccountingEvent(String[] indices) throws Exception {
        List<Long> dellist = this.parse(indices);
        Connection con = null;
        Statement stmt = null;
        PreparedStatement stmt_modify = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            stmt_modify = con.prepareStatement(SQLLoader.getSql("AccountingSummaryAction.DELETE_STMT"));
            for (Long eventId : dellist) {
                stmt_modify.setLong(1, eventId);
                stmt_modify.addBatch();
            }
            stmt_modify.executeBatch();
            con.commit();
        }
        catch (SQLException ex) {
            _Logger.error((Object)ex);
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(stmt_modify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAccountingAllEvent(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws Exception {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            con = ConnectionManager.getConnection();
            sql = "TRUNCATE TABLE accounting";
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.executeUpdate();
            _Logger.info((Object)"accounting table truncated.");
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)ex);
            }
            catch (Throwable throwable) {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    private List<Long> parse(String[] indices) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (String ind : indices) {
            String[] range = ind.split("-");
            if (range.length == 1) {
                long tmp = Long.parseLong(range[0].trim());
                result.add(tmp);
                continue;
            }
            if (range.length != 2) continue;
            long start = Long.parseLong(range[0].trim());
            long end = Long.parseLong(range[1].trim());
            for (long i = start; i <= end; ++i) {
                result.add(i);
            }
        }
        return result;
    }

    public String printAccountingTable(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getList(records, dbFilter, dbFilter.getDcType(), dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.getGroupId(), startIdx, recordSize, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, false);
        return JasperPrintGenerator.getInstance().generatePrintReport(ACCOUNTING, columnHeader, records);
    }

    public String exportAccountingTable(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getList(records, dbFilter, dbFilter.getDcType(), dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.getGroupId(), startIdx, recordSize, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, false);
        return JasperPrintGenerator.getInstance().generateExcelReport(ACCOUNTING, columnHeader, records);
    }

    public int getDataLength(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        long vsanDbId = dbFilter.getVsanDbId();
        long fabricDbId = dbFilter.getFabricDbId();
        int recordSize = -1;
        return this.getList(null, dbFilter, dbFilter.getDcType(), fabricDbId, dbFilter.getSwitchDbId(), dbFilter.getGroupId(), 0, recordSize, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, true);
    }

    private String getSortStmt(DbFilterDO dbFilter) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField());
        if (sortSqlSuffix != null) {
            return sortSqlSuffix.replace("?", dbFilter.getSortType());
        }
        sortSqlSuffix = " ORDER BY LAST_SEEN DESC";
        return sortSqlSuffix;
    }

    public static String getIntervalPhrase(String interval) {
        if (interval.trim().equals(ALLEVENTS)) {
            return "";
        }
        boolean usingOracle = ConnectionManager.getDbDriver().startsWith("oracle");
        if (interval.trim().equals("24 Hours")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,ACCOUNTING.LAST_SEEN)*31 <= 1 )";
            }
            return " AND ( (current_date-ACCOUNTING.LAST_SEEN) < INTERVAL '1 day' )";
        }
        if (interval.trim().equals("Week")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,ACCOUNTING.LAST_SEEN)*31 <= 7 )";
            }
            return " AND ( (current_date-ACCOUNTING.LAST_SEEN) < INTERVAL '7 days' )";
        }
        if (interval.trim().equals("Month")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,ACCOUNTING.LAST_SEEN) <= 1 )";
            }
            return " AND ( (current_date-ACCOUNTING.LAST_SEEN) < INTERVAL '30 days' )";
        }
        if (interval.trim().equals("Year")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,ACCOUNTING.LAST_SEEN)*31 <= 365 )";
            }
            return " AND ( (current_date-ACCOUNTING.LAST_SEEN) < INTERVAL '365 days' )";
        }
        return "";
    }

    private static boolean isPortGroup(String type, String facility, String description) {
        return type.startsWith("Port Group") && facility.startsWith("PMON-SLOT") && description.contains("Port Group") && description.contains("crossed");
    }

    public static void main(String ... strings) throws Exception {
        System.setProperty("db.url", "jdbc:oracle:thin:@localhost:1521:XE");
        System.setProperty("db.user", "scott");
        System.setProperty("db.password", "tiger");
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        int length = AccountingHandler.getInstance().getDataLength(dbFilter, ALLEVENTS, ALLEVENTS, ALLEVENTS);
        System.out.println("length is :" + length);
        DBEntryDO dbEntry = AccountingHandler.getInstance().getList(dbFilter, ALLEVENTS, ALLEVENTS, ALLEVENTS, 0, 31);
        for (DBRowDO row : dbEntry.getRows()) {
            String[] en = row.getEntry();
            if (en == null) continue;
            for (String e : en) {
                System.out.print(e + "\t");
            }
            System.out.print("\n");
        }
    }

    static {
        REPOSITORY = ClientCache.getLogsDir();
        _Instance = null;
        _Logger = Logger.getLogger((String)"fms");
        cnt = 1;
        ACCTEVENTID = cnt++;
        ACCTHOST_TIME = cnt++;
        ACCTSWITCH_TIME = cnt++;
        ACCTFACILITY = cnt++;
        ACCTSEVERITY = cnt++;
        ACCTSOURCE = cnt++;
        ACCTDESCR = cnt++;
        ACCTSYSLOGEVENT = cnt++;
        ACCTFABRICID = cnt++;
        ACCTSWITCHID = cnt;
    }
}

