/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.health;

import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.sm.server.web.health.AccountingWrapper;
import com.cisco.dcbu.sm.server.web.health.EventHandler;
import com.cisco.dcbu.sm.server.web.health.EventTokenizer;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AccountingTokenizer
implements EventTokenizer {
    static final int TIMESTAMP = 1;
    static final int FACILITY = 2;
    static final int SEVERITY = 3;
    static final int EVENT = 4;
    static final int VSAN_TIMESTAMP = 5;
    static final int VSAN = 6;
    static final int VSAN_ID = 7;
    static final int HOST_TIMESTAMP = 8;
    static final int ACTION = 9;
    static final int PROTOCOL_SOURCE = 10;
    static final int USER = 11;
    static final int DESCRIPTION = 12;
    static final String ACCT_REGEX = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\S*): +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +([^:]*):([^:]*):([^:]*):(.*)";
    static final int TIMESTAMP2 = 1;
    static final int ACTION2 = 2;
    static final int PROTOCOL_SOURCE2 = 3;
    static final int USER2 = 4;
    static final int DESCRIPTION2 = 5;
    static final String ACCT_REGEX2 = "([a-zA-Z]{3} +[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d+):([^:]*):([^:]*):([^:]*):(.*)";
    static Pattern _Pattern1 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\S*): +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +([^:]*):([^:]*):([^:]*):(.*)");
    static Pattern _Pattern2 = Pattern.compile("([a-zA-Z]{3} +[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\d+):([^:]*):([^:]*):([^:]*):(.*)");

    AccountingTokenizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBEntryDO getEvents(String device, String name, String file) throws FileNotFoundException {
        String fileName = EventHandler.REPOSITORY + File.separator + device + File.separator + file;
        ArrayList<AccountingWrapper> list = new ArrayList<AccountingWrapper>();
        FileReader reader = null;
        BufferedReader breader = null;
        DBEntryDO dbEntry = null;
        try {
            if (device != null) {
                String line;
                reader = new FileReader(fileName);
                breader = new BufferedReader(reader);
                while ((line = breader.readLine()) != null) {
                    int prefix = line.indexOf(">:");
                    if (prefix != -1) {
                        line = line.substring(prefix + 3);
                    }
                    AccountingWrapper wrapper = this.tokenize(line);
                    list.add(0, wrapper);
                }
            }
            dbEntry = EventHandler.convertAccntToDBEntryDTO(list);
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException(" Accounting events not available for " + name);
        }
        catch (IOException ex) {
            EventHandler._Logger.error((Object)ex.getMessage());
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {
                EventHandler._Logger.warn((Object)"Unable to close file.");
            }
        }
        return dbEntry;
    }

    private AccountingWrapper tokenize(String line) {
        AccountingWrapper wrapper = new AccountingWrapper();
        Matcher m = _Pattern1.matcher(line = line.trim());
        if (m.matches()) {
            wrapper.setSwitchTime(m.group(1));
            wrapper.setAction(m.group(9));
            wrapper.setProtocolAndSource(m.group(10));
            wrapper.setUser(m.group(11));
            wrapper.setDescription(DisplayUtil.formatLongString(m.group(12), 60));
        } else {
            wrapper.setDescription(DisplayUtil.formatLongString(line, 60));
        }
        return wrapper;
    }
}

