/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.health;

import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.health.AccountingTokenizer;
import com.cisco.dcbu.sm.server.web.health.AccountingWrapper;
import com.cisco.dcbu.sm.server.web.health.EventTokenizer;
import com.cisco.dcbu.sm.server.web.health.EventWrapper;
import com.cisco.dcbu.sm.server.web.health.HardwareTokenizer;
import com.cisco.dcbu.sm.server.web.health.RlirTokenizer;
import com.cisco.dcbu.sm.server.web.health.RlirWrapper;
import com.cisco.dcbu.sm.server.web.health.SyslogTokenizer;
import com.cisco.dcbu.sm.server.web.health.TableColumn;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EventHandler {
    static String REPOSITORY = null;
    public static final String RS = ">:";
    public static final String EVENTS = "Events";
    public static final String ACCOUNTING = "Accounting";
    public static final String HARDWARE = "Hardware";
    public static final String RLIR = "Link Incidents";
    public static final String EVENTS_FILE = "events";
    public static final String ACCOUNTING_FILE = "accounting";
    public static final String HARDWARE_FILE = "hardware";
    public static final String RLIR_FILE = "rli";
    private static EventHandler _Instance;
    static Logger _Logger;
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();

    public static EventHandler getInstance() {
        if (_Instance == null) {
            _Instance = new EventHandler();
        }
        return _Instance;
    }

    EventHandler() {
        this._Name2SqlHash.put("sw", " ORDER BY TIMESTAMP(EVENT.HOST_TIME) DESC");
    }

    public DBEntryDO getList(DbFilterDO dbFilter, int startIdx, int recordSize) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getRegisteredInfo(records, dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.isGroup(), startIdx, recordSize, sortSqlSuffix, false);
        return records;
    }

    public int getSwitchListDataLength(DbFilterDO dbFilter, String name, String device, String file, String type) throws Exception {
        boolean startIdx = false;
        int recordSize = -1;
        DBEntryDO result = this.getSwitchList(dbFilter, name, device, file, type);
        if (result == null) {
            return 0;
        }
        return result.getRowSize();
    }

    public DBEntryDO getSwitchList(DbFilterDO dbFilter, String name, String device, String file, String type) throws Exception {
        TableColumn[] cols = null;
        DBEntryDO dbEntry = null;
        if (device != null && type != null && !type.equals("switch")) {
            EventTokenizer tokenizer = null;
            if (type.equals(EVENTS)) {
                tokenizer = new SyslogTokenizer();
                cols = EventWrapper.getHeaders();
            } else if (type.equals(HARDWARE)) {
                tokenizer = new HardwareTokenizer();
                cols = EventWrapper.getHeaders();
            } else if (type.equals(ACCOUNTING)) {
                tokenizer = new AccountingTokenizer();
                cols = AccountingWrapper.getHeaders();
            } else if (type.equals(RLIR)) {
                tokenizer = new RlirTokenizer();
                cols = RlirWrapper.getHeaders();
            } else {
                tokenizer = new SyslogTokenizer();
                cols = EventWrapper.getHeaders();
            }
            try {
                dbEntry = tokenizer.getEvents(device, name == null ? "" : name, file);
            }
            catch (FileNotFoundException fne) {
                _Logger.error((Object)fne.getMessage());
                throw fne;
            }
        }
        return dbEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRegisteredInfo(DBEntryDO records, long fDbId, long swDbId, boolean isGroup, int startIdx, int recordSize, String sortSqlSuffix, boolean lengthOnly) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block18: {
            int n;
            block17: {
                if (sortSqlSuffix == null) {
                    sortSqlSuffix = "";
                }
                Map<String, List<String>> sysLogMap = ClusterProcessor.getInstance().getAllSysLogs();
                if (!SQLLoader.canExecute()) {
                    return 0;
                }
                con = null;
                String sql = null;
                stmt = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    if (fDbId != -1L && swDbId != -1L) {
                        sql = SQLLoader.getSql("EventSyslogAction.SWITCH_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                        stmt.setLong(1, fDbId);
                        stmt.setLong(2, swDbId);
                    } else if (fDbId != -1L) {
                        sql = SQLLoader.getSql("EventSyslogAction.FABRIC_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                        stmt.setLong(1, fDbId);
                    } else {
                        sql = SQLLoader.getSql("EventSyslogAction.STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                    }
                    rs = SQLLoader.execute(stmt);
                    if (lengthOnly) {
                        rs.last();
                        n = rs.getRow();
                        ConnectionManager.returnConnection(con);
                        break block17;
                    }
                    records.setColumn(new String[]{"Index", "Fabric", "Switch", "Files", "TrapRegistered", "SyslogRegistered"});
                    if (startIdx != 0) {
                        rs.absolute(startIdx);
                    }
                    ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
                    int curIdx = 0;
                    while (rs.next()) {
                        String ipAddress;
                        ArrayList files;
                        long fabricId = rs.getLong(1);
                        String fabric = rs.getString(2);
                        long deviceId = rs.getLong(3);
                        String device = rs.getString(4);
                        byte[] ip = rs.getBytes(5);
                        boolean trapRegistered = rs.getBoolean(6);
                        boolean syslogRegistered = rs.getBoolean(7);
                        int fid = rs.getInt(8);
                        String trapRegStr = trapRegistered ? "Yes" : "No";
                        String syslogRegStr = syslogRegistered ? "Yes" : "No";
                        String index = curIdx + startIdx + 1 + "";
                        StringBuilder filesInXml = new StringBuilder();
                        if (ip != null && ip.length >= 4 && (files = (ArrayList)sysLogMap.get(ipAddress = InetAddress.getByAddress(ip).getHostAddress())) != null && files.size() > 0) {
                            for (int i = 0; i < files.size(); ++i) {
                                String file = (String)files.get(i);
                                String type = EVENTS;
                                String old = URLEncoder.encode(file, "UTF-8");
                                type = file.startsWith(EVENTS_FILE) ? EVENTS : (file.startsWith(HARDWARE_FILE) ? HARDWARE : (file.startsWith(ACCOUNTING_FILE) ? ACCOUNTING : (file.startsWith(RLIR_FILE) ? RLIR : EVENTS)));
                                String serverIp = FMServerImpl.getInstance().getServerForFabric(new FabricPK(fid));
                                String url = "/s130.do?svr=" + serverIp + "&currentScreenID=s130&filter.event.select=false&filter.event.fabricId=" + fabricId + "&filter.event.deviceId=" + deviceId + "&filter.event.deviceName=" + device + "&filter.event.deviceAddress=" + ipAddress + "&selectedType=" + type + "&selectedOld=" + old;
                                String fileXml = "<file svr=\"" + serverIp + "\" fabricId=\"" + fabricId + "\" deviceId=\"" + deviceId + "\" deviceName=\"" + device + "\" deviceAddress=\"" + ipAddress + "\" selectedType=\"" + type + "\" fileName=\"" + old + "\"/>";
                                filesInXml.append(fileXml + "\n");
                            }
                        }
                        DBRowDO row = new DBRowDO();
                        row.setEntry(new String[]{index, fabric, device, filesInXml.toString(), trapRegStr, syslogRegStr});
                        rList.add(row);
                        if (recordSize <= 0 || ++curIdx <= 0 || curIdx < recordSize) continue;
                    }
                    records.setRow(rList.toArray(new DBRowDO[0]));
                    ConnectionManager.returnConnection(con);
                    break block18;
                }
                catch (SQLException ex) {
                    _Logger.error((Object)ex);
                    return 0;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            return n;
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return 0;
        finally {
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
    }

    public int getDataLength(DbFilterDO dbFilter) throws Exception {
        Object result = null;
        int startIdx = 0;
        int recordSize = -1;
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        return this.getRegisteredInfo(null, dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.isGroup(), startIdx, recordSize, sortSqlSuffix, true);
    }

    private String getSortStmt(DbFilterDO dbFilter) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField());
        if (sortSqlSuffix != null) {
            sortSqlSuffix = sortSqlSuffix + " " + dbFilter.getSortType();
        }
        return sortSqlSuffix;
    }

    static DBEntryDO convertEventToDBEntryDTO(List<EventWrapper> list) {
        TableColumn[] columns = EventWrapper.getHeaders();
        String[] colsStr = new String[columns.length];
        for (int i = 0; i < colsStr.length; ++i) {
            colsStr[i] = columns[i].getName();
        }
        DBEntryDO dbEntry = new DBEntryDO();
        dbEntry.setColumn(colsStr);
        DBRowDO[] rows = new DBRowDO[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            DBRowDO row = new DBRowDO();
            EventWrapper w = list.get(i);
            String[] value = new String[]{i + 1 + "", w.getSwitchTime(), w.getFacility(), w.getSeverity(), w.getEvent(), w.getVsanId(), w.getHostTime(), w.getDescription()};
            row.setEntry(value);
            rows[i] = row;
        }
        dbEntry.setRow(rows);
        return dbEntry;
    }

    static DBEntryDO convertAccntToDBEntryDTO(List<AccountingWrapper> list) {
        TableColumn[] columns = EventWrapper.getHeaders();
        String[] colsStr = new String[columns.length];
        for (int i = 0; i < colsStr.length; ++i) {
            colsStr[i] = columns[i].getName();
        }
        DBEntryDO dbEntry = new DBEntryDO();
        dbEntry.setColumn(colsStr);
        DBRowDO[] rows = new DBRowDO[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            DBRowDO row = new DBRowDO();
            AccountingWrapper w = list.get(i);
            String[] value = new String[]{i + 1 + "", w.getSwitchTime(), w.getAction(), w.getProtocolAndSource(), w.getUser(), w.getDescription()};
            row.setEntry(value);
            rows[i] = row;
        }
        dbEntry.setRow(rows);
        return dbEntry;
    }

    static DBEntryDO convertRlirToDBEntryDTO(List<RlirWrapper> list) {
        TableColumn[] columns = EventWrapper.getHeaders();
        String[] colsStr = new String[columns.length];
        for (int i = 0; i < colsStr.length; ++i) {
            colsStr[i] = columns[i].getName();
        }
        DBEntryDO dbEntry = new DBEntryDO();
        dbEntry.setColumn(colsStr);
        DBRowDO[] rows = new DBRowDO[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            DBRowDO row = new DBRowDO();
            RlirWrapper w = list.get(i);
            String[] value = new String[]{i + 1 + "", w.getHostTime(), w.getSwitchTime(), w.getPort(), w.getIntf(), w.getLinkIncident()};
            row.setEntry(value);
            rows[i] = row;
        }
        dbEntry.setRow(rows);
        return dbEntry;
    }

    static {
        REPOSITORY = ClientCache.getLogsDir();
        _Instance = null;
        _Logger = Logger.getLogger((String)"fms");
    }
}

