/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.health;

import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.NameValueDO;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EventSummaryHandler {
    public static final String SYSLOG = "Syslog Message";
    public static final String ACCOUNTING = " Accounting";
    public static final String TRAPS = "All Events";
    public static final String ALLEVENTS = "All";
    private static EventSummaryHandler _Instance = null;
    private static Logger _Logger = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    static final String SYSLOG_PROMISCUOUS = "syslog.promiscuous";
    static final String INSERT_SUPPRESSOR_STMT = "INSERT INTO EVENT_SUPPRESSOR(ID, TYPE, SWITCH_ADDRESS, FACILITY, SYSTYPE, DESCR) VALUES(?, ?, ?, ?, ?, ?)";
    static final String DELETE_SUPPRESSOR_STMT = "DELETE FROM EVENT_SUPPRESSOR WHERE ID = ?";
    static final String SELECT_SUPPRESSOR_STMT = "SELECT ID, TYPE, SWITCH_ADDRESS, FACILITY, SYSTYPE, DESCR FROM EVENT_SUPPRESSOR";
    static final int SUPPRESSOR_TYPE_ALL = 0;
    static final int SUPPRESSOR_TYPE_DCNM = 1;
    static final int SUPPRESSOR_TYPE_SYSLOG = 2;

    public static EventSummaryHandler getInstance() {
        if (_Instance == null) {
            _Instance = new EventSummaryHandler();
        }
        return _Instance;
    }

    EventSummaryHandler() {
        this._Name2SqlHash.put("scope", " ORDER BY FABRIC.NAME ?, SWITCH.SYS_NAME ?");
        this._Name2SqlHash.put("sw", " ORDER BY FABRIC.NAME ASC, SWITCH.SYS_NAME ASC, EVENTS.LAST_SEEN DESC");
        this._Name2SqlHash.put("source", " ORDER BY EVENTS.SOURCE ?, FABRIC.NAME ASC, SWITCH.SYS_NAME ASC, EVENTS.LAST_SEEN DESC");
        this._Name2SqlHash.put("severity", " ORDER BY EVENTS.SEVERITY ?, FABRIC.NAME ASC, SWITCH.SYS_NAME ASC, EVENTS.LAST_SEEN DESC");
        this._Name2SqlHash.put("switchTime", " ORDER BY EVENTS.SWITCH_TIME ?, FABRIC.NAME ASC, SWITCH.SYS_NAME ASC, EVENTS.LAST_SEEN DESC");
        this._Name2SqlHash.put("default", " ORDER BY EVENTS.LAST_SEEN DESC");
        this._Name2SqlHash.put("", " ORDER BY EVENTS.LAST_SEEN DESC");
        this._Name2SqlHash.put("hostTime", " ORDER BY EVENTS.LAST_SEEN ?");
    }

    public DBEntryDO getList(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getList(records, dbFilter, dbFilter.getDcType(), dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), startIdx, recordSize, severity, interval, type, sortSqlSuffix, false);
        return records;
    }

    private ResultSet getRecordSet(DbFilterDO dbFilter, int dcType, long fDbId, long swDbId, long groupId, String filterStr, String sevFilter, String intervalFilter, String typeFilter, String sortSqlSuffix, Connection con, PreparedStatement stmt, ResultSet rs, String sql) throws Exception {
        String[] st;
        if (sortSqlSuffix == null) {
            sortSqlSuffix = " ";
        }
        String newFilterStr = "";
        if (filterStr == null || filterStr.length() == 0) {
            filterStr = "";
        }
        for (String elem : st = filterStr.split("/t")) {
            String[] pos = elem.split("=");
            if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("ACK")) {
                newFilterStr = newFilterStr + " AND ACK = " + pos[1];
                continue;
            }
            if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("SCOPE")) {
                String scopeStr = " AND (UPPER(SYS_NAME) LIKE '%$SCOPE$%')";
                newFilterStr = newFilterStr + scopeStr.replace("$SCOPE$", pos[1].trim().toUpperCase());
                continue;
            }
            if (pos.length != 2) continue;
            newFilterStr = newFilterStr + " AND UPPER(" + pos[0] + ") LIKE '%" + pos[1].trim().toUpperCase() + "%'";
        }
        newFilterStr = newFilterStr + " ";
        String typeFilterSql = " ";
        if (SYSLOG.toLowerCase().startsWith(typeFilter.toLowerCase())) {
            typeFilterSql = " AND EVENTS.TYPE=-1";
        } else if (typeFilter.toUpperCase().equals(ALLEVENTS)) {
            typeFilterSql = " ";
        } else {
            int filterTypeInt;
            LogEventType logEType = LogEventType.valueOfByString(typeFilter);
            if (logEType != null && (filterTypeInt = logEType.value()) != -1) {
                typeFilterSql = " AND EVENTS.TYPE=" + filterTypeInt;
            }
        }
        typeFilterSql = typeFilterSql + newFilterStr;
        if (intervalFilter == null) {
            intervalFilter = ALLEVENTS;
        }
        String prom_mode = System.getProperties().getProperty(SYSLOG_PROMISCUOUS);
        String severitySQLFilter = " " + EventSummaryHandler.getSeverityFilterPhase(sevFilter);
        if (swDbId > 0L) {
            if (dcType == 0) {
                sql = SQLLoader.getSql("EventSummaryAction.EVENT_SWITCH_STMT") + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter;
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                stmt.setLong(1, swDbId);
            } else {
                sql = SQLLoader.getSql("EventSummaryAction.EVENT_ETHSWITCH_STMT") + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter;
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                stmt.setLong(1, swDbId);
            }
        } else if (fDbId != -1L) {
            if (dcType == 0) {
                sql = SQLLoader.getSql("EventSummaryAction.EVENT_FABRIC_STMT") + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter;
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                stmt.setLong(1, fDbId);
            } else {
                sql = SQLLoader.getSql("EventSummaryAction.EVENT_LAN_STMT") + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter;
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                stmt.setLong(1, fDbId);
            }
        } else if (groupId != -1L) {
            StringBuilder groupFilter = new StringBuilder();
            ArrayList<Long> gids = NavigationUtil.getInstance().getAllNavGroupIds(groupId);
            groupFilter.append(" AND GROUP_ID in (");
            String tmp = gids.toString();
            groupFilter.append(tmp.substring(1, tmp.length() - 1));
            groupFilter.append(") ");
            sql = SQLLoader.getSql("EventSummaryAction.EVENT_GROUP_STMT") + groupFilter + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter;
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
        } else {
            sql = prom_mode != null && prom_mode.equalsIgnoreCase("TRUE") ? SQLLoader.getSql("EventSummaryAction.EVENT_STMT_PROM") + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter : SQLLoader.getSql("EventSummaryAction.EVENT_STMT") + typeFilterSql + EventSummaryHandler.getIntervalPhrase(intervalFilter) + severitySQLFilter;
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
        }
        rs = SQLLoader.execute(stmt);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getList(DBEntryDO records, DbFilterDO dbFilter, int dcType, long fDbId, long swDbId, long groupId, String filterStr, int startIdx, int recordSize, String sevFilter, String intervalFilter, String typeFilter, String sortSqlSuffix, boolean lengthOnly) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block10: {
            int n;
            block9: {
                con = null;
                stmt = null;
                rs = null;
                String sql = null;
                try {
                    con = ConnectionManager.getConnection();
                    rs = this.getRecordSet(dbFilter, dcType, fDbId, swDbId, groupId, filterStr, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, con, stmt, rs, sql);
                    if (lengthOnly) {
                        rs.last();
                        n = rs.getRow();
                        ConnectionManager.returnConnection(con);
                        break block9;
                    }
                    String lastUpdated = SnmpTimeticks.getDateFormat().format(System.currentTimeMillis());
                    records.setColumn(new String[]{"Index", "Type-Old", "FIRST SEEN", "Last-First Seen", "Count", "Switch Time", "Source", "Severity", "Facility", "Type", "Description", "Group", "Switch", "Switch IP", "Event ID", "Ack", "Switch ID", "DC Type"});
                    if (startIdx != 0) {
                        rs.absolute(startIdx);
                    }
                    ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
                    int curIdx = 0;
                    while (rs.next()) {
                        String fabric = rs.getString(1);
                        int type = rs.getInt(2);
                        Timestamp lastseen = rs.getTimestamp(3);
                        Timestamp switchtime = rs.getTimestamp(4);
                        String source = rs.getString(5);
                        int severity = rs.getInt(6);
                        String facility = rs.getString(7);
                        String syslogEvent = rs.getString(8);
                        String description = rs.getString(9);
                        String sysName = rs.getString(10);
                        long eventId = rs.getLong(12);
                        int ack = rs.getInt(13);
                        Timestamp firstseen = rs.getTimestamp(14);
                        long count = rs.getLong(15);
                        long switchId = rs.getLong(16);
                        dcType = rs.getInt(17);
                        String currentType = "";
                        currentType = type == -1 ? SYSLOG : LogEventType.toString(type);
                        String firstseenStr = firstseen == null ? "" : SnmpTimeticks.getDateFormat().format(firstseen.getTime());
                        String lastfirstseenStr = lastseen == null ? "" : SnmpTimeticks.getDateFormat().format(lastseen.getTime()) + "<->" + firstseenStr;
                        String swTime = switchtime == null ? "" : SnmpTimeticks.getDateFormat().format(switchtime.getTime());
                        String sevStr = Severity.valueOf(severity).toString();
                        String index = curIdx + startIdx + 1 + "";
                        String ackStr = ack == 1 ? "Yes" : "";
                        DBRowDO row = new DBRowDO();
                        row.setEntry(new String[]{index, currentType, lastUpdated, lastfirstseenStr, "" + count, swTime, source, sevStr, facility == null ? "" : facility, syslogEvent == null ? "" : syslogEvent, description, fabric, sysName, "", "" + eventId, "" + ackStr, "" + switchId, "" + dcType});
                        rList.add(row);
                        if (recordSize <= 0 || ++curIdx <= 0 || curIdx < recordSize) continue;
                    }
                    records.setRow(rList.toArray(new DBRowDO[0]));
                    ConnectionManager.returnConnection(con);
                    break block10;
                }
                catch (SQLException ex) {
                    _Logger.error((Object)ex);
                    return 0;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            return n;
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return 0;
        finally {
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
    }

    private List<Long> parse(String[] indices) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (String ind : indices) {
            String[] range = ind.split("-");
            if (range.length == 1) {
                long tmp = Long.parseLong(range[0].trim());
                result.add(tmp);
                continue;
            }
            if (range.length != 2) continue;
            long start = Long.parseLong(range[0].trim());
            long end = Long.parseLong(range[1].trim());
            for (long i = start; i <= end; ++i) {
                result.add(i);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getEventSuppressors() {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"Id", "SwitchAddr", "Facility", "Type", "Descr"});
        ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
        if (!SQLLoader.canExecute()) {
            return dto;
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = SELECT_SUPPRESSOR_STMT;
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                long id = rs.getLong(1);
                String switchAddr = rs.getString(3);
                String facility = rs.getString(4);
                String type = rs.getString(5);
                String descr = rs.getString(6);
                DBRowDO row = new DBRowDO();
                row.setEntry(new String[]{Long.toString(id), switchAddr, facility, type, descr});
                rlist.add(row);
            }
        }
        catch (SQLException ex) {
            DBEntryDO dBEntryDO;
            try {
                dBEntryDO = new DBEntryDO(1, "Cannot get event suppressors: " + ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
            return dBEntryDO;
        }
        DbUtil.close(stmt);
        DbUtil.close(rs);
        DbUtil.close(con);
        dto.setRow(rlist.toArray(new DBRowDO[0]));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEventSuppressor(String switchName, String facility, String type, String desc) {
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(INSERT_SUPPRESSOR_STMT);
            long eventId = Sequence.getSequence().getEventPK(con);
            stat.setLong(1, eventId);
            stat.setInt(2, 0);
            stat.setString(3, switchName);
            stat.setString(4, facility);
            stat.setString(5, type);
            stat.setString(6, desc);
            stat.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            _Logger.error((Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return true;
    }

    public boolean modifyEventSuppressor(String[] indices, String switchIp, String facility, String type, String desc) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEventSuppressors(String[] indices) {
        if (indices == null) {
            return false;
        }
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            stat = con.prepareStatement(DELETE_SUPPRESSOR_STMT);
            for (String idStr : indices) {
                long id = Long.parseLong(idStr);
                stat.setLong(1, id);
                stat.addBatch();
            }
            stat.executeBatch();
            con.commit();
        }
        catch (SQLException e) {
            boolean bl;
            try {
                _Logger.error((Object)e.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return bl;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return true;
    }

    public void setAckFabricEvent(String[] indices) throws Exception {
        this.setAckFabricEvent(indices, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAckFabricEvent(String[] indices, int set) throws Exception {
        List<Long> acklist = this.parse(indices);
        Connection con = null;
        Statement stmt = null;
        PreparedStatement stmt_modify = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            con.setAutoCommit(false);
            if (set >= 0) {
                stmt_modify = con.prepareStatement(SQLLoader.getSql("EventSummaryAction.ACK_STMT"));
                for (Long eventId : acklist) {
                    stmt_modify.setInt(1, set);
                    stmt_modify.setLong(2, eventId);
                    stmt_modify.addBatch();
                }
            } else {
                stmt_modify = con.prepareStatement(SQLLoader.getSql("EventSummaryAction.DELETE_STMT"));
                for (Long eventId : acklist) {
                    stmt_modify.setLong(1, eventId);
                    stmt_modify.addBatch();
                }
            }
            stmt_modify.executeBatch();
            con.commit();
        }
        catch (SQLException ex) {
            _Logger.error((Object)ex);
        }
        finally {
            if (con != null) {
                con.setAutoCommit(true);
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(stmt_modify);
        }
    }

    public void clearAckFabricEvent(String[] indices) throws Exception {
        this.setAckFabricEvent(indices, 0);
    }

    public void deleteFabricEvent(String[] indices) throws Exception {
        this.setAckFabricEvent(indices, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllEvent(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws Exception {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            con = ConnectionManager.getConnection();
            sql = "TRUNCATE TABLE events";
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.executeUpdate();
            _Logger.info((Object)"events table truncated.");
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)("failed to truncate events table: " + ex));
            }
            catch (Throwable throwable) {
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            ConnectionManager.returnConnection(con);
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    public String printEventTable(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getList(records, dbFilter, dbFilter.getDcType(), dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), startIdx, recordSize, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, false);
        return JasperPrintGenerator.getInstance().generatePrintReport("Events", columnHeader, records);
    }

    public String exportEventTable(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter, int startIdx, int recordSize, String[] columnHeader) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        DBEntryDO records = new DBEntryDO();
        this.getList(records, dbFilter, dbFilter.getDcType(), dbFilter.getFabricDbId(), dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), startIdx, recordSize, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, false);
        return JasperPrintGenerator.getInstance().generateExcelReport("Events", columnHeader, records);
    }

    public int getDataLength(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws Exception {
        String sortSqlSuffix = this.getSortStmt(dbFilter);
        long fabricDbId = dbFilter.getFabricDbId();
        int recordSize = -1;
        return this.getList(null, dbFilter, dbFilter.getDcType(), fabricDbId, dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), 0, recordSize, sevFilter, intervalFilter, typeFilter, sortSqlSuffix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkNewEvents(DbFilterDO dbFilter) throws Exception {
        int count;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            rs = null;
            String sql = null;
            count = 0;
            try {
                con = ConnectionManager.getConnection();
                sql = SQLLoader.getSql("EventSummaryAction.CHECK_NEW_EVENTS_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
                Date date = format.parse(dbFilter.getFilterStr());
                stmt.setTimestamp(1, new Timestamp(date.getTime()));
                rs = SQLLoader.execute(stmt);
                if (!rs.first()) break block4;
                count = rs.getInt(1);
            }
            catch (SQLException ex) {
                try {
                    _Logger.error((Object)ex);
                }
                catch (Throwable throwable) {
                    ConnectionManager.returnConnection(con);
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                ConnectionManager.returnConnection(con);
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        ConnectionManager.returnConnection(con);
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return count;
    }

    public NameValueDO[] getEventSummary(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws Exception {
        ArrayList<NameValueDO> nameValueList = new ArrayList<NameValueDO>();
        String sortSqlSuffix = "";
        long fabricDbId = dbFilter.getFabricDbId();
        int recordSize = -1;
        int emergencyCount = this.getList(null, dbFilter, dbFilter.getDcType(), fabricDbId, dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), 0, recordSize, Severity.EMERGENCY.toString(), intervalFilter, typeFilter, sortSqlSuffix, true);
        int alertCount = this.getList(null, dbFilter, dbFilter.getDcType(), fabricDbId, dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), 0, recordSize, Severity.ALERT.toString(), intervalFilter, typeFilter, sortSqlSuffix, true);
        int criticalCount = this.getList(null, dbFilter, dbFilter.getDcType(), fabricDbId, dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), 0, recordSize, Severity.CRITICAL.toString(), intervalFilter, typeFilter, sortSqlSuffix, true);
        int errorCount = this.getList(null, dbFilter, dbFilter.getDcType(), fabricDbId, dbFilter.getSwitchDbId(), dbFilter.getGroupId(), dbFilter.getFilterStr(), 0, recordSize, Severity.ERROR.toString(), intervalFilter, typeFilter, sortSqlSuffix, true);
        nameValueList.add(new NameValueDO(Severity.EMERGENCY.toString(), "" + emergencyCount));
        nameValueList.add(new NameValueDO(Severity.ALERT.toString(), "" + alertCount));
        nameValueList.add(new NameValueDO(Severity.CRITICAL.toString(), "" + criticalCount));
        nameValueList.add(new NameValueDO(Severity.ERROR.toString(), "" + errorCount));
        return nameValueList.toArray(new NameValueDO[0]);
    }

    private String getSortStmt(DbFilterDO dbFilter) {
        String sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField());
        if (sortSqlSuffix != null) {
            return sortSqlSuffix.replace("?", dbFilter.getSortType());
        }
        sortSqlSuffix = " ORDER BY LAST_SEEN DESC";
        return sortSqlSuffix;
    }

    private static boolean isPortGroup(String type, String facility, String description) {
        return type.startsWith("Port Group") && facility.startsWith("PMON-SLOT") && description.contains("Port Group") && description.contains("crossed");
    }

    protected static String getSeverityFilterPhase(String sev) {
        try {
            if (sev == null) {
                return "";
            }
            if (ALLEVENTS.equals(sev)) {
                return "";
            }
            int sevInt = Severity.valueOf(sev.toUpperCase()).getValue();
            return "AND (EVENTS.SEVERITY = " + sevInt + ")";
        }
        catch (Exception ex) {
            _Logger.error((Object)("Unable to decode severity: " + ex.getMessage()));
            return "";
        }
    }

    public static String getIntervalPhrase(String interval) {
        boolean usingOracle = ConnectionManager.getDbDriver().startsWith("oracle");
        if (interval.trim().equals("Last 10 Minutes")) {
            if (usingOracle) {
                return " AND ( EVENTS.LAST_SEEN > SYSDATE - (10/1440) )";
            }
            return " AND ( (current_timestamp-EVENTS.LAST_SEEN) < INTERVAL '10 minutes' )";
        }
        if (interval.trim().equals("Last Hour")) {
            if (usingOracle) {
                return " AND ( EVENTS.LAST_SEEN > SYSDATE - (60/1440) )";
            }
            return " AND ( (current_timestamp-EVENTS.LAST_SEEN) < INTERVAL '1 hour' )";
        }
        if (interval.trim().equals("24 Hours")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,EVENTS.LAST_SEEN)*31 <= 1 )";
            }
            return " AND ( (current_date-EVENTS.LAST_SEEN) < INTERVAL '1 day' )";
        }
        if (interval.trim().equals("Week")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,EVENTS.LAST_SEEN)*31 <= 7 )";
            }
            return " AND ( (current_date-EVENTS.LAST_SEEN) < INTERVAL '7 days' )";
        }
        if (interval.trim().equals("Month")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,EVENTS.LAST_SEEN) <= 1 )";
            }
            return " AND ( (current_date-EVENTS.LAST_SEEN) < INTERVAL '30 days' )";
        }
        if (interval.trim().equals("Year")) {
            if (usingOracle) {
                return " AND ( MONTHS_BETWEEN(SYSDATE,EVENTS.LAST_SEEN)*31 <= 365 )";
            }
            return " AND ( (current_date-EVENTS.LAST_SEEN) < INTERVAL '365 days' )";
        }
        return "";
    }

    public static void main(String ... strings) throws Exception {
        System.setProperty("db.driver", "org.postgresql.Driver");
        System.setProperty("db.url", "jdbc:postgresql://171.71.58.41:5432/dcmdb");
        System.setProperty("db.user", "yelguan");
        System.setProperty("db.password", "password");
        DbFilterDO dbFilter = new DbFilterDO();
        dbFilter.setFilterStr("2012/07/26-10:05:18");
        int count = EventSummaryHandler.getInstance().checkNewEvents(dbFilter);
        System.out.println(">>>>> count = " + count);
    }
}

