/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.health;

import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.sm.server.web.health.EventHandler;
import com.cisco.dcbu.sm.server.web.health.EventTokenizer;
import com.cisco.dcbu.sm.server.web.health.EventWrapper;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HardwareTokenizer
implements EventTokenizer {
    static final String[] SEVERITY_LABELS = new String[]{"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug"};
    static final int TIMESTAMP = 1;
    static final int FACILITY = 2;
    static final int SEVERITY = 3;
    static final int EVENT = 4;
    static final int VSAN_TIMESTAMP = 5;
    static final int VSAN = 6;
    static final int VSAN_ID = 7;
    static final int HOST_TIMESTAMP = 8;
    static final int DESCRIPTION = 9;
    static final int DESCRIPTION2 = 2;
    static final String SYSLOG_REGEX = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\S*): +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +(.*)";
    static final String SYSLOG_REGEX2 = "(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\S*): +(.*)";
    static Pattern _Pattern1 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\S*): +%([a-zA-Z_0-9\\-]+)-(\\d)-(\\w+):( +%\\$(VSAN (\\d+))?:? *(.*)%\\$)? +(.*)");
    static Pattern _Pattern2 = Pattern.compile("(\\d* *[a-zA-Z]{3} +\\d+ +\\d{2}:\\d{2}:\\d{2} +\\S*): +(.*)");

    HardwareTokenizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBEntryDO getEvents(String device, String name, String file) throws FileNotFoundException {
        String fileName = EventHandler.REPOSITORY + File.separator + device + File.separator + file;
        ArrayList<EventWrapper> list = new ArrayList<EventWrapper>();
        FileReader reader = null;
        BufferedReader breader = null;
        DBEntryDO dbEntry = null;
        try {
            if (device != null) {
                String line;
                reader = new FileReader(fileName);
                breader = new BufferedReader(reader);
                while ((line = breader.readLine()) != null) {
                    int prefix = line.indexOf(">:");
                    if (prefix != -1) {
                        line = line.substring(prefix + 3);
                    }
                    EventWrapper wrapper = this.tokenize(line);
                    list.add(0, wrapper);
                }
            }
            dbEntry = EventHandler.convertEventToDBEntryDTO(list);
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException(" Hardware events not available for " + name);
        }
        catch (IOException ex) {
            EventHandler._Logger.error((Object)ex.getMessage());
        }
        finally {
            try {
                if (breader != null) {
                    breader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {
                EventHandler._Logger.warn((Object)"Unable to close file.");
            }
        }
        return dbEntry;
    }

    private EventWrapper tokenize(String line) {
        EventWrapper wrapper = new EventWrapper();
        Matcher m = _Pattern1.matcher(line);
        if (m.matches()) {
            wrapper.setSwitchTime(m.group(1));
            wrapper.setFacility(m.group(2));
            String tmp = m.group(3);
            int severityLevel = Integer.parseInt(tmp);
            wrapper.setSeverity(SEVERITY_LABELS[severityLevel]);
            wrapper.setEvent(m.group(4));
            wrapper.setVsanId(m.group(7));
            wrapper.setHostTime(m.group(8));
            wrapper.setDescription(DisplayUtil.formatLongString(m.group(9), 60));
        } else {
            m = _Pattern2.matcher(line);
            if (m.matches()) {
                wrapper.setSwitchTime(m.group(1));
                wrapper.setDescription(DisplayUtil.formatLongString(m.group(2), 60));
            } else {
                wrapper.setDescription(DisplayUtil.formatLongString(line, 60));
            }
        }
        return wrapper;
    }
}

