/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.web.inventory.IslHandler;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.PerfUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class NpvLinkStatHandler {
    private static NpvLinkStatHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;

    public static NpvLinkStatHandler getInstance() {
        if (_Instance == null) {
            _Instance = new NpvLinkStatHandler();
        }
        return _Instance;
    }

    private NpvLinkStatHandler() {
    }

    public String ifIndexToName(int index, int switchType) {
        if (FRUConstants.isN5K(switchType)) {
            return IfIndexUtil.ifIndexToNameForN5K(index, switchType);
        }
        switch (switchType) {
            case 601: {
                return IfIndexUtil.ifIndexToNameInagua(index);
            }
            case 606: 
            case 773: {
                return IfIndexUtil.ifIndexToNameChester(index);
            }
            case 843: {
                return IfIndexUtil.ifIndexToNameCassino(index);
            }
        }
        return IfIndexUtil.ifIndexToName(index);
    }

    public ArrayList<StatisticsDataDO> getNpvLinkStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        this.getNpvLinkStatList(records, dbFilter, interval, startIdx, recordSize, false);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNpvLinkStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, boolean lengthOnly) {
        Connection con = null;
        Statement stmt = null;
        Statement infoStmt = null;
        ResultSet rs = null;
        ResultSet rsInfo = null;
        try {
            con = ConnectionManager.getConnection();
            Hashtable<String, ArrayList<String>> info = new Hashtable<String, ArrayList<String>>();
            String sql = null;
            String infoSql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            String sortString = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval);
            int[] indices = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
            String[] columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString};
            String prefix = "PerformanceAction.";
            if (dbFilter.getVsanDbId() != -1L) {
                sql = SQLLoader.getSql(prefix + "NpvLink_VSAN_STMT", indices, columns);
                infoSql = SQLLoader.getSql(prefix + "NpvLink_INFO_VSAN_STMT");
                infoStmt = con.prepareStatement(infoSql);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, dbFilter.getFabricDbId());
                stmt.setLong(2, dbFilter.getVsanDbId());
                infoStmt.setLong(1, dbFilter.getFabricDbId());
                infoStmt.setLong(2, dbFilter.getVsanDbId());
            } else if (dbFilter.getFabricDbId() != -1L) {
                infoSql = SQLLoader.getSql(prefix + "NpvLink_INFO_FABRIC_STMT");
                infoStmt = con.prepareStatement(infoSql);
                infoStmt.setLong(1, dbFilter.getFabricDbId());
                if (dbFilter.isGroup()) {
                    sql = SQLLoader.getSql(prefix + "NpvLink_GROUP_STMT", indices, columns);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, dbFilter.getFabricDbId());
                    stmt.setLong(2, dbFilter.getGroupId());
                } else {
                    sql = SQLLoader.getSql(prefix + "NpvLink_FABRIC_STMT", indices, columns);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, dbFilter.getFabricDbId());
                }
            } else {
                String groupFabricFilterSqlSuffix;
                String roleFilter = " 1 = 1 ";
                String filterStr = groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
                int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 99, 9};
                String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, sortString, roleFilter, filterStr};
                sql = SQLLoader.getSql(prefix + "NpvLink_STMT", ind, rep);
                infoSql = SQLLoader.getSql(prefix + "NpvLink_INFO_STMT");
                infoStmt = con.prepareStatement(infoSql);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            }
            rs = SQLLoader.execute((PreparedStatement)stmt);
            if (lengthOnly) {
                rs.last();
                int roleFilter = rs.getRow();
                return roleFilter;
            }
            rsInfo = SQLLoader.execute((PreparedStatement)infoStmt);
            while (rsInfo.next()) {
                long id = rsInfo.getLong(1);
                long vid = rsInfo.getLong(2);
                ArrayList<String> infoList = (ArrayList<String>)info.get(id + "");
                if (infoList == null) {
                    infoList = new ArrayList<String>();
                }
                infoList.add(vid + "");
                info.put(id + "", infoList);
            }
            rs = SQLLoader.execute((PreparedStatement)stmt);
            Hashtable group = new Hashtable();
            ArrayList tpList = new ArrayList();
            ArrayList luList = new ArrayList();
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                long srcId = rs.getLong(2);
                long dstId = rs.getLong(3);
                double rx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                double tx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                double maxRx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                double maxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                long speed = rs.getLong(10) / 10L;
                long sourceId = rs.getLong(11);
                String xml = rs.getString(12);
                String rrd = rs.getString(13);
                String name = "Unknown";
                String src = rs.getString(14);
                byte[] srcWwn = rs.getBytes(15);
                String dst = rs.getString(16);
                byte[] dstWwn = rs.getBytes(17);
                double rxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 18));
                int paramType = rs.getInt(19);
                Timestamp lastUpdated = rs.getTimestamp(20);
                int switchType1 = rs.getInt(21);
                int switchType2 = rs.getInt(22);
                byte[] s1Wwn = rs.getBytes(23);
                byte[] s2Wwn = rs.getBytes(24);
                int chdrnCnt = rs.getInt(25);
                long fid = rs.getLong(26);
                int rxUtil = -1;
                int txUtil = -1;
                int pRxUtil = -1;
                int pTxUtil = -1;
                ArrayList membersOf = (ArrayList)info.get(sourceId + "");
                StatisticsDataDO wrapper = null;
                boolean grouped = false;
                double tp = Double.isNaN(rxTx) ? 0.0 : rxTx;
                double util = tp == 0.0 ? 0.0 : tp / (double)(2L * speed) * 100.0;
                wrapper = new StatisticsDataDO(0L, 0L);
                int index1 = Integer.parseInt(src.substring(src.lastIndexOf(58) + 1).trim());
                src = src.substring(0, src.lastIndexOf(58)) + " " + this.ifIndexToName(index1, switchType1);
                int index2 = Integer.parseInt(dst.substring(dst.lastIndexOf(58) + 1).trim());
                dst = dst.substring(0, dst.lastIndexOf(58)) + " " + this.ifIndexToName(index2, switchType2);
                if (src != null) {
                    name = dst != null ? src + "<->" + dst : src;
                }
                wrapper.setRrdFile(rrd);
                wrapper.setPmtype(paramType);
                wrapper.setEntityName(name);
                wrapper.setChdCnt(chdrnCnt);
                wrapper.setFid(fid);
                wrapper.setDbId(sourceId);
                wrapper.setInterval(interval);
                if (speed > 0L) {
                    rx = this.capTrafficWithSpeed(rx, speed);
                    tx = this.capTrafficWithSpeed(tx, speed);
                    maxRx = this.capTrafficWithSpeed(maxRx, speed);
                    maxTx = this.capTrafficWithSpeed(maxTx, speed);
                    rxUtil = !Double.isNaN(rx) ? (int)(rx / (double)speed * 100.0) : -1;
                    txUtil = !Double.isNaN(tx) ? (int)(tx / (double)speed * 100.0) : -1;
                    pRxUtil = !Double.isNaN(maxRx) ? (int)(maxRx / (double)speed * 100.0) : -1;
                    pTxUtil = !Double.isNaN(maxTx) ? (int)(maxTx / (double)speed * 100.0) : -1;
                }
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                if (grouped) {
                    speed = (long)((double)speed + wrapper.getSpeed());
                    rx += wrapper.getLastDayAvgRx();
                    tx += wrapper.getLastDayAvgTx();
                    maxRx += wrapper.getLastDayMaxRx();
                    maxTx += wrapper.getLastDayMaxTx();
                    errors += wrapper.getError();
                    discards += wrapper.getDiscard();
                    rxTx += wrapper.getLastDayAvgRx() + wrapper.getLastDayAvgTx();
                }
                wrapper.setTitle(name);
                wrapper.setFabric(fabric);
                wrapper.setVsanStr(IslHandler.convertArrayListToString(membersOf, ","));
                wrapper.setSpeed((double)speed);
                wrapper.setLastDayAvgRx(rx);
                wrapper.setLastDayAvgTx(tx);
                wrapper.setLastDayMaxRx(maxRx);
                wrapper.setLastDayMaxTx(maxTx);
                wrapper.setError(errors);
                wrapper.setDiscard(discards);
                wrapper.setRxTx(rxTx);
                wrapper.setSpeedStr(DisplayUtil.formatSpeed(speed * 10L));
                if (speed == 0L) {
                    wrapper.setSpeedStr("n/a");
                }
                wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                int threshold = PmCollect._MetaData._thresholdDef._highWaterMark;
                wrapper.setHighThreshold(threshold);
                wrapper.setRxUtil(rxUtil);
                wrapper.setTxUtil(txUtil);
                wrapper.setpRxUtil(pRxUtil);
                wrapper.setpTxUtil(pTxUtil);
                wrapper.setIndex(curIdx + startIdx + 1);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
                break;
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)"failed to get NPV link stat", (Throwable)ex);
        }
        finally {
            try {
                ConnectionManager.returnConnection(con);
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (rsInfo != null) {
                    rsInfo.close();
                }
                if (infoStmt != null) {
                    infoStmt.close();
                }
            }
            catch (Exception ex) {}
        }
        return 0;
    }

    public int getNpvLinkStatDataLength(DbFilterDO dbFilter, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getNpvLinkStatList(records, dbFilter, interval, 0, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<StatisticsDataDO> getPcMemList(long npvLinkId, String interval) {
        ArrayList<StatisticsDataDO> records;
        block10: {
            records = new ArrayList<StatisticsDataDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                String sql = null;
                String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
                String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
                String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
                String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
                String errorCol = PerfUtil.getErrorIntervalColumn(interval);
                String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
                String totalCol = PerfUtil.getTotalIntervalColumn(interval);
                String prefix = "PerformanceAction.";
                int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
                String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, totalCol};
                sql = SQLLoader.getSql(prefix + "NpvLink_CHNL_MEM_STMT", ind, rep);
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, npvLinkId);
                rs = SQLLoader.execute(stmt);
                int idx = 1;
                while (rs.next()) {
                    String fabric = rs.getString(1);
                    int srcId = rs.getInt(2);
                    int dstId = rs.getInt(3);
                    double rx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                    double tx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                    double maxRx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                    double maxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                    double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                    double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                    long speed = rs.getLong(10) / 10L;
                    int sourceId = rs.getInt(11);
                    String xml = rs.getString(12);
                    String rrd = rs.getString(13);
                    String name = "Unknown";
                    String src = rs.getString(14);
                    byte[] srcWwn = rs.getBytes(15);
                    String dst = rs.getString(16);
                    byte[] dstWwn = rs.getBytes(17);
                    double rxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 18));
                    int paramType = rs.getInt(19);
                    Timestamp lastUpdated = rs.getTimestamp(20);
                    int switchType1 = rs.getInt(21);
                    int switchType2 = rs.getInt(22);
                    byte[] s1Wwn = rs.getBytes(23);
                    byte[] s2Wwn = rs.getBytes(24);
                    long fid = rs.getLong(25);
                    int rxUtil = -1;
                    int txUtil = -1;
                    int pRxUtil = -1;
                    int pTxUtil = -1;
                    StatisticsDataDO wrapper = null;
                    boolean grouped = false;
                    double tp = Double.isNaN(rxTx) ? 0.0 : rxTx;
                    double util = tp == 0.0 ? 0.0 : tp / (double)(2L * speed) * 100.0;
                    wrapper = new StatisticsDataDO(0L, 0L);
                    int index1 = Integer.parseInt(src.substring(src.lastIndexOf(58) + 1).trim());
                    src = src.substring(0, src.lastIndexOf(58)) + " " + DisplayUtil.ifIndexToName(index1, switchType1);
                    int index2 = Integer.parseInt(dst.substring(dst.lastIndexOf(58) + 1).trim());
                    dst = dst.substring(0, dst.lastIndexOf(58)) + " " + DisplayUtil.ifIndexToName(index2, switchType2);
                    if (src != null) {
                        name = dst != null ? src + "<->" + dst : src;
                    }
                    wrapper.setRrdFile(rrd);
                    wrapper.setPmtype(paramType);
                    wrapper.setEntityName(name);
                    wrapper.setFid(fid);
                    wrapper.setDbId((long)sourceId);
                    if (speed > 0L) {
                        rx = this.capTrafficWithSpeed(rx, speed);
                        tx = this.capTrafficWithSpeed(tx, speed);
                        maxRx = this.capTrafficWithSpeed(maxRx, speed);
                        maxTx = this.capTrafficWithSpeed(maxTx, speed);
                        rxUtil = !Double.isNaN(rx) ? (int)(rx / (double)speed * 100.0) : -1;
                        txUtil = !Double.isNaN(tx) ? (int)(tx / (double)speed * 100.0) : -1;
                        pRxUtil = !Double.isNaN(maxRx) ? (int)(maxRx / (double)speed * 100.0) : -1;
                        pTxUtil = !Double.isNaN(maxTx) ? (int)(maxTx / (double)speed * 100.0) : -1;
                    }
                    wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                    wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                    if (grouped) {
                        speed = (long)((double)speed + wrapper.getSpeed());
                        rx += wrapper.getLastDayAvgRx();
                        tx += wrapper.getLastDayAvgTx();
                        maxRx += wrapper.getLastDayMaxRx();
                        maxTx += wrapper.getLastDayMaxTx();
                        errors += wrapper.getError();
                        discards += wrapper.getDiscard();
                        rxTx += wrapper.getLastDayAvgRx() + wrapper.getLastDayAvgTx();
                    }
                    wrapper.setTitle(name);
                    wrapper.setFabric(fabric);
                    wrapper.setSpeed((double)speed);
                    wrapper.setLastDayAvgRx(rx);
                    wrapper.setLastDayAvgTx(tx);
                    wrapper.setLastDayMaxRx(maxRx);
                    wrapper.setLastDayMaxTx(maxTx);
                    wrapper.setError(errors);
                    wrapper.setDiscard(discards);
                    wrapper.setRxTx(rxTx);
                    wrapper.setSpeedStr(DisplayUtil.formatSpeed(speed * 10L));
                    if (speed == 0L) {
                        wrapper.setSpeedStr("n/a");
                    }
                    wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                    wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                    wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                    wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                    wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                    wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                    wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                    int threshold = PmCollect._MetaData._thresholdDef._highWaterMark;
                    wrapper.setHighThreshold(threshold);
                    wrapper.setRxUtil(rxUtil);
                    wrapper.setTxUtil(txUtil);
                    wrapper.setpRxUtil(pRxUtil);
                    wrapper.setpTxUtil(pTxUtil);
                    wrapper.setIndex(idx++);
                    records.add(wrapper);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return records;
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    private double capTrafficWithSpeed(double traffic, long speed) {
        double ret = traffic;
        if (traffic > (double)speed) {
            ret = speed;
        }
        return ret;
    }

    private String getSqlSortSuffix(String sortField, String sortType, String interval) {
        StringBuilder sortStr = new StringBuilder();
        if (sortField.equals("avgRxStr")) {
            sortStr.append(PerfUtil.getAvgIntervalColumn(interval)).append("RX");
        } else if (sortField.equals("avgTxStr")) {
            sortStr.append(PerfUtil.getAvgIntervalColumn(interval)).append("TX");
        } else if (sortField.equals("maxRxStr")) {
            sortStr.append(PerfUtil.getMaxIntervalColumn(interval)).append("RX");
        } else if (sortField.equals("maxTxStr")) {
            sortStr.append(PerfUtil.getMaxIntervalColumn(interval)).append("TX");
        } else if (sortField.equals("errorStr")) {
            sortStr.append(PerfUtil.getErrorIntervalColumn(interval));
        } else if (sortField.equals("discardStr")) {
            sortStr.append(PerfUtil.getDiscardIntervalColumn(interval));
        } else if (sortField.equals("rxTxStr")) {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        } else if (sortField.equals("speedStr")) {
            sortStr.append("SP1.IF_SPEED");
        } else if (sortField.equals("rxUtil")) {
            sortStr.append("RX_UTIL");
        } else if (sortField.equals("txUtil")) {
            sortStr.append("TX_UTIL");
        } else if (sortField.equals("pRxUtil")) {
            sortStr.append("PEAK_RX_UTIL");
        } else if (sortField.equals("pTxUtil")) {
            sortStr.append("PEAK_TX_UTIL");
        } else {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        sortStr.append(" ").append(sortType);
        return sortStr.toString();
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        int length = NpvLinkStatHandler.getInstance().getNpvLinkStatDataLength(dbFilter, "24 Hours");
        System.out.println("length is :" + length);
        ArrayList<StatisticsDataDO> rstList = NpvLinkStatHandler.getInstance().getNpvLinkStatList(dbFilter, "24 Hours", 0, 31);
        int count = 0;
        for (StatisticsDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getTitle() + " : " + e.getLastUpdateTimeStr());
        }
        boolean i = false;
    }

    public String printNpvLinkStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = NpvLinkStatHandler.getInstance().getNpvLinkStatList(dbFilter, interval, startIdx, recordSize);
        String title = "Performance NPV Link";
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Speed", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg.", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg%", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak%", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxUtil", "rxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "txUtil", "txUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pRxUtil", "pRxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pTxUtil", "pTxUtilStr");
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, columnAlignment, rstList);
    }

    public String exportNpvLinkStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = NpvLinkStatHandler.getInstance().getNpvLinkStatList(dbFilter, interval, startIdx, recordSize);
        String title = "Performance NPV Link";
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Speed", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg.", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg%", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak%", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxUtil", "rxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "txUtil", "txUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pRxUtil", "pRxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pTxUtil", "pTxUtilStr");
        boolean unitlessFlag = true;
        String export_unitless = System.getProperties().getProperty("export.unitless");
        if (export_unitless != null) {
            unitlessFlag = Boolean.getBoolean("export.unitless");
        }
        String export_unit = System.getProperties().getProperty("export.unit");
        if (unitlessFlag) {
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "speedStr", "speed");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgRxStr", "lastDayAvgRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgTxStr", "lastDayAvgTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxTxStr", "rxTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxRxStr", "lastDayMaxRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxTxStr", "lastDayMaxTx");
        } else if (export_unit != null) {
            DisplayUtil.convertToExportUnit(rstList, export_unit);
        }
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, columnAlignment, rstList);
    }
}

