/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.PerfUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OidStatHandler {
    private static OidStatHandler _Instance = null;
    public static int TYPE_ALL = 0;
    public static int TYPE_CPU = 1;
    public static int TYPE_MEMORY = 2;
    public static int TYPE_OTHER = 3;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;
    private int sanDataLength = 0;
    private int lanDataLength = 0;
    private Map<String, String> _FilterHash = new HashMap<String, String>();

    public static OidStatHandler getInstance() {
        if (_Instance == null) {
            _Instance = new OidStatHandler();
        }
        return _Instance;
    }

    private OidStatHandler() {
        this.initSqlSuffix();
    }

    private void initSqlSuffix() {
        this._FilterHash.put("entityName", " PO.SWITCHNAME like ");
    }

    public int getOidStatDataLength(DbFilterDO dbFilter, String interval, int type) {
        int totalLength = 0;
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("SAN")) {
            this.sanDataLength = this.getOidSanStatDataLength(dbFilter, interval, type);
            totalLength += this.sanDataLength;
        }
        if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("LAN")) {
            this.lanDataLength = this.getOidLanStatDataLength(dbFilter, interval, type);
            totalLength += this.lanDataLength;
        }
        return totalLength;
    }

    public int getOidSanStatDataLength(DbFilterDO dbFilter, String interval, int type) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getOidSanStatList(records, dbFilter, interval, 0, 1, type, true);
    }

    public int getOidLanStatDataLength(DbFilterDO dbFilter, String interval, int type) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getOidLanStatList(records, dbFilter, interval, 0, 1, type, true);
    }

    public ArrayList<StatisticsDataDO> getOidStatList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, int type) {
        ArrayList<StatisticsDataDO> records;
        String networkType = dbFilter.getNetworkType();
        ArrayList<StatisticsDataDO> totalList = new ArrayList<StatisticsDataDO>();
        int sanStartIdx = 0;
        int lanStartIdx = 0;
        int sanRecordSize = 0;
        int lanRecordSize = 0;
        if (networkType != null && networkType.equals("Data Center")) {
            if (startIdx < this.sanDataLength) {
                sanStartIdx = startIdx;
                int retrieveSize = sanStartIdx + recordSize;
                if (retrieveSize < this.sanDataLength) {
                    sanRecordSize = recordSize;
                } else {
                    sanRecordSize = this.sanDataLength - sanStartIdx;
                    lanRecordSize = recordSize - sanRecordSize;
                    lanStartIdx = 0;
                }
            } else {
                sanStartIdx = this.sanDataLength;
                sanRecordSize = 0;
                lanStartIdx = startIdx - this.sanDataLength;
                lanRecordSize = recordSize;
            }
        } else {
            sanStartIdx = lanStartIdx = startIdx;
            sanRecordSize = lanRecordSize = recordSize;
        }
        if (networkType != null && (networkType.equals("SAN") || networkType.equals("Data Center"))) {
            records = new ArrayList<StatisticsDataDO>();
            this.getOidSanStatList(records, dbFilter, interval, sanStartIdx, sanRecordSize, type, false);
            totalList.addAll(records);
        }
        if (networkType != null && (networkType.equals("LAN") || networkType.equals("Data Center"))) {
            records = new ArrayList();
            this.getOidLanStatList(records, dbFilter, interval, lanStartIdx, lanRecordSize, type, false);
            totalList.addAll(records);
        }
        return totalList;
    }

    private String getType(int type) {
        switch (type) {
            case 1: {
                return "CPU";
            }
            case 2: {
                return "Memory";
            }
        }
        return "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getOidSanStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, int type, boolean lengthOnly) {
        String suffix = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval, false);
        String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
        String colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash);
        suffix = groupFabricFilterSqlSuffix + colFilterSqlSuffix + suffix;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            block28: {
                String prefix;
                String discardCol;
                String errorCol;
                String maxTxCol;
                String maxRxCol;
                String avgTxCol;
                String avgRxCol;
                String sql;
                block29: {
                    String[] columns;
                    int[] indices;
                    block27: {
                        con = ConnectionManager.getConnection();
                        sql = null;
                        avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
                        avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
                        maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
                        maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
                        errorCol = PerfUtil.getErrorIntervalColumn(interval);
                        discardCol = PerfUtil.getDiscardIntervalColumn(interval);
                        String totalCol = PerfUtil.getTotalIntervalColumn(interval);
                        indices = new int[]{1, 2, 3, 4, 5, 6};
                        columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol};
                        prefix = "PerformanceAction.";
                        if (dbFilter.getFabricDbId() == -1L || dbFilter.getVsanDbId() == -1L) break block27;
                        sql = SQLLoader.getSql(prefix + (type != TYPE_OTHER ? "OID_VSAN_FABRIC_STMT" : "OID_OTHER_VSAN_FABRIC_STMT"), indices, columns);
                        sql = sql + suffix;
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        stmt.setLong(1, dbFilter.getFabricDbId());
                        stmt.setLong(2, dbFilter.getVsanDbId());
                        if (type != TYPE_OTHER) {
                            stmt.setString(3, this.getType(type));
                        }
                        break block28;
                    }
                    if (dbFilter.getFabricDbId() == -1L) break block29;
                    if (dbFilter.getGroupId() != -1L) {
                        sql = SQLLoader.getSql(prefix + (type != TYPE_OTHER ? "OID_GROUP_FABRIC_STMT" : "OID_OTHER_GROUP_FABRIC_STMT"), indices, columns);
                        sql = sql + suffix;
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        stmt.setLong(1, dbFilter.getFabricDbId());
                        stmt.setLong(2, dbFilter.getGroupId());
                        if (type != TYPE_OTHER) {
                            stmt.setString(3, this.getType(type));
                        }
                        break block28;
                    } else {
                        sql = SQLLoader.getSql(prefix + (type != TYPE_OTHER ? "OID_FABRIC_STMT" : "OID_OTHER_FABRIC_STMT"), indices, columns);
                        sql = sql + suffix;
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        stmt.setLong(1, dbFilter.getFabricDbId());
                        if (type != TYPE_OTHER) {
                            stmt.setString(2, this.getType(type));
                        }
                    }
                    break block28;
                }
                String roleFilter = " 1=1 ";
                int[] ind = new int[]{1, 2, 3, 4, 5, 6};
                String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol};
                sql = SQLLoader.getSql(prefix + (type != TYPE_OTHER ? "OID_STMT" : "OID_OTHER_STMT"), ind, rep);
                sql = sql + suffix;
                stmt = con.prepareStatement(sql);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                if (type != TYPE_OTHER) {
                    stmt.setString(1, this.getType(type));
                }
            }
            rs = SQLLoader.execute(stmt);
            if (lengthOnly) {
                rs.last();
                int roleFilter = rs.getRow();
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                return roleFilter;
            }
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                long srcId = rs.getLong(2);
                long dstId = rs.getLong(3);
                Double rx = DisplayUtil.formatPmStat((Double)rs.getObject(4));
                Double tx = DisplayUtil.formatPmStat((Double)rs.getObject(5));
                Double maxRx = DisplayUtil.formatPmStat(new Double((Double)rs.getObject(6)));
                Double maxTx = DisplayUtil.formatPmStat(new Double((Double)rs.getObject(7)));
                if (type == TYPE_MEMORY || type == TYPE_CPU) {
                    if (rx > 100.0) {
                        rx = new Double(100.0);
                    }
                    if (tx > 100.0) {
                        tx = new Double(100.0);
                    }
                    if (maxRx > 100.0) {
                        maxRx = new Double(100.0);
                    }
                    if (maxTx > 100.0) {
                        maxTx = new Double(100.0);
                    }
                }
                Double errors = DisplayUtil.formatPmStat((Double)rs.getObject(8));
                Double discards = DisplayUtil.formatPmStat((Double)rs.getObject(9));
                String xml = rs.getString(10);
                String rrd = rs.getString(11);
                String displayName = rs.getString(12);
                String switchIP = rs.getString(13);
                String oidName = rs.getString(14);
                Timestamp lastUpdated = rs.getTimestamp(15);
                long fid = rs.getLong(16);
                String switchName = rs.getString(17);
                long swId = rs.getLong(18);
                this._Log.debug((Object)("RX=" + rx + " TX=" + tx + " Max RX=" + maxRx + " Max Tx" + maxTx + " Errors=" + errors + " Discard=" + discards));
                StatisticsDataDO wrapper = new StatisticsDataDO(srcId, dstId);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                wrapper.setFabric(fabric);
                wrapper.setAvgRxStr(!rx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)rx.doubleValue()) : "n/a");
                if (type == TYPE_ALL) {
                    wrapper.setAvgTxStr(!tx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)tx.doubleValue()) : "n/a");
                } else {
                    wrapper.setAvgTxStr(!tx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)tx.doubleValue()) : "n/a");
                }
                wrapper.setMaxRxStr(!maxRx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)maxRx.doubleValue()) : "n/a");
                if (type == TYPE_ALL) {
                    wrapper.setMaxTxStr(!maxTx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)maxTx.doubleValue()) : "n/a");
                } else {
                    wrapper.setMaxTxStr(!maxTx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)maxTx.doubleValue()) : "n/a");
                }
                wrapper.setErrorStr(!errors.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)errors.doubleValue()) : "n/a");
                wrapper.setDiscardStr(!discards.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)discards.doubleValue()) : "n/a");
                wrapper.setTitle(displayName);
                wrapper.setEntityName(switchName);
                wrapper.setRrdFile(rrd);
                wrapper.setPmtype(5);
                wrapper.setFid(fid);
                wrapper.setSwitchDbId(swId);
                wrapper.setLan(false);
                if (type == TYPE_MEMORY || type == TYPE_CPU || type == TYPE_OTHER) {
                    wrapper.clipStatUnit();
                }
                wrapper.setIndex(curIdx + startIdx + 1);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
            }
            DbUtil.close(stmt);
        }
        catch (SQLException ex) {
            this._Log.error((Object)"OidStatHandler", (Throwable)ex);
            return records.size();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception exe) {
                this._Log.error((Object)"OidStatHandler", (Throwable)exe);
                return records.size();
            }
        }
        finally {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(con);
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getOidLanStatList(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String interval, int startIdx, int recordSize, int type, boolean lengthOnly) {
        String suffix = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval, true);
        String groupLanFilterSqlSuffix = NavigationUtil.getInstance().getLanIdsInGroup(dbFilter.getGroupFilterXml());
        String colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash);
        suffix = groupLanFilterSqlSuffix + colFilterSqlSuffix + suffix;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = null;
            String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
            String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
            String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
            String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
            String errorCol = PerfUtil.getErrorIntervalColumn(interval);
            String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
            String totalCol = PerfUtil.getTotalIntervalColumn(interval);
            String prefix = "PerformanceAction.";
            String roleFilter = " 1=1 ";
            int[] ind = new int[]{1, 2, 3, 4, 5, 6};
            String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol};
            sql = type != TYPE_OTHER ? SQLLoader.getSql(prefix + "OID_LAN_STMT", ind, rep) : SQLLoader.getSql(prefix + "OID_OTHER_LAN_STMT", ind, rep);
            sql = sql + suffix;
            stmt = con.prepareStatement(sql);
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            if (type != TYPE_OTHER) {
                stmt.setString(1, this.getType(type));
            }
            rs = SQLLoader.execute(stmt);
            if (lengthOnly) {
                rs.last();
                int n = rs.getRow();
                DbUtil.close(stmt);
                DbUtil.close(rs);
                DbUtil.close(con);
                return n;
            }
            if (startIdx != 0) {
                rs.absolute(startIdx);
            }
            int curIdx = 0;
            while (rs.next()) {
                String fabric = rs.getString(1);
                long srcId = rs.getLong(2);
                long dstId = rs.getLong(3);
                Double rx = DisplayUtil.formatPmStat((Double)rs.getObject(4));
                Double tx = DisplayUtil.formatPmStat((Double)rs.getObject(5));
                Double maxRx = DisplayUtil.formatPmStat(new Double((Double)rs.getObject(6)));
                Double maxTx = DisplayUtil.formatPmStat(new Double((Double)rs.getObject(7)));
                if (type == TYPE_MEMORY || type == TYPE_CPU) {
                    if (rx > 100.0) {
                        rx = new Double(100.0);
                    }
                    if (tx > 100.0) {
                        tx = new Double(100.0);
                    }
                    if (maxRx > 100.0) {
                        maxRx = new Double(100.0);
                    }
                    if (maxTx > 100.0) {
                        maxTx = new Double(100.0);
                    }
                }
                Double errors = DisplayUtil.formatPmStat((Double)rs.getObject(8));
                Double discards = DisplayUtil.formatPmStat((Double)rs.getObject(9));
                String xml = rs.getString(10);
                String rrd = rs.getString(11);
                String displayName = rs.getString(12);
                String switchIP = rs.getString(13);
                String oidName = rs.getString(14);
                Timestamp lastUpdated = rs.getTimestamp(15);
                long fid = rs.getLong(16);
                String switchName = rs.getString(17);
                long swId = rs.getLong(18);
                this._Log.debug((Object)("RX=" + rx + " TX=" + tx + " Max RX=" + maxRx + " Max Tx" + maxTx + " Errors=" + errors + " Discard=" + discards));
                StatisticsDataDO wrapper = new StatisticsDataDO(srcId, dstId);
                wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                wrapper.setFabric(fabric);
                wrapper.setAvgRxStr(!rx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)rx.doubleValue()) : "n/a");
                if (type == TYPE_ALL) {
                    wrapper.setAvgTxStr(!tx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)tx.doubleValue()) : "n/a");
                } else {
                    wrapper.setAvgTxStr(!tx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)tx.doubleValue()) : "n/a");
                }
                wrapper.setMaxRxStr(!maxRx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)maxRx.doubleValue()) : "n/a");
                if (type == TYPE_ALL) {
                    wrapper.setMaxTxStr(!maxTx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)maxTx.doubleValue()) : "n/a");
                } else {
                    wrapper.setMaxTxStr(!maxTx.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)maxTx.doubleValue()) : "n/a");
                }
                wrapper.setErrorStr(!errors.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)errors.doubleValue()) : "n/a");
                wrapper.setDiscardStr(!discards.isNaN() ? DefaultSnmpNumberRenderer.formatLong((long)discards.doubleValue()) : "n/a");
                wrapper.setTitle(displayName);
                wrapper.setEntityName(switchName);
                wrapper.setRrdFile(rrd);
                wrapper.setPmtype(15);
                wrapper.setFid(fid);
                wrapper.setSwitchDbId(swId);
                wrapper.setLan(true);
                if (type == TYPE_MEMORY || type == TYPE_CPU || type == TYPE_OTHER) {
                    wrapper.clipStatUnit();
                }
                wrapper.setIndex(curIdx + startIdx + 1 + this.sanDataLength);
                records.add(wrapper);
                if (++curIdx < recordSize) continue;
            }
            DbUtil.close(stmt);
        }
        catch (SQLException ex) {
            this._Log.error((Object)"OidStatHandler", (Throwable)ex);
            return records.size();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception exe) {
                this._Log.error((Object)"OidStatHandler", (Throwable)exe);
                return records.size();
            }
        }
        finally {
            DbUtil.close(stmt);
            DbUtil.close(rs);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(con);
        return records.size();
    }

    private String getSqlSortSuffix(String sortField, String sortType, String interval, boolean isLan) {
        StringBuilder sortStr = new StringBuilder(" ORDER BY ");
        if (sortField.equals("avgRxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getAvgIntervalColumn(interval) + "RX"));
        } else if (sortField.equals("avgTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getAvgIntervalColumn(interval) + "TX"));
        } else if (sortField.equals("maxRxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getMaxIntervalColumn(interval) + "RX"));
        } else if (sortField.equals("maxTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getMaxIntervalColumn(interval) + "TX"));
        } else if (sortField.equals("errorStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getErrorIntervalColumn(interval)));
        } else if (sortField.equals("discardStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getDiscardIntervalColumn(interval)));
        } else if (sortField.equals("rxTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getTotalIntervalColumn(interval)));
        } else if (sortField.equals("speedStr")) {
            sortStr.append("SP1.IF_SPEED");
        } else {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getTotalIntervalColumn(interval)));
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        sortStr.append(" ").append(sortType);
        if (!isLan) {
            sortStr.append(", FABRIC.NAME ASC");
        }
        return sortStr.toString();
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        dbFilter.setSortField("rxTxStr");
        System.out.println("*********get other ************ :");
        int length = OidStatHandler.getInstance().getOidStatDataLength(dbFilter, "24 Hours", TYPE_MEMORY);
        System.out.println("length is : " + length);
        ArrayList<StatisticsDataDO> rstList = OidStatHandler.getInstance().getOidStatList(dbFilter, "24 Hours", 1, 30, TYPE_MEMORY);
        int count = 0;
        for (StatisticsDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getTitle() + ":" + e.getEntityName() + " : " + e.getLastUpdateTimeStr() + ":" + e.getRrdFile() + ":" + e.getFid() + ":" + e.getPmtype() + ":" + e.getAvgRxStr() + ":" + e.getMaxRxStr() + " : " + e.getFid());
        }
    }

    public String printOidStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, int type, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = OidStatHandler.getInstance().getOidStatList(dbFilter, interval, startIdx, recordSize, type);
        String title = "Performance All";
        if (type == TYPE_CPU) {
            title = "Performance CPU";
        } else if (type == TYPE_MEMORY) {
            title = "Performance Memory";
        } else if (type == TYPE_OTHER) {
            title = "Performance Others";
        }
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Avg %", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak %", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg./sec", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak/sec", HorizontalAlign.RIGHT);
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, columnAlignment, rstList);
    }

    public String exportOidStatTable(DbFilterDO dbFilter, String interval, int startIdx, int recordSize, int type, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = OidStatHandler.getInstance().getOidStatList(dbFilter, interval, startIdx, recordSize, type);
        String title = "Performance All";
        if (type == TYPE_CPU) {
            title = "Performance CPU";
        } else if (type == TYPE_MEMORY) {
            title = "Performance Memory";
        } else if (type == TYPE_OTHER) {
            title = "Performance Others";
        }
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Avg %", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak %", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg./sec", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak/sec", HorizontalAlign.RIGHT);
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, columnAlignment, rstList);
    }
}

