/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.jasper.report;

import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.server.web.jasper.report.ChartReport;
import com.cisco.dcbu.sm.server.web.jasper.report.DBEntryDODataSource;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportStyle;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportUtil;
import com.cisco.dcbu.sm.server.web.jasper.report.NestedCoumnTableReport;
import com.cisco.dcbu.sm.server.web.jasper.report.TocReport;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class JasperReportBuilder
extends FastReportBuilder {
    private static Logger _Logger = Logger.getLogger((String)"fms");
    protected String title;
    protected String dataSourceKey;
    protected Collection dataObjects;
    protected String[] columnHeader;
    protected String[] columnProperty;
    protected Collection<ColumnSet> columnSets;
    protected boolean nestedColumn = false;
    protected JasperDesign jasperDesign;
    protected Map params = new HashMap();
    protected boolean isMarkupLink = false;
    protected String anchorString;
    protected boolean isChartBuilder = false;
    protected List<String[]> chartList;
    protected boolean export2Xls = false;
    protected boolean isTocBuilder = false;
    protected List<String[]> tocList;
    private boolean isDiagnostic = false;
    protected HashMap<String, HorizontalAlign> columnAllignment = new HashMap();

    public boolean isDiagnostic() {
        return this.isDiagnostic;
    }

    public void setDiagnostic(boolean isDiagnostic) {
        this.isDiagnostic = isDiagnostic;
    }

    public JRDataSource getDataSource() {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Inside JasperReportBuilder - > getDataSource()");
        }
        Object ds = null;
        if (this.dataObjects == null) {
            return ds;
        }
        if (this.dataObjects.toArray().length == 0) {
            return ds;
        }
        Object obj = this.dataObjects.toArray()[0];
        if (obj instanceof DBEntryDO) {
            if (_Logger.isTraceEnabled()) {
                _Logger.info((Object)"Data source from DBEntryDO");
            }
            DBEntryDO dbEntryDO = (DBEntryDO)obj;
            ds = new DBEntryDODataSource(dbEntryDO);
        } else {
            ds = new JRBeanCollectionDataSource(this.dataObjects);
        }
        return ds;
    }

    protected void init() throws ColumnBuilderException, ClassNotFoundException {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Inside JasperReportBuilder - > init()");
        }
        if (this.getColumnSets() != null && JasperReportUtil.isNestedColumn(this.columnSets)) {
            try {
                if (_Logger.isTraceEnabled()) {
                    _Logger.info((Object)"Inside JasperReportBuilder - > Nested Column true !!!");
                }
                this.nestedColumn = true;
                NestedCoumnTableReport nestedCoumnTableReport = new NestedCoumnTableReport(this);
                this.jasperDesign = nestedCoumnTableReport.getJasperDesign();
                this.params.put("title", this.title);
            }
            catch (JRException e) {
                _Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ColumnBuilderException("Unable to create Nested Column Table: " + e.getMessage());
            }
        } else if (this.isChartBuilder) {
            try {
                if (_Logger.isTraceEnabled()) {
                    _Logger.info((Object)"Inside JasperReportBuilder - > isChartBuilder true !!!");
                }
                ChartReport imageReport = new ChartReport(this);
                this.jasperDesign = imageReport.getJasperDesign();
            }
            catch (JRException e) {
                _Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ColumnBuilderException("Unable to create image report: " + e.getMessage());
            }
        } else if (this.isTocBuilder) {
            try {
                if (_Logger.isTraceEnabled()) {
                    _Logger.info((Object)"Inside JasperReportBuilder - > isTocBuilder true !!!");
                }
                TocReport tocReport = new TocReport(this);
                this.jasperDesign = tocReport.getJasperDesign();
            }
            catch (JRException e) {
                _Logger.error((Object)e.getMessage(), (Throwable)e);
                throw new ColumnBuilderException("Unable to create tco report: " + e.getMessage());
            }
        } else {
            if (_Logger.isTraceEnabled()) {
                _Logger.info((Object)"Inside JasperReportBuilder - > Nested Column false !!!");
            }
            this.setIgnorePagination(false);
            this.setMargins(JasperReportStyle.MARGIN, 0, JasperReportStyle.MARGIN, JasperReportStyle.MARGIN);
            this.setUseFullPageWidth(false);
            this.setIgnorePagination(true);
            this.setPrintBackgroundOnOddRows(true);
            this.setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
            this.setOddRowBackgroundStyle(JasperReportStyle.getOddRowStyle());
            this.setTitleStyle(JasperReportStyle.getSubReportTitleStyle());
            this.setTemplateFile(System.getProperty("mds.nmsRoot") + "/conf/template.jrxml");
            this.params.put("title", this.title);
            if (this.anchorString != null && this.anchorString.trim().length() > 0) {
                this.params.put("anchor", this.anchorString);
            }
            this.createColumn();
        }
    }

    public Map getParams() {
        return this.params;
    }

    private void createColumn() throws ColumnBuilderException, ClassNotFoundException {
        if (this.getColumnSets() != null) {
            this.createColumnHeaderFromColumnSets();
        } else if (this.columnHeader != null && this.columnProperty != null) {
            this.createColumnHeaderFromProperties();
        } else {
            this.createColumnHeader();
        }
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    protected void createColumnHeader() throws ColumnBuilderException, ClassNotFoundException {
        Style headerStyle = JasperReportStyle.getHeaderStyle();
        Object obj = this.dataObjects.toArray()[0];
        PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors((Object)obj);
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor property = properties[i];
            if (property == null || !JasperReportBuilder.isValidProperty(property)) continue;
            int columnWidth = this.getColumnWidth(property);
            if (columnWidth < JasperReportBuilder.getColumnTitle(property).length() * 6) {
                columnWidth = JasperReportBuilder.getColumnTitle(property).length() * 6;
            }
            AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property.getName(), this.getPropertyType(property)).setTitle(JasperReportBuilder.getColumnTitle(property)).setFixedWidth(true).setWidth(columnWidth).setHeaderStyle(headerStyle).build();
            this.setColumnStyle(column, property);
            this.addColumn(column);
        }
    }

    protected void createColumnHeaderFromProperties() throws ColumnBuilderException, ClassNotFoundException {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Inside JasperReportBuilder - > createColumnHeaderFromProperties()");
        }
        Style headerStyle = JasperReportStyle.getHeaderStyle();
        Style detailStyle = JasperReportStyle.getDetailStyle();
        if (this.dataObjects != null && this.dataObjects.toArray().length == 0) {
            _Logger.warn((Object)"dataObects size is zero.  Returning....");
            return;
        }
        Object obj = this.dataObjects.toArray()[0];
        if (obj instanceof DBEntryDO) {
            if (_Logger.isTraceEnabled()) {
                _Logger.info((Object)"Inside JasperReportBuilder - > Creating column headers from DBEntryDO");
            }
            DBEntryDO entryDO = (DBEntryDO)obj;
            for (int idx = 0; idx < this.columnHeader.length; ++idx) {
                AbstractColumn column;
                int columnWidth = this.getColumnWidth(entryDO, this.columnHeader[idx]);
                if (_Logger.isTraceEnabled()) {
                    _Logger.info((Object)("Column Title: " + this.columnHeader[idx]));
                }
                if (this.columnHeader[idx].equals("")) {
                    if (_Logger.isTraceEnabled()) {
                        _Logger.info((Object)"Column Property: Index");
                    }
                    column = ColumnBuilder.getNew().setColumnProperty("Index", String.class.getName()).setTitle(this.columnHeader[idx]).setFixedWidth(true).setWidth(columnWidth).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
                    this.setColumnStyle(column);
                    this.addColumn(column);
                    continue;
                }
                if (_Logger.isTraceEnabled()) {
                    _Logger.info((Object)("Column Property: " + this.columnHeader[idx]));
                }
                column = ColumnBuilder.getNew().setColumnProperty(this.columnHeader[idx], String.class.getName()).setTitle(this.columnHeader[idx]).setFixedWidth(true).setWidth(columnWidth).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
                this.setColumnStyle(column);
                this.addColumn(column);
            }
        } else {
            if (_Logger.isTraceEnabled()) {
                _Logger.info((Object)"Inside JasperReportBuilder - > Creating column headers from column property...");
            }
            PropertyDescriptor[] properties = new PropertyDescriptor[this.columnProperty.length];
            try {
                for (int i = 0; i < this.columnProperty.length; ++i) {
                    String propertiesName = this.columnProperty[i];
                    properties[i] = PropertyUtils.getPropertyDescriptor((Object)obj, (String)propertiesName);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            for (int i = 0; i < properties.length; ++i) {
                PropertyDescriptor property = properties[i];
                if (property == null || !JasperReportBuilder.isValidProperty(property)) continue;
                int columnWidth = this.getColumnWidth(property);
                if (columnWidth < this.columnHeader[i].length() * 6) {
                    columnWidth = this.columnHeader[i].length() * 6;
                }
                if (_Logger.isTraceEnabled()) {
                    _Logger.info((Object)("Column Title: " + this.columnHeader[i]));
                    _Logger.info((Object)("Column Property: " + property.getName()));
                }
                AbstractColumn column = ColumnBuilder.getNew().setColumnProperty(property.getName(), this.getPropertyType(property)).setTitle(this.columnHeader[i]).setFixedWidth(true).setWidth(columnWidth).setHeaderStyle(headerStyle).build();
                this.setColumnStyle(column, property);
                this.addColumn(column);
            }
        }
    }

    protected void createColumnHeaderFromColumnSets() throws ColumnBuilderException, ClassNotFoundException {
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)"Inside JasperReportBuilder - > createColumnHeaderFromColumnSets()");
        }
        if (this.dataObjects == null) {
            _Logger.warn((Object)"dataObject is null, returning !!!");
            return;
        }
        Style headerStyle = JasperReportStyle.getHeaderStyle();
        int size = JasperReportUtil.getColumnSetsSize(this.columnSets, 0);
        if (_Logger.isTraceEnabled()) {
            _Logger.info((Object)("Inside JasperReportBuilder - > size: " + size));
        }
        Object obj = this.dataObjects.toArray()[0];
        try {
            for (ColumnSet columnSet : this.columnSets) {
                Object[] columnSetobj = columnSet.getColumnSet().toArray();
                for (int idx = 0; idx < columnSetobj.length; ++idx) {
                    PropertyDescriptor property = PropertyUtils.getPropertyDescriptor((Object)obj, (String)((TableColumn)columnSetobj[idx]).getProperty());
                    if (property != null && JasperReportBuilder.isValidProperty(property)) {
                        AbstractColumn column;
                        int columnWidth = this.getColumnWidth(property);
                        if (columnWidth < ((TableColumn)columnSetobj[idx]).getName().length() * 6) {
                            columnWidth = ((TableColumn)columnSetobj[idx]).getName().length() * 6;
                        }
                        if ((column = ColumnBuilder.getNew().setColumnProperty(property.getName(), this.getPropertyType(property)).setTitle(((TableColumn)columnSetobj[idx]).getName()).setFixedWidth(true).setWidth(columnWidth).setHeaderStyle(headerStyle).build()).getWidth() < column.getTitle().length() * 10) {
                            column.setWidth(Integer.valueOf(column.getTitle().length() * 10));
                        }
                        this.updateColumnAlignment((TableColumn)columnSetobj[idx], ((TableColumn)columnSetobj[idx]).getName());
                        this.setColumnStyle(column, property);
                        this.addColumn(column);
                        continue;
                    }
                    _Logger.warn((Object)"PropertyDescriptor is null or invalid !!!");
                }
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        if (this.isMarkupLink) {
            DJHyperLink djlink = new DJHyperLink();
            StringExpression expression = new StringExpression(){

                public Object evaluate(Map arg0, Map arg1, Map arg2) {
                    try {
                        JRBeanCollectionDataSource ds = (JRBeanCollectionDataSource)arg2.get("REPORT_DATA_SOURCE");
                        Field currentBeanField = ds.getClass().getDeclaredField("currentBean");
                        currentBeanField.setAccessible(true);
                        Object obj = currentBeanField.get(ds);
                        Method method = obj.getClass().getMethod("getLinkName", null);
                        return method.invoke(obj, new Object[0]);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            djlink.setExpression(expression);
            this.getColumn(0).setLink(djlink);
        }
    }

    public void setColumnStyle(AbstractColumn column, PropertyDescriptor property) {
        Style detailStyle = JasperReportStyle.getDetailStyle();
        Style numeriDetailStyle = JasperReportStyle.getDetailStyleNumeric();
        if (String.class.isAssignableFrom(property.getPropertyType()) || Date.class.isAssignableFrom(property.getPropertyType())) {
            column.setStyle(detailStyle);
        } else {
            column.setStyle(numeriDetailStyle);
        }
        if (this.columnAllignment != null && this.columnAllignment.get(column.getTitle()) != null) {
            column.getStyle().setHorizontalAlign(this.columnAllignment.get(column.getTitle()));
        }
    }

    public void setColumnStyle(AbstractColumn column) {
        Style detailStyle = JasperReportStyle.getDetailStyle();
        column.setStyle(detailStyle);
        if (this.columnAllignment != null && this.columnAllignment.get(column.getTitle()) != null) {
            column.getStyle().setHorizontalAlign(this.columnAllignment.get(column.getTitle()));
        }
    }

    public static boolean isValidProperty(PropertyDescriptor property) {
        return !"class".equals(property.getName()) && JasperReportBuilder.isValidPropertyClass(property);
    }

    private static boolean isValidPropertyClass(PropertyDescriptor property) {
        Class<?> type = property.getPropertyType();
        return type.toString().equals("int") || type.toString().equals("double") || Number.class.isAssignableFrom(type) || type == String.class || Date.class.isAssignableFrom(type) || type == Boolean.class;
    }

    private static String getColumnTitle(PropertyDescriptor property) {
        StringBuffer buffer = new StringBuffer();
        String name = property.getName();
        buffer.append(Character.toUpperCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append(' ');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public int getColumnWidth(PropertyDescriptor property) {
        int width = 50;
        for (Object obj : this.dataObjects) {
            try {
                String value;
                if (property.getReadMethod().invoke(obj, new Object[0]) == null || (value = property.getReadMethod().invoke(obj, new Object[0]).toString()) == null) continue;
                if (value.contains("<BR/>") || value.contains("\n")) {
                    String[] tempStr;
                    if (value.contains("<BR/>")) {
                        value = value.replace("<BR/>", "\n");
                    }
                    property.getWriteMethod().invoke(obj, value);
                    for (String str : tempStr = value.split("\n")) {
                        if (width >= (str = this.removeSpecialCharacters(str)).length() * 6) continue;
                        width = str.toString().length() * 6;
                    }
                    continue;
                }
                if (width >= (value = this.removeSpecialCharacters(value)).length() * 6) continue;
                width = value.toString().length() * 6;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (JasperReportBuilder.getColumnTitle(property) != null && JasperReportBuilder.getColumnTitle(property).equalsIgnoreCase("Index")) {
            width = 30;
        }
        if (width >= 300) {
            width = 300;
        }
        return width;
    }

    private String removeSpecialCharacters(String str) {
        if (str != null && str.trim().length() > 0) {
            if (str.contains(".")) {
                str = str.replaceAll("\\.", "");
            }
            if (str.contains(":")) {
                str = str.replaceAll(":", "");
            }
            if (str.contains("i")) {
                str = str.replaceAll("i", "");
            }
            str = str.concat("      ");
        }
        return str;
    }

    public int getColumnWidth(DBEntryDO entryDO, String columnTitle) {
        int width = 50;
        if (columnTitle.equalsIgnoreCase("")) {
            columnTitle = "Index";
        }
        int columnIdx = JasperReportUtil.getColumnIndex(entryDO, columnTitle);
        DBRowDO[] rows = entryDO.getRows();
        for (int idx = 0; idx < rows.length; ++idx) {
            String value;
            if (columnTitle.equalsIgnoreCase("Scope")) {
                columnIdx = JasperReportUtil.getColumnIndex(entryDO, columnTitle, idx);
            }
            if ((value = rows[idx].getEntry()[columnIdx]) == null) continue;
            if (value.contains("<BR/>") || value.contains("\n")) {
                String[] tempStr;
                value = value.replace("<BR/>", "\n");
                for (String str : tempStr = value.split("\n")) {
                    if (width >= (str = this.removeSpecialCharacters(str)).length() * 6) continue;
                    width = str.toString().length() * 6;
                }
                continue;
            }
            if (width >= (value = this.removeSpecialCharacters(value)).length() * 6) continue;
            width = value.toString().length() * 6;
        }
        if (columnTitle.equalsIgnoreCase("Index")) {
            width = 30;
        } else if (width < columnTitle.length() * 6) {
            width = columnTitle.length() * 6;
        }
        if (width >= 300) {
            width = 300;
        }
        return width;
    }

    public String getPropertyType(PropertyDescriptor property) {
        if (property.getPropertyType().toString().equals("double")) {
            return Double.class.getName();
        }
        if (property.getPropertyType().toString().equals("int")) {
            return Integer.class.getName();
        }
        if (property.getPropertyType().toString().equals("boolean")) {
            return Boolean.class.getName();
        }
        return property.getPropertyType().getName();
    }

    public Class getPropertyTypeClass(PropertyDescriptor property) {
        if (property.getPropertyType().toString().equals("double")) {
            return Double.class;
        }
        if (property.getPropertyType().toString().equals("int")) {
            return Integer.class;
        }
        if (property.getPropertyType().toString().equals("boolean")) {
            return Boolean.class;
        }
        return property.getPropertyType();
    }

    public String[] getColumnProperties() {
        return this.columnProperty;
    }

    public void setColumnPropertiesNames(String[] columnPropertiesNames) {
        this.columnProperty = columnPropertiesNames;
    }

    public Collection<ColumnSet> getColumnSets() {
        return this.columnSets;
    }

    public Collection getDataObjects() {
        return this.dataObjects;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String[]> getChartList() {
        return this.chartList;
    }

    public List<String[]> getTocList() {
        return this.tocList;
    }

    public String getAnchorString() {
        return this.anchorString;
    }

    public void updateColumnAlignment(TableColumn tableColumn, String key) {
        if (this.anchorString != null) {
            if (1 == tableColumn.getAlignment()) {
                this.columnAllignment.put(key, HorizontalAlign.LEFT);
            } else if (2 == tableColumn.getAlignment()) {
                this.columnAllignment.put(key, HorizontalAlign.RIGHT);
            }
        }
    }
}

