/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.lan.util;

import com.cisco.dcbu.dcm.model.PlatformDetails;
import com.cisco.dcbu.dcm.model.enumkind.PlatformType;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformHelper {
    private static final Log log = LogFactory.getLog(PlatformHelper.class);

    public static boolean isSupported(PlatformType platformType) {
        Field[] fields;
        if (platformType == null) {
            return false;
        }
        for (Field field : fields = PlatformType.class.getDeclaredFields()) {
            try {
                PlatformDetails annotations;
                if (!field.isEnumConstant() || !platformType.equals(field.get(platformType)) || (annotations = field.getAnnotation(PlatformDetails.class)) == null) continue;
                return annotations.isSupported();
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return false;
    }

    public static boolean isVirtualized(PlatformType platformType) {
        Field[] fields;
        for (Field field : fields = PlatformType.class.getDeclaredFields()) {
            try {
                PlatformDetails annotations;
                if (!field.isEnumConstant() || !platformType.equals(field.get(platformType)) || (annotations = field.getAnnotation(PlatformDetails.class)) == null) continue;
                return annotations.isVirtualized();
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return false;
    }

    public static boolean skipLicenseCheck(PlatformType platformType) {
        Field[] fields;
        for (Field field : fields = PlatformType.class.getDeclaredFields()) {
            try {
                PlatformDetails annotations;
                if (!field.isEnumConstant() || !platformType.equals(field.get(platformType)) || (annotations = field.getAnnotation(PlatformDetails.class)) == null) continue;
                return annotations.skipLicenseCheck();
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return false;
    }

    public static PlatformType getPlatformType(String platformString) {
        Field[] fields;
        for (Field field : fields = PlatformType.class.getDeclaredFields()) {
            String[] validStrs;
            PlatformDetails annotations = field.getAnnotation(PlatformDetails.class);
            if (annotations == null || annotations.validFormat() == null || annotations.validFormat().trim().length() == 0) continue;
            for (String str : validStrs = annotations.validFormat().split(",")) {
                if (!platformString.contains(str)) continue;
                try {
                    PlatformType platformType = (PlatformType)field.get(null);
                    if (PlatformType.C6500.equals((Object)platformType)) {
                        platformType = PlatformType.C6500;
                    }
                    return platformType;
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)e.getMessage());
                }
                catch (IllegalAccessException e) {
                    log.debug((Object)e.getMessage());
                }
            }
        }
        return PlatformType.UNSUPPORTED;
    }

    public static boolean hasVdc(PlatformType platformType) {
        return PlatformType.DC3.equals((Object)platformType) || PlatformType.N5K.equals((Object)platformType) || PlatformType.N5500.equals((Object)platformType) || PlatformType.N4KI.equals((Object)platformType) || PlatformType.N4KD.equals((Object)platformType) || PlatformType.N1KV.equals((Object)platformType) || PlatformType.N1010.equals((Object)platformType) || PlatformType.UCS6100.equals((Object)platformType) || PlatformType.FWSM.equals((Object)platformType) || PlatformType.N3K.equals((Object)platformType);
    }

    public static boolean hasVcs(PlatformType platformType) {
        return PlatformType.ESX.equals((Object)platformType);
    }

    public static boolean isMdsDevice(PlatformType platformType) {
        return platformType == PlatformType.MDS || platformType == PlatformType.MDS_9100 || platformType == PlatformType.MDS_9200 || platformType == PlatformType.MDS_9500;
    }

    public static boolean isFcDevice(PlatformType platformType) {
        return platformType == PlatformType.MDS || platformType == PlatformType.MDS_9100 || platformType == PlatformType.MDS_9200 || platformType == PlatformType.MDS_9500 || platformType == PlatformType.ENDDEVICE;
    }

    public static boolean isCatDevice(PlatformType platformType) {
        return platformType == PlatformType.C6500;
    }

    public static boolean isFirewallDevice(PlatformType platformType) {
        return platformType == PlatformType.FWSM || platformType == PlatformType.ASA;
    }

    public static boolean isUCSDevice(PlatformType pfType) {
        return PlatformType.UCS6100.equals((Object)pfType);
    }

    public static boolean isCdpProbeRequired(PlatformType pfType) {
        Field[] fields;
        for (Field field : fields = PlatformType.class.getDeclaredFields()) {
            try {
                PlatformDetails annotations;
                if (field == null || !field.isEnumConstant() || !pfType.equals(field.get(pfType)) || (annotations = field.getAnnotation(PlatformDetails.class)) == null) continue;
                return annotations.isCdpProbeRequired();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isReadOnly(PlatformType pfType) {
        Field[] fields;
        for (Field field : fields = PlatformType.class.getDeclaredFields()) {
            try {
                PlatformDetails annotations;
                if (field == null || !field.isEnumConstant() || !pfType.equals(field.get(pfType)) || (annotations = field.getAnnotation(PlatformDetails.class)) == null) continue;
                return annotations.isReadOnly();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }
}

