/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.lan.util;

import com.cisco.dcbu.dcm.model.admin.devicegroup.DeviceGroup;
import com.cisco.dcbu.dcm.model.admin.devicegroup.util.DeviceGroupInstanceNameHelper;
import com.cisco.dcbu.dcm.model.admin.util.UserInstanceNameHelper;
import com.cisco.dcbu.dcm.model.enumkind.ApplicationUserRole;
import com.cisco.dcbu.dcm.model.security.ApplicationUser;
import com.cisco.dcbu.dcm.model.vdc.AbstractNetworkElement;
import com.cisco.dcbu.dcm.model.vdc.VirtualNetworkElement;
import com.cisco.dcbu.dcm.security.CryptoHelper;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.web.lan.persister.CommonSessionPersisterFactory;
import com.cisco.dcbu.sm.server.web.lan.persister.SessionPersister;
import com.cisco.dcbu.sm.server.web.lan.persister.Transaction;
import com.cisco.dcbu.sm.server.web.lan.persister.UnitOfWorkFactory;
import com.cisco.dcbu.sm.server.web.lan.util.PlatformHelper;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ServiceInitHelper {
    public static final String DEFAULT_USERID = "admin";
    private static final String DEFAULT_USER_PASSWORD = "admin";
    public static final String DEFAULT_INTERNAL_APPLICATION_USERID = "internalApplication";
    public static final String DEFAULT_INTERNAL_DEVICE_GROUP_NAME = "Default Group";
    static final String HBM2DDL_CREATE = "create";
    static final String HBM2DDL_VERIFY = "verify";
    static final String HBM2DDL_UPDATE = "update";
    static final String DEFAULT_MODEL_CFG = "com/cisco/dcbu/dcm/model/model.cfg.xml";
    static final String DEFAULT_DB_CFG = "com/cisco/dcbu/dcm/common/database/hsql.cfg.xml";
    private static final String FS = File.separator;
    private static final String DEFAULT_POSTGRES_CFG_RESOURCE = FS + "conf" + FS + "postgresql.cfg.xml";
    private static final String DEFAULT_ORACLE_CFG_RESOURCE = FS + "conf" + FS + "oracle.cfg.xml";
    private static String DEFAULT_DB_CFG_RESOURCE = DEFAULT_POSTGRES_CFG_RESOURCE;
    private static Log log = LogFactory.getLog(ServiceInitHelper.class);

    public static void init() {
        log = LogFactory.getLog(ServiceInitHelper.class);
        ServiceInitHelper.initDB();
    }

    public static void main(String[] a) {
        ServiceInitHelper.init();
    }

    private static void initDB() {
        if (UnitOfWorkFactory.INSTANCE.isInitFlag()) {
            return;
        }
        String aDbCfgResource = null;
        try {
            log.info((Object)"Initializing Database");
            String jbossBaseDir = System.getProperty("jboss.server.base.dir", "");
            File postgresCfgFile = new File(jbossBaseDir + DEFAULT_POSTGRES_CFG_RESOURCE);
            File oracleCfgFile = new File(jbossBaseDir + DEFAULT_ORACLE_CFG_RESOURCE);
            aDbCfgResource = postgresCfgFile.exists() ? jbossBaseDir + DEFAULT_POSTGRES_CFG_RESOURCE : (oracleCfgFile.exists() ? jbossBaseDir + DEFAULT_ORACLE_CFG_RESOURCE : DEFAULT_DB_CFG);
        }
        catch (Exception e) {
            log.error((Object)"Error parsing hibernate cfg path", (Throwable)e);
        }
        log.info((Object)("Hibernate Config file : " + aDbCfgResource));
        String mappingCfgResource = System.getProperty("cisco.dcbu.dcm.mappingCfgResource");
        if (mappingCfgResource == null) {
            mappingCfgResource = DEFAULT_MODEL_CFG;
        }
        UnitOfWorkFactory.INSTANCE.setDbCfgResource(aDbCfgResource);
        UnitOfWorkFactory.INSTANCE.setMappingCfgResource(mappingCfgResource);
        UnitOfWorkFactory.INSTANCE.init();
    }

    private static Properties getHibernateProperties(String dbCfgResource) {
        String hbm2ddl = System.getProperty("cisco.dcbu.dcm.hbm2ddl");
        if (hbm2ddl == null) {
            hbm2ddl = HBM2DDL_VERIFY;
            try {
                Connection c = ServiceInitHelper.getConnection(dbCfgResource);
                if (!ServiceInitHelper.checkUserTableExists(c)) {
                    if (ServiceInitHelper.checkDcnmUserTableExists(c)) {
                        log.info((Object)"Database tables do not exist except dcnmuser table (hbm2ddl = update)");
                        hbm2ddl = HBM2DDL_UPDATE;
                    } else {
                        hbm2ddl = HBM2DDL_CREATE;
                    }
                    log.info((Object)"Database tables do not exist (hbm2ddl = create)");
                } else {
                    log.info((Object)"Database tables exist (hbm2ddl = verify)");
                }
                c.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error querying the DB", (Throwable)e);
            }
        }
        Properties prop = new Properties();
        prop.setProperty("hibernate.hbm2ddl.auto", hbm2ddl);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkUserTableExists(Connection c) {
        Statement statement = null;
        try {
            statement = c.createStatement();
            statement.executeQuery("SELECT COUNT(*) FROM applicationuser");
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtil.close(statement);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDcnmUserTableExists(Connection c) {
        Statement statement = null;
        try {
            statement = c.createStatement();
            statement.executeQuery("SELECT COUNT(*) FROM dcnmuser");
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DbUtil.close(statement);
        }
        return true;
    }

    private static Connection getConnection(String dbCfgResource) {
        Configuration cfg = new Configuration().configure(dbCfgResource);
        String driver = cfg.getProperty("connection.driver_class");
        String dbUrl = cfg.getProperty("connection.url");
        String dbUsername = cfg.getProperty("connection.username");
        String dbPassword = cfg.getProperty("connection.password");
        Connection c = null;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error loading database driver");
            return null;
        }
        try {
            c = DriverManager.getConnection(dbUrl, dbUsername, dbPassword);
        }
        catch (SQLException e) {
            log.error((Object)"Error connecting to database", (Throwable)e);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initUsers() {
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            ArrayList<ApplicationUser> list = new ArrayList<ApplicationUser>(1);
            ApplicationUser internalUser = (ApplicationUser)session.createCriteria(ApplicationUser.class).add((Criterion)Restrictions.eq((String)"userId", (Object)DEFAULT_INTERNAL_APPLICATION_USERID)).uniqueResult();
            if (internalUser == null) {
                internalUser = new ApplicationUser();
                internalUser.setUserId(DEFAULT_INTERNAL_APPLICATION_USERID);
                String password = String.valueOf(Math.random());
                internalUser.setPassword(CryptoHelper.INSTANCE.encrypt(password));
                internalUser.setDescription("Default Internal Application");
                internalUser.setRole(ApplicationUserRole.SERVER_ADMIN);
                internalUser.setName("Internal Application");
                internalUser.setInstanceName(UserInstanceNameHelper.buildApplicationUserInstanceName((String)internalUser.getUserId()));
                list.add(internalUser);
            }
            Transaction tx = null;
            try {
                if (list.size() > 0) {
                    tx = session.beginTransaction();
                    for (ApplicationUser applicationUser : list) {
                        session.save(applicationUser);
                    }
                    tx.commit();
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"Error creating default user", (Throwable)e);
                if (tx != null) {
                    tx.rollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDefaultGroup() {
        boolean defaultGroupCreated = false;
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            ArrayList<DeviceGroup> list = new ArrayList<DeviceGroup>(1);
            DeviceGroup defaultGroup = (DeviceGroup)session.createCriteria(DeviceGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)DEFAULT_INTERNAL_DEVICE_GROUP_NAME)).uniqueResult();
            if (defaultGroup == null) {
                defaultGroup = new DeviceGroup();
                defaultGroup.setName(DEFAULT_INTERNAL_DEVICE_GROUP_NAME);
                defaultGroup.setOwnerName("admin");
                defaultGroup.setDescription("Default Device Group");
                defaultGroup.setPrivateGroup(new Boolean(false));
                defaultGroup.setInstanceName(DeviceGroupInstanceNameHelper.buildNetworkElementGroupInstanceName((String)"admin", (String)defaultGroup.getName(), (Boolean)false));
                list.add(defaultGroup);
            }
            Transaction tx = null;
            try {
                List aneList;
                if (list.size() > 0) {
                    tx = session.beginTransaction();
                    for (DeviceGroup deviceGroup : list) {
                        session.save(deviceGroup);
                        defaultGroupCreated = true;
                    }
                    tx.commit();
                }
                if (defaultGroupCreated && (aneList = session.createCriteria(AbstractNetworkElement.class).setFetchMode("deviceGroupRef", FetchMode.JOIN).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list()) != null && aneList.size() > 0) {
                    tx = session.beginTransaction();
                    for (AbstractNetworkElement ane : aneList) {
                        if (ane.getPlatformType() != null && PlatformHelper.isVirtualized(ane.getPlatformType()) && !(ane instanceof VirtualNetworkElement)) continue;
                        ane.setDeviceGroupRef(defaultGroup);
                        defaultGroup.addAbstractNetworkElement(ane);
                    }
                    session.save(defaultGroup);
                    tx.commit();
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"Error creating default group", (Throwable)e);
                if (tx != null) {
                    tx.rollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createInternalUser() {
        ApplicationUser user = new ApplicationUser();
        user.setUserId("admin");
        user.setPassword(CryptoHelper.INSTANCE.encrypt("admin"));
        user.setDescription("Default Server Administrator");
        user.setRole(ApplicationUserRole.SERVER_ADMIN);
        user.setName("Administrator");
        user.setInstanceName(UserInstanceNameHelper.buildApplicationUserInstanceName((String)user.getUserId()));
        ApplicationUser internalUser = new ApplicationUser();
        internalUser.setUserId(DEFAULT_INTERNAL_APPLICATION_USERID);
        String password = String.valueOf(Math.random());
        internalUser.setPassword(CryptoHelper.INSTANCE.encrypt(password));
        internalUser.setDescription("Default Internal Application");
        internalUser.setRole(ApplicationUserRole.SERVER_ADMIN);
        internalUser.setName("Internal Application");
        internalUser.setInstanceName(UserInstanceNameHelper.buildApplicationUserInstanceName((String)internalUser.getUserId()));
        Transaction tx = null;
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            tx = session.beginTransaction();
            session.save(user);
            session.save(internalUser);
            tx.commit();
        }
    }
}

