/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.lib.sshexec.impl.GoldDiagAdapter;
import com.cisco.dcbu.sm.common.model.TableColumn;
import com.cisco.dcbu.sm.server.web.report.ColumnSet;
import com.cisco.dcbu.sm.server.web.report.DiagnosticDetailReport;
import com.cisco.dcbu.sm.server.web.report.ReportInfo;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DiagnosticReport
extends ReportInfo {
    private Collection detailList;
    private Logger _Log = Logger.getLogger((String)"fms.lanReport");
    protected Collection<ColumnSet> columnSets = null;
    private Collection detailStatsColumns = null;

    public DiagnosticReport(String reportName) {
        super(reportName);
    }

    public DiagnosticReport(String reportName, boolean showDetails) {
        super(reportName);
    }

    @Override
    public int getReportType() {
        return 1;
    }

    @Override
    public Collection getDataList() {
        if (this.dataList == null) {
            try {
                boolean isLan = (Boolean)this.getFilterValue("Is_Lan");
                boolean isGroup = (Boolean)this.getFilterValue("Is_Group");
                if (!isLan && !isGroup) {
                    this.dataList = this.getOneLanSwitch();
                } else if (isLan) {
                    this.dataList = this.getOneLanSwitch();
                } else if (isGroup) {
                    this.dataList = this.getOneLanSwitch();
                }
                long lanGroupId = (Long)this.getFilterValue("Lan_Group_Id");
                this.detailList = new ArrayList();
                this.populateDetailList();
            }
            catch (Exception e) {
                this._Log.warn((Object)e.getMessage(), (Throwable)e);
                this.handleException(e);
                this.dataList = new ArrayList();
            }
        }
        return this.dataList;
    }

    @Override
    public List<String[]> getTocContent() {
        this.getDataList();
        return this.tocContent;
    }

    @Override
    public Collection getColumns() {
        if (this.columns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("Switch Name", "name"), new TableColumn("Switch IP", "ipAddress"), new TableColumn("Status", "status")};
            this.columns = Arrays.asList(tCols);
        }
        return this.columns;
    }

    private Collection getDetailStatsColumns() {
        if (this.detailStatsColumns == null) {
            TableColumn[] tCols = new TableColumn[]{new TableColumn("Switch Report Content", "content")};
            this.detailStatsColumns = Arrays.asList(tCols);
        }
        return this.detailStatsColumns;
    }

    private void populateDetailList() throws Exception {
        for (Object sws : this.dataList) {
            SwitchDO swDO = (SwitchDO)sws;
            String ip = swDO.getIpAddress();
            String swName = swDO.getName();
            GoldDiagAdapter adapter = null;
            try {
                adapter = new GoldDiagAdapter(ip, "admin", "democonf_2008");
                adapter.startModuleDiagnostic(3);
                Thread.sleep(5000L);
                String rs = adapter.showModuleDiagnostic(3);
                DiagnosticDetailReport reportHolder = new DiagnosticDetailReport(new Object[]{"#Switch_" + swName, "Detial Report For " + swName, rs, swName});
                this.detailList.add(reportHolder);
                adapter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Collection getDetails() {
        return this.detailList;
    }

    @Override
    public String getNote() {
        return null;
    }

    @Override
    public boolean getShowFilter() {
        return true;
    }

    @Override
    public Collection getColumnSets() {
        if (this.columnSets == null) {
            if (this.columns == null) {
                this.getColumns();
            }
            this.columnSets = new ArrayList<ColumnSet>();
            ColumnSet set = null;
            Iterator itr = this.columns.iterator();
            set = DisplayUtil.initSet(itr, this.columns.size(), "");
            this.columnSets.add(set);
        }
        return this.columnSets;
    }

    private List<SwitchDO> getLanSwitches(String scopeXML) {
        String[] lanSwIdArr;
        ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
        long swId = -1L;
        String lanSwIdsInStr = NavigationUtil.getInstance().getEntitiesInGroup(scopeXML, 1);
        for (String lanSwId : lanSwIdArr = lanSwIdsInStr.split(",")) {
            swId = Long.parseLong(lanSwId);
            if (swId < 0L) continue;
            rstList.add(NavigationUtil.getInstance().getLanSwitchDetail(swId));
        }
        return rstList;
    }

    private List<SwitchDO> getSanSwitches(String scopeXML) {
        ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
        String fidsInStr = NavigationUtil.getInstance().getEntitiesInGroup(scopeXML, 0);
        String[] fidArr = fidsInStr.split(",");
        long swId = -1L;
        for (String fidStr : fidArr) {
            swId = Long.parseLong(fidStr);
            if (swId < 0L) continue;
            rstList.addAll(NavigationUtil.getInstance().getSwitchList(swId));
        }
        return rstList;
    }

    private List<SwitchDO> getOneLanSwitch() {
        ArrayList<SwitchDO> rstList = new ArrayList<SwitchDO>();
        SwitchDO swDO = new SwitchDO();
        swDO.setIpAddress("172.22.31.16");
        String name = "SW_172.22.31.16";
        swDO.setName(name);
        swDO.setStatus("Successfully get Diagnostic Information");
        swDO.setLinkName("#Switch_" + name);
        rstList.add(swDO);
        return rstList;
    }
}

