/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.sm.common.util.Filter;
import com.cisco.dcbu.sm.server.web.report.CustomReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class ReportInfo {
    public static final int TYPE_TABLE = 1;
    public static final int TYPE_LINK = 2;
    public static final int TYPE_HTML = 3;
    public static final int TYPE_TOC = 4;
    public static final int TYPE_RAW_TEXT = 5;
    public static final int TYPE_SIMPLE_TEXT = 6;
    public static final String REPORT_DIR = File.separator + "reports";
    protected String name;
    protected HashMap<String, Filter> filters = new HashMap();
    protected Collection dataList;
    protected Collection columns;
    protected List<String[]> charts = null;
    protected List<String[]> tocContent = null;
    protected String error = null;
    protected String jobName = "";
    protected boolean showFabricColumn = true;
    protected String reportURI = null;
    protected String _Localhost = "127.0.0.1";
    protected String exp2Csv = "";
    protected boolean isMarkupLink = false;
    protected String anchor = "";
    protected HashMap<String, HorizontalAlign> columnAllignment = null;

    protected ReportInfo(String reportName, String jobName) {
        this.name = reportName;
        this.jobName = jobName;
    }

    protected ReportInfo(String reportName) {
        this.name = reportName;
    }

    public String getNote() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMarkupLink() {
        return this.isMarkupLink;
    }

    public void setMarkupLink(boolean isMarkupLink) {
        this.isMarkupLink = isMarkupLink;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public void setReportURI(String reportURI) {
        this.reportURI = reportURI;
    }

    public String getReportURI() {
        if (this.reportURI != null) {
            return this.reportURI;
        }
        return CustomReport.getUri();
    }

    public String getError() {
        if (this.error == null) {
            switch (this.getReportType()) {
                case 1: 
                case 4: {
                    this.getDataList();
                    break;
                }
                case 3: {
                    this.getHtmlContent();
                }
            }
            this.getHasChart();
        }
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean isErrorFound() {
        String err = this.getError();
        return this.error != null && this.error.trim().length() > 0;
    }

    public Collection<Filter> getFilters() {
        return this.filters.values();
    }

    public void addFilter(String filterName, Object value) {
        Filter filter = new Filter(filterName, value);
        this.addFilter(filter);
    }

    public void addFilter(Filter filter) {
        this.filters.put(filter.getFilterKey(), filter);
    }

    public void addAll(HashMap<String, Filter> filters) {
        this.filters.putAll(filters);
    }

    public abstract int getReportType();

    public boolean getHasChart() {
        return this.charts != null && this.charts.size() > 0;
    }

    public boolean getHasToc() {
        return this.tocContent != null && this.tocContent.size() > 0;
    }

    public Collection getDataList() {
        return new ArrayList();
    }

    public void setDataList(Collection data) {
    }

    public boolean getShowFilter() {
        return false;
    }

    public int getColumnSpan() {
        if (this.getReportType() == 1 && this.getColumns() != null) {
            return this.getColumns().size() + 1;
        }
        return 1;
    }

    public Collection getDetails() {
        return null;
    }

    public void setDetails(Collection details) {
    }

    public boolean isDetailAttached() {
        Collection details = this.getDetails();
        return details != null && details.size() > 0;
    }

    public String getWrapperClass() {
        return "";
    }

    public Collection getColumns() {
        return null;
    }

    public Collection getColumnSets() {
        return null;
    }

    public List<String[]> getCharts() {
        return this.charts;
    }

    public void setCharts(List<String[]> charts) {
        this.charts = charts;
    }

    public List<String[]> getTocContent() {
        return this.tocContent;
    }

    public void setTocContent(List<String[]> tocContent) {
        this.tocContent = tocContent;
    }

    public String getHtmlContent() {
        return null;
    }

    public String getCsvContent() {
        return null;
    }

    public long getTimeoutInterval() {
        return 0L;
    }

    public void setTimeoutInterval(long timeoutInterval) {
    }

    protected Object getFilterValue(String filterKey) {
        return this.filters.get(filterKey).getFilterValue();
    }

    protected void showFilters(String[] keys) {
        for (Filter filter : this.filters.values()) {
            filter.setDisplayable(false);
        }
        for (String key : keys) {
            Filter filter = this.filters.get(key);
            filter.setDisplayable(true);
        }
    }

    public boolean getReset() {
        if (this.dataList != null) {
            this.dataList = null;
        }
        if (this.columns != null) {
            this.columns = null;
        }
        if (this.getDetails() != null) {
            this.setDetails(null);
        }
        return true;
    }

    protected void handleException(Throwable t) {
        Throwable temp = t;
        while (temp.getCause() != null) {
            temp = temp.getCause();
        }
        String message = temp.getMessage();
        this.setError(message);
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getSwitchName() {
        return null;
    }

    public String getExp2Csv() {
        return this.exp2Csv;
    }

    public void setExp2Csv(String exp2Csv) {
        this.exp2Csv = exp2Csv;
    }

    public boolean isShowFabricColumn() {
        return this.showFabricColumn;
    }

    public void setShowFabricColumn(boolean showFabricColumn) {
        this.showFabricColumn = showFabricColumn;
    }

    public HashMap<String, HorizontalAlign> getColumnAllignment() {
        return this.columnAllignment;
    }

    public void setColumnAllignment(HashMap<String, HorizontalAlign> columnAllignment) {
        this.columnAllignment = columnAllignment;
    }
}

