/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.util;

import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class AppGroupUtil {
    static final String _CreateGroupSQL = "insert into app_groups (id,name) values(?,?)";
    static final String _InsertGroupSQL = "insert into app_group_member (id,name) values(?,?)";
    static final String _GroupExistSQL = "select count(*) from app_groups where name like(?)";
    static final String _DeleteGroupSQL = "delete from app_groups where id = ?";
    static final String _GetAllGroupsSQL = "select id,name from app_groups order by name ASC ";
    static final String _GetSanGroupMemberSQL = "select agm.id, sw.id, sw.sys_name, sp.if_name, sp.id, ag.name,agm.type,sp.if_alias from app_group_member agm, app_groups ag, switch sw, switch_port sp where agm.group_id = ag.id and sw.id=agm.switch_id and sp.id=agm.if_id and sp.switch_id = sw.id and ag.id = ? order by if_name ASC ";
    static final String _GetLanGroupMemberSQL = "select agm.id, sw.id, sw.sys_name, sp.if_name, sp.id, ag.name,agm.type,sp.if_alias  from app_group_member agm, app_groups ag, ethswitch sw, ethswitch_port sp  where agm.group_id = ag.id and sw.id=agm.switch_id and sp.id=agm.if_id  and sp.switch_id = sw.id and ag.id = ? order by if_name ASC";
    static final String _GetGroupMemberSQL = "select if_id,switch_id, type from app_group_member agm where agm.group_id=?";
    private static Logger _Logger = Logger.getLogger((String)"fm.web");
    private static AppGroupUtil _Instance = null;
    private final ReentrantLock _Lock = new ReentrantLock();

    public static AppGroupUtil getInstance() {
        if (_Instance == null) {
            _Instance = new AppGroupUtil();
        }
        return _Instance;
    }

    private AppGroupUtil() {
    }

    private void addGrp2Db(long idx, String gName) throws Exception {
        Connection con = null;
        PreparedStatement pstmt = null;
        this._Lock.lock();
        try {
            con = ConnectionManager.getConnection();
            pstmt = con.prepareStatement(_CreateGroupSQL);
            pstmt.setLong(1, idx);
            pstmt.setString(2, gName);
            pstmt.execute();
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(con);
                this._Lock.unlock();
                throw throwable;
            }
        }
        DbUtil.close(pstmt);
        DbUtil.close(con);
        this._Lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getPortGroupId(long ifId, long memId, int type) {
        HashSet<Integer> groupIds;
        block6: {
            String QUERY_GROUP_ID = "SELECT distinct GROUP_ID FROM APP_GROUP_MEMBER WHERE IF_ID=? and SWITCH_ID=? and type=?";
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            groupIds = new HashSet<Integer>();
            try {
                conn = ConnectionManager.getConnection();
                stmt = conn.prepareStatement("SELECT distinct GROUP_ID FROM APP_GROUP_MEMBER WHERE IF_ID=? and SWITCH_ID=? and type=?");
                stmt.setLong(1, ifId);
                stmt.setLong(2, memId);
                stmt.setInt(3, type);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int gid = rs.getInt(1);
                    groupIds.add(gid);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage());
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        return groupIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallResultDO deleteGroup(int gId) {
        CallResultDO rstDo = new CallResultDO();
        Connection con = null;
        PreparedStatement pstmt = null;
        this._Lock.lock();
        try {
            con = ConnectionManager.getConnection();
            pstmt = con.prepareStatement(_DeleteGroupSQL);
            pstmt.setInt(1, gId);
            pstmt.execute();
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                rstDo.setResultStatus(-1);
                rstDo.setResultMessage(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(pstmt);
                DbUtil.close(con);
                this._Lock.unlock();
                throw throwable;
            }
            DbUtil.close(pstmt);
            DbUtil.close(con);
            this._Lock.unlock();
        }
        DbUtil.close(pstmt);
        DbUtil.close(con);
        this._Lock.unlock();
        return rstDo;
    }

    public CallResultDO addNewGroup(String gName) {
        CallResultDO rstDo = new CallResultDO();
        if (!this.validateGroupName(gName)) {
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage("The group name already exists, please pick another one.");
            return rstDo;
        }
        try {
            long curIndex = this.getCurGroupIndex();
            this.addGrp2Db(++curIndex, gName);
            rstDo.setResultStatus((int)curIndex);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            rstDo.setResultStatus(-2);
            rstDo.setResultMessage(ex.getMessage());
        }
        return rstDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateGroupName(String gName) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block8: {
            boolean bl;
            block7: {
                con = null;
                stmt = null;
                rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement(_GroupExistSQL);
                    stmt.setString(1, gName);
                    rs = stmt.executeQuery();
                    int rstCnt = 0;
                    if (rs.next()) {
                        rstCnt = rs.getInt(1);
                    }
                    if (rstCnt > 0) {
                        bl = false;
                        DbUtil.close(rs);
                        break block7;
                    }
                    DbUtil.close(rs);
                    break block8;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    return true;
                }
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
            return bl;
        }
        DbUtil.close(stmt);
        DbUtil.close(con);
        return true;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurGroupIndex() throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long curIndex;
        block4: {
            curIndex = 0L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("select id from app_groups where id=(select max(id) from app_groups)");
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                curIndex = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return curIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurMemberIndex() throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        long curIndex;
        block4: {
            curIndex = 0L;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("select id from app_group_member where id=(select max(id) from app_group_member)");
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                curIndex = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return curIndex;
    }

    public CallResultDO updateGroupSelection(int gIdx, String[] infSelection) {
        return this.updateGroupSelection(gIdx, infSelection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallResultDO updateGroupSelection(int gIdx, String[] infSelection, boolean cleanOldData) {
        CallResultDO rstDo = new CallResultDO();
        if (gIdx < 0) {
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage("Fail to find group : " + gIdx);
            return rstDo;
        }
        this._Lock.lock();
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = ConnectionManager.getConnection();
            if (cleanOldData) {
                this.removeOldSelection(gIdx, con);
            }
            HashMap<String, String> selMap = new HashMap<String, String>();
            long curIdx = this.getCurMemberIndex();
            for (String infSel : infSelection) {
                if (selMap.containsKey(infSel)) continue;
                selMap.put(infSel, "");
                long swId = Long.parseLong(infSel.split(":")[0]);
                long ifId = this.getIfDbId(infSel);
                String memTypeStr = infSel.split(":")[2];
                int memType = memTypeStr.equalsIgnoreCase("SAN") ? 3 : 4;
                stmt = con.prepareStatement("insert into app_group_member(id, if_id, switch_id, group_id,type) values(?,?,?,?,?)");
                stmt.setLong(1, ++curIdx);
                stmt.setLong(2, ifId);
                stmt.setLong(3, swId);
                stmt.setInt(4, gIdx);
                stmt.setInt(5, memType);
                stmt.execute();
                DbUtil.close(stmt);
            }
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage("Failed to update group member.");
        }
        finally {
            DbUtil.close(stmt);
            DbUtil.close(con);
            this._Lock.unlock();
        }
        return rstDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIfDbId(String infSel) {
        long ifId;
        block7: {
            ifId = Long.parseLong(infSel.split(":")[1]);
            if (ifId > 0L) {
                return ifId;
            }
            long swId = Long.parseLong(infSel.split(":")[0]);
            long ifIdx = Long.parseLong(infSel.split(":")[3]);
            String memTypeStr = infSel.split(":")[2];
            String sql = null;
            sql = memTypeStr.equalsIgnoreCase("SAN") ? "select id from switch_port where switch_id = ? and if_index = ?" : "select id from ethswitch_port where switch_id = ? and if_index = ?";
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, swId);
                stmt.setLong(2, ifIdx);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    ifId = rs.getLong(1);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return ifId;
    }

    public CallResultDO createGroupWithMember(String gName, String[] infSelection) {
        CallResultDO rstDo = new CallResultDO();
        if (!this.validateGroupName(gName)) {
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage("Group:" + gName + " already exists.");
            return rstDo;
        }
        CallResultDO cDo = this.addNewGroup(gName);
        int gId = cDo.getResultStatus();
        rstDo = this.updateGroupSelection(gId, infSelection);
        return rstDo;
    }

    public CallResultDO insertGroupMember(int gId, String[] infSelection) {
        CallResultDO rstDo = new CallResultDO();
        Map<String, String> memHash = this.getPortGroupMemberInHash(gId);
        ArrayList<String> newInfs = new ArrayList<String>();
        for (String infItm : infSelection) {
            if (memHash.containsKey(infItm)) continue;
            newInfs.add(infItm);
        }
        rstDo = this.updateGroupSelection(gId, newInfs.toArray(new String[0]), false);
        return rstDo;
    }

    private void removeOldSelection(int gIdx, Connection con) throws Exception {
        PreparedStatement stmt = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement("delete from app_group_member where group_id = ?");
            stmt.setInt(1, gIdx);
            stmt.execute();
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stmt);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getAllGroups() {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"id", "name"});
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_GetAllGroupsSQL);
            rs = stat.executeQuery();
            while (rs.next()) {
                DBRowDO row = new DBRowDO();
                long groupDbId = rs.getLong(1);
                String groupName = rs.getString(2);
                row.setEntry(new String[]{Long.toString(groupDbId), groupName});
                rList.add(row);
            }
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)"get all Applicaiton groups", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    public void appendPortGroupNav(StringBuffer groupNavInXml) {
        DBEntryDO dto = this.getAllGroups();
        DBRowDO[] rows = dto.getRows();
        groupNavInXml.append("<group isBranch=\"" + (rows.length > 0 ? "true" : "false") + "\" " + " name=\"" + "Port Groups" + "\" state =\"unchecked" + "\" selectable= \"false\" memDbId=\"-1\" type=\"" + 5 + "\" >\n");
        for (DBRowDO row : dto.getRows()) {
            long gId = Long.parseLong(row.getEntry()[0]);
            String gName = row.getEntry()[1];
            groupNavInXml.append("<groupMember isBranch=\"false\"  name=\"" + gName + "\" state =\"unchecked \"" + " icon=\"portIcon\"  " + " memId= \"" + gId + "\" " + " selectable= \"true\" memDbId=\"" + gId + "\" type=\"" + 6 + "\" />\n");
        }
        groupNavInXml.append("</group>");
    }

    public DBEntryDO getPortGroupMember(int gId) {
        Map<Long, String> connMap = this.getConnectToInfo(gId);
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"memId", "swId", "swName", "ifName", "ifId", "gId", "connTo", "type", "desc"});
        this.getGroupMemberByNetwork(gId, connMap, rList, _GetSanGroupMemberSQL);
        this.getGroupMemberByNetwork(gId, connMap, rList, _GetLanGroupMemberSQL);
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGroupMemberByNetwork(int gId, Map<Long, String> connMap, List<DBRowDO> rList, String sql) {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, gId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                DBRowDO row = new DBRowDO();
                long grpMemId = rs.getLong(1);
                long swId = rs.getLong(2);
                String swName = rs.getString(3);
                String ifName = rs.getString(4);
                long ifId = rs.getLong(5);
                int type = rs.getInt(7);
                String ifDesc = rs.getString(8);
                String connTo = connMap.get(ifId);
                row.setEntry(new String[]{String.valueOf(grpMemId), String.valueOf(swId), swName, ifName, String.valueOf(ifId), String.valueOf(gId), connTo, type == 4 ? "LAN" : "SAN", ifDesc});
                rList.add(row);
            }
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)("Failed to get group member:" + gId), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> getConnectToInfo(int gId) {
        HashMap<Long, String> memHash = new HashMap<Long, String>();
        HashMap<Long, String> sanMemHash = new HashMap<Long, String>();
        HashMap<Long, String> lanMemHash = new HashMap<Long, String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement(_GetGroupMemberSQL);
            stmt.setInt(1, gId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long spId = rs.getLong(1);
                int type = rs.getInt(3);
                if (type == 3) {
                    sanMemHash.put(spId, "");
                    continue;
                }
                lanMemHash.put(spId, "");
            }
            if (!sanMemHash.isEmpty()) {
                EndDeviceHandler.getInstance().populateSanConnectTo(sanMemHash);
            }
            if (!lanMemHash.isEmpty()) {
                EndDeviceHandler.getInstance().populateLanConnectTo(lanMemHash);
            }
            memHash.putAll(sanMemHash);
            memHash.putAll(lanMemHash);
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)("Failed to get group member:" + gId), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return memHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPortGroupMemberInHash(int gId) {
        HashMap<String, String> memHash = new HashMap<String, String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement(_GetGroupMemberSQL);
            stmt.setInt(1, gId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long grpMemId = rs.getLong(1);
                long swId = rs.getLong(2);
                int type = rs.getInt(3);
                String network = type == 4 ? "LAN" : "SAN";
                memHash.put(swId + ":" + grpMemId + ":" + network, swId + "");
            }
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)("Failed to get group member:" + gId), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return memHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallResultDO removeGroupMember(long memId) {
        CallResultDO rstDo = new CallResultDO();
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement("delete from app_group_member where id=?");
            stmt.setLong(1, memId);
            stmt.execute();
        }
        catch (Exception ex) {
            try {
                String errMsg = "Failed to remove group member:" + memId;
                _Logger.error((Object)errMsg, (Throwable)ex);
                rstDo.setResultStatus(-1);
                rstDo.setResultMessage(errMsg);
            }
            catch (Throwable throwable) {
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(stmt);
        DbUtil.close(con);
        return rstDo;
    }

    public static void main(String[] args) {
        Set<Integer> s = AppGroupUtil.getInstance().getPortGroupId(42806620L, 42802780L, 3);
        for (Integer i : s) {
            System.out.println(i);
        }
    }
}

