/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.vpc;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.dcm.common.util.IntegerRange;
import com.cisco.dcbu.dcm.model.enumkind.NetworkElementManagementState;
import com.cisco.dcbu.dcm.model.enumkind.NetworkInterfaceFlowControlMethod;
import com.cisco.dcbu.dcm.model.enumkind.NetworkInterfaceSpeedMode;
import com.cisco.dcbu.dcm.model.enumkind.StpGuardState;
import com.cisco.dcbu.dcm.model.enumkind.StpInterfacePortType;
import com.cisco.dcbu.dcm.model.enumkind.StpPortType;
import com.cisco.dcbu.dcm.model.enumkind.StpProtocol;
import com.cisco.dcbu.dcm.model.enumkind.SwitchedNetworkInterfaceMode;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.jaxws.lan.ep.util.LanReferenceFactory;
import com.cisco.dcbu.jaxws.lan.wo.vpc.ResolveVpcDO;
import com.cisco.dcbu.jaxws.lan.wo.vpc.ResolveVpcStatusDO;
import com.cisco.dcbu.jaxws.lan.wo.vpc.VpcDO;
import com.cisco.dcbu.jaxws.lan.wo.vpc.VpcInconsistencyDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lan.webservice.client.generated.vpc.LanServiceException;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.vpc.Constants;
import com.cisco.dcbu.sm.server.web.vpc.VpcInconsistencyState;
import com.cisco.dcbu.sm.server.web.vpc.VpcInconsistencyStatus;
import com.cisco.dcbu.sm.server.web.vpc.VpcInconsistentMaps;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public class VpcHandler {
    private static VpcHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash;
    private Hashtable<String, VpcInconsistentMaps> inconsistentMap = new Hashtable();
    private Hashtable<String, VpcInconsistentMaps> vpcinconsistentMap = new Hashtable();
    private Hashtable<String, VpcInconsistentMaps> gvpcinconsistentMap = new Hashtable();
    ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(10);

    public static VpcHandler getInstance() {
        if (_Instance == null) {
            _Instance = new VpcHandler();
        }
        return _Instance;
    }

    private VpcHandler() {
        this._Name2SqlHash = new HashMap<String, String>();
        this.initSqlSortSuffix();
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("vpcId", " order by cvpc.vpcId ");
        this._Name2SqlHash.put("domainId", " order by ep_domain_Id ");
        this._Name2SqlHash.put("accessPoCh", " order by access_poch.name ");
        this._Name2SqlHash.put("accessAne", " order by access_ane ");
    }

    public int getVpcDataLength(DbFilterDO dbFilter, boolean allVpc) {
        ArrayList<VpcDO> vpcs = this.getAllVpcs(dbFilter, "", allVpc, "", 0);
        List<NameValue> nvs = this.getColFilterNameValue(dbFilter.getColFilterStr());
        for (NameValue nameValue : nvs) {
            CollectionUtils.filter(vpcs, (Predicate)new VpcFilter(nameValue.key, nameValue.vlu));
        }
        return vpcs.size();
    }

    public VpcDO[] getInconsistentVpcList(DbFilterDO dbFilter, String status, int startIdx, int recordSize, boolean allVpc) throws SanServiceException {
        String sortSqlSuffix = this._Name2SqlHash.get("vpcId");
        ArrayList<VpcDO> vpcs = this.getAllVpcs(dbFilter, "", allVpc, "", 0);
        VpcComparator comparator = new VpcComparator(dbFilter.getSortField(), dbFilter.getSortType());
        Collections.sort(vpcs, comparator);
        List<NameValue> nvs = this.getColFilterNameValue(dbFilter.getColFilterStr());
        for (NameValue nameValue : nvs) {
            CollectionUtils.filter(vpcs, (Predicate)new VpcFilter(nameValue.key, nameValue.vlu));
        }
        int endIndex = startIdx + recordSize > vpcs.size() ? vpcs.size() : startIdx + recordSize;
        List _vpcs = vpcs.subList(startIdx, endIndex);
        VpcDO[] vpcdos = new VpcDO[_vpcs.size() < recordSize ? _vpcs.size() : recordSize];
        int index = 0;
        for (VpcDO vpcDO : _vpcs) {
            vpcdos[index++] = vpcDO;
        }
        return vpcdos;
    }

    private List<NameValue> getColFilterNameValue(String colFilterStr) {
        String filterSql = "";
        ArrayList<NameValue> nvs = new ArrayList<NameValue>();
        if (colFilterStr != null && colFilterStr.length() > 0) {
            String[] pairs = colFilterStr.split(";");
            for (int i = 0; i < pairs.length; ++i) {
                String item = pairs[i];
                if (item.split(":")[0] == null || item.split(":").length < 2) continue;
                String key = item.split(":")[0];
                String vlu = item.split(":")[1];
                if ("All".equals(vlu)) continue;
                nvs.add(new NameValue(key, vlu));
            }
        }
        return nvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<VpcDO> getAllVpcs(DbFilterDO dbFilter, String sortSqlSuffix, boolean inconsistent, String sqlSuffix, int startIdx) {
        LinkedHashMap<String, VpcDO> inconsitencyTuplesMap;
        ArrayList<VpcDO> resultList;
        block35: {
            resultList = new ArrayList<VpcDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            inconsitencyTuplesMap = new LinkedHashMap<String, VpcDO>();
            try {
                con = ConnectionManager.getConnection();
                sql = Constants.vpcinconsistentquery + sortSqlSuffix;
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                while (rs.next()) {
                    try {
                        String vPCRole;
                        String vpcinstanceId;
                        int mgmtstate;
                        NetworkElementManagementState elementManagementState;
                        if (!inconsistent && (PersistentHelper.getHelper().getBooleanFromStringField(rs, "vpc_isconsistent") || PersistentHelper.getHelper().getBooleanFromStringField(rs, "vpc_pl_isconsistent"))) continue;
                        String vpcId = rs.getString("ep_vpcId");
                        boolean licensestate = PersistentHelper.getHelper().getBooleanFromStringField(rs, "ep_licensedstate");
                        if (!licensestate || NetworkElementManagementState.MANAGED != (elementManagementState = NetworkElementManagementState.getInstance((int)(mgmtstate = Integer.valueOf(rs.getString("ep_mgmtstate")).intValue()))) || (vpcinstanceId = rs.getString("ep_VPC_ID")) == null) continue;
                        String vpcinstanceName = rs.getString("vpc_instancename");
                        String epinstanceId = rs.getString("ep_instanceClassId");
                        VpcDO inconsitencyTuple = (VpcDO)inconsitencyTuplesMap.get(vpcinstanceId);
                        boolean isMaster = false;
                        boolean alreadyExisted = true;
                        if (inconsitencyTuple == null) {
                            alreadyExisted = false;
                            inconsitencyTuple = new VpcDO();
                        }
                        if (rs.getString("ep_vpc_role").equals("2")) continue;
                        if (rs.getString("ep_vpc_role").equals("0")) {
                            isMaster = true;
                            inconsitencyTuple.masterOperational = "Primary";
                        } else if (rs.getString("ep_vpc_role").equals("1")) {
                            isMaster = false;
                            inconsitencyTuple.slaveOperational = "Secondary";
                        } else if (rs.getString("ep_vpc_role").equals("3")) {
                            vPCRole = "Primary, Operational Secondary";
                            if (inconsitencyTuple.masterdeviceIP == null && inconsitencyTuple.slavedeviceIP == null) {
                                isMaster = true;
                                inconsitencyTuple.masterOperational = vPCRole;
                            } else if (inconsitencyTuple.masterdeviceIP != null) {
                                isMaster = false;
                                inconsitencyTuple.slaveOperational = vPCRole;
                            } else if (inconsitencyTuple.slavedeviceIP != null) {
                                isMaster = true;
                                inconsitencyTuple.masterOperational = vPCRole;
                            }
                        } else if (rs.getString("ep_vpc_role").equals("4")) {
                            vPCRole = "Secondary, Operational Primary";
                            if (inconsitencyTuple.masterdeviceIP == null && inconsitencyTuple.slavedeviceIP == null) {
                                isMaster = false;
                                inconsitencyTuple.slaveOperational = vPCRole;
                            } else if (inconsitencyTuple.masterdeviceIP != null) {
                                isMaster = false;
                                inconsitencyTuple.slaveOperational = vPCRole;
                            } else if (inconsitencyTuple.slavedeviceIP != null) {
                                isMaster = true;
                                inconsitencyTuple.masterOperational = vPCRole;
                            }
                        }
                        inconsitencyTuple.vpcid = Integer.parseInt(vpcId);
                        inconsitencyTuple.domainId = Integer.parseInt(rs.getString("ep_domain_Id"));
                        Boolean firstPointinconsitent = null;
                        Boolean secondPointinconsitent = null;
                        Boolean firstPointpeerinconsitent = null;
                        Boolean secondPointpeerinconsitent = null;
                        if (isMaster) {
                            inconsitencyTuple.masterdevice = rs.getString("ep_hostName");
                            inconsitencyTuple.masterdeviceIP = rs.getString("ep_ipaddress");
                            inconsitencyTuple.masterpeerPO = Integer.parseInt(rs.getString("vpc_pl_poch").substring("Port-channel".length()));
                            inconsitencyTuple.masterNeId = Integer.parseInt(rs.getString("ep_ABSTRACTNETWORKELEMENT_ID"));
                            inconsitencyTuple.vpcInstanceClassId = Integer.parseInt(vpcinstanceId);
                            inconsitencyTuple.vpcInstanceName = vpcinstanceName;
                            inconsitencyTuple.masterPO = Integer.parseInt(rs.getString("vpc_poch").substring("Port-channel".length()));
                            inconsitencyTuple.masterPoinstanceClassId = Integer.parseInt(epinstanceId);
                            firstPointinconsitent = rs.getString("vpc_isconsistent") != null ? PersistentHelper.getHelper().getBooleanFromStringField(rs, "vpc_isconsistent") : false;
                            firstPointpeerinconsitent = rs.getString("vpc_pl_isconsistent") != null ? PersistentHelper.getHelper().getBooleanFromStringField(rs, "vpc_pl_isconsistent") : false;
                            inconsitencyTuple.vpcInconsistent = firstPointinconsitent != null && firstPointinconsitent != false;
                            inconsitencyTuple.globalInconsistent = firstPointpeerinconsitent != null && firstPointpeerinconsitent != false;
                        } else {
                            inconsitencyTuple.slavedevice = rs.getString("ep_hostName");
                            inconsitencyTuple.slavedeviceIP = rs.getString("ep_ipaddress");
                            inconsitencyTuple.slavePO = Integer.parseInt(rs.getString("vpc_poch").substring("Port-channel".length()));
                            inconsitencyTuple.slavepeerPO = Integer.parseInt(rs.getString("vpc_pl_poch").substring("Port-channel".length()));
                            inconsitencyTuple.vpcInstanceClassId = Integer.parseInt(vpcinstanceId);
                            inconsitencyTuple.vpcInstanceName = vpcinstanceName;
                            inconsitencyTuple.slaveNeId = Integer.parseInt(rs.getString("ep_ABSTRACTNETWORKELEMENT_ID"));
                            inconsitencyTuple.slavePoinstanceClassId = Integer.parseInt(epinstanceId);
                            secondPointinconsitent = rs.getString("vpc_isconsistent") != null ? PersistentHelper.getHelper().getBooleanFromStringField(rs, "vpc_isconsistent") : false;
                            secondPointpeerinconsitent = rs.getString("vpc_pl_isconsistent") != null ? PersistentHelper.getHelper().getBooleanFromStringField(rs, "vpc_pl_isconsistent") : false;
                            inconsitencyTuple.vpcInconsistent = secondPointinconsitent != null && inconsitencyTuple.vpcInconsistent && secondPointinconsitent != false;
                            boolean bl = inconsitencyTuple.globalInconsistent = secondPointpeerinconsitent != null && inconsitencyTuple.globalInconsistent && secondPointpeerinconsitent != false;
                        }
                        if (rs.getString("access_po_name") != null) {
                            if (alreadyExisted) {
                                if (!(inconsitencyTuple.accessdevice.equals("n/a") || inconsitencyTuple.accessPoTip.equals("n/a") || inconsitencyTuple.accessdevice.trim().equals(rs.getString("access_ane").trim()) || inconsitencyTuple.accessPoTip.trim().equals(rs.getString("access_po_name").substring("Port-channel".length()).trim()))) {
                                    inconsitencyTuple.accessPO = 0;
                                    inconsitencyTuple.accessPoTip = "n/a";
                                    inconsitencyTuple.accessdevice = "n/a";
                                }
                            } else {
                                inconsitencyTuple.accessPO = Integer.parseInt(rs.getString("access_po_name").substring("Port-channel".length()));
                                inconsitencyTuple.accessPoTip = rs.getString("access_po_name").substring("Port-channel".length());
                                inconsitencyTuple.accessdevice = rs.getString("access_ane");
                            }
                        } else {
                            inconsitencyTuple.accessPO = 0;
                            inconsitencyTuple.accessPoTip = "n/a";
                            inconsitencyTuple.accessdevice = "n/a";
                        }
                        inconsitencyTuplesMap.put(vpcinstanceId, inconsitencyTuple);
                    }
                    catch (Exception ex) {
                        this._Log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block35;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        for (VpcDO inconsistentVpcVO : inconsitencyTuplesMap.values()) {
            if (inconsistentVpcVO.masterdevice == null || inconsistentVpcVO.slavedevice == null) continue;
            resultList.add(inconsistentVpcVO);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VpcInconsistencyDO getVpcInconsistency(int masterInstanceNameId, int slaveInstanceNameId, boolean forPeerlink, String sqlSuffix) throws SanServiceException {
        block6: {
            VpcInconsistencyDO vpcInconsistencyDO;
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            VpcInconsistencyDO vpcInconsistencyDO2 = new VpcInconsistencyDO();
            try {
                con = ConnectionManager.getConnection();
                sql = Constants.vpcinconsistentreport;
                sql = MessageFormat.format(sql, masterInstanceNameId + "", slaveInstanceNameId + "");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                rs = SQLLoader.execute(stmt);
                boolean isMaster = true;
                while (rs.next()) {
                    isMaster = masterInstanceNameId == Integer.parseInt(rs.getString("instanceClassId"));
                    this.populate(vpcInconsistencyDO2, rs, isMaster);
                }
                vpcInconsistencyDO = vpcInconsistencyDO2;
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
            return vpcInconsistencyDO;
        }
        return null;
    }

    public String getDuplexMode(String number) {
        try {
            switch (Integer.valueOf(number)) {
                case 0: {
                    return "Half";
                }
                case 1: {
                    return "Full";
                }
                case 2: {
                    return "Auto";
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getPortChannelProtocol(String number) {
        try {
            switch (Integer.valueOf(number)) {
                case 0: {
                    return "lacp";
                }
                case 1: {
                    return "pagp";
                }
                case 2: {
                    return "none";
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMstGlobal(VpcInconsistencyDO inconsistencyVO, String aneId, boolean isMaster) {
        block7: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            String vlans = "";
            try {
                con = ConnectionManager.getConnection();
                sql = Constants.MSTGLOBALPROPERTIES;
                sql = MessageFormat.format(Constants.MSTGLOBALPROPERTIES, aneId);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + "", 1004, 1007);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    if (isMaster) {
                        inconsistencyVO.primary_mst_gsimulatepvst = rs.getString("simulatepvst") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "simulatepvst") ? "Enabled" : "Disabled";
                        inconsistencyVO.primary_mst_reg_name = rs.getString("name");
                        inconsistencyVO.primary_mst_reg_rev = rs.getString("revision");
                        continue;
                    }
                    inconsistencyVO.secondary_mst_gsimulatepvst = rs.getString("simulatepvst") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "simulatepvst") ? "Enabled" : "Disabled";
                    inconsistencyVO.secondary_mst_reg_name = rs.getString("name");
                    inconsistencyVO.secondary_mst_reg_rev = rs.getString("revision");
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block7;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
    }

    private void populate(VpcInconsistencyDO inconsistencyVO, ResultSet rs, boolean isMaster) {
        block11: {
            try {
                this.populateMstGlobal(inconsistencyVO, rs.getString("ane_instanceclassid"), isMaster);
                if (isMaster) {
                    inconsistencyVO.primary_channel_id = rs.getString("vpc_poch");
                    inconsistencyVO.primary_description = rs.getString("vpc_poch_desc");
                    inconsistencyVO.primary_portMode = SwitchedNetworkInterfaceMode.getInstance((int)Integer.parseInt(rs.getString("vpc_poch_Mode"))).getName();
                    inconsistencyVO.primary_protocol = this.getPortChannelProtocol(rs.getString("vpc_poch_protocol"));
                    inconsistencyVO.primary_bandwidth = rs.getString("vpc_poch_bandwidth");
                    inconsistencyVO.primary_delay = rs.getString("vpc_poch_delay");
                    String pri_speed = null;
                    if (rs.getString("vpc_poch_speedConfigured") != null) {
                        pri_speed = NetworkInterfaceSpeedMode.getInstance((int)Integer.valueOf(rs.getString("vpc_poch_speedConfigured"))).getKeyword();
                    }
                    inconsistencyVO.primary_speed = pri_speed;
                    inconsistencyVO.primary_duplex = this.getDuplexMode(rs.getString("vpc_poch_duplexconfigured"));
                    inconsistencyVO.primary_simulatepvst = rs.getString("simulatepvst");
                    inconsistencyVO.primary_mtu = rs.getString("vpc_poch_mtu");
                    inconsistencyVO.primary_flowctrlRecv = NetworkInterfaceFlowControlMethod.getInstance((int)Integer.parseInt(rs.getString("vpc_poch_rxFlCntlCfg"))).getName();
                    inconsistencyVO.primary_flowctrlSend = NetworkInterfaceFlowControlMethod.getInstance((int)Integer.parseInt(rs.getString("vpc_poch_txFlCntlCfg"))).getName();
                    inconsistencyVO.primary_allowedVlan = rs.getString("vpc_poch_allowed_vlans");
                    inconsistencyVO.primary_stpPortType = StpInterfacePortType.getInstance((int)Integer.parseInt(rs.getString("stp_porttype"))).getName();
                    inconsistencyVO.primary_stpPortGuard = StpGuardState.getInstance((int)Integer.parseInt(rs.getString("stp_guardenabled"))).getName();
                    inconsistencyVO.primary_accessVlan = rs.getString("vlan_access_id");
                    inconsistencyVO.primary_nativeVlan = rs.getString("vlan_native_id");
                    inconsistencyVO.primary_stp_protocol = StpProtocol.getInstance((int)Integer.parseInt(rs.getString("stp_global_protocol"))).getName();
                    inconsistencyVO.primary_port_type = StpPortType.getInstance((int)Integer.parseInt(rs.getString("stp_global_porttype"))).getName();
                    inconsistencyVO.primary_bpdu_guard = rs.getString("stp_global_bpduGuardEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_global_bpduGuardEnabled") ? "true" : "false";
                    inconsistencyVO.primary_bpdu_filter = rs.getString("stp_global_bpduFilterEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_global_bpduFilterEnabled") ? "true" : "false";
                    inconsistencyVO.primary_bridge_assurance = rs.getString("stp_bridgeAssuranceEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_bridgeAssuranceEnabled") ? "true" : "false";
                    inconsistencyVO.primary_loop_guard = rs.getString("stp_global_loopGuardEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_global_loopGuardEnabled") ? "true" : "false";
                    boolean flag = false;
                    try {
                        flag = LanReferenceFactory.getInstance().getVpcWS(SecurityHandler.getToken()).isPvstConsistenccySupported(Integer.valueOf(rs.getString("ane_instanceclassid")).intValue());
                    }
                    catch (RuntimeException _e) {
                        this._Log.error((Object)_e.getMessage(), (Throwable)_e);
                    }
                    if (!flag) {
                        inconsistencyVO.primary_stp_enabled_vlans = this.populateStpEnabledVlans(rs.getString("ane_instanceclassid"));
                    }
                    inconsistencyVO.primary_mst_vlans = this.populateMstVlans(rs.getString("ane_instanceclassid"));
                    inconsistencyVO.primary_domainId = rs.getString("vpc_domainId");
                    inconsistencyVO.primary_systemMacAddress = rs.getString("domain_mac_address");
                    inconsistencyVO.primary_systemPriority = rs.getString("domain_systempriority");
                    inconsistencyVO.primary_excludeInterfaceVlan = rs.getString("domain_excludeinterfacevlans");
                    inconsistencyVO.primary_udpPort = rs.getString("domain_udpport");
                    inconsistencyVO.primary_interval = rs.getString("domain_vpcdomaininterval");
                    inconsistencyVO.primary_timeout = rs.getString("domain_vpctimeout");
                    break block11;
                }
                inconsistencyVO.secondary_domainId = rs.getString("vpc_domainId");
                inconsistencyVO.secondary_systemMacAddress = rs.getString("domain_mac_address");
                inconsistencyVO.secondary_systemPriority = rs.getString("domain_systempriority");
                inconsistencyVO.secondary_excludeInterfaceVlan = rs.getString("domain_excludeinterfacevlans");
                inconsistencyVO.secondary_udpPort = rs.getString("domain_udpport");
                inconsistencyVO.secondary_interval = rs.getString("domain_vpcdomaininterval");
                inconsistencyVO.secondary_timeout = rs.getString("domain_vpctimeout");
                inconsistencyVO.secondary_simulatepvst = rs.getString("simulatepvst");
                inconsistencyVO.secondary_stp_protocol = StpProtocol.getInstance((int)Integer.parseInt(rs.getString("stp_global_protocol"))).getName();
                inconsistencyVO.secondary_port_type = StpPortType.getInstance((int)Integer.parseInt(rs.getString("stp_global_porttype"))).getName();
                inconsistencyVO.secondary_bpdu_guard = rs.getString("stp_global_bpduGuardEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_global_bpduGuardEnabled") ? "true" : "false";
                inconsistencyVO.secondary_bpdu_filter = rs.getString("stp_global_bpduFilterEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_global_bpduFilterEnabled") ? "true" : "false";
                inconsistencyVO.secondary_bridge_assurance = rs.getString("stp_bridgeAssuranceEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_bridgeAssuranceEnabled") ? "true" : "false";
                inconsistencyVO.secondary_loop_guard = rs.getString("stp_global_loopGuardEnabled") != null && PersistentHelper.getHelper().getBooleanFromStringField(rs, "stp_global_loopGuardEnabled") ? "true" : "false";
                boolean flag = false;
                try {
                    flag = LanReferenceFactory.getInstance().getVpcWS(SecurityHandler.getToken()).isPvstConsistenccySupported(Integer.valueOf(rs.getString("ane_instanceclassid")).intValue());
                }
                catch (RuntimeException _e) {
                    this._Log.error((Object)_e.getMessage(), (Throwable)_e);
                }
                if (!flag) {
                    inconsistencyVO.secondary_stp_enabled_vlans = this.populateStpEnabledVlans(rs.getString("ane_instanceclassid"));
                }
                inconsistencyVO.secondary_mst_vlans = this.populateMstVlans(rs.getString("ane_instanceclassid"));
                inconsistencyVO.secondary_channel_id = rs.getString("vpc_poch");
                inconsistencyVO.secondary_description = rs.getString("vpc_poch_desc");
                inconsistencyVO.secondary_portMode = SwitchedNetworkInterfaceMode.getInstance((int)Integer.parseInt(rs.getString("vpc_poch_Mode"))).getName();
                inconsistencyVO.secondary_protocol = this.getPortChannelProtocol(rs.getString("vpc_poch_protocol"));
                inconsistencyVO.secondary_bandwidth = rs.getString("vpc_poch_bandwidth");
                inconsistencyVO.secondary_delay = rs.getString("vpc_poch_delay");
                inconsistencyVO.secondary_duplex = this.getDuplexMode(rs.getString("vpc_poch_duplexconfigured"));
                String sec_speed = null;
                if (rs.getString("vpc_poch_speedConfigured") != null) {
                    sec_speed = NetworkInterfaceSpeedMode.getInstance((int)Integer.valueOf(rs.getString("vpc_poch_speedConfigured"))).getKeyword();
                }
                inconsistencyVO.secondary_speed = sec_speed;
                inconsistencyVO.secondary_mtu = rs.getString("vpc_poch_mtu");
                inconsistencyVO.secondary_flowctrlRecv = NetworkInterfaceFlowControlMethod.getInstance((int)Integer.parseInt(rs.getString("vpc_poch_rxFlCntlCfg"))).getName();
                inconsistencyVO.secondary_flowctrlSend = NetworkInterfaceFlowControlMethod.getInstance((int)Integer.parseInt(rs.getString("vpc_poch_txFlCntlCfg"))).getName();
                inconsistencyVO.secondary_allowedVlan = rs.getString("vpc_poch_allowed_vlans");
                inconsistencyVO.secondary_stpPortType = StpInterfacePortType.getInstance((int)Integer.parseInt(rs.getString("stp_porttype"))).getName();
                inconsistencyVO.secondary_stpPortGuard = StpGuardState.getInstance((int)Integer.parseInt(rs.getString("stp_guardenabled"))).getName();
                inconsistencyVO.secondary_accessVlan = rs.getString("vlan_access_id");
                inconsistencyVO.secondary_nativeVlan = rs.getString("vlan_native_id");
            }
            catch (Exception e) {
                this._Log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String populateMstVlans(String aneId) {
        String vlans;
        block6: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            vlans = "";
            try {
                con = ConnectionManager.getConnection();
                sql = Constants.MSTVLANS;
                sql = MessageFormat.format(Constants.MSTVLANS, aneId);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + "", 1004, 1007);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    vlans = vlans + rs.getString(2) + " -> " + rs.getString(3) + " , ";
                }
                vlans = vlans.substring(0, vlans.length() - 1);
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return vlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String populateStpEnabledVlans(String aneId) {
        String vlans;
        block6: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            vlans = "";
            try {
                con = ConnectionManager.getConnection();
                sql = Constants.STPENABLEDVLANS;
                sql = MessageFormat.format(Constants.STPENABLEDVLANS, aneId);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + "", 1004, 1007);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    vlans = vlans + rs.getString(1) + ",";
                }
                vlans = vlans.substring(0, vlans.length() - 1);
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return vlans.length() == 0 ? "" : new IntegerRange(vlans).toString();
    }

    private String getCurrentUsername() {
        String token = SecurityHandler.getToken();
        if (token != null) {
            return IdentityManager.getInstance().extractToken(token).getUsername();
        }
        this._Log.error((Object)"Unable to get logged in Username, returning default username Admin!!!!");
        return "admin";
    }

    public void _synchronizeGlobalSettingsForPrimaryAndSecondary(int primaryNeId, int secondaryNeId) throws LanServiceException, RemoteException, Exception {
        LanReferenceFactory.getInstance().getVpcWS(SecurityHandler.getToken()).synchronizeGlobalSettingsForPrimaryAndSecondary(primaryNeId, secondaryNeId);
    }

    public void _synchronizePrimaryAndSecondary(int primaryNeId, String vpcInstanceName, int vpcInstanceClassId) throws LanServiceException, RemoteException, Exception {
        LanReferenceFactory.getInstance().getVpcWS(SecurityHandler.getToken()).synchronizePrimaryAndSecondary(primaryNeId, vpcInstanceName, vpcInstanceClassId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveVpcDO synchronizeGlobalSettingsForPrimaryAndSecondary(final int primaryNeId, final int secondaryNeId) throws LanServiceException, RemoteException, Exception {
        VpcHandler vpcHandler = this;
        synchronized (vpcHandler) {
            if (!this.checkIfCallFinishedForAllTheVpcs(false)) {
                throw new SanServiceException("Operation to resolve all vPC Inconsistencies is already in progress. Please try after some time.");
            }
            final String token = SecurityHandler.getToken();
            VpcInconsistencyState vpcInconsistencyState = new VpcInconsistencyState(primaryNeId, secondaryNeId, null);
            if (!this.checkIfCallFinishedForGlobalVpcs(vpcInconsistencyState)) {
                throw new SanServiceException("Operation to resolve vPC Global Inconsistencies is already in progress. Please try after some time.");
            }
            VpcInconsistentMaps inconsistentMaps = new VpcInconsistentMaps();
            final Map<String, VpcInconsistencyState> globalInconsistentMap = inconsistentMaps.globalInconsistentMap;
            globalInconsistentMap.put(primaryNeId + ":" + secondaryNeId, vpcInconsistencyState);
            ResolveVpcDO resolveVpcDo = new ResolveVpcDO();
            resolveVpcDo.id = new Date().toString();
            this.gvpcinconsistentMap.put(resolveVpcDo.id, inconsistentMaps);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    VpcInconsistencyState inconsistencyState;
                    String failureReason;
                    block11: {
                        SecurityHandler.setToken((String)token);
                        failureReason = null;
                        try {
                            VpcHandler.this._synchronizeGlobalSettingsForPrimaryAndSecondary(primaryNeId, secondaryNeId);
                        }
                        catch (Exception e) {
                            if (!(e instanceof LanServiceException)) break block11;
                            LanServiceException _e = (LanServiceException)e;
                            failureReason = _e.getDetail();
                        }
                    }
                    VpcDO vpcDO = null;
                    ArrayList vpcdos = VpcHandler.this.getAllVpcs(null, "", true, "", 0);
                    for (VpcDO vpcDO2 : vpcdos) {
                        if (vpcDO2.slaveNeId != secondaryNeId || vpcDO2.masterNeId != primaryNeId) continue;
                        vpcDO = vpcDO2;
                        break;
                    }
                    if ((inconsistencyState = (VpcInconsistencyState)globalInconsistentMap.get(primaryNeId + ":" + secondaryNeId)) == null) {
                        inconsistencyState = (VpcInconsistencyState)globalInconsistentMap.get(secondaryNeId + ":" + primaryNeId);
                    }
                    if (inconsistencyState != null) {
                        if (failureReason != null) {
                            inconsistencyState.setFailureReason(failureReason);
                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.Failed);
                        } else {
                            String description = "vPC global configuration synched on secondary device " + vpcDO.slavedeviceIP + " from master device " + vpcDO.masterdeviceIP;
                            InetAddress address = null;
                            try {
                                address = InetAddress.getByName(vpcDO.slavedeviceIP);
                            }
                            catch (UnknownHostException e) {
                                // empty catch block
                            }
                            try {
                                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(DCManager.getInstance().getLan().getPK(), IdentityManager.getInstance().getClientAddress(), DCManager.getInstance().getLan().getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), description, Severity.INFO.getValue(), 1));
                            }
                            catch (Exception ex) {
                                VpcHandler.this._Log.error((Object)("Exception while publishing accounting \n" + ex.getMessage()), (Throwable)ex);
                            }
                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.RESOLVED);
                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.RESOLVED);
                        }
                    }
                }
            };
            this.newFixedThreadPool.submit(runnable);
            return resolveVpcDo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveVpcDO synchronizePrimaryAndSecondary(final int primaryNeId, final String vpcInstanceName, final int vpcInstanceClassId) throws LanServiceException, RemoteException, Exception {
        VpcHandler vpcHandler = this;
        synchronized (vpcHandler) {
            if (!this.checkIfCallFinishedForAllTheVpcs(false)) {
                throw new SanServiceException("Operation to resolve all vPC Inconsistencies is already in progress. Please try after some time.");
            }
            VpcInconsistencyState vpcInconsistencyState = new VpcInconsistencyState(vpcInstanceClassId, null);
            if (!this.checkIfCallFinishedForVpc(vpcInconsistencyState)) {
                throw new SanServiceException("Operation to resolve vPC Inconsistencies is already in progress. Please try after some time.");
            }
            VpcInconsistentMaps inconsistentMaps = new VpcInconsistentMaps();
            final Map<String, VpcInconsistencyState> vpcInconsistentMap = inconsistentMaps.vpcInconsistentMap;
            vpcInconsistentMap.put(vpcInstanceClassId + "", vpcInconsistencyState);
            ResolveVpcDO resolveVpcDo = new ResolveVpcDO();
            resolveVpcDo.id = new Date().toString();
            this.vpcinconsistentMap.put(resolveVpcDo.id, inconsistentMaps);
            final String token = SecurityHandler.getToken();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    VpcInconsistencyState inconsistencyState;
                    String failureReason;
                    block10: {
                        failureReason = null;
                        try {
                            SecurityHandler.setToken((String)token);
                            VpcHandler.this._synchronizePrimaryAndSecondary(primaryNeId, vpcInstanceName, vpcInstanceClassId);
                        }
                        catch (Exception e) {
                            if (!(e instanceof LanServiceException)) break block10;
                            LanServiceException _e = (LanServiceException)e;
                            failureReason = _e.getDetail();
                            System.out.println(_e.getDetail());
                        }
                    }
                    VpcDO vpcDO = null;
                    ArrayList vpcdos = VpcHandler.this.getAllVpcs(null, "", true, "", 0);
                    for (VpcDO vpcDO2 : vpcdos) {
                        if (!vpcDO2.vpcInstanceName.equals(vpcInstanceName)) continue;
                        vpcDO = vpcDO2;
                        break;
                    }
                    if ((inconsistencyState = (VpcInconsistencyState)vpcInconsistentMap.get(vpcInstanceClassId + "")) != null) {
                        if (failureReason != null) {
                            inconsistencyState.setFailureReason(failureReason);
                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.Failed);
                        } else {
                            String description = "For vPC Id " + vpcDO.vpcid + " vPC configuration synched on secondary device " + vpcDO.slavedeviceIP + " from master device " + vpcDO.masterdeviceIP;
                            InetAddress address = null;
                            try {
                                address = InetAddress.getByName(vpcDO.slavedeviceIP);
                            }
                            catch (UnknownHostException e) {
                                // empty catch block
                            }
                            try {
                                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(DCManager.getInstance().getLan().getPK(), IdentityManager.getInstance().getClientAddress(), DCManager.getInstance().getLan().getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), description, Severity.INFO.getValue(), 1));
                            }
                            catch (Exception ex) {
                                VpcHandler.this._Log.error((Object)("Exception while publishing accounting \n" + ex.getMessage()), (Throwable)ex);
                            }
                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.RESOLVED);
                        }
                    }
                }
            };
            this.newFixedThreadPool.submit(runnable);
            return resolveVpcDo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveVpcDO resolveAllVpcInconsistency() throws Exception {
        VpcHandler vpcHandler = this;
        synchronized (vpcHandler) {
            if (!this.checkIfCallFinishedForAllTheVpcs(true)) {
                throw new SanServiceException("Operation to resolve vPC Inconsistencies is already in progress. Please try after some time.");
            }
            VpcInconsistentMaps inconsistentMaps = new VpcInconsistentMaps();
            final Map<String, VpcInconsistencyState> globalInconsistentMap = inconsistentMaps.globalInconsistentMap;
            final Map<String, VpcInconsistencyState> vpcInconsistentMap = inconsistentMaps.vpcInconsistentMap;
            ArrayList<VpcDO> vpcdos = this.getAllVpcs(null, "", true, "", 0);
            if (vpcdos == null || vpcdos.size() == 0) {
                throw new SanServiceException("There are no vPCs for the discovered license devices.");
            }
            ResolveVpcDO resolveVpcDo = new ResolveVpcDO();
            int count = 0;
            resolveVpcDo.id = new Date().toString();
            this.inconsistentMap.put(resolveVpcDo.id, inconsistentMaps);
            for (VpcDO vpcDO : vpcdos) {
                if (vpcDO.globalInconsistent && vpcDO.vpcInconsistent) continue;
                if (!vpcDO.globalInconsistent) {
                    globalInconsistentMap.put(vpcDO.masterNeId + ":" + vpcDO.slaveNeId, new VpcInconsistencyState(vpcDO.masterNeId, vpcDO.slaveNeId, vpcDO));
                }
                if (!vpcDO.vpcInconsistent) {
                    vpcInconsistentMap.put(vpcDO.vpcInstanceClassId + "", new VpcInconsistencyState(vpcDO.vpcInstanceClassId, vpcDO));
                }
                ++count;
            }
            if (!(globalInconsistentMap.values() != null && globalInconsistentMap.values().size() != 0 || vpcInconsistentMap.values() != null && vpcInconsistentMap.values().size() != 0)) {
                this.inconsistentMap.remove(resolveVpcDo.id);
                throw new SanServiceException("All the vPCs for the discovered licensed devices in DCNM are consistent.");
            }
            ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(10);
            final String token = SecurityHandler.getToken();
            for (VpcDO _vpcDO : vpcdos) {
                if (_vpcDO.globalInconsistent && _vpcDO.vpcInconsistent) continue;
                final VpcDO vpcDO = _vpcDO;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block21: {
                            InetAddress address;
                            String description;
                            VpcInconsistencyState inconsistencyState;
                            String failureReason;
                            block22: {
                                LanServiceException _e;
                                if (!vpcDO.globalInconsistent) {
                                    block20: {
                                        failureReason = null;
                                        try {
                                            SecurityHandler.setToken((String)token);
                                            VpcHandler.this._synchronizeGlobalSettingsForPrimaryAndSecondary(vpcDO.masterNeId, vpcDO.slaveNeId);
                                        }
                                        catch (Exception e) {
                                            if (!(e instanceof LanServiceException)) break block20;
                                            _e = (LanServiceException)e;
                                            failureReason = _e.getDetail();
                                        }
                                    }
                                    inconsistencyState = (VpcInconsistencyState)globalInconsistentMap.get(vpcDO.masterNeId + ":" + vpcDO.slaveNeId);
                                    if (inconsistencyState == null) {
                                        inconsistencyState = (VpcInconsistencyState)globalInconsistentMap.get(vpcDO.slaveNeId + ":" + vpcDO.masterNeId);
                                    }
                                    if (inconsistencyState != null) {
                                        if (failureReason != null) {
                                            inconsistencyState.setFailureReason(failureReason);
                                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.Failed);
                                        } else {
                                            description = "vPC global configuration synched on secondary device " + vpcDO.slavedeviceIP + " from master device " + vpcDO.masterdeviceIP;
                                            address = null;
                                            try {
                                                address = InetAddress.getByName(vpcDO.slavedeviceIP);
                                            }
                                            catch (UnknownHostException e) {
                                                // empty catch block
                                            }
                                            try {
                                                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(DCManager.getInstance().getLan().getPK(), IdentityManager.getInstance().getClientAddress(), DCManager.getInstance().getLan().getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), description, Severity.INFO.getValue(), 1));
                                            }
                                            catch (Exception ex) {
                                                VpcHandler.this._Log.error((Object)("Exception while publishing accounting \n" + ex.getMessage()), (Throwable)ex);
                                            }
                                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.RESOLVED);
                                        }
                                    }
                                }
                                if (vpcDO.vpcInconsistent) break block21;
                                failureReason = null;
                                try {
                                    SecurityHandler.setToken((String)token);
                                    VpcHandler.this._synchronizePrimaryAndSecondary(vpcDO.masterNeId, vpcDO.vpcInstanceName, vpcDO.vpcInstanceClassId);
                                }
                                catch (Exception e) {
                                    if (!(e instanceof LanServiceException)) break block22;
                                    _e = (LanServiceException)e;
                                    failureReason = _e.getDetail();
                                }
                            }
                            inconsistencyState = (VpcInconsistencyState)vpcInconsistentMap.get(vpcDO.vpcInstanceClassId + "");
                            if (inconsistencyState == null) break block21;
                            if (failureReason != null) {
                                inconsistencyState.setFailureReason(failureReason);
                                inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.Failed);
                                break block21;
                            }
                            description = "For vPC Id " + vpcDO.vpcid + " vPC configuration synched on secondary device " + vpcDO.slavedeviceIP + " from master device " + vpcDO.masterdeviceIP;
                            address = null;
                            try {
                                address = InetAddress.getByName(vpcDO.slavedeviceIP);
                            }
                            catch (UnknownHostException e) {
                                // empty catch block
                            }
                            try {
                                ((EventControllerService)ServiceConfig.findService((String)"Event Controller Service")).publishAccounting(new SyslogEntry(DCManager.getInstance().getLan().getPK(), address, DCManager.getInstance().getLan().getDBID(), "DCNM-LAN", LogEventType.LAN.toString(), IdentityManager.getInstance().getCurrentUsername(), description, Severity.INFO.getValue(), 1));
                            }
                            catch (Exception ex) {
                                VpcHandler.this._Log.error((Object)("Exception while publishing accounting \n" + ex.getMessage()), (Throwable)ex);
                            }
                            inconsistencyState.setInconsistencyStatus(VpcInconsistencyStatus.RESOLVED);
                        }
                    }
                };
                newFixedThreadPool.submit(runnable);
            }
            return resolveVpcDo;
        }
    }

    private boolean checkIfCallFinishedForVpc(VpcInconsistencyState inconsistencyState) {
        if (inconsistencyState == null) {
            Collection<VpcInconsistentMaps> values = this.vpcinconsistentMap.values();
            for (VpcInconsistentMaps vpcInconsistentMap : values) {
                Map<String, VpcInconsistencyState> vpcMap = vpcInconsistentMap.vpcInconsistentMap;
                Collection<VpcInconsistencyState> vPCvalues = vpcMap.values();
                for (VpcInconsistencyState vpcInconsistencyState : vPCvalues) {
                    if (vpcInconsistencyState.getInconsistencyStatus() != VpcInconsistencyStatus.INCONSISTENT) continue;
                    return false;
                }
            }
        } else {
            Collection<VpcInconsistentMaps> values = this.vpcinconsistentMap.values();
            for (VpcInconsistentMaps vpcInconsistentMap : values) {
                Map<String, VpcInconsistencyState> vpcMap = vpcInconsistentMap.vpcInconsistentMap;
                Collection<VpcInconsistencyState> vPCvalues = vpcMap.values();
                for (VpcInconsistencyState vpcInconsistencyState : vPCvalues) {
                    if (vpcInconsistencyState.getVpcInstanceClassId() != inconsistencyState.getVpcInstanceClassId() || vpcInconsistencyState.getInconsistencyStatus() != VpcInconsistencyStatus.INCONSISTENT) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkIfCallFinishedForGlobalVpcs(VpcInconsistencyState inconsistencyState) {
        if (inconsistencyState == null) {
            Collection<VpcInconsistentMaps> values = this.gvpcinconsistentMap.values();
            for (VpcInconsistentMaps vpcInconsistentMap : values) {
                Map<String, VpcInconsistencyState> globalMap = vpcInconsistentMap.globalInconsistentMap;
                Collection<VpcInconsistencyState> globalValues = globalMap.values();
                for (VpcInconsistencyState vpcInconsistencyState : globalValues) {
                    if (vpcInconsistencyState.getInconsistencyStatus() != VpcInconsistencyStatus.INCONSISTENT) continue;
                    return false;
                }
            }
        } else {
            Collection<VpcInconsistentMaps> values = this.gvpcinconsistentMap.values();
            for (VpcInconsistentMaps vpcInconsistentMap : values) {
                Map<String, VpcInconsistencyState> globalMap = vpcInconsistentMap.globalInconsistentMap;
                Collection<VpcInconsistencyState> globalValues = globalMap.values();
                for (VpcInconsistencyState vpcInconsistencyState : globalValues) {
                    if ((vpcInconsistencyState.getPrimaryNeId() != inconsistencyState.getPrimaryNeId() || vpcInconsistencyState.getSecondaryNeId() != inconsistencyState.getSecondaryNeId()) && (vpcInconsistencyState.getPrimaryNeId() != inconsistencyState.getSecondaryNeId() || vpcInconsistencyState.getSecondaryNeId() != inconsistencyState.getPrimaryNeId()) || vpcInconsistencyState.getInconsistencyStatus() != VpcInconsistencyStatus.INCONSISTENT) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkIfCallFinishedForAllTheVpcs(boolean all) {
        Collection<VpcInconsistentMaps> values = this.inconsistentMap.values();
        for (VpcInconsistentMaps vpcInconsistentMap : values) {
            Map<String, VpcInconsistencyState> globalMap = vpcInconsistentMap.globalInconsistentMap;
            Map<String, VpcInconsistencyState> vpcMap = vpcInconsistentMap.vpcInconsistentMap;
            Collection<VpcInconsistencyState> globalValues = globalMap.values();
            Collection<VpcInconsistencyState> vPCvalues = vpcMap.values();
            for (VpcInconsistencyState vpcInconsistencyState : vPCvalues) {
                if (vpcInconsistencyState.getInconsistencyStatus() != VpcInconsistencyStatus.INCONSISTENT) continue;
                return false;
            }
            for (VpcInconsistencyState vpcInconsistencyState : globalValues) {
                if (vpcInconsistencyState.getInconsistencyStatus() != VpcInconsistencyStatus.INCONSISTENT) continue;
                return false;
            }
        }
        if (all && !this.checkIfCallFinishedForGlobalVpcs(null)) {
            return false;
        }
        return !all || this.checkIfCallFinishedForVpc(null);
    }

    public ResolveVpcStatusDO[] getResolveInconsistencyStatus(String id) throws Exception {
        VpcDO vpcDo;
        VpcInconsistentMaps vpcInconsistentMap = this.inconsistentMap.get(id);
        if (vpcInconsistentMap == null) {
            vpcInconsistentMap = this.gvpcinconsistentMap.get(id);
        }
        if (vpcInconsistentMap == null) {
            vpcInconsistentMap = this.vpcinconsistentMap.get(id);
        }
        if (vpcInconsistentMap == null) {
            throw new SanServiceException("Operation is already finished or never executed");
        }
        HashMap<String, ResolveVpcStatusDO> resolveVpcStatusDoMap = new HashMap<String, ResolveVpcStatusDO>();
        Map<String, VpcInconsistencyState> globalMap = vpcInconsistentMap.globalInconsistentMap;
        Map<String, VpcInconsistencyState> vpcMap = vpcInconsistentMap.vpcInconsistentMap;
        if (vpcMap != null) {
            for (VpcInconsistencyState vpcInconsistencyState : vpcMap.values()) {
                ResolveVpcStatusDO resolveVpcStatusDO;
                vpcDo = vpcInconsistencyState.getVpcDO();
                if (vpcDo != null) {
                    resolveVpcStatusDO = (ResolveVpcStatusDO)resolveVpcStatusDoMap.get(vpcDo.vpcInstanceClassId + "");
                    if (resolveVpcStatusDO == null) {
                        resolveVpcStatusDO = new ResolveVpcStatusDO();
                    }
                    resolveVpcStatusDO.vpcDO = vpcDo;
                    resolveVpcStatusDO.vpcFailedReason = vpcInconsistencyState.getFailureReason();
                    resolveVpcStatusDO.gAlreadyResolved = true;
                    resolveVpcStatusDoMap.put(vpcDo.vpcInstanceClassId + "", resolveVpcStatusDO);
                    continue;
                }
                resolveVpcStatusDO = new ResolveVpcStatusDO();
                if (vpcInconsistencyState.getFailureReason() == null) {
                    resolveVpcStatusDO.vpcFailedReason = "Successfully resolved the vPC Inconsistency.";
                    resolveVpcStatusDO.vpcStatus = true;
                } else {
                    resolveVpcStatusDO.vpcFailedReason = vpcInconsistencyState.getFailureReason();
                }
                resolveVpcStatusDoMap.put("id", resolveVpcStatusDO);
            }
        }
        if (globalMap != null) {
            for (VpcInconsistencyState vpcInconsistencyState : globalMap.values()) {
                vpcDo = vpcInconsistencyState.getVpcDO();
                if (vpcDo != null) {
                    ResolveVpcStatusDO resolveVpcStatusDO2;
                    boolean flag = false;
                    for (ResolveVpcStatusDO resolveVpcStatusDO2 : resolveVpcStatusDoMap.values()) {
                        if (resolveVpcStatusDO2.vpcDO.masterNeId != vpcDo.masterNeId && resolveVpcStatusDO2.vpcDO.slaveNeId != vpcDo.slaveNeId && resolveVpcStatusDO2.vpcDO.slaveNeId != vpcDo.masterNeId && resolveVpcStatusDO2.vpcDO.masterNeId != vpcDo.slaveNeId) continue;
                        resolveVpcStatusDO2.gVpcFailedReason = vpcInconsistencyState.getFailureReason();
                        resolveVpcStatusDO2.gAlreadyResolved = false;
                        flag = true;
                    }
                    if (flag) continue;
                    resolveVpcStatusDO2 = new ResolveVpcStatusDO();
                    resolveVpcStatusDO2.vpcDO = vpcDo;
                    if (vpcInconsistencyState.getFailureReason() == null) {
                        resolveVpcStatusDO2.gVpcFailedReason = "Successfully resolved the vPC Inconsistency.";
                        resolveVpcStatusDO2.globalStatus = true;
                    } else {
                        resolveVpcStatusDO2.gVpcFailedReason = vpcInconsistencyState.getFailureReason();
                    }
                    resolveVpcStatusDO2.vpcAlreadyResolved = true;
                    resolveVpcStatusDoMap.put(vpcDo.vpcInstanceClassId + "", resolveVpcStatusDO2);
                    continue;
                }
                ResolveVpcStatusDO resolveVpcStatusDO = new ResolveVpcStatusDO();
                if (vpcInconsistencyState.getFailureReason() == null) {
                    resolveVpcStatusDO.gVpcFailedReason = "Successfully resolved the vPC Inconsistency.";
                    resolveVpcStatusDO.globalStatus = true;
                } else {
                    resolveVpcStatusDO.gVpcFailedReason = vpcInconsistencyState.getFailureReason();
                }
                resolveVpcStatusDO.vpcAlreadyResolved = true;
                resolveVpcStatusDoMap.put("id", resolveVpcStatusDO);
            }
        }
        ResolveVpcStatusDO[] resolveVpcStatusArray = new ResolveVpcStatusDO[resolveVpcStatusDoMap.values().size()];
        Iterator itr = resolveVpcStatusDoMap.values().iterator();
        int count = 0;
        while (itr.hasNext()) {
            ResolveVpcStatusDO resolveVpcStatusDO = (ResolveVpcStatusDO)itr.next();
            resolveVpcStatusArray[count++] = resolveVpcStatusDO;
        }
        return resolveVpcStatusArray;
    }

    public boolean checkIfResolveInconsistencyInProgress(String id) {
        Map<String, VpcInconsistencyState> globalMap;
        VpcInconsistentMaps vpcInconsistentMap = this.inconsistentMap.get(id);
        boolean flag = false;
        if (vpcInconsistentMap != null) {
            globalMap = null;
            Map<String, VpcInconsistencyState> vpcMap = null;
            globalMap = vpcInconsistentMap.globalInconsistentMap;
            vpcMap = vpcInconsistentMap.vpcInconsistentMap;
            for (VpcInconsistencyState vpcInconsistencyState : globalMap.values()) {
                if (vpcInconsistencyState.getInconsistencyStatus() == null || !vpcInconsistencyState.getInconsistencyStatus().equals((Object)VpcInconsistencyStatus.INCONSISTENT)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                for (VpcInconsistencyState vpcInconsistencyState : vpcMap.values()) {
                    if (vpcInconsistencyState.getInconsistencyStatus() == null || !vpcInconsistencyState.getInconsistencyStatus().equals((Object)VpcInconsistencyStatus.INCONSISTENT)) continue;
                    flag = true;
                    break;
                }
            }
        }
        vpcInconsistentMap = this.gvpcinconsistentMap.get(id);
        if (!flag && vpcInconsistentMap != null) {
            globalMap = null;
            globalMap = vpcInconsistentMap.globalInconsistentMap;
            for (VpcInconsistencyState vpcInconsistencyState : globalMap.values()) {
                if (vpcInconsistencyState.getInconsistencyStatus() == null || !vpcInconsistencyState.getInconsistencyStatus().equals((Object)VpcInconsistencyStatus.INCONSISTENT)) continue;
                flag = true;
                break;
            }
        }
        vpcInconsistentMap = this.vpcinconsistentMap.get(id);
        if (!flag && vpcInconsistentMap != null) {
            Map<String, VpcInconsistencyState> vpcMap = null;
            vpcMap = vpcInconsistentMap.vpcInconsistentMap;
            for (VpcInconsistencyState vpcInconsistencyState : vpcMap.values()) {
                if (vpcInconsistencyState.getInconsistencyStatus() == null || !vpcInconsistencyState.getInconsistencyStatus().equals((Object)VpcInconsistencyStatus.INCONSISTENT)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private HashMap<String, HorizontalAlign> getColumnAlignment() {
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("vPC ID", HorizontalAlign.RIGHT);
        columnAlignment.put("Domain ID", HorizontalAlign.RIGHT);
        columnAlignment.put("Port Channel", HorizontalAlign.RIGHT);
        columnAlignment.put("Peer Port Channel", HorizontalAlign.RIGHT);
        return columnAlignment;
    }

    public String exportVpcInconTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) {
        this._Log.info((Object)"Inside vPC Inconsistency exportVpcInconTable");
        this._Log.info((Object)("startIdx: " + startIdx));
        this._Log.info((Object)("recordSize: " + recordSize));
        this._Log.info((Object)("columnHeader.length: " + columnHeader.length));
        this.fixColumnheader(columnHeader);
        try {
            VpcDO[] vpcs = VpcHandler.getInstance().getInconsistentVpcList(dbFilter, "All", startIdx, recordSize, true);
            List<VpcDO> rstList = Arrays.asList(vpcs);
            return JasperPrintGenerator.getInstance().generateExcelReport("vPC Inconsistency", columnHeader, this.getColumnAlignment(), rstList);
        }
        catch (SanServiceException e) {
            this._Log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void fixColumnheader(String[] columnHeader) {
        for (int count = 0; count < columnHeader.length; ++count) {
            if (columnHeader[count].contains("globalInconsistent")) {
                columnHeader[count] = columnHeader[count].replace("globalInconsistent", "globalInconsistentStr");
            } else if (columnHeader[count].contains("vpcInconsistent")) {
                columnHeader[count] = columnHeader[count].replace("vpcInconsistent", "vpcInconsistentStr");
            } else if (columnHeader[count].contains("accessPO")) {
                columnHeader[count] = columnHeader[count].replace("accessPO", "accessPoTip");
            }
            if (columnHeader[count].equals("Port")) {
                columnHeader[count] = columnHeader[count].replace("Port", "Port Channel");
                continue;
            }
            if (!columnHeader[count].equals("Peer Port")) continue;
            columnHeader[count] = columnHeader[count].replace("Peer Port", "Peer Port Channel");
        }
    }

    public String printVpcInconTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) {
        try {
            this.fixColumnheader(columnHeader);
            VpcDO[] vpcs = VpcHandler.getInstance().getInconsistentVpcList(dbFilter, "All", startIdx, recordSize, true);
            List<VpcDO> rstList = Arrays.asList(vpcs);
            return JasperPrintGenerator.getInstance().generatePrintReport("vPC Inconsistency", columnHeader, this.getColumnAlignment(), rstList);
        }
        catch (SanServiceException e) {
            this._Log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    class VpcComparator
    implements Comparator<VpcDO> {
        String sortField = null;
        String sortType = null;

        public VpcComparator(String sortField, String sortType) {
            if (sortField == null || sortField.length() == 0) {
                sortField = "vpcid";
            }
            this.sortField = sortField;
            this.sortType = sortType;
        }

        @Override
        public int compare(VpcDO o1, VpcDO o2) {
            try {
                Field f = VpcDO.class.getField(this.sortField);
                Object obj1 = f.get(o1);
                Object obj2 = f.get(o2);
                if (this.sortType.equals("DESC")) {
                    if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                        if ((Integer)obj1 < (Integer)obj2) {
                            return 1;
                        }
                        if ((Integer)obj1 > (Integer)obj2) {
                            return -1;
                        }
                        return 0;
                    }
                    obj1 = obj1 == null ? "" : obj1;
                    obj2 = obj2 == null ? "" : obj2;
                    return obj2.toString().compareTo(obj1.toString());
                }
                if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                    if ((Integer)obj1 > (Integer)obj2) {
                        return 1;
                    }
                    if ((Integer)obj1 < (Integer)obj2) {
                        return -1;
                    }
                    return 0;
                }
                obj1 = obj1 == null ? "" : obj1;
                obj2 = obj2 == null ? "" : obj2;
                return obj1.toString().compareTo(obj2.toString());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    class VpcFilter
    implements Predicate {
        String field = null;
        String value = null;

        public VpcFilter(String sortField, String value) {
            if (sortField == null || sortField.length() == 0) {
                sortField = "vpcid";
            }
            this.field = sortField;
            this.value = value;
        }

        public boolean evaluate(Object arg0) {
            if (arg0 == null || !(arg0 instanceof VpcDO)) {
                return false;
            }
            try {
                Field f = VpcDO.class.getField(this.field);
                VpcDO o1 = (VpcDO)arg0;
                Object obj1 = f.get(o1);
                if (obj1.toString().contains(this.value)) {
                    return true;
                }
            }
            catch (SecurityException e) {
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return false;
        }
    }

    class NameValue {
        public String key = null;
        public String vlu = null;

        public NameValue(String key, String vlu) {
            this.key = key;
            this.vlu = vlu;
        }
    }
}

