/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.zone;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.zm.ZoneMemberFormat;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ZoneService {
    public static Logger _Logger = LogManager.getLogger((String)"com.cisco.dcbu.sm.client.zm");

    public static ArrayList getAllEndPortsAndSetStatus(FabricBase fa, ZoneMemberBase zm, VsanBase zoneVsan) {
        ArrayList ports = new ArrayList();
        switch (zm.getType()) {
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                EndPortBase epp = ZoneService.getEndPortAndSetStatus(fa, zm, zoneVsan);
                if (epp == null) break;
                ports.add(epp);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList allports = ZoneService.getAttachedEndPorts(fa, zm, zoneVsan);
                if (allports == null) break;
                ports = allports;
            }
        }
        return ports;
    }

    public static StringBuffer getZoneMemberName(FabricPK fPK, VsanPK vPk, int format, byte[] id, byte[] lunId) {
        VsanImpl vsan = SanManager.getInstance().findVsan(vPk);
        if (vsan == null) {
            return null;
        }
        FabricImpl fa = vsan != null ? vsan.getFabric() : SanManager.getInstance().findFabric(fPK);
        StringBuffer sb = new StringBuffer();
        SnmpString memberId = new SnmpString(id);
        EndPortBase p = ZoneService.getEndPort(format, id, (VsanBase)vsan.getBaseObject(), fa.getFabricBase(null));
        switch (format) {
            case 1: 
            case 11: {
                if (8 != id.length) {
                    sb.append(memberId);
                    return sb;
                }
                Wwn memWwn = new Wwn(memberId);
                if (p != null) {
                    sb.append(p.getName());
                    break;
                }
                FcPortAlias da = fa.findDeviceAliasByWwn(memWwn);
                sb.append(da != null ? da.getAlias() : WwnDictionary.getWwnAlias(id));
                break;
            }
            case 3: 
            case 12: {
                if (p != null) {
                    sb.append(p.getName());
                    break;
                }
                sb.append(SnmpFcAddressId.toHexString(id));
                break;
            }
            case 4: 
            case 6: {
                Object[] ifMemberData = ZoneMemberFormat.getSwitchPort(format, id);
                int interFaceIndex = ((int[])ifMemberData[0])[0];
                byte[] swwN = (byte[])ifMemberData[1];
                SwitchImpl swImpl = SanManager.getInstance().findSwitch(new Wwn(swwN), fa.getPK());
                sb.append(swImpl != null ? swImpl.ifIndexToName(interFaceIndex) + " " + swImpl : (format == 4 ? SnmpString.toHexString(id) : IfIndexUtil.ifIndexToName(interFaceIndex)));
                break;
            }
            case 2: 
            case 7: {
                SwitchImpl swImpl;
                Object[] ifMemberData = ZoneMemberFormat.getSwitchPort(format, id);
                int interFaceIndex = ((int[])ifMemberData[0])[0];
                int did = ((byte[])ifMemberData[1])[0] & 0xFF;
                SwitchImpl switchImpl = swImpl = vsan != null ? vsan.findSwitchByDomainId(did) : null;
                sb.append(swImpl != null ? (format == 4 ? swImpl.getBase().ifWwn2IfName(id, IfIndexIf.FwwnInfo.Config) : IfIndexUtil.ifIndexToName(interFaceIndex)) + " " + swImpl : SnmpString.toHexString(id));
                break;
            }
            case 5: {
                if (p != null) {
                    sb.append(p.getSymNodeName());
                    break;
                }
                sb.append(memberId.toString());
                break;
            }
            case 8: 
            case 9: {
                int prefix;
                byte[][] addMsk = ZoneMemberFormat.getIpAddressMask(id);
                byte[] address = addMsk[0];
                sb.append(SnmpIpAddress.toString(address));
                if (addMsk[1] == null) break;
                byte[] mask = addMsk[1];
                int n = prefix = address.length == 16 ? SnmpIntList.bytesToInt(mask, 0) : 0;
                sb.append(address.length == 16 ? (prefix < 128 ? "/" + Integer.toString(prefix) : "") : "/" + SnmpIpAddress.toString(mask));
                break;
            }
            case 10: {
                sb.append(memberId);
            }
        }
        if (null != lunId && lunId.length > 0) {
            sb.append(", LUN " + MibVariableFormat.ciscoExtScsiIntrDiscLunNumber(new SnmpString(lunId)));
        }
        return sb;
    }

    public static ArrayList getAllEndPorts(FabricBase fa, ZoneMemberBase zm, VsanBase zoneVsan, boolean setStatus) {
        ArrayList ports = new ArrayList();
        switch (zm.getType()) {
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                EndPortBase epp;
                EndPortBase endPortBase = epp = setStatus ? ZoneService.getEndPortAndSetStatus(fa, zm, zoneVsan) : ZoneService.getEndPort(zm.getType(), zm.getId(), zoneVsan, fa);
                if (epp == null) break;
                ports.add(epp);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList allports = ZoneService.getAttachedEndPorts(fa, zm, zoneVsan);
                if (allports == null) break;
                ports = allports;
            }
        }
        return ports;
    }

    public static EndPortBase getEndPortAndSetStatus(FabricBase fa, ZoneMemberBase zm, VsanBase zoneVsan) {
        EndPortBase ep = null;
        FabricImpl faImpl = SanManager.getInstance().findFabric(fa.getPK());
        if (faImpl == null) {
            return ep;
        }
        int type = zm.getType();
        byte[] id = zm.getId();
        if (type == 1 || type == 11) {
            EndPortImpl epImpl = SanManager.getInstance().findEndPort(new Wwn(id), fa.getPK());
            ep = epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
        } else if (type == 5) {
            VsanImpl vImpl;
            if (zoneVsan != null && (vImpl = SanManager.getInstance().findVsan(zoneVsan.getVsanPK())) != null) {
                EndPortImpl epImpl = vImpl.findIscsiEndport(new String(id));
                ep = epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
            }
        } else if (type == 10) {
            FcPortAlias da = faImpl.findDeviceAliasByName(new String(id));
            if (da != null) {
                EndPortImpl epImpl = SanManager.getInstance().findEndPort(da.getWwn(), fa.getPK());
                ep = epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
            }
        } else if (type == 12 || type == 3) {
            VsanImpl vImpl;
            if (zoneVsan != null && (vImpl = SanManager.getInstance().findVsan(zoneVsan.getVsanPK())) != null) {
                EndPortImpl epImpl = vImpl.findEndPort(id);
                ep = epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
            }
        } else {
            zm.setPortStatus((byte)0);
            return ep;
        }
        if (ep != null) {
            zm.setPortStatus((byte)(zoneVsan != null && (!ep.isMemberOfVsan(zoneVsan.getId()) || !ep.getVsanPK((int)zoneVsan.getId())._prinSwwn.equals(zoneVsan.getVsanPK()._prinSwwn)) ? 2 : (!ep.isPresent() ? 3 : 0)));
        } else {
            zm.setPortStatus((byte)1);
        }
        return ep;
    }

    public static EndPortBase getEndPort(int type, byte[] id, VsanBase vsan, FabricBase fa) {
        if (vsan == null && fa == null) {
            return null;
        }
        switch (type) {
            case 1: 
            case 11: {
                EndPortBase ep;
                if (vsan == null) {
                    EndPortImpl epImpl = SanManager.getInstance().findEndPort(new Wwn(id), fa.getPK());
                    return epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
                }
                EndPortImpl epImpl = SanManager.getInstance().findEndPort(new Wwn(id), fa.getPK());
                EndPortBase endPortBase = ep = epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
                if (ep == null || !ep.isMemberOfVsan(vsan.getId())) break;
                return ep;
            }
            case 10: {
                EndPortBase ep;
                FabricImpl faImpl;
                FcPortAlias da;
                if (fa == null || (da = (faImpl = SanManager.getInstance().findFabric(fa.getPK())).findDeviceAliasByName(new String(id))) == null) break;
                EndPortImpl epImpl = SanManager.getInstance().findEndPort(da.getWwn(), fa.getPK());
                EndPortBase endPortBase = ep = epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
                if (ep != null && vsan != null && !ep.isMemberOfVsan(vsan.getId())) break;
                return ep;
            }
            case 3: 
            case 12: {
                VsanImpl vImpl;
                if (vsan == null || (vImpl = SanManager.getInstance().findVsan(vsan.getVsanPK())) == null) break;
                EndPortImpl epImpl = vImpl.findEndPort(id);
                return epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
            }
            case 5: {
                VsanImpl vImpl;
                if (vsan == null || (vImpl = SanManager.getInstance().findVsan(vsan.getVsanPK())) == null) break;
                EndPortImpl epImpl = vImpl.findIscsiEndport(new String(id));
                return epImpl != null ? (EndPortBase)epImpl.getBaseObject() : null;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList attPorts = ZoneService.getAttachedEndPorts(fa, type, id, vsan);
                if (attPorts == null || attPorts.size() <= 0) break;
                return (EndPortBase)attPorts.get(0);
            }
        }
        return null;
    }

    private static ArrayList getAttachedEndPorts(FabricBase fa, ZoneMemberBase zb, VsanBase vs) {
        int type = zb.getType();
        if (type == 4 || type == 6 || type == 7 || type == 2 || type == 8 || type == 9) {
            ArrayList<EndPortBase> ports = null;
            zb.setPortStatus((byte)0);
            if (type == 8 || type == 9) {
                ArrayList allPorts = ZoneService.getPortIpAttachedPorts(zb.getId(), vs, false);
                if (allPorts == null || allPorts.size() == 0) {
                    zb.setPortStatus((byte)1);
                } else {
                    ports = new ArrayList<EndPortBase>();
                    for (int k = 0; k < allPorts.size(); ++k) {
                        EndPortBase ep = (EndPortBase)allPorts.get(k);
                        if (!ep.isMemberOfVsan(vs.getId())) continue;
                        ports.add(ep);
                    }
                    if (ports.size() == 0) {
                        zb.setPortStatus((byte)2);
                    }
                }
            } else {
                ports = ZoneService.getAttachedEndPorts(fa, type, zb.getId(), vs);
                if (ports == null || ports.size() == 0) {
                    zb.setPortStatus((byte)4);
                }
            }
            return ports;
        }
        return null;
    }

    public static ArrayList getAttachedEndPorts(FabricBase fa, int type, byte[] id, VsanBase vsan) {
        FabricImpl faImpl = fa != null ? SanManager.getInstance().findFabric(fa.getPK()) : null;
        VsanImpl vImpl = null;
        if (vsan != null && (vImpl = SanManager.getInstance().findVsan(vsan.getVsanPK())) != null) {
            faImpl = vImpl.getFabric();
        }
        ArrayList ports = null;
        switch (type) {
            case 4: {
                SwitchImpl swImpl;
                SwitchImpl switchImpl = swImpl = fa != null ? SanManager.getInstance().findSwitch(new Wwn(IfIndexUtil.ifWwn2SwWwn(id)), fa.getPK()) : null;
                if (swImpl == null) break;
                ports = ZoneService.getEndPortBaseFromImpl(swImpl.getFabric().findEndPortsBySwitchIfIndex(swImpl, ((SwitchBase)swImpl.getBaseObject()).ifWwn2IfIndex(id, IfIndexIf.FwwnInfo.Config)));
                break;
            }
            case 6: {
                int swIfIndex = ZoneMemberFormat.getIfFormatIfIndex(id, 0);
                byte[] swWwn = ZoneMemberFormat.getIfFormatSwitchWwn(id);
                SwitchImpl swi = null;
                if (null != swWwn && faImpl != null) {
                    swi = SanManager.getInstance().findSwitch(new Wwn(swWwn), faImpl.getPK());
                }
                if (null == swi) break;
                ports = ZoneService.getEndPortBaseFromImpl(swi.getFabric().findEndPortsBySwitchIfIndex(swi, swIfIndex));
                break;
            }
            case 2: 
            case 7: {
                int ifIndex;
                if (type == 2 && id.length != 6) break;
                SwitchImpl sw = null;
                if (vImpl != null) {
                    sw = vImpl.findSwitchByDomainId(0xFF & id[0]);
                }
                int n = ifIndex = type == 7 ? ZoneMemberFormat.getIfFormatIfIndex(id, 1) : 0xFF & id[1];
                if (null == sw) break;
                ports = ZoneService.getEndPortBaseFromImpl(sw.getFabric().findEndPortsBySwitchIfIndex(sw, ifIndex));
                break;
            }
            case 8: 
            case 9: {
                ports = ZoneService.getPortIpAttachedPorts(id, vsan, true);
            }
        }
        return ports;
    }

    private static ArrayList getEndPortBaseFromImpl(ArrayList epImpls) {
        ArrayList<BaseModelObject> ports = new ArrayList<BaseModelObject>();
        if (epImpls != null && epImpls.size() > 0) {
            ports = new ArrayList();
            for (int p = 0; p < epImpls.size(); ++p) {
                ports.add(((EndPortImpl)epImpls.get(p)).getBaseObject());
            }
        }
        return ports;
    }

    private static ArrayList getPortIpAttachedPorts(byte[] id, VsanBase vsan, boolean filterByVsan) {
        ArrayList<BaseModelObject> ports = new ArrayList<BaseModelObject>();
        if (vsan == null) {
            return ports;
        }
        byte[][] addMsk = ZoneMemberFormat.getIpAddressMask(id);
        byte[] subnet = ZoneMemberFormat.getSubnet(addMsk);
        byte[] mask = addMsk[1];
        if (mask != null && mask.length > 0) {
            for (int i = 0; i < mask.length; ++i) {
                subnet[i] = (byte)(subnet[i] & mask[i] & 0xFF);
            }
        }
        FabricImpl faImpl = null;
        VsanImpl vImpl = SanManager.getInstance().findVsan(vsan.getVsanPK());
        if (vImpl != null) {
            faImpl = vImpl.getFabric();
        }
        if (vImpl == null || faImpl == null) {
            return ports;
        }
        EndPortImpl[] endPorts = vImpl.getFabric().getEndPorts();
        if (endPorts != null) {
            for (int i = 0; i < endPorts.length; ++i) {
                String address;
                if (!endPorts[i].isISCSI() || filterByVsan && !endPorts[i].isMemberOfVsan(vImpl.getId()) || (address = endPorts[i].getNodeIpAddress()) == null || address.length() <= 0) continue;
                byte[] addInBytes = null;
                try {
                    addInBytes = SnmpIpAddress.parse(address);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (addInBytes == null) {
                    _Logger.info((Object)("Zones - Invalid ip address:" + address));
                    continue;
                }
                if (mask == null) {
                    if (!SnmpIpAddress.equals(subnet, addInBytes)) continue;
                    ports.add(endPorts[i].getBaseObject());
                    break;
                }
                if (!NetUtil.memberofSubnet(addInBytes, subnet, mask)) continue;
                ports.add(endPorts[i].getBaseObject());
            }
        }
        if (ports.size() == 0) {
            return null;
        }
        return ports;
    }

    public static Wwn findWWNforDeviceAlias(String devAliasName, FabricBase fa) {
        if (fa == null) {
            return null;
        }
        Collection<FcPortAlias> cc = fa.getDeviceAliases();
        for (FcPortAlias da : cc) {
            if (!devAliasName.equals(da.getAlias())) continue;
            return da.getWwn();
        }
        return null;
    }

    public static String getInfo(ZoneMemberBase zB) {
        switch (zB.getPortStatus()) {
            case 1: {
                return "Not in Fabric";
            }
            case 2: {
                return "Not in VSAN";
            }
            case 3: {
                return "Link Down";
            }
            case 4: {
                return "n/a";
            }
        }
        return "";
    }

    public static boolean areMultipleCFSIvrZonesetsPresent(int fId) {
        FabricImpl fImpl;
        FabricPK fPk = new FabricPK(fId);
        FabricImpl fabricImpl = fImpl = fPk != null ? SanManager.getInstance().findFabric(fPk) : null;
        if (fImpl != null) {
            return fImpl.getIvrEnforcedZoneNum() > 1;
        }
        return false;
    }

    public static ArrayList getZonesFromServer(int fId, String vsanPKString, StringBuffer unmonitored) throws Exception {
        FabricImpl fImpl;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        VsanPK[] vPk = ReportAnalysis.getVsanPK(vsanPKString);
        FabricPK fPk = new FabricPK(fId);
        FabricImpl fabricImpl = fImpl = fPk != null ? SanManager.getInstance().findFabric(fPk) : null;
        if (vPk != null && vPk.length == 1) {
            VsanImpl vImpl = SanManager.getInstance().findVsan(vPk[0]);
            if (vImpl != null) {
                ArrayList<Object[]> vsanList = new ArrayList<Object[]>();
                Object[] zoneData = ZoneService.buildZoneInformation(fImpl, vImpl, unmonitored);
                if (zoneData != null) {
                    vsanList.add(zoneData);
                    list.add(new Object[]{vImpl.getFabric().toString().getBytes(), vsanList});
                }
            } else {
                _Logger.info((Object)("Vsan with ID " + vsanPKString + " may not be monitored."));
                unmonitored.append("Vsan with ID " + vsanPKString + " may not be monitored./n");
            }
        } else if (fImpl != null) {
            Object[] vImpl = fImpl.getVsans();
            if (vImpl != null && vImpl.length > 0) {
                Arrays.sort(vImpl);
                ArrayList<Object[]> vsanList = new ArrayList<Object[]>();
                for (int k = 0; k < vImpl.length; ++k) {
                    Object[] zoneData = ZoneService.buildZoneInformation(fImpl, (VsanImpl)vImpl[k], unmonitored);
                    if (zoneData == null) continue;
                    vsanList.add(zoneData);
                }
                Object[] zoneData = ZoneService.buildZoneInformation(fImpl, null, unmonitored);
                if (zoneData != null) {
                    vsanList.add(zoneData);
                }
                list.add(new Object[]{fImpl.toString().getBytes(), vsanList});
            } else {
                _Logger.info((Object)("Fabric with ID " + fId + " may not be monitored."));
                unmonitored.append("Fabric with ID " + fId + " may not be monitored./n");
            }
        } else {
            FabricImpl[] fImpls = SanManager.getInstance().getFabrics();
            if (fImpls != null && fImpls.length > 0) {
                for (int f = 0; f < fImpls.length; ++f) {
                    Object[] zoneData;
                    Object[] vImpl = fImpls[f].getVsans();
                    if (vImpl == null || vImpl.length == 0) {
                        _Logger.info((Object)("Fabric  " + fImpls[f] + " may not be monitored."));
                        unmonitored.append("Fabric with ID " + fImpls[f] + " may not be monitored./n");
                        continue;
                    }
                    Arrays.sort(vImpl);
                    ArrayList<Object[]> vsanList = new ArrayList<Object[]>();
                    if (vImpl != null && vImpl.length > 0) {
                        for (int k = 0; k < vImpl.length; ++k) {
                            Object[] zoneData2 = ZoneService.buildZoneInformation(fImpls[f], (VsanImpl)vImpl[k], unmonitored);
                            if (zoneData2 == null) continue;
                            vsanList.add(zoneData2);
                        }
                    }
                    if ((zoneData = ZoneService.buildZoneInformation(fImpls[f], null, unmonitored)) != null) {
                        vsanList.add(zoneData);
                    }
                    list.add(new Object[]{fImpls[f].toString().getBytes(), vsanList});
                }
            }
        }
        return list;
    }

    public static Object[] buildDetailedZoneInformation(VsanImpl vv, ZoneMemberBase zmem, EndPortBase ep) {
        int vsanID;
        VsanImpl ivrVsan;
        byte[][] data = new byte[6][];
        SwitchImpl swImpl = ep != null ? SanManager.getInstance().findSwitch(ep.getSwitchPK(), ep.getFabricPK()) : null;
        VsanImpl vsanImpl = ivrVsan = swImpl != null ? swImpl.getVsan(zmem.getIvrVsanId()) : null;
        String vsanName = vv == null ? (ivrVsan != null ? ivrVsan.getName() : "VSAN" + zmem.getIvrVsanId()) : vv.getName();
        data[0] = vsanName.getBytes();
        data[1] = zmem.getTypeName().getBytes();
        data[2] = zmem.getName(ep).getBytes();
        Object object = ep != null ? ep.getEndPortPK()._wwn.toString().getBytes() : (data[3] = (Object)(zmem.getType() == 1 || zmem.getType() == 11 ? SnmpString.toHexString(zmem.getId()).getBytes() : null));
        int n = vv != null ? vv.getId() : (vsanID = ivrVsan != null ? (int)ivrVsan.getId() : -1);
        data[4] = ep != null && vsanID != -1 ? EndPortBase.getFcIdAsString(ep.getFcId(vsanID)).getBytes() : null;
        data[5] = ep != null ? (swImpl.getName() + " " + ep.getIfName()).getBytes() : null;
        return data;
    }

    public static Object[] buildZoneInformation(FabricImpl fImpl, VsanImpl vImpl, StringBuffer unmonitored) {
        VsanBase vBase;
        String zoneSetName;
        FabricBase fb;
        ArrayList data = new ArrayList();
        FabricBase fabricBase = fb = fImpl != null ? fImpl.getFabricBase(null) : null;
        if (fImpl != null && fb == null) {
            _Logger.info((Object)("Fabric " + fImpl + " may not be monitored."));
            unmonitored.append("Fabric " + fImpl + " may not be monitored.");
            return null;
        }
        String string = vImpl != null ? vImpl.getEnforcedZoneSetName() : (zoneSetName = fb != null ? fb.getIvrEnforcedZoneSetName() : null);
        Object[] zz = vImpl != null ? vImpl.getEnforcedZones() : (fb != null ? fb.getIvrEnforcedZones() : null);
        FabricBase fbb = vImpl != null ? vImpl.getFabric().getFabricBase(null) : fb;
        VsanBase vsanBase = vBase = vImpl != null ? (VsanBase)vImpl.getBaseObject() : null;
        if (zz != null) {
            Arrays.sort(zz);
            ArrayList<Object[]> outData = new ArrayList<Object[]>();
            for (int z = 0; z < zz.length; ++z) {
                ArrayList<Object[]> memEpData = new ArrayList<Object[]>();
                Array members = ((ZoneBase)zz[z]).getMembers();
                for (int m = 0; m < members.size(); ++m) {
                    ZoneMemberBase zmem = (ZoneMemberBase)members.elementAt(m);
                    if (zmem.getType() == 4 || zmem.getType() == 6 || zmem.getType() == 7 || zmem.getType() == 2 || zmem.getType() == 8 || zmem.getType() == 9) {
                        ArrayList ports = ZoneService.getAttachedEndPorts(fbb, zmem.getType(), zmem.getId(), vBase);
                        if (ports == null || ports.size() <= 0) continue;
                        for (int k = 0; k < ports.size(); ++k) {
                            EndPortBase ep = (EndPortBase)ports.get(k);
                            memEpData.add(ZoneService.buildDetailedZoneInformation(vImpl, zmem, ep));
                        }
                        continue;
                    }
                    EndPortBase eBase = ZoneService.getEndPort(zmem.getType(), zmem.getId(), vBase, fbb);
                    memEpData.add(ZoneService.buildDetailedZoneInformation(vImpl, zmem, eBase));
                }
                outData.add(new Object[]{((ZoneBase)zz[z]).getName().getBytes(), memEpData});
            }
            if (zoneSetName != null) {
                return new Object[]{vImpl != null ? vImpl.getName().getBytes() : null, zoneSetName.getBytes(), outData};
            }
        }
        return null;
    }
}

