/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.vi.discover;

import com.cisco.dcbu.lib.util.SyncedBoolean;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.model.DataStoreImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.vi.discover.AbstractVmWareWorker;
import com.cisco.dcbu.vi.discover.VCenterWorker;
import com.cisco.dcbu.vi.discover.WorkerCallbackIf;
import com.cisco.dcbu.vi.model.GuestNic;
import com.cisco.dcbu.vi.model.HostSystem;
import com.cisco.dcbu.vi.model.PhyNic;
import com.cisco.dcbu.vi.model.ViManager;
import com.vmware.vim25.DatastoreInfo;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.GuestNicInfo;
import com.vmware.vim25.HostFibreChannelHba;
import com.vmware.vim25.HostFibreChannelTargetTransport;
import com.vmware.vim25.HostFileSystemMountInfo;
import com.vmware.vim25.HostFileSystemVolume;
import com.vmware.vim25.HostFileSystemVolumeInfo;
import com.vmware.vim25.HostHostBusAdapter;
import com.vmware.vim25.HostInternetScsiHba;
import com.vmware.vim25.HostIpConfig;
import com.vmware.vim25.HostMountInfo;
import com.vmware.vim25.HostMultipathInfo;
import com.vmware.vim25.HostMultipathInfoLogicalUnit;
import com.vmware.vim25.HostMultipathInfoLogicalUnitPolicy;
import com.vmware.vim25.HostMultipathInfoPath;
import com.vmware.vim25.HostNetworkInfo;
import com.vmware.vim25.HostPortGroup;
import com.vmware.vim25.HostPortGroupPort;
import com.vmware.vim25.HostScsiDiskPartition;
import com.vmware.vim25.HostScsiTopology;
import com.vmware.vim25.HostScsiTopologyInterface;
import com.vmware.vim25.HostScsiTopologyLun;
import com.vmware.vim25.HostScsiTopologyTarget;
import com.vmware.vim25.HostStorageDeviceInfo;
import com.vmware.vim25.HostTargetTransport;
import com.vmware.vim25.HostVirtualNic;
import com.vmware.vim25.HostVirtualNicSpec;
import com.vmware.vim25.HostVirtualSwitch;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PhysicalNic;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.ScsiLun;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualDiskRawDiskMappingVer1BackingInfo;
import com.vmware.vim25.VirtualEthernetCard;
import com.vmware.vim25.VirtualEthernetCardDistributedVirtualPortBackingInfo;
import com.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineConfigSummary;
import com.vmware.vim25.VmfsDatastoreInfo;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostNetworkSystem;
import com.vmware.vim25.mo.HostStorageSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.Network;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class VHostWorker
extends AbstractVmWareWorker {
    static final int DISC_ALL = 65535;
    private int _discFlags = 65535;
    private com.vmware.vim25.mo.HostSystem _host;
    private VirtualCenterImpl _vc;
    private SyncedBoolean _isDiscovering = new SyncedBoolean(false);
    static Logger _logger = LogManager.getLogger((String)"fms.disc");
    private ServiceInstance _si = null;

    public VHostWorker(com.vmware.vim25.mo.HostSystem host, VirtualCenterImpl vc, WorkerCallbackIf observer) {
        this._host = host;
        this._vc = vc;
        this._observer = observer;
        VCenterWorker vcWorker = this._vc == null ? null : this._vc.getWorker();
        this._si = vcWorker == null ? null : vcWorker.getServiceInstance();
    }

    @Override
    protected void exec() throws DiscoveryException {
        if (this._status.get() == 1) {
            long time = _Log.isDebugEnabled() ? System.currentTimeMillis() : 0L;
            this.startDiscovery();
            if (_Log.isDebugEnabled()) {
                _Log.debug((Object)(this + ": " + " done in " + (System.currentTimeMillis() - time) + " ms"));
            }
        } else if (this._status.get() == 2) {
            _Log.warn((Object)(this + ": " + " interrupted abruptly"));
            return;
        }
        this.sendUpdate(null);
    }

    public String toString() {
        return this._host.getName() + "-VHostWorker";
    }

    public void startDiscovery() {
        try {
            VirtualMachine[] vmList;
            VCenterWorker vcWorker;
            String moRef = this._host.getMOR() == null ? null : this._host.getMOR().getVal();
            String fullName = this._host.getName();
            _logger.debug((Object)("*******start host discovery****:" + moRef + ":" + fullName));
            if (fullName == null) {
                return;
            }
            VCenterWorker vCenterWorker = vcWorker = this._vc == null ? null : this._vc.getWorker();
            if (vcWorker == null) {
                _logger.warn((Object)("vCenter worker is null for data center worker " + this));
                return;
            }
            int jj = 0;
            Collection<NameKey> preVHostPKs = vcWorker.getPreVHostPKs();
            String name = null;
            try {
                String ipaddress = null;
                InetAddress inet = InetAddress.getByName(fullName);
                name = inet.getCanonicalHostName();
                ipaddress = inet.getHostAddress();
                if (ipaddress.equals(name) && (name = inet.getHostName()) == null) {
                    name = ipaddress;
                }
                if (!ipaddress.equals(name)) {
                    fullName = name;
                    int index = name.indexOf(46);
                    name = index > 0 ? name.substring(0, name.indexOf(46)).toUpperCase() : name.toUpperCase();
                }
            }
            catch (Exception ex) {
                _logger.debug((Object)("couldn't resolve InetAddress for vHost " + fullName + ":" + ex));
                int index = fullName.indexOf(46);
                name = index > 0 ? fullName.substring(0, index).toUpperCase() : fullName.toUpperCase();
            }
            int powerState = -1;
            int connState = 0;
            ArrayList<String> ipAddressList = new ArrayList<String>();
            ArrayList<String> macAddressList = new ArrayList<String>();
            HostNetworkSystem hns = null;
            PhysicalNic[] pNics = null;
            try {
                HostVirtualNic[] vnics;
                String mac;
                hns = this._host.getHostNetworkSystem();
                HostVirtualNic[] hnic = hns.getNetworkInfo() == null ? null : hns.getNetworkInfo().getConsoleVnic();
                HostNetworkInfo hninfo = hns.getNetworkInfo();
                pNics = hninfo.getPnic();
                String ipAddress = null;
                if (hnic != null) {
                    for (HostVirtualNic nic : hnic) {
                        HostVirtualNicSpec spec = nic.getSpec();
                        HostIpConfig ipConfig = spec.getIp();
                        if (ipAddress != null) continue;
                        ipAddress = ipConfig.getIpAddress();
                        mac = spec.getMac();
                        _logger.debug((Object)("mac: " + mac + ", ip: " + ipAddress));
                        macAddressList.add(mac);
                        ipAddressList.add(ipAddress);
                    }
                } else if (hninfo != null && (vnics = hninfo.getVnic()) != null) {
                    for (HostVirtualNic vnic : vnics) {
                        HostVirtualNicSpec spec = vnic.getSpec();
                        if (spec.getIp() != null) {
                            ipAddress = spec.getIp().getIpAddress();
                        }
                        mac = spec.getMac();
                        _logger.debug((Object)("mac: " + mac + ", ip: " + ipAddress));
                        macAddressList.add(mac);
                        ipAddressList.add(ipAddress);
                    }
                }
                if (name == null && ipAddressList.size() > 0) {
                    name = (String)ipAddressList.get(0);
                }
            }
            catch (Exception e) {
                _logger.debug((Object)("getHostNetworkSystem failed for host " + moRef + ":" + fullName));
            }
            long memorySize = -1L;
            short cpuCount = -1;
            long cpuSpeedAvg = -1L;
            String model = null;
            String vendor = null;
            String osType = null;
            String version = null;
            long[] nwwns = this.getNodeWwns(this._host);
            long[] pwwns = this.getPortWwns(this._host);
            VHostImpl vhost = this._vc.createHost(nwwns, pwwns, osType, vendor, model, version, memorySize, cpuCount, cpuSpeedAvg, name, fullName, powerState, connState, macAddressList, ipAddressList, moRef, this._vc);
            List<String> iscsiNames = this.getIscsciNames(this._host);
            vhost.setIscsiNames(iscsiNames);
            preVHostPKs.remove((NameKey)vhost.getPK());
            if (pNics != null) {
                PhyNic[] pnics = new PhyNic[pNics.length];
                for (int i = 0; i < pNics.length; ++i) {
                    pnics[i] = new PhyNic(pNics[i].getKey(), pNics[i].getDevice(), pNics[i].getMac());
                }
                vhost.createPhyNics(pnics);
            }
            if (vhost.getDBID() == 0L) {
                InventoryPersistentManager.getInstance().persistDBObject(vhost);
            }
            vhost.createLanHosts(hns);
            HostSystem hs = vhost == null ? null : (HostSystem)vhost.getBaseObject();
            try {
                HostStorageSystem hds = this._host.getHostStorageSystem();
                _logger.debug((Object)"Supported file system volume types:");
                _logger.debug((Object)("Start Storage device information for :" + moRef + ":" + fullName));
                HostStorageDeviceInfo hsdi = hds.getStorageDeviceInfo();
                this.printStorageDeviceInfo(hsdi, hs);
            }
            catch (Exception e) {
                _logger.debug((Object)("getHostStorageSystem failed for host " + moRef + ":" + fullName));
            }
            _logger.debug((Object)("End Storage device information for :" + moRef + ":" + fullName));
            Set<NameKey> preVmPKs = vhost.getAllVmPKs();
            for (VirtualMachine vm : vmList = this._host.getVms()) {
                String moRef1;
                this.createVm(vm, vhost, hs.getId());
                String string = moRef1 = vm.getMOR() == null ? null : vm.getMOR().getVal();
                if (moRef1 == null) continue;
                preVmPKs.remove(new NameKey(moRef1));
            }
            for (NameKey vmPK : preVmPKs) {
                vhost.removeVm(vmPK);
            }
            _logger.debug((Object)("*******done host****:" + jj + ":" + moRef + ":" + fullName));
        }
        catch (Exception e) {
            _logger.error((Object)("process host " + this._host + " error "), (Throwable)e);
        }
    }

    private void createVm(VirtualMachine vm, VHostImpl vhost, long hostId) {
        String guestFullName = null;
        try {
            VmImpl vmImpl;
            String moRef = vm.getMOR() == null ? null : vm.getMOR().getVal();
            long memorySize1 = -1L;
            int cpuCount1 = -1;
            String ipAddr = null;
            VirtualMachineConfigInfo vmConfig = vm.getConfig();
            VirtualDevice[] vDevices = vmConfig.getHardware().getDevice();
            int powerState = -1;
            String vmName = vm.getName();
            if (vmName == null || moRef == null) {
                _logger.warn((Object)("vmName = " + vmName + ",moRef = " + moRef));
                return;
            }
            String fullName = vmName;
            if (vmName.indexOf(".") > 0) {
                vmName = vmName.substring(0, vmName.indexOf("."));
            }
            HostNetworkSystem hns = this._host.getHostNetworkSystem();
            HostNetworkInfo hninfo = hns.getNetworkInfo();
            if (vm.getGuest() != null) {
                ipAddr = vm.getGuest().ipAddress;
            }
            vmImpl = (vmImpl = vhost.findVmByName(moRef)) == null ? vhost.createVm(vmName, fullName, moRef, memorySize1, cpuCount1, hostId, guestFullName, ipAddr, powerState) : vhost.updateVm(vmName, fullName, moRef, memorySize1, cpuCount1, hostId, guestFullName, ipAddr, powerState);
            GuestNic[] vnics = this.getVnics(vm, hninfo);
            GuestNic[] guestNics = this.getGuestNics(vm);
            this.mapGuestNic2Vnic(guestNics, vnics);
            vmImpl.createVNics(vnics);
            PhyNic[] pnics = this.getPhysicalNics(vm, hninfo);
            vmImpl.setPnic(pnics);
            long lastUpdateTime = System.currentTimeMillis();
            vmImpl.setLastUpdateTime(lastUpdateTime);
            for (int i = 0; vDevices != null && i < vDevices.length; ++i) {
                VirtualDeviceBackingInfo vBackingInfo;
                if (vDevices[i] == null || !(vDevices[i] instanceof VirtualDisk) || (vBackingInfo = ((VirtualDisk)vDevices[i]).getBacking()) == null) continue;
                String uuid = null;
                Datastore dstore = null;
                if (vBackingInfo instanceof VirtualDiskRawDiskMappingVer1BackingInfo) {
                    VirtualDiskRawDiskMappingVer1BackingInfo vRawBackingInfo = (VirtualDiskRawDiskMappingVer1BackingInfo)vBackingInfo;
                    uuid = vRawBackingInfo.getUuid();
                    dstore = (Datastore)MorUtil.createExactManagedObject((ServerConnection)this._si.getServerConnection(), (ManagedObjectReference)vRawBackingInfo.getDatastore());
                } else if (vBackingInfo instanceof VirtualDiskFlatVer2BackingInfo) {
                    VirtualDiskFlatVer2BackingInfo vFlatBackingInfo = (VirtualDiskFlatVer2BackingInfo)vBackingInfo;
                    uuid = vFlatBackingInfo.getUuid();
                    dstore = (Datastore)MorUtil.createExactManagedObject((ServerConnection)this._si.getServerConnection(), (ManagedObjectReference)vFlatBackingInfo.getDatastore());
                } else {
                    _logger.debug((Object)("unhandled virtualdisk type, type  is " + vBackingInfo.getClass()));
                }
                if (dstore == null) continue;
                try {
                    DatastoreSummary summary = dstore.getSummary();
                    DatastoreInfo dInfo = dstore.getInfo();
                    if (dInfo instanceof VmfsDatastoreInfo) {
                        VmfsDatastoreInfo info = (VmfsDatastoreInfo)dInfo;
                        _logger.debug((Object)("datastore url is " + summary.getUrl()));
                        HostScsiDiskPartition[] par = info.getVmfs().getExtent();
                        if (par == null) continue;
                        for (int j = 0; j < par.length; ++j) {
                            _logger.debug((Object)("disk name is " + par[j].getDiskName()));
                            if (par[j].getDiskName() == null) continue;
                            DataStoreImpl dStore = this._vc.findDataStoreByName(par[j].getDiskName());
                            if (dStore != null) {
                                dStore.setUrl(summary.getUrl());
                                dStore.addVm(vmImpl);
                                dStore.setName(summary.getName());
                                vmImpl.setDataStore(dStore);
                                continue;
                            }
                            _logger.debug((Object)("could not find datastore for disk name " + par[j].getDiskName()));
                        }
                        continue;
                    }
                    if (dInfo == null) continue;
                    _logger.debug((Object)("unhandled datastoreInfo, type  is " + dInfo.getClass()));
                    continue;
                }
                catch (Exception ex) {
                    _logger.warn((Object)("Failed to get DataStore. " + ex.getMessage()));
                }
            }
        }
        catch (NullPointerException npe) {
            _logger.debug((Object)("createVm failed for " + guestFullName + " of VHost " + vhost), (Throwable)npe);
        }
        catch (Exception e) {
            _logger.warn((Object)("createVm failed for " + guestFullName + " of VHost " + vhost), (Throwable)e);
        }
    }

    private void mapGuestNic2Vnic(GuestNic[] guestNics, GuestNic[] vNics) {
        for (int i = 0; guestNics != null && i < guestNics.length; ++i) {
            for (int j = 0; vNics != null && j < vNics.length; ++j) {
                if (!vNics[j].getMacAddress().equals(guestNics[i].getMacAddress())) continue;
                vNics[j].setIpAddress(guestNics[i].getIpAddress());
                vNics[j].setNetwork(guestNics[i].getNetwork());
            }
        }
    }

    private GuestNic[] getGuestNics(VirtualMachine vm) {
        GuestNicInfo[] guestNics;
        GuestNicInfo[] guestNicInfoArray = guestNics = vm.getGuest() == null ? null : vm.getGuest().getNet();
        if (guestNics == null || guestNics.length == 0) {
            _logger.debug((Object)("no guestNics found for VM " + vm.getName()));
            return null;
        }
        GuestNic[] vnic = new GuestNic[guestNics.length];
        for (int k = 0; k < guestNics.length; ++k) {
            if (guestNics[k] == null) continue;
            vnic[k] = new GuestNic(guestNics[k].getIpAddress(), guestNics[k].getMacAddress(), guestNics[k].getNetwork());
            _logger.debug((Object)(" guestNic is " + guestNics[k].getMacAddress() + ", VM is " + vm.getName()));
        }
        return vnic;
    }

    private GuestNic[] getVnics(VirtualMachine vm, HostNetworkInfo hninfo) {
        ArrayList<GuestNic> resultList = new ArrayList<GuestNic>();
        VirtualDevice[] vDevices = vm.getConfig().getHardware().getDevice();
        if (vDevices == null) {
            return null;
        }
        for (int i = 0; i < vDevices.length; ++i) {
            VirtualDevice currentDevice = vDevices[i];
            if (currentDevice == null || !(currentDevice instanceof VirtualEthernetCard)) continue;
            VirtualEthernetCard vEthCard = (VirtualEthernetCard)currentDevice;
            try {
                VirtualEthernetCardNetworkBackingInfo nicBacking;
                String portGroup = null;
                if (vEthCard.getBacking() instanceof VirtualEthernetCardNetworkBackingInfo) {
                    nicBacking = (VirtualEthernetCardNetworkBackingInfo)vEthCard.getBacking();
                    portGroup = nicBacking.getDeviceName();
                } else if (vEthCard.getBacking() instanceof VirtualEthernetCardDistributedVirtualPortBackingInfo) {
                    nicBacking = (VirtualEthernetCardDistributedVirtualPortBackingInfo)vEthCard.getBacking();
                    portGroup = this.getPortGroup(vEthCard.getMacAddress(), hninfo);
                } else {
                    _logger.debug((Object)("unsupported backingInfo: " + vEthCard.getBacking().getClass()));
                }
                resultList.add(new GuestNic(null, vEthCard.getMacAddress(), portGroup));
                _logger.debug((Object)(" vNic is " + vEthCard.getMacAddress() + ", VM is " + vm.getName()));
                continue;
            }
            catch (Exception e) {
                _logger.warn((Object)("caught exception " + e));
            }
        }
        return resultList.toArray(new GuestNic[resultList.size()]);
    }

    private PhyNic[] getPhysicalNics(VirtualMachine vm, HostNetworkInfo hninfo) {
        try {
            HostPortGroup[] prtGrps = hninfo.getPortgroup();
            PhysicalNic[] pNics = hninfo.getPnic();
            if (prtGrps == null || prtGrps.length == 0 || pNics == null || pNics.length == 0) {
                return null;
            }
            ArrayList<PhyNic> resultList = new ArrayList<PhyNic>();
            Network[] ntworks = vm.getNetworks();
            if (ntworks == null || ntworks.length == 0) {
                return null;
            }
            String prtGrpName = ntworks[0].getName();
            if (prtGrpName == null) {
                return null;
            }
            for (int i = 0; i < prtGrps.length; ++i) {
                int offset;
                String prtGrpKey = prtGrps[i].getKey();
                String pname = prtGrpKey.substring((offset = prtGrpKey.indexOf("PortGroup-")) + 10);
                if (pname == null || !pname.equals(prtGrpName)) continue;
                String vswitchName = prtGrps[i].getVswitch();
                HostVirtualSwitch[] sws = hninfo.getVswitch();
                for (int j = 0; sws != null && j < sws.length; ++j) {
                    if (!sws[j].key.equals(vswitchName)) continue;
                    String[] pnics = sws[j].getPnic();
                    for (int k = 0; k < pNics.length; ++k) {
                        for (int l = 0; pnics != null && l < pnics.length; ++l) {
                            if (!pNics[k].key.equals(pnics[l])) continue;
                            PhyNic nic = new PhyNic(pNics[k].getKey(), pNics[k].getDevice(), pNics[k].getMac());
                            resultList.add(nic);
                        }
                    }
                }
            }
            return resultList.toArray(new PhyNic[resultList.size()]);
        }
        catch (Exception e) {
            _logger.warn((Object)("getPhysicalNics failed for " + vm.getName()), (Throwable)e);
            return null;
        }
    }

    private String getPortGroup(String macAddr, HostNetworkInfo hninfo) {
        String portGroup = null;
        try {
            HostPortGroup[] prtGrps = hninfo.getPortgroup();
            if (prtGrps == null || prtGrps.length == 0) {
                return null;
            }
            for (int i = 0; i < prtGrps.length; ++i) {
                HostPortGroupPort[] hpgp = prtGrps[i].getPort();
                for (int j = 0; hpgp != null && j < hpgp.length; ++j) {
                    if (!hpgp[j].getType().equals("virtualMachine")) continue;
                    if (hpgp[j].getMac() == null || hpgp[j].getMac().equals(macAddr)) {
                        // empty if block
                    }
                    portGroup = prtGrps[i].getSpec() == null ? null : prtGrps[i].getSpec().getName();
                }
            }
        }
        catch (Exception e) {
            _logger.warn((Object)("Exception caught in getPortGroup(): " + macAddr + "," + e));
        }
        return portGroup;
    }

    private long[] getNodeWwns(com.vmware.vim25.mo.HostSystem host) {
        long[] result = null;
        try {
            int i;
            if (host == null || host.getConfig() == null || host.getConfig().getStorageDevice() == null) {
                return null;
            }
            HostHostBusAdapter[] apts = host.getConfig().getStorageDevice().getHostBusAdapter();
            if (apts == null || apts.length == 0) {
                _logger.debug((Object)"no hbas");
                return null;
            }
            ArrayList<Long> nwwns = new ArrayList<Long>();
            _logger.debug((Object)"Host HBA");
            _logger.debug((Object)"--------");
            for (i = 0; i < apts.length; ++i) {
                _logger.debug((Object)("\t\t key " + apts[i].getKey()));
                if (!(apts[i] instanceof HostFibreChannelHba)) continue;
                HostFibreChannelHba fcHba = (HostFibreChannelHba)apts[i];
                _logger.debug((Object)("\t\t nWwn " + fcHba.getNodeWorldWideName()));
                _logger.debug((Object)("\t\t pWwn " + fcHba.getPortWorldWideName()));
                nwwns.add(new Long(fcHba.getNodeWorldWideName()));
            }
            if (nwwns.size() == 0) {
                return null;
            }
            result = new long[nwwns.size()];
            for (i = 0; i < nwwns.size(); ++i) {
                result[i] = (Long)nwwns.get(i);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)("getNodeWwns for host '" + host.getName() + "' failed. " + e.getMessage()));
        }
        return result;
    }

    private long[] getPortWwns(com.vmware.vim25.mo.HostSystem host) {
        long[] result = null;
        try {
            int i;
            if (host == null || host.getConfig() == null || host.getConfig().getStorageDevice() == null) {
                return null;
            }
            HostHostBusAdapter[] apts = host.getConfig().getStorageDevice().getHostBusAdapter();
            if (apts == null || apts.length == 0) {
                _logger.debug((Object)"no hbas");
                return null;
            }
            ArrayList<Long> pwwns = new ArrayList<Long>();
            _logger.debug((Object)"Host HBA");
            _logger.debug((Object)"--------");
            for (i = 0; i < apts.length; ++i) {
                _logger.debug((Object)("\t\t key " + apts[i].getKey()));
                if (!(apts[i] instanceof HostFibreChannelHba)) continue;
                HostFibreChannelHba fcHba = (HostFibreChannelHba)apts[i];
                _logger.debug((Object)("\t\t nWwn " + fcHba.getNodeWorldWideName()));
                _logger.debug((Object)("\t\t pWwn " + fcHba.getPortWorldWideName()));
                pwwns.add(new Long(fcHba.getPortWorldWideName()));
            }
            if (pwwns.size() == 0) {
                return null;
            }
            result = new long[pwwns.size()];
            for (i = 0; i < pwwns.size(); ++i) {
                result[i] = (Long)pwwns.get(i);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)("getPortWwns for host '" + host.getName() + "' failed. " + e.getMessage()));
        }
        return result;
    }

    private List<String> getIscsciNames(com.vmware.vim25.mo.HostSystem host) {
        ArrayList<String> result = null;
        try {
            if (host == null || host.getConfig() == null || host.getConfig().getStorageDevice() == null) {
                return null;
            }
            HostHostBusAdapter[] apts = host.getConfig().getStorageDevice().getHostBusAdapter();
            if (apts == null || apts.length == 0) {
                _logger.debug((Object)"no hbas");
                return null;
            }
            result = new ArrayList<String>();
            for (int i = 0; i < apts.length; ++i) {
                if (!(apts[i] instanceof HostInternetScsiHba)) continue;
                HostInternetScsiHba hba = (HostInternetScsiHba)apts[i];
                String name = hba.getIScsiName();
                _logger.debug((Object)("iScsi: name='" + name + "'"));
                result.add(name);
            }
        }
        catch (Exception e) {
            _logger.warn((Object)("getIscsiNames for host '" + host.getName() + "' failed. " + e.getMessage()));
        }
        return result;
    }

    void printStorageDeviceInfo(HostStorageDeviceInfo hsdi, HostSystem hs) {
        _logger.debug((Object)"\nHost bus adapters");
        HostMultipathInfo hmi = hsdi.getMultipathInfo();
        String multipath = this.getMultiPathInfo(hmi);
        hs.setMultiPath(multipath);
        this.printScsiTopology(hsdi, hs);
    }

    void printHBAs(HostHostBusAdapter[] hbas) {
        for (int i = 0; hbas != null && i < hbas.length; ++i) {
            _logger.debug((Object)("Device:" + hbas[i].getDevice()));
            _logger.debug((Object)("Bus:" + hbas[i].getBus()));
            _logger.debug((Object)("Driver:" + hbas[i].getDriver()));
            _logger.debug((Object)("Key:" + hbas[i].getKey()));
            _logger.debug((Object)("Model:" + hbas[i].getModel()));
            _logger.debug((Object)("PCI:" + hbas[i].getPci()));
            _logger.debug((Object)("Status:" + hbas[i].getStatus()));
        }
    }

    void printScsiTopology(HostStorageDeviceInfo hsdi, HostSystem hs) {
        VCenterWorker vcWorker;
        ViManager vi = ViManager.getInstance();
        HostScsiTopology hst = hsdi.getScsiTopology();
        ScsiLun[] scsiluns = hsdi.getScsiLun();
        VCenterWorker vCenterWorker = vcWorker = this._vc.getWorker() == null ? null : this._vc.getWorker();
        if (vcWorker == null) {
            _logger.warn((Object)("vCenter worker is null for data center worker " + this));
            return;
        }
        Collection<NameKey> preDsPKs = vcWorker.getPreDsPKs();
        HostScsiTopologyInterface[] hstis = hst.getAdapter();
        for (int i = 0; hstis != null && i < hstis.length; ++i) {
            HostScsiTopologyTarget[] hstts = hstis[i].getTarget();
            for (int j = 0; hstts != null && j < hstts.length; ++j) {
                if (!(hstts[j].getTransport() instanceof HostFibreChannelTargetTransport)) continue;
                _logger.debug((Object)"\n");
                HostFibreChannelTargetTransport sanStorage = (HostFibreChannelTargetTransport)hstts[j].getTransport();
                HostScsiTopologyLun[] luns = hstts[j].getLun();
                for (int k = 0; luns != null && k < luns.length; ++k) {
                    String uuid = null;
                    String canonicalName = null;
                    for (int m = 0; scsiluns != null && m < scsiluns.length; ++m) {
                        if (scsiluns[m] == null || !scsiluns[m].getKey().equals(luns[k].getScsiLun())) continue;
                        uuid = scsiluns[m].getUuid();
                        canonicalName = scsiluns[m].getCanonicalName();
                    }
                    DataStoreImpl dStore = this._vc.createDataStore(sanStorage.getNodeWorldWideName(), sanStorage.getPortWorldWideName(), luns[k].getKey(), luns[k].getLun(), luns[k].getScsiLun(), uuid, canonicalName);
                    dStore.addHost(hs);
                    preDsPKs.remove(new NameKey(canonicalName));
                }
            }
        }
    }

    void printScsiLuns(ScsiLun[] sls) {
        for (int i = 0; sls != null && i < sls.length; ++i) {
            _logger.debug((Object)("UUID:" + sls[i].getUuid()));
            _logger.debug((Object)("CanonicalName:" + sls[i].getCanonicalName()));
            _logger.debug((Object)("LunType:" + sls[i].getLunType()));
            String[] states = sls[i].getOperationalState();
            for (int j = 0; states != null && j < states.length; ++j) {
                _logger.debug((Object)(states[j] + " "));
            }
        }
    }

    String getMultiPathInfo(HostMultipathInfo hmi) {
        HostMultipathInfoLogicalUnit[] lus = hmi.getLun();
        String lastPolicy = null;
        for (int i = 0; lus != null && i < lus.length; ++i) {
            HostMultipathInfoPath[] hmips = lus[i].getPath();
            for (int j = 0; hmips != null && j < hmips.length; ++j) {
                String policyStr;
                HostTargetTransport htt;
                String pathState = hmips[j].getPathState();
                if (pathState == null || pathState.equals("dead") || (htt = hmips[j].getTransport()) == null || !(htt instanceof HostFibreChannelTargetTransport)) continue;
                HostMultipathInfoLogicalUnitPolicy policy = lus[i].getPolicy();
                lastPolicy = policyStr = policy.getPolicy();
                return lastPolicy;
            }
        }
        return lastPolicy;
    }

    void printFileVolumeInfo(HostFileSystemVolumeInfo info) {
        String[] volTypes = info.getVolumeTypeList();
        for (int i = 0; volTypes != null && i < volTypes.length; ++i) {
            _logger.debug((Object)volTypes[i]);
        }
        _logger.debug((Object)"\nThe file system volumes mounted:");
        HostFileSystemMountInfo[] mis = info.getMountInfo();
        for (int i = 0; mis != null && i < mis.length; ++i) {
            HostMountInfo hmi = mis[i].getMountInfo();
            _logger.debug((Object)("\nAccessible:" + hmi.getAccessible()));
            _logger.debug((Object)("AccessMode:" + hmi.getAccessMode()));
            _logger.debug((Object)("Path:" + hmi.getPath()));
            HostFileSystemVolume hfsv = mis[i].getVolume();
            _logger.debug((Object)("Capacity:" + hfsv.getCapacity()));
            _logger.debug((Object)("Name:" + hfsv.getName()));
            _logger.debug((Object)("Type:" + hfsv.getType()));
        }
    }

    private void processVmFolder(Folder vmFolder) {
        try {
            ManagedEntity[] children;
            for (ManagedEntity me : children = vmFolder.getChildEntity()) {
                if (me instanceof VirtualMachine) {
                    VirtualMachine vm = (VirtualMachine)me;
                    VirtualMachineConfigSummary summary = vm.getSummary().getConfig();
                    continue;
                }
                if (!(me instanceof Folder)) continue;
                Folder subFolder = (Folder)me;
                this.processVmFolder(subFolder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveVm(VirtualMachine vm, int hostId) {
        _logger.debug((Object)("vm****" + vm.getName()));
        VirtualMachineConfigSummary summary = vm.getSummary().getConfig();
        long memorySize = summary.getMemorySizeMB().intValue();
        int cpuCount = summary.getNumCpu();
        String moRef = vm.getMOR() == null ? null : vm.getMOR().getVal();
        com.cisco.dcbu.vi.model.VirtualMachine machine = new com.cisco.dcbu.vi.model.VirtualMachine(vm.getName(), moRef, memorySize, cpuCount, "");
        machine.setHostId(hostId);
    }

    public void setDiscFlag(int flag) {
        this._discFlags |= flag;
    }

    public void resetDiscFlag(int flag) {
        this._discFlags &= ~flag;
    }

    public boolean isDiscFlagSet(int flag) {
        return (this._discFlags & flag) != 0;
    }

    public void setServiceInstance(ServiceInstance si) {
        this._si = si;
    }

    public ServiceInstance getServiceInstance() {
        return this._si;
    }

    private ObjectContent[] getHosts(ManagedObjectReference dcMoRef) throws InvalidProperty, RemoteException {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType("HostSystem");
        pSpec.setPathSet(new String[]{"name", "parent", "summary.hardware.memorySize", "summary.hardware.numCpuCores", "summary.hardware.cpuMhz", "summary.hardware.vendor", "summary.config.product.osType", "summary.hardware.model", "summary.hardware.uuid", "summary.config.product.fullName", "summary.config.product.version", "summary.runtime.powerState", "summary.runtime.connectionState"});
        SelectionSpec recurseFolders = new SelectionSpec();
        recurseFolders.setName("folder2childEntity");
        TraversalSpec computeResource2host = new TraversalSpec();
        computeResource2host.setType("ComputeResource");
        computeResource2host.setPath("host");
        TraversalSpec folder2childEntity = new TraversalSpec();
        folder2childEntity.setType("Folder");
        folder2childEntity.setPath("childEntity");
        folder2childEntity.setName(recurseFolders.getName());
        folder2childEntity.setSelectSet(new SelectionSpec[]{recurseFolders, computeResource2host});
        TraversalSpec dc2hostFolder = new TraversalSpec();
        dc2hostFolder.setType("Datacenter");
        dc2hostFolder.setPath("hostFolder");
        dc2hostFolder.setSelectSet(new SelectionSpec[]{folder2childEntity});
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(dcMoRef);
        oSpec.setSkip(Boolean.TRUE);
        oSpec.setSelectSet(new SelectionSpec[]{dc2hostFolder});
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        return this._si.getPropertyCollector().retrieveProperties(new PropertyFilterSpec[]{pfSpec});
    }

    private ObjectContent[] getVMs(ManagedObjectReference dcMoRef) throws InvalidProperty, RemoteException {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType("VirtualMachine");
        pSpec.setPathSet(new String[]{"name", "parent", "summary.config.memorySizeMB", "summary.config.numCpu", "summary.config.guestFullName", "summary.config.uuid", "guest.ipAddress", "summary.runtime.powerState"});
        SelectionSpec recurseFolders = new SelectionSpec();
        recurseFolders.setName("folder2childEntity");
        TraversalSpec folder2childEntity = new TraversalSpec();
        folder2childEntity.setType("Folder");
        folder2childEntity.setPath("childEntity");
        folder2childEntity.setName(recurseFolders.getName());
        folder2childEntity.setSelectSet(new SelectionSpec[]{recurseFolders});
        TraversalSpec dc2vmFolder = new TraversalSpec();
        dc2vmFolder.setType("Datacenter");
        dc2vmFolder.setPath("vmFolder");
        dc2vmFolder.setSelectSet(new SelectionSpec[]{folder2childEntity});
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(dcMoRef);
        oSpec.setSkip(Boolean.TRUE);
        oSpec.setSelectSet(new SelectionSpec[]{dc2vmFolder});
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        return this._si.getPropertyCollector().retrieveProperties(new PropertyFilterSpec[]{pfSpec});
    }

    private void printObjectContent(ObjectContent[] ocs, String title) {
        if (ocs != null) {
            _logger.info((Object)(title + "****Size****" + ocs.length));
            for (int i = 0; i < ocs.length; ++i) {
                ObjectContent oc = ocs[i];
                _logger.debug((Object)oc.getObj().getType());
                _logger.debug((Object)"  Property Name:Value");
                DynamicProperty[] dps = oc.getPropSet();
                if (dps == null) continue;
                for (int j = 0; j < dps.length; ++j) {
                    DynamicProperty dp = dps[j];
                    _logger.info((Object)("  " + dp.getName() + ": " + dp.getVal()));
                }
            }
        }
    }

    private Object[] getProperties(ManagedObjectReference moRef, String[] properties) throws RuntimeFault, RemoteException {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(moRef.getType());
        pSpec.setPathSet(properties);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(moRef);
        PropertyFilterSpec pfSpec = new PropertyFilterSpec();
        pfSpec.setPropSet(new PropertySpec[]{pSpec});
        pfSpec.setObjectSet(new ObjectSpec[]{oSpec});
        ObjectContent[] ocs = this._si.getPropertyCollector().retrieveProperties(new PropertyFilterSpec[]{pfSpec});
        Object[] ret = new Object[properties.length];
        if (ocs != null) {
            for (int i = 0; i < ocs.length; ++i) {
                ObjectContent oc = ocs[i];
                DynamicProperty[] dps = oc.getPropSet();
                if (dps == null) continue;
                for (int j = 0; j < dps.length; ++j) {
                    DynamicProperty dp = dps[j];
                    for (int p = 0; p < ret.length; ++p) {
                        if (!properties[p].equals(dp.getName())) continue;
                        ret[p] = dp.getVal();
                    }
                }
            }
        }
        return ret;
    }
}

