/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper;

import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.GraphComponentOwner;
import com.cisco.nm.esper.GraphScrollPaneLayout;
import com.cisco.nm.esper.JGraphCanvas;
import com.cisco.nm.esper.shape.FixedBounds;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JGraphScrollPane
extends JPanel
implements AdjustmentListener,
GraphComponentOwner {
    private JScrollBar _vScroll;
    private JScrollBar _hScroll;
    private GraphComponent _canvas;
    private boolean userScroll;

    public JGraphScrollPane() {
        this.setLayout(new GraphScrollPaneLayout(this));
        this.createGUI();
        this.setMinimumSize(new Dimension(100, 100));
    }

    protected void createGUI() {
        this.setHorizontalScrollBar(new JScrollBar(0));
        this.setVerticalScrollBar(new JScrollBar(1));
        this.setGraphComponent(new JGraphCanvas());
    }

    protected void setVerticalScrollBar(JScrollBar jScrollBar) {
        if (this._vScroll != null) {
            this.remove(this._vScroll);
            this._vScroll.removeAdjustmentListener(this);
        }
        this._vScroll = jScrollBar;
        if (this._vScroll != null) {
            this._vScroll.setOrientation(1);
            this.add("vs", this._vScroll);
            this._vScroll.addAdjustmentListener(this);
        }
    }

    protected void setHorizontalScrollBar(JScrollBar jScrollBar) {
        if (this._hScroll != null) {
            this._hScroll.removeAdjustmentListener(this);
            this.remove(this._hScroll);
        }
        this._hScroll = jScrollBar;
        if (this._hScroll != null) {
            this._hScroll.setOrientation(0);
            this.add("hs", this._hScroll);
            this._hScroll.addAdjustmentListener(this);
        }
    }

    public void setGraphComponent(GraphComponent graphComponent) {
        if (this._canvas != null) {
            this.remove((Component)((Object)this._canvas));
        }
        this._canvas = graphComponent;
        if (this._canvas != null) {
            this.add("vw", (Component)((Object)this._canvas));
        }
    }

    public GraphComponent getGraphComponent() {
        return this._canvas;
    }

    protected JScrollBar getVerticalScrollBar() {
        return this._vScroll;
    }

    protected JScrollBar getHorizontalScrollBar() {
        return this._hScroll;
    }

    public void updateScrollbars() {
        if (this.getGraphComponent() != null) {
            double d = this.getGraphComponent().getTransform().getScaleX();
            double d2 = this.getGraphComponent().getTransform().getScaleY();
            FixedBounds fixedBounds = this.getGraphComponent().getUniverseBounds();
            int n = (int)Math.round(d * fixedBounds.getLeft());
            int n2 = (int)Math.round(d * fixedBounds.getRight());
            int n3 = (int)Math.round(d2 * fixedBounds.getTop());
            int n4 = (int)Math.round(d2 * fixedBounds.getBottom());
            FixedBounds fixedBounds2 = this.getGraphComponent().getViewBounds();
            int n5 = (int)Math.round(d * fixedBounds2.getLeft());
            int n6 = (int)Math.round(d * fixedBounds2.getRight());
            int n7 = (int)Math.round(d2 * fixedBounds2.getTop());
            int n8 = (int)Math.round(d2 * fixedBounds2.getBottom());
            int n9 = n6 - n5;
            int n10 = n8 - n7;
            this.setAdjustmentEventEnabled(false);
            this.getHorizontalScrollBar().getModel().setRangeProperties(n5, n9, n, n2, false);
            this.getVerticalScrollBar().getModel().setRangeProperties(n7, n10, n3, n4, false);
            this.getHorizontalScrollBar().setBlockIncrement(n9 / 4);
            this.getHorizontalScrollBar().setUnitIncrement(n9 / 25);
            this.getVerticalScrollBar().setBlockIncrement(n10 / 4);
            this.getVerticalScrollBar().setUnitIncrement(n10 / 25);
            this.setAdjustmentEventEnabled(true);
        }
    }

    public boolean isAdjustmentEventEnabled() {
        return this.userScroll;
    }

    public void setAdjustmentEventEnabled(boolean bl) {
        this.userScroll = bl;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.isAdjustmentEventEnabled() && this.getGraphComponent() != null) {
            if (adjustmentEvent.getAdjustable().getOrientation() == 0) {
                this.getGraphComponent().scrollHorizontallyTo(adjustmentEvent.getValue(), true);
            } else {
                this.getGraphComponent().scrollVerticallyTo(adjustmentEvent.getValue(), true);
            }
        }
    }

    public void viewChanged(GraphComponent graphComponent) {
        this.updateScrollbars();
    }

    public boolean isFocusTraversable() {
        return true;
    }
}

