/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper;

import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.command.InsertEdgeCommand;
import com.cisco.nm.esper.command.InsertGraphCommand;
import com.cisco.nm.esper.command.InsertNodeCommand;
import com.cisco.nm.esper.command.RemoveEdgeCommand;
import com.cisco.nm.esper.command.RemoveGraphCommand;
import com.cisco.nm.esper.command.RemoveNodeCommand;
import com.cisco.nm.esper.lib.OwnedArrayList;
import com.cisco.nm.esper.lib.OwnedList;
import com.cisco.nm.esper.model.BaseObject;
import com.cisco.nm.esper.model.Bend;
import com.cisco.nm.esper.model.CopyHelper;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.GraphObject;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.io.GraphSelection;
import com.cisco.nm.lib.command.GroupCommand;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SelectionWorker {
    private Clipboard clipboard;
    private GraphComponent comp;
    private boolean recursive;

    public SelectionWorker() {
        this.setRecursive(true);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public GraphComponent getGraphComponent() {
        return this.comp;
    }

    public void setGraphComponent(GraphComponent graphComponent) {
        this.comp = graphComponent;
    }

    public OwnedList bends(Graph graph) {
        if (!this.isRecursive() || graph.graphs().isEmpty()) {
            return graph.getSelection().bends();
        }
        OwnedArrayList ownedArrayList = new OwnedArrayList(Math.max(graph.getSelection().bends().size(), 20));
        return this.bends(graph, ownedArrayList);
    }

    public OwnedList edgeLabels(Graph graph) {
        if (!this.isRecursive() || graph.graphs().isEmpty()) {
            return graph.getSelection().edgeLabels();
        }
        OwnedArrayList ownedArrayList = new OwnedArrayList(Math.max(graph.getSelection().edgeLabels().size(), 20));
        return this.edgeLabels(graph, ownedArrayList);
    }

    public OwnedList graphs(Graph graph) {
        if (!this.isRecursive() || graph.graphs().isEmpty()) {
            return graph.getSelection().graphs();
        }
        OwnedArrayList ownedArrayList = new OwnedArrayList(Math.max(graph.getSelection().graphs().size(), 20));
        return this.graphs(graph, ownedArrayList);
    }

    public OwnedList nodes(Graph graph) {
        if (!this.isRecursive() || graph.graphs().isEmpty()) {
            return graph.getSelection().nodes();
        }
        OwnedArrayList ownedArrayList = new OwnedArrayList(Math.max(graph.getSelection().nodes().size(), 20));
        return this.nodes(graph, ownedArrayList);
    }

    public OwnedList nodeLabels(Graph graph) {
        if (!this.isRecursive() || graph.graphs().isEmpty()) {
            return graph.getSelection().nodeLabels();
        }
        OwnedArrayList ownedArrayList = new OwnedArrayList(Math.max(graph.getSelection().nodeLabels().size(), 20));
        return this.nodeLabels(graph, ownedArrayList);
    }

    private OwnedList bends(Graph graph, OwnedArrayList ownedArrayList) {
        Iterator iterator = graph.getSelection().bends().iterator();
        while (iterator.hasNext()) {
            ownedArrayList.add(iterator.next());
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph2.isExpanded()) continue;
            this.bends(graph2, ownedArrayList);
        }
        return ownedArrayList;
    }

    private OwnedList edgeLabels(Graph graph, OwnedArrayList ownedArrayList) {
        Iterator iterator = graph.getSelection().edgeLabels().iterator();
        while (iterator.hasNext()) {
            ownedArrayList.add(iterator.next());
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph2.isExpanded()) continue;
            this.edgeLabels(graph2, ownedArrayList);
        }
        return ownedArrayList;
    }

    private OwnedList graphs(Graph graph, OwnedArrayList ownedArrayList) {
        Iterator iterator = graph.getSelection().graphs().iterator();
        while (iterator.hasNext()) {
            ownedArrayList.add(iterator.next());
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph2.isExpanded()) continue;
            this.graphs(graph2, ownedArrayList);
        }
        return ownedArrayList;
    }

    private OwnedList nodes(Graph graph, OwnedArrayList ownedArrayList) {
        Iterator iterator = graph.getSelection().nodes().iterator();
        while (iterator.hasNext()) {
            ownedArrayList.add(iterator.next());
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph2.isExpanded()) continue;
            this.nodes(graph2, ownedArrayList);
        }
        return ownedArrayList;
    }

    private OwnedList nodeLabels(Graph graph, OwnedArrayList ownedArrayList) {
        Iterator iterator = graph.getSelection().nodeLabels().iterator();
        while (iterator.hasNext()) {
            ownedArrayList.add(iterator.next());
        }
        iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            Graph graph2 = (Graph)iterator.next();
            if (!graph2.isExpanded()) continue;
            this.nodeLabels(graph2, ownedArrayList);
        }
        return ownedArrayList;
    }

    public boolean replaceSelection(Graph graph, List list) {
        boolean bl = this.removeAllFromSelected(graph);
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                GraphMember graphMember = (GraphMember)iterator.next();
                if (graphMember.isSelected()) continue;
                graphMember.setSelected(true);
                bl = true;
            }
        }
        return bl;
    }

    public boolean toggleSelection(Graph graph, Rectangle rectangle) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Transform transform = this.getGraphComponent().getTransform();
        Iterator iterator = graph.graphs().iterator();
        while (iterator.hasNext()) {
            object4 = (Graph)iterator.next();
            if (!((BaseObject)object4).isVisible()) continue;
            if (((BaseObject)object4).intersects(rectangle, transform)) {
                ((BaseObject)object4).setSelected(!((BaseObject)object4).isSelected());
            }
            if (!this.isRecursive()) continue;
            this.toggleSelection((Graph)object4, rectangle);
        }
        object4 = graph.nodes().iterator();
        while (object4.hasNext()) {
            object3 = (Node)object4.next();
            if (!((BaseObject)object3).isVisible() || !((BaseObject)object3).intersects(rectangle, transform)) continue;
            ((BaseObject)object3).setSelected(!((BaseObject)object3).isSelected());
            object2 = ((Node)object3).labels().iterator();
            while (object2.hasNext()) {
                object = (NodeLabel)object2.next();
                if (!((BaseObject)object).isVisible() || !((BaseObject)object).intersects(rectangle, transform)) continue;
                ((BaseObject)object).setSelected(!((BaseObject)object).isSelected());
            }
        }
        object3 = graph.edges().iterator();
        while (object3.hasNext()) {
            BaseObject baseObject;
            object2 = (Edge)object3.next();
            if (!((BaseObject)object2).isVisible()) continue;
            if (((BaseObject)object2).intersects(rectangle, transform)) {
                ((BaseObject)object2).setSelected(!((BaseObject)object2).isSelected());
                object = ((Edge)object2).bends().iterator();
                while (object.hasNext()) {
                    baseObject = (Bend)object.next();
                    if (!baseObject.isVisible() || !baseObject.intersects(rectangle, transform)) continue;
                    baseObject.setSelected(!baseObject.isSelected());
                }
            }
            object = ((Edge)object2).labels().iterator();
            while (object.hasNext()) {
                baseObject = (EdgeLabel)object.next();
                if (!baseObject.isVisible() || !baseObject.intersects(rectangle, transform)) continue;
                baseObject.setSelected(!baseObject.isSelected());
            }
        }
        return true;
    }

    public boolean addToSelection(Graph graph, Rectangle rectangle) {
        BaseObject baseObject;
        Iterator iterator;
        Object object;
        Transform transform = this.getGraphComponent().getTransform();
        Iterator iterator2 = graph.graphs().iterator();
        while (iterator2.hasNext()) {
            object = (Graph)iterator2.next();
            if (!((BaseObject)object).isVisible()) continue;
            if (((BaseObject)object).intersects(rectangle, transform)) {
                ((BaseObject)object).setSelected(true);
            }
            if (!this.isRecursive()) continue;
            this.toggleSelection((Graph)object, rectangle);
        }
        object = graph.nodes().iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            if (!node.isVisible() || !node.intersects(rectangle, transform)) continue;
            node.setSelected(true);
            iterator = node.labels().iterator();
            while (iterator.hasNext()) {
                baseObject = (NodeLabel)iterator.next();
                if (!baseObject.isVisible() || !baseObject.intersects(rectangle, transform)) continue;
                baseObject.setSelected(true);
            }
        }
        for (int i = 1; i <= 2; ++i) {
            iterator = graph.edges(i).iterator();
            while (iterator.hasNext()) {
                BaseObject baseObject2;
                Iterator iterator3;
                baseObject = (Edge)iterator.next();
                if (!baseObject.isVisible()) continue;
                if (baseObject.intersects(rectangle, transform)) {
                    baseObject.setSelected(true);
                    iterator3 = ((Edge)baseObject).bends().iterator();
                    while (iterator3.hasNext()) {
                        baseObject2 = (Bend)iterator3.next();
                        if (!baseObject2.isVisible() || !baseObject2.intersects(rectangle, transform)) continue;
                        baseObject2.setSelected(true);
                    }
                }
                iterator3 = ((Edge)baseObject).labels().iterator();
                while (iterator3.hasNext()) {
                    baseObject2 = (EdgeLabel)iterator3.next();
                    if (!baseObject2.isVisible() || !baseObject2.intersects(rectangle, transform)) continue;
                    baseObject2.setSelected(true);
                }
            }
        }
        return true;
    }

    public boolean addAllToSelected(Graph graph) {
        return this.addToSelected(graph, 63);
    }

    public boolean addGraphsToSelected(Graph graph) {
        return this.addToSelected(graph, 4);
    }

    public boolean addNodesToSelected(Graph graph) {
        return this.addToSelected(graph, 1);
    }

    public boolean addEdgesToSelected(Graph graph) {
        return this.addToSelected(graph, 2);
    }

    public boolean addBendsToSelected(Graph graph) {
        return this.addToSelected(graph, 32);
    }

    public boolean addEdgeLabelsToSelected(Graph graph) {
        return this.addToSelected(graph, 16);
    }

    public boolean addNodeLabelsToSelected(Graph graph) {
        return this.addToSelected(graph, 8);
    }

    protected boolean addToSelected(Graph graph, int n) {
        boolean bl = graph.getSelection().select(n);
        if (this.isRecursive()) {
            Iterator iterator = graph.graphs().iterator();
            while (iterator.hasNext()) {
                this.addToSelected((Graph)iterator.next(), n);
            }
        }
        return bl;
    }

    public boolean removeAllFromSelected(Graph graph) {
        boolean bl = !graph.getSelection().isEmpty();
        graph.getSelection().clear();
        if (this.isRecursive()) {
            Iterator iterator = graph.graphs().iterator();
            while (iterator.hasNext()) {
                bl = this.removeAllFromSelected((Graph)iterator.next()) | bl;
            }
        }
        return bl;
    }

    public boolean copy(Graph graph) {
        if (this.isCopyPossible(graph)) {
            Graph graph2 = CopyHelper.INSTANCE.newCopyGraph(graph);
            GraphSelection graphSelection = new GraphSelection(graph2);
            this.getClipboard().setContents(graphSelection, graphSelection);
        }
        return false;
    }

    public boolean cut(Graph graph) {
        if (!this.isCutPossible(graph)) {
            return false;
        }
        if (graph.getSelection().nodes().size() > 0 || graph.getSelection().edges().size() > 0) {
            this.copy(graph);
            GroupCommand groupCommand = new GroupCommand();
            Iterator iterator = graph.getSelection().nodes().iterator();
            while (iterator.hasNext()) {
                groupCommand.insert(new RemoveNodeCommand((Node)iterator.next()));
            }
            Iterator iterator2 = graph.getSelection().edges().iterator();
            while (iterator2.hasNext()) {
                groupCommand.insert(new RemoveEdgeCommand((Edge)iterator2.next()));
            }
            Iterator iterator3 = graph.getSelection().graphs().iterator();
            while (iterator3.hasNext()) {
                groupCommand.insert(new RemoveGraphCommand((Graph)iterator3.next()));
            }
            this.getGraphComponent().getCommandDispatcher().dispatch(groupCommand);
        }
        return true;
    }

    public boolean paste(Graph graph) throws IOException {
        try {
            int n;
            Object object;
            GraphObject graphObject;
            if (!this.isPastePossible(graph)) {
                boolean bl = false;
                return bl;
            }
            Transferable transferable = this.getClipboard().getContents(this);
            if (!transferable.isDataFlavorSupported(GraphSelection.GRAPH_FLAVOR)) {
                boolean bl = false;
                return bl;
            }
            Graph graph2 = (Graph)transferable.getTransferData(GraphSelection.GRAPH_FLAVOR);
            Graph graph3 = CopyHelper.INSTANCE.newPasteGraph(graph2, 10, 10);
            GroupCommand groupCommand = new GroupCommand();
            ArrayList<Object> arrayList = new ArrayList<Object>(graph3.nodes().size() + graph3.edges().size() + graph3.graphs().size() + graph3.getNodeLabelCount() + graph3.getEdgeLabelCount() + graph3.getBendCount());
            int n2 = graph3.nodes().size() - 1;
            while (n2 >= 0) {
                graphObject = (Node)graph3.nodes().get(n2);
                graph3.remove((Node)graphObject);
                groupCommand.insert(new InsertNodeCommand(graph, (Node)graphObject));
                arrayList.add(graphObject);
                n2 = graph3.nodes().size() - 1;
                object = ((Node)graphObject).labels().iterator();
                while (object.hasNext()) {
                    arrayList.add(object.next());
                }
            }
            n2 = graph3.graphs().size() - 1;
            while (n2 >= 0) {
                graphObject = (Graph)graph3.graphs().get(n2);
                graph3.remove((Graph)graphObject);
                groupCommand.insert(new InsertGraphCommand(graph, (Graph)graphObject));
                this.addNestedSelection((Graph)graphObject, arrayList);
                n2 = graph3.graphs().size() - 1;
            }
            for (n = 0; n <= 2; ++n) {
                n2 = graph3.edges(n).size() - 1;
                while (n2 >= 0) {
                    object = (Edge)graph3.edges(n).get(n2);
                    graph3.remove((Edge)object);
                    groupCommand.insert(new InsertEdgeCommand(graph, (Edge)object));
                    n2 = graph3.edges(n).size() - 1;
                    arrayList.add(object);
                    Iterator iterator = ((Edge)object).bends().iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                    iterator = ((Edge)object).labels().iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                }
            }
            this.getGraphComponent().getCommandDispatcher().dispatch(groupCommand);
            this.replaceSelection(graph, arrayList);
            n = 1;
            return n != 0;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            throw new IOException("DataFlavor error: ".concat(String.valueOf(String.valueOf(unsupportedFlavorException.getMessage()))));
        }
    }

    private void addNestedSelection(Graph graph, ArrayList arrayList) {
        Iterator iterator;
        GraphObject graphObject;
        arrayList.add(graph);
        Iterator iterator2 = graph.graphs().iterator();
        while (iterator2.hasNext()) {
            this.addNestedSelection((Graph)iterator2.next(), arrayList);
        }
        iterator2 = graph.nodes().iterator();
        while (iterator2.hasNext()) {
            graphObject = (Node)iterator2.next();
            arrayList.add(graphObject);
            iterator = ((Node)graphObject).labels().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        iterator2 = graph.edges().iterator();
        while (iterator2.hasNext()) {
            graphObject = (Edge)iterator2.next();
            arrayList.add(graphObject);
            iterator = ((Edge)graphObject).labels().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
    }

    public void setClipboard(Clipboard clipboard) {
        if (this.clipboard == null && clipboard != null || this.clipboard != null && !this.clipboard.equals(clipboard)) {
            this.clipboard = clipboard;
        }
    }

    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = this.getGraphComponent().asContainer().getToolkit().getSystemClipboard();
        }
        return this.clipboard;
    }

    public boolean isPastePossible(Graph graph) {
        Transferable transferable;
        return graph != null && this.clipboard != null && (transferable = this.clipboard.getContents(this)) != null && transferable.isDataFlavorSupported(GraphSelection.GRAPH_FLAVOR);
    }

    public boolean isCopyPossible(Graph graph) {
        if (graph == null || graph == null) {
            return false;
        }
        return !graph.getSelection().isEmpty();
    }

    public boolean isCutPossible(Graph graph) {
        if (graph == null || graph == null) {
            return false;
        }
        return !graph.getSelection().isEmpty();
    }
}

