/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.action;

import com.cisco.nm.esper.GraphPrintJobAttributes;
import com.cisco.nm.esper.GraphPrinter;
import com.cisco.nm.esper.action.GraphComponentAction;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.shape.Bounds;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class PrintAction
extends GraphComponentAction {
    public static final String PRINT_PAGE_ACTION = "printPage";
    public static final String PRINT_ALL_ACTION = "printAll";
    private GraphPrintJobAttributes atts = new GraphPrintJobAttributes();

    public boolean isAbleToHandle(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return false;
        }
        String string = actionEvent.getActionCommand();
        return PRINT_PAGE_ACTION.equals(string) || PRINT_ALL_ACTION.equals(string);
    }

    protected void execute(ActionEvent actionEvent) {
        Graph graph = this.getGraphComponent().getGraph();
        if (graph == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (printerJob.printDialog()) {
                Paper paper = new Paper();
                paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
                PageFormat pageFormat = new PageFormat();
                pageFormat.setPaper(paper);
                printerJob.setJobName(this.getJobName(graph));
                String string = actionEvent.getActionCommand();
                if (PRINT_ALL_ACTION.equals(string)) {
                    printerJob.setPrintable(new GraphPrinter(graph, this.atts), pageFormat);
                } else if (PRINT_PAGE_ACTION.equals(string)) {
                    Bounds bounds = this.getGraphComponent().getTransform().boundsToWorld(0, 0, this.getGraphComponent().getWidth(), this.getGraphComponent().getHeight());
                    printerJob.setPrintable(new GraphPrinter(graph, bounds, this.atts), pageFormat);
                } else {
                    this.cannotHandle(actionEvent);
                }
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    this.getExceptionListener().exceptionThrown(printerException);
                }
            }
        }
    }

    protected String getJobName(Graph graph) {
        if (graph == null) {
            return "Null Graph";
        }
        String string = graph.getText() != null ? graph.getText() : (graph.getResource("source") != null ? ((String)graph.getResource("source")).replace('\\', '/') : "Graph ".concat(String.valueOf(String.valueOf(graph.hashCode()))));
        return string;
    }

    public GraphPrintJobAttributes getGraphPrintJobAttributes() {
        return this.atts;
    }

    public void setGraphPrintJobAttributes(GraphPrintJobAttributes graphPrintJobAttributes) {
        this.atts = graphPrintJobAttributes;
    }

    static {
        PRINT_PAGE_ACTION = PRINT_PAGE_ACTION;
        PRINT_ALL_ACTION = PRINT_ALL_ACTION;
    }
}

