/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.esper.command;

import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.Node;
import com.cisco.nm.lib.command.Command;
import java.util.ArrayList;
import java.util.Iterator;

public class RemoveNodeCommand
extends Command {
    private Node node;
    private Graph graph;
    private ArrayList edges;

    public RemoveNodeCommand(Node node) {
        if (node == null || !node.isOwned()) {
            throw new IllegalArgumentException("null or not owned node");
        }
        this.node = node;
        this.graph = node.getOwner();
    }

    protected void onDo() throws Exception {
        if (this.graph != null) {
            this.graph.remove(this.node);
        }
    }

    protected void onUndo() throws Exception {
        if (this.getGraph() != null) {
            this.getGraph().insert(this.getNode());
        }
    }

    protected void doCleanup() {
        Edge edge;
        Iterator iterator = this.node.inedges(0);
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            if (edge.isOwned()) {
                edge.getOwner().remove(edge);
            }
            edge.detach();
        }
        iterator = this.node.outedges(0);
        while (iterator.hasNext()) {
            edge = (Edge)iterator.next();
            if (edge.isOwned()) {
                edge.getOwner().remove(edge);
            }
            edge.detach();
        }
        this.node.detach();
        this.node = null;
        this.graph = null;
    }

    public Node getNode() {
        return this.node;
    }

    public Graph getGraph() {
        return this.graph;
    }
}

